/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.JsonLdToRdf;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfDatasetSupplier;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import jakarta.json.JsonArray;
import java.net.URI;

public final class ToRdfProcessor {
    private ToRdfProcessor() {
    }

    @Deprecated
    public static final RdfDataset toRdf(URI input, JsonLdOptions options) throws JsonLdError {
        RdfDatasetSupplier consumer = new RdfDatasetSupplier();
        ToRdfProcessor.toRdf((RdfQuadConsumer)consumer, input, options);
        return consumer.get();
    }

    @Deprecated
    public static final RdfDataset toRdf(Document input, JsonLdOptions options) throws JsonLdError {
        RdfDatasetSupplier consumer = new RdfDatasetSupplier();
        ToRdfProcessor.toRdf((RdfQuadConsumer)consumer, input, options);
        return consumer.get();
    }

    public static final void toRdf(RdfQuadConsumer consumer, URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(input) + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        ToRdfProcessor.toRdf(consumer, remoteDocument, options);
    }

    public static final void toRdf(RdfQuadConsumer consumer, Document input, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setProcessingMode(options.getProcessingMode());
        expansionOptions.setBase(options.getBase());
        expansionOptions.setExpandContext(options.getExpandContext());
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        ToRdfProcessor.toRdf(consumer, expandedInput, options);
    }

    public static final void toRdf(RdfQuadConsumer consumer, JsonArray expandedInput, JsonLdOptions options) throws JsonLdError {
        JsonLdToRdf.with(NodeMapBuilder.with(expandedInput, new NodeMap()).build()).produceGeneralizedRdf(options.isProduceGeneralizedRdf()).rdfDirection(options.getRdfDirection()).uriValidation(options.getUriValidation()).provide(consumer);
    }
}

