/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class RdfDatasetSupplier
implements RdfQuadConsumer,
Supplier<RdfDataset> {
    protected final Map<String, RdfResource> resources;
    protected final RdfDataset dataset;

    public RdfDatasetSupplier() {
        this(Rdf.createDataset(), new HashMap<String, RdfResource>());
    }

    public RdfDatasetSupplier(RdfDataset dataset) {
        this(dataset, new HashMap<String, RdfResource>());
    }

    public RdfDatasetSupplier(RdfDataset dataset, Map<String, RdfResource> resources) {
        this.dataset = dataset;
        this.resources = resources;
    }

    @Override
    public RdfDataset get() {
        return this.dataset;
    }

    protected void quad(RdfResource subject, RdfResource predicate, RdfValue value, RdfResource graph) {
        this.dataset.add(Rdf.createNQuad(subject, predicate, value, graph));
    }

    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
        RdfValue objectValue = language != null || direction != null ? Rdf.createLangString(object, language, direction) : (datatype != null ? Rdf.createTypedString(object, datatype) : this.getResource(object));
        this.quad(this.getResource(subject), this.getResource(predicate), objectValue, this.getResource(graph));
        return this;
    }

    protected final RdfResource getResource(String name) {
        return name != null ? this.resources.computeIfAbsent(name, arg0 -> name.startsWith("_:") ? Rdf.createBlankNode(name) : Rdf.createIRI(name)) : null;
    }
}

