/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

class PercentCodec {
    private static final Chars RFC3986_GEN_DELIMS_CHARS = new Chars(){
        {
            this.add(':', '/', '?', '#', '[', ']', '@');
        }
    };
    private static final Chars RFC3986_SUB_DELIMS_CHARS = new Chars(){
        {
            this.add('!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=');
        }
    };
    private static final Chars RFC3986_UNRESERVED_CHARS = new Chars(){
        {
            this.addRange('a', 'z');
            this.addRange('A', 'Z');
            this.addRange('0', '9');
            this.add('-', '.', '_', '~');
        }
    };
    private static final Chars RFC3986_PATH_NO_COLON_CHARS = new Chars(){
        {
            this.add(RFC3986_UNRESERVED_CHARS);
            this.add(RFC3986_SUB_DELIMS_CHARS);
            this.add('@');
        }
    };
    private static final Chars RFC3986_PATH_CHARS = new Chars(){
        {
            this.add(RFC3986_PATH_NO_COLON_CHARS);
            this.add(':');
        }
    };
    private static final Chars RFC3986_URIC_CHARS = new Chars(){
        {
            this.add(RFC3986_SUB_DELIMS_CHARS);
            this.add(RFC3986_UNRESERVED_CHARS);
        }
    };
    private static final Chars RFC5987_UNRESERVED_CHARS = new Chars(){
        {
            this.addRange('a', 'z');
            this.addRange('A', 'Z');
            this.addRange('0', '9');
            this.add('!', '#', '$', '&', '+', '-', '.', '^', '_', '`', '|', '~');
        }
    };
    private static final int RADIX = 16;
    public static final PercentCodec RFC3986_UNRESERVED = new PercentCodec(RFC3986_UNRESERVED_CHARS);
    public static final PercentCodec RFC3986_PATH = new PercentCodec(RFC3986_PATH_CHARS);
    public static final PercentCodec RFC5987_UNRESERVED = new PercentCodec(RFC5987_UNRESERVED_CHARS);
    private final Chars unreserved;

    private static void encode(StringBuilder buf, CharSequence content, Charset charset, Chars safeChars, boolean blankAsPlus) {
        if (content == null) {
            return;
        }
        CharBuffer cb = CharBuffer.wrap(content);
        ByteBuffer bb = (charset != null ? charset : StandardCharsets.UTF_8).encode(cb);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safeChars.contains(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append("+");
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
    }

    private static String decode(CharSequence content, Charset charset, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return (charset != null ? charset : StandardCharsets.UTF_8).decode(bb).toString();
    }

    private PercentCodec(Chars unreserved) {
        this.unreserved = unreserved;
    }

    public void encode(StringBuilder buf, CharSequence content) {
        PercentCodec.encode(buf, content, StandardCharsets.UTF_8, this.unreserved, false);
    }

    public String encode(CharSequence content) {
        if (content == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        PercentCodec.encode(buf, content, StandardCharsets.UTF_8, this.unreserved, false);
        return buf.toString();
    }

    public String decode(CharSequence content) {
        return PercentCodec.decode(content, StandardCharsets.UTF_8, false);
    }

    private static class Chars {
        private final BitSet set = new BitSet(256);

        private Chars() {
        }

        public void add(char ... chars) {
            for (char c : chars) {
                this.set.set(c);
            }
        }

        public void addRange(char start, char end) {
            this.set.set((int)start, end + '\u0001');
        }

        public void add(Chars set) {
            this.set.or(set.set);
        }

        public boolean contains(int c) {
            return this.set.get(c);
        }
    }
}

