/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.tests;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.james.metrics.api.TimeMetric;

public class RecordingTimeMetric
implements TimeMetric {
    private final String name;
    private final Stopwatch stopwatch = Stopwatch.createStarted();
    private final Consumer<Duration> publishCallback;

    RecordingTimeMetric(String name, Consumer<Duration> publishCallback) {
        this.name = name;
        this.publishCallback = publishCallback;
    }

    public String name() {
        return this.name;
    }

    public TimeMetric.ExecutionResult stopAndPublish() {
        Duration elapsed = Duration.ofNanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.publishCallback.accept(elapsed);
        return new DefaultExecutionResult(elapsed);
    }

    public void record(Duration duration) {
        this.publishCallback.accept(duration);
    }

    static class DefaultExecutionResult
    implements TimeMetric.ExecutionResult {
        private final Duration elasped;

        DefaultExecutionResult(Duration elasped) {
            this.elasped = elasped;
        }

        public Duration elasped() {
            return this.elasped;
        }

        public TimeMetric.ExecutionResult logWhenExceedP99(Duration thresholdInNanoSeconds) {
            return this;
        }
    }
}

