/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TimeZoneDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=8912");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=8913");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=8917");
    private final Short offset;
    private final Boolean daylightSavingInOffset;

    public TimeZoneDataType(Short offset, Boolean daylightSavingInOffset) {
        this.offset = offset;
        this.daylightSavingInOffset = daylightSavingInOffset;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Short getOffset() {
        return this.offset;
    }

    public Boolean getDaylightSavingInOffset() {
        return this.daylightSavingInOffset;
    }

    protected TimeZoneDataType(TimeZoneDataTypeBuilder<?, ?> b) {
        super(b);
        this.offset = ((TimeZoneDataTypeBuilder)b).offset;
        this.daylightSavingInOffset = ((TimeZoneDataTypeBuilder)b).daylightSavingInOffset;
    }

    public static TimeZoneDataTypeBuilder<?, ?> builder() {
        return new TimeZoneDataTypeBuilderImpl();
    }

    public TimeZoneDataTypeBuilder<?, ?> toBuilder() {
        return new TimeZoneDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeZoneDataType)) {
            return false;
        }
        TimeZoneDataType other = (TimeZoneDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Short this$offset = this.getOffset();
        Short other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Boolean this$daylightSavingInOffset = this.getDaylightSavingInOffset();
        Boolean other$daylightSavingInOffset = other.getDaylightSavingInOffset();
        return !(this$daylightSavingInOffset == null ? other$daylightSavingInOffset != null : !((Object)this$daylightSavingInOffset).equals(other$daylightSavingInOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeZoneDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Short $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Boolean $daylightSavingInOffset = this.getDaylightSavingInOffset();
        result = result * 59 + ($daylightSavingInOffset == null ? 43 : ((Object)$daylightSavingInOffset).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TimeZoneDataType(offset=" + this.getOffset() + ", daylightSavingInOffset=" + this.getDaylightSavingInOffset() + ")";
    }

    private static final class TimeZoneDataTypeBuilderImpl
    extends TimeZoneDataTypeBuilder<TimeZoneDataType, TimeZoneDataTypeBuilderImpl> {
        private TimeZoneDataTypeBuilderImpl() {
        }

        @Override
        protected TimeZoneDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public TimeZoneDataType build() {
            return new TimeZoneDataType(this);
        }
    }

    public static abstract class TimeZoneDataTypeBuilder<C extends TimeZoneDataType, B extends TimeZoneDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Short offset;
        private Boolean daylightSavingInOffset;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TimeZoneDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TimeZoneDataType instance, TimeZoneDataTypeBuilder<?, ?> b) {
            b.offset(instance.offset);
            b.daylightSavingInOffset(instance.daylightSavingInOffset);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B offset(Short offset) {
            this.offset = offset;
            return (B)this.self();
        }

        public B daylightSavingInOffset(Boolean daylightSavingInOffset) {
            this.daylightSavingInOffset = daylightSavingInOffset;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TimeZoneDataType.TimeZoneDataTypeBuilder(super=" + super.toString() + ", offset=" + this.offset + ", daylightSavingInOffset=" + this.daylightSavingInOffset + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TimeZoneDataType> {
        @Override
        public Class<TimeZoneDataType> getType() {
            return TimeZoneDataType.class;
        }

        @Override
        public TimeZoneDataType decode(SerializationContext context, UaDecoder decoder) {
            Short offset = decoder.readInt16("Offset");
            Boolean daylightSavingInOffset = decoder.readBoolean("DaylightSavingInOffset");
            return new TimeZoneDataType(offset, daylightSavingInOffset);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TimeZoneDataType value) {
            encoder.writeInt16("Offset", value.getOffset());
            encoder.writeBoolean("DaylightSavingInOffset", value.getDaylightSavingInOffset());
        }
    }
}

