/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.scan;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.chunk.AbstractChunkReader;
import org.apache.tsfile.read.reader.page.PageReader;

public class SinglePageWholeChunkReader
extends AbstractChunkReader {
    private final ChunkHeader chunkHeader;
    private final ByteBuffer chunkDataBuffer;
    private final EncryptParameter encryptParam;

    public SinglePageWholeChunkReader(Chunk chunk) throws IOException {
        super(Long.MIN_VALUE, null);
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.encryptParam = chunk.getEncryptParam();
        this.initAllPageReaders();
    }

    private void initAllPageReaders() throws IOException {
        while (this.chunkDataBuffer.remaining() > 0) {
            this.pageReaderList.add(this.constructPageReader(PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (Statistics)null)));
        }
    }

    private PageReader constructPageReader(PageHeader pageHeader) throws IOException {
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        return new PageReader(pageHeader, SinglePageWholeChunkReader.deserializePageData(pageHeader, this.chunkDataBuffer, this.chunkHeader, decryptor), this.chunkHeader.getDataType(), Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)this.chunkHeader.getDataType()), this.defaultTimeDecoder, null);
    }

    public static ByteBuffer readCompressedPageData(PageHeader pageHeader, ByteBuffer chunkBuffer) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > chunkBuffer.remaining()) {
            throw new IOException("do not has a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + chunkBuffer.remaining());
        }
        chunkBuffer.get(compressedPageBody);
        return ByteBuffer.wrap(compressedPageBody);
    }

    public static ByteBuffer uncompressPageData(PageHeader pageHeader, IUnCompressor unCompressor, ByteBuffer compressedPageData) throws IOException {
        if (unCompressor.getCodecName() == CompressionType.UNCOMPRESSED) {
            return compressedPageData;
        }
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        ByteBuffer uncompressedPageData = ByteBuffer.allocate(pageHeader.getUncompressedSize());
        try {
            unCompressor.uncompress(compressedPageData.array(), 0, compressedPageBodyLength, uncompressedPageData.array(), 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage(), e);
        }
        return uncompressedPageData;
    }

    public static ByteBuffer decrypt(IDecryptor decryptor, ByteBuffer buffer) {
        if (decryptor == null || decryptor.getEncryptionType() == EncryptionType.UNENCRYPTED) {
            return buffer;
        }
        return ByteBuffer.wrap(decryptor.decrypt(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining()));
    }

    public static ByteBuffer decryptAndUncompressPageData(PageHeader pageHeader, IUnCompressor unCompressor, ByteBuffer compressedPageData, IDecryptor decryptor) throws IOException {
        return SinglePageWholeChunkReader.uncompressPageData(pageHeader, unCompressor, SinglePageWholeChunkReader.decrypt(decryptor, compressedPageData));
    }

    public static ByteBuffer deserializePageData(PageHeader pageHeader, ByteBuffer chunkBuffer, ChunkHeader chunkHeader, IDecryptor decryptor) throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)chunkHeader.getCompressionType());
        ByteBuffer compressedPageBody = SinglePageWholeChunkReader.readCompressedPageData(pageHeader, chunkBuffer);
        if (decryptor == null || decryptor.getEncryptionType() == EncryptionType.UNENCRYPTED) {
            return SinglePageWholeChunkReader.uncompressPageData(pageHeader, unCompressor, compressedPageBody);
        }
        return SinglePageWholeChunkReader.decryptAndUncompressPageData(pageHeader, unCompressor, compressedPageBody, decryptor);
    }
}

