/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.match;

import org.apache.iotdb.commons.path.fa.IFAState;

public class MatchedStateSet {
    private static final int INITIAL_SIZE = 8;
    private final boolean[] stateStatus;
    private int[] existingState = new int[8];
    private int end = 0;

    MatchedStateSet(int capacity) {
        this.stateStatus = new boolean[capacity];
    }

    void add(IFAState state) {
        if (this.stateStatus[state.getIndex()]) {
            return;
        }
        if (this.end == this.existingState.length) {
            int[] array = new int[this.existingState.length * 2];
            System.arraycopy(this.existingState, 0, array, 0, this.end);
            this.existingState = array;
        }
        this.existingState[this.end++] = state.getIndex();
        this.stateStatus[state.getIndex()] = true;
    }

    int getStateIndex(int stateOrdinal) {
        return this.existingState[stateOrdinal];
    }

    int size() {
        return this.end;
    }
}

