/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.AbstractExportData;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class ExportDataTree
extends AbstractExportData {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static Session session;

    @Override
    public void init() throws IoTDBConnectionException, StatementExecutionException, TException {
        session = new Session(host, Integer.parseInt(port), username, password);
        session.open(false);
        timestampPrecision = session.getTimestampPrecision();
        if (timeZoneID != null) {
            session.setTimeZone(timeZoneID);
        }
        zoneId = ZoneId.of(session.getTimeZone());
    }

    @Override
    public void exportBySql(String sql, int index) {
        if ("sql".equalsIgnoreCase(exportType) || "tsfile".equalsIgnoreCase(exportType)) {
            ExportDataTree.legalCheck(sql);
        }
        String path = targetDirectory + targetFile + index;
        try (SessionDataSet sessionDataSet = session.executeQueryStatement(sql, timeout);){
            if ("sql".equalsIgnoreCase(exportType)) {
                this.exportToSqlFile(sessionDataSet, path);
            } else if ("tsfile".equalsIgnoreCase(exportType)) {
                long start = System.currentTimeMillis();
                boolean isComplete = ExportDataTree.exportToTsFile(sessionDataSet, path + ".tsfile");
                if (isComplete) {
                    long end = System.currentTimeMillis();
                    ioTPrinter.println("Export completely!cost: " + (end - start) + " ms.");
                }
            } else {
                ArrayList<String> headers = new ArrayList<String>();
                List names = sessionDataSet.getColumnNames();
                List types = sessionDataSet.getColumnTypes();
                if (Boolean.TRUE.equals(needDataTypePrinted)) {
                    for (int i = 0; i < names.size(); ++i) {
                        if (!"Time".equals(names.get(i)) && !"Device".equals(names.get(i))) {
                            headers.add(String.format("%s(%s)", names.get(i), types.get(i)));
                            continue;
                        }
                        headers.add((String)names.get(i));
                    }
                } else {
                    headers.addAll(names);
                }
                this.exportToCsvFile(sessionDataSet, path);
            }
            sessionDataSet.closeOperationHandle();
            ioTPrinter.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException | WriteProcessException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private void exportToSqlFile(SessionDataSet sessionDataSet, String filePath) throws IoTDBConnectionException, StatementExecutionException, IOException {
        List headers = sessionDataSet.getColumnNames();
        int fileIndex = 0;
        String deviceName = null;
        boolean writeNull = false;
        ArrayList<String> seriesList = new ArrayList<String>(headers);
        if (CollectionUtils.isEmpty((Collection)headers) || headers.size() <= 1) {
            writeNull = true;
        } else if (headers.contains("Device")) {
            seriesList.remove("Time");
            seriesList.remove("Device");
        } else {
            Path path = new Path((String)seriesList.get(1), true);
            deviceName = path.getDeviceString();
            seriesList.remove("Time");
            for (int i = 0; i < seriesList.size(); ++i) {
                String series = (String)seriesList.get(i);
                path = new Path(series, true);
                seriesList.set(i, path.getMeasurement());
            }
        }
        boolean hasNext = sessionDataSet.hasNext();
        while (hasNext) {
            String finalFilePath = filePath + "_" + fileIndex + ".sql";
            try (FileWriter writer = new FileWriter(finalFilePath);){
                if (writeNull) break;
                int i = 0;
                while (i++ < linesPerFile && hasNext) {
                    RowRecord rowRecord = sessionDataSet.next();
                    List fields = rowRecord.getFields();
                    ArrayList headersTemp = new ArrayList(seriesList);
                    ArrayList<String> timeseries = new ArrayList<String>();
                    if (headers.contains("Device")) {
                        deviceName = ((Field)fields.get(0)).toString();
                        if (deviceName.startsWith("root.__system.")) continue;
                        for (String header : headersTemp) {
                            timeseries.add(deviceName + "." + header);
                        }
                    } else {
                        if (((String)headers.get(1)).startsWith("root.__system.")) continue;
                        timeseries.addAll(headers);
                        timeseries.remove(0);
                    }
                    String sqlMiddle = Boolean.TRUE.equals(aligned) ? " ALIGNED VALUES (" + rowRecord.getTimestamp() + "," : " VALUES (" + rowRecord.getTimestamp() + ",";
                    ArrayList<String> values = new ArrayList<String>();
                    if (headers.contains("Device")) {
                        fields.remove(0);
                    }
                    for (int index = 0; index < fields.size(); ++index) {
                        RowRecord next = session.executeQueryStatement("SHOW TIMESERIES " + (String)timeseries.get(index), timeout).next();
                        if (ObjectUtils.isNotEmpty((Object)next)) {
                            List timeseriesList = next.getFields();
                            String value = ((Field)fields.get(index)).toString();
                            if (value.equals("null")) {
                                headersTemp.remove(seriesList.get(index));
                                continue;
                            }
                            if ("TEXT".equalsIgnoreCase(((Field)timeseriesList.get(3)).getStringValue())) {
                                values.add("\"" + value + "\"");
                                continue;
                            }
                            values.add(value);
                            continue;
                        }
                        headersTemp.remove(seriesList.get(index));
                    }
                    if (CollectionUtils.isNotEmpty(headersTemp)) {
                        writer.write("INSERT INTO " + deviceName + "(TIMESTAMP," + String.join((CharSequence)",", headersTemp) + ")" + sqlMiddle + String.join((CharSequence)",", values) + ");\n");
                    }
                    if (hasNext = sessionDataSet.hasNext()) continue;
                    break;
                }
                writer.flush();
            }
            if (!hasNext) break;
            ++fileIndex;
        }
    }

    private static Boolean exportToTsFile(SessionDataSet sessionDataSet, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException, WriteProcessException {
        List columnNames = sessionDataSet.getColumnNames();
        List columnTypes = sessionDataSet.getColumnTypes();
        File f = FSFactoryProducer.getFSFactory().getFile(filePath);
        if (f.exists()) {
            Files.delete(f.toPath());
        }
        boolean isEmpty = false;
        try (TsFileWriter tsFileWriter = new TsFileWriter(f);){
            HashMap<String, List<Integer>> deviceColumnIndices = new HashMap<String, List<Integer>>();
            HashSet<String> alignedDevices = new HashSet<String>();
            LinkedHashMap<String, List<IMeasurementSchema>> deviceSchemaMap = new LinkedHashMap<String, List<IMeasurementSchema>>();
            ExportDataTree.collectSchemas(columnNames, columnTypes, deviceSchemaMap, alignedDevices, deviceColumnIndices);
            List<Tablet> tabletList = ExportDataTree.constructTablets(deviceSchemaMap, alignedDevices, tsFileWriter);
            if (!tabletList.isEmpty()) {
                ExportDataTree.writeWithTablets(sessionDataSet, tabletList, alignedDevices, tsFileWriter, deviceColumnIndices);
                tsFileWriter.flush();
            } else {
                isEmpty = true;
            }
        }
        if (isEmpty) {
            ioTPrinter.println("!!!Warning:Tablet is empty,no data can be exported.");
            return false;
        }
        return true;
    }

    private void exportToCsvFile(SessionDataSet sessionDataSet, String filePath) throws IOException, IoTDBConnectionException, StatementExecutionException {
        List headers = sessionDataSet.getColumnNames();
        int fileIndex = 0;
        boolean hasNext = sessionDataSet.hasNext();
        while (hasNext) {
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractDataTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractDataTool.CSVPrinterWrapper(finalFilePath);
            csvPrinterWrapper.printRecord(headers);
            int i = 0;
            while (i++ < linesPerFile && hasNext) {
                RowRecord rowRecord = sessionDataSet.next();
                if (rowRecord.getTimestamp() != 0L) {
                    csvPrinterWrapper.print(ExportDataTree.timeTrans(rowRecord.getTimestamp()));
                }
                rowRecord.getFields().forEach(field -> {
                    String fieldStringValue = field.getStringValue();
                    if (!"null".equals(field.getStringValue())) {
                        if (!(field.getDataType() != TSDataType.TEXT && field.getDataType() != TSDataType.STRING || fieldStringValue.startsWith("root."))) {
                            fieldStringValue = "\"" + fieldStringValue + "\"";
                        }
                        csvPrinterWrapper.print(fieldStringValue);
                    } else {
                        csvPrinterWrapper.print("");
                    }
                });
                csvPrinterWrapper.println();
                hasNext = sessionDataSet.hasNext();
                if (hasNext) continue;
                break;
            }
            csvPrinterWrapper.flush();
            if (!hasNext) break;
            ++fileIndex;
        }
    }

    private static void writeWithTablets(SessionDataSet sessionDataSet, List<Tablet> tabletList, Set<String> alignedDevices, TsFileWriter tsFileWriter, Map<String, List<Integer>> deviceColumnIndices) throws IoTDBConnectionException, StatementExecutionException, IOException, WriteProcessException {
        while (sessionDataSet.hasNext()) {
            RowRecord rowRecord = sessionDataSet.next();
            List fields = rowRecord.getFields();
            for (Tablet tablet : tabletList) {
                String deviceId = tablet.getDeviceId();
                List<Integer> columnIndices = deviceColumnIndices.get(deviceId);
                int rowIndex = tablet.getRowSize();
                tablet.addTimestamp(rowIndex, rowRecord.getTimestamp());
                List schemas = tablet.getSchemas();
                int columnIndicesSize = columnIndices.size();
                for (int i = 0; i < columnIndicesSize; ++i) {
                    Integer columnIndex = columnIndices.get(i);
                    IMeasurementSchema measurementSchema = (IMeasurementSchema)schemas.get(i);
                    Object value = ((Field)fields.get(columnIndex - 1)).getObjectValue(measurementSchema.getType());
                    tablet.addValue(measurementSchema.getMeasurementName(), rowIndex, value);
                }
                if (tablet.getRowSize() != tablet.getMaxRowNumber()) continue;
                ExportDataTree.writeToTsFile(alignedDevices, tsFileWriter, tablet);
                tablet.reset();
            }
        }
        for (Tablet tablet : tabletList) {
            if (tablet.getRowSize() == 0) continue;
            ExportDataTree.writeToTsFile(alignedDevices, tsFileWriter, tablet);
        }
    }

    private static void writeToTsFile(Set<String> deviceFilterSet, TsFileWriter tsFileWriter, Tablet tablet) throws IOException, WriteProcessException {
        if (deviceFilterSet.contains(tablet.getDeviceId())) {
            tsFileWriter.writeAligned(tablet);
        } else {
            tsFileWriter.writeTree(tablet);
        }
    }

    private static List<Tablet> constructTablets(Map<String, List<IMeasurementSchema>> deviceSchemaMap, Set<String> alignedDevices, TsFileWriter tsFileWriter) throws WriteProcessException {
        ArrayList<Tablet> tabletList = new ArrayList<Tablet>(deviceSchemaMap.size());
        for (Map.Entry<String, List<IMeasurementSchema>> stringListEntry : deviceSchemaMap.entrySet()) {
            String deviceId = stringListEntry.getKey();
            List<IMeasurementSchema> schemaList = stringListEntry.getValue();
            Tablet tablet = new Tablet(deviceId, schemaList);
            tablet.initBitMaps();
            Path path = new Path(tablet.getDeviceId());
            if (alignedDevices.contains(tablet.getDeviceId())) {
                tsFileWriter.registerAlignedTimeseries(path, schemaList);
            } else {
                tsFileWriter.registerTimeseries(path, schemaList);
            }
            tabletList.add(tablet);
        }
        return tabletList;
    }

    private static void collectSchemas(List<String> columnNames, List<String> columnTypes, Map<String, List<IMeasurementSchema>> deviceSchemaMap, Set<String> alignedDevices, Map<String, List<Integer>> deviceColumnIndices) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < columnNames.size(); ++i) {
            String column = columnNames.get(i);
            if (!column.startsWith("root.")) continue;
            TSDataType tsDataType = ExportDataTree.getType(columnTypes.get(i));
            Path path = new Path(column, true);
            String deviceId = path.getDeviceString();
            try (SessionDataSet deviceDataSet = session.executeQueryStatement("show devices " + deviceId, timeout);){
                List deviceList = deviceDataSet.next().getFields();
                if (deviceList.size() > 1 && "true".equals(((Field)deviceList.get(1)).getStringValue())) {
                    alignedDevices.add(deviceId);
                }
            }
            MeasurementSchema measurementSchema = new MeasurementSchema(path.getMeasurement(), tsDataType);
            List seriesList = session.executeQueryStatement("show timeseries " + column, timeout).next().getFields();
            measurementSchema.setEncoding(TSEncoding.valueOf((String)((Field)seriesList.get(4)).getStringValue()));
            measurementSchema.setCompressionType(CompressionType.valueOf((String)((Field)seriesList.get(5)).getStringValue()));
            deviceSchemaMap.computeIfAbsent(deviceId, key -> new ArrayList()).add(measurementSchema);
            deviceColumnIndices.computeIfAbsent(deviceId, key -> new ArrayList()).add(i);
        }
    }
}

