/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletBinaryReqV2;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletInsertNodeReqV2;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;

public class PipeTransferTabletBatchReqV2
extends TPipeTransferReq {
    private final transient List<PipeTransferTabletBinaryReqV2> binaryReqs = new ArrayList<PipeTransferTabletBinaryReqV2>();
    private final transient List<PipeTransferTabletInsertNodeReqV2> insertNodeReqs = new ArrayList<PipeTransferTabletInsertNodeReqV2>();
    private final transient List<PipeTransferTabletRawReqV2> tabletReqs = new ArrayList<PipeTransferTabletRawReqV2>();

    private PipeTransferTabletBatchReqV2() {
    }

    public List<InsertBaseStatement> constructStatements() {
        InsertBaseStatement statement;
        ArrayList<InsertBaseStatement> statements = new ArrayList<InsertBaseStatement>();
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        HashMap<String, List> tableModelDatabaseInsertRowStatementMap = new HashMap<String, List>();
        for (PipeTransferTabletBinaryReqV2 pipeTransferTabletBinaryReqV2 : this.binaryReqs) {
            statement = pipeTransferTabletBinaryReqV2.constructStatement();
            if (statement.isEmpty()) continue;
            if (statement.isWriteToTable()) {
                if (statement instanceof InsertRowStatement) {
                    tableModelDatabaseInsertRowStatementMap.computeIfAbsent(statement.getDatabaseName().get(), k -> new ArrayList()).add((InsertRowStatement)statement);
                    continue;
                }
                if (statement instanceof InsertTabletStatement) {
                    statements.add(statement);
                    continue;
                }
                if (statement instanceof InsertRowsStatement) {
                    tableModelDatabaseInsertRowStatementMap.computeIfAbsent(statement.getDatabaseName().get(), k -> new ArrayList()).addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                    continue;
                }
                throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletBinaryReqV2.", new Object[]{pipeTransferTabletBinaryReqV2}));
            }
            if (statement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)statement);
                continue;
            }
            if (statement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)statement);
                continue;
            }
            if (statement instanceof InsertRowsStatement) {
                insertRowStatementList.addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                continue;
            }
            throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletBinaryReqV2.", new Object[]{pipeTransferTabletBinaryReqV2}));
        }
        for (PipeTransferTabletInsertNodeReqV2 pipeTransferTabletInsertNodeReqV2 : this.insertNodeReqs) {
            statement = pipeTransferTabletInsertNodeReqV2.constructStatement();
            if (statement.isEmpty()) continue;
            if (statement.isWriteToTable()) {
                if (statement instanceof InsertRowStatement) {
                    tableModelDatabaseInsertRowStatementMap.computeIfAbsent(statement.getDatabaseName().get(), k -> new ArrayList()).add((InsertRowStatement)statement);
                    continue;
                }
                if (statement instanceof InsertTabletStatement) {
                    statements.add(statement);
                    continue;
                }
                if (statement instanceof InsertRowsStatement) {
                    tableModelDatabaseInsertRowStatementMap.computeIfAbsent(statement.getDatabaseName().get(), k -> new ArrayList()).addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                    continue;
                }
                throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletBinaryReqV2.", new Object[]{pipeTransferTabletInsertNodeReqV2}));
            }
            if (statement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)statement);
                continue;
            }
            if (statement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)statement);
                continue;
            }
            if (statement instanceof InsertRowsStatement) {
                insertRowStatementList.addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unknown InsertBaseStatement %s constructed from PipeTransferTabletInsertNodeReqV2.", statement));
        }
        for (PipeTransferTabletRawReqV2 pipeTransferTabletRawReqV2 : this.tabletReqs) {
            statement = pipeTransferTabletRawReqV2.constructStatement();
            if (((InsertTabletStatement)statement).isEmpty()) continue;
            if (statement.isWriteToTable()) {
                statements.add(statement);
                continue;
            }
            insertTabletStatementList.add((InsertTabletStatement)statement);
        }
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        if (!insertRowsStatement.isEmpty()) {
            statements.add(insertRowsStatement);
        }
        if (!insertMultiTabletsStatement.isEmpty()) {
            statements.add(insertMultiTabletsStatement);
        }
        for (Map.Entry entry : tableModelDatabaseInsertRowStatementMap.entrySet()) {
            statement = new InsertRowsStatement();
            statement.setWriteToTable(true);
            statement.setDatabaseName((String)entry.getKey());
            ((InsertRowsStatement)statement).setInsertRowStatementList((List)entry.getValue());
            statements.add(statement);
        }
        return statements;
    }

    public static PipeTransferTabletBatchReqV2 toTPipeTransferReq(List<ByteBuffer> binaryBuffers, List<ByteBuffer> insertNodeBuffers, List<ByteBuffer> tabletBuffers, List<String> binaryDataBases, List<String> insertNodeDataBases, List<String> tabletDataBases) throws IOException {
        PipeTransferTabletBatchReqV2 batchReq = new PipeTransferTabletBatchReqV2();
        batchReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        batchReq.type = PipeRequestType.TRANSFER_TABLET_BATCH_V2.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            int i;
            ReadWriteIOUtils.write((int)binaryBuffers.size(), (OutputStream)outputStream);
            for (i = 0; i < binaryBuffers.size(); ++i) {
                ByteBuffer binaryBuffer = binaryBuffers.get(i);
                ReadWriteIOUtils.write((int)binaryBuffer.limit(), (OutputStream)outputStream);
                outputStream.write(binaryBuffer.array(), 0, binaryBuffer.limit());
                ReadWriteIOUtils.write((String)binaryDataBases.get(i), (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write((int)insertNodeBuffers.size(), (OutputStream)outputStream);
            for (i = 0; i < insertNodeBuffers.size(); ++i) {
                ByteBuffer insertNodeBuffer = insertNodeBuffers.get(i);
                outputStream.write(insertNodeBuffer.array(), 0, insertNodeBuffer.limit());
                ReadWriteIOUtils.write((String)insertNodeDataBases.get(i), (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write((int)tabletBuffers.size(), (OutputStream)outputStream);
            for (i = 0; i < tabletBuffers.size(); ++i) {
                ByteBuffer tabletBuffer = tabletBuffers.get(i);
                outputStream.write(tabletBuffer.array(), 0, tabletBuffer.limit());
                ReadWriteIOUtils.write((String)tabletDataBases.get(i), (OutputStream)outputStream);
            }
            batchReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return batchReq;
    }

    public static PipeTransferTabletBatchReqV2 fromTPipeTransferReq(TPipeTransferReq transferReq) {
        int i;
        PipeTransferTabletBatchReqV2 batchReq = new PipeTransferTabletBatchReqV2();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            int length = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
            byte[] body = new byte[length];
            transferReq.body.get(body);
            batchReq.binaryReqs.add(PipeTransferTabletBinaryReqV2.toTPipeTransferBinaryReq(ByteBuffer.wrap(body), ReadWriteIOUtils.readString((ByteBuffer)transferReq.body)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.insertNodeReqs.add(PipeTransferTabletInsertNodeReqV2.toTabletInsertNodeReq((InsertNode)PlanFragment.deserializeHelper(transferReq.body, null), ReadWriteIOUtils.readString((ByteBuffer)transferReq.body)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.tabletReqs.add(PipeTransferTabletRawReqV2.toTPipeTransferRawReq(Tablet.deserialize((ByteBuffer)transferReq.body), ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body), ReadWriteIOUtils.readString((ByteBuffer)transferReq.body)));
        }
        batchReq.version = transferReq.version;
        batchReq.type = transferReq.type;
        batchReq.body = transferReq.body;
        return batchReq;
    }

    @TestOnly
    public List<PipeTransferTabletBinaryReqV2> getBinaryReqs() {
        return this.binaryReqs;
    }

    @TestOnly
    public List<PipeTransferTabletInsertNodeReqV2> getInsertNodeReqs() {
        return this.insertNodeReqs;
    }

    @TestOnly
    public List<PipeTransferTabletRawReqV2> getTabletReqs() {
        return this.tabletReqs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletBatchReqV2 that = (PipeTransferTabletBatchReqV2)((Object)obj);
        return Objects.equals(this.binaryReqs, that.binaryReqs) && Objects.equals(this.insertNodeReqs, that.insertNodeReqs) && Objects.equals(this.tabletReqs, that.tabletReqs) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.binaryReqs, this.insertNodeReqs, this.tabletReqs, this.version, this.type, this.body);
    }
}

