/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PolarisPolicyMappingRecord {
    public static final String EMPTY_MAP_STRING = "{}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private long targetCatalogId;
    private long targetId;
    private long policyCatalogId;
    private long policyId;
    private int policyTypeCode;
    private String parameters;

    public PolarisPolicyMappingRecord() {
    }

    public long getTargetCatalogId() {
        return this.targetCatalogId;
    }

    public void setTargetCatalogId(long targetCatalogId) {
        this.targetCatalogId = targetCatalogId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(long targetId) {
        this.targetId = targetId;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    public int getPolicyTypeCode() {
        return this.policyTypeCode;
    }

    public void setPolicyTypeCode(int policyTypeCode) {
        this.policyTypeCode = policyTypeCode;
    }

    public long getPolicyCatalogId() {
        return this.policyCatalogId;
    }

    public void setPolicyCatalogId(long policyCatalogId) {
        this.policyCatalogId = policyCatalogId;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParametersAsMap() {
        if (this.parameters == null) {
            return new HashMap<String, String>();
        }
        try {
            return (Map)MAPPER.readValue(this.parameters, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to deserialize json. parameters %s", this.parameters), ex);
        }
    }

    public void setParametersAsMap(Map<String, String> parameters) {
        try {
            this.parameters = parameters == null ? EMPTY_MAP_STRING : MAPPER.writeValueAsString(parameters);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to serialize json. properties %s", parameters), ex);
        }
    }

    @JsonCreator
    public PolarisPolicyMappingRecord(@JsonProperty(value="targetCatalogId") long targetCatalogId, @JsonProperty(value="targetId") long targetId, @JsonProperty(value="policyCatalogId") long policyCatalogId, @JsonProperty(value="policyId") long policyId, @JsonProperty(value="policyTypeCode") int policyTypeCode, @JsonProperty(value="parameters") String parameters) {
        this.targetCatalogId = targetCatalogId;
        this.targetId = targetId;
        this.policyCatalogId = policyCatalogId;
        this.policyId = policyId;
        this.policyTypeCode = policyTypeCode;
        this.parameters = parameters;
    }

    public PolarisPolicyMappingRecord(long targetCatalogId, long targetId, long policyCatalogId, long policyId, int policyTypeCode, Map<String, String> parameters) {
        this.targetCatalogId = targetCatalogId;
        this.targetId = targetId;
        this.policyCatalogId = policyCatalogId;
        this.policyId = policyId;
        this.policyTypeCode = policyTypeCode;
        this.setParametersAsMap(parameters);
    }

    public PolarisPolicyMappingRecord(PolarisPolicyMappingRecord policyMappingRecord) {
        this.targetCatalogId = policyMappingRecord.getTargetCatalogId();
        this.targetId = policyMappingRecord.getTargetId();
        this.policyCatalogId = policyMappingRecord.getPolicyCatalogId();
        this.policyId = policyMappingRecord.getPolicyId();
        this.policyTypeCode = policyMappingRecord.getPolicyTypeCode();
        this.parameters = policyMappingRecord.getParameters();
    }

    public String toString() {
        return "PolarisPolicyMappingRec{targetCatalogId=" + this.targetCatalogId + ", targetId=" + this.targetId + ", policyCatalogId=" + this.policyCatalogId + ", policyId=" + this.policyId + ", policyType='" + this.policyTypeCode + ", parameters='" + this.parameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolarisPolicyMappingRecord that = (PolarisPolicyMappingRecord)o;
        return this.targetCatalogId == that.targetCatalogId && this.targetId == that.targetId && this.policyCatalogId == that.policyCatalogId && this.policyId == that.policyId && this.policyTypeCode == that.policyTypeCode && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.targetId, this.policyId, this.policyCatalogId, this.policyTypeCode, this.parameters);
    }
}

