/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="azure storage configuration info")
public class AzureStorageConfigInfo
extends StorageConfigInfo {
    @NotNull
    private final String tenantId;
    private final String multiTenantAppName;
    private final String consentUrl;

    @ApiModelProperty(required=true, value="the tenant id that the storage accounts belong to")
    @JsonProperty(value="tenantId", required=true)
    public String getTenantId() {
        return this.tenantId;
    }

    @ApiModelProperty(value="the name of the azure client application")
    @JsonProperty(value="multiTenantAppName")
    public String getMultiTenantAppName() {
        return this.multiTenantAppName;
    }

    @ApiModelProperty(value="URL to the Azure permissions request page")
    @JsonProperty(value="consentUrl")
    public String getConsentUrl() {
        return this.consentUrl;
    }

    @JsonCreator
    public AzureStorageConfigInfo(@JsonProperty(value="tenantId", required=true) String tenantId, @JsonProperty(value="multiTenantAppName") String multiTenantAppName, @JsonProperty(value="consentUrl") String consentUrl, @JsonProperty(value="storageType", required=true) StorageConfigInfo.StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.tenantId = tenantId;
        this.multiTenantAppName = multiTenantAppName;
        this.consentUrl = consentUrl;
    }

    public AzureStorageConfigInfo(String tenantId, StorageConfigInfo.StorageTypeEnum storageType) {
        super(storageType);
        this.tenantId = tenantId;
        this.multiTenantAppName = null;
        this.consentUrl = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String tenantId, StorageConfigInfo.StorageTypeEnum storageType) {
        return new Builder(tenantId, storageType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureStorageConfigInfo azureStorageConfigInfo = (AzureStorageConfigInfo)o;
        return super.equals(o) && Objects.equals(this.tenantId, azureStorageConfigInfo.tenantId) && Objects.equals(this.multiTenantAppName, azureStorageConfigInfo.multiTenantAppName) && Objects.equals(this.consentUrl, azureStorageConfigInfo.consentUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tenantId, super.hashCode(), this.multiTenantAppName, super.hashCode(), this.consentUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureStorageConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    multiTenantAppName: ").append(this.toIndentedString(this.multiTenantAppName)).append("\n");
        sb.append("    consentUrl: ").append(this.toIndentedString(this.consentUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String tenantId;
        private String multiTenantAppName;
        private String consentUrl;
        private StorageConfigInfo.StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(String tenantId, StorageConfigInfo.StorageTypeEnum storageType) {
            this.tenantId = tenantId;
            this.storageType = storageType;
        }

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setMultiTenantAppName(String multiTenantAppName) {
            this.multiTenantAppName = multiTenantAppName;
            return this;
        }

        public Builder setConsentUrl(String consentUrl) {
            this.consentUrl = consentUrl;
            return this;
        }

        public Builder setStorageType(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public AzureStorageConfigInfo build() {
            AzureStorageConfigInfo inst = new AzureStorageConfigInfo(this.tenantId, this.multiTenantAppName, this.consentUrl, this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

