import * as React from "react";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { JavaClass } from "./model/JavaClass";
import { JavaCodeCompletionService } from "./services";
export type LanguageServerStatus = "disable" | "enable" | "loading" | "error";
export type ImportJavaClassesWizardProps = Pick<React.ComponentProps<typeof Modal>, "isOpen" | "onClose"> & {
    onSave: (javaClass: JavaClass[]) => void;
    javaCodeCompletionService: JavaCodeCompletionService;
};
export interface ImportJavaClassesButtonProps {
    javaCodeCompletionService: JavaCodeCompletionService;
    handleButtonClick: () => void;
}
export declare const useLanguageServerAvailable: (javaCodeCompletionService: JavaCodeCompletionService) => {
    languageServerStatus: LanguageServerStatus;
    isLanguageServerDisabled: boolean;
    isLanguageServerLoading: boolean;
    isLanguageServerError: boolean;
};
export declare const ImportJavaClassesButton: ({ javaCodeCompletionService, handleButtonClick, }: ImportJavaClassesButtonProps) => JSX.Element;
export declare const ImportJavaClassesWizard: ({ javaCodeCompletionService, isOpen, onClose, onSave, }: ImportJavaClassesWizardProps) => JSX.Element;
//# sourceMappingURL=ImportJavaClassesWizard.d.ts.map