import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { getDashboardNameColumn, getDateColumn } from "../CustomDashboardListUtils/CustomDashboardListUtils";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
const CustomDashboardsTable = ({ driver, customDashboardData, setDashboardsData, isLoading, ouiaId, ouiaSafe, }) => {
    const [columns] = useState([
        getDashboardNameColumn((customDashboardInfo) => driver.openDashboard(customDashboardInfo)),
        getDateColumn("lastModified", "Last Modified"),
    ]);
    const [sortBy, setSortBy] = useState({
        property: "lastModified",
        direction: "desc",
    });
    useEffect(() => {
        if (!_.isEmpty(customDashboardData)) {
            onSort(2, "desc");
        }
    }, [isLoading]);
    const getSortBy = () => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    };
    const onSort = async (index, direction) => {
        const sortObj = {
            property: columns[index - 1].path,
            direction: direction,
        };
        const sortedData = _.orderBy(customDashboardData, _.keys({
            [sortObj.property]: sortObj.direction,
        }), _.values({
            [sortObj.property]: sortObj.direction,
        }));
        setDashboardsData(sortedData);
        setSortBy(sortObj);
    };
    const customDashboardLoadingComponent = (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading Dashboard...", ouiaId: "custom-dashboard-list-custom-dashboard-list" }) }));
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "customDashboard-table", ouiaSafe), children: _jsx(DataTable, { data: customDashboardData, isLoading: isLoading, columns: columns, error: false, sortBy: getSortBy(), onSorting: onSort, LoadingComponent: customDashboardLoadingComponent }) }));
};
export default CustomDashboardsTable;
//# sourceMappingURL=CustomDashboardsTable.js.map