import { Actions } from "./Actions";
import { Builder } from "../paths";
import { validateMiningFieldsDataFieldReference } from "../validation/MiningSchema";
import { getMiningSchema } from "../PMMLModelHelper";
export const PMMLReducer = (historyService, validationRegistry) => {
    return (state, action) => {
        var _a;
        switch (action.type) {
            case Actions.Refresh:
                return action.payload.pmml;
            case Actions.SetVersion:
                historyService.batch(state, null, (draft) => {
                    draft.version = action.payload.version;
                });
                break;
            case Actions.Undo:
                return historyService.undo(state);
            case Actions.Redo:
                return historyService.redo(state);
            case Actions.Validate:
                const dataFields = state.DataDictionary.DataField;
                const models = (_a = state.models) !== null && _a !== void 0 ? _a : [];
                models.forEach((model, modelIndex) => {
                    const miningSchema = getMiningSchema(state, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear(Builder().forModel(modelIndex).forMiningSchema().build());
                        validateMiningFieldsDataFieldReference(modelIndex, dataFields, miningSchema.MiningField, validationRegistry);
                    }
                });
        }
        return state;
    };
};
//# sourceMappingURL=PMMLReducer.js.map