import { ApolloClient } from "apollo-client";
import { BulkCancel, Job, JobOperationResult, JobStatus, JobsSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export interface JobsManagementQueries {
    getJobs(start: number, end: number, filters: JobStatus[], sortBy: JobsSortBy | any): Promise<Job[]>;
    cancelJob: (job: Pick<Job, "id" | "endpoint">) => Promise<JobOperationResult>;
    bulkCancel: (jobsToBeActioned: (Job & {
        errorMessage?: string;
    })[]) => Promise<BulkCancel>;
    rescheduleJob: (job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date) => Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
}
export declare class GraphQLJobsManagementQueries implements JobsManagementQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getJobs(offset: number, limit: number, filters: JobStatus[], orderBy: JobsSortBy): Promise<Job[]>;
    cancelJob(job: Job): Promise<JobOperationResult>;
    bulkCancel(jobsToBeActioned: (Job & {
        errorMessage?: string;
    })[]): Promise<BulkCancel>;
    rescheduleJob(job: Job, repeatInterval: string | number, repeatLimit: string | number, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
}
//# sourceMappingURL=JobsManagementQueries.d.ts.map