import { By } from "selenium-webdriver";
import DmnPalette from "./DmnPalette";
import DmnSideBar from "./DmnSideBar";
import Editor from "../Editor";
import DecisionNavigator from "./DecisionNavigator";
import DmnExpressionEditor from "./DmnExpressionEditor";
class DmnEditor extends Editor {
    async getDmnPalette() {
        const palette = await this.tools.by(DmnEditor.PALETTE_LOCATOR).getElement();
        return await this.tools.createPageFragment(DmnPalette, palette);
    }
    async getExpressionEditor() {
        const palette = await this.tools.by(DmnEditor.EXPRESSION_EDITOR_LOCATOR).getElement();
        return await this.tools.createPageFragment(DmnExpressionEditor, palette);
    }
    async getSideBar() {
        const sideBar = this.tools.by(DmnEditor.SIDE_BAR_LOCATOR);
        await sideBar.wait(1000).untilPresent();
        return await this.tools.createPageFragment(DmnSideBar, await sideBar.getElement());
    }
    async openLeftSideBar() {
        const leftSideBarButton = await this.tools.by(DmnEditor.LEFT_SIDE_BAR_LOCATOR).getElement();
        await leftSideBarButton.click();
        return await this.tools.createPageFragment(DecisionNavigator, await this.tools.by(DmnEditor.DECISION_GRAPH_LOCATOR).getElement());
    }
    async dragAndDropAnnotationToCanvas() {
        const dmnPalette = await this.getDmnPalette();
        return await dmnPalette.dragAndDropAnnotationToCanvas();
    }
}
DmnEditor.PALETTE_LOCATOR = By.className("kie-palette");
DmnEditor.EXPRESSION_EDITOR_LOCATOR = By.id("dmn-expression-editor-container");
DmnEditor.SIDE_BAR_LOCATOR = By.className("collapsed-docks-bar-E");
DmnEditor.LEFT_SIDE_BAR_LOCATOR = By.className("collapsed-docks-bar-W");
DmnEditor.DECISION_GRAPH_LOCATOR = By.id("decision-graphs-content");
export default DmnEditor;
//# sourceMappingURL=DmnEditor.js.map