import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as __path from "path";
import * as React from "react";
import { useCallback, useEffect, useMemo, useState } from "react";
import * as DmnEditor from "@kie-tools/dmn-editor/dist/DmnEditor";
import { normalize } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { getMarshaller } from "@kie-tools/dmn-marshaller";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { SearchType } from "@kie-tools-core/workspace/dist/api";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { domParser } from "@kie-tools/xml-parser-ts";
import { ns as dmn15ns } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/meta";
import { XML2PMML } from "@kie-tools/pmml-editor-marshaller";
import { getPmmlNamespace } from "@kie-tools/dmn-editor/dist/pmml/pmml";
import { getNamespaceOfDmnImport } from "@kie-tools/dmn-editor/dist/includedModels/importNamespaces";
import { imperativePromiseHandle, } from "@kie-tools-core/react-hooks/dist/useImperativePromiseHandler";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
export const EXTERNAL_MODELS_SEARCH_GLOB_PATTERN = "**/*.{dmn,pmml}";
export const TARGET_DIRECTORY = "target/classes/";
export const EMPTY_DMN = () => `<?xml version="1.0" encoding="UTF-8"?>
<definitions
  xmlns="${dmn15ns.get("")}"
  expressionLanguage="${DMN15_SPEC.expressionLanguage.default}"
  namespace="https://kie.org/dmn/${generateUuid()}"
  id="${generateUuid()}"
  name="DMN${generateUuid()}">
</definitions>`;
export class DmnEditorRoot extends React.Component {
    constructor(props) {
        super(props);
        this.externalModelsManagerDoneBootstraping = imperativePromiseHandle();
        this.setExternalModelsByNamespace = (externalModelsByNamespace) => {
            this.setState((prev) => ({ ...prev, externalModelsByNamespace }));
        };
        this.onModelChange = (model) => {
            this.setState((prev) => {
                const newStack = prev.stack.slice(0, prev.pointer + 1);
                return {
                    ...prev,
                    stack: [...newStack, model],
                    pointer: newStack.length,
                };
            }, () => this.props.onNewEdit({
                id: `${this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot}__${generateUuid()}`,
            }));
        };
        this.onRequestExternalModelsAvailableToInclude = async () => {
            if (!this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return [];
            }
            const list = await this.props.onRequestWorkspaceFilesList({
                pattern: EXTERNAL_MODELS_SEARCH_GLOB_PATTERN,
                opts: { type: SearchType.TRAVERSAL },
            });
            return list.normalizedPosixPathsRelativeToTheWorkspaceRoot.flatMap((p) => p === this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot || p.includes(TARGET_DIRECTORY)
                ? []
                : __path.relative(__path.dirname(this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot), p));
        };
        this.onRequestToResolvePathRelativeToTheOpenFile = (normalizedPosixPathRelativeToTheOpenFile) => {
            const normalizedPosixPathRelativeToTheWorkspaceRoot = __path
                .resolve(__path.dirname(this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot), normalizedPosixPathRelativeToTheOpenFile)
                .substring(1);
            return normalizedPosixPathRelativeToTheWorkspaceRoot;
        };
        this.onRequestExternalModelByPathsRelativeToTheOpenFile = async (normalizedPosixPathRelativeToTheOpenFile) => {
            var _a, _b;
            const normalizedPosixPathRelativeToTheWorkspaceRoot = this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile);
            const resource = await this.props.onRequestWorkspaceFileContent({
                normalizedPosixPathRelativeToTheWorkspaceRoot,
                opts: { type: "text" },
            });
            const ext = __path.extname(normalizedPosixPathRelativeToTheOpenFile);
            if (ext === ".dmn") {
                return {
                    normalizedPosixPathRelativeToTheOpenFile,
                    type: "dmn",
                    model: normalize(getMarshaller((_a = resource === null || resource === void 0 ? void 0 : resource.content) !== null && _a !== void 0 ? _a : "", { upgradeTo: "latest" }).parser.parse()),
                    svg: "",
                };
            }
            else if (ext === ".pmml") {
                return {
                    normalizedPosixPathRelativeToTheOpenFile,
                    type: "pmml",
                    model: XML2PMML((_b = resource === null || resource === void 0 ? void 0 : resource.content) !== null && _b !== void 0 ? _b : ""),
                };
            }
            else {
                throw new Error(`Unknown extension '${ext}'.`);
            }
        };
        this.onOpenFileFromPathRelativeToTheOpenFile = (normalizedPosixPathRelativeToTheOpenFile) => {
            if (!this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            this.props.onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot(this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile));
        };
        props.exposing(this);
        this.dmnEditorRef = React.createRef();
        this.state = {
            externalModelsByNamespace: {},
            marshaller: undefined,
            stack: [],
            pointer: -1,
            openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: undefined,
            isReadOnly: props.isReadOnly,
            externalModelsManagerDoneBootstraping: false,
            keyboardShortcutsRegisterIds: [],
            keyboardShortcutsRegistered: false,
            error: undefined,
            evaluationResultsByNodeId: new Map(),
        };
    }
    openBoxedExpressionEditor(nodeId) {
        var _a;
        (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.openBoxedExpressionEditor(nodeId);
    }
    showDmnEvaluationResults(evaluationResultsByNodeId) {
        this.setState((prev) => ({ ...prev, evaluationResultsByNodeId: evaluationResultsByNodeId }));
    }
    async undo() {
        this.setState((prev) => ({ ...prev, pointer: Math.max(0, prev.pointer - 1) }));
    }
    async redo() {
        this.setState((prev) => ({ ...prev, pointer: Math.min(prev.stack.length - 1, prev.pointer + 1) }));
    }
    async getDiagramSvg() {
        var _a;
        return (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getDiagramSvg();
    }
    async getContent() {
        if (!this.state.marshaller || !this.model) {
            throw new Error(`DMN EDITOR ROOT: Content has not been set yet. Throwing an error to prevent returning a "default" content.`);
        }
        return this.state.marshaller.builder.build(this.model);
    }
    async setContent(openFileNormalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        const marshaller = this.getMarshaller(content);
        let savedStackPointer = [];
        this.setState((prev) => {
            savedStackPointer = [...prev.stack];
            return {
                stack: [normalize(marshaller.parser.parse())],
                openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                pointer: 0,
            };
        });
        await this.externalModelsManagerDoneBootstraping.promise;
        this.setState((prev) => {
            if (prev.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot ===
                openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                const newStack = savedStackPointer.slice(0, prev.pointer + 1);
                return {
                    marshaller,
                    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                    stack: [...newStack, normalize(marshaller.parser.parse())],
                    isReadOnly: prev.isReadOnly,
                    pointer: newStack.length,
                    externalModelsManagerDoneBootstraping: true,
                };
            }
            else {
                return {
                    marshaller,
                    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                    stack: [normalize(marshaller.parser.parse())],
                    isReadOnly: prev.isReadOnly,
                    pointer: 0,
                    externalModelsManagerDoneBootstraping: true,
                };
            }
        });
    }
    get model() {
        return this.state.stack[this.state.pointer];
    }
    getMarshaller(content) {
        try {
            return getMarshaller(content || EMPTY_DMN(), { upgradeTo: "latest" });
        }
        catch (e) {
            this.setState((s) => ({
                ...s,
                error: e,
            }));
            throw e;
        }
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        if (this.props.keyboardShortcutsService === undefined || this.state.keyboardShortcutsRegistered === true) {
            return;
        }
        const commands = (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (commands === undefined) {
            return;
        }
        const cancelAction = this.props.keyboardShortcutsService.registerKeyPress("Escape", "Edit | Unselect", async () => commands.cancelAction());
        const deleteSelectionBackspace = this.props.keyboardShortcutsService.registerKeyPress("Backspace", "Edit | Delete selection", async () => { });
        const deleteSelectionDelete = this.props.keyboardShortcutsService.registerKeyPress("Delete", "Edit | Delete selection", async () => { });
        const selectAll = (_b = this.props.keyboardShortcutsService) === null || _b === void 0 ? void 0 : _b.registerKeyPress("A", "Edit | Select/Deselect all", async () => commands.selectAll());
        const createGroup = (_c = this.props.keyboardShortcutsService) === null || _c === void 0 ? void 0 : _c.registerKeyPress("G", "Edit | Create group wrapping selection", async () => {
            console.log(" KEY GROUP PRESSED, ", commands);
            return commands.createGroup();
        });
        const hideFromDrd = (_d = this.props.keyboardShortcutsService) === null || _d === void 0 ? void 0 : _d.registerKeyPress("X", "Edit | Hide from DRD", async () => commands.hideFromDrd());
        const copy = (_e = this.props.keyboardShortcutsService) === null || _e === void 0 ? void 0 : _e.registerKeyPress("Ctrl+C", "Edit | Copy nodes", async () => commands.copy());
        const cut = (_f = this.props.keyboardShortcutsService) === null || _f === void 0 ? void 0 : _f.registerKeyPress("Ctrl+X", "Edit | Cut nodes", async () => commands.cut());
        const paste = (_g = this.props.keyboardShortcutsService) === null || _g === void 0 ? void 0 : _g.registerKeyPress("Ctrl+V", "Edit | Paste nodes", async () => commands.paste());
        const togglePropertiesPanel = (_h = this.props.keyboardShortcutsService) === null || _h === void 0 ? void 0 : _h.registerKeyPress("I", "Misc | Open/Close properties panel", async () => commands.togglePropertiesPanel());
        const toggleHierarchyHighlight = (_j = this.props.keyboardShortcutsService) === null || _j === void 0 ? void 0 : _j.registerKeyPress("H", "Misc | Toggle hierarchy highlights", async () => commands.toggleHierarchyHighlight());
        const moveUp = this.props.keyboardShortcutsService.registerKeyPress("Up", "Move | Move selection up", async () => { });
        const moveDown = this.props.keyboardShortcutsService.registerKeyPress("Down", "Move | Move selection down", async () => { });
        const moveLeft = this.props.keyboardShortcutsService.registerKeyPress("Left", "Move | Move selection left", async () => { });
        const moveRight = this.props.keyboardShortcutsService.registerKeyPress("Right", "Move | Move selection right", async () => { });
        const bigMoveUp = this.props.keyboardShortcutsService.registerKeyPress("Shift + Up", "Move | Move selection up a big distance", async () => { });
        const bigMoveDown = this.props.keyboardShortcutsService.registerKeyPress("Shift + Down", "Move | Move selection down a big distance", async () => { });
        const bigMoveLeft = this.props.keyboardShortcutsService.registerKeyPress("Shift + Left", "Move | Move selection left a big distance", async () => { });
        const bigMoveRight = this.props.keyboardShortcutsService.registerKeyPress("Shift + Right", "Move | Move selection right a big distance", async () => { });
        const focusOnBounds = (_k = this.props.keyboardShortcutsService) === null || _k === void 0 ? void 0 : _k.registerKeyPress("B", "Navigate | Focus on selection", async () => commands.focusOnSelection());
        const resetPosition = (_l = this.props.keyboardShortcutsService) === null || _l === void 0 ? void 0 : _l.registerKeyPress("Space", "Navigate | Reset position to origin", async () => commands.resetPosition());
        const pan = (_m = this.props.keyboardShortcutsService) === null || _m === void 0 ? void 0 : _m.registerKeyPress("Right Mouse Button", "Navigate | Hold and drag to Pan", async () => { });
        const zoom = (_o = this.props.keyboardShortcutsService) === null || _o === void 0 ? void 0 : _o.registerKeyPress("Ctrl", "Navigate | Hold and scroll to zoom in/out", async () => { });
        const navigateHorizontally = (_p = this.props.keyboardShortcutsService) === null || _p === void 0 ? void 0 : _p.registerKeyPress("Shift", "Navigate | Hold and scroll to navigate horizontally", async () => { });
        this.setState((prev) => ({
            ...prev,
            keyboardShortcutsRegistered: true,
            keyboardShortcutsRegisterIds: [
                bigMoveDown,
                bigMoveLeft,
                bigMoveRight,
                bigMoveUp,
                cancelAction,
                copy,
                createGroup,
                cut,
                deleteSelectionBackspace,
                deleteSelectionDelete,
                focusOnBounds,
                hideFromDrd,
                moveDown,
                moveLeft,
                moveRight,
                moveUp,
                navigateHorizontally,
                pan,
                paste,
                resetPosition,
                selectAll,
                toggleHierarchyHighlight,
                togglePropertiesPanel,
                zoom,
            ],
        }));
    }
    componentWillUnmount() {
        var _a;
        const keyboardShortcuts = (_a = this.dmnEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (keyboardShortcuts === undefined) {
            return;
        }
        this.state.keyboardShortcutsRegisterIds.forEach((id) => {
            var _a;
            (_a = this.props.keyboardShortcutsService) === null || _a === void 0 ? void 0 : _a.deregister(id);
        });
    }
    render() {
        var _a, _b, _c, _d;
        return (_jsxs(_Fragment, { children: [this.state.error && _jsx(DmnMarshallerFallbackError, { error: this.state.error }), this.model && (_jsxs(_Fragment, { children: [_jsx(DmnEditor.DmnEditor, { ref: this.dmnEditorRef, originalVersion: (_a = this.state.marshaller) === null || _a === void 0 ? void 0 : _a.originalVersion, model: this.model, externalModelsByNamespace: this.state.externalModelsByNamespace, evaluationResultsByNodeId: this.state.evaluationResultsByNodeId, validationMessages: [], externalContextName: "", externalContextDescription: "", issueTrackerHref: "", isEvaluationHighlightsSupported: (_b = this.props) === null || _b === void 0 ? void 0 : _b.isEvaluationHighlightsSupported, isReadOnly: this.state.isReadOnly, isImportDataTypesFromJavaClassesSupported: (_c = this.props) === null || _c === void 0 ? void 0 : _c.isImportDataTypesFromJavaClassesSupported, javaCodeCompletionService: (_d = this.props) === null || _d === void 0 ? void 0 : _d.javaCodeCompletionService, onModelChange: this.onModelChange, onOpenedBoxedExpressionEditorNodeChange: this.props.onOpenedBoxedExpressionEditorNodeChange, onRequestExternalModelsAvailableToInclude: this.onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath: this.onRequestExternalModelByPathsRelativeToTheOpenFile, onRequestToJumpToPath: this.onOpenFileFromPathRelativeToTheOpenFile, onRequestToResolvePath: this.onRequestToResolvePathRelativeToTheOpenFile }), _jsx(ExternalModelsManager, { workspaceRootAbsolutePosixPath: this.props.workspaceRootAbsolutePosixPath, thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot: this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot, model: this.model, onChange: this.setExternalModelsByNamespace, onRequestWorkspaceFilesList: this.props.onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: this.props.onRequestWorkspaceFileContent, externalModelsManagerDoneBootstraping: this.externalModelsManagerDoneBootstraping })] }))] }));
    }
}
const NAMESPACES_EFFECT_SEPARATOR = " , ";
function ExternalModelsManager({ workspaceRootAbsolutePosixPath, thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot, model, onChange, onRequestWorkspaceFileContent, onRequestWorkspaceFilesList, externalModelsManagerDoneBootstraping, }) {
    const namespaces = useMemo(() => getIncludedNamespacesFromModel(model.definitions.import), [model.definitions.import]);
    const [externalUpdatesCount, setExternalUpdatesCount] = useState(0);
    useEffect(() => {
        const bc = new BroadcastChannel("workspaces_files");
        bc.onmessage = ({ data }) => {
            if ((data === null || data === void 0 ? void 0 : data.relativePath) === thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            setExternalUpdatesCount((prev) => prev + 1);
        };
        return () => {
            bc.close();
        };
    }, [thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot]);
    const getDmnsByNamespace = useCallback((resources) => {
        var _a;
        const ret = new Map();
        for (let i = 0; i < resources.length; i++) {
            const resource = resources[i];
            if (!resource) {
                continue;
            }
            const content = (_a = resource.content) !== null && _a !== void 0 ? _a : "";
            const ext = __path.extname(resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
            if (ext === ".dmn") {
                const namespace = domParser.getDomDocument(content).documentElement.getAttribute("namespace");
                if (namespace) {
                    if (ret.has(namespace)) {
                        console.warn(`DMN EDITOR ROOT: Multiple DMN models encountered with the same namespace '${namespace}': '${resource.normalizedPosixPathRelativeToTheWorkspaceRoot}' and '${ret.get(namespace).normalizedPosixPathRelativeToTheWorkspaceRoot}'. The latter will be considered.`);
                    }
                    ret.set(namespace, resource);
                }
            }
        }
        return ret;
    }, []);
    useEffect(() => {
        let canceled = false;
        if (!thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot) {
            return;
        }
        onRequestWorkspaceFilesList({ pattern: EXTERNAL_MODELS_SEARCH_GLOB_PATTERN, opts: { type: SearchType.TRAVERSAL } })
            .then((list) => {
            const resources = [];
            for (let i = 0; i < list.normalizedPosixPathsRelativeToTheWorkspaceRoot.length; i++) {
                const normalizedPosixPathRelativeToTheWorkspaceRoot = list.normalizedPosixPathsRelativeToTheWorkspaceRoot[i];
                if (normalizedPosixPathRelativeToTheWorkspaceRoot === thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot ||
                    normalizedPosixPathRelativeToTheWorkspaceRoot.includes(TARGET_DIRECTORY)) {
                    continue;
                }
                resources.push(onRequestWorkspaceFileContent({
                    normalizedPosixPathRelativeToTheWorkspaceRoot,
                    opts: { type: "text" },
                }));
            }
            return Promise.all(resources);
        })
            .then((resources) => {
            var _a;
            const externalModelsIndex = {};
            const namespacesSet = new Set(namespaces.split(NAMESPACES_EFFECT_SEPARATOR));
            const loadedDmnsByPathRelativeToTheWorkspaceRoot = new Set();
            const dmnsByNamespace = getDmnsByNamespace(resources);
            for (let i = 0; i < resources.length; i++) {
                const resource = resources[i];
                if (!resource) {
                    continue;
                }
                const ext = __path.extname(resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                const normalizedPosixPathRelativeToTheOpenFile = __path.relative(__path.dirname(thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot), resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                const resourceContent = (_a = resource.content) !== null && _a !== void 0 ? _a : "";
                if (ext === ".dmn") {
                    const namespaceOfTheResourceFile = domParser
                        .getDomDocument(resourceContent)
                        .documentElement.getAttribute("namespace");
                    if (namespaceOfTheResourceFile && namespacesSet.has(namespaceOfTheResourceFile)) {
                        checkIfNamespaceIsAlreadyLoaded({
                            externalModelsIndex,
                            namespaceOfTheResourceFile,
                            normalizedPosixPathRelativeToTheWorkspaceRoot: resource.normalizedPosixPathRelativeToTheWorkspaceRoot,
                        });
                        loadModel({
                            includedModelContent: resourceContent,
                            includedModelNamespace: namespaceOfTheResourceFile,
                            externalModelsIndex,
                            thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot,
                            loadedDmnsByPathRelativeToTheWorkspaceRoot,
                            normalizedPosixPathRelativeToTheWorkspaceRoot: resource.normalizedPosixPathRelativeToTheWorkspaceRoot,
                            resourcesByNamespace: dmnsByNamespace,
                        });
                    }
                }
                else if (ext === ".pmml") {
                    const namespace = getPmmlNamespace({ normalizedPosixPathRelativeToTheOpenFile });
                    if (namespace && namespacesSet.has(namespace)) {
                        externalModelsIndex[namespace] = {
                            normalizedPosixPathRelativeToTheOpenFile,
                            model: XML2PMML(resourceContent),
                            type: "pmml",
                        };
                    }
                }
                else {
                    throw new Error(`Unknown extension '${ext}'.`);
                }
            }
            if (!canceled) {
                onChange(externalModelsIndex);
            }
            externalModelsManagerDoneBootstraping.resolve();
        });
        return () => {
            canceled = true;
        };
    }, [
        namespaces,
        onChange,
        onRequestWorkspaceFileContent,
        onRequestWorkspaceFilesList,
        thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot,
        externalUpdatesCount,
        workspaceRootAbsolutePosixPath,
        externalModelsManagerDoneBootstraping,
        getDmnsByNamespace,
    ]);
    return _jsx(_Fragment, {});
}
function DmnMarshallerFallbackError({ error }) {
    return (_jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" }, children: _jsxs(EmptyState, { style: { maxWidth: "1280px" }, children: [_jsx(EmptyStateIcon, { icon: () => _jsx("div", { style: { fontSize: "3em" }, children: "\uD83D\uDE15" }) }), _jsx(Title, { size: "lg", headingLevel: "h4", children: "Unable to open file." }), _jsx("br", {}), _jsxs(EmptyStateBody, { children: ["Error details: ", error.message] })] }) }));
}
function getIncludedNamespacesFromModel(imports) {
    return (imports !== null && imports !== void 0 ? imports : []).map((i) => getNamespaceOfDmnImport({ dmnImport: i })).join(NAMESPACES_EFFECT_SEPARATOR);
}
function loadModel(args) {
    const normalizedPosixPathRelativeToTheOpenFile = __path.relative(__path.dirname(args.thisDmnsNormalizedPosixPathRelativeToTheWorkspaceRoot), args.normalizedPosixPathRelativeToTheWorkspaceRoot);
    const includedModel = normalize(getMarshaller(args.includedModelContent, { upgradeTo: "latest" }).parser.parse());
    args.externalModelsIndex[args.includedModelNamespace] = {
        normalizedPosixPathRelativeToTheOpenFile,
        model: includedModel,
        type: "dmn",
        svg: "",
    };
    args.loadedDmnsByPathRelativeToTheWorkspaceRoot.add(args.normalizedPosixPathRelativeToTheWorkspaceRoot);
    loadDependentModels({
        ...args,
        model: includedModel,
    });
}
function loadDependentModels(args) {
    var _a;
    const includedNamespaces = new Set(getIncludedNamespacesFromModel(args.model.definitions.import).split(NAMESPACES_EFFECT_SEPARATOR));
    for (const includedNamespace of includedNamespaces) {
        if (!args.resourcesByNamespace.has(includedNamespace)) {
            console.warn(`DMN EDITOR ROOT: The included namespace '${includedNamespace}' for the model '${args.model.definitions["@_id"]}' can not be found.`);
            continue;
        }
        const resource = args.resourcesByNamespace.get(includedNamespace);
        if (args.loadedDmnsByPathRelativeToTheWorkspaceRoot.has(resource.normalizedPosixPathRelativeToTheWorkspaceRoot)) {
            continue;
        }
        checkIfNamespaceIsAlreadyLoaded({
            externalModelsIndex: args.externalModelsIndex,
            namespaceOfTheResourceFile: includedNamespace,
            normalizedPosixPathRelativeToTheWorkspaceRoot: resource.normalizedPosixPathRelativeToTheWorkspaceRoot,
        });
        loadModel({
            ...args,
            includedModelContent: (_a = resource.content) !== null && _a !== void 0 ? _a : "",
            normalizedPosixPathRelativeToTheWorkspaceRoot: resource.normalizedPosixPathRelativeToTheWorkspaceRoot,
            includedModelNamespace: includedNamespace,
        });
    }
}
function checkIfNamespaceIsAlreadyLoaded(args) {
    if (args.externalModelsIndex[args.namespaceOfTheResourceFile]) {
        console.warn(`DMN EDITOR ROOT: Multiple DMN models encountered with the same namespace '${args.namespaceOfTheResourceFile}': '${args.normalizedPosixPathRelativeToTheWorkspaceRoot}' and '${args.externalModelsIndex[args.namespaceOfTheResourceFile].normalizedPosixPathRelativeToTheOpenFile}'. The latter will be considered.`);
    }
}
//# sourceMappingURL=DmnEditorRoot.js.map