import { jsx as _jsx } from "react/jsx-runtime";
import * as ReactDOM from "react-dom";
import { ComponentDevPane } from "./ComponentDevPane";
import { MessageProperty, MessageType, FunctionResultType, } from "@kie-tools/dashbuilder-component-api";
const DEV_FILE = "/manifest.dev.json";
const COMP_ID = 42;
let initMessage;
let dataSetMessage;
let functions;
function handleDevConf(text) {
    const devConf = JSON.parse(text);
    const devPane = document.createElement("div");
    document.body.prepend(devPane);
    ReactDOM.render(_jsx(ComponentDevPane, { sendDataSet: () => sendMessage(dataSetMessage), sendInit: () => sendMessage(initMessage) }), devPane);
    window.addEventListener("message", (e) => {
        const message = e.data;
        if (message.type === MessageType.FUNCTION_CALL) {
            respondFunctionCall(message);
        }
    });
    functions = devConf.functions;
    createInit(devConf);
    createDataSet(devConf);
    setTimeout(() => {
        sendMessage(initMessage);
        setTimeout(() => {
            sendMessage(dataSetMessage);
        }, 100);
    }, 100);
}
function respondFunctionCall(message) {
    const functionCall = message.properties.get(MessageProperty.FUNCTION_CALL);
    const functionName = functionCall.functionName;
    const confResponse = functions
        ? functions.filter((f) => f.name === functionName).filter((f) => paramsMatch(functionCall.parameters, f.params))[0]
        : undefined;
    console.debug("[COMPONENT DEV] Function response: ");
    console.debug(confResponse);
    let functionResponse;
    if (confResponse === undefined) {
        functionResponse = {
            message: "Function not found",
            request: functionCall,
            resultType: FunctionResultType.NOT_FOUND,
            result: undefined,
        };
    }
    else if (confResponse.response === "ERROR") {
        functionResponse = {
            message: "Function Error!",
            request: functionCall,
            resultType: FunctionResultType.ERROR,
            result: undefined,
        };
    }
    else {
        functionResponse = {
            message: "Success!",
            request: functionCall,
            resultType: FunctionResultType.SUCCESS,
            result: confResponse.response,
        };
    }
    const props = new Map();
    props.set(MessageProperty.FUNCTION_RESPONSE, functionResponse);
    sendMessage({
        type: MessageType.FUNCTION_RESPONSE,
        properties: props,
    });
}
function createInit(devConf) {
    const props = new Map();
    devConf.init.forEach((prop) => props.set(prop.key, prop.value));
    initMessage = {
        type: MessageType.INIT,
        properties: props,
    };
}
function createDataSet(devConf) {
    const props = new Map();
    devConf.init.forEach((prop) => props.set(prop.key, prop.value));
    props.set(MessageProperty.DATASET, devConf.dataSet);
    dataSetMessage = {
        type: MessageType.DATASET,
        properties: props,
    };
}
function paramsMatch(requestParams, devParams) {
    const devParamsEmpty = !devParams || devParams.length === 0;
    const requestParamsEmpty = !requestParams || requestParams.size === 0;
    const allMatch = devParams && requestParams
        ? !devParamsEmpty && devParams.every((p) => requestParams.get(p.key) === p.value)
        : false;
    return (devParamsEmpty && requestParamsEmpty) || allMatch;
}
function sendMessage(message) {
    console.debug("[COMPONENT DEV] Sending Message");
    console.debug(message);
    message.properties.set(MessageProperty.COMPONENT_ID, COMP_ID);
    window.postMessage(message, window.location.href);
}
export class ComponentDev {
    start() {
        fetch(DEV_FILE)
            .then((r) => r.text())
            .then((text) => handleDevConf(text))
            .catch((e) => console.log("Not able to load manifest DEV file: " + e));
    }
}
//# sourceMappingURL=index.js.map