import { renameDrgElement } from "./renameNode";
import { setDrgElementExpression } from "./setDrgElementExpression";
import { updateDrgElementType } from "./updateDrgElementType";
export function updateExpression({ definitions, expression, drgElementIndex, externalDmnModelsByNamespaceMap, }) {
    var _a, _b;
    const drgElement = (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex];
    if (!drgElement) {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that doesn't exist.");
    }
    renameDrgElement({
        definitions,
        newName: (_b = expression === null || expression === void 0 ? void 0 : expression["@_label"]) !== null && _b !== void 0 ? _b : drgElement["@_name"],
        index: drgElementIndex,
        externalDmnModelsByNamespaceMap,
        shouldRenameReferencedExpressions: false,
    });
    setDrgElementExpression({
        definitions,
        expression,
        drgElementIndex,
    });
    updateDrgElementType({
        definitions,
        expression,
        drgElementIndex,
    });
}
//# sourceMappingURL=updateExpression.js.map