import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { IdentifiersRefactor } from "@kie-tools/dmn-language-service";
export function renameDrgElement({ definitions, newName, index, externalDmnModelsByNamespaceMap, shouldRenameReferencedExpressions, }) {
    var _a;
    const trimmedNewName = newName.trim();
    const drgElement = definitions.drgElement[index];
    const identifiersRefactor = new IdentifiersRefactor({
        writeableDmnDefinitions: definitions,
        _readonly_externalDmnModelsByNamespaceMap: externalDmnModelsByNamespaceMap,
    });
    drgElement["@_name"] = trimmedNewName;
    if (drgElement.__$$element !== "knowledgeSource") {
        (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": trimmedNewName });
        drgElement.variable["@_name"] = trimmedNewName;
    }
    if (drgElement.__$$element === "decision" && drgElement.expression) {
        drgElement.expression["@_label"] = trimmedNewName;
    }
    if (drgElement.__$$element === "businessKnowledgeModel" && drgElement.encapsulatedLogic) {
        drgElement.encapsulatedLogic["@_label"] = trimmedNewName;
    }
    if (shouldRenameReferencedExpressions) {
        identifiersRefactor.rename({ identifierUuid: drgElement["@_id"], newName: trimmedNewName });
    }
}
export function renameGroupNode({ definitions, newName, index, }) {
    definitions.artifact[index]["@_name"] = newName;
}
export function updateTextAnnotation({ definitions, newText, index, }) {
    definitions.artifact[index].text = { __$$text: newText };
}
//# sourceMappingURL=renameNode.js.map