import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { snapPoint } from "../SnapGrid";
import { EDGE_TYPES } from "../edges/EdgeTypes";
import { AssociationPath, AuthorityRequirementPath, InformationRequirementPath, KnowledgeRequirementPath, } from "../edges/Edges";
import { NODE_TYPES } from "../nodes/NodeTypes";
import { getPositionalHandlePosition } from "../maths/Maths";
import { DecisionNodeSvg, BkmNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg } from "../nodes/NodeSvgs";
import { pointsToPath } from "../maths/DmnMaths";
import { getBoundsCenterPoint } from "../maths/Maths";
import { getDefaultEdgeTypeBetween } from "./graphStructure";
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { DEFAULT_NODE_SIZES } from "../nodes/DefaultSizes";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useKieEdgePath } from "../edges/useKieEdgePath";
import { PositionalNodeHandleId } from "./PositionalNodeHandles";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function ConnectionLine({ toX, toY, fromNode, fromHandle }) {
    var _a, _b, _c;
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const { externalModelsByNamespace } = useExternalModels();
    const edgeBeingUpdated = useDmnEditorStore((s) => s.diagram.edgeIdBeingUpdated
        ? s.computed(s).getDiagramData(externalModelsByNamespace).edgesById.get(s.diagram.edgeIdBeingUpdated)
        : undefined);
    const kieEdgePath = useKieEdgePath(edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.source, edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.target, edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.data);
    const isAlternativeInputDataShape = useDmnEditorStore((s) => s.computed(s).isAlternativeInputDataShape());
    const isUpdatingFromSourceHandle = Object.keys(PositionalNodeHandleId).some((k) => PositionalNodeHandleId[k] === (fromHandle === null || fromHandle === void 0 ? void 0 : fromHandle.id));
    const { "@_x": fromX, "@_y": fromY } = getBoundsCenterPoint({
        x: (_a = fromNode === null || fromNode === void 0 ? void 0 : fromNode.positionAbsolute) === null || _a === void 0 ? void 0 : _a.x,
        y: (_b = fromNode === null || fromNode === void 0 ? void 0 : fromNode.positionAbsolute) === null || _b === void 0 ? void 0 : _b.y,
        width: fromNode === null || fromNode === void 0 ? void 0 : fromNode.width,
        height: fromNode === null || fromNode === void 0 ? void 0 : fromNode.height,
    });
    const connectionLinePath = edgeBeingUpdated && kieEdgePath.points
        ? isUpdatingFromSourceHandle
            ? pointsToPath([{ "@_x": toX, "@_y": toY }, ...kieEdgePath.points.slice(1)])
            : pointsToPath([...kieEdgePath.points.slice(0, -1), { "@_x": toX, "@_y": toY }])
        : `M${fromX},${fromY} L${toX},${toY}`;
    const handleId = isUpdatingFromSourceHandle ? edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.type : (_c = edgeBeingUpdated === null || edgeBeingUpdated === void 0 ? void 0 : edgeBeingUpdated.type) !== null && _c !== void 0 ? _c : fromHandle === null || fromHandle === void 0 ? void 0 : fromHandle.id;
    if (handleId === EDGE_TYPES.informationRequirement) {
        return _jsx(InformationRequirementPath, { d: connectionLinePath });
    }
    else if (handleId === EDGE_TYPES.knowledgeRequirement) {
        return _jsx(KnowledgeRequirementPath, { d: connectionLinePath });
    }
    else if (handleId === EDGE_TYPES.authorityRequirement) {
        return _jsx(AuthorityRequirementPath, { d: connectionLinePath, centerToConnectionPoint: true });
    }
    else if (handleId === EDGE_TYPES.association) {
        return _jsx(AssociationPath, { d: connectionLinePath });
    }
    else {
        const nodeType = handleId;
        const { "@_x": toXsnapped, "@_y": toYsnapped } = snapPoint(snapGrid, { "@_x": toX, "@_y": toY });
        const defaultSize = DEFAULT_NODE_SIZES[nodeType]({ snapGrid, isAlternativeInputDataShape });
        const [toXauto, toYauto] = getPositionalHandlePosition({ x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"] }, { x: fromX, y: fromY, width: 1, height: 1 });
        const edgeType = getDefaultEdgeTypeBetween(fromNode === null || fromNode === void 0 ? void 0 : fromNode.type, handleId);
        if (!edgeType) {
            throw new Error(`Invalid structure: ${fromNode === null || fromNode === void 0 ? void 0 : fromNode.type} --(any)--> ${handleId}`);
        }
        const path = `M${fromX},${fromY} L${toXauto},${toYauto}`;
        const edgeSvg = switchExpression(edgeType, {
            [EDGE_TYPES.informationRequirement]: _jsx(InformationRequirementPath, { d: path }),
            [EDGE_TYPES.knowledgeRequirement]: _jsx(KnowledgeRequirementPath, { d: path }),
            [EDGE_TYPES.authorityRequirement]: _jsx(AuthorityRequirementPath, { d: path, centerToConnectionPoint: false }),
            [EDGE_TYPES.association]: _jsx(AssociationPath, { d: path }),
        });
        if (nodeType === NODE_TYPES.decision) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(DecisionNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], isCollection: false, hasHiddenRequirements: false })] }));
        }
        else if (nodeType === NODE_TYPES.bkm) {
            return (_jsxs("g", { className: "pulse", children: [edgeSvg, _jsx(BkmNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], hasHiddenRequirements: false })] }));
        }
        else if (nodeType === NODE_TYPES.knowledgeSource) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(KnowledgeSourceNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"], hasHiddenRequirements: false })] }));
        }
        else if (nodeType === NODE_TYPES.textAnnotation) {
            return (_jsxs("g", { children: [edgeSvg, _jsx(TextAnnotationNodeSvg, { x: toXsnapped, y: toYsnapped, width: defaultSize["@_width"], height: defaultSize["@_height"] })] }));
        }
    }
    throw new Error(`Unknown source of ConnectionLine '${handleId}'.`);
}
//# sourceMappingURL=ConnectionLine.js.map