import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import OptimizeIcon from "@patternfly/react-icons/dist/js/icons/optimize-icon";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { getAutoLayoutedInfo } from "./autoLayoutInfo";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { applyAutoLayoutToDrd } from "../mutations/applyAutoLayoutToDrd";
export function AutolayoutButton() {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const onClick = React.useCallback(async () => {
        const state = dmnEditorStoreApi.getState();
        const snapGrid = state.diagram.snapGrid;
        const nodesById = state.computed(state).getDiagramData(externalModelsByNamespace).nodesById;
        const edgesById = state.computed(state).getDiagramData(externalModelsByNamespace).edgesById;
        const nodes = state.computed(state).getDiagramData(externalModelsByNamespace).nodes;
        const drgEdges = state.computed(state).getDiagramData(externalModelsByNamespace).drgEdges;
        const isAlternativeInputDataShape = state.computed(state).isAlternativeInputDataShape();
        const { __readonly_autoLayoutedInfo, __readonly_parentNodesById } = await getAutoLayoutedInfo({
            __readonly_snapGrid: snapGrid,
            __readonly_nodesById: nodesById,
            __readonly_edgesById: edgesById,
            __readonly_nodes: nodes,
            __readonly_drgEdges: drgEdges,
            __readonly_isAlternativeInputDataShape: isAlternativeInputDataShape,
        });
        dmnEditorStoreApi.setState((s) => {
            applyAutoLayoutToDrd({
                state: s,
                __readonly_dmnShapesByHref: s.computed(s).indexedDrd().dmnShapesByHref,
                __readonly_edges: s.computed(s).getDiagramData(externalModelsByNamespace).edges,
                __readonly_edgesById: s.computed(s).getDiagramData(externalModelsByNamespace).edgesById,
                __readonly_nodesById: s.computed(s).getDiagramData(externalModelsByNamespace).nodesById,
                __readonly_autoLayoutedInfo,
                __readonly_parentNodesById,
                __readonly_drdIndex: s.computed(s).getDrdIndex(),
                __readonly_dmnObjectNamespace: s.dmn.model.definitions["@_namespace"],
                __readonly_externalDmnsIndex: s
                    .computed(s)
                    .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                __readonly_externalModelsByNamespace: externalModelsByNamespace,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace]);
    return (_jsx("button", { className: "kie-dmn-editor--autolayout-panel-toggle-button", onClick: onClick, title: "Autolayout (beta)", children: _jsx(OptimizeIcon, {}) }));
}
//# sourceMappingURL=AutolayoutButton.js.map