/*! For license information please see monaco.min.js.LICENSE.txt */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.monaco=t():e.monaco=t()}(self,(()=>(()=>{"use strict";var e={8419:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar {\n\twhite-space: nowrap;\n\theight: 100%;\n}\n\n.monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\theight: 100%;\n\twidth: 100%;\n\talign-items: center;\n}\n\n.monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-action-bar .action-item {\n\tdisplay: block;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: pointer;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .icon,\n.monaco-action-bar .action-item .codicon {\n\tdisplay: block;\n}\n\n.monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n\twidth: 16px;\n\theight: 16px;\n}\n\n.monaco-action-bar .action-label {\n\tdisplay: flex;\n\tfont-size: 11px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-action-bar .action-item.disabled .action-label,\n.monaco-action-bar .action-item.disabled .action-label::before,\n.monaco-action-bar .action-item.disabled .action-label:hover {\n\topacity: 0.6;\n}\n\n/* Vertical actions */\n\n.monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid #bbb;\n\tpadding-top: 1px;\n\tmargin-left: .8em;\n\tmargin-right: .8em;\n}\n\n.monaco-action-bar .action-item .action-label.separator {\n\twidth: 1px;\n\theight: 16px;\n\tmargin: 5px 4px !important;\n\tcursor: default;\n\tmin-width: 1px;\n\tpadding: 0;\n\tbackground-color: #bbb;\n}\n\n.secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item {\n\tdisplay: flex;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-dropdown-item-separator {\n\tdisplay: flex;\n\talign-items: center;\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-dropdown-item-separator > div {\n\twidth: 1px;\n}\n",""]);const s=o},9891:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-aria-container {\n\tposition: absolute; /* try to hide from window but not from screen readers */\n\tleft:-999em;\n}",""]);const s=o},9041:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-text-button {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\twidth: 100%;\n\tpadding: 4px;\n\tborder-radius: 2px;\n\ttext-align: center;\n\tcursor: pointer;\n\tjustify-content: center;\n\talign-items: center;\n\tborder: 1px solid var(--vscode-button-border, transparent);\n\tline-height: 18px;\n}\n\n.monaco-text-button:focus {\n\toutline-offset: 2px !important;\n}\n\n.monaco-text-button:hover {\n\ttext-decoration: none !important;\n}\n\n.monaco-button.disabled:focus,\n.monaco-button.disabled {\n\topacity: 0.4 !important;\n\tcursor: default;\n}\n\n.monaco-text-button .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label {\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\tpadding: 0 4px;\n\toverflow: hidden;\n\theight: 28px;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label {\n\tflex-basis: 100%;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label-short {\n\tflex-grow: 1;\n\twidth: 0;\n\toverflow: hidden;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label,\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label-short {\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n\tfont-weight: normal;\n\tfont-style: inherit;\n\tpadding: 4px 0;\n}\n\n.monaco-button-dropdown {\n\tdisplay: flex;\n\tcursor: pointer;\n}\n\n.monaco-button-dropdown.disabled {\n\tcursor: default;\n}\n\n.monaco-button-dropdown > .monaco-button:focus {\n\toutline-offset: -1px !important;\n}\n\n.monaco-button-dropdown.disabled > .monaco-button.disabled,\n.monaco-button-dropdown.disabled > .monaco-button.disabled:focus,\n.monaco-button-dropdown.disabled > .monaco-button-dropdown-separator {\n\topacity: 0.4 !important;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-text-button {\n\tborder-right-width: 0 !important;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator {\n\tpadding: 4px 0;\n\tcursor: default;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator > div {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-dropdown-button {\n\tborder: 1px solid var(--vscode-button-border, transparent);\n\tborder-left-width: 0 !important;\n\tborder-radius: 0 2px 2px 0;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-text-button {\n\tborder-radius: 2px 0 0 2px;\n}\n\n.monaco-description-button {\n\tdisplay: flex;\n\tflex-direction: column;\n\talign-items: center;\n\tmargin: 4px 5px; /* allows button focus outline to be visible */\n}\n\n.monaco-description-button .monaco-button-description {\n\tfont-style: italic;\n\tfont-size: 11px;\n\tpadding: 4px 20px;\n}\n\n.monaco-description-button .monaco-button-label,\n.monaco-description-button .monaco-button-description {\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-description-button .monaco-button-label > .codicon,\n.monaco-description-button .monaco-button-description > .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n",""]);const s=o},2069:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.codicon-wrench-subaction {\n\topacity: 0.5;\n}\n\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n\n.codicon-sync.codicon-modifier-spin,\n.codicon-loading.codicon-modifier-spin,\n.codicon-gear.codicon-modifier-spin,\n.codicon-notebook-state-executing.codicon-modifier-spin {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.5s steps(30) infinite;\n}\n\n.codicon-modifier-disabled {\n\topacity: 0.4;\n}\n\n/* custom speed & easing for loading icon */\n.codicon-loading,\n.codicon-tree-item-loading::before {\n\tanimation-duration: 1s !important;\n\tanimation-timing-function: cubic-bezier(0.53, 0.21, 0.29, 0.67) !important;\n}\n",""]);const s=o},52:(e,t,i)=>{i.d(t,{A:()=>c});var n=i(7305),o=i.n(n),s=i(4964),r=i.n(s),a=i(6066),l=o()((function(e){return e[1]})),h=r()(a.A);l.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n@font-face {\n\tfont-family: "codicon";\n\tfont-display: block;\n\tsrc: url('+h+") format(\"truetype\");\n}\n\n.codicon[class*='codicon-'] {\n\tfont: normal normal normal 16px/1 codicon;\n\tdisplay: inline-block;\n\ttext-decoration: none;\n\ttext-rendering: auto;\n\ttext-align: center;\n\ttext-transform: none;\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/* icon rules are dynamically created by the platform theme service (see iconsStyleSheet.ts) */\n",""]);const c=l},527:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.context-view {\n\tposition: absolute;\n}\n\n.context-view.fixed {\n\tall: initial;\n\tfont-family: inherit;\n\tfont-size: 13px;\n\tposition: fixed;\n\tcolor: inherit;\n}\n",""]);const s=o},1757:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-count-badge {\n\tpadding: 3px 6px;\n\tborder-radius: 11px;\n\tfont-size: 11px;\n\tmin-width: 18px;\n\tmin-height: 18px;\n\tline-height: 11px;\n\tfont-weight: normal;\n\ttext-align: center;\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n}\n\n.monaco-count-badge.long {\n\tpadding: 2px 3px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n",""]);const s=o},3795:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-dropdown {\n\theight: 100%;\n\tpadding: 0;\n}\n\n.monaco-dropdown > .dropdown-label {\n\tcursor: pointer;\n\theight: 100%;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-dropdown > .dropdown-label > .action-label.disabled {\n\tcursor: default;\n}\n\n.monaco-dropdown-with-primary {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-primary > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]);const s=o},543:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- Find input ---------- */\n\n.monaco-findInput {\n\tposition: relative;\n}\n\n.monaco-findInput .monaco-inputbox {\n\tfont-size: 13px;\n\twidth: 100%;\n}\n\n.monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n.vs .monaco-findInput.disabled {\n\tbackground-color: #E1E1E1;\n}\n\n/* Theming */\n.vs-dark .monaco-findInput.disabled {\n\tbackground-color: #333;\n}\n\n/* Highlighting */\n.monaco-findInput.highlight-0 .controls,\n.hc-light .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-0 100ms linear 0s;\n}\n\n.monaco-findInput.highlight-1 .controls,\n.hc-light .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-1 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-0 .controls,\n.vs-dark  .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-dark-0 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-1 .controls,\n.vs-dark  .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-dark-1 100ms linear 0s;\n}\n\n@keyframes monaco-findInput-highlight-0 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-1 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n\n@keyframes monaco-findInput-highlight-dark-0 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-dark-1 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n",""]);const s=o},7203:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* ---------- Icon label ---------- */\n\n.monaco-icon-label {\n\tdisplay: flex; /* required for icons support :before rule */\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-icon-label::before {\n\n\t/* svg icons rendered as background image */\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tline-height: inherit !important;\n\tdisplay: inline-block;\n\n\t/* fonts icons */\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tvertical-align: top;\n\n\tflex-shrink: 0; /* fix for https://github.com/microsoft/vscode/issues/13787 */\n}\n\n.monaco-icon-label-container.disabled {\n\tcolor: var(--vscode-disabledForeground);\n}\n.monaco-icon-label > .monaco-icon-label-container {\n\tmin-width: 0;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tflex: 1;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name {\n\tcolor: inherit;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name > .label-separator {\n\tmargin: 0 2px;\n\topacity: 0.5;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .7;\n\tmargin-left: 0.5em;\n\tfont-size: 0.9em;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label.nowrap > .monaco-icon-label-container > .monaco-icon-description-container > .label-description{\n\twhite-space: nowrap\n}\n\n.vs .monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .95;\n}\n\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.deprecated {\n\ttext-decoration: line-through;\n\topacity: 0.66;\n}\n\n/* make sure apply italic font style to decorations as well */\n.monaco-icon-label.italic::after {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\ttext-decoration: line-through;\n}\n\n.monaco-icon-label::after {\n\topacity: 0.75;\n\tfont-size: 90%;\n\tfont-weight: 600;\n\tmargin: auto 16px 0 5px; /* https://github.com/microsoft/vscode/issues/113223 */\n\ttext-align: center;\n}\n\n/* make sure selection color wins when a label is being selected */\n.monaco-list:focus .selected .monaco-icon-label, /* list */\n.monaco-list:focus .selected .monaco-icon-label::after\n{\n\tcolor: inherit !important;\n}\n\n.monaco-list-row.focused.selected .label-description,\n.monaco-list-row.selected .label-description {\n\topacity: .8;\n}\n",""]);const s=o},4283:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-inputbox {\n\tposition: relative;\n\tdisplay: block;\n\tpadding: 0;\n\tbox-sizing:\tborder-box;\n\tborder-radius: 2px;\n\n\t/* Customizable */\n\tfont-size: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > .input,\n.monaco-inputbox > .ibwrapper > .mirror {\n\n\t/* Customizable */\n\tpadding: 4px 6px;\n}\n\n.monaco-inputbox > .ibwrapper {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-inputbox > .ibwrapper > .input {\n\tdisplay: inline-block;\n\tbox-sizing:\tborder-box;\n\twidth: 100%;\n\theight: 100%;\n\tline-height: inherit;\n\tborder: none;\n\tfont-family: inherit;\n\tfont-size: inherit;\n\tresize: none;\n\tcolor: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > input {\n\ttext-overflow: ellipsis;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input {\n\tdisplay: block;\n\tscrollbar-width: none; /* Firefox: hide scrollbars */\n\toutline: none;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input::-webkit-scrollbar {\n\tdisplay: none; /* Chrome + Safari: hide scrollbar */\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input.empty {\n\twhite-space: nowrap;\n}\n\n.monaco-inputbox > .ibwrapper > .mirror {\n\tposition: absolute;\n\tdisplay: inline-block;\n\twidth: 100%;\n\ttop: 0;\n\tleft: 0;\n\tbox-sizing: border-box;\n\twhite-space: pre-wrap;\n\tvisibility: hidden;\n\tword-wrap: break-word;\n}\n\n/* Context view */\n\n.monaco-inputbox-container {\n\ttext-align: right;\n}\n\n.monaco-inputbox-container .monaco-inputbox-message {\n\tdisplay: inline-block;\n\toverflow: hidden;\n\ttext-align: left;\n\twidth: 100%;\n\tbox-sizing:\tborder-box;\n\tpadding: 0.4em;\n\tfont-size: 12px;\n\tline-height: 17px;\n\tmargin-top: -1px;\n\tword-wrap: break-word;\n}\n\n/* Action bar support */\n.monaco-inputbox .monaco-action-bar {\n\tposition: absolute;\n\tright: 2px;\n\ttop: 4px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item {\n\tmargin-left: 2px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item .codicon {\n\tbackground-repeat: no-repeat;\n\twidth: 16px;\n\theight: 16px;\n}\n",""]);const s=o},3451:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-keybinding {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 10px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tdisplay: inline-block;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tvertical-align: middle;\n\tfont-size: 11px;\n\tpadding: 3px 5px;\n\tmargin: 0 2px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:first-child {\n\tmargin-left: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:last-child {\n\tmargin-right: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-separator {\n\tdisplay: inline-block;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-chord-separator {\n\twidth: 6px;\n}\n",""]);const s=o},5557:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-list {\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-list.mouse-support {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n.monaco-list > .monaco-scrollable-element {\n\theight: 100%;\n}\n\n.monaco-list-rows {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-list.horizontal-scrolling .monaco-list-rows {\n\twidth: auto;\n\tmin-width: 100%;\n}\n\n.monaco-list-row {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\twidth: 100%;\n}\n\n.monaco-list.mouse-support .monaco-list-row {\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n/* for OS X ballistic scrolling */\n.monaco-list-row.scrolling {\n\tdisplay: none !important;\n}\n\n/* Focus */\n.monaco-list.element-focused,\n.monaco-list.selection-single,\n.monaco-list.selection-multiple {\n\toutline: 0 !important;\n}\n\n/* Dnd */\n.monaco-drag-image {\n\tdisplay: inline-block;\n\tpadding: 1px 7px;\n\tborder-radius: 10px;\n\tfont-size: 12px;\n\tposition: absolute;\n\tz-index: 1000;\n}\n\n/* Filter */\n\n.monaco-list-type-filter-message {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\twidth: 100%;\n\theight: 100%;\n\ttop: 0;\n\tleft: 0;\n\tpadding: 40px 1em 1em 1em;\n\ttext-align: center;\n\twhite-space: normal;\n\topacity: 0.7;\n\tpointer-events: none;\n}\n\n.monaco-list-type-filter-message:empty {\n\tdisplay: none;\n}\n",""]);const s=o},5159:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-mouse-cursor-text {\n\tcursor: text;\n}\n",""]);const s=o},3175:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-progress-container {\n\twidth: 100%;\n\theight: 5px;\n\toverflow: hidden; /* keep progress bit in bounds */\n}\n\n.monaco-progress-container .progress-bit {\n\twidth: 2%;\n\theight: 5px;\n\tposition: absolute;\n\tleft: 0;\n\tdisplay: none;\n}\n\n.monaco-progress-container.active .progress-bit {\n\tdisplay: inherit;\n}\n\n.monaco-progress-container.discrete .progress-bit {\n\tleft: 0;\n\ttransition: width 100ms linear;\n}\n\n.monaco-progress-container.discrete.done .progress-bit {\n\twidth: 100%;\n}\n\n.monaco-progress-container.infinite .progress-bit {\n\tanimation-name: progress;\n\tanimation-duration: 4s;\n\tanimation-iteration-count: infinite;\n\ttransform: translate3d(0px, 0px, 0px);\n\tanimation-timing-function: linear;\n}\n\n.monaco-progress-container.infinite.infinite-long-running .progress-bit {\n\t/*\n\t\tThe more smooth `linear` timing function can cause\n\t\thigher GPU consumption as indicated in\n\t\thttps://github.com/microsoft/vscode/issues/97900 &\n\t\thttps://github.com/microsoft/vscode/issues/138396\n\t*/\n\tanimation-timing-function: steps(100);\n}\n\n/**\n * The progress bit has a width: 2% (1/50) of the parent container. The animation moves it from 0% to 100% of\n * that container. Since translateX is relative to the progress bit size, we have to multiple it with\n * its relative size to the parent container:\n * parent width: 5000%\n *    bit width: 100%\n * translateX should be as follow:\n *  50%: 5000% * 50% - 50% (set to center) = 2450%\n * 100%: 5000% * 100% - 100% (do not overflow) = 4900%\n */\n@keyframes progress { from { transform: translateX(0%) scaleX(1) } 50% { transform: translateX(2500%) scaleX(3) } to { transform: translateX(4900%) scaleX(1) } }\n",""]);const s=o},55:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n:root {\n\t--vscode-sash-size: 4px;\n}\n\n.monaco-sash {\n\tposition: absolute;\n\tz-index: 35;\n\ttouch-action: none;\n}\n\n.monaco-sash.disabled {\n\tpointer-events: none;\n}\n\n.monaco-sash.mac.vertical {\n\tcursor: col-resize;\n}\n\n.monaco-sash.vertical.minimum {\n\tcursor: e-resize;\n}\n\n.monaco-sash.vertical.maximum {\n\tcursor: w-resize;\n}\n\n.monaco-sash.mac.horizontal {\n\tcursor: row-resize;\n}\n\n.monaco-sash.horizontal.minimum {\n\tcursor: s-resize;\n}\n\n.monaco-sash.horizontal.maximum {\n\tcursor: n-resize;\n}\n\n.monaco-sash.disabled {\n\tcursor: default !important;\n\tpointer-events: none !important;\n}\n\n.monaco-sash.vertical {\n\tcursor: ew-resize;\n\ttop: 0;\n\twidth: var(--vscode-sash-size);\n\theight: 100%;\n}\n\n.monaco-sash.horizontal {\n\tcursor: ns-resize;\n\tleft: 0;\n\twidth: 100%;\n\theight: var(--vscode-sash-size);\n}\n\n.monaco-sash:not(.disabled) > .orthogonal-drag-handle {\n\tcontent: \" \";\n\theight: calc(var(--vscode-sash-size) * 2);\n\twidth: calc(var(--vscode-sash-size) * 2);\n\tz-index: 100;\n\tdisplay: block;\n\tcursor: all-scroll;\n\tposition: absolute;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.start,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.end {\n\tcursor: nwse-resize;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.end,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.start {\n\tcursor: nesw-resize;\n}\n\n.monaco-sash.vertical > .orthogonal-drag-handle.start {\n\tleft: calc(var(--vscode-sash-size) * -0.5);\n\ttop: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.vertical > .orthogonal-drag-handle.end {\n\tleft: calc(var(--vscode-sash-size) * -0.5);\n\tbottom: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.start {\n\ttop: calc(var(--vscode-sash-size) * -0.5);\n\tleft: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.end {\n\ttop: calc(var(--vscode-sash-size) * -0.5);\n\tright: calc(var(--vscode-sash-size) * -1);\n}\n\n.monaco-sash:before {\n\tcontent: '';\n\tpointer-events: none;\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tbackground: transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-sash:before {\n\ttransition: background-color 0.1s ease-out;\n}\n\n.monaco-sash.hover:before,\n.monaco-sash.active:before {\n\tbackground: var(--vscode-sash-hoverBorder);\n}\n\n.monaco-sash.vertical:before {\n\twidth: var(--vscode-sash-hover-size);\n\tleft: calc(50% - (var(--vscode-sash-hover-size) / 2));\n}\n\n.monaco-sash.horizontal:before {\n\theight: var(--vscode-sash-hover-size);\n\ttop: calc(50% - (var(--vscode-sash-hover-size) / 2));\n}\n\n.pointer-events-disabled {\n\tpointer-events: none !important;\n}\n\n/** Debug **/\n\n.monaco-sash.debug {\n\tbackground: cyan;\n}\n\n.monaco-sash.debug.disabled {\n\tbackground: rgba(0, 255, 255, 0.2);\n}\n\n.monaco-sash.debug:not(.disabled) > .orthogonal-drag-handle {\n\tbackground: red;\n}\n",""]);const s=o},3487:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Arrows */\n.monaco-scrollable-element > .scrollbar > .scra {\n\tcursor: pointer;\n\tfont-size: 11px !important;\n}\n\n.monaco-scrollable-element > .visible {\n\topacity: 1;\n\n\t/* Background rule added for IE9 - to allow clicks on dom node */\n\tbackground:rgba(0,0,0,0);\n\n\ttransition: opacity 100ms linear;\n\t/* In front of peek view */\n\tz-index: 11;\n}\n.monaco-scrollable-element > .invisible {\n\topacity: 0;\n\tpointer-events: none;\n}\n.monaco-scrollable-element > .invisible.fade {\n\ttransition: opacity 800ms linear;\n}\n\n/* Scrollable Content Inset Shadow */\n.monaco-scrollable-element > .shadow {\n\tposition: absolute;\n\tdisplay: none;\n}\n.monaco-scrollable-element > .shadow.top {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 3px;\n\theight: 3px;\n\twidth: 100%;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 6px 6px -6px inset;\n}\n.monaco-scrollable-element > .shadow.left {\n\tdisplay: block;\n\ttop: 3px;\n\tleft: 0;\n\theight: 100%;\n\twidth: 3px;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 6px 0 6px -6px inset;\n}\n.monaco-scrollable-element > .shadow.top-left-corner {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 0;\n\theight: 3px;\n\twidth: 3px;\n}\n.monaco-scrollable-element > .shadow.top.left {\n\tbox-shadow: var(--vscode-scrollbar-shadow) 6px 0 6px -6px inset;\n}\n\n.monaco-scrollable-element > .scrollbar > .slider {\n\tbackground: var(--vscode-scrollbarSlider-background);\n}\n\n.monaco-scrollable-element > .scrollbar > .slider:hover {\n\tbackground: var(--vscode-scrollbarSlider-hoverBackground);\n}\n\n.monaco-scrollable-element > .scrollbar > .slider.active {\n\tbackground: var(--vscode-scrollbarSlider-activeBackground);\n}\n",""]);const s=o},7611:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-select-box {\n\twidth: 100%;\n\tcursor: pointer;\n\tborder-radius: 2px;\n}\n\n.monaco-select-box-dropdown-container {\n\tfont-size: 13px;\n\tfont-weight: normal;\n\ttext-transform: none;\n}\n\n/** Actions */\n\n.monaco-action-bar .action-item.select-container {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .monaco-select-box {\n\tcursor: pointer;\n\tmin-width: 100px;\n\tmin-height: 18px;\n\tpadding: 2px 23px 2px 8px;\n}\n\n.mac .monaco-action-bar .action-item .monaco-select-box {\n\tfont-size: 11px;\n\tborder-radius: 5px;\n}\n",""]);const s=o},8014:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Use custom CSS vars to expose padding into parent select for padding calculation */\n.monaco-select-box-dropdown-padding {\n\t--dropdown-padding-top: 1px;\n\t--dropdown-padding-bottom: 1px;\n}\n\n.hc-black .monaco-select-box-dropdown-padding,\n.hc-light .monaco-select-box-dropdown-padding {\n\t--dropdown-padding-top: 3px;\n\t--dropdown-padding-bottom: 4px;\n}\n\n.monaco-select-box-dropdown-container {\n\tdisplay: none;\n\tbox-sizing:\tborder-box;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown * {\n\tmargin: 0;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown a:focus {\n\toutline: 1px solid -webkit-focus-ring-color;\n\toutline-offset: -1px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown code {\n\tline-height: 15px; /** For some reason, this is needed, otherwise <code> will take up 20px height */\n\tfont-family: var(--monaco-monospace-font);\n}\n\n\n.monaco-select-box-dropdown-container.visible {\n\tdisplay: flex;\n\tflex-direction: column;\n\ttext-align: left;\n\twidth: 1px;\n\toverflow: hidden;\n\tborder-bottom-left-radius: 3px;\n\tborder-bottom-right-radius: 3px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container {\n\tflex: 0 0 auto;\n\talign-self: flex-start;\n\tpadding-top: var(--dropdown-padding-top);\n\tpadding-bottom: var(--dropdown-padding-bottom);\n\tpadding-left: 1px;\n\tpadding-right: 1px;\n\twidth: 100%;\n\toverflow: hidden;\n\tbox-sizing:\tborder-box;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane {\n\tpadding: 5px;\n}\n\n.hc-black .monaco-select-box-dropdown-container > .select-box-dropdown-list-container {\n\tpadding-top: var(--dropdown-padding-top);\n\tpadding-bottom: var(--dropdown-padding-bottom);\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row {\n\tcursor: pointer;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-text {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-left: 3.5px;\n\twhite-space: nowrap;\n\tfloat: left;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-detail {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-left: 3.5px;\n\twhite-space: nowrap;\n\tfloat: left;\n\topacity: 0.7;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-decorator-right {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-right: 10px;\n\twhite-space: nowrap;\n\tfloat: right;\n}\n\n\n/* Accepted CSS hiding technique for accessibility reader text  */\n/* https://webaim.org/techniques/css/invisiblecontent/ */\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .visually-hidden {\n\t\tposition: absolute;\n\t\tleft: -10000px;\n\t\ttop: auto;\n\t\twidth: 1px;\n\t\theight: 1px;\n\t\toverflow: hidden;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control {\n\tflex: 1 1 auto;\n\talign-self: flex-start;\n\topacity: 0;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control > .width-control-div {\n\toverflow: hidden;\n\tmax-height: 0px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control > .width-control-div > .option-text-width-control {\n\tpadding-left: 4px;\n\tpadding-right: 8px;\n\twhite-space: nowrap;\n}\n",""]);const s=o},3191:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-split-view2 {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .sash-container {\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tpointer-events: none;\n}\n\n.monaco-split-view2 > .sash-container > .monaco-sash {\n\tpointer-events: initial;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element {\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container {\n\twidth: 100%;\n\theight: 100%;\n\twhite-space: nowrap;\n\tposition: relative;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twhite-space: initial;\n\tposition: absolute;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view:not(.visible) {\n\tdisplay: none;\n}\n\n.monaco-split-view2.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twidth: 100%;\n}\n\n.monaco-split-view2.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\theight: 100%;\n}\n\n.monaco-split-view2.separator-border > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\tcontent: ' ';\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tz-index: 5;\n\tpointer-events: none;\n\tbackground-color: var(--separator-border);\n}\n\n.monaco-split-view2.separator-border.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-split-view2.separator-border.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 1px;\n\twidth: 100%;\n}\n",""]);const s=o},3199:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-table {\n\tdisplay: flex;\n\tflex-direction: column;\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n\toverflow: hidden;\n}\n\n.monaco-table > .monaco-split-view2 {\n\tborder-bottom: 1px solid transparent;\n}\n\n.monaco-table > .monaco-list {\n\tflex: 1;\n}\n\n.monaco-table-tr {\n\tdisplay: flex;\n\theight: 100%;\n}\n\n.monaco-table-th {\n\twidth: 100%;\n\theight: 100%;\n\tfont-weight: bold;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table-th,\n.monaco-table-td {\n\tbox-sizing: border-box;\n\tflex-shrink: 0;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\tcontent: "";\n\tposition: absolute;\n\tleft: calc(var(--vscode-sash-size) / 2);\n\twidth: 0;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2,\n.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\ttransition: border-color 0.2s ease-out;\n}\n',""]);const s=o},2629:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-custom-toggle {\n\tmargin-left: 2px;\n\tfloat: left;\n\tcursor: pointer;\n\toverflow: hidden;\n\twidth: 20px;\n\theight: 20px;\n\tborder-radius: 3px;\n\tborder: 1px solid transparent;\n\tpadding: 1px;\n\tbox-sizing:\tborder-box;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n.monaco-custom-toggle:hover {\n\tbackground-color: var(--vscode-inputOption-hoverBackground);\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tborder: 1px dashed var(--vscode-focusBorder);\n}\n\n.hc-black .monaco-custom-toggle,\n.hc-light .monaco-custom-toggle {\n\tbackground: none;\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tbackground: none;\n}\n\n.monaco-custom-toggle.monaco-checkbox {\n\theight: 18px;\n\twidth: 18px;\n\tborder: 1px solid transparent;\n\tborder-radius: 3px;\n\tmargin-right: 9px;\n\tmargin-left: 0px;\n\tpadding: 0px;\n\topacity: 1;\n\tbackground-size: 16px !important;\n}\n\n/* hide check when unchecked */\n.monaco-custom-toggle.monaco-checkbox:not(.checked)::before {\n\tvisibility: hidden;\n}\n",""]);const s=o},2850:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-tl-row {\n\tdisplay: flex;\n\theight: 100%;\n\talign-items: center;\n\tposition: relative;\n}\n\n.monaco-tl-row.disabled {\n\tcursor: default;\n}\n.monaco-tl-indent {\n\theight: 100%;\n\tposition: absolute;\n\ttop: 0;\n\tleft: 16px;\n\tpointer-events: none;\n}\n\n.hide-arrows .monaco-tl-indent {\n\tleft: 12px;\n}\n\n.monaco-tl-indent > .indent-guide {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\theight: 100%;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-tl-indent > .indent-guide {\n\ttransition: border-color 0.1s linear;\n}\n\n.monaco-tl-twistie,\n.monaco-tl-contents {\n\theight: 100%;\n}\n\n.monaco-tl-twistie {\n\tfont-size: 10px;\n\ttext-align: right;\n\tpadding-right: 6px;\n\tflex-shrink: 0;\n\twidth: 16px;\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\ttransform: translateX(3px);\n}\n\n.monaco-tl-contents {\n\tflex: 1;\n\toverflow: hidden;\n}\n\n.monaco-tl-twistie::before {\n\tborder-radius: 20px;\n}\n\n.monaco-tl-twistie.collapsed::before {\n\ttransform: rotate(-90deg);\n}\n\n.monaco-tl-twistie.codicon-tree-item-loading::before {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.25s steps(30) infinite;\n}\n\n.monaco-tree-type-filter {\n\tposition: absolute;\n\ttop: 0;\n\tdisplay: flex;\n\tpadding: 3px;\n\tmax-width: 200px;\n\tz-index: 100;\n\tmargin: 0 6px;\n\tborder: 1px solid var(--vscode-widget-border);\n\tborder-bottom-left-radius: 4px;\n\tborder-bottom-right-radius: 4px;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-tree-type-filter {\n\ttransition: top 0.3s;\n}\n\n.monaco-tree-type-filter.disabled {\n\ttop: -40px !important;\n}\n\n.monaco-tree-type-filter-grab {\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: grab;\n\tmargin-right: 2px;\n}\n\n.monaco-tree-type-filter-grab.grabbing {\n\tcursor: grabbing;\n}\n\n.monaco-tree-type-filter-input {\n\tflex: 1;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox {\n\theight: 23px;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .input,\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding: 2px 4px;\n}\n\n.monaco-tree-type-filter-input .monaco-findInput > .controls {\n\ttop: 2px;\n}\n\n.monaco-tree-type-filter-actionbar {\n\tmargin-left: 4px;\n}\n\n.monaco-tree-type-filter-actionbar .monaco-action-bar .action-label {\n\tpadding: 2px;\n}\n",""]);const s=o},7078:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .inputarea {\n\tmin-width: 0;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\toutline: none !important;\n\tresize: none;\n\tborder: none;\n\toverflow: hidden;\n\tcolor: transparent;\n\tbackground-color: transparent;\n\tz-index: -10;\n}\n/*.monaco-editor .inputarea {\n\tposition: fixed !important;\n\twidth: 800px !important;\n\theight: 500px !important;\n\ttop: initial !important;\n\tleft: initial !important;\n\tbottom: 0 !important;\n\tright: 0 !important;\n\tcolor: black !important;\n\tbackground: white !important;\n\tline-height: 15px !important;\n\tfont-size: 14px !important;\n\tz-index: 10 !important;\n}*/\n.monaco-editor .inputarea.ime-input {\n\tz-index: 10;\n\tcaret-color: var(--vscode-editorCursor-foreground);\n\tcolor: var(--vscode-editor-foreground);\n}\n",""]);const s=o},7108:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .blockDecorations-container {\n\tposition: absolute;\n\ttop: 0;\n\tpointer-events: none;\n}\n\n.monaco-editor .blockDecorations-block {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n",""]);const s=o},5166:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line.current-line-margin.current-line-margin-both {\n\tborder-right: 0;\n}\n",""]);const s=o},358:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcdr = core decorations rendering (div)\n*/\n.monaco-editor .lines-content .cdr {\n\tposition: absolute;\n}",""]);const s=o},7394:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .glyph-margin {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcgmr = core glyph margin rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cgmr {\n\tposition: absolute;\n\tdisplay: flex;\n\talign-items: center;\n}\n",""]);const s=o},9158:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .lines-content .core-guide {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .lines-content .core-guide-indent {\n\tbox-shadow: 1px 0 0 0 var(--vscode-editorIndentGuide-background) inset;\n}\n\n.monaco-editor .lines-content .core-guide-indent-active {\n\tbox-shadow: 1px 0 0 0 var(--vscode-editorIndentGuide-activeBackground, --vscode-editorIndentGuide-background) inset;\n}\n",""]);const s=o},4602:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin-view-overlays .line-numbers {\n\tfont-variant-numeric: tabular-nums;\n\tposition: absolute;\n\ttext-align: right;\n\tdisplay: inline-block;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\tcursor: default;\n\theight: 100%;\n}\n\n.monaco-editor .relative-current-line-number {\n\ttext-align: left;\n\tdisplay: inline-block;\n\twidth: 100%;\n}\n\n.monaco-editor .margin-view-overlays .line-numbers.lh-odd {\n\tmargin-top: 1px;\n}\n\n.monaco-editor .line-numbers {\n\tcolor: var(--vscode-editorLineNumber-foreground);\n}\n\n.monaco-editor .line-numbers.active-line-number {\n\tcolor: var(--vscode-editorLineNumber-activeForeground);\n}\n",""]);const s=o},9091:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Uncomment to see lines flashing when they're painted */\n/*.monaco-editor .view-lines > .view-line {\n\tbackground-color: none;\n\tanimation-name: flash-background;\n\tanimation-duration: 800ms;\n}\n@keyframes flash-background {\n\t0%   { background-color: lightgreen; }\n\t100% { background-color: none }\n}*/\n\n.mtkcontrol {\n\tcolor: rgb(255, 255, 255) !important;\n\tbackground: rgb(150, 0, 0) !important;\n}\n\n.mtkoverflow {\n\tbackground-color: var(--vscode-button-background, --vscode-editor-background);\n\tcolor: var(--vscode-button-foreground, --vscode-editor-foreground);\n\tborder-width: 1px;\n\tborder-style: solid;\n\tborder-color: var(--vscode-contrastBorder);\n\tborder-radius: 2px;\n\tpadding: 4px;\n\tcursor: pointer;\n}\n.mtkoverflow:hover {\n\tbackground-color: var(--vscode-button-hoverBackground);\n}\n\n.monaco-editor.no-user-select .lines-content,\n.monaco-editor.no-user-select .view-line,\n.monaco-editor.no-user-select .view-lines {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n/* Use user-select: text for lookup feature on macOS */\n/* https://github.com/microsoft/vscode/issues/85632 */\n.monaco-editor.mac .lines-content:hover,\n.monaco-editor.mac .view-line:hover,\n.monaco-editor.mac .view-lines:hover {\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n}\n\n.monaco-editor.enable-user-select {\n\tuser-select: initial;\n\t-webkit-user-select: initial;\n}\n\n.monaco-editor .view-lines {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .view-line {\n\tposition: absolute;\n\twidth: 100%;\n}\n\n.monaco-editor .mtkw {\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n\n.monaco-editor .mtkz {\n\tdisplay: inline-block;\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n\n/* TODO@tokenization bootstrap fix */\n/*.monaco-editor .view-line > span > span {\n\tfloat: none;\n\tmin-height: inherit;\n\tmargin-left: inherit;\n}*/\n",""]);const s=o},9688:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .lines-decorations {\n\tposition: absolute;\n\ttop: 0;\n\tbackground: white;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcldr = core lines decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cldr {\n\tposition: absolute;\n\theight: 100%;\n}",""]);const s=o},200:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin {\n\tbackground-color: var(--vscode-editorGutter-background);\n}\n",""]);const s=o},8346:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcmdr = core margin decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cmdr {\n\tposition: absolute;\n\tleft: 0;\n\twidth: 100%;\n\theight: 100%;\n}",""]);const s=o},7974:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* START cover the case that slider is visible on mouseover */\n.monaco-editor .minimap.slider-mouseover .minimap-slider {\n\topacity: 0;\n\ttransition: opacity 100ms linear;\n}\n.monaco-editor .minimap.slider-mouseover:hover .minimap-slider {\n\topacity: 1;\n}\n.monaco-editor .minimap.slider-mouseover .minimap-slider.active {\n\topacity: 1;\n}\n/* END cover the case that slider is visible on mouseover */\n.monaco-editor .minimap-slider .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-background);\n}\n.monaco-editor .minimap-slider:hover .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-hoverBackground);\n}\n.monaco-editor .minimap-slider.active .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-activeBackground);\n}\n.monaco-editor .minimap-shadow-visible {\n\tbox-shadow: var(--vscode-scrollbar-shadow) -6px 0 6px -6px inset;\n}\n.monaco-editor .minimap-shadow-hidden {\n\tposition: absolute;\n\twidth: 0;\n}\n.monaco-editor .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -6px;\n\twidth: 6px;\n}\n.monaco-editor.no-minimap-shadow .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -1px;\n\twidth: 1px;\n}\n\n/* 0.5s fade in/out for the minimap */\n.minimap.autohide {\n\topacity: 0;\n\ttransition: opacity 0.5s;\n}\n.minimap.autohide:hover {\n\topacity: 1;\n}\n",""]);const s=o},8298:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .overlayWidgets {\n\tposition: absolute;\n\ttop: 0;\n\tleft:0;\n}",""]);const s=o},9166:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-ruler {\n\tposition: absolute;\n\ttop: 0;\n\tbox-shadow: 1px 0 0 0 var(--vscode-editorRuler-foreground) inset;\n}\n",""]);const s=o},3398:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .scroll-decoration {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\theight: 6px;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 6px 6px -6px inset;\n}\n",""]);const s=o},3270:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcslr = core selections layer rendering (div)\n*/\n.monaco-editor .lines-content .cslr {\n\tposition: absolute;\n}\n\n.monaco-editor .focused .selected-text {\n\tbackground-color: var(--vscode-editor-selectionBackground);\n}\n\n.monaco-editor .selected-text {\n\tbackground-color: var(--vscode-editor-inactiveSelectionBackground);\n}\n\n.monaco-editor\t\t\t.top-left-radius\t\t{ border-top-left-radius: 3px; }\n.monaco-editor\t\t\t.bottom-left-radius\t\t{ border-bottom-left-radius: 3px; }\n.monaco-editor\t\t\t.top-right-radius\t\t{ border-top-right-radius: 3px; }\n.monaco-editor\t\t\t.bottom-right-radius\t{ border-bottom-right-radius: 3px; }\n\n.monaco-editor.hc-black .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-black .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-black .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-black .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n\n.monaco-editor.hc-light .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-light .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-light .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-light .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n",""]);const s=o},1762:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .cursors-layer {\n\tposition: absolute;\n\ttop: 0;\n}\n\n.monaco-editor .cursors-layer > .cursor {\n\tposition: absolute;\n\toverflow: hidden;\n\tbox-sizing: border-box;\n}\n\n/* -- smooth-caret-animation -- */\n.monaco-editor .cursors-layer.cursor-smooth-caret-animation > .cursor {\n\ttransition: all 80ms;\n}\n\n/* -- block-outline-style -- */\n.monaco-editor .cursors-layer.cursor-block-outline-style > .cursor {\n\tbackground: transparent !important;\n\tborder-style: solid;\n\tborder-width: 1px;\n}\n\n/* -- underline-style -- */\n.monaco-editor .cursors-layer.cursor-underline-style > .cursor {\n\tborder-bottom-width: 2px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n}\n\n/* -- underline-thin-style -- */\n.monaco-editor .cursors-layer.cursor-underline-thin-style > .cursor {\n\tborder-bottom-width: 1px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n}\n\n@keyframes monaco-cursor-smooth {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t60%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-phase {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t90%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-expand {\n\t0%,\n\t20% {\n\t\ttransform: scaleY(1);\n\t}\n\t80%,\n\t100% {\n\t\ttransform: scaleY(0);\n\t}\n}\n\n.cursor-smooth {\n\tanimation: monaco-cursor-smooth 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-phase {\n\tanimation: monaco-cursor-phase 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-expand > .cursor {\n\tanimation: monaco-cursor-expand 0.5s ease-in-out 0s 20 alternate;\n}\n",""]);const s=o},774:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .mwh {\n\tposition: absolute;\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n",""]);const s=o},4199:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- DiffEditor ---------- */\n\n.monaco-diff-editor .diffOverview {\n\tz-index: 9;\n}\n\n.monaco-diff-editor .diffOverview .diffViewport {\n\tz-index: 10;\n}\n\n/* colors not externalized: using transparancy on background */\n.monaco-diff-editor.vs\t\t\t.diffOverview { background: rgba(0, 0, 0, 0.03); }\n.monaco-diff-editor.vs-dark\t\t.diffOverview { background: rgba(255, 255, 255, 0.01); }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs\t\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs-dark\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-black\t.scrollbar { background: none; }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-light\t.scrollbar { background: none; }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor .slider {\n\tz-index: 10;\n}\n.modified-in-monaco-diff-editor\t\t\t\t.slider.active { background: rgba(171, 171, 171, .4); }\n.modified-in-monaco-diff-editor.hc-black\t.slider.active { background: none; }\n.modified-in-monaco-diff-editor.hc-light\t.slider.active { background: none; }\n\n/* ---------- Diff ---------- */\n\n.monaco-editor .insert-sign,\n.monaco-diff-editor .insert-sign,\n.monaco-editor .delete-sign,\n.monaco-diff-editor .delete-sign {\n\tfont-size: 11px !important;\n\topacity: 0.7 !important;\n\tdisplay: flex !important;\n\talign-items: center;\n}\n.monaco-editor.hc-black .insert-sign,\n.monaco-diff-editor.hc-black .insert-sign,\n.monaco-editor.hc-black .delete-sign,\n.monaco-diff-editor.hc-black .delete-sign,\n.monaco-editor.hc-light .insert-sign,\n.monaco-diff-editor.hc-light .insert-sign,\n.monaco-editor.hc-light .delete-sign,\n.monaco-diff-editor.hc-light .delete-sign {\n\topacity: 1;\n}\n\n.monaco-editor .inline-deleted-margin-view-zone {\n\ttext-align: right;\n}\n.monaco-editor .inline-added-margin-view-zone {\n\ttext-align: right;\n}\n\n.monaco-editor .arrow-revert-change {\n\tz-index: 10;\n\tposition: absolute;\n}\n\n.monaco-editor .arrow-revert-change:hover {\n\tcursor: pointer;\n}\n\n/* ---------- Inline Diff ---------- */\n\n.monaco-editor .view-zones .view-lines .view-line span {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .margin-view-zones .lightbulb-glyph:hover {\n\tcursor: pointer;\n}\n\n.monaco-editor .char-insert, .monaco-diff-editor .char-insert {\n\tbackground-color: var(--vscode-diffEditor-insertedTextBackground);\n}\n\n.monaco-editor .line-insert, .monaco-diff-editor .line-insert {\n\tbackground-color: var(--vscode-diffEditor-insertedLineBackground, --vscode-diffEditor-insertedTextBackground);\n}\n\n.monaco-editor .line-insert,\n.monaco-editor .char-insert {\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-diffEditor-insertedTextBorder);\n}\n.monaco-editor.hc-black .line-insert, .monaco-editor.hc-light .line-insert,\n.monaco-editor.hc-black .char-insert, .monaco-editor.hc-light .char-insert {\n\tborder-style: dashed;\n}\n\n.monaco-editor .line-delete,\n.monaco-editor .char-delete {\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-diffEditor-removedTextBorder);\n}\n.monaco-editor.hc-black .line-delete, .monaco-editor.hc-light .line-delete,\n.monaco-editor.hc-black .char-delete, .monaco-editor.hc-light .char-delete {\n\tborder-style: dashed;\n}\n\n.monaco-editor .inline-added-margin-view-zone,\n.monaco-editor .gutter-insert, .monaco-diff-editor .gutter-insert {\n\tbackground-color: var(--vscode-diffEditorGutter-insertedLineBackground, --vscode-diffEditor-insertedLineBackground, --vscode-diffEditor-insertedTextBackground);\n}\n\n.monaco-editor .char-delete, .monaco-diff-editor .char-delete {\n\tbackground-color: var(--vscode-diffEditor-removedTextBackground);\n}\n\n.monaco-editor .line-delete, .monaco-diff-editor .line-delete {\n\tbackground-color: var(--vscode-diffEditor-removedLineBackground, --vscode-diffEditor-removedTextBackground);\n}\n\n.monaco-editor .inline-deleted-margin-view-zone,\n.monaco-editor .gutter-delete, .monaco-diff-editor .gutter-delete {\n\tbackground-color: var(--vscode-diffEditorGutter-removedLineBackground, --vscode-diffEditor-removedLineBackground, --vscode-diffEditor-removedTextBackground);\n}\n\n.monaco-diff-editor.side-by-side .editor.modified {\n\tbox-shadow: -6px 0 5px -5px var(--vscode-scrollbar-shadow);\n\tborder-left: 1px solid var(--vscode-diffEditor-border);\n}\n\n.monaco-diff-editor .diffViewport {\n\tbackground: var(--vscode-scrollbarSlider-background);\n}\n\n.monaco-diff-editor .diffViewport:hover {\n\tbackground: var(--vscode-scrollbarSlider-hoverBackground);\n}\n\n.monaco-diff-editor .diffViewport:active {\n\tbackground: var(--vscode-scrollbarSlider-activeBackground);\n}\n",""]);const s=o},1268:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-diff-editor .diff-review-line-number {\n\ttext-align: right;\n\tdisplay: inline-block;\n\tcolor: var(--vscode-editorLineNumber-foreground);\n}\n\n.monaco-diff-editor .diff-review {\n\tposition: absolute;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n.monaco-diff-editor .diff-review-summary {\n\tpadding-left: 10px;\n}\n\n.monaco-diff-editor .diff-review-shadow {\n\tposition: absolute;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 -6px 6px -6px inset;\n}\n\n.monaco-diff-editor .diff-review-row {\n\twhite-space: pre;\n}\n\n.monaco-diff-editor .diff-review-table {\n\tdisplay: table;\n\tmin-width: 100%;\n}\n\n.monaco-diff-editor .diff-review-row {\n\tdisplay: table-row;\n\twidth: 100%;\n}\n\n.monaco-diff-editor .diff-review-spacer {\n\tdisplay: inline-block;\n\twidth: 10px;\n\tvertical-align: middle;\n}\n\n.monaco-diff-editor .diff-review-spacer > .codicon {\n\tfont-size: 9px !important;\n}\n\n.monaco-diff-editor .diff-review-actions {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\ttop: 2px;\n}\n\n.monaco-diff-editor .diff-review-actions .action-label {\n\twidth: 16px;\n\theight: 16px;\n\tmargin: 2px 0;\n}\n",""]);const s=o},4470:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -------------------- IE10 remove auto clear button -------------------- */\n\n::-ms-clear {\n\tdisplay: none;\n}\n\n/* All widgets */\n/* I am not a big fan of this rule */\n.monaco-editor .editor-widget input {\n\tcolor: inherit;\n}\n\n/* -------------------- Editor -------------------- */\n\n.monaco-editor {\n\tposition: relative;\n\toverflow: visible;\n\t-webkit-text-size-adjust: 100%;\n\tcolor: var(--vscode-editor-foreground);\n\tbackground-color: var(--vscode-editor-background);\n}\n.monaco-editor-background {\n\tbackground-color: var(--vscode-editor-background);\n}\n.monaco-editor .rangeHighlight {\n\tbackground-color: var(--vscode-editor-rangeHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-rangeHighlightBorder);\n}\n.monaco-editor.hc-black .rangeHighlight, .monaco-editor.hc-light .rangeHighlight {\n\tborder-style: dotted;\n}\n.monaco-editor .symbolHighlight {\n\tbackground-color: var(--vscode-editor-symbolHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-symbolHighlightBorder);\n}\n.monaco-editor.hc-black .symbolHighlight, .monaco-editor.hc-light .symbolHighlight {\n\tborder-style: dotted;\n}\n\n/* -------------------- Misc -------------------- */\n\n.monaco-editor .overflow-guard {\n\tposition: relative;\n\toverflow: hidden;\n}\n\n.monaco-editor .view-overlays {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n.monaco-editor .auto-closed-character {\n\topacity: 0.3;\n}\n*/\n\n\n.monaco-editor .squiggly-error {\n\tborder-bottom: 4px double var(--vscode-editorError-border);\n}\n.monaco-editor .squiggly-error::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorError-background);\n}\n.monaco-editor .squiggly-warning {\n\tborder-bottom: 4px double var(--vscode-editorWarning-border);\n}\n.monaco-editor .squiggly-warning::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorWarning-background);\n}\n.monaco-editor .squiggly-info {\n\tborder-bottom: 4px double var(--vscode-editorInfo-border);\n}\n.monaco-editor .squiggly-info::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorInfo-background);\n}\n.monaco-editor .squiggly-hint {\n\tborder-bottom: 2px dotted var(--vscode-editorHint-border);\n}\n.monaco-editor.showUnused .squiggly-unnecessary {\n\tborder-bottom: 2px dashed var(--vscode-editorUnnecessaryCode-border);\n}\n.monaco-editor.showDeprecated .squiggly-inline-deprecated {\n\ttext-decoration: line-through;\n\ttext-decoration-color: var(--vscode-editor-foreground, inherit);\n}\n",""]);const s=o},3356:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .rendered-markdown kbd {\n\tbackground-color: var(--vscode-keybindingLabel-background);\n\tcolor: var(--vscode-keybindingLabel-foreground);\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tborder-color: var(--vscode-keybindingLabel-border);\n\tborder-bottom-color: var(--vscode-keybindingLabel-bottomBorder);\n\tbox-shadow: inset 0 -1px 0 var(--vscode-widget-shadow);\n\tvertical-align: middle;\n\tpadding: 1px 3px;\n}\n",""]);const s=o},4472:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .snippet-placeholder {\n\tmin-width: 2px;\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetTabstopHighlightBorder, transparent);\n}\n\n.monaco-editor .finish-snippet-placeholder {\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetFinalTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetFinalTabstopHighlightBorder, transparent);\n}\n",""]);const s=o},9719:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Suggest widget*/\n\n.monaco-editor .suggest-widget {\n\twidth: 430px;\n\tz-index: 40;\n\tdisplay: flex;\n\tflex-direction: column;\n\tborder-radius: 3px;\n}\n\n.monaco-editor .suggest-widget.message {\n\tflex-direction: row;\n\talign-items: center;\n}\n\n.monaco-editor .suggest-widget,\n.monaco-editor .suggest-details {\n\tflex: 0 1 auto;\n\twidth: 100%;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-color: var(--vscode-editorSuggestWidget-border);\n\tbackground-color: var(--vscode-editorSuggestWidget-background);\n}\n\n.monaco-editor.hc-black .suggest-widget,\n.monaco-editor.hc-black .suggest-details,\n.monaco-editor.hc-light .suggest-widget,\n.monaco-editor.hc-light .suggest-details {\n\tborder-width: 2px;\n}\n\n/* Styles for status bar part */\n\n\n.monaco-editor .suggest-widget .suggest-status-bar {\n\tbox-sizing: border-box;\n\tdisplay: none;\n\tflex-flow: row nowrap;\n\tjustify-content: space-between;\n\twidth: 100%;\n\tfont-size: 80%;\n\tpadding: 0 4px 0 4px;\n\tborder-top: 1px solid var(--vscode-editorSuggestWidget-border);\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .suggest-status-bar .left {\n\tpadding-right: 8px;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-label {\n\tcolor: var(--vscode-editorSuggestWidgetStatus-foreground);\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label::after {\n\tcontent: ', ';\n\tmargin-right: 0.3em;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row>.contents>.main>.right>.readMore,\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget.with-status-bar:not(.docs-side) .monaco-list .monaco-list-row:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: 100%;\n}\n\n/* Styles for Message element for when widget is loading or is empty */\n\n.monaco-editor .suggest-widget>.message {\n\tpadding-left: 22px;\n}\n\n/** Styles for the list element **/\n\n.monaco-editor .suggest-widget>.tree {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/** Styles for each row in the list element **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row {\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tpadding-right: 10px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused {\n\tcolor: var(--vscode-editorSuggestWidget-selectedForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: var(--vscode-editorSuggestWidget-selectedIconForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents {\n\tflex: 1;\n\theight: 100%;\n\toverflow: hidden;\n\tpadding-left: 2px;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main {\n\tdisplay: flex;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: pre;\n\tjustify-content: space-between;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.focused)>.contents>.main .monaco-icon-label {\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-widget:not(.frozen) .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-highlightForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-focusHighlightForeground);\n}\n\n/** ReadMore Icon styles **/\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore::before {\n\tcolor: inherit;\n\topacity: 1;\n\tfont-size: 14px;\n\tcursor: pointer;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close {\n\tposition: absolute;\n\ttop: 6px;\n\tright: 2px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close:hover,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore:hover {\n\topacity: 1;\n}\n\n/** signature, qualifier, type/details opacity **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\topacity: 0.7;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.signature-label {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.6;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.qualifier-label {\n\tmargin-left: 12px;\n\topacity: 0.4;\n\tfont-size: 85%;\n\tline-height: initial;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\talign-self: center;\n}\n\n/** Type Info and icon next to the label in the focused completion item **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tfont-size: 85%;\n\tmargin-left: 1.1em;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label>.monaco-tokenized-source {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItem#details, show on focus **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget:not(.shows-details) .monaco-list .monaco-list-row.focused>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItemLabel#details, always show **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.right>.details-label,\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row.focused:not(.string-label)>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Ellipsis on hover **/\n\n.monaco-editor .suggest-widget:not(.docs-side) .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: calc(100% - 26px);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left {\n\tflex-shrink: 1;\n\tflex-grow: 1;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 0;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.left>.monaco-icon-label {\n\tmax-width: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 1;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\toverflow: hidden;\n\tflex-shrink: 4;\n\tmax-width: 70%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\twidth: 18px;\n\theight: 18px;\n\tvisibility: hidden;\n}\n\n/** Do NOT display ReadMore when docs is side/below **/\n\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: none !important;\n}\n\n/** Do NOT display ReadMore when using plain CompletionItemLabel (details/documentation might not be resolved) **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n/** Focused item can show ReadMore, but can't when docs is side/below **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right>.readMore {\n\tvisibility: visible;\n}\n\n/** Styles for each row in the list **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated {\n\topacity: 0.66;\n\ttext-decoration: unset;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated>.monaco-icon-label-container>.monaco-icon-name-container {\n\ttext-decoration: line-through;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label::before {\n\theight: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon {\n\tdisplay: block;\n\theight: 16px;\n\twidth: 16px;\n\tmargin-left: 2px;\n\tbackground-repeat: no-repeat;\n\tbackground-size: 80%;\n\tbackground-position: center;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.hide {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .suggest-icon {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .icon,\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .suggest-icon::before {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.customcolor .colorspan {\n\tmargin: 0 0 0 0.3em;\n\tborder: 0.1em solid #000;\n\twidth: 0.7em;\n\theight: 0.7em;\n\tdisplay: inline-block;\n}\n\n/** Styles for the docs of the completion item in focus **/\n\n.monaco-editor .suggest-details-container {\n\tz-index: 41;\n}\n\n.monaco-editor .suggest-details {\n\tdisplay: flex;\n\tflex-direction: column;\n\tcursor: default;\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-details.focused {\n\tborder-color: var(--vscode-focusBorder);\n}\n\n.monaco-editor .suggest-details a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .suggest-details a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .suggest-details code {\n\tbackground-color: var(--vscode-textCodeBlock-background);\n}\n\n.monaco-editor .suggest-details.no-docs {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element {\n\tflex: 1;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body {\n\tbox-sizing: border-box;\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type {\n\tflex: 2;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.7;\n\twhite-space: pre;\n\tmargin: 0 24px 0 0;\n\tpadding: 4px 0 12px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type.auto-wrap {\n\twhite-space: normal;\n\tword-break: break-all;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs {\n\tmargin: 0;\n\tpadding: 4px 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .suggest-details.no-type>.monaco-scrollable-element>.body>.docs {\n\tmargin-right: 24px;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs {\n\tpadding: 0;\n\twhite-space: initial;\n\tmin-height: calc(1rem + 8px);\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div,\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>span:not(:empty) {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:last-child {\n\tmargin-bottom: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .monaco-tokenized-source {\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs .code {\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .codicon {\n\tvertical-align: sub;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>p:empty {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .suggest-details ul {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details ol {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details p code {\n\tfont-family: var(--monaco-monospace-font);\n}\n",""]);const s=o},7062:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .codicon.codicon-symbol-array,\n.monaco-workbench .codicon.codicon-symbol-array { color: var(--vscode-symbolIcon-arrayForeground); }\n.monaco-editor .codicon.codicon-symbol-boolean,\n.monaco-workbench .codicon.codicon-symbol-boolean { color: var(--vscode-symbolIcon-booleanForeground); }\n.monaco-editor .codicon.codicon-symbol-class,\n.monaco-workbench .codicon.codicon-symbol-class { color: var(--vscode-symbolIcon-classForeground); }\n.monaco-editor .codicon.codicon-symbol-method,\n.monaco-workbench .codicon.codicon-symbol-method { color: var(--vscode-symbolIcon-methodForeground); }\n.monaco-editor .codicon.codicon-symbol-color,\n.monaco-workbench .codicon.codicon-symbol-color { color: var(--vscode-symbolIcon-colorForeground); }\n.monaco-editor .codicon.codicon-symbol-constant,\n.monaco-workbench .codicon.codicon-symbol-constant { color: var(--vscode-symbolIcon-constantForeground); }\n.monaco-editor .codicon.codicon-symbol-constructor,\n.monaco-workbench .codicon.codicon-symbol-constructor { color: var(--vscode-symbolIcon-constructorForeground); }\n.monaco-editor .codicon.codicon-symbol-value,\n.monaco-workbench .codicon.codicon-symbol-value,\n.monaco-editor .codicon.codicon-symbol-enum,\n.monaco-workbench .codicon.codicon-symbol-enum { color: var(--vscode-symbolIcon-enumeratorForeground); }\n.monaco-editor .codicon.codicon-symbol-enum-member,\n.monaco-workbench .codicon.codicon-symbol-enum-member { color: var(--vscode-symbolIcon-enumeratorMemberForeground); }\n.monaco-editor .codicon.codicon-symbol-event,\n.monaco-workbench .codicon.codicon-symbol-event { color: var(--vscode-symbolIcon-eventForeground); }\n.monaco-editor .codicon.codicon-symbol-field,\n.monaco-workbench .codicon.codicon-symbol-field { color: var(--vscode-symbolIcon-fieldForeground); }\n.monaco-editor .codicon.codicon-symbol-file,\n.monaco-workbench .codicon.codicon-symbol-file { color: var(--vscode-symbolIcon-fileForeground); }\n.monaco-editor .codicon.codicon-symbol-folder,\n.monaco-workbench .codicon.codicon-symbol-folder { color: var(--vscode-symbolIcon-folderForeground); }\n.monaco-editor .codicon.codicon-symbol-function,\n.monaco-workbench .codicon.codicon-symbol-function { color: var(--vscode-symbolIcon-functionForeground); }\n.monaco-editor .codicon.codicon-symbol-interface,\n.monaco-workbench .codicon.codicon-symbol-interface { color: var(--vscode-symbolIcon-interfaceForeground); }\n.monaco-editor .codicon.codicon-symbol-key,\n.monaco-workbench .codicon.codicon-symbol-key { color: var(--vscode-symbolIcon-keyForeground); }\n.monaco-editor .codicon.codicon-symbol-keyword,\n.monaco-workbench .codicon.codicon-symbol-keyword { color: var(--vscode-symbolIcon-keywordForeground); }\n.monaco-editor .codicon.codicon-symbol-module,\n.monaco-workbench .codicon.codicon-symbol-module { color: var(--vscode-symbolIcon-moduleForeground); }\n.monaco-editor .codicon.codicon-symbol-namespace,\n.monaco-workbench .codicon.codicon-symbol-namespace { color: var(--vscode-symbolIcon-namespaceForeground); }\n.monaco-editor .codicon.codicon-symbol-null,\n.monaco-workbench .codicon.codicon-symbol-null { color: var(--vscode-symbolIcon-nullForeground); }\n.monaco-editor .codicon.codicon-symbol-number,\n.monaco-workbench .codicon.codicon-symbol-number { color: var(--vscode-symbolIcon-numberForeground); }\n.monaco-editor .codicon.codicon-symbol-object,\n.monaco-workbench .codicon.codicon-symbol-object { color: var(--vscode-symbolIcon-objectForeground); }\n.monaco-editor .codicon.codicon-symbol-operator,\n.monaco-workbench .codicon.codicon-symbol-operator { color: var(--vscode-symbolIcon-operatorForeground); }\n.monaco-editor .codicon.codicon-symbol-package,\n.monaco-workbench .codicon.codicon-symbol-package { color: var(--vscode-symbolIcon-packageForeground); }\n.monaco-editor .codicon.codicon-symbol-property,\n.monaco-workbench .codicon.codicon-symbol-property { color: var(--vscode-symbolIcon-propertyForeground); }\n.monaco-editor .codicon.codicon-symbol-reference,\n.monaco-workbench .codicon.codicon-symbol-reference { color: var(--vscode-symbolIcon-referenceForeground); }\n.monaco-editor .codicon.codicon-symbol-snippet,\n.monaco-workbench .codicon.codicon-symbol-snippet { color: var(--vscode-symbolIcon-snippetForeground); }\n.monaco-editor .codicon.codicon-symbol-string,\n.monaco-workbench .codicon.codicon-symbol-string { color: var(--vscode-symbolIcon-stringForeground); }\n.monaco-editor .codicon.codicon-symbol-struct,\n.monaco-workbench .codicon.codicon-symbol-struct { color: var(--vscode-symbolIcon-structForeground); }\n.monaco-editor .codicon.codicon-symbol-text,\n.monaco-workbench .codicon.codicon-symbol-text { color: var(--vscode-symbolIcon-textForeground); }\n.monaco-editor .codicon.codicon-symbol-type-parameter,\n.monaco-workbench .codicon.codicon-symbol-type-parameter { color: var(--vscode-symbolIcon-typeParameterForeground); }\n.monaco-editor .codicon.codicon-symbol-unit,\n.monaco-workbench .codicon.codicon-symbol-unit { color: var(--vscode-symbolIcon-unitForeground); }\n.monaco-editor .codicon.codicon-symbol-variable,\n.monaco-workbench .codicon.codicon-symbol-variable { color: var(--vscode-symbolIcon-variableForeground); }\n",""]);const s=o},3195:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tfont-size: 13px;\n}\n\n.quick-input-widget .monaco-highlighted-label .highlight,\n.quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0066BF;\n}\n\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight,\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight {\n\tcolor: #9DDDFF;\n}\n\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight,\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0097fb;\n}\n\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #F38518;\n}\n\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0F4A85;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(221, 221, 221, 0.4);\n\tborder: solid 1px rgba(204, 204, 204, 0.4);\n\tborder-bottom-color: rgba(187, 187, 187, 0.4);\n\tbox-shadow: inset 0 -1px 0 rgba(187, 187, 187, 0.4);\n\tcolor: #555;\n}\n\n.hc-black .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px rgb(111, 195, 223);\n\tbox-shadow: none;\n\tcolor: #fff;\n}\n\n.hc-light .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px #0F4A85;\n\tbox-shadow: none;\n\tcolor: #292929;\n}\n\n.vs-dark .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(128, 128, 128, 0.17);\n\tborder: solid 1px rgba(51, 51, 51, 0.6);\n\tborder-bottom-color: rgba(68, 68, 68, 0.6);\n\tbox-shadow: inset 0 -1px 0 rgba(68, 68, 68, 0.6);\n\tcolor: #ccc;\n}\n",""]);const s=o},6587:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n\n/* Default standalone editor fonts */\n.monaco-editor {\n\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t--monaco-monospace-font: "SF Mono", Monaco, Menlo, Consolas, "Ubuntu Mono", "Liberation Mono", "DejaVu Sans Mono", "Courier New", monospace;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-black .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-light .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-hover p {\n\tmargin: 0;\n}\n\n/* See https://github.com/microsoft/monaco-editor/issues/2168#issuecomment-780078600 */\n.monaco-aria-container {\n\tposition: absolute !important;\n\ttop: 0; /* avoid being placed underneath a sibling element */\n\theight: 1px;\n\twidth: 1px;\n\tmargin: -1px;\n\toverflow: hidden;\n\tpadding: 0;\n\tclip: rect(1px, 1px, 1px, 1px);\n\tclip-path: inset(50%);\n}\n\n/*.monaco-editor.vs [tabindex="0"]:focus {\n\toutline: 1px solid rgba(0, 122, 204, 0.4);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}\n\n.monaco-editor.vs-dark [tabindex="0"]:focus {\n\toutline: 1px solid rgba(14, 99, 156, 0.6);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}*/\n',""]);const s=o},1608:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar .action-item.menu-entry .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-default > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-default > .action-container.menu-entry > .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]);const s=o},1231:(e,t,i)=>{i.d(t,{A:()=>s});var n=i(7305),o=i.n(n)()((function(e){return e[1]}));o.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tposition: absolute;\n\twidth: 600px;\n\tz-index: 2550;\n\tleft: 50%;\n\tmargin-left: -300px;\n\t-webkit-app-region: no-drag;\n\tborder-radius: 6px;\n}\n\n.quick-input-titlebar {\n\tdisplay: flex;\n\talign-items: center;\n\tborder-top-left-radius: 5px; /* match border radius of quick input widget */\n\tborder-top-right-radius: 5px;\n}\n\n.quick-input-left-action-bar {\n\tdisplay: flex;\n\tmargin-left: 4px;\n\tflex: 1;\n}\n\n.quick-input-title {\n\tpadding: 3px 0px;\n\ttext-align: center;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-right-action-bar {\n\tdisplay: flex;\n\tmargin-right: 4px;\n\tflex: 1;\n}\n\n.quick-input-right-action-bar > .actions-container {\n\tjustify-content: flex-end;\n}\n\n.quick-input-titlebar .monaco-action-bar .action-label.codicon {\n\tbackground-position: center;\n\tbackground-repeat: no-repeat;\n\tpadding: 2px;\n}\n\n.quick-input-description {\n\tmargin: 6px;\n}\n\n.quick-input-header .quick-input-description {\n\tmargin: 4px 2px;\n}\n\n.quick-input-header {\n\tdisplay: flex;\n\tpadding: 8px 6px 6px 6px;\n}\n\n.quick-input-widget.hidden-input .quick-input-header {\n\t/* reduce margins and paddings when input box hidden */\n\tpadding: 0;\n\tmargin-bottom: 0;\n}\n\n.quick-input-and-message {\n\tdisplay: flex;\n\tflex-direction: column;\n\tflex-grow: 1;\n\tmin-width: 0;\n\tposition: relative;\n}\n\n.quick-input-check-all {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-filter {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tposition: relative;\n}\n\n.quick-input-box {\n\tflex-grow: 1;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-box,\n.quick-input-widget.show-checkboxes .quick-input-message {\n\tmargin-left: 5px;\n}\n\n.quick-input-visible-count {\n\tposition: absolute;\n\tleft: -10000px;\n}\n\n.quick-input-count {\n\talign-self: center;\n\tposition: absolute;\n\tright: 4px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-count .monaco-count-badge {\n\tvertical-align: middle;\n\tpadding: 2px 4px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n\n.quick-input-action {\n\tmargin-left: 6px;\n}\n\n.quick-input-action .monaco-text-button {\n\tfont-size: 11px;\n\tpadding: 0 6px;\n\tdisplay: flex;\n\theight: 25px;\n\talign-items: center;\n}\n\n.quick-input-message {\n\tmargin-top: -1px;\n\tpadding: 5px;\n\toverflow-wrap: break-word;\n}\n\n.quick-input-message > .codicon {\n\tmargin: 0 0.2em;\n\tvertical-align: text-bottom;\n}\n\n/* Links in descriptions & validations */\n.quick-input-message a {\n\tcolor: inherit;\n}\n\n.quick-input-progress.monaco-progress-container {\n\tposition: relative;\n}\n\n.quick-input-progress.monaco-progress-container,\n.quick-input-progress.monaco-progress-container .progress-bit {\n\theight: 2px;\n}\n\n.quick-input-list {\n\tline-height: 22px;\n}\n\n.quick-input-widget.hidden-input .quick-input-list {\n\tmargin-top: 4px; /* reduce margins when input box hidden */\n\tpadding-bottom: 4px;\n}\n\n.quick-input-list .monaco-list {\n\toverflow: hidden;\n\tmax-height: calc(20 * 22px);\n\tpadding-bottom: 5px;\n}\n\n.quick-input-list .monaco-scrollable-element {\n\tpadding: 0px 5px;\n}\n\n.quick-input-list .quick-input-list-entry {\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tpadding: 0 6px;\n}\n\n.quick-input-list .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-width: 1px;\n\tborder-top-style: solid;\n}\n\n.quick-input-list .monaco-list-row {\n\tborder-radius: 3px;\n}\n\n.quick-input-list .monaco-list-row[data-index=\"0\"] .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-style: none;\n}\n\n.quick-input-list .quick-input-list-label {\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tflex: 1;\n}\n\n.quick-input-list .quick-input-list-checkbox {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-list .quick-input-list-rows {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tdisplay: flex;\n\tflex-direction: column;\n\theight: 100%;\n\tflex: 1;\n\tmargin-left: 5px;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-rows {\n\tmargin-left: 10px;\n}\n\n.quick-input-widget .quick-input-list .quick-input-list-checkbox {\n\tdisplay: none;\n}\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-checkbox {\n\tdisplay: inline;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label,\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label .monaco-icon-label-container > .monaco-icon-name-container {\n\tflex: 1; /* make sure the icon label grows within the row */\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .codicon[class*='codicon-'] {\n\tvertical-align: text-bottom;\n}\n\n.quick-input-list .quick-input-list-rows .monaco-highlighted-label > span {\n\topacity: 1;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-keybinding {\n\tmargin-right: 8px; /* separate from the separator label or scrollbar if any */\n}\n\n.quick-input-list .quick-input-list-label-meta {\n\topacity: 0.7;\n\tline-height: normal;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-list .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-separator {\n\tmargin-right: 4px; /* separate from keybindings or actions */\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tdisplay: flex;\n\tflex: 0;\n\toverflow: visible;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label {\n\t/*\n\t * By default, actions in the quick input action bar are hidden\n\t * until hovered over them or selected.\n\t */\n\tdisplay: none;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label.codicon {\n\tmargin-right: 4px;\n\tpadding: 0px 2px 2px 2px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-top: 1px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-right: 4px; /* separate from scrollbar */\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-action-bar .action-label.always-visible,\n.quick-input-list .quick-input-list-entry:hover .quick-input-list-entry-action-bar .action-label,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry-action-bar .action-label {\n\tdisplay: flex;\n}\n\n/* focused items in quick pick */\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry .quick-input-list-separator {\n\tcolor: inherit\n}\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key {\n\tbackground: none;\n}\n",""]);const s=o},7305:e=>{e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var i=e(t);return t[2]?"@media ".concat(t[2]," {").concat(i,"}"):i})).join("")},t.i=function(e,i,n){"string"==typeof e&&(e=[[null,e,""]]);var o={};if(n)for(var s=0;s<this.length;s++){var r=this[s][0];null!=r&&(o[r]=!0)}for(var a=0;a<e.length;a++){var l=[].concat(e[a]);n&&o[l[0]]||(i&&(l[2]?l[2]="".concat(i," and ").concat(l[2]):l[2]=i),t.push(l))}},t}},4964:e=>{e.exports=function(e,t){return t||(t={}),"string"!=typeof(e=e&&e.__esModule?e.default:e)?e:(/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e)}},2003:(e,t,i)=>{i.r(t),i.d(t,{PixelRatio:()=>h,addMatchMediaChangeListener:()=>l,getZoomFactor:()=>c,isAndroid:()=>_,isChrome:()=>m,isElectron:()=>A,isFirefox:()=>u,isSafari:()=>p,isStandalone:()=>b,isWebKit:()=>g,isWebkitWebView:()=>f});var n=i(3884),o=i(8300);class s{constructor(){this._zoomFactor=1}getZoomFactor(){return this._zoomFactor}}s.INSTANCE=new s;class r extends o.jG{constructor(){super(),this._onDidChange=this._register(new n.vl),this.onDidChange=this._onDidChange.event,this._listener=()=>this._handleChange(!0),this._mediaQueryList=null,this._handleChange(!1)}_handleChange(e){var t;null===(t=this._mediaQueryList)||void 0===t||t.removeEventListener("change",this._listener),this._mediaQueryList=window.matchMedia(`(resolution: ${window.devicePixelRatio}dppx)`),this._mediaQueryList.addEventListener("change",this._listener),e&&this._onDidChange.fire()}}class a extends o.jG{get value(){return this._value}constructor(){super(),this._onDidChange=this._register(new n.vl),this.onDidChange=this._onDidChange.event,this._value=this._getPixelRatio();const e=this._register(new r);this._register(e.onDidChange((()=>{this._value=this._getPixelRatio(),this._onDidChange.fire(this._value)})))}_getPixelRatio(){const e=document.createElement("canvas").getContext("2d");return(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1)}}function l(e,t){"string"==typeof e&&(e=window.matchMedia(e)),e.addEventListener("change",t)}const h=new class{constructor(){this._pixelRatioMonitor=null}_getOrCreatePixelRatioMonitor(){return this._pixelRatioMonitor||(this._pixelRatioMonitor=(0,o.lC)(new a)),this._pixelRatioMonitor}get value(){return this._getOrCreatePixelRatioMonitor().value}get onDidChange(){return this._getOrCreatePixelRatioMonitor().onDidChange}};function c(){return s.INSTANCE.getZoomFactor()}const d=navigator.userAgent,u=d.indexOf("Firefox")>=0,g=d.indexOf("AppleWebKit")>=0,m=d.indexOf("Chrome")>=0,p=!m&&d.indexOf("Safari")>=0,f=!m&&!p&&g,A=d.indexOf("Electron/")>=0,_=d.indexOf("Android")>=0;let w=!1;if(window.matchMedia){const e=window.matchMedia("(display-mode: standalone) or (display-mode: window-controls-overlay)"),t=window.matchMedia("(display-mode: fullscreen)");w=e.matches,l(e,(({matches:e})=>{w&&t.matches||(w=e)}))}function b(){return w}},4179:(e,t,i)=>{i.d(t,{e:()=>s});var n=i(2003),o=i(4541);const s={clipboard:{writeText:o.ib||document.queryCommandSupported&&document.queryCommandSupported("copy")||!!(navigator&&navigator.clipboard&&navigator.clipboard.writeText),readText:o.ib||!!(navigator&&navigator.clipboard&&navigator.clipboard.readText)},keyboard:o.ib||n.isStandalone()?0:navigator.keyboard||n.isSafari?1:2,touch:"ontouchstart"in window||navigator.maxTouchPoints>0,pointerEvents:window.PointerEvent&&("ontouchstart"in window||window.navigator.maxTouchPoints>0||navigator.maxTouchPoints>0)}},3037:(e,t,i)=>{i.d(t,{t:()=>n});const n={RESOURCES:"ResourceURLs",DOWNLOAD_URL:"DownloadURL",FILES:"Files",TEXT:i(2694).K.text,INTERNAL_URI_LIST:"application/vnd.code.uri-list"}},8479:(e,t,i)=>{i.d(t,{$:()=>ie,BC:()=>q,BK:()=>E,Bx:()=>V,Cl:()=>R,Di:()=>ge,Ej:()=>k,H4:()=>M,Hs:()=>$,Ln:()=>X,OK:()=>I,Oq:()=>A,PG:()=>_,QX:()=>B,TT:()=>ue,Tf:()=>le,Tr:()=>x,WU:()=>ne,Wt:()=>H,XD:()=>T,a4:()=>de,b2:()=>f,bq:()=>P,cL:()=>S,fg:()=>y,fs:()=>j,gI:()=>ce,h:()=>fe,i0:()=>ae,jD:()=>oe,jG:()=>O,jh:()=>re,ko:()=>p,li:()=>z,m1:()=>N,mU:()=>D,pN:()=>me,qD:()=>g,sb:()=>W,sd:()=>U,tG:()=>v,vT:()=>se,w5:()=>J,w_:()=>u,wk:()=>K,y6:()=>L,yt:()=>he,zK:()=>G});var n=i(2003),o=(i(4179),i(192)),s=i(9121),r=i(3329),a=i(3884),l=i(9856),h=i(8300),c=i(7446),d=i(4541);function u(e){for(;e.firstChild;)e.firstChild.remove()}function g(e){var t;return null!==(t=null==e?void 0:e.isConnected)&&void 0!==t&&t}class m{constructor(e,t,i,n){this._node=e,this._type=t,this._handler=i,this._options=n||!1,this._node.addEventListener(this._type,this._handler,this._options)}dispose(){this._handler&&(this._node.removeEventListener(this._type,this._handler,this._options),this._node=null,this._handler=null)}}function p(e,t,i,n){return new m(e,t,i,n)}const f=function(e,t,i,n){let r=i;return"click"===t||"mousedown"===t?r=function(e){return function(t){return e(new s.P(t))}}(i):"keydown"!==t&&"keypress"!==t&&"keyup"!==t||(r=function(e){return function(t){return e(new o.Z(t))}}(i)),p(e,t,r,n)};let A,_;class w{constructor(e,t=0){this._runner=e,this.priority=t,this._canceled=!1}dispose(){this._canceled=!0}execute(){if(!this._canceled)try{this._runner()}catch(e){(0,r.dz)(e)}}static sort(e,t){return t.priority-e.priority}}function b(e){return document.defaultView.getComputedStyle(e,null)}function v(e){if(e!==document.body)return new y(e.clientWidth,e.clientHeight);if(d.un&&window.visualViewport)return new y(window.visualViewport.width,window.visualViewport.height);if(window.innerWidth&&window.innerHeight)return new y(window.innerWidth,window.innerHeight);if(document.body&&document.body.clientWidth&&document.body.clientHeight)return new y(document.body.clientWidth,document.body.clientHeight);if(document.documentElement&&document.documentElement.clientWidth&&document.documentElement.clientHeight)return new y(document.documentElement.clientWidth,document.documentElement.clientHeight);throw new Error("Unable to figure out browser width and height")}!function(){let e=[],t=null,i=!1,n=!1;const o=()=>{for(i=!1,t=e,e=[],n=!0;t.length>0;)t.sort(w.sort),t.shift().execute();n=!1};_=(t,n=0)=>{const s=new w(t,n);return e.push(s),i||(i=!0,requestAnimationFrame(o)),s},A=(e,i)=>{if(n){const n=new w(e,i);return t.push(n),n}return _(e,i)}}();class C{static convertToPixels(e,t){return parseFloat(t)||0}static getDimension(e,t,i){const n=b(e),o=n?n.getPropertyValue(t):"0";return C.convertToPixels(e,o)}static getBorderLeftWidth(e){return C.getDimension(e,"border-left-width","borderLeftWidth")}static getBorderRightWidth(e){return C.getDimension(e,"border-right-width","borderRightWidth")}static getBorderTopWidth(e){return C.getDimension(e,"border-top-width","borderTopWidth")}static getBorderBottomWidth(e){return C.getDimension(e,"border-bottom-width","borderBottomWidth")}static getPaddingLeft(e){return C.getDimension(e,"padding-left","paddingLeft")}static getPaddingRight(e){return C.getDimension(e,"padding-right","paddingRight")}static getPaddingTop(e){return C.getDimension(e,"padding-top","paddingTop")}static getPaddingBottom(e){return C.getDimension(e,"padding-bottom","paddingBottom")}static getMarginLeft(e){return C.getDimension(e,"margin-left","marginLeft")}static getMarginTop(e){return C.getDimension(e,"margin-top","marginTop")}static getMarginRight(e){return C.getDimension(e,"margin-right","marginRight")}static getMarginBottom(e){return C.getDimension(e,"margin-bottom","marginBottom")}}class y{constructor(e,t){this.width=e,this.height=t}with(e=this.width,t=this.height){return e!==this.width||t!==this.height?new y(e,t):this}static is(e){return"object"==typeof e&&"number"==typeof e.height&&"number"==typeof e.width}static lift(e){return e instanceof y?e:new y(e.width,e.height)}static equals(e,t){return e===t||!(!e||!t)&&e.width===t.width&&e.height===t.height}}function S(e){let t=e.offsetParent,i=e.offsetTop,n=e.offsetLeft;for(;null!==(e=e.parentNode)&&e!==document.body&&e!==document.documentElement;){i-=e.scrollTop;const o=F(e)?null:b(e);o&&(n-="rtl"!==o.direction?e.scrollLeft:-e.scrollLeft),e===t&&(n+=C.getBorderLeftWidth(e),i+=C.getBorderTopWidth(e),i+=e.offsetTop,n+=e.offsetLeft,t=e.offsetParent)}return{left:n,top:i}}function k(e,t,i){"number"==typeof t&&(e.style.width=`${t}px`),"number"==typeof i&&(e.style.height=`${i}px`)}function E(e){const t=e.getBoundingClientRect();return{left:t.left+window.scrollX,top:t.top+window.scrollY,width:t.width,height:t.height}}function D(e){let t=e,i=1;do{const e=b(t).zoom;null!=e&&"1"!==e&&(i*=e),t=t.parentElement}while(null!==t&&t!==document.documentElement);return i}function x(e){const t=C.getMarginLeft(e)+C.getMarginRight(e);return e.offsetWidth+t}function L(e){const t=C.getBorderLeftWidth(e)+C.getBorderRightWidth(e),i=C.getPaddingLeft(e)+C.getPaddingRight(e);return e.offsetWidth-t-i}function M(e){const t=C.getBorderTopWidth(e)+C.getBorderBottomWidth(e),i=C.getPaddingTop(e)+C.getPaddingBottom(e);return e.offsetHeight-t-i}function I(e){const t=C.getMarginTop(e)+C.getMarginBottom(e);return e.offsetHeight+t}function B(e,t){for(;e;){if(e===t)return!0;e=e.parentNode}return!1}function N(e,t,i){for(;e&&e.nodeType===e.ELEMENT_NODE;){if(e.classList.contains(t))return e;if(i)if("string"==typeof i){if(e.classList.contains(i))return null}else if(e===i)return null;e=e.parentNode}return null}function T(e,t,i){return!!N(e,t,i)}function F(e){return e&&!!e.host&&!!e.mode}function R(e){return!!O(e)}function O(e){for(;e.parentNode;){if(e===document.body)return null;e=e.parentNode}return F(e)?e:null}function P(){let e=document.activeElement;for(;null==e?void 0:e.shadowRoot;)e=e.shadowRoot.activeElement;return e}function z(e=document.getElementsByTagName("head")[0],t){const i=document.createElement("style");return i.type="text/css",i.media="screen",null==t||t(i),e.appendChild(i),i}y.None=new y(0,0);let Q=null;function H(e,t,i=function(){return Q||(Q=z()),Q}()){i&&t&&i.sheet.insertRule(e+"{"+t+"}",0)}function W(e){return"object"==typeof HTMLElement?e instanceof HTMLElement:e&&"object"==typeof e&&1===e.nodeType&&"string"==typeof e.nodeName}const V={CLICK:"click",AUXCLICK:"auxclick",DBLCLICK:"dblclick",MOUSE_UP:"mouseup",MOUSE_DOWN:"mousedown",MOUSE_OVER:"mouseover",MOUSE_MOVE:"mousemove",MOUSE_OUT:"mouseout",MOUSE_ENTER:"mouseenter",MOUSE_LEAVE:"mouseleave",MOUSE_WHEEL:"wheel",POINTER_UP:"pointerup",POINTER_DOWN:"pointerdown",POINTER_MOVE:"pointermove",POINTER_LEAVE:"pointerleave",CONTEXT_MENU:"contextmenu",WHEEL:"wheel",KEY_DOWN:"keydown",KEY_PRESS:"keypress",KEY_UP:"keyup",LOAD:"load",BEFORE_UNLOAD:"beforeunload",UNLOAD:"unload",PAGE_SHOW:"pageshow",PAGE_HIDE:"pagehide",ABORT:"abort",ERROR:"error",RESIZE:"resize",SCROLL:"scroll",FULLSCREEN_CHANGE:"fullscreenchange",WK_FULLSCREEN_CHANGE:"webkitfullscreenchange",SELECT:"select",CHANGE:"change",SUBMIT:"submit",RESET:"reset",FOCUS:"focus",FOCUS_IN:"focusin",FOCUS_OUT:"focusout",BLUR:"blur",INPUT:"input",STORAGE:"storage",DRAG_START:"dragstart",DRAG:"drag",DRAG_ENTER:"dragenter",DRAG_LEAVE:"dragleave",DRAG_OVER:"dragover",DROP:"drop",DRAG_END:"dragend",ANIMATION_START:n.isWebKit?"webkitAnimationStart":"animationstart",ANIMATION_END:n.isWebKit?"webkitAnimationEnd":"animationend",ANIMATION_ITERATION:n.isWebKit?"webkitAnimationIteration":"animationiteration"};function U(e){const t=e;return!(!t||"function"!=typeof t.preventDefault||"function"!=typeof t.stopPropagation)}const j={stop:(e,t)=>(e.preventDefault(),t&&e.stopPropagation(),e)};function G(e){const t=[];for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)t[i]=e.scrollTop,e=e.parentNode;return t}function K(e,t){for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)e.scrollTop!==t[i]&&(e.scrollTop=t[i]),e=e.parentNode}class Y extends h.jG{static hasFocusWithin(e){const t=O(e);return B(t?t.activeElement:document.activeElement,e)}constructor(e){super(),this._onDidFocus=this._register(new a.vl),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new a.vl),this.onDidBlur=this._onDidBlur.event;let t=Y.hasFocusWithin(e),i=!1;const n=()=>{i=!1,t||(t=!0,this._onDidFocus.fire())},o=()=>{t&&(i=!0,window.setTimeout((()=>{i&&(i=!1,t=!1,this._onDidBlur.fire())}),0))};this._refreshStateHandler=()=>{Y.hasFocusWithin(e)!==t&&(t?o():n())},this._register(p(e,V.FOCUS,n,!0)),this._register(p(e,V.BLUR,o,!0)),this._register(p(e,V.FOCUS_IN,(()=>this._refreshStateHandler()))),this._register(p(e,V.FOCUS_OUT,(()=>this._refreshStateHandler())))}}function J(e){return new Y(e)}function q(e,...t){if(e.append(...t),1===t.length&&"string"!=typeof t[0])return t[0]}function $(e,t){return e.insertBefore(t,e.firstChild),t}function X(e,...t){e.innerText="",q(e,...t)}const Z=/([\w\-]+)?(#([\w\-]+))?((\.([\w\-]+))*)/;var ee;function te(e,t,i,...n){const o=Z.exec(t);if(!o)throw new Error("Bad use of emmet");const s=o[1]||"div";let r;return r=e!==ee.HTML?document.createElementNS(e,s):document.createElement(s),o[3]&&(r.id=o[3]),o[4]&&(r.className=o[4].replace(/\./g," ").trim()),i&&Object.entries(i).forEach((([e,t])=>{void 0!==t&&(/^on\w+$/.test(e)?r[e]=t:"selected"===e?t&&r.setAttribute(e,"true"):r.setAttribute(e,t))})),r.append(...n),r}function ie(e,t,...i){return te(ee.HTML,e,t,...i)}function ne(...e){for(const t of e)t.style.display="",t.removeAttribute("aria-hidden")}function oe(...e){for(const t of e)t.style.display="none",t.setAttribute("aria-hidden","true")}function se(e){const t=window.devicePixelRatio*e;return Math.max(1,Math.floor(t))/window.devicePixelRatio}function re(e){window.open(e,"_blank","noopener")}function ae(e){const t=()=>{e(),i=_(t)};let i=_(t);return(0,h.s)((()=>i.dispose()))}function le(e){return e?`url('${c.zl.uriToBrowserUri(e).toString(!0).replace(/'/g,"%27")}')`:"url('')"}function he(e){return`'${e.replace(/'/g,"%27")}'`}function ce(e,t){if(void 0!==e){const i=e.match(/^\s*var\((.+)\)$/);if(i){const e=i[1].split(",",2);return 2===e.length&&(t=ce(e[1].trim(),t)),`var(${e[0]}, ${t})`}return e}return t}function de(e,t=!1){const i=document.createElement("a");return l.$w("afterSanitizeAttributes",(n=>{for(const o of["href","src"])if(n.hasAttribute(o)){const s=n.getAttribute(o);if("href"===o&&s.startsWith("#"))continue;if(i.href=s,!e.includes(i.protocol.replace(/:$/,""))){if(t&&"src"===o&&i.href.startsWith("data:"))continue;n.removeAttribute(o)}}})),(0,h.s)((()=>{l.SV("afterSanitizeAttributes")}))}!function(e){e.HTML="http://www.w3.org/1999/xhtml",e.SVG="http://www.w3.org/2000/svg"}(ee||(ee={})),ie.SVG=function(e,t,...i){return te(ee.SVG,e,t,...i)},c.Ez.setPreferredWebSchema(/^https:/.test(window.location.href)?"https":"http");const ue=Object.freeze(["a","abbr","b","bdo","blockquote","br","caption","cite","code","col","colgroup","dd","del","details","dfn","div","dl","dt","em","figcaption","figure","h1","h2","h3","h4","h5","h6","hr","i","img","ins","kbd","label","li","mark","ol","p","pre","q","rp","rt","ruby","samp","small","small","source","span","strike","strong","sub","summary","sup","table","tbody","td","tfoot","th","thead","time","tr","tt","u","ul","var","video","wbr"]);Object.freeze({ALLOWED_TAGS:["a","button","blockquote","code","div","h1","h2","h3","h4","h5","h6","hr","input","label","li","p","pre","select","small","span","strong","textarea","ul","ol"],ALLOWED_ATTR:["href","data-href","data-command","target","title","name","src","alt","class","id","role","tabindex","style","data-code","width","height","align","x-dispatch","required","checked","placeholder","type","start"],RETURN_DOM:!1,RETURN_DOM_FRAGMENT:!1,RETURN_TRUSTED_TYPE:!0});class ge extends a.vl{constructor(){super(),this._subscriptions=new h.Cm,this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1},this._subscriptions.add(p(window,"keydown",(e=>{if(e.defaultPrevented)return;const t=new o.Z(e);if(6!==t.keyCode||!e.repeat){if(e.altKey&&!this._keyStatus.altKey)this._keyStatus.lastKeyPressed="alt";else if(e.ctrlKey&&!this._keyStatus.ctrlKey)this._keyStatus.lastKeyPressed="ctrl";else if(e.metaKey&&!this._keyStatus.metaKey)this._keyStatus.lastKeyPressed="meta";else if(e.shiftKey&&!this._keyStatus.shiftKey)this._keyStatus.lastKeyPressed="shift";else{if(6===t.keyCode)return;this._keyStatus.lastKeyPressed=void 0}this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyPressed&&(this._keyStatus.event=e,this.fire(this._keyStatus))}}),!0)),this._subscriptions.add(p(window,"keyup",(e=>{e.defaultPrevented||(!e.altKey&&this._keyStatus.altKey?this._keyStatus.lastKeyReleased="alt":!e.ctrlKey&&this._keyStatus.ctrlKey?this._keyStatus.lastKeyReleased="ctrl":!e.metaKey&&this._keyStatus.metaKey?this._keyStatus.lastKeyReleased="meta":!e.shiftKey&&this._keyStatus.shiftKey?this._keyStatus.lastKeyReleased="shift":this._keyStatus.lastKeyReleased=void 0,this._keyStatus.lastKeyPressed!==this._keyStatus.lastKeyReleased&&(this._keyStatus.lastKeyPressed=void 0),this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyReleased&&(this._keyStatus.event=e,this.fire(this._keyStatus)))}),!0)),this._subscriptions.add(p(document.body,"mousedown",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),this._subscriptions.add(p(document.body,"mouseup",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),this._subscriptions.add(p(document.body,"mousemove",(e=>{e.buttons&&(this._keyStatus.lastKeyPressed=void 0)}),!0)),this._subscriptions.add(p(window,"blur",(()=>{this.resetKeyStatus()})))}get keyStatus(){return this._keyStatus}resetKeyStatus(){this.doResetKeyStatus(),this.fire(this._keyStatus)}doResetKeyStatus(){this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1}}static getInstance(){return ge.instance||(ge.instance=new ge),ge.instance}dispose(){super.dispose(),this._subscriptions.dispose()}}class me extends h.jG{constructor(e,t){super(),this.element=e,this.callbacks=t,this.counter=0,this.dragStartTime=0,this.registerListeners()}registerListeners(){this._register(p(this.element,V.DRAG_ENTER,(e=>{this.counter++,this.dragStartTime=e.timeStamp,this.callbacks.onDragEnter(e)}))),this._register(p(this.element,V.DRAG_OVER,(e=>{var t,i;e.preventDefault(),null===(i=(t=this.callbacks).onDragOver)||void 0===i||i.call(t,e,e.timeStamp-this.dragStartTime)}))),this._register(p(this.element,V.DRAG_LEAVE,(e=>{this.counter--,0===this.counter&&(this.dragStartTime=0,this.callbacks.onDragLeave(e))}))),this._register(p(this.element,V.DRAG_END,(e=>{this.counter=0,this.dragStartTime=0,this.callbacks.onDragEnd(e)}))),this._register(p(this.element,V.DROP,(e=>{this.counter=0,this.dragStartTime=0,this.callbacks.onDrop(e)})))}}const pe=/(?<tag>[\w\-]+)?(?:#(?<id>[\w\-]+))?(?<class>(?:\.(?:[\w\-]+))*)(?:@(?<name>(?:[\w\_])+))?/;function fe(e,...t){let i,n;Array.isArray(t[0])?(i={},n=t[0]):(i=t[0]||{},n=t[1]);const o=pe.exec(e);if(!o||!o.groups)throw new Error("Bad use of h");const s=o.groups.tag||"div",r=document.createElement(s);o.groups.id&&(r.id=o.groups.id);const a=[];if(o.groups.class)for(const e of o.groups.class.split("."))""!==e&&a.push(e);if(void 0!==i.className)for(const e of i.className.split("."))""!==e&&a.push(e);a.length>0&&(r.className=a.join(" "));const l={};if(o.groups.name&&(l[o.groups.name]=r),n)for(const e of n)e instanceof HTMLElement?r.appendChild(e):"string"==typeof e?r.append(e):"root"in e&&(Object.assign(l,e),r.appendChild(e.root));for(const[e,t]of Object.entries(i))if("className"!==e)if("style"===e)for(const[e,i]of Object.entries(t))r.style.setProperty(Ae(e),"number"==typeof i?i+"px":""+i);else"tabIndex"===e?r.tabIndex=t:r.setAttribute(Ae(e),t.toString());return l.root=r,l}function Ae(e){return e.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}},9856:(e,t,i)=>{i.d(t,{$w:()=>$,SV:()=>X,aj:()=>q});var n=Object.hasOwnProperty,o=Object.setPrototypeOf,s=Object.isFrozen,r=Object.getPrototypeOf,a=Object.getOwnPropertyDescriptor,l=Object.freeze,h=Object.seal,c=Object.create,d="undefined"!=typeof Reflect&&Reflect,u=d.apply,g=d.construct;u||(u=function(e,t,i){return e.apply(t,i)}),l||(l=function(e){return e}),h||(h=function(e){return e}),g||(g=function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}(t))))});var m,p=k(Array.prototype.forEach),f=k(Array.prototype.pop),A=k(Array.prototype.push),_=k(String.prototype.toLowerCase),w=k(String.prototype.match),b=k(String.prototype.replace),v=k(String.prototype.indexOf),C=k(String.prototype.trim),y=k(RegExp.prototype.test),S=(m=TypeError,function(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];return g(m,t)});function k(e){return function(t){for(var i=arguments.length,n=Array(i>1?i-1:0),o=1;o<i;o++)n[o-1]=arguments[o];return u(e,t,n)}}function E(e,t){o&&o(e,null);for(var i=t.length;i--;){var n=t[i];if("string"==typeof n){var r=_(n);r!==n&&(s(t)||(t[i]=r),n=r)}e[n]=!0}return e}function D(e){var t=c(null),i=void 0;for(i in e)u(n,e,[i])&&(t[i]=e[i]);return t}function x(e,t){for(;null!==e;){var i=a(e,t);if(i){if(i.get)return k(i.get);if("function"==typeof i.value)return k(i.value)}e=r(e)}return function(e){return console.warn("fallback value for",e),null}}var L=l(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),M=l(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),I=l(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),B=l(["animate","color-profile","cursor","discard","fedropshadow","feimage","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),N=l(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),T=l(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),F=l(["#text"]),R=l(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),O=l(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),P=l(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),z=l(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),Q=h(/\{\{[\s\S]*|[\s\S]*\}\}/gm),H=h(/<%[\s\S]*|[\s\S]*%>/gm),W=h(/^data-[\-\w.\u00B7-\uFFFF]/),V=h(/^aria-[\-\w]+$/),U=h(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),j=h(/^(?:\w+script|data):/i),G=h(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),K="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function Y(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var J=function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"undefined"==typeof window?null:window,i=function(t){return e(t)};if(i.version="2.3.1",i.removed=[],!t||!t.document||9!==t.document.nodeType)return i.isSupported=!1,i;var n=t.document,o=t.document,s=t.DocumentFragment,r=t.HTMLTemplateElement,a=t.Node,h=t.Element,c=t.NodeFilter,d=t.NamedNodeMap,u=void 0===d?t.NamedNodeMap||t.MozNamedAttrMap:d,g=t.Text,m=t.Comment,k=t.DOMParser,J=t.trustedTypes,q=h.prototype,$=x(q,"cloneNode"),X=x(q,"nextSibling"),Z=x(q,"childNodes"),ee=x(q,"parentNode");if("function"==typeof r){var te=o.createElement("template");te.content&&te.content.ownerDocument&&(o=te.content.ownerDocument)}var ie=function(e,t){if("object"!==(void 0===e?"undefined":K(e))||"function"!=typeof e.createPolicy)return null;var i=null,n="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(n)&&(i=t.currentScript.getAttribute(n));var o="dompurify"+(i?"#"+i:"");try{return e.createPolicy(o,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+o+" could not be created."),null}}(J,n),ne=ie&&Fe?ie.createHTML(""):"",oe=o,se=oe.implementation,re=oe.createNodeIterator,ae=oe.createDocumentFragment,le=oe.getElementsByTagName,he=n.importNode,ce={};try{ce=D(o).documentMode?o.documentMode:{}}catch(e){}var de={};i.isSupported="function"==typeof ee&&se&&void 0!==se.createHTMLDocument&&9!==ce;var ue=Q,ge=H,me=W,pe=V,fe=j,Ae=G,_e=U,we=null,be=E({},[].concat(Y(L),Y(M),Y(I),Y(N),Y(F))),ve=null,Ce=E({},[].concat(Y(R),Y(O),Y(P),Y(z))),ye=null,Se=null,ke=!0,Ee=!0,De=!1,xe=!1,Le=!1,Me=!1,Ie=!1,Be=!1,Ne=!1,Te=!0,Fe=!1,Re=!0,Oe=!0,Pe=!1,ze={},Qe=null,He=E({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),We=null,Ve=E({},["audio","video","img","source","image","track"]),Ue=null,je=E({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),Ge="http://www.w3.org/1998/Math/MathML",Ke="http://www.w3.org/2000/svg",Ye="http://www.w3.org/1999/xhtml",Je=Ye,qe=!1,$e=null,Xe=o.createElement("form"),Ze=function(e){$e&&$e===e||(e&&"object"===(void 0===e?"undefined":K(e))||(e={}),e=D(e),we="ALLOWED_TAGS"in e?E({},e.ALLOWED_TAGS):be,ve="ALLOWED_ATTR"in e?E({},e.ALLOWED_ATTR):Ce,Ue="ADD_URI_SAFE_ATTR"in e?E(D(je),e.ADD_URI_SAFE_ATTR):je,We="ADD_DATA_URI_TAGS"in e?E(D(Ve),e.ADD_DATA_URI_TAGS):Ve,Qe="FORBID_CONTENTS"in e?E({},e.FORBID_CONTENTS):He,ye="FORBID_TAGS"in e?E({},e.FORBID_TAGS):{},Se="FORBID_ATTR"in e?E({},e.FORBID_ATTR):{},ze="USE_PROFILES"in e&&e.USE_PROFILES,ke=!1!==e.ALLOW_ARIA_ATTR,Ee=!1!==e.ALLOW_DATA_ATTR,De=e.ALLOW_UNKNOWN_PROTOCOLS||!1,xe=e.SAFE_FOR_TEMPLATES||!1,Le=e.WHOLE_DOCUMENT||!1,Be=e.RETURN_DOM||!1,Ne=e.RETURN_DOM_FRAGMENT||!1,Te=!1!==e.RETURN_DOM_IMPORT,Fe=e.RETURN_TRUSTED_TYPE||!1,Ie=e.FORCE_BODY||!1,Re=!1!==e.SANITIZE_DOM,Oe=!1!==e.KEEP_CONTENT,Pe=e.IN_PLACE||!1,_e=e.ALLOWED_URI_REGEXP||_e,Je=e.NAMESPACE||Ye,xe&&(Ee=!1),Ne&&(Be=!0),ze&&(we=E({},[].concat(Y(F))),ve=[],!0===ze.html&&(E(we,L),E(ve,R)),!0===ze.svg&&(E(we,M),E(ve,O),E(ve,z)),!0===ze.svgFilters&&(E(we,I),E(ve,O),E(ve,z)),!0===ze.mathMl&&(E(we,N),E(ve,P),E(ve,z))),e.ADD_TAGS&&(we===be&&(we=D(we)),E(we,e.ADD_TAGS)),e.ADD_ATTR&&(ve===Ce&&(ve=D(ve)),E(ve,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&E(Ue,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&(Qe===He&&(Qe=D(Qe)),E(Qe,e.FORBID_CONTENTS)),Oe&&(we["#text"]=!0),Le&&E(we,["html","head","body"]),we.table&&(E(we,["tbody"]),delete ye.tbody),l&&l(e),$e=e)},et=E({},["mi","mo","mn","ms","mtext"]),tt=E({},["foreignobject","desc","title","annotation-xml"]),it=E({},M);E(it,I),E(it,B);var nt=E({},N);E(nt,T);var ot=function(e){A(i.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=ne}catch(t){e.remove()}}},st=function(e,t){try{A(i.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){A(i.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!ve[e])if(Be||Ne)try{ot(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},rt=function(e){var t=void 0,i=void 0;if(Ie)e="<remove></remove>"+e;else{var n=w(e,/^[\r\n\t ]+/);i=n&&n[0]}var s=ie?ie.createHTML(e):e;if(Je===Ye)try{t=(new k).parseFromString(s,"text/html")}catch(e){}if(!t||!t.documentElement){t=se.createDocument(Je,"template",null);try{t.documentElement.innerHTML=qe?"":s}catch(e){}}var r=t.body||t.documentElement;return e&&i&&r.insertBefore(o.createTextNode(i),r.childNodes[0]||null),Je===Ye?le.call(t,Le?"html":"body")[0]:Le?t.documentElement:r},at=function(e){return re.call(e.ownerDocument||e,e,c.SHOW_ELEMENT|c.SHOW_COMMENT|c.SHOW_TEXT,null,!1)},lt=function(e){return"object"===(void 0===a?"undefined":K(a))?e instanceof a:e&&"object"===(void 0===e?"undefined":K(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},ht=function(e,t,n){de[e]&&p(de[e],(function(e){e.call(i,t,n,$e)}))},ct=function(e){var t,n=void 0;if(ht("beforeSanitizeElements",e,null),!((t=e)instanceof g||t instanceof m||"string"==typeof t.nodeName&&"string"==typeof t.textContent&&"function"==typeof t.removeChild&&t.attributes instanceof u&&"function"==typeof t.removeAttribute&&"function"==typeof t.setAttribute&&"string"==typeof t.namespaceURI&&"function"==typeof t.insertBefore))return ot(e),!0;if(w(e.nodeName,/[\u0080-\uFFFF]/))return ot(e),!0;var o=_(e.nodeName);if(ht("uponSanitizeElement",e,{tagName:o,allowedTags:we}),!lt(e.firstElementChild)&&(!lt(e.content)||!lt(e.content.firstElementChild))&&y(/<[/\w]/g,e.innerHTML)&&y(/<[/\w]/g,e.textContent))return ot(e),!0;if("select"===o&&y(/<template/i,e.innerHTML))return ot(e),!0;if(!we[o]||ye[o]){if(Oe&&!Qe[o]){var s=ee(e)||e.parentNode,r=Z(e)||e.childNodes;if(r&&s)for(var a=r.length-1;a>=0;--a)s.insertBefore($(r[a],!0),X(e))}return ot(e),!0}return e instanceof h&&!function(e){var t=ee(e);t&&t.tagName||(t={namespaceURI:Ye,tagName:"template"});var i=_(e.tagName),n=_(t.tagName);if(e.namespaceURI===Ke)return t.namespaceURI===Ye?"svg"===i:t.namespaceURI===Ge?"svg"===i&&("annotation-xml"===n||et[n]):Boolean(it[i]);if(e.namespaceURI===Ge)return t.namespaceURI===Ye?"math"===i:t.namespaceURI===Ke?"math"===i&&tt[n]:Boolean(nt[i]);if(e.namespaceURI===Ye){if(t.namespaceURI===Ke&&!tt[n])return!1;if(t.namespaceURI===Ge&&!et[n])return!1;var o=E({},["title","style","font","a","script"]);return!nt[i]&&(o[i]||!it[i])}return!1}(e)?(ot(e),!0):"noscript"!==o&&"noembed"!==o||!y(/<\/no(script|embed)/i,e.innerHTML)?(xe&&3===e.nodeType&&(n=e.textContent,n=b(n,ue," "),n=b(n,ge," "),e.textContent!==n&&(A(i.removed,{element:e.cloneNode()}),e.textContent=n)),ht("afterSanitizeElements",e,null),!1):(ot(e),!0)},dt=function(e,t,i){if(Re&&("id"===t||"name"===t)&&(i in o||i in Xe))return!1;if(Ee&&!Se[t]&&y(me,t));else if(ke&&y(pe,t));else{if(!ve[t]||Se[t])return!1;if(Ue[t]);else if(y(_e,b(i,Ae,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==v(i,"data:")||!We[e])if(De&&!y(fe,b(i,Ae,"")));else if(i)return!1}return!0},ut=function(e){var t=void 0,n=void 0,o=void 0,s=void 0;ht("beforeSanitizeAttributes",e,null);var r=e.attributes;if(r){var a={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:ve};for(s=r.length;s--;){var l=t=r[s],h=l.name,c=l.namespaceURI;if(n=C(t.value),o=_(h),a.attrName=o,a.attrValue=n,a.keepAttr=!0,a.forceKeepAttr=void 0,ht("uponSanitizeAttribute",e,a),n=a.attrValue,!a.forceKeepAttr&&(st(h,e),a.keepAttr))if(y(/\/>/i,n))st(h,e);else{xe&&(n=b(n,ue," "),n=b(n,ge," "));var d=e.nodeName.toLowerCase();if(dt(d,o,n))try{c?e.setAttributeNS(c,h,n):e.setAttribute(h,n),f(i.removed)}catch(e){}}}ht("afterSanitizeAttributes",e,null)}},gt=function e(t){var i=void 0,n=at(t);for(ht("beforeSanitizeShadowDOM",t,null);i=n.nextNode();)ht("uponSanitizeShadowNode",i,null),ct(i)||(i.content instanceof s&&e(i.content),ut(i));ht("afterSanitizeShadowDOM",t,null)};return i.sanitize=function(e,o){var r=void 0,l=void 0,h=void 0,c=void 0,d=void 0;if((qe=!e)&&(e="\x3c!--\x3e"),"string"!=typeof e&&!lt(e)){if("function"!=typeof e.toString)throw S("toString is not a function");if("string"!=typeof(e=e.toString()))throw S("dirty is not a string, aborting")}if(!i.isSupported){if("object"===K(t.toStaticHTML)||"function"==typeof t.toStaticHTML){if("string"==typeof e)return t.toStaticHTML(e);if(lt(e))return t.toStaticHTML(e.outerHTML)}return e}if(Me||Ze(o),i.removed=[],"string"==typeof e&&(Pe=!1),Pe);else if(e instanceof a)1===(l=(r=rt("\x3c!----\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===l.nodeName||"HTML"===l.nodeName?r=l:r.appendChild(l);else{if(!Be&&!xe&&!Le&&-1===e.indexOf("<"))return ie&&Fe?ie.createHTML(e):e;if(!(r=rt(e)))return Be?null:ne}r&&Ie&&ot(r.firstChild);for(var u=at(Pe?e:r);h=u.nextNode();)3===h.nodeType&&h===c||ct(h)||(h.content instanceof s&&gt(h.content),ut(h),c=h);if(c=null,Pe)return e;if(Be){if(Ne)for(d=ae.call(r.ownerDocument);r.firstChild;)d.appendChild(r.firstChild);else d=r;return Te&&(d=he.call(n,d,!0)),d}var g=Le?r.outerHTML:r.innerHTML;return xe&&(g=b(g,ue," "),g=b(g,ge," ")),ie&&Fe?ie.createHTML(g):g},i.setConfig=function(e){Ze(e),Me=!0},i.clearConfig=function(){$e=null,Me=!1},i.isValidAttribute=function(e,t,i){$e||Ze({});var n=_(e),o=_(t);return dt(n,o,i)},i.addHook=function(e,t){"function"==typeof t&&(de[e]=de[e]||[],A(de[e],t))},i.removeHook=function(e){de[e]&&f(de[e])},i.removeHooks=function(e){de[e]&&(de[e]=[])},i.removeAllHooks=function(){de={}},i}();J.version,J.isSupported;const q=J.sanitize,$=(J.setConfig,J.clearConfig,J.isValidAttribute,J.addHook),X=J.removeHook;J.removeHooks,J.removeAllHooks},9923:(e,t,i)=>{i.d(t,{f:()=>o});var n=i(3884);class o{get event(){return this.emitter.event}constructor(e,t,i){const o=e=>this.emitter.fire(e);this.emitter=new n.vl({onWillAddFirstListener:()=>e.addEventListener(t,o,i),onDidRemoveLastListener:()=>e.removeEventListener(t,o,i)})}dispose(){this.emitter.dispose()}}},7693:(e,t,i)=>{i.d(t,{D:()=>n,Z:()=>s});class n{constructor(e){this.domNode=e,this._maxWidth="",this._width="",this._height="",this._top="",this._left="",this._bottom="",this._right="",this._paddingLeft="",this._fontFamily="",this._fontWeight="",this._fontSize="",this._fontStyle="",this._fontFeatureSettings="",this._fontVariationSettings="",this._textDecoration="",this._lineHeight="",this._letterSpacing="",this._className="",this._display="",this._position="",this._visibility="",this._color="",this._backgroundColor="",this._layerHint=!1,this._contain="none",this._boxShadow=""}setMaxWidth(e){const t=o(e);this._maxWidth!==t&&(this._maxWidth=t,this.domNode.style.maxWidth=this._maxWidth)}setWidth(e){const t=o(e);this._width!==t&&(this._width=t,this.domNode.style.width=this._width)}setHeight(e){const t=o(e);this._height!==t&&(this._height=t,this.domNode.style.height=this._height)}setTop(e){const t=o(e);this._top!==t&&(this._top=t,this.domNode.style.top=this._top)}setLeft(e){const t=o(e);this._left!==t&&(this._left=t,this.domNode.style.left=this._left)}setBottom(e){const t=o(e);this._bottom!==t&&(this._bottom=t,this.domNode.style.bottom=this._bottom)}setRight(e){const t=o(e);this._right!==t&&(this._right=t,this.domNode.style.right=this._right)}setPaddingLeft(e){const t=o(e);this._paddingLeft!==t&&(this._paddingLeft=t,this.domNode.style.paddingLeft=this._paddingLeft)}setFontFamily(e){this._fontFamily!==e&&(this._fontFamily=e,this.domNode.style.fontFamily=this._fontFamily)}setFontWeight(e){this._fontWeight!==e&&(this._fontWeight=e,this.domNode.style.fontWeight=this._fontWeight)}setFontSize(e){const t=o(e);this._fontSize!==t&&(this._fontSize=t,this.domNode.style.fontSize=this._fontSize)}setFontStyle(e){this._fontStyle!==e&&(this._fontStyle=e,this.domNode.style.fontStyle=this._fontStyle)}setFontFeatureSettings(e){this._fontFeatureSettings!==e&&(this._fontFeatureSettings=e,this.domNode.style.fontFeatureSettings=this._fontFeatureSettings)}setFontVariationSettings(e){this._fontVariationSettings!==e&&(this._fontVariationSettings=e,this.domNode.style.fontVariationSettings=this._fontVariationSettings)}setTextDecoration(e){this._textDecoration!==e&&(this._textDecoration=e,this.domNode.style.textDecoration=this._textDecoration)}setLineHeight(e){const t=o(e);this._lineHeight!==t&&(this._lineHeight=t,this.domNode.style.lineHeight=this._lineHeight)}setLetterSpacing(e){const t=o(e);this._letterSpacing!==t&&(this._letterSpacing=t,this.domNode.style.letterSpacing=this._letterSpacing)}setClassName(e){this._className!==e&&(this._className=e,this.domNode.className=this._className)}toggleClassName(e,t){this.domNode.classList.toggle(e,t),this._className=this.domNode.className}setDisplay(e){this._display!==e&&(this._display=e,this.domNode.style.display=this._display)}setPosition(e){this._position!==e&&(this._position=e,this.domNode.style.position=this._position)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this.domNode.style.visibility=this._visibility)}setColor(e){this._color!==e&&(this._color=e,this.domNode.style.color=this._color)}setBackgroundColor(e){this._backgroundColor!==e&&(this._backgroundColor=e,this.domNode.style.backgroundColor=this._backgroundColor)}setLayerHinting(e){this._layerHint!==e&&(this._layerHint=e,this.domNode.style.transform=this._layerHint?"translate3d(0px, 0px, 0px)":"")}setBoxShadow(e){this._boxShadow!==e&&(this._boxShadow=e,this.domNode.style.boxShadow=e)}setContain(e){this._contain!==e&&(this._contain=e,this.domNode.style.contain=this._contain)}setAttribute(e,t){this.domNode.setAttribute(e,t)}removeAttribute(e){this.domNode.removeAttribute(e)}appendChild(e){this.domNode.appendChild(e.domNode)}removeChild(e){this.domNode.removeChild(e.domNode)}}function o(e){return"number"==typeof e?`${e}px`:e}function s(e){return new n(e)}},7095:(e,t,i)=>{i.d(t,{S5:()=>o,n:()=>r,yk:()=>s});var n=i(8479);function o(e,t={}){const i=r(t);return i.textContent=e,i}function s(e,t={}){const i=r(t);return l(i,function(e,t){const i={type:1,children:[]};let n=0,o=i;const s=[],r=new a(e);for(;!r.eos();){let e=r.next();const i="\\"===e&&0!==h(r.peek(),t);if(i&&(e=r.next()),i||0===h(e,t)||e!==r.peek())if("\n"===e)2===o.type&&(o=s.pop()),o.children.push({type:8});else if(2!==o.type){const t={type:2,content:e};o.children.push(t),s.push(o),o=t}else o.content+=e;else{r.advance(),2===o.type&&(o=s.pop());const i=h(e,t);if(o.type===i||5===o.type&&6===i)o=s.pop();else{const e={type:i,children:[]};5===i&&(e.index=n,n++),o.children.push(e),s.push(o),o=e}}}return 2===o.type&&(o=s.pop()),s.length,i}(e,!!t.renderCodeSegments),t.actionHandler,t.renderCodeSegments),i}function r(e){const t=e.inline?"span":"div",i=document.createElement(t);return e.className&&(i.className=e.className),i}class a{constructor(e){this.source=e,this.index=0}eos(){return this.index>=this.source.length}next(){const e=this.peek();return this.advance(),e}peek(){return this.source[this.index]}advance(){this.index++}}function l(e,t,i,o){let s;if(2===t.type)s=document.createTextNode(t.content||"");else if(3===t.type)s=document.createElement("b");else if(4===t.type)s=document.createElement("i");else if(7===t.type&&o)s=document.createElement("code");else if(5===t.type&&i){const e=document.createElement("a");i.disposables.add(n.b2(e,"click",(e=>{i.callback(String(t.index),e)}))),s=e}else 8===t.type?s=document.createElement("br"):1===t.type&&(s=e);s&&e!==s&&e.appendChild(s),s&&Array.isArray(t.children)&&t.children.forEach((e=>{l(s,e,i,o)}))}function h(e,t){switch(e){case"*":return 3;case"_":return 4;case"[":return 5;case"]":return 6;case"`":return t?7:0;default:return 0}}},6322:(e,t,i)=>{i.d(t,{_:()=>s});var n=i(8479),o=i(8300);class s{constructor(){this._hooks=new o.Cm,this._pointerMoveCallback=null,this._onStopCallback=null}dispose(){this.stopMonitoring(!1),this._hooks.dispose()}stopMonitoring(e,t){if(!this.isMonitoring())return;this._hooks.clear(),this._pointerMoveCallback=null;const i=this._onStopCallback;this._onStopCallback=null,e&&i&&i(t)}isMonitoring(){return!!this._pointerMoveCallback}startMonitoring(e,t,i,s,r){this.isMonitoring()&&this.stopMonitoring(!1),this._pointerMoveCallback=s,this._onStopCallback=r;let a=e;try{e.setPointerCapture(t),this._hooks.add((0,o.s)((()=>{try{e.releasePointerCapture(t)}catch(e){}})))}catch(e){a=window}this._hooks.add(n.ko(a,n.Bx.POINTER_MOVE,(e=>{e.buttons===i?(e.preventDefault(),this._pointerMoveCallback(e)):this.stopMonitoring(!0)}))),this._hooks.add(n.ko(a,n.Bx.POINTER_UP,(e=>this.stopMonitoring(!0))))}}},192:(e,t,i)=>{i.d(t,{Z:()=>h});var n=i(2003),o=i(9833),s=i(6021),r=i(4541);const a=r.zx?256:2048,l=r.zx?2048:256;class h{constructor(e){this._standardKeyboardEventBrand=!0;const t=e;this.browserEvent=t,this.target=t.target,this.ctrlKey=t.ctrlKey,this.shiftKey=t.shiftKey,this.altKey=t.altKey,this.metaKey=t.metaKey,this.altGraphKey=t.getModifierState("AltGraph"),this.keyCode=function(e){if(e.charCode){const t=String.fromCharCode(e.charCode).toUpperCase();return o.YM.fromString(t)}const t=e.keyCode;if(3===t)return 7;if(n.isFirefox)switch(t){case 59:return 85;case 60:if(r.j9)return 97;break;case 61:return 86;case 107:return 109;case 109:return 111;case 173:return 88;case 224:if(r.zx)return 57}else if(n.isWebKit){if(r.zx&&93===t)return 57;if(!r.zx&&92===t)return 57}return o.uw[t]||0}(t),this.code=t.code,this.ctrlKey=this.ctrlKey||5===this.keyCode,this.altKey=this.altKey||6===this.keyCode,this.shiftKey=this.shiftKey||4===this.keyCode,this.metaKey=this.metaKey||57===this.keyCode,this._asKeybinding=this._computeKeybinding(),this._asKeyCodeChord=this._computeKeyCodeChord()}preventDefault(){this.browserEvent&&this.browserEvent.preventDefault&&this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent&&this.browserEvent.stopPropagation&&this.browserEvent.stopPropagation()}toKeyCodeChord(){return this._asKeyCodeChord}equals(e){return this._asKeybinding===e}_computeKeybinding(){let e=0;5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode);let t=0;return this.ctrlKey&&(t|=a),this.altKey&&(t|=512),this.shiftKey&&(t|=1024),this.metaKey&&(t|=l),t|=e,t}_computeKeyCodeChord(){let e=0;return 5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode),new s.dG(this.ctrlKey,this.shiftKey,this.altKey,this.metaKey,e)}}},7092:(e,t,i)=>{i.d(t,{Gc:()=>E,R9:()=>I});var n=i(8479),o=i(9856),s=i(9923),r=i(7095),a=i(192),l=i(9121),h=i(8948),c=i(3329),d=i(3884),u=i(5702),g=i(9804),m=i(9582),p=i(4100),f=i(8300);let A={};!function(){function e(e,t){t(A)}var t,i;e.amd=!0,t=this,i=function(e){function t(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function i(e,i){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(n)return(n=n.call(e)).next.bind(n);if(Array.isArray(e)||(n=function(e,i){if(e){if("string"==typeof e)return t(e,i);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?t(e,i):void 0}}(e))||i&&e&&"number"==typeof e.length){n&&(e=n);var o=0;return function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function n(){return{async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1}}e.defaults={async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1};var o=/[&<>"']/,s=/[&<>"']/g,r=/[<>"']|&(?!#?\w+;)/,a=/[<>"']|&(?!#?\w+;)/g,l={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},h=function(e){return l[e]};function c(e,t){if(t){if(o.test(e))return e.replace(s,h)}else if(r.test(e))return e.replace(a,h);return e}var d=/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi;function u(e){return e.replace(d,(function(e,t){return"colon"===(t=t.toLowerCase())?":":"#"===t.charAt(0)?"x"===t.charAt(1)?String.fromCharCode(parseInt(t.substring(2),16)):String.fromCharCode(+t.substring(1)):""}))}var g=/(^|[^\[])\^/g;function m(e,t){e="string"==typeof e?e:e.source,t=t||"";var i={replace:function(t,n){return n=(n=n.source||n).replace(g,"$1"),e=e.replace(t,n),i},getRegex:function(){return new RegExp(e,t)}};return i}var p=/[^\w:]/g,f=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;function A(e,t,i){if(e){var n;try{n=decodeURIComponent(u(i)).replace(p,"").toLowerCase()}catch(e){return null}if(0===n.indexOf("javascript:")||0===n.indexOf("vbscript:")||0===n.indexOf("data:"))return null}t&&!f.test(i)&&(i=function(e,t){_[" "+e]||(w.test(e)?_[" "+e]=e+"/":_[" "+e]=k(e,"/",!0));var i=-1===(e=_[" "+e]).indexOf(":");return"//"===t.substring(0,2)?i?t:e.replace(b,"$1")+t:"/"===t.charAt(0)?i?t:e.replace(v,"$1")+t:e+t}(t,i));try{i=encodeURI(i).replace(/%25/g,"%")}catch(e){return null}return i}var _={},w=/^[^:]+:\/*[^/]*$/,b=/^([^:]+:)[\s\S]*$/,v=/^([^:]+:\/*[^/]*)[\s\S]*$/,C={exec:function(){}};function y(e){for(var t,i,n=1;n<arguments.length;n++)for(i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}function S(e,t){var i=e.replace(/\|/g,(function(e,t,i){for(var n=!1,o=t;--o>=0&&"\\"===i[o];)n=!n;return n?"|":" |"})).split(/ \|/),n=0;if(i[0].trim()||i.shift(),i.length>0&&!i[i.length-1].trim()&&i.pop(),i.length>t)i.splice(t);else for(;i.length<t;)i.push("");for(;n<i.length;n++)i[n]=i[n].trim().replace(/\\\|/g,"|");return i}function k(e,t,i){var n=e.length;if(0===n)return"";for(var o=0;o<n;){var s=e.charAt(n-o-1);if(s!==t||i){if(s===t||!i)break;o++}else o++}return e.slice(0,n-o)}function E(e){e&&e.sanitize&&!e.silent&&console.warn("marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options")}function D(e,t){if(t<1)return"";for(var i="";t>1;)1&t&&(i+=e),t>>=1,e+=e;return i+e}function x(e,t,i,n){var o=t.href,s=t.title?c(t.title):null,r=e[1].replace(/\\([\[\]])/g,"$1");if("!"!==e[0].charAt(0)){n.state.inLink=!0;var a={type:"link",raw:i,href:o,title:s,text:r,tokens:n.inlineTokens(r)};return n.state.inLink=!1,a}return{type:"image",raw:i,href:o,title:s,text:c(r)}}var L=function(){function t(t){this.options=t||e.defaults}var n=t.prototype;return n.space=function(e){var t=this.rules.block.newline.exec(e);if(t&&t[0].length>0)return{type:"space",raw:t[0]}},n.code=function(e){var t=this.rules.block.code.exec(e);if(t){var i=t[0].replace(/^ {1,4}/gm,"");return{type:"code",raw:t[0],codeBlockStyle:"indented",text:this.options.pedantic?i:k(i,"\n")}}},n.fences=function(e){var t=this.rules.block.fences.exec(e);if(t){var i=t[0],n=function(e,t){var i=e.match(/^(\s+)(?:```)/);if(null===i)return t;var n=i[1];return t.split("\n").map((function(e){var t=e.match(/^\s+/);return null===t?e:t[0].length>=n.length?e.slice(n.length):e})).join("\n")}(i,t[3]||"");return{type:"code",raw:i,lang:t[2]?t[2].trim():t[2],text:n}}},n.heading=function(e){var t=this.rules.block.heading.exec(e);if(t){var i=t[2].trim();if(/#$/.test(i)){var n=k(i,"#");this.options.pedantic?i=n.trim():n&&!/ $/.test(n)||(i=n.trim())}return{type:"heading",raw:t[0],depth:t[1].length,text:i,tokens:this.lexer.inline(i)}}},n.hr=function(e){var t=this.rules.block.hr.exec(e);if(t)return{type:"hr",raw:t[0]}},n.blockquote=function(e){var t=this.rules.block.blockquote.exec(e);if(t){var i=t[0].replace(/^ *>[ \t]?/gm,"");return{type:"blockquote",raw:t[0],tokens:this.lexer.blockTokens(i,[]),text:i}}},n.list=function(e){var t=this.rules.block.list.exec(e);if(t){var n,o,s,r,a,l,h,c,d,u,g,m,p=t[1].trim(),f=p.length>1,A={type:"list",raw:"",ordered:f,start:f?+p.slice(0,-1):"",loose:!1,items:[]};p=f?"\\d{1,9}\\"+p.slice(-1):"\\"+p,this.options.pedantic&&(p=f?p:"[*+-]");for(var _=new RegExp("^( {0,3}"+p+")((?:[\t ][^\\n]*)?(?:\\n|$))");e&&(m=!1,t=_.exec(e))&&!this.rules.block.hr.test(e);){if(n=t[0],e=e.substring(n.length),c=t[2].split("\n",1)[0],d=e.split("\n",1)[0],this.options.pedantic?(r=2,g=c.trimLeft()):(r=(r=t[2].search(/[^ ]/))>4?1:r,g=c.slice(r),r+=t[1].length),l=!1,!c&&/^ *$/.test(d)&&(n+=d+"\n",e=e.substring(d.length+1),m=!0),!m)for(var w=new RegExp("^ {0,"+Math.min(3,r-1)+"}(?:[*+-]|\\d{1,9}[.)])((?: [^\\n]*)?(?:\\n|$))"),b=new RegExp("^ {0,"+Math.min(3,r-1)+"}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)"),v=new RegExp("^ {0,"+Math.min(3,r-1)+"}(?:```|~~~)"),C=new RegExp("^ {0,"+Math.min(3,r-1)+"}#");e&&(c=u=e.split("\n",1)[0],this.options.pedantic&&(c=c.replace(/^ {1,4}(?=( {4})*[^ ])/g,"  ")),!v.test(c))&&!C.test(c)&&!w.test(c)&&!b.test(e);){if(c.search(/[^ ]/)>=r||!c.trim())g+="\n"+c.slice(r);else{if(l)break;g+="\n"+c}l||c.trim()||(l=!0),n+=u+"\n",e=e.substring(u.length+1)}A.loose||(h?A.loose=!0:/\n *\n *$/.test(n)&&(h=!0)),this.options.gfm&&(o=/^\[[ xX]\] /.exec(g))&&(s="[ ] "!==o[0],g=g.replace(/^\[[ xX]\] +/,"")),A.items.push({type:"list_item",raw:n,task:!!o,checked:s,loose:!1,text:g}),A.raw+=n}A.items[A.items.length-1].raw=n.trimRight(),A.items[A.items.length-1].text=g.trimRight(),A.raw=A.raw.trimRight();var y=A.items.length;for(a=0;a<y;a++){this.lexer.state.top=!1,A.items[a].tokens=this.lexer.blockTokens(A.items[a].text,[]);var S=A.items[a].tokens.filter((function(e){return"space"===e.type})),k=S.every((function(e){for(var t,n=0,o=i(e.raw.split(""));!(t=o()).done;)if("\n"===t.value&&(n+=1),n>1)return!0;return!1}));!A.loose&&S.length&&k&&(A.loose=!0,A.items[a].loose=!0)}return A}},n.html=function(e){var t=this.rules.block.html.exec(e);if(t){var i={type:"html",raw:t[0],pre:!this.options.sanitizer&&("pre"===t[1]||"script"===t[1]||"style"===t[1]),text:t[0]};if(this.options.sanitize){var n=this.options.sanitizer?this.options.sanitizer(t[0]):c(t[0]);i.type="paragraph",i.text=n,i.tokens=this.lexer.inline(n)}return i}},n.def=function(e){var t=this.rules.block.def.exec(e);if(t)return t[3]&&(t[3]=t[3].substring(1,t[3].length-1)),{type:"def",tag:t[1].toLowerCase().replace(/\s+/g," "),raw:t[0],href:t[2],title:t[3]}},n.table=function(e){var t=this.rules.block.table.exec(e);if(t){var i={type:"table",header:S(t[1]).map((function(e){return{text:e}})),align:t[2].replace(/^ *|\| *$/g,"").split(/ *\| */),rows:t[3]&&t[3].trim()?t[3].replace(/\n[ \t]*$/,"").split("\n"):[]};if(i.header.length===i.align.length){i.raw=t[0];var n,o,s,r,a=i.align.length;for(n=0;n<a;n++)/^ *-+: *$/.test(i.align[n])?i.align[n]="right":/^ *:-+: *$/.test(i.align[n])?i.align[n]="center":/^ *:-+ *$/.test(i.align[n])?i.align[n]="left":i.align[n]=null;for(a=i.rows.length,n=0;n<a;n++)i.rows[n]=S(i.rows[n],i.header.length).map((function(e){return{text:e}}));for(a=i.header.length,o=0;o<a;o++)i.header[o].tokens=this.lexer.inline(i.header[o].text);for(a=i.rows.length,o=0;o<a;o++)for(r=i.rows[o],s=0;s<r.length;s++)r[s].tokens=this.lexer.inline(r[s].text);return i}}},n.lheading=function(e){var t=this.rules.block.lheading.exec(e);if(t)return{type:"heading",raw:t[0],depth:"="===t[2].charAt(0)?1:2,text:t[1],tokens:this.lexer.inline(t[1])}},n.paragraph=function(e){var t=this.rules.block.paragraph.exec(e);if(t){var i="\n"===t[1].charAt(t[1].length-1)?t[1].slice(0,-1):t[1];return{type:"paragraph",raw:t[0],text:i,tokens:this.lexer.inline(i)}}},n.text=function(e){var t=this.rules.block.text.exec(e);if(t)return{type:"text",raw:t[0],text:t[0],tokens:this.lexer.inline(t[0])}},n.escape=function(e){var t=this.rules.inline.escape.exec(e);if(t)return{type:"escape",raw:t[0],text:c(t[1])}},n.tag=function(e){var t=this.rules.inline.tag.exec(e);if(t)return!this.lexer.state.inLink&&/^<a /i.test(t[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&/^<\/a>/i.test(t[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&/^<(pre|code|kbd|script)(\s|>)/i.test(t[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(t[0])&&(this.lexer.state.inRawBlock=!1),{type:this.options.sanitize?"text":"html",raw:t[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,text:this.options.sanitize?this.options.sanitizer?this.options.sanitizer(t[0]):c(t[0]):t[0]}},n.link=function(e){var t=this.rules.inline.link.exec(e);if(t){var i=t[2].trim();if(!this.options.pedantic&&/^</.test(i)){if(!/>$/.test(i))return;var n=k(i.slice(0,-1),"\\");if((i.length-n.length)%2==0)return}else{var o=function(e,t){if(-1===e.indexOf(t[1]))return-1;for(var i=e.length,n=0,o=0;o<i;o++)if("\\"===e[o])o++;else if(e[o]===t[0])n++;else if(e[o]===t[1]&&--n<0)return o;return-1}(t[2],"()");if(o>-1){var s=(0===t[0].indexOf("!")?5:4)+t[1].length+o;t[2]=t[2].substring(0,o),t[0]=t[0].substring(0,s).trim(),t[3]=""}}var r=t[2],a="";if(this.options.pedantic){var l=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(r);l&&(r=l[1],a=l[3])}else a=t[3]?t[3].slice(1,-1):"";return r=r.trim(),/^</.test(r)&&(r=this.options.pedantic&&!/>$/.test(i)?r.slice(1):r.slice(1,-1)),x(t,{href:r?r.replace(this.rules.inline._escapes,"$1"):r,title:a?a.replace(this.rules.inline._escapes,"$1"):a},t[0],this.lexer)}},n.reflink=function(e,t){var i;if((i=this.rules.inline.reflink.exec(e))||(i=this.rules.inline.nolink.exec(e))){var n=(i[2]||i[1]).replace(/\s+/g," ");if(!(n=t[n.toLowerCase()])||!n.href){var o=i[0].charAt(0);return{type:"text",raw:o,text:o}}return x(i,n,i[0],this.lexer)}},n.emStrong=function(e,t,i){void 0===i&&(i="");var n=this.rules.inline.emStrong.lDelim.exec(e);if(n&&(!n[3]||!i.match(/(?:[0-9A-Za-z\xAA\xB2\xB3\xB5\xB9\xBA\xBC-\xBE\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u0660-\u0669\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0966-\u096F\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09F9\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AE6-\u0AEF\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B6F\u0B71-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0BE6-\u0BF2\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C66-\u0C6F\u0C78-\u0C7E\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D58-\u0D61\u0D66-\u0D78\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DE6-\u0DEF\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F20-\u0F33\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F-\u1049\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u1090-\u1099\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1369-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A20-\u1A54\u1A80-\u1A89\u1A90-\u1A99\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B50-\u1B59\u1B83-\u1BA0\u1BAE-\u1BE5\u1C00-\u1C23\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2070\u2071\u2074-\u2079\u207F-\u2089\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2CFD\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3192-\u3195\u31A0-\u31BF\u31F0-\u31FF\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA830-\uA835\uA840-\uA873\uA882-\uA8B3\uA8D0-\uA8D9\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA900-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF-\uA9D9\uA9E0-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA50-\uAA59\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD07-\uDD33\uDD40-\uDD78\uDD8A\uDD8B\uDE80-\uDE9C\uDEA0-\uDED0\uDEE1-\uDEFB\uDF00-\uDF23\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDD70-\uDD7A\uDD7C-\uDD8A\uDD8C-\uDD92\uDD94\uDD95\uDD97-\uDDA1\uDDA3-\uDDB1\uDDB3-\uDDB9\uDDBB\uDDBC\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67\uDF80-\uDF85\uDF87-\uDFB0\uDFB2-\uDFBA]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC58-\uDC76\uDC79-\uDC9E\uDCA7-\uDCAF\uDCE0-\uDCF2\uDCF4\uDCF5\uDCFB-\uDD1B\uDD20-\uDD39\uDD80-\uDDB7\uDDBC-\uDDCF\uDDD2-\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE40-\uDE48\uDE60-\uDE7E\uDE80-\uDE9F\uDEC0-\uDEC7\uDEC9-\uDEE4\uDEEB-\uDEEF\uDF00-\uDF35\uDF40-\uDF55\uDF58-\uDF72\uDF78-\uDF91\uDFA9-\uDFAF]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDCFA-\uDD23\uDD30-\uDD39\uDE60-\uDE7E\uDE80-\uDEA9\uDEB0\uDEB1\uDF00-\uDF27\uDF30-\uDF45\uDF51-\uDF54\uDF70-\uDF81\uDFB0-\uDFCB\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC52-\uDC6F\uDC71\uDC72\uDC75\uDC83-\uDCAF\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD03-\uDD26\uDD36-\uDD3F\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDD0-\uDDDA\uDDDC\uDDE1-\uDDF4\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDEF0-\uDEF9\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC50-\uDC59\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE50-\uDE59\uDE80-\uDEAA\uDEB8\uDEC0-\uDEC9\uDF00-\uDF1A\uDF30-\uDF3B\uDF40-\uDF46]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCF2\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDD50-\uDD59\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEB0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC50-\uDC6C\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD50-\uDD59\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDDA0-\uDDA9\uDEE0-\uDEF2\uDFB0\uDFC0-\uDFD4]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|\uD80B[\uDF90-\uDFF0]|[\uD80C\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDE70-\uDEBE\uDEC0-\uDEC9\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF50-\uDF59\uDF5B-\uDF61\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDE40-\uDE96\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDD00-\uDD08]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD50-\uDD52\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD834[\uDEE0-\uDEF3\uDF60-\uDF78]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD837[\uDF00-\uDF1E]|\uD838[\uDD00-\uDD2C\uDD37-\uDD3D\uDD40-\uDD49\uDD4E\uDE90-\uDEAD\uDEC0-\uDEEB\uDEF0-\uDEF9]|\uD839[\uDFE0-\uDFE6\uDFE8-\uDFEB\uDFED\uDFEE\uDFF0-\uDFFE]|\uD83A[\uDC00-\uDCC4\uDCC7-\uDCCF\uDD00-\uDD43\uDD4B\uDD50-\uDD59]|\uD83B[\uDC71-\uDCAB\uDCAD-\uDCAF\uDCB1-\uDCB4\uDD01-\uDD2D\uDD2F-\uDD3D\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD83C[\uDD00-\uDD0C]|\uD83E[\uDFF0-\uDFF9]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF38\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A])/))){var o=n[1]||n[2]||"";if(!o||o&&(""===i||this.rules.inline.punctuation.exec(i))){var s,r,a=n[0].length-1,l=a,h=0,c="*"===n[0][0]?this.rules.inline.emStrong.rDelimAst:this.rules.inline.emStrong.rDelimUnd;for(c.lastIndex=0,t=t.slice(-1*e.length+a);null!=(n=c.exec(t));)if(s=n[1]||n[2]||n[3]||n[4]||n[5]||n[6])if(r=s.length,n[3]||n[4])l+=r;else if(!((n[5]||n[6])&&a%3)||(a+r)%3){if(!((l-=r)>0)){if(r=Math.min(r,r+l+h),Math.min(a,r)%2){var d=e.slice(1,a+n.index+r);return{type:"em",raw:e.slice(0,a+n.index+r+1),text:d,tokens:this.lexer.inlineTokens(d)}}var u=e.slice(2,a+n.index+r-1);return{type:"strong",raw:e.slice(0,a+n.index+r+1),text:u,tokens:this.lexer.inlineTokens(u)}}}else h+=r}}},n.codespan=function(e){var t=this.rules.inline.code.exec(e);if(t){var i=t[2].replace(/\n/g," "),n=/[^ ]/.test(i),o=/^ /.test(i)&&/ $/.test(i);return n&&o&&(i=i.substring(1,i.length-1)),i=c(i,!0),{type:"codespan",raw:t[0],text:i}}},n.br=function(e){var t=this.rules.inline.br.exec(e);if(t)return{type:"br",raw:t[0]}},n.del=function(e){var t=this.rules.inline.del.exec(e);if(t)return{type:"del",raw:t[0],text:t[2],tokens:this.lexer.inlineTokens(t[2])}},n.autolink=function(e,t){var i,n,o=this.rules.inline.autolink.exec(e);if(o)return n="@"===o[2]?"mailto:"+(i=c(this.options.mangle?t(o[1]):o[1])):i=c(o[1]),{type:"link",raw:o[0],text:i,href:n,tokens:[{type:"text",raw:i,text:i}]}},n.url=function(e,t){var i;if(i=this.rules.inline.url.exec(e)){var n,o;if("@"===i[2])o="mailto:"+(n=c(this.options.mangle?t(i[0]):i[0]));else{var s;do{s=i[0],i[0]=this.rules.inline._backpedal.exec(i[0])[0]}while(s!==i[0]);n=c(i[0]),o="www."===i[1]?"http://"+n:n}return{type:"link",raw:i[0],text:n,href:o,tokens:[{type:"text",raw:n,text:n}]}}},n.inlineText=function(e,t){var i,n=this.rules.inline.text.exec(e);if(n)return i=this.lexer.state.inRawBlock?this.options.sanitize?this.options.sanitizer?this.options.sanitizer(n[0]):c(n[0]):n[0]:c(this.options.smartypants?t(n[0]):n[0]),{type:"text",raw:n[0],text:i}},t}(),M={newline:/^(?: *(?:\n|$))+/,code:/^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,fences:/^ {0,3}(`{3,}(?=[^`\n]*\n)|~{3,})([^\n]*)\n(?:|([\s\S]*?)\n)(?: {0,3}\1[~`]* *(?=\n|$)|$)/,hr:/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/,html:"^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$))",def:/^ {0,3}\[(label)\]: *(?:\n *)?<?([^\s>]+)>?(?:(?: +(?:\n *)?| *\n *)(title))? *(?:\n+|$)/,table:C,lheading:/^([^\n]+)\n {0,3}(=+|-+) *(?:\n+|$)/,_paragraph:/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,text:/^[^\n]+/,_label:/(?!\s*\])(?:\\.|[^\[\]\\])+/,_title:/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/};M.def=m(M.def).replace("label",M._label).replace("title",M._title).getRegex(),M.bullet=/(?:[*+-]|\d{1,9}[.)])/,M.listItemStart=m(/^( *)(bull) */).replace("bull",M.bullet).getRegex(),M.list=m(M.list).replace(/bull/g,M.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+M.def.source+")").getRegex(),M._tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",M._comment=/<!--(?!-?>)[\s\S]*?(?:-->|$)/,M.html=m(M.html,"i").replace("comment",M._comment).replace("tag",M._tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),M.paragraph=m(M._paragraph).replace("hr",M.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",M._tag).getRegex(),M.blockquote=m(M.blockquote).replace("paragraph",M.paragraph).getRegex(),M.normal=y({},M),M.gfm=y({},M.normal,{table:"^ *([^\\n ].*\\|.*)\\n {0,3}(?:\\| *)?(:?-+:? *(?:\\| *:?-+:? *)*)(?:\\| *)?(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)"}),M.gfm.table=m(M.gfm.table).replace("hr",M.hr).replace("heading"," {0,3}#{1,6} ").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",M._tag).getRegex(),M.gfm.paragraph=m(M._paragraph).replace("hr",M.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("table",M.gfm.table).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",M._tag).getRegex(),M.pedantic=y({},M.normal,{html:m("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",M._comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:C,paragraph:m(M.normal._paragraph).replace("hr",M.hr).replace("heading"," *#{1,6} *[^\n]").replace("lheading",M.lheading).replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").getRegex()});var I={escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:C,tag:"^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>",link:/^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,reflink:/^!?\[(label)\]\[(ref)\]/,nolink:/^!?\[(ref)\](?:\[\])?/,reflinkSearch:"reflink|nolink(?!\\()",emStrong:{lDelim:/^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,rDelimAst:/^[^_*]*?\_\_[^_*]*?\*[^_*]*?(?=\_\_)|[^*]+(?=[^*])|[punct_](\*+)(?=[\s]|$)|[^punct*_\s](\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|[^punct*_\s](\*+)(?=[^punct*_\s])/,rDelimUnd:/^[^_*]*?\*\*[^_*]*?\_[^_*]*?(?=\*\*)|[^_]+(?=[^_])|[punct*](\_+)(?=[\s]|$)|[^punct*_\s](\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/},code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,br:/^( {2,}|\\)\n(?!\s*$)/,del:C,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,punctuation:/^([\spunctuation])/};function B(e){return e.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…")}function N(e){var t,i,n="",o=e.length;for(t=0;t<o;t++)i=e.charCodeAt(t),Math.random()>.5&&(i="x"+i.toString(16)),n+="&#"+i+";";return n}I._punctuation="!\"#$%&'()+\\-.,/:;<=>?@\\[\\]`^{|}~",I.punctuation=m(I.punctuation).replace(/punctuation/g,I._punctuation).getRegex(),I.blockSkip=/\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g,I.escapedEmSt=/\\\*|\\_/g,I._comment=m(M._comment).replace("(?:--\x3e|$)","--\x3e").getRegex(),I.emStrong.lDelim=m(I.emStrong.lDelim).replace(/punct/g,I._punctuation).getRegex(),I.emStrong.rDelimAst=m(I.emStrong.rDelimAst,"g").replace(/punct/g,I._punctuation).getRegex(),I.emStrong.rDelimUnd=m(I.emStrong.rDelimUnd,"g").replace(/punct/g,I._punctuation).getRegex(),I._escapes=/\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g,I._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,I._email=/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,I.autolink=m(I.autolink).replace("scheme",I._scheme).replace("email",I._email).getRegex(),I._attribute=/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/,I.tag=m(I.tag).replace("comment",I._comment).replace("attribute",I._attribute).getRegex(),I._label=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,I._href=/<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/,I._title=/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/,I.link=m(I.link).replace("label",I._label).replace("href",I._href).replace("title",I._title).getRegex(),I.reflink=m(I.reflink).replace("label",I._label).replace("ref",M._label).getRegex(),I.nolink=m(I.nolink).replace("ref",M._label).getRegex(),I.reflinkSearch=m(I.reflinkSearch,"g").replace("reflink",I.reflink).replace("nolink",I.nolink).getRegex(),I.normal=y({},I),I.pedantic=y({},I.normal,{strong:{start:/^__|\*\*/,middle:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,endAst:/\*\*(?!\*)/g,endUnd:/__(?!_)/g},em:{start:/^_|\*/,middle:/^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,endAst:/\*(?!\*)/g,endUnd:/_(?!_)/g},link:m(/^!?\[(label)\]\((.*?)\)/).replace("label",I._label).getRegex(),reflink:m(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",I._label).getRegex()}),I.gfm=y({},I.normal,{escape:m(I.escape).replace("])","~|])").getRegex(),_extended_email:/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,url:/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,_backpedal:/(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/}),I.gfm.url=m(I.gfm.url,"i").replace("email",I.gfm._extended_email).getRegex(),I.breaks=y({},I.gfm,{br:m(I.br).replace("{2,}","*").getRegex(),text:m(I.gfm.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()});var T=function(){function t(t){this.tokens=[],this.tokens.links=Object.create(null),this.options=t||e.defaults,this.options.tokenizer=this.options.tokenizer||new L,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};var i={block:M.normal,inline:I.normal};this.options.pedantic?(i.block=M.pedantic,i.inline=I.pedantic):this.options.gfm&&(i.block=M.gfm,this.options.breaks?i.inline=I.breaks:i.inline=I.gfm),this.tokenizer.rules=i}t.lex=function(e,i){return new t(i).lex(e)},t.lexInline=function(e,i){return new t(i).inlineTokens(e)};var i,n,o=t.prototype;return o.lex=function(e){var t;for(e=e.replace(/\r\n|\r/g,"\n"),this.blockTokens(e,this.tokens);t=this.inlineQueue.shift();)this.inlineTokens(t.src,t.tokens);return this.tokens},o.blockTokens=function(e,t){var i,n,o,s,r=this;for(void 0===t&&(t=[]),e=this.options.pedantic?e.replace(/\t/g,"    ").replace(/^ +$/gm,""):e.replace(/^( *)(\t+)/gm,(function(e,t,i){return t+"    ".repeat(i.length)}));e;)if(!(this.options.extensions&&this.options.extensions.block&&this.options.extensions.block.some((function(n){return!!(i=n.call({lexer:r},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)}))))if(i=this.tokenizer.space(e))e=e.substring(i.raw.length),1===i.raw.length&&t.length>0?t[t.length-1].raw+="\n":t.push(i);else if(i=this.tokenizer.code(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?t.push(i):(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.fences(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.heading(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.hr(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.blockquote(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.list(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.html(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.def(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?this.tokens.links[i.tag]||(this.tokens.links[i.tag]={href:i.href,title:i.title}):(n.raw+="\n"+i.raw,n.text+="\n"+i.raw,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.table(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.lheading(e))e=e.substring(i.raw.length),t.push(i);else if(o=e,this.options.extensions&&this.options.extensions.startBlock&&function(){var t=1/0,i=e.slice(1),n=void 0;r.options.extensions.startBlock.forEach((function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))})),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),this.state.top&&(i=this.tokenizer.paragraph(o)))n=t[t.length-1],s&&"paragraph"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i),s=o.length!==e.length,e=e.substring(i.raw.length);else if(i=this.tokenizer.text(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i);else if(e){var a="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(a);break}throw new Error(a)}return this.state.top=!0,t},o.inline=function(e,t){return void 0===t&&(t=[]),this.inlineQueue.push({src:e,tokens:t}),t},o.inlineTokens=function(e,t){var i,n,o,s=this;void 0===t&&(t=[]);var r,a,l,h=e;if(this.tokens.links){var c=Object.keys(this.tokens.links);if(c.length>0)for(;null!=(r=this.tokenizer.rules.inline.reflinkSearch.exec(h));)c.includes(r[0].slice(r[0].lastIndexOf("[")+1,-1))&&(h=h.slice(0,r.index)+"["+D("a",r[0].length-2)+"]"+h.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(r=this.tokenizer.rules.inline.blockSkip.exec(h));)h=h.slice(0,r.index)+"["+D("a",r[0].length-2)+"]"+h.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);for(;null!=(r=this.tokenizer.rules.inline.escapedEmSt.exec(h));)h=h.slice(0,r.index)+"++"+h.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex);for(;e;)if(a||(l=""),a=!1,!(this.options.extensions&&this.options.extensions.inline&&this.options.extensions.inline.some((function(n){return!!(i=n.call({lexer:s},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)}))))if(i=this.tokenizer.escape(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.tag(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.link(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.reflink(e,this.tokens.links))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.emStrong(e,h,l))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.codespan(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.br(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.del(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.autolink(e,N))e=e.substring(i.raw.length),t.push(i);else if(this.state.inLink||!(i=this.tokenizer.url(e,N))){if(o=e,this.options.extensions&&this.options.extensions.startInline&&function(){var t=1/0,i=e.slice(1),n=void 0;s.options.extensions.startInline.forEach((function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))})),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),i=this.tokenizer.inlineText(o,B))e=e.substring(i.raw.length),"_"!==i.raw.slice(-1)&&(l=i.raw.slice(-1)),a=!0,(n=t[t.length-1])&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(e){var d="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(d);break}throw new Error(d)}}else e=e.substring(i.raw.length),t.push(i);return t},i=t,(n=[{key:"rules",get:function(){return{block:M,inline:I}}}])&&function(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}(i,n),Object.defineProperty(i,"prototype",{writable:!1}),t}(),F=function(){function t(t){this.options=t||e.defaults}var i=t.prototype;return i.code=function(e,t,i){var n=(t||"").match(/\S*/)[0];if(this.options.highlight){var o=this.options.highlight(e,n);null!=o&&o!==e&&(i=!0,e=o)}return e=e.replace(/\n$/,"")+"\n",n?'<pre><code class="'+this.options.langPrefix+c(n,!0)+'">'+(i?e:c(e,!0))+"</code></pre>\n":"<pre><code>"+(i?e:c(e,!0))+"</code></pre>\n"},i.blockquote=function(e){return"<blockquote>\n"+e+"</blockquote>\n"},i.html=function(e){return e},i.heading=function(e,t,i,n){return this.options.headerIds?"<h"+t+' id="'+(this.options.headerPrefix+n.slug(i))+'">'+e+"</h"+t+">\n":"<h"+t+">"+e+"</h"+t+">\n"},i.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},i.list=function(e,t,i){var n=t?"ol":"ul";return"<"+n+(t&&1!==i?' start="'+i+'"':"")+">\n"+e+"</"+n+">\n"},i.listitem=function(e){return"<li>"+e+"</li>\n"},i.checkbox=function(e){return"<input "+(e?'checked="" ':"")+'disabled="" type="checkbox"'+(this.options.xhtml?" /":"")+"> "},i.paragraph=function(e){return"<p>"+e+"</p>\n"},i.table=function(e,t){return t&&(t="<tbody>"+t+"</tbody>"),"<table>\n<thead>\n"+e+"</thead>\n"+t+"</table>\n"},i.tablerow=function(e){return"<tr>\n"+e+"</tr>\n"},i.tablecell=function(e,t){var i=t.header?"th":"td";return(t.align?"<"+i+' align="'+t.align+'">':"<"+i+">")+e+"</"+i+">\n"},i.strong=function(e){return"<strong>"+e+"</strong>"},i.em=function(e){return"<em>"+e+"</em>"},i.codespan=function(e){return"<code>"+e+"</code>"},i.br=function(){return this.options.xhtml?"<br/>":"<br>"},i.del=function(e){return"<del>"+e+"</del>"},i.link=function(e,t,i){if(null===(e=A(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<a href="'+c(e)+'"';return t&&(n+=' title="'+t+'"'),n+">"+i+"</a>"},i.image=function(e,t,i){if(null===(e=A(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<img src="'+e+'" alt="'+i+'"';return t&&(n+=' title="'+t+'"'),n+(this.options.xhtml?"/>":">")},i.text=function(e){return e},t}(),R=function(){function e(){}var t=e.prototype;return t.strong=function(e){return e},t.em=function(e){return e},t.codespan=function(e){return e},t.del=function(e){return e},t.html=function(e){return e},t.text=function(e){return e},t.link=function(e,t,i){return""+i},t.image=function(e,t,i){return""+i},t.br=function(){return""},e}(),O=function(){function e(){this.seen={}}var t=e.prototype;return t.serialize=function(e){return e.toLowerCase().trim().replace(/<[!\/a-z].*?>/gi,"").replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g,"").replace(/\s/g,"-")},t.getNextSafeSlug=function(e,t){var i=e,n=0;if(this.seen.hasOwnProperty(i)){n=this.seen[e];do{i=e+"-"+ ++n}while(this.seen.hasOwnProperty(i))}return t||(this.seen[e]=n,this.seen[i]=0),i},t.slug=function(e,t){void 0===t&&(t={});var i=this.serialize(e);return this.getNextSafeSlug(i,t.dryrun)},e}(),P=function(){function t(t){this.options=t||e.defaults,this.options.renderer=this.options.renderer||new F,this.renderer=this.options.renderer,this.renderer.options=this.options,this.textRenderer=new R,this.slugger=new O}t.parse=function(e,i){return new t(i).parse(e)},t.parseInline=function(e,i){return new t(i).parseInline(e)};var i=t.prototype;return i.parse=function(e,t){void 0===t&&(t=!0);var i,n,o,s,r,a,l,h,c,d,g,m,p,f,A,_,w,b,v,C="",y=e.length;for(i=0;i<y;i++)if(d=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[d.type])||!1===(v=this.options.extensions.renderers[d.type].call({parser:this},d))&&["space","hr","heading","code","table","blockquote","list","html","paragraph","text"].includes(d.type))switch(d.type){case"space":continue;case"hr":C+=this.renderer.hr();continue;case"heading":C+=this.renderer.heading(this.parseInline(d.tokens),d.depth,u(this.parseInline(d.tokens,this.textRenderer)),this.slugger);continue;case"code":C+=this.renderer.code(d.text,d.lang,d.escaped);continue;case"table":for(h="",l="",s=d.header.length,n=0;n<s;n++)l+=this.renderer.tablecell(this.parseInline(d.header[n].tokens),{header:!0,align:d.align[n]});for(h+=this.renderer.tablerow(l),c="",s=d.rows.length,n=0;n<s;n++){for(l="",r=(a=d.rows[n]).length,o=0;o<r;o++)l+=this.renderer.tablecell(this.parseInline(a[o].tokens),{header:!1,align:d.align[o]});c+=this.renderer.tablerow(l)}C+=this.renderer.table(h,c);continue;case"blockquote":c=this.parse(d.tokens),C+=this.renderer.blockquote(c);continue;case"list":for(g=d.ordered,m=d.start,p=d.loose,s=d.items.length,c="",n=0;n<s;n++)_=(A=d.items[n]).checked,w=A.task,f="",A.task&&(b=this.renderer.checkbox(_),p?A.tokens.length>0&&"paragraph"===A.tokens[0].type?(A.tokens[0].text=b+" "+A.tokens[0].text,A.tokens[0].tokens&&A.tokens[0].tokens.length>0&&"text"===A.tokens[0].tokens[0].type&&(A.tokens[0].tokens[0].text=b+" "+A.tokens[0].tokens[0].text)):A.tokens.unshift({type:"text",text:b}):f+=b),f+=this.parse(A.tokens,p),c+=this.renderer.listitem(f,w,_);C+=this.renderer.list(c,g,m);continue;case"html":C+=this.renderer.html(d.text);continue;case"paragraph":C+=this.renderer.paragraph(this.parseInline(d.tokens));continue;case"text":for(c=d.tokens?this.parseInline(d.tokens):d.text;i+1<y&&"text"===e[i+1].type;)c+="\n"+((d=e[++i]).tokens?this.parseInline(d.tokens):d.text);C+=t?this.renderer.paragraph(c):c;continue;default:var S='Token with "'+d.type+'" type was not found.';if(this.options.silent)return void console.error(S);throw new Error(S)}else C+=v||"";return C},i.parseInline=function(e,t){t=t||this.renderer;var i,n,o,s="",r=e.length;for(i=0;i<r;i++)if(n=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[n.type])||!1===(o=this.options.extensions.renderers[n.type].call({parser:this},n))&&["escape","html","link","image","strong","em","codespan","br","del","text"].includes(n.type))switch(n.type){case"escape":case"text":s+=t.text(n.text);break;case"html":s+=t.html(n.text);break;case"link":s+=t.link(n.href,n.title,this.parseInline(n.tokens,t));break;case"image":s+=t.image(n.href,n.title,n.text);break;case"strong":s+=t.strong(this.parseInline(n.tokens,t));break;case"em":s+=t.em(this.parseInline(n.tokens,t));break;case"codespan":s+=t.codespan(n.text);break;case"br":s+=t.br();break;case"del":s+=t.del(this.parseInline(n.tokens,t));break;default:var a='Token with "'+n.type+'" type was not found.';if(this.options.silent)return void console.error(a);throw new Error(a)}else s+=o||"";return s},t}();function z(e,t,i){if(null==e)throw new Error("marked(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");if("function"==typeof t&&(i=t,t=null),E(t=y({},z.defaults,t||{})),i){var n,o=t.highlight;try{n=T.lex(e,t)}catch(e){return i(e)}var s=function(e){var s;if(!e)try{t.walkTokens&&z.walkTokens(n,t.walkTokens),s=P.parse(n,t)}catch(t){e=t}return t.highlight=o,e?i(e):i(null,s)};if(!o||o.length<3)return s();if(delete t.highlight,!n.length)return s();var r=0;return z.walkTokens(n,(function(e){"code"===e.type&&(r++,setTimeout((function(){o(e.text,e.lang,(function(t,i){if(t)return s(t);null!=i&&i!==e.text&&(e.text=i,e.escaped=!0),0==--r&&s()}))}),0))})),void(0===r&&s())}function a(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+c(e.message+"",!0)+"</pre>";throw e}try{var l=T.lex(e,t);if(t.walkTokens){if(t.async)return Promise.all(z.walkTokens(l,t.walkTokens)).then((function(){return P.parse(l,t)})).catch(a);z.walkTokens(l,t.walkTokens)}return P.parse(l,t)}catch(e){a(e)}}z.options=z.setOptions=function(t){var i;return y(z.defaults,t),i=z.defaults,e.defaults=i,z},z.getDefaults=n,z.defaults=e.defaults,z.use=function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];var n,o=y.apply(void 0,[{}].concat(t)),s=z.defaults.extensions||{renderers:{},childTokens:{}};t.forEach((function(e){if(e.extensions&&(n=!0,e.extensions.forEach((function(e){if(!e.name)throw new Error("extension name required");if(e.renderer){var t=s.renderers?s.renderers[e.name]:null;s.renderers[e.name]=t?function(){for(var i=arguments.length,n=new Array(i),o=0;o<i;o++)n[o]=arguments[o];var s=e.renderer.apply(this,n);return!1===s&&(s=t.apply(this,n)),s}:e.renderer}if(e.tokenizer){if(!e.level||"block"!==e.level&&"inline"!==e.level)throw new Error("extension level must be 'block' or 'inline'");s[e.level]?s[e.level].unshift(e.tokenizer):s[e.level]=[e.tokenizer],e.start&&("block"===e.level?s.startBlock?s.startBlock.push(e.start):s.startBlock=[e.start]:"inline"===e.level&&(s.startInline?s.startInline.push(e.start):s.startInline=[e.start]))}e.childTokens&&(s.childTokens[e.name]=e.childTokens)}))),e.renderer&&function(){var t=z.defaults.renderer||new F,i=function(i){var n=t[i];t[i]=function(){for(var o=arguments.length,s=new Array(o),r=0;r<o;r++)s[r]=arguments[r];var a=e.renderer[i].apply(t,s);return!1===a&&(a=n.apply(t,s)),a}};for(var n in e.renderer)i(n);o.renderer=t}(),e.tokenizer&&function(){var t=z.defaults.tokenizer||new L,i=function(i){var n=t[i];t[i]=function(){for(var o=arguments.length,s=new Array(o),r=0;r<o;r++)s[r]=arguments[r];var a=e.tokenizer[i].apply(t,s);return!1===a&&(a=n.apply(t,s)),a}};for(var n in e.tokenizer)i(n);o.tokenizer=t}(),e.walkTokens){var t=z.defaults.walkTokens;o.walkTokens=function(i){var n=[];return n.push(e.walkTokens.call(this,i)),t&&(n=n.concat(t.call(this,i))),n}}n&&(o.extensions=s),z.setOptions(o)}))},z.walkTokens=function(e,t){for(var n,o=[],s=function(){var e=n.value;switch(o=o.concat(t.call(z,e)),e.type){case"table":for(var s,r=i(e.header);!(s=r()).done;){var a=s.value;o=o.concat(z.walkTokens(a.tokens,t))}for(var l,h=i(e.rows);!(l=h()).done;)for(var c,d=i(l.value);!(c=d()).done;){var u=c.value;o=o.concat(z.walkTokens(u.tokens,t))}break;case"list":o=o.concat(z.walkTokens(e.items,t));break;default:z.defaults.extensions&&z.defaults.extensions.childTokens&&z.defaults.extensions.childTokens[e.type]?z.defaults.extensions.childTokens[e.type].forEach((function(i){o=o.concat(z.walkTokens(e[i],t))})):e.tokens&&(o=o.concat(z.walkTokens(e.tokens,t)))}},r=i(e);!(n=r()).done;)s();return o},z.parseInline=function(e,t){if(null==e)throw new Error("marked.parseInline(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked.parseInline(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");E(t=y({},z.defaults,t||{}));try{var i=T.lexInline(e,t);return t.walkTokens&&z.walkTokens(i,t.walkTokens),P.parseInline(i,t)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+c(e.message+"",!0)+"</pre>";throw e}},z.Parser=P,z.parser=P.parse,z.Renderer=F,z.TextRenderer=R,z.Lexer=T,z.lexer=T.lex,z.Tokenizer=L,z.Slugger=O,z.parse=z;var Q=z.options,H=z.setOptions,W=z.use,V=z.walkTokens,U=z.parseInline,j=z,G=P.parse,K=T.lex;e.Lexer=T,e.Parser=P,e.Renderer=F,e.Slugger=O,e.TextRenderer=R,e.Tokenizer=L,e.getDefaults=n,e.lexer=K,e.marked=z,e.options=Q,e.parse=j,e.parseInline=U,e.parser=G,e.setOptions=H,e.use=W,e.walkTokens=V,Object.defineProperty(e,"__esModule",{value:!0})},e.amd?e(0,i):"object"==typeof exports?i(exports):i((t="undefined"!=typeof globalThis?globalThis:t||self).marked={})}(),A.Lexer||exports.Lexer,A.Parser||exports.Parser,A.Renderer||exports.Renderer,A.Slugger||exports.Slugger,A.TextRenderer||exports.TextRenderer,A.Tokenizer||exports.Tokenizer,A.getDefaults||exports.getDefaults,A.lexer||exports.lexer;var _=A.marked||exports.marked,w=(A.options||exports.options,A.parse||exports.parse,A.parseInline||exports.parseInline,A.parser||exports.parser,A.setOptions||exports.setOptions,A.use||exports.use,A.walkTokens||exports.walkTokens,i(5558)),b=i(7446),v=i(3104),C=i(9405),y=i(5306),S=i(6926);const k=Object.freeze({image:(e,t,i)=>{let n=[],o=[];return e&&(({href:e,dimensions:n}=(0,u.nI)(e)),o.push(`src="${(0,u.oO)(e)}"`)),i&&o.push(`alt="${(0,u.oO)(i)}"`),t&&o.push(`title="${(0,u.oO)(t)}"`),n.length&&(o=o.concat(n)),"<img "+o.join(" ")+">"},paragraph:e=>`<p>${e}</p>`,link:(e,t,i)=>"string"!=typeof e?"":(e===i&&(i=(0,u._W)(i)),t="string"==typeof t?(0,u.oO)((0,u._W)(t)):"",`<a href="${e=(e=(0,u._W)(e)).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}" title="${t||e}">${i}</a>`)});function E(e,t={},i={}){var o,u;const p=new f.Cm;let A=!1;const C=(0,r.n)(t),E=function(t){let i;try{i=(0,w.qg)(decodeURIComponent(t))}catch(e){}return i?(i=(0,v.PI)(i,(t=>e.uris&&e.uris[t]?S.r.revive(e.uris[t]):void 0)),encodeURIComponent(JSON.stringify(i))):t},M=function(t,i){const n=e.uris&&e.uris[t];let o=S.r.revive(n);return i?t.startsWith(b.ny.data+":")?t:(o||(o=S.r.parse(t)),b.zl.uriToBrowserUri(o).toString(!0)):o?S.r.parse(t).toString()===o.toString()?t:(o.query&&(o=o.with({query:E(o.query)})),o.toString()):t},I=new _.Renderer;I.image=k.image,I.link=k.link,I.paragraph=k.paragraph;const B=[],N=[];if(t.codeBlockRendererSync?I.code=(e,i)=>{const n=m.r.nextId(),o=t.codeBlockRendererSync(D(i),e);return N.push([n,o]),`<div class="code" data-code="${n}">${(0,y.ih)(e)}</div>`}:t.codeBlockRenderer&&(I.code=(e,i)=>{const n=m.r.nextId(),o=t.codeBlockRenderer(D(i),e);return B.push(o.then((e=>[n,e]))),`<div class="code" data-code="${n}">${(0,y.ih)(e)}</div>`}),t.actionHandler){const i=function(i){let n=i.target;if("A"===n.tagName||(n=n.parentElement,n&&"A"===n.tagName))try{let o=n.dataset.href;o&&(e.baseUri&&(o=x(S.r.from(e.baseUri),o)),t.actionHandler.callback(o,i))}catch(e){(0,c.dz)(e)}finally{i.preventDefault()}},o=t.actionHandler.disposables.add(new s.f(C,"click")),r=t.actionHandler.disposables.add(new s.f(C,"auxclick"));t.actionHandler.disposables.add(d.Jh.any(o.event,r.event)((e=>{const t=new l.P(e);(t.leftButton||t.middleButton)&&i(t)}))),t.actionHandler.disposables.add(n.ko(C,"keydown",(e=>{const t=new a.Z(e);(t.equals(10)||t.equals(3))&&i(t)})))}e.supportHtml||(i.sanitizer=t=>(e.isTrusted?t.match(/^(<span[^>]+>)|(<\/\s*span>)$/):void 0)?t:"",i.sanitize=!0,i.silent=!0),i.renderer=I;let T,O=null!==(o=e.value)&&void 0!==o?o:"";if(O.length>1e5&&(O=`${O.substr(0,1e5)}…`),e.supportThemeIcons&&(O=(0,g.sA)(O)),t.fillInIncompleteTokens){const e=Object.assign(Object.assign({},_.defaults),i),t=function(e){let t,i;for(t=0;t<e.length;t++){const n=e[t];if("paragraph"===n.type&&n.raw.match(/(\n|^)```/)){i=R(e.slice(t));break}if("paragraph"===n.type&&n.raw.match(/(\n|^)\|/)){i=V(e.slice(t));break}if(t===e.length-1&&"paragraph"===n.type){const e=F(n);if(e){i=[e];break}}}if(i){const n=[...e.slice(0,t),...i];return n.links=e.links,n}return e}(_.lexer(O,e));T=_.parser(t,e)}else T=_.parse(O,i);e.supportThemeIcons&&(T=(0,h.n)(T).map((e=>"string"==typeof e?e:e.outerHTML)).join(""));const P=(new DOMParser).parseFromString(L(e,T),"text/html");if(P.body.querySelectorAll("img").forEach((t=>{const i=t.getAttribute("src");if(i){let n=i;try{e.baseUri&&(n=x(S.r.from(e.baseUri),n))}catch(e){}t.src=M(n,!0)}})),P.body.querySelectorAll("a").forEach((t=>{const i=t.getAttribute("href");if(t.setAttribute("href",""),!i||/^data:|javascript:/i.test(i)||/^command:/i.test(i)&&!e.isTrusted||/^command:(\/\/\/)?_workbench\.downloadResource/i.test(i))t.replaceWith(...t.childNodes);else{let n=M(i,!1);e.baseUri&&(n=x(S.r.from(e.baseUri),i)),t.dataset.href=n}})),C.innerHTML=L(e,P.body.innerHTML),B.length>0)Promise.all(B).then((e=>{var i,o;if(A)return;const s=new Map(e),r=C.querySelectorAll("div[data-code]");for(const e of r){const t=s.get(null!==(i=e.dataset.code)&&void 0!==i?i:"");t&&n.Ln(e,t)}null===(o=t.asyncRenderCallback)||void 0===o||o.call(t)}));else if(N.length>0){const e=new Map(N),t=C.querySelectorAll("div[data-code]");for(const i of t){const t=e.get(null!==(u=i.dataset.code)&&void 0!==u?u:"");t&&n.Ln(i,t)}}if(t.asyncRenderCallback)for(const e of C.getElementsByTagName("img")){const i=p.add(n.ko(e,"load",(()=>{i.dispose(),t.asyncRenderCallback()})))}return{element:C,dispose:()=>{A=!0,p.dispose()}}}function D(e){if(!e)return"";const t=e.split(/[\s+|:|,|\{|\?]/,1);return t.length?t[0]:e}function x(e,t){return/^\w[\w\d+.-]*:/.test(t)?t:e.path.endsWith("/")?(0,C.o1)(e,t).toString():(0,C.o1)((0,C.pD)(e),t).toString()}function L(e,t){const{config:i,allowedSchemes:s}=function(e){const t=[b.ny.http,b.ny.https,b.ny.mailto,b.ny.data,b.ny.file,b.ny.vscodeFileResource,b.ny.vscodeRemote,b.ny.vscodeRemoteResource];return e.isTrusted&&t.push(b.ny.command),{config:{ALLOWED_TAGS:[...n.TT],ALLOWED_ATTR:M,ALLOW_UNKNOWN_PROTOCOLS:!0},allowedSchemes:t}}(e);o.$w("uponSanitizeAttribute",((e,t)=>{if("style"!==t.attrName&&"class"!==t.attrName);else{if("SPAN"===e.tagName){if("style"===t.attrName)return void(t.keepAttr=/^(color\:(#[0-9a-fA-F]+|var\(--vscode(-[a-zA-Z]+)+\));)?(background-color\:(#[0-9a-fA-F]+|var\(--vscode(-[a-zA-Z]+)+\));)?$/.test(t.attrValue));if("class"===t.attrName)return void(t.keepAttr=/^codicon codicon-[a-z\-]+( codicon-modifier-[a-z\-]+)?$/.test(t.attrValue))}t.keepAttr=!1}}));const r=n.a4(s);try{return o.aj(t,Object.assign(Object.assign({},i),{RETURN_TRUSTED_TYPE:!0}))}finally{o.SV("uponSanitizeAttribute"),r.dispose()}}const M=["align","autoplay","alt","class","controls","data-code","data-href","height","href","loop","muted","playsinline","poster","src","style","target","title","width","start"];function I(e){return"string"==typeof e?e:function(e){var t;let i=null!==(t=e.value)&&void 0!==t?t:"";i.length>1e5&&(i=`${i.substr(0,1e5)}…`);const n=_.parse(i,{renderer:N.value}).replace(/&(#\d+|[a-zA-Z]+);/g,(e=>{var t;return null!==(t=B.get(e))&&void 0!==t?t:e}));return L({isTrusted:!1},n).toString()}(e)}const B=new Map([["&quot;",'"'],["&nbsp;"," "],["&amp;","&"],["&#39;","'"],["&lt;","<"],["&gt;",">"]]),N=new p.d((()=>{const e=new _.Renderer;return e.code=e=>e,e.blockquote=e=>e,e.html=e=>"",e.heading=(e,t,i)=>e+"\n",e.hr=()=>"",e.list=(e,t)=>e,e.listitem=e=>e+"\n",e.paragraph=e=>e+"\n",e.table=(e,t)=>e+t+"\n",e.tablerow=e=>e,e.tablecell=(e,t)=>e+" ",e.strong=e=>e,e.em=e=>e,e.codespan=e=>e,e.br=()=>"\n",e.del=e=>e,e.image=(e,t,i)=>"",e.text=e=>e,e.link=(e,t,i)=>i,e}));function T(e){let t="";return e.forEach((e=>{t+=e.raw})),t}function F(e){for(const t of e.tokens)if("text"===t.type){const i=t.raw.split("\n"),n=i[i.length-1];if(n.includes("`"))return O(e);if(n.includes("**"))return W(e,"**");if(n.match(/\*\w/))return W(e,"*");if(n.match(/(^|\s)__\w/))return H(e);if(n.match(/(^|\s)_\w/))return P(e);if(n.match(/(^|\s)\[.*\]\(\w*/))return z(e);if(n.match(/(^|\s)\[\w/))return Q(e)}}function R(e){const t=T(e);return _.lexer(t+"\n```")}function O(e){return W(e,"`")}function P(e){return W(e,"_")}function z(e){return W(e,")")}function Q(e){return W(e,"](about:blank)")}function H(e){return W(e,"__")}function W(e,t){const i=T(Array.isArray(e)?e:[e]);return _.lexer(i+t)[0]}function V(e){const t=T(e),i=t.split("\n");let n,o=!1;for(let e=0;e<i.length;e++){const t=i[e].trim();if(void 0===n&&t.match(/^\s*\|/)){const e=t.match(/(\|[^\|]+)(?=\||$)/g);e&&(n=e.length)}else if("number"==typeof n){if(!t.match(/^\s*\|/))return;if(e!==i.length-1)return;o=!0}}if("number"==typeof n&&n>0){const e=o?i.slice(0,-1).join("\n"):t,s=!!e.match(/\|\s*$/),r=e+(s?"":"|")+`\n|${" --- |".repeat(n)}`;return _.lexer(r)}}},9121:(e,t,i)=>{i.d(t,{P:()=>h,$:()=>c});var n=i(2003);let o=!1,s=null;function r(e){if(!e.parent||e.parent===e)return null;try{const t=e.location,i=e.parent.location;if("null"!==t.origin&&"null"!==i.origin&&t.origin!==i.origin)return o=!0,null}catch(e){return o=!0,null}return e.parent}class a{static getSameOriginWindowChain(){if(!s){s=[];let e,t=window;do{e=r(t),e?s.push({window:t,iframeElement:t.frameElement||null}):s.push({window:t,iframeElement:null}),t=e}while(t)}return s.slice(0)}static getPositionOfChildWindowRelativeToAncestorWindow(e,t){if(!t||e===t)return{top:0,left:0};let i=0,n=0;const o=this.getSameOriginWindowChain();for(const e of o){if(i+=e.window.scrollY,n+=e.window.scrollX,e.window===t)break;if(!e.iframeElement)break;const o=e.iframeElement.getBoundingClientRect();i+=o.top,n+=o.left}return{top:i,left:n}}}var l=i(4541);class h{constructor(e){this.timestamp=Date.now(),this.browserEvent=e,this.leftButton=0===e.button,this.middleButton=1===e.button,this.rightButton=2===e.button,this.buttons=e.buttons,this.target=e.target,this.detail=e.detail||1,"dblclick"===e.type&&(this.detail=2),this.ctrlKey=e.ctrlKey,this.shiftKey=e.shiftKey,this.altKey=e.altKey,this.metaKey=e.metaKey,"number"==typeof e.pageX?(this.posx=e.pageX,this.posy=e.pageY):(this.posx=e.clientX+document.body.scrollLeft+document.documentElement.scrollLeft,this.posy=e.clientY+document.body.scrollTop+document.documentElement.scrollTop);const t=a.getPositionOfChildWindowRelativeToAncestorWindow(window,e.view);this.posx-=t.left,this.posy-=t.top}preventDefault(){this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent.stopPropagation()}}class c{constructor(e,t=0,i=0){if(this.browserEvent=e||null,this.target=e?e.target||e.targetNode||e.srcElement:null,this.deltaY=i,this.deltaX=t,e){const t=e,i=e;if(void 0!==t.wheelDeltaY)this.deltaY=t.wheelDeltaY/120;else if(void 0!==i.VERTICAL_AXIS&&i.axis===i.VERTICAL_AXIS)this.deltaY=-i.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!l.zx?this.deltaY=-e.deltaY/3:this.deltaY=-e.deltaY:this.deltaY=-e.deltaY/40}if(void 0!==t.wheelDeltaX)n.isSafari&&l.uF?this.deltaX=-t.wheelDeltaX/120:this.deltaX=t.wheelDeltaX/120;else if(void 0!==i.HORIZONTAL_AXIS&&i.axis===i.HORIZONTAL_AXIS)this.deltaX=-e.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!l.zx?this.deltaX=-e.deltaX/3:this.deltaX=-e.deltaX:this.deltaX=-e.deltaX/40}0===this.deltaY&&0===this.deltaX&&e.wheelDelta&&(this.deltaY=e.wheelDelta/120)}}preventDefault(){var e;null===(e=this.browserEvent)||void 0===e||e.preventDefault()}stopPropagation(){var e;null===(e=this.browserEvent)||void 0===e||e.stopPropagation()}}},9408:(e,t,i)=>{i.d(t,{B:()=>n,q:()=>h});var n,o=i(8479),s=i(8092),r=i(8844),a=i(8300),l=i(6423);!function(e){e.Tap="-monaco-gesturetap",e.Change="-monaco-gesturechange",e.Start="-monaco-gesturestart",e.End="-monaco-gesturesend",e.Contextmenu="-monaco-gesturecontextmenu"}(n||(n={}));class h extends a.jG{constructor(){super(),this.dispatched=!1,this.targets=new l.w,this.ignoreTargets=new l.w,this.activeTouches={},this.handle=null,this._lastSetTapCountTime=0,this._register(o.ko(document,"touchstart",(e=>this.onTouchStart(e)),{passive:!1})),this._register(o.ko(document,"touchend",(e=>this.onTouchEnd(e)))),this._register(o.ko(document,"touchmove",(e=>this.onTouchMove(e)),{passive:!1}))}static addTarget(e){if(!h.isTouchDevice())return a.jG.None;h.INSTANCE||(h.INSTANCE=new h);const t=h.INSTANCE.targets.push(e);return(0,a.s)(t)}static ignoreTarget(e){if(!h.isTouchDevice())return a.jG.None;h.INSTANCE||(h.INSTANCE=new h);const t=h.INSTANCE.ignoreTargets.push(e);return(0,a.s)(t)}static isTouchDevice(){return"ontouchstart"in window||navigator.maxTouchPoints>0}dispose(){this.handle&&(this.handle.dispose(),this.handle=null),super.dispose()}onTouchStart(e){const t=Date.now();this.handle&&(this.handle.dispose(),this.handle=null);for(let i=0,o=e.targetTouches.length;i<o;i++){const o=e.targetTouches.item(i);this.activeTouches[o.identifier]={id:o.identifier,initialTarget:o.target,initialTimeStamp:t,initialPageX:o.pageX,initialPageY:o.pageY,rollingTimestamps:[t],rollingPageX:[o.pageX],rollingPageY:[o.pageY]};const s=this.newGestureEvent(n.Start,o.target);s.pageX=o.pageX,s.pageY=o.pageY,this.dispatchEvent(s)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}onTouchEnd(e){const t=Date.now(),i=Object.keys(this.activeTouches).length;for(let o=0,r=e.changedTouches.length;o<r;o++){const r=e.changedTouches.item(o);if(!this.activeTouches.hasOwnProperty(String(r.identifier))){console.warn("move of an UNKNOWN touch",r);continue}const a=this.activeTouches[r.identifier],l=Date.now()-a.initialTimeStamp;if(l<h.HOLD_DELAY&&Math.abs(a.initialPageX-s.RT(a.rollingPageX))<30&&Math.abs(a.initialPageY-s.RT(a.rollingPageY))<30){const e=this.newGestureEvent(n.Tap,a.initialTarget);e.pageX=s.RT(a.rollingPageX),e.pageY=s.RT(a.rollingPageY),this.dispatchEvent(e)}else if(l>=h.HOLD_DELAY&&Math.abs(a.initialPageX-s.RT(a.rollingPageX))<30&&Math.abs(a.initialPageY-s.RT(a.rollingPageY))<30){const e=this.newGestureEvent(n.Contextmenu,a.initialTarget);e.pageX=s.RT(a.rollingPageX),e.pageY=s.RT(a.rollingPageY),this.dispatchEvent(e)}else if(1===i){const e=s.RT(a.rollingPageX),i=s.RT(a.rollingPageY),n=s.RT(a.rollingTimestamps)-a.rollingTimestamps[0],o=e-a.rollingPageX[0],r=i-a.rollingPageY[0],l=[...this.targets].filter((e=>a.initialTarget instanceof Node&&e.contains(a.initialTarget)));this.inertia(l,t,Math.abs(o)/n,o>0?1:-1,e,Math.abs(r)/n,r>0?1:-1,i)}this.dispatchEvent(this.newGestureEvent(n.End,a.initialTarget)),delete this.activeTouches[r.identifier]}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}newGestureEvent(e,t){const i=document.createEvent("CustomEvent");return i.initEvent(e,!1,!0),i.initialTarget=t,i.tapCount=0,i}dispatchEvent(e){if(e.type===n.Tap){const t=(new Date).getTime();let i=0;i=t-this._lastSetTapCountTime>h.CLEAR_TAP_COUNT_TIME?1:2,this._lastSetTapCountTime=t,e.tapCount=i}else e.type!==n.Change&&e.type!==n.Contextmenu||(this._lastSetTapCountTime=0);if(e.initialTarget instanceof Node){for(const t of this.ignoreTargets)if(t.contains(e.initialTarget))return;for(const t of this.targets)t.contains(e.initialTarget)&&(t.dispatchEvent(e),this.dispatched=!0)}}inertia(e,t,i,s,r,a,l,c){this.handle=o.PG((()=>{const o=Date.now(),d=o-t;let u=0,g=0,m=!0;i+=h.SCROLL_FRICTION*d,a+=h.SCROLL_FRICTION*d,i>0&&(m=!1,u=s*i*d),a>0&&(m=!1,g=l*a*d);const p=this.newGestureEvent(n.Change);p.translationX=u,p.translationY=g,e.forEach((e=>e.dispatchEvent(p))),m||this.inertia(e,o,i,s,r+u,a,l,c+g)}))}onTouchMove(e){const t=Date.now();for(let i=0,o=e.changedTouches.length;i<o;i++){const o=e.changedTouches.item(i);if(!this.activeTouches.hasOwnProperty(String(o.identifier))){console.warn("end of an UNKNOWN touch",o);continue}const r=this.activeTouches[o.identifier],a=this.newGestureEvent(n.Change,r.initialTarget);a.translationX=o.pageX-s.RT(r.rollingPageX),a.translationY=o.pageY-s.RT(r.rollingPageY),a.pageX=o.pageX,a.pageY=o.pageY,this.dispatchEvent(a),r.rollingPageX.length>3&&(r.rollingPageX.shift(),r.rollingPageY.shift(),r.rollingTimestamps.shift()),r.rollingPageX.push(o.pageX),r.rollingPageY.push(o.pageY),r.rollingTimestamps.push(t)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}}h.SCROLL_FRICTION=-.005,h.HOLD_DELAY=700,h.CLEAR_TAP_COUNT_TIME=400,function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);s>3&&r&&Object.defineProperty(t,i,r)}([r.B],h,"isTouchDevice",null)},6123:(e,t,i)=>{i.d(t,{H:()=>o});var n=i(3329);function o(e,t){var i;const o=globalThis.MonacoEnvironment;if(null==o?void 0:o.createTrustedTypesPolicy)try{return o.createTrustedTypesPolicy(e,t)}catch(e){return void(0,n.dz)(e)}try{return null===(i=window.trustedTypes)||void 0===i?void 0:i.createPolicy(e,t)}catch(e){return void(0,n.dz)(e)}}},7733:(e,t,i)=>{i.d(t,{Z4:()=>B,EH:()=>I,XF:()=>N});var n=i(2003),o=i(3037),s=i(8479),r=i(9408),a=i(6551),l=i(9923),h=i(192),c=i(7092),d=i(3624),u=i(8092),g=i(3884),m=i(9833),p=i(8300),f=i(4541),A=i(3925),_=i.n(A),w=i(8014);_()(w.A,{insert:"head",singleton:!1}),w.A.locals;var b=i(1759);const v=s.$,C="selectOption.entry.template";class y{get templateId(){return C}renderTemplate(e){const t=Object.create(null);return t.root=e,t.text=s.BC(e,v(".option-text")),t.detail=s.BC(e,v(".option-detail")),t.decoratorRight=s.BC(e,v(".option-decorator-right")),t}renderElement(e,t,i){const n=i,o=e.text,s=e.detail,r=e.decoratorRight,a=e.isDisabled;n.text.textContent=o,n.detail.textContent=s||"",n.decoratorRight.innerText=r||"",a?n.root.classList.add("option-disabled"):n.root.classList.remove("option-disabled")}disposeTemplate(e){}}class S extends p.jG{constructor(e,t,i,n,o){super(),this.options=[],this._currentSelection=0,this._hasDetails=!1,this._skipLayout=!1,this._sticky=!1,this._isVisible=!1,this.styles=n,this.selectBoxOptions=o||Object.create(null),"number"!=typeof this.selectBoxOptions.minBottomMargin?this.selectBoxOptions.minBottomMargin=S.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN:this.selectBoxOptions.minBottomMargin<0&&(this.selectBoxOptions.minBottomMargin=0),this.selectElement=document.createElement("select"),this.selectElement.className="monaco-select-box monaco-select-box-dropdown-padding","string"==typeof this.selectBoxOptions.ariaLabel&&this.selectElement.setAttribute("aria-label",this.selectBoxOptions.ariaLabel),"string"==typeof this.selectBoxOptions.ariaDescription&&this.selectElement.setAttribute("aria-description",this.selectBoxOptions.ariaDescription),this._onDidSelect=new g.vl,this._register(this._onDidSelect),this.registerListeners(),this.constructSelectDropDown(i),this.selected=t||0,e&&this.setOptions(e,t),this.initStyleSheet()}getHeight(){return 22}getTemplateId(){return C}constructSelectDropDown(e){this.contextViewProvider=e,this.selectDropDownContainer=s.$(".monaco-select-box-dropdown-container"),this.selectDropDownContainer.classList.add("monaco-select-box-dropdown-padding"),this.selectionDetailsPane=s.BC(this.selectDropDownContainer,v(".select-box-details-pane"));const t=s.BC(this.selectDropDownContainer,v(".select-box-dropdown-container-width-control")),i=s.BC(t,v(".width-control-div"));this.widthControlElement=document.createElement("span"),this.widthControlElement.className="option-text-width-control",s.BC(i,this.widthControlElement),this._dropDownPosition=0,this.styleElement=s.li(this.selectDropDownContainer),this.selectDropDownContainer.setAttribute("draggable","true"),this._register(s.ko(this.selectDropDownContainer,s.Bx.DRAG_START,(e=>{s.fs.stop(e,!0)})))}registerListeners(){let e;this._register(s.b2(this.selectElement,"change",(e=>{this.selected=e.target.selectedIndex,this._onDidSelect.fire({index:e.target.selectedIndex,selected:e.target.value}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)}))),this._register(s.ko(this.selectElement,s.Bx.CLICK,(e=>{s.fs.stop(e),this._isVisible?this.hideSelectDropDown(!0):this.showSelectDropDown()}))),this._register(s.ko(this.selectElement,s.Bx.MOUSE_DOWN,(e=>{s.fs.stop(e)}))),this._register(s.ko(this.selectElement,"touchstart",(t=>{e=this._isVisible}))),this._register(s.ko(this.selectElement,"touchend",(t=>{s.fs.stop(t),e?this.hideSelectDropDown(!0):this.showSelectDropDown()}))),this._register(s.ko(this.selectElement,s.Bx.KEY_DOWN,(e=>{const t=new h.Z(e);let i=!1;f.zx?18!==t.keyCode&&16!==t.keyCode&&10!==t.keyCode&&3!==t.keyCode||(i=!0):(18===t.keyCode&&t.altKey||16===t.keyCode&&t.altKey||10===t.keyCode||3===t.keyCode)&&(i=!0),i&&(this.showSelectDropDown(),s.fs.stop(e,!0))})))}get onDidSelect(){return this._onDidSelect.event}setOptions(e,t){u.aI(this.options,e)||(this.options=e,this.selectElement.options.length=0,this._hasDetails=!1,this._cachedMaxDetailsHeight=void 0,this.options.forEach(((e,t)=>{this.selectElement.add(this.createOption(e.text,t,e.isDisabled)),"string"==typeof e.description&&(this._hasDetails=!0)}))),void 0!==t&&(this.select(t),this._currentSelection=this.selected)}setOptionsList(){var e;null===(e=this.selectList)||void 0===e||e.splice(0,this.selectList.length,this.options)}select(e){e>=0&&e<this.options.length?this.selected=e:e>this.options.length-1?this.select(this.options.length-1):this.selected<0&&(this.selected=0),this.selectElement.selectedIndex=this.selected,this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)}focus(){this.selectElement&&(this.selectElement.tabIndex=0,this.selectElement.focus())}blur(){this.selectElement&&(this.selectElement.tabIndex=-1,this.selectElement.blur())}setFocusable(e){this.selectElement.tabIndex=e?0:-1}render(e){this.container=e,e.classList.add("select-container"),e.appendChild(this.selectElement),this.styleSelectElement()}initStyleSheet(){const e=[];this.styles.listFocusBackground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { background-color: ${this.styles.listFocusBackground} !important; }`),this.styles.listFocusForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { color: ${this.styles.listFocusForeground} !important; }`),this.styles.decoratorRightForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.focused) .option-decorator-right { color: ${this.styles.decoratorRightForeground}; }`),this.styles.selectBackground&&this.styles.selectBorder&&this.styles.selectBorder!==this.styles.selectBackground?(e.push(`.monaco-select-box-dropdown-container { border: 1px solid ${this.styles.selectBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-top { border-top: 1px solid ${this.styles.selectBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-bottom { border-bottom: 1px solid ${this.styles.selectBorder} } `)):this.styles.selectListBorder&&(e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-top { border-top: 1px solid ${this.styles.selectListBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-bottom { border-bottom: 1px solid ${this.styles.selectListBorder} } `)),this.styles.listHoverForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { color: ${this.styles.listHoverForeground} !important; }`),this.styles.listHoverBackground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { background-color: ${this.styles.listHoverBackground} !important; }`),this.styles.listFocusOutline&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { outline: 1.6px dotted ${this.styles.listFocusOutline} !important; outline-offset: -1.6px !important; }`),this.styles.listHoverOutline&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { outline: 1.6px dashed ${this.styles.listHoverOutline} !important; outline-offset: -1.6px !important; }`),e.push(".monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.option-disabled.focused { background-color: transparent !important; color: inherit !important; outline: none !important; }"),e.push(".monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.option-disabled:hover { background-color: transparent !important; color: inherit !important; outline: none !important; }"),this.styleElement.textContent=e.join("\n")}styleSelectElement(){var e,t,i;const n=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",o=null!==(t=this.styles.selectForeground)&&void 0!==t?t:"",s=null!==(i=this.styles.selectBorder)&&void 0!==i?i:"";this.selectElement.style.backgroundColor=n,this.selectElement.style.color=o,this.selectElement.style.borderColor=s}styleList(){var e,t;const i=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",n=s.gI(this.styles.selectListBackground,i);this.selectDropDownListContainer.style.backgroundColor=n,this.selectionDetailsPane.style.backgroundColor=n;const o=null!==(t=this.styles.focusBorder)&&void 0!==t?t:"";this.selectDropDownContainer.style.outlineColor=o,this.selectDropDownContainer.style.outlineOffset="-1px",this.selectList.style(this.styles)}createOption(e,t,i){const n=document.createElement("option");return n.value=e,n.text=e,n.disabled=!!i,n}showSelectDropDown(){this.selectionDetailsPane.innerText="",this.contextViewProvider&&!this._isVisible&&(this.createSelectList(this.selectDropDownContainer),this.setOptionsList(),this.contextViewProvider.showContextView({getAnchor:()=>this.selectElement,render:e=>this.renderSelectDropDown(e,!0),layout:()=>{this.layoutSelectDropDown()},onHide:()=>{this.selectDropDownContainer.classList.remove("visible"),this.selectElement.classList.remove("synthetic-focus")},anchorPosition:this._dropDownPosition},this.selectBoxOptions.optionsAsChildren?this.container:void 0),this._isVisible=!0,this.hideSelectDropDown(!1),this.contextViewProvider.showContextView({getAnchor:()=>this.selectElement,render:e=>this.renderSelectDropDown(e),layout:()=>this.layoutSelectDropDown(),onHide:()=>{this.selectDropDownContainer.classList.remove("visible"),this.selectElement.classList.remove("synthetic-focus")},anchorPosition:this._dropDownPosition},this.selectBoxOptions.optionsAsChildren?this.container:void 0),this._currentSelection=this.selected,this._isVisible=!0,this.selectElement.setAttribute("aria-expanded","true"))}hideSelectDropDown(e){this.contextViewProvider&&this._isVisible&&(this._isVisible=!1,this.selectElement.setAttribute("aria-expanded","false"),e&&this.selectElement.focus(),this.contextViewProvider.hideContextView())}renderSelectDropDown(e,t){return e.appendChild(this.selectDropDownContainer),this.layoutSelectDropDown(t),{dispose:()=>{try{e.removeChild(this.selectDropDownContainer)}catch(e){}}}}measureMaxDetailsHeight(){let e=0;return this.options.forEach(((t,i)=>{this.updateDetail(i),this.selectionDetailsPane.offsetHeight>e&&(e=this.selectionDetailsPane.offsetHeight)})),e}layoutSelectDropDown(e){if(this._skipLayout)return!1;if(this.selectList){this.selectDropDownContainer.classList.add("visible");const t=s.BK(this.selectElement),i=getComputedStyle(this.selectElement),n=parseFloat(i.getPropertyValue("--dropdown-padding-top"))+parseFloat(i.getPropertyValue("--dropdown-padding-bottom")),o=window.innerHeight-t.top-t.height-(this.selectBoxOptions.minBottomMargin||0),r=t.top-S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN,a=this.selectElement.offsetWidth,l=this.setWidthControlElement(this.widthControlElement),h=Math.max(l,Math.round(a)).toString()+"px";this.selectDropDownContainer.style.width=h,this.selectList.getHTMLElement().style.height="",this.selectList.layout();let c=this.selectList.contentHeight;this._hasDetails&&void 0===this._cachedMaxDetailsHeight&&(this._cachedMaxDetailsHeight=this.measureMaxDetailsHeight());const d=this._hasDetails?this._cachedMaxDetailsHeight:0,u=c+n+d,g=Math.floor((o-n-d)/this.getHeight()),m=Math.floor((r-n-d)/this.getHeight());if(e)return!(t.top+t.height>window.innerHeight-22||t.top<S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN||g<1&&m<1||(g<S.DEFAULT_MINIMUM_VISIBLE_OPTIONS&&m>g&&this.options.length>g?(this._dropDownPosition=1,this.selectDropDownContainer.removeChild(this.selectDropDownListContainer),this.selectDropDownContainer.removeChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectDropDownListContainer),this.selectionDetailsPane.classList.remove("border-top"),this.selectionDetailsPane.classList.add("border-bottom")):(this._dropDownPosition=0,this.selectDropDownContainer.removeChild(this.selectDropDownListContainer),this.selectDropDownContainer.removeChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectDropDownListContainer),this.selectDropDownContainer.appendChild(this.selectionDetailsPane),this.selectionDetailsPane.classList.remove("border-bottom"),this.selectionDetailsPane.classList.add("border-top")),0));if(t.top+t.height>window.innerHeight-22||t.top<S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN||0===this._dropDownPosition&&g<1||1===this._dropDownPosition&&m<1)return this.hideSelectDropDown(!0),!1;if(0===this._dropDownPosition){if(this._isVisible&&g+m<1)return this.hideSelectDropDown(!0),!1;u>o&&(c=g*this.getHeight())}else u>r&&(c=m*this.getHeight());return this.selectList.layout(c),this.selectList.domFocus(),this.selectList.length>0&&(this.selectList.setFocus([this.selected||0]),this.selectList.reveal(this.selectList.getFocus()[0]||0)),this._hasDetails?(this.selectList.getHTMLElement().style.height=c+n+"px",this.selectDropDownContainer.style.height=""):this.selectDropDownContainer.style.height=c+n+"px",this.updateDetail(this.selected),this.selectDropDownContainer.style.width=h,this.selectDropDownListContainer.setAttribute("tabindex","0"),this.selectElement.classList.add("synthetic-focus"),this.selectDropDownContainer.classList.add("synthetic-focus"),!0}return!1}setWidthControlElement(e){let t=0;if(e){let i=0,n=0;this.options.forEach(((e,t)=>{const o=e.detail?e.detail.length:0,s=e.decoratorRight?e.decoratorRight.length:0,r=e.text.length+o+s;r>n&&(i=t,n=r)})),e.textContent=this.options[i].text+(this.options[i].decoratorRight?this.options[i].decoratorRight+" ":""),t=s.Tr(e)}return t}createSelectList(e){if(this.selectList)return;this.selectDropDownListContainer=s.BC(e,v(".select-box-dropdown-list-container")),this.listRenderer=new y,this.selectList=new d.B8("SelectBoxCustom",this.selectDropDownListContainer,this,[this.listRenderer],{useShadows:!1,verticalScrollMode:3,keyboardSupport:!1,mouseSupport:!1,accessibilityProvider:{getAriaLabel:e=>{let t=e.text;return e.detail&&(t+=`. ${e.detail}`),e.decoratorRight&&(t+=`. ${e.decoratorRight}`),e.description&&(t+=`. ${e.description}`),t},getWidgetAriaLabel:()=>(0,b.kg)({key:"selectBox",comment:["Behave like native select dropdown element."]},"Select Box"),getRole:()=>f.zx?"":"option",getWidgetRole:()=>"listbox"}}),this.selectBoxOptions.ariaLabel&&(this.selectList.ariaLabel=this.selectBoxOptions.ariaLabel);const t=this._register(new l.f(this.selectDropDownListContainer,"keydown")),i=g.Jh.chain(t.event).filter((()=>this.selectList.length>0)).map((e=>new h.Z(e)));this._register(i.filter((e=>3===e.keyCode)).on((e=>this.onEnter(e)),this)),this._register(i.filter((e=>2===e.keyCode)).on((e=>this.onEnter(e)),this)),this._register(i.filter((e=>9===e.keyCode)).on((e=>this.onEscape(e)),this)),this._register(i.filter((e=>16===e.keyCode)).on((e=>this.onUpArrow(e)),this)),this._register(i.filter((e=>18===e.keyCode)).on((e=>this.onDownArrow(e)),this)),this._register(i.filter((e=>12===e.keyCode)).on(this.onPageDown,this)),this._register(i.filter((e=>11===e.keyCode)).on(this.onPageUp,this)),this._register(i.filter((e=>14===e.keyCode)).on(this.onHome,this)),this._register(i.filter((e=>13===e.keyCode)).on(this.onEnd,this)),this._register(i.filter((e=>e.keyCode>=21&&e.keyCode<=56||e.keyCode>=85&&e.keyCode<=113)).on(this.onCharacter,this)),this._register(s.ko(this.selectList.getHTMLElement(),s.Bx.POINTER_UP,(e=>this.onPointerUp(e)))),this._register(this.selectList.onMouseOver((e=>void 0!==e.index&&this.selectList.setFocus([e.index])))),this._register(this.selectList.onDidChangeFocus((e=>this.onListFocus(e)))),this._register(s.ko(this.selectDropDownContainer,s.Bx.FOCUS_OUT,(e=>{this._isVisible&&!s.QX(e.relatedTarget,this.selectDropDownContainer)&&this.onListBlur()}))),this.selectList.getHTMLElement().setAttribute("aria-label",this.selectBoxOptions.ariaLabel||""),this.selectList.getHTMLElement().setAttribute("aria-expanded","true"),this.styleList()}onPointerUp(e){if(!this.selectList.length)return;s.fs.stop(e);const t=e.target;if(!t)return;if(t.classList.contains("slider"))return;const i=t.closest(".monaco-list-row");if(!i)return;const n=Number(i.getAttribute("data-index")),o=i.classList.contains("option-disabled");n>=0&&n<this.options.length&&!o&&(this.selected=n,this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0]),this.selected!==this._currentSelection&&(this._currentSelection=this.selected,this._onDidSelect.fire({index:this.selectElement.selectedIndex,selected:this.options[this.selected].text}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)),this.hideSelectDropDown(!0))}onListBlur(){this._sticky||(this.selected!==this._currentSelection&&this.select(this._currentSelection),this.hideSelectDropDown(!1))}renderDescriptionMarkdown(e,t){const i=e=>{for(let t=0;t<e.childNodes.length;t++){const n=e.childNodes.item(t);"img"===(n.tagName&&n.tagName.toLowerCase())?e.removeChild(n):i(n)}},n=(0,c.Gc)({value:e,supportThemeIcons:!0},{actionHandler:t});return n.element.classList.add("select-box-description-markdown"),i(n.element),n.element}onListFocus(e){this._isVisible&&this._hasDetails&&this.updateDetail(e.indexes[0])}updateDetail(e){var t,i;this.selectionDetailsPane.innerText="";const n=this.options[e],o=null!==(t=null==n?void 0:n.description)&&void 0!==t?t:"",s=null!==(i=null==n?void 0:n.descriptionIsMarkdown)&&void 0!==i&&i;if(o){if(s){const e=n.descriptionMarkdownActionHandler;this.selectionDetailsPane.appendChild(this.renderDescriptionMarkdown(o,e))}else this.selectionDetailsPane.innerText=o;this.selectionDetailsPane.style.display="block"}else this.selectionDetailsPane.style.display="none";this._skipLayout=!0,this.contextViewProvider.layout(),this._skipLayout=!1}onEscape(e){s.fs.stop(e),this.select(this._currentSelection),this.hideSelectDropDown(!0)}onEnter(e){s.fs.stop(e),this.selected!==this._currentSelection&&(this._currentSelection=this.selected,this._onDidSelect.fire({index:this.selectElement.selectedIndex,selected:this.options[this.selected].text}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)),this.hideSelectDropDown(!0)}onDownArrow(e){if(this.selected<this.options.length-1){s.fs.stop(e,!0);const t=this.options[this.selected+1].isDisabled;if(t&&this.options.length>this.selected+2)this.selected+=2;else{if(t)return;this.selected++}this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0])}}onUpArrow(e){this.selected>0&&(s.fs.stop(e,!0),this.options[this.selected-1].isDisabled&&this.selected>1?this.selected-=2:this.selected--,this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0]))}onPageUp(e){s.fs.stop(e),this.selectList.focusPreviousPage(),setTimeout((()=>{this.selected=this.selectList.getFocus()[0],this.options[this.selected].isDisabled&&this.selected<this.options.length-1&&(this.selected++,this.selectList.setFocus([this.selected])),this.selectList.reveal(this.selected),this.select(this.selected)}),1)}onPageDown(e){s.fs.stop(e),this.selectList.focusNextPage(),setTimeout((()=>{this.selected=this.selectList.getFocus()[0],this.options[this.selected].isDisabled&&this.selected>0&&(this.selected--,this.selectList.setFocus([this.selected])),this.selectList.reveal(this.selected),this.select(this.selected)}),1)}onHome(e){s.fs.stop(e),this.options.length<2||(this.selected=0,this.options[this.selected].isDisabled&&this.selected>1&&this.selected++,this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selected),this.select(this.selected))}onEnd(e){s.fs.stop(e),this.options.length<2||(this.selected=this.options.length-1,this.options[this.selected].isDisabled&&this.selected>1&&this.selected--,this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selected),this.select(this.selected))}onCharacter(e){const t=m.YM.toString(e.keyCode);let i=-1;for(let n=0;n<this.options.length-1;n++)if(i=(n+this.selected+1)%this.options.length,this.options[i].text.charAt(0).toUpperCase()===t&&!this.options[i].isDisabled){this.select(i),this.selectList.setFocus([i]),this.selectList.reveal(this.selectList.getFocus()[0]),s.fs.stop(e);break}}dispose(){this.hideSelectDropDown(!1),super.dispose()}}S.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN=32,S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN=2,S.DEFAULT_MINIMUM_VISIBLE_OPTIONS=3;class k extends p.jG{constructor(e,t,i,n){super(),this.selected=0,this.selectBoxOptions=n||Object.create(null),this.options=[],this.selectElement=document.createElement("select"),this.selectElement.className="monaco-select-box","string"==typeof this.selectBoxOptions.ariaLabel&&this.selectElement.setAttribute("aria-label",this.selectBoxOptions.ariaLabel),"string"==typeof this.selectBoxOptions.ariaDescription&&this.selectElement.setAttribute("aria-description",this.selectBoxOptions.ariaDescription),this._onDidSelect=this._register(new g.vl),this.styles=i,this.registerListeners(),this.setOptions(e,t)}registerListeners(){this._register(r.q.addTarget(this.selectElement)),[r.B.Tap].forEach((e=>{this._register(s.ko(this.selectElement,e,(e=>{this.selectElement.focus()})))})),this._register(s.b2(this.selectElement,"click",(e=>{s.fs.stop(e,!0)}))),this._register(s.b2(this.selectElement,"change",(e=>{this.selectElement.title=e.target.value,this._onDidSelect.fire({index:e.target.selectedIndex,selected:e.target.value})}))),this._register(s.b2(this.selectElement,"keydown",(e=>{let t=!1;f.zx?18!==e.keyCode&&16!==e.keyCode&&10!==e.keyCode||(t=!0):(18===e.keyCode&&e.altKey||10===e.keyCode||3===e.keyCode)&&(t=!0),t&&e.stopPropagation()})))}get onDidSelect(){return this._onDidSelect.event}setOptions(e,t){this.options&&u.aI(this.options,e)||(this.options=e,this.selectElement.options.length=0,this.options.forEach(((e,t)=>{this.selectElement.add(this.createOption(e.text,t,e.isDisabled))}))),void 0!==t&&this.select(t)}select(e){0===this.options.length?this.selected=0:e>=0&&e<this.options.length?this.selected=e:e>this.options.length-1?this.select(this.options.length-1):this.selected<0&&(this.selected=0),this.selectElement.selectedIndex=this.selected,this.selected<this.options.length&&"string"==typeof this.options[this.selected].text?this.selectElement.title=this.options[this.selected].text:this.selectElement.title=""}focus(){this.selectElement&&(this.selectElement.tabIndex=0,this.selectElement.focus())}blur(){this.selectElement&&(this.selectElement.tabIndex=-1,this.selectElement.blur())}setFocusable(e){this.selectElement.tabIndex=e?0:-1}render(e){e.classList.add("select-container"),e.appendChild(this.selectElement),this.setOptions(this.options,this.selected),this.applyStyles()}applyStyles(){var e,t,i;this.selectElement&&(this.selectElement.style.backgroundColor=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",this.selectElement.style.color=null!==(t=this.styles.selectForeground)&&void 0!==t?t:"",this.selectElement.style.borderColor=null!==(i=this.styles.selectBorder)&&void 0!==i?i:"")}createOption(e,t,i){const n=document.createElement("option");return n.value=e,n.text=e,n.disabled=!!i,n}}var E=i(2776),D=i(7611);_()(D.A,{insert:"head",singleton:!1}),D.A.locals;class x extends E.x{constructor(e,t,i,n,o){super(),f.zx&&!(null==o?void 0:o.useCustomDrawn)?this.selectBoxDelegate=new k(e,t,n,o):this.selectBoxDelegate=new S(e,t,i,n,o),this._register(this.selectBoxDelegate)}get onDidSelect(){return this.selectBoxDelegate.onDidSelect}setOptions(e,t){this.selectBoxDelegate.setOptions(e,t)}select(e){this.selectBoxDelegate.select(e)}focus(){this.selectBoxDelegate.focus()}blur(){this.selectBoxDelegate.blur()}setFocusable(e){this.selectBoxDelegate.setFocusable(e)}render(e){this.selectBoxDelegate.render(e)}}var L=i(4315),M=i(2821);i(3679);class I extends p.jG{get action(){return this._action}constructor(e,t,i={}){super(),this.options=i,this._context=e||this,this._action=t,t instanceof L.rc&&this._register(t.onDidChange((e=>{this.element&&this.handleActionChangeEvent(e)})))}handleActionChangeEvent(e){void 0!==e.enabled&&this.updateEnabled(),void 0!==e.checked&&this.updateChecked(),void 0!==e.class&&this.updateClass(),void 0!==e.label&&(this.updateLabel(),this.updateTooltip()),void 0!==e.tooltip&&this.updateTooltip()}get actionRunner(){return this._actionRunner||(this._actionRunner=this._register(new L.LN)),this._actionRunner}set actionRunner(e){this._actionRunner=e}isEnabled(){return this._action.enabled}setActionContext(e){this._context=e}render(e){const t=this.element=e;this._register(r.q.addTarget(e));const i=this.options&&this.options.draggable;i&&(e.draggable=!0,n.isFirefox&&this._register((0,s.ko)(e,s.Bx.DRAG_START,(e=>{var t;return null===(t=e.dataTransfer)||void 0===t?void 0:t.setData(o.t.TEXT,this._action.label)})))),this._register((0,s.ko)(t,r.B.Tap,(e=>this.onClick(e,!0)))),this._register((0,s.ko)(t,s.Bx.MOUSE_DOWN,(e=>{i||s.fs.stop(e,!0),this._action.enabled&&0===e.button&&t.classList.add("active")}))),f.zx&&this._register((0,s.ko)(t,s.Bx.CONTEXT_MENU,(e=>{0===e.button&&!0===e.ctrlKey&&this.onClick(e)}))),this._register((0,s.ko)(t,s.Bx.CLICK,(e=>{s.fs.stop(e,!0),this.options&&this.options.isMenu||this.onClick(e)}))),this._register((0,s.ko)(t,s.Bx.DBLCLICK,(e=>{s.fs.stop(e,!0)}))),[s.Bx.MOUSE_UP,s.Bx.MOUSE_OUT].forEach((e=>{this._register((0,s.ko)(t,e,(e=>{s.fs.stop(e),t.classList.remove("active")})))}))}onClick(e,t=!1){var i;s.fs.stop(e,!0);const n=M.z(this._context)?(null===(i=this.options)||void 0===i?void 0:i.useEventAsContext)?e:{preserveFocus:t}:this._context;this.actionRunner.run(this._action,n)}focus(){this.element&&(this.element.tabIndex=0,this.element.focus(),this.element.classList.add("focused"))}blur(){this.element&&(this.element.blur(),this.element.tabIndex=-1,this.element.classList.remove("focused"))}setFocusable(e){this.element&&(this.element.tabIndex=e?0:-1)}get trapsArrowNavigation(){return!1}updateEnabled(){}updateLabel(){}getTooltip(){return this.action.tooltip}updateTooltip(){var e;if(!this.element)return;const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.updateAriaLabel(),this.options.hoverDelegate?(this.element.title="",this.customHover?this.customHover.update(t):(this.customHover=(0,a.f)(this.options.hoverDelegate,this.element,t),this._store.add(this.customHover))):this.element.title=t}updateAriaLabel(){var e;if(this.element){const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.element.setAttribute("aria-label",t)}}updateClass(){}updateChecked(){}dispose(){this.element&&(this.element.remove(),this.element=void 0),this._context=void 0,super.dispose()}}class B extends I{constructor(e,t,i){super(e,t,i),this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.cssClass=""}render(e){super.render(e),this.element&&(this.label=(0,s.BC)(this.element,(0,s.$)("a.action-label"))),this.label&&this.label.setAttribute("role",this.getDefaultAriaRole()),this.options.label&&this.options.keybinding&&this.element&&((0,s.BC)(this.element,(0,s.$)("span.keybinding")).textContent=this.options.keybinding),this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked()}getDefaultAriaRole(){return this._action.id===L.wv.ID?"presentation":this.options.isMenu?"menuitem":"button"}focus(){this.label&&(this.label.tabIndex=0,this.label.focus())}blur(){this.label&&(this.label.tabIndex=-1)}setFocusable(e){this.label&&(this.label.tabIndex=e?0:-1)}updateLabel(){this.options.label&&this.label&&(this.label.textContent=this.action.label)}getTooltip(){let e=null;return this.action.tooltip?e=this.action.tooltip:!this.options.label&&this.action.label&&this.options.icon&&(e=this.action.label,this.options.keybinding&&(e=b.kg({key:"titleLabel",comment:["action title","action keybinding"]},"{0} ({1})",e,this.options.keybinding))),null!=e?e:void 0}updateClass(){var e;this.cssClass&&this.label&&this.label.classList.remove(...this.cssClass.split(" ")),this.options.icon?(this.cssClass=this.action.class,this.label&&(this.label.classList.add("codicon"),this.cssClass&&this.label.classList.add(...this.cssClass.split(" "))),this.updateEnabled()):null===(e=this.label)||void 0===e||e.classList.remove("codicon")}updateEnabled(){var e,t;this.action.enabled?(this.label&&(this.label.removeAttribute("aria-disabled"),this.label.classList.remove("disabled")),null===(e=this.element)||void 0===e||e.classList.remove("disabled")):(this.label&&(this.label.setAttribute("aria-disabled","true"),this.label.classList.add("disabled")),null===(t=this.element)||void 0===t||t.classList.add("disabled"))}updateAriaLabel(){var e;if(this.label){const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.label.setAttribute("aria-label",t)}}updateChecked(){this.label&&(void 0!==this.action.checked?(this.label.classList.toggle("checked",this.action.checked),this.label.setAttribute("aria-checked",this.action.checked?"true":"false"),this.label.setAttribute("role","checkbox")):(this.label.classList.remove("checked"),this.label.setAttribute("aria-checked",""),this.label.setAttribute("role",this.getDefaultAriaRole())))}}class N extends I{constructor(e,t,i,n,o,s,r){super(e,t),this.selectBox=new x(i,n,o,s,r),this.selectBox.setFocusable(!1),this._register(this.selectBox),this.registerListeners()}select(e){this.selectBox.select(e)}registerListeners(){this._register(this.selectBox.onDidSelect((e=>this.runAction(e.selected,e.index))))}runAction(e,t){this.actionRunner.run(this._action,this.getActionContext(e,t))}getActionContext(e,t){return e}setFocusable(e){this.selectBox.setFocusable(e)}focus(){var e;null===(e=this.selectBox)||void 0===e||e.focus()}blur(){var e;null===(e=this.selectBox)||void 0===e||e.blur()}render(e){this.selectBox.render(e)}}},1758:(e,t,i)=>{i.d(t,{E:()=>d});var n=i(8479),o=i(192),s=i(7733),r=i(4315),a=i(3884),l=i(8300),h=i(2821),c=(i(3679),function(e,t,i,n){return new(i||(i=Promise))((function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(r,a)}l((n=n.apply(e,t||[])).next())}))});class d extends l.jG{constructor(e,t={}){var i,h,c,d,u,g;let m,p;switch(super(),this._actionRunnerDisposables=this._register(new l.Cm),this.viewItemDisposables=this._register(new l.$w),this.triggerKeyDown=!1,this.focusable=!0,this._onDidBlur=this._register(new a.vl),this.onDidBlur=this._onDidBlur.event,this._onDidCancel=this._register(new a.vl({onWillAddFirstListener:()=>this.cancelHasListener=!0})),this.onDidCancel=this._onDidCancel.event,this.cancelHasListener=!1,this._onDidRun=this._register(new a.vl),this.onDidRun=this._onDidRun.event,this._onWillRun=this._register(new a.vl),this.onWillRun=this._onWillRun.event,this.options=t,this._context=null!==(i=t.context)&&void 0!==i?i:null,this._orientation=null!==(h=this.options.orientation)&&void 0!==h?h:0,this._triggerKeys={keyDown:null!==(d=null===(c=this.options.triggerKeys)||void 0===c?void 0:c.keyDown)&&void 0!==d&&d,keys:null!==(g=null===(u=this.options.triggerKeys)||void 0===u?void 0:u.keys)&&void 0!==g?g:[3,10]},this.options.actionRunner?this._actionRunner=this.options.actionRunner:(this._actionRunner=new r.LN,this._actionRunnerDisposables.add(this._actionRunner)),this._actionRunnerDisposables.add(this._actionRunner.onDidRun((e=>this._onDidRun.fire(e)))),this._actionRunnerDisposables.add(this._actionRunner.onWillRun((e=>this._onWillRun.fire(e)))),this.viewItems=[],this.focusedItem=void 0,this.domNode=document.createElement("div"),this.domNode.className="monaco-action-bar",!1!==t.animated&&this.domNode.classList.add("animated"),this._orientation){case 0:m=[15],p=[17];break;case 1:m=[16],p=[18],this.domNode.className+=" vertical"}this._register(n.ko(this.domNode,n.Bx.KEY_DOWN,(e=>{const t=new o.Z(e);let i=!0;const n="number"==typeof this.focusedItem?this.viewItems[this.focusedItem]:void 0;m&&(t.equals(m[0])||t.equals(m[1]))?i=this.focusPrevious():p&&(t.equals(p[0])||t.equals(p[1]))?i=this.focusNext():t.equals(9)&&this.cancelHasListener?this._onDidCancel.fire():t.equals(14)?i=this.focusFirst():t.equals(13)?i=this.focusLast():t.equals(2)&&n instanceof s.EH&&n.trapsArrowNavigation?i=this.focusNext():this.isTriggerKeyEvent(t)?this._triggerKeys.keyDown?this.doTrigger(t):this.triggerKeyDown=!0:i=!1,i&&(t.preventDefault(),t.stopPropagation())}))),this._register(n.ko(this.domNode,n.Bx.KEY_UP,(e=>{const t=new o.Z(e);this.isTriggerKeyEvent(t)?(!this._triggerKeys.keyDown&&this.triggerKeyDown&&(this.triggerKeyDown=!1,this.doTrigger(t)),t.preventDefault(),t.stopPropagation()):(t.equals(2)||t.equals(1026))&&this.updateFocusedItem()}))),this.focusTracker=this._register(n.w5(this.domNode)),this._register(this.focusTracker.onDidBlur((()=>{n.bq()!==this.domNode&&n.QX(n.bq(),this.domNode)||(this._onDidBlur.fire(),this.focusedItem=void 0,this.previouslyFocusedItem=void 0,this.triggerKeyDown=!1)}))),this._register(this.focusTracker.onDidFocus((()=>this.updateFocusedItem()))),this.actionsList=document.createElement("ul"),this.actionsList.className="actions-container",this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"),this.options.ariaLabel&&this.actionsList.setAttribute("aria-label",this.options.ariaLabel),this.domNode.appendChild(this.actionsList),e.appendChild(this.domNode)}refreshRole(){this.length()>=2?this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"):this.actionsList.setAttribute("role","presentation")}setFocusable(e){if(this.focusable=e,this.focusable){const e=this.viewItems.find((e=>e instanceof s.EH&&e.isEnabled()));e instanceof s.EH&&e.setFocusable(!0)}else this.viewItems.forEach((e=>{e instanceof s.EH&&e.setFocusable(!1)}))}isTriggerKeyEvent(e){let t=!1;return this._triggerKeys.keys.forEach((i=>{t=t||e.equals(i)})),t}updateFocusedItem(){for(let e=0;e<this.actionsList.children.length;e++){const t=this.actionsList.children[e];if(n.QX(n.bq(),t)){this.focusedItem=e;break}}}get context(){return this._context}set context(e){this._context=e,this.viewItems.forEach((t=>t.setActionContext(e)))}get actionRunner(){return this._actionRunner}set actionRunner(e){this._actionRunner=e,this._actionRunnerDisposables.clear(),this._actionRunnerDisposables.add(this._actionRunner.onDidRun((e=>this._onDidRun.fire(e)))),this._actionRunnerDisposables.add(this._actionRunner.onWillRun((e=>this._onWillRun.fire(e)))),this.viewItems.forEach((t=>t.actionRunner=e))}getContainer(){return this.domNode}getAction(e){var t;if("number"==typeof e)return null===(t=this.viewItems[e])||void 0===t?void 0:t.action;if(e instanceof HTMLElement){for(;e.parentElement!==this.actionsList;){if(!e.parentElement)return;e=e.parentElement}for(let t=0;t<this.actionsList.childNodes.length;t++)if(this.actionsList.childNodes[t]===e)return this.viewItems[t].action}}push(e,t={}){const i=Array.isArray(e)?e:[e];let o=h.Et(t.index)?t.index:null;i.forEach((e=>{const i=document.createElement("li");let r;i.className="action-item",i.setAttribute("role","presentation");const a=Object.assign({hoverDelegate:this.options.hoverDelegate},t);this.options.actionViewItemProvider&&(r=this.options.actionViewItemProvider(e,a)),r||(r=new s.Z4(this.context,e,a)),this.options.allowContextMenu||this.viewItemDisposables.set(r,n.ko(i,n.Bx.CONTEXT_MENU,(e=>{n.fs.stop(e,!0)}))),r.actionRunner=this._actionRunner,r.setActionContext(this.context),r.render(i),this.focusable&&r instanceof s.EH&&0===this.viewItems.length&&r.setFocusable(!0),null===o||o<0||o>=this.actionsList.children.length?(this.actionsList.appendChild(i),this.viewItems.push(r)):(this.actionsList.insertBefore(i,this.actionsList.children[o]),this.viewItems.splice(o,0,r),o++)})),"number"==typeof this.focusedItem&&this.focus(this.focusedItem),this.refreshRole()}clear(){this.isEmpty()||(this.viewItems=(0,l.AS)(this.viewItems),this.viewItemDisposables.clearAndDisposeAll(),n.w_(this.actionsList),this.refreshRole())}length(){return this.viewItems.length}isEmpty(){return 0===this.viewItems.length}focus(e){let t,i=!1;if(void 0===e?i=!0:"number"==typeof e?t=e:"boolean"==typeof e&&(i=e),i&&void 0===this.focusedItem){const e=this.viewItems.findIndex((e=>e.isEnabled()));this.focusedItem=-1===e?void 0:e,this.updateFocus(void 0,void 0,!0)}else void 0!==t&&(this.focusedItem=t),this.updateFocus(void 0,void 0,!0)}focusFirst(){return this.focusedItem=this.length()-1,this.focusNext(!0)}focusLast(){return this.focusedItem=0,this.focusPrevious(!0)}focusNext(e){if(void 0===this.focusedItem)this.focusedItem=this.viewItems.length-1;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(!e&&this.options.preventLoopNavigation&&this.focusedItem+1>=this.viewItems.length)return this.focusedItem=t,!1;this.focusedItem=(this.focusedItem+1)%this.viewItems.length,i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===r.wv.ID));return this.updateFocus(),!0}focusPrevious(e){if(void 0===this.focusedItem)this.focusedItem=0;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(this.focusedItem=this.focusedItem-1,this.focusedItem<0){if(!e&&this.options.preventLoopNavigation)return this.focusedItem=t,!1;this.focusedItem=this.viewItems.length-1}i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===r.wv.ID));return this.updateFocus(!0),!0}updateFocus(e,t,i=!1){var n;void 0===this.focusedItem&&this.actionsList.focus({preventScroll:t}),void 0!==this.previouslyFocusedItem&&this.previouslyFocusedItem!==this.focusedItem&&(null===(n=this.viewItems[this.previouslyFocusedItem])||void 0===n||n.blur());const o=void 0!==this.focusedItem&&this.viewItems[this.focusedItem];if(o){let n=!0;h.Tn(o.focus)||(n=!1),this.options.focusOnlyEnabledItems&&h.Tn(o.isEnabled)&&!o.isEnabled()&&(n=!1),o.action.id===r.wv.ID&&(n=!1),n?(i||this.previouslyFocusedItem!==this.focusedItem)&&(o.focus(e),this.previouslyFocusedItem=this.focusedItem):(this.actionsList.focus({preventScroll:t}),this.previouslyFocusedItem=void 0)}}doTrigger(e){if(void 0===this.focusedItem)return;const t=this.viewItems[this.focusedItem];if(t instanceof s.EH){const i=null===t._context||void 0===t._context?e:t._context;this.run(t._action,i)}}run(e,t){return c(this,void 0,void 0,(function*(){yield this._actionRunner.run(e,t)}))}dispose(){this._context=void 0,this.viewItems=(0,l.AS)(this.viewItems),this.getContainer().remove(),super.dispose()}}},6413:(e,t,i)=>{i.d(t,{xE:()=>p,vr:()=>m,h5:()=>f});var n=i(8479),o=i(4541),s=i(3925),r=i.n(s),a=i(9891);r()(a.A,{insert:"head",singleton:!1}),a.A.locals;const l=2e4;let h,c,d,u,g;function m(e){h=document.createElement("div"),h.className="monaco-aria-container";const t=()=>{const e=document.createElement("div");return e.className="monaco-alert",e.setAttribute("role","alert"),e.setAttribute("aria-atomic","true"),h.appendChild(e),e};c=t(),d=t();const i=()=>{const e=document.createElement("div");return e.className="monaco-status",e.setAttribute("role","complementary"),e.setAttribute("aria-live","polite"),e.setAttribute("aria-atomic","true"),h.appendChild(e),e};u=i(),g=i(),e.appendChild(h)}function p(e){h&&(c.textContent!==e?(n.w_(d),A(c,e)):(n.w_(c),A(d,e)))}function f(e){h&&(o.zx?p(e):u.textContent!==e?(n.w_(g),A(u,e)):(n.w_(u),A(g,e)))}function A(e,t){n.w_(e),t.length>l&&(t=t.substr(0,l)),e.textContent=t,e.style.visibility="hidden",e.style.visibility="visible"}},2197:(e,t,i)=>{i.d(t,{c:()=>_});var n=i(8479),o=i(771),s=i(8694),r=i(1759);const a=r.kg("caseDescription","Match Case"),l=r.kg("wordsDescription","Match Whole Word"),h=r.kg("regexDescription","Use Regular Expression");class c extends o.l{constructor(e){super({icon:s.W.caseSensitive,title:a+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class d extends o.l{constructor(e){super({icon:s.W.wholeWord,title:l+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class u extends o.l{constructor(e){super({icon:s.W.regex,title:h+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}var g=i(6641),m=i(2776),p=i(3884),f=(i(267),i(8300));const A=r.kg("defaultLabel","input");class _ extends m.x{constructor(e,t,i){super(),this.fixFocusOnOptionClickEnabled=!0,this.imeSessionInProgress=!1,this.additionalTogglesDisposables=new f.Cm,this.additionalToggles=[],this._onDidOptionChange=this._register(new p.vl),this.onDidOptionChange=this._onDidOptionChange.event,this._onKeyDown=this._register(new p.vl),this.onKeyDown=this._onKeyDown.event,this._onMouseDown=this._register(new p.vl),this.onMouseDown=this._onMouseDown.event,this._onInput=this._register(new p.vl),this._onKeyUp=this._register(new p.vl),this._onCaseSensitiveKeyDown=this._register(new p.vl),this.onCaseSensitiveKeyDown=this._onCaseSensitiveKeyDown.event,this._onRegexKeyDown=this._register(new p.vl),this.onRegexKeyDown=this._onRegexKeyDown.event,this._lastHighlightFindOptions=0,this.placeholder=i.placeholder||"",this.validation=i.validation,this.label=i.label||A,this.showCommonFindToggles=!!i.showCommonFindToggles;const o=i.appendCaseSensitiveLabel||"",s=i.appendWholeWordsLabel||"",r=i.appendRegexLabel||"",a=i.history||[],l=!!i.flexibleHeight,h=!!i.flexibleWidth,m=i.flexibleMaxHeight;if(this.domNode=document.createElement("div"),this.domNode.classList.add("monaco-findInput"),this.inputBox=this._register(new g.mJ(this.domNode,t,{placeholder:this.placeholder||"",ariaLabel:this.label||"",validationOptions:{validation:this.validation},history:a,showHistoryHint:i.showHistoryHint,flexibleHeight:l,flexibleWidth:h,flexibleMaxHeight:m,inputBoxStyles:i.inputBoxStyles})),this.showCommonFindToggles){this.regex=this._register(new u(Object.assign({appendTitle:r,isChecked:!1},i.toggleStyles))),this._register(this.regex.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.regex.onKeyDown((e=>{this._onRegexKeyDown.fire(e)}))),this.wholeWords=this._register(new d(Object.assign({appendTitle:s,isChecked:!1},i.toggleStyles))),this._register(this.wholeWords.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this.caseSensitive=this._register(new c(Object.assign({appendTitle:o,isChecked:!1},i.toggleStyles))),this._register(this.caseSensitive.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.caseSensitive.onKeyDown((e=>{this._onCaseSensitiveKeyDown.fire(e)})));const e=[this.caseSensitive.domNode,this.wholeWords.domNode,this.regex.domNode];this.onkeydown(this.domNode,(t=>{if(t.equals(15)||t.equals(17)||t.equals(9)){const i=e.indexOf(document.activeElement);if(i>=0){let o=-1;t.equals(17)?o=(i+1)%e.length:t.equals(15)&&(o=0===i?e.length-1:i-1),t.equals(9)?(e[i].blur(),this.inputBox.focus()):o>=0&&e[o].focus(),n.fs.stop(t,!0)}}}))}this.controls=document.createElement("div"),this.controls.className="controls",this.controls.style.display=this.showCommonFindToggles?"":"none",this.caseSensitive&&this.controls.append(this.caseSensitive.domNode),this.wholeWords&&this.controls.appendChild(this.wholeWords.domNode),this.regex&&this.controls.appendChild(this.regex.domNode),this.setAdditionalToggles(null==i?void 0:i.additionalToggles),this.controls&&this.domNode.appendChild(this.controls),null==e||e.appendChild(this.domNode),this._register(n.ko(this.inputBox.inputElement,"compositionstart",(e=>{this.imeSessionInProgress=!0}))),this._register(n.ko(this.inputBox.inputElement,"compositionend",(e=>{this.imeSessionInProgress=!1,this._onInput.fire()}))),this.onkeydown(this.inputBox.inputElement,(e=>this._onKeyDown.fire(e))),this.onkeyup(this.inputBox.inputElement,(e=>this._onKeyUp.fire(e))),this.oninput(this.inputBox.inputElement,(e=>this._onInput.fire())),this.onmousedown(this.inputBox.inputElement,(e=>this._onMouseDown.fire(e)))}get onDidChange(){return this.inputBox.onDidChange}layout(e){this.inputBox.layout(),this.updateInputBoxPadding(e.collapsedFindWidget)}enable(){var e,t,i;this.domNode.classList.remove("disabled"),this.inputBox.enable(),null===(e=this.regex)||void 0===e||e.enable(),null===(t=this.wholeWords)||void 0===t||t.enable(),null===(i=this.caseSensitive)||void 0===i||i.enable();for(const e of this.additionalToggles)e.enable()}disable(){var e,t,i;this.domNode.classList.add("disabled"),this.inputBox.disable(),null===(e=this.regex)||void 0===e||e.disable(),null===(t=this.wholeWords)||void 0===t||t.disable(),null===(i=this.caseSensitive)||void 0===i||i.disable();for(const e of this.additionalToggles)e.disable()}setFocusInputOnOptionClick(e){this.fixFocusOnOptionClickEnabled=e}setEnabled(e){e?this.enable():this.disable()}setAdditionalToggles(e){for(const e of this.additionalToggles)e.domNode.remove();this.additionalToggles=[],this.additionalTogglesDisposables.dispose(),this.additionalTogglesDisposables=new f.Cm;for(const t of null!=e?e:[])this.additionalTogglesDisposables.add(t),this.controls.appendChild(t.domNode),this.additionalTogglesDisposables.add(t.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus()}))),this.additionalToggles.push(t);this.additionalToggles.length>0&&(this.controls.style.display=""),this.updateInputBoxPadding()}updateInputBoxPadding(e=!1){var t,i,n,o,s,r;this.inputBox.paddingRight=e?0:(null!==(i=null===(t=this.caseSensitive)||void 0===t?void 0:t.width())&&void 0!==i?i:0)+(null!==(o=null===(n=this.wholeWords)||void 0===n?void 0:n.width())&&void 0!==o?o:0)+(null!==(r=null===(s=this.regex)||void 0===s?void 0:s.width())&&void 0!==r?r:0)+this.additionalToggles.reduce(((e,t)=>e+t.width()),0)}getValue(){return this.inputBox.value}setValue(e){this.inputBox.value!==e&&(this.inputBox.value=e)}select(){this.inputBox.select()}focus(){this.inputBox.focus()}getCaseSensitive(){var e,t;return null!==(t=null===(e=this.caseSensitive)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setCaseSensitive(e){this.caseSensitive&&(this.caseSensitive.checked=e)}getWholeWords(){var e,t;return null!==(t=null===(e=this.wholeWords)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setWholeWords(e){this.wholeWords&&(this.wholeWords.checked=e)}getRegex(){var e,t;return null!==(t=null===(e=this.regex)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setRegex(e){this.regex&&(this.regex.checked=e,this.validate())}focusOnCaseSensitive(){var e;null===(e=this.caseSensitive)||void 0===e||e.focus()}highlightFindOptions(){this.domNode.classList.remove("highlight-"+this._lastHighlightFindOptions),this._lastHighlightFindOptions=1-this._lastHighlightFindOptions,this.domNode.classList.add("highlight-"+this._lastHighlightFindOptions)}validate(){this.inputBox.validate()}showMessage(e){this.inputBox.showMessage(e)}clearMessage(){this.inputBox.hideMessage()}}},678:(e,t,i)=>{i.d(t,{s:()=>m});var n=i(3925),o=i.n(n),s=i(7203);o()(s.A,{insert:"head",singleton:!1}),s.A.locals;var r=i(8479),a=i(8948),l=i(3104);class h{constructor(e,t){var i;this.text="",this.title="",this.highlights=[],this.didEverRender=!1,this.supportIcons=null!==(i=null==t?void 0:t.supportIcons)&&void 0!==i&&i,this.domNode=r.BC(e,r.$("span.monaco-highlighted-label"))}get element(){return this.domNode}set(e,t=[],i="",n){e||(e=""),n&&(e=h.escapeNewLines(e,t)),this.didEverRender&&this.text===e&&this.title===i&&l.aI(this.highlights,t)||(this.text=e,this.title=i,this.highlights=t,this.render())}render(){const e=[];let t=0;for(const i of this.highlights){if(i.end===i.start)continue;if(t<i.start){const n=this.text.substring(t,i.start);this.supportIcons?e.push(...(0,a.n)(n)):e.push(n),t=i.start}const n=this.text.substring(t,i.end),o=r.$("span.highlight",void 0,...this.supportIcons?(0,a.n)(n):[n]);i.extraClasses&&o.classList.add(...i.extraClasses),e.push(o),t=i.end}if(t<this.text.length){const i=this.text.substring(t);this.supportIcons?e.push(...(0,a.n)(i)):e.push(i)}r.Ln(this.domNode,...e),this.title?this.domNode.title=this.title:this.domNode.removeAttribute("title"),this.didEverRender=!0}static escapeNewLines(e,t){let i=0,n=0;return e.replace(/\r\n|\r|\n/g,((e,o)=>{n="\r\n"===e?-1:0,o+=i;for(const e of t)e.end<=o||(e.start>=o&&(e.start+=n),e.end>=o&&(e.end+=n));return i+=n,"⏎"}))}}var c=i(6551),d=i(8300),u=i(4101);class g{constructor(e){this._element=e}get element(){return this._element}set textContent(e){this.disposed||e===this._textContent||(this._textContent=e,this._element.textContent=e)}set className(e){this.disposed||e===this._className||(this._className=e,this._element.className=e)}set empty(e){this.disposed||e===this._empty||(this._empty=e,this._element.style.marginLeft=e?"0":"")}dispose(){this.disposed=!0}}class m extends d.jG{constructor(e,t){super(),this.customHovers=new Map,this.creationOptions=t,this.domNode=this._register(new g(r.BC(e,r.$(".monaco-icon-label")))),this.labelContainer=r.BC(this.domNode.element,r.$(".monaco-icon-label-container"));const i=r.BC(this.labelContainer,r.$("span.monaco-icon-name-container"));(null==t?void 0:t.supportHighlights)||(null==t?void 0:t.supportIcons)?this.nameNode=new f(i,!!t.supportIcons):this.nameNode=new p(i),this.hoverDelegate=null==t?void 0:t.hoverDelegate}get element(){return this.domNode.element}setLabel(e,t,i){const n=["monaco-icon-label"],o=["monaco-icon-label-container"];if(i&&(i.extraClasses&&n.push(...i.extraClasses),i.italic&&n.push("italic"),i.strikethrough&&n.push("strikethrough"),i.disabledCommand&&o.push("disabled")),this.domNode.className=n.join(" "),this.labelContainer.className=o.join(" "),this.setupHover((null==i?void 0:i.descriptionTitle)?this.labelContainer:this.element,null==i?void 0:i.title),this.nameNode.setLabel(e,i),t||this.descriptionNode){const e=this.getOrCreateDescriptionNode();e instanceof h?(e.set(t||"",i?i.descriptionMatches:void 0,void 0,null==i?void 0:i.labelEscapeNewLines),this.setupHover(e.element,null==i?void 0:i.descriptionTitle)):(e.textContent=t&&(null==i?void 0:i.labelEscapeNewLines)?h.escapeNewLines(t,[]):t||"",this.setupHover(e.element,(null==i?void 0:i.descriptionTitle)||""),e.empty=!t)}}setupHover(e,t){const i=this.customHovers.get(e);if(i&&(i.dispose(),this.customHovers.delete(e)),t)if(this.hoverDelegate){const i=(0,c.f)(this.hoverDelegate,e,t);i&&this.customHovers.set(e,i)}else(0,c.$)(e,t);else e.removeAttribute("title")}dispose(){super.dispose();for(const e of this.customHovers.values())e.dispose();this.customHovers.clear()}getOrCreateDescriptionNode(){var e;if(!this.descriptionNode){const t=this._register(new g(r.BC(this.labelContainer,r.$("span.monaco-icon-description-container"))));(null===(e=this.creationOptions)||void 0===e?void 0:e.supportDescriptionHighlights)?this.descriptionNode=new h(r.BC(t.element,r.$("span.label-description")),{supportIcons:!!this.creationOptions.supportIcons}):this.descriptionNode=this._register(new g(r.BC(t.element,r.$("span.label-description"))))}return this.descriptionNode}}class p{constructor(e){this.container=e,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,l.aI)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=r.BC(this.container,r.$("a.label-name",{id:null==t?void 0:t.domId}))),this.singleLabel.textContent=e;else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;for(let i=0;i<e.length;i++){const n=e[i],o=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${i}`;r.BC(this.container,r.$("a.label-name",{id:o,"data-icon-label-count":e.length,"data-icon-label-index":i,role:"treeitem"},n)),i<e.length-1&&r.BC(this.container,r.$("span.label-separator",void 0,(null==t?void 0:t.separator)||"/"))}}}}class f{constructor(e,t){this.container=e,this.supportIcons=t,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,l.aI)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=new h(r.BC(this.container,r.$("a.label-name",{id:null==t?void 0:t.domId})),{supportIcons:this.supportIcons})),this.singleLabel.set(e,null==t?void 0:t.matches,void 0,null==t?void 0:t.labelEscapeNewLines);else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;const i=(null==t?void 0:t.separator)||"/",n=function(e,t,i){if(!i)return;let n=0;return e.map((e=>{const o={start:n,end:n+e.length},s=i.map((e=>u.Q.intersect(o,e))).filter((e=>!u.Q.isEmpty(e))).map((({start:e,end:t})=>({start:e-n,end:t-n})));return n=o.end+t.length,s}))}(e,i,null==t?void 0:t.matches);for(let o=0;o<e.length;o++){const s=e[o],a=n?n[o]:void 0,l=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${o}`,c=r.$("a.label-name",{id:l,"data-icon-label-count":e.length,"data-icon-label-index":o,role:"treeitem"});new h(r.BC(this.container,c),{supportIcons:this.supportIcons}).set(s,a,void 0,null==t?void 0:t.labelEscapeNewLines),o<e.length-1&&r.BC(c,r.$("span.label-separator",void 0,i))}}}}},6551:(e,t,i)=>{i.d(t,{$:()=>u,f:()=>m});var n=i(8479),o=i(5404),s=i(9377),r=i(5702),a=i(9804),l=i(8300),h=i(2821),c=i(1759),d=function(e,t,i,n){return new(i||(i=Promise))((function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(r,a)}l((n=n.apply(e,t||[])).next())}))};function u(e,t){(0,h.Kg)(t)?e.title=(0,a.pS)(t):(null==t?void 0:t.markdownNotSupportedFallback)?e.title=t.markdownNotSupportedFallback:e.removeAttribute("title")}class g{constructor(e,t,i){this.hoverDelegate=e,this.target=t,this.fadeInAnimation=i}update(e,t,i){var n;return d(this,void 0,void 0,(function*(){if(this._cancellationTokenSource&&(this._cancellationTokenSource.dispose(!0),this._cancellationTokenSource=void 0),this.isDisposed)return;let o;if(void 0===e||(0,h.Kg)(e)||e instanceof HTMLElement)o=e;else if((0,h.Tn)(e.markdown)){this._hoverWidget||this.show((0,c.kg)("iconLabel.loading","Loading..."),t),this._cancellationTokenSource=new s.Q;const i=this._cancellationTokenSource.token;if(o=yield e.markdown(i),void 0===o&&(o=e.markdownNotSupportedFallback),this.isDisposed||i.isCancellationRequested)return}else o=null!==(n=e.markdown)&&void 0!==n?n:e.markdownNotSupportedFallback;this.show(o,t,i)}))}show(e,t,i){const n=this._hoverWidget;if(this.hasContent(e)){const o=Object.assign({content:e,target:this.target,showPointer:"element"===this.hoverDelegate.placement,hoverPosition:2,skipFadeInAnimation:!this.fadeInAnimation||!!n},i);this._hoverWidget=this.hoverDelegate.showHover(o,t)}null==n||n.dispose()}hasContent(e){return!(!e||(0,r.VS)(e)&&!e.value)}get isDisposed(){var e;return null===(e=this._hoverWidget)||void 0===e?void 0:e.isDisposed}dispose(){var e,t;null===(e=this._hoverWidget)||void 0===e||e.dispose(),null===(t=this._cancellationTokenSource)||void 0===t||t.dispose(!0),this._cancellationTokenSource=void 0}}function m(e,t,i,s){let r,a;const h=(t,i)=>{var n;const o=void 0!==a;t&&(null==a||a.dispose(),a=void 0),i&&(null==r||r.dispose(),r=void 0),o&&(null===(n=e.onDidHideHover)||void 0===n||n.call(e))},c=(n,r,l)=>new o.pc((()=>d(this,void 0,void 0,(function*(){a&&!a.isDisposed||(a=new g(e,l||t,n>0),yield a.update(i,r,s))}))),n),u=n.ko(t,n.Bx.MOUSE_OVER,(()=>{if(r)return;const i=new l.Cm;i.add(n.ko(t,n.Bx.MOUSE_LEAVE,(e=>h(!1,e.fromElement===t)),!0)),i.add(n.ko(t,n.Bx.MOUSE_DOWN,(()=>h(!0,!0)),!0));const o={targetElements:[t],dispose:()=>{}};if(void 0===e.placement||"mouse"===e.placement){const e=e=>{o.x=e.x+10,e.target instanceof HTMLElement&&e.target.classList.contains("action-label")&&h(!0,!0)};i.add(n.ko(t,n.Bx.MOUSE_MOVE,e,!0))}i.add(c(e.delay,!1,o)),r=i}),!0);return{show:e=>{h(!1,!0),c(0,e)},hide:()=>{h(!0,!0)},update:(e,t)=>d(this,void 0,void 0,(function*(){i=e,yield null==a?void 0:a.update(i,void 0,t)})),dispose:()=>{u.dispose(),h(!0,!0)}}}},8948:(e,t,i)=>{i.d(t,{n:()=>r});var n=i(8479),o=i(3483);const s=new RegExp(`(\\\\)?\\$\\((${o.L.iconNameExpression}(?:${o.L.iconModifierExpression})?)\\)`,"g");function r(e){const t=new Array;let i,n=0,o=0;for(;null!==(i=s.exec(e));){o=i.index||0,n<o&&t.push(e.substring(n,o)),n=(i.index||0)+i[0].length;const[,s,r]=i;t.push(s?`$(${r})`:a({id:r}))}return n<e.length&&t.push(e.substring(n)),t}function a(e){const t=n.$("span");return t.classList.add(...o.L.asClassNameArray(e)),t}},6641:(e,t,i)=>{i.d(t,{mJ:()=>v,x8:()=>w});var n=i(8479),o=i(9923),s=i(7095),r=i(1758),a=i(6413),l=i(5443),h=i(2776),c=i(3884);class d{constructor(e,t=0,i=e.length,n=t-1){this.items=e,this.start=t,this.end=i,this.index=n}current(){return this.index===this.start-1||this.index===this.end?null:this.items[this.index]}next(){return this.index=Math.min(this.index+1,this.end),this.current()}previous(){return this.index=Math.max(this.index-1,this.start-1),this.current()}first(){return this.index=this.start,this.current()}last(){return this.index=this.end-1,this.current()}}class u{constructor(e=[],t=10){this._initialize(e),this._limit=t,this._onChange()}getHistory(){return this._elements}add(e){this._history.delete(e),this._history.add(e),this._onChange()}next(){return this._navigator.next()}previous(){return 0!==this._currentPosition()?this._navigator.previous():null}current(){return this._navigator.current()}first(){return this._navigator.first()}last(){return this._navigator.last()}isLast(){return this._currentPosition()>=this._elements.length-1}isNowhere(){return null===this._navigator.current()}has(e){return this._history.has(e)}_onChange(){this._reduceToLimit();const e=this._elements;this._navigator=new d(e,0,e.length,e.length)}_reduceToLimit(){const e=this._elements;e.length>this._limit&&this._initialize(e.slice(e.length-this._limit))}_currentPosition(){const e=this._navigator.current();return e?this._elements.indexOf(e):-1}_initialize(e){this._history=new Set;for(const t of e)this._history.add(t)}get _elements(){const e=[];return this._history.forEach((t=>e.push(t))),e}}var g=i(3104),m=i(3925),p=i.n(m),f=i(4283);p()(f.A,{insert:"head",singleton:!1}),f.A.locals;var A=i(1759);const _=n.$,w={inputBackground:"#3C3C3C",inputForeground:"#CCCCCC",inputValidationInfoBorder:"#55AAFF",inputValidationInfoBackground:"#063B49",inputValidationWarningBorder:"#B89500",inputValidationWarningBackground:"#352A05",inputValidationErrorBorder:"#BE1100",inputValidationErrorBackground:"#5A1D1D",inputBorder:void 0,inputValidationErrorForeground:void 0,inputValidationInfoForeground:void 0,inputValidationWarningForeground:void 0};class b extends h.x{constructor(e,t,i){var s;super(),this.state="idle",this.maxHeight=Number.POSITIVE_INFINITY,this._onDidChange=this._register(new c.vl),this.onDidChange=this._onDidChange.event,this._onDidHeightChange=this._register(new c.vl),this.onDidHeightChange=this._onDidHeightChange.event,this.contextViewProvider=t,this.options=i,this.message=null,this.placeholder=this.options.placeholder||"",this.tooltip=null!==(s=this.options.tooltip)&&void 0!==s?s:this.placeholder||"",this.ariaLabel=this.options.ariaLabel||"",this.options.validationOptions&&(this.validation=this.options.validationOptions.validation),this.element=n.BC(e,_(".monaco-inputbox.idle"));const a=this.options.flexibleHeight?"textarea":"input",h=n.BC(this.element,_(".ibwrapper"));if(this.input=n.BC(h,_(a+".input.empty")),this.input.setAttribute("autocorrect","off"),this.input.setAttribute("autocapitalize","off"),this.input.setAttribute("spellcheck","false"),this.onfocus(this.input,(()=>this.element.classList.add("synthetic-focus"))),this.onblur(this.input,(()=>this.element.classList.remove("synthetic-focus"))),this.options.flexibleHeight){this.maxHeight="number"==typeof this.options.flexibleMaxHeight?this.options.flexibleMaxHeight:Number.POSITIVE_INFINITY,this.mirror=n.BC(h,_("div.mirror")),this.mirror.innerText=" ",this.scrollableElement=new l.Se(this.element,{vertical:1}),this.options.flexibleWidth&&(this.input.setAttribute("wrap","off"),this.mirror.style.whiteSpace="pre",this.mirror.style.wordWrap="initial"),n.BC(e,this.scrollableElement.getDomNode()),this._register(this.scrollableElement),this._register(this.scrollableElement.onScroll((e=>this.input.scrollTop=e.scrollTop)));const t=this._register(new o.f(document,"selectionchange")),i=c.Jh.filter(t.event,(()=>{const e=document.getSelection();return(null==e?void 0:e.anchorNode)===h}));this._register(i(this.updateScrollDimensions,this)),this._register(this.onDidHeightChange(this.updateScrollDimensions,this))}else this.input.type=this.options.type||"text",this.input.setAttribute("wrap","off");this.ariaLabel&&this.input.setAttribute("aria-label",this.ariaLabel),this.placeholder&&!this.options.showPlaceholderOnFocus&&this.setPlaceHolder(this.placeholder),this.tooltip&&this.setTooltip(this.tooltip),this.oninput(this.input,(()=>this.onValueChange())),this.onblur(this.input,(()=>this.onBlur())),this.onfocus(this.input,(()=>this.onFocus())),this._register(this.ignoreGesture(this.input)),setTimeout((()=>this.updateMirror()),0),this.options.actions&&(this.actionbar=this._register(new r.E(this.element)),this.actionbar.push(this.options.actions,{icon:!0,label:!1})),this.applyStyles()}onBlur(){this._hideMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder","")}onFocus(){this._showMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder",this.placeholder||"")}setPlaceHolder(e){this.placeholder=e,this.input.setAttribute("placeholder",e)}setTooltip(e){this.tooltip=e,this.input.title=e}get inputElement(){return this.input}get value(){return this.input.value}set value(e){this.input.value!==e&&(this.input.value=e,this.onValueChange())}get height(){return"number"==typeof this.cachedHeight?this.cachedHeight:n.OK(this.element)}focus(){this.input.focus()}blur(){this.input.blur()}hasFocus(){return document.activeElement===this.input}select(e=null){this.input.select(),e&&(this.input.setSelectionRange(e.start,e.end),e.end===this.input.value.length&&(this.input.scrollLeft=this.input.scrollWidth))}isSelectionAtEnd(){return this.input.selectionEnd===this.input.value.length&&this.input.selectionStart===this.input.selectionEnd}enable(){this.input.removeAttribute("disabled")}disable(){this.blur(),this.input.disabled=!0,this._hideMessage()}set paddingRight(e){this.input.style.width=`calc(100% - ${e}px)`,this.mirror&&(this.mirror.style.paddingRight=e+"px")}updateScrollDimensions(){if("number"!=typeof this.cachedContentHeight||"number"!=typeof this.cachedHeight||!this.scrollableElement)return;const e=this.cachedContentHeight,t=this.cachedHeight,i=this.input.scrollTop;this.scrollableElement.setScrollDimensions({scrollHeight:e,height:t}),this.scrollableElement.setScrollPosition({scrollTop:i})}showMessage(e,t){if("open"===this.state&&(0,g.aI)(this.message,e))return;this.message=e,this.element.classList.remove("idle"),this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add(this.classForType(e.type));const i=this.stylesForType(this.message.type);this.element.style.border=`1px solid ${n.gI(i.border,"transparent")}`,this.message.content&&(this.hasFocus()||t)&&this._showMessage()}hideMessage(){this.message=null,this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add("idle"),this._hideMessage(),this.applyStyles()}validate(){let e=null;return this.validation&&(e=this.validation(this.value),e?(this.inputElement.setAttribute("aria-invalid","true"),this.showMessage(e)):this.inputElement.hasAttribute("aria-invalid")&&(this.inputElement.removeAttribute("aria-invalid"),this.hideMessage())),null==e?void 0:e.type}stylesForType(e){const t=this.options.inputBoxStyles;switch(e){case 1:return{border:t.inputValidationInfoBorder,background:t.inputValidationInfoBackground,foreground:t.inputValidationInfoForeground};case 2:return{border:t.inputValidationWarningBorder,background:t.inputValidationWarningBackground,foreground:t.inputValidationWarningForeground};default:return{border:t.inputValidationErrorBorder,background:t.inputValidationErrorBackground,foreground:t.inputValidationErrorForeground}}}classForType(e){switch(e){case 1:return"info";case 2:return"warning";default:return"error"}}_showMessage(){if(!this.contextViewProvider||!this.message)return;let e;const t=()=>e.style.width=n.Tr(this.element)+"px";let i;this.contextViewProvider.showContextView({getAnchor:()=>this.element,anchorAlignment:1,render:i=>{var o,r;if(!this.message)return null;e=n.BC(i,_(".monaco-inputbox-container")),t();const a={inline:!0,className:"monaco-inputbox-message"},l=this.message.formatContent?(0,s.yk)(this.message.content,a):(0,s.S5)(this.message.content,a);l.classList.add(this.classForType(this.message.type));const h=this.stylesForType(this.message.type);return l.style.backgroundColor=null!==(o=h.background)&&void 0!==o?o:"",l.style.color=null!==(r=h.foreground)&&void 0!==r?r:"",l.style.border=h.border?`1px solid ${h.border}`:"",n.BC(e,l),null},onHide:()=>{this.state="closed"},layout:t}),i=3===this.message.type?A.kg("alertErrorMessage","Error: {0}",this.message.content):2===this.message.type?A.kg("alertWarningMessage","Warning: {0}",this.message.content):A.kg("alertInfoMessage","Info: {0}",this.message.content),a.xE(i),this.state="open"}_hideMessage(){this.contextViewProvider&&("open"===this.state&&this.contextViewProvider.hideContextView(),this.state="idle")}onValueChange(){this._onDidChange.fire(this.value),this.validate(),this.updateMirror(),this.input.classList.toggle("empty",!this.value),"open"===this.state&&this.contextViewProvider&&this.contextViewProvider.layout()}updateMirror(){if(!this.mirror)return;const e=this.value,t=10===e.charCodeAt(e.length-1)?" ":"";(e+t).replace(/\u000c/g,"")?this.mirror.textContent=e+t:this.mirror.innerText=" ",this.layout()}applyStyles(){var e,t,i;const o=this.options.inputBoxStyles,s=null!==(e=o.inputBackground)&&void 0!==e?e:"",r=null!==(t=o.inputForeground)&&void 0!==t?t:"",a=null!==(i=o.inputBorder)&&void 0!==i?i:"";this.element.style.backgroundColor=s,this.element.style.color=r,this.input.style.backgroundColor="inherit",this.input.style.color=r,this.element.style.border=`1px solid ${n.gI(a,"transparent")}`}layout(){if(!this.mirror)return;const e=this.cachedContentHeight;this.cachedContentHeight=n.OK(this.mirror),e!==this.cachedContentHeight&&(this.cachedHeight=Math.min(this.cachedContentHeight,this.maxHeight),this.input.style.height=this.cachedHeight+"px",this._onDidHeightChange.fire(this.cachedContentHeight))}insertAtCursor(e){const t=this.inputElement,i=t.selectionStart,n=t.selectionEnd,o=t.value;null!==i&&null!==n&&(this.value=o.substr(0,i)+e+o.substr(n),t.setSelectionRange(i+1,i+1),this.layout())}dispose(){var e;this._hideMessage(),this.message=null,null===(e=this.actionbar)||void 0===e||e.dispose(),super.dispose()}}class v extends b{constructor(e,t,i){const n=A.kg({key:"history.inputbox.hint",comment:["Text will be prefixed with ⇅ plus a single space, then used as a hint where input field keeps history"]},"for history"),o=` or ⇅ ${n}`,s=` (⇅ ${n})`;super(e,t,i),this._onDidFocus=this._register(new c.vl),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new c.vl),this.onDidBlur=this._onDidBlur.event,this.history=new u(i.history,100);const r=()=>{if(i.showHistoryHint&&i.showHistoryHint()&&!this.placeholder.endsWith(o)&&!this.placeholder.endsWith(s)&&this.history.getHistory().length){const e=this.placeholder.endsWith(")")?o:s,t=this.placeholder+e;i.showPlaceholderOnFocus&&document.activeElement!==this.input?this.placeholder=t:this.setPlaceHolder(t)}};this.observer=new MutationObserver(((e,t)=>{e.forEach((e=>{e.target.textContent||r()}))})),this.observer.observe(this.input,{attributeFilter:["class"]}),this.onfocus(this.input,(()=>r())),this.onblur(this.input,(()=>{const e=e=>{if(this.placeholder.endsWith(e)){const t=this.placeholder.slice(0,this.placeholder.length-e.length);return i.showPlaceholderOnFocus?this.placeholder=t:this.setPlaceHolder(t),!0}return!1};e(s)||e(o)}))}dispose(){super.dispose(),this.observer&&(this.observer.disconnect(),this.observer=void 0)}addToHistory(e){this.value&&(e||this.value!==this.getCurrentValue())&&this.history.add(this.value)}isAtLastInHistory(){return this.history.isLast()}isNowhereInHistory(){return this.history.isNowhere()}showNextValue(){this.history.has(this.value)||this.addToHistory();let e=this.getNextValue();e&&(e=e===this.value?this.getNextValue():e),this.value=null!=e?e:"",a.h5(this.value?this.value:A.kg("clearedInput","Cleared Input"))}showPreviousValue(){this.history.has(this.value)||this.addToHistory();let e=this.getPreviousValue();e&&(e=e===this.value?this.getPreviousValue():e),e&&(this.value=e,a.h5(this.value))}onBlur(){super.onBlur(),this._onDidBlur.fire()}onFocus(){super.onFocus(),this._onDidFocus.fire()}getCurrentValue(){let e=this.history.current();return e||(e=this.history.last(),this.history.next()),e}getPreviousValue(){return this.history.previous()||this.history.first()}getNextValue(){return this.history.next()}}},7368:(e,t,i)=>{i.d(t,{ur:()=>y,uO:()=>D});var n=i(3037),o=i(8479),s=i(9923),r=i(9408),a=i(5443),l=i(8092),h=i(5404),c=i(8844),d=i(3884),u=i(8300),g=i(4101),m=i(1955);function p(e,t){const i=[];for(const n of t){if(e.start>=n.range.end)continue;if(e.end<n.range.start)break;const t=g.Q.intersect(e,n.range);g.Q.isEmpty(t)||i.push({range:t,size:n.size})}return i}function f({start:e,end:t},i){return{start:e+i,end:t+i}}class A{constructor(){this.groups=[],this._size=0}splice(e,t,i=[]){const n=i.length-t,o=p({start:0,end:e},this.groups),s=p({start:e+t,end:Number.POSITIVE_INFINITY},this.groups).map((e=>({range:f(e.range,n),size:e.size}))),r=i.map(((t,i)=>({range:{start:e+i,end:e+i+1},size:t.size})));this.groups=function(...e){return function(e){const t=[];let i=null;for(const n of e){const e=n.range.start,o=n.range.end,s=n.size;i&&s===i.size?i.range.end=o:(i={range:{start:e,end:o},size:s},t.push(i))}return t}(e.reduce(((e,t)=>e.concat(t)),[]))}(o,r,s),this._size=this.groups.reduce(((e,t)=>e+t.size*(t.range.end-t.range.start)),0)}get count(){const e=this.groups.length;return e?this.groups[e-1].range.end:0}get size(){return this._size}indexAt(e){if(e<0)return-1;let t=0,i=0;for(const n of this.groups){const o=n.range.end-n.range.start,s=i+o*n.size;if(e<s)return t+Math.floor((e-i)/n.size);t+=o,i=s}return t}indexAfter(e){return Math.min(this.indexAt(e)+1,this.count)}positionAt(e){if(e<0)return-1;let t=0,i=0;for(const n of this.groups){const o=n.range.end-n.range.start,s=i+o;if(e<s)return t+(e-i)*n.size;t+=o*n.size,i=s}return-1}}class _{constructor(e){this.renderers=e,this.cache=new Map,this.transactionNodesPendingRemoval=new Set,this.inTransaction=!1}alloc(e){let t=this.getTemplateCache(e).pop(),i=!1;if(t)i=this.transactionNodesPendingRemoval.has(t.domNode),i&&this.transactionNodesPendingRemoval.delete(t.domNode);else{const i=(0,o.$)(".monaco-list-row");t={domNode:i,templateId:e,templateData:this.getRenderer(e).renderTemplate(i)}}return{row:t,isReusingConnectedDomNode:i}}release(e){e&&this.releaseRow(e)}transact(e){if(this.inTransaction)throw new Error("Already in transaction");this.inTransaction=!0;try{e()}finally{for(const e of this.transactionNodesPendingRemoval)this.doRemoveNode(e);this.transactionNodesPendingRemoval.clear(),this.inTransaction=!1}}releaseRow(e){const{domNode:t,templateId:i}=e;t&&(this.inTransaction?this.transactionNodesPendingRemoval.add(t):this.doRemoveNode(t)),this.getTemplateCache(i).push(e)}doRemoveNode(e){e.classList.remove("scrolling"),function(e){var t;try{null===(t=e.parentElement)||void 0===t||t.removeChild(e)}catch(e){}}(e)}getTemplateCache(e){let t=this.cache.get(e);return t||(t=[],this.cache.set(e,t)),t}dispose(){this.cache.forEach(((e,t)=>{for(const i of e)this.getRenderer(t).disposeTemplate(i.templateData),i.templateData=null})),this.cache.clear(),this.transactionNodesPendingRemoval.clear()}getRenderer(e){const t=this.renderers.get(e);if(!t)throw new Error(`No renderer found for ${e}`);return t}}var w=i(3329),b=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r};const v={CurrentDragAndDropData:void 0},C={useShadows:!0,verticalScrollMode:1,setRowLineHeight:!0,setRowHeight:!0,supportDynamicHeights:!1,dnd:{getDragElements:e=>[e],getDragURI:()=>null,onDragStart(){},onDragOver:()=>!1,drop(){}},horizontalScrolling:!1,transformOptimization:!0,alwaysConsumeMouseWheel:!0};class y{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class S{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class k{constructor(){this.types=[],this.files=[]}update(e){if(e.types&&this.types.splice(0,this.types.length,...e.types),e.files){this.files.splice(0,this.files.length);for(let t=0;t<e.files.length;t++){const i=e.files.item(t);i&&(i.size||i.type)&&this.files.push(i)}}}getData(){return{types:this.types,files:this.files}}}class E{constructor(e){(null==e?void 0:e.getSetSize)?this.getSetSize=e.getSetSize.bind(e):this.getSetSize=(e,t,i)=>i,(null==e?void 0:e.getPosInSet)?this.getPosInSet=e.getPosInSet.bind(e):this.getPosInSet=(e,t)=>t+1,(null==e?void 0:e.getRole)?this.getRole=e.getRole.bind(e):this.getRole=e=>"listitem",(null==e?void 0:e.isChecked)?this.isChecked=e.isChecked.bind(e):this.isChecked=e=>{}}}class D{get contentHeight(){return this.rangeMap.size}get horizontalScrolling(){return this._horizontalScrolling}set horizontalScrolling(e){if(e!==this._horizontalScrolling){if(e&&this.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");if(this._horizontalScrolling=e,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this._horizontalScrolling){for(const e of this.items)this.measureItemWidth(e);this.updateScrollWidth(),this.scrollableElement.setScrollDimensions({width:(0,o.y6)(this.domNode)}),this.rowsContainer.style.width=`${Math.max(this.scrollWidth||0,this.renderWidth)}px`}else this.scrollableElementWidthDelayer.cancel(),this.scrollableElement.setScrollDimensions({width:this.renderWidth,scrollWidth:this.renderWidth}),this.rowsContainer.style.width=""}}constructor(e,t,i,n=C){var s,l,c,g,p,f,w,b,v,y,S,k;if(this.virtualDelegate=t,this.domId="list_id_"+ ++D.InstanceCount,this.renderers=new Map,this.renderWidth=0,this._scrollHeight=0,this.scrollableElementUpdateDisposable=null,this.scrollableElementWidthDelayer=new h.ve(50),this.splicing=!1,this.dragOverAnimationStopDisposable=u.jG.None,this.dragOverMouseY=0,this.canDrop=!1,this.currentDragFeedbackDisposable=u.jG.None,this.onDragLeaveTimeout=u.jG.None,this.disposables=new u.Cm,this._onDidChangeContentHeight=new d.vl,this._onDidChangeContentWidth=new d.vl,this._horizontalScrolling=!1,n.horizontalScrolling&&n.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");this.items=[],this.itemId=0,this.rangeMap=new A;for(const e of i)this.renderers.set(e.templateId,e);this.cache=this.disposables.add(new _(this.renderers)),this.lastRenderTop=0,this.lastRenderHeight=0,this.domNode=document.createElement("div"),this.domNode.className="monaco-list",this.domNode.classList.add(this.domId),this.domNode.tabIndex=0,this.domNode.classList.toggle("mouse-support","boolean"!=typeof n.mouseSupport||n.mouseSupport),this._horizontalScrolling=null!==(s=n.horizontalScrolling)&&void 0!==s?s:C.horizontalScrolling,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this.additionalScrollHeight=void 0===n.additionalScrollHeight?0:n.additionalScrollHeight,this.accessibilityProvider=new E(n.accessibilityProvider),this.rowsContainer=document.createElement("div"),this.rowsContainer.className="monaco-list-rows",(null!==(l=n.transformOptimization)&&void 0!==l?l:C.transformOptimization)&&(this.rowsContainer.style.transform="translate3d(0px, 0px, 0px)",this.rowsContainer.style.overflow="hidden",this.rowsContainer.style.contain="strict"),this.disposables.add(r.q.addTarget(this.rowsContainer)),this.scrollable=new m.yE({forceIntegerValues:!0,smoothScrollDuration:null!==(c=n.smoothScrolling)&&void 0!==c&&c?125:0,scheduleAtNextAnimationFrame:e=>(0,o.PG)(e)}),this.scrollableElement=this.disposables.add(new a.oO(this.rowsContainer,{alwaysConsumeMouseWheel:null!==(g=n.alwaysConsumeMouseWheel)&&void 0!==g?g:C.alwaysConsumeMouseWheel,horizontal:1,vertical:null!==(p=n.verticalScrollMode)&&void 0!==p?p:C.verticalScrollMode,useShadows:null!==(f=n.useShadows)&&void 0!==f?f:C.useShadows,mouseWheelScrollSensitivity:n.mouseWheelScrollSensitivity,fastScrollSensitivity:n.fastScrollSensitivity,scrollByPage:n.scrollByPage},this.scrollable)),this.domNode.appendChild(this.scrollableElement.getDomNode()),e.appendChild(this.domNode),this.scrollableElement.onScroll(this.onScroll,this,this.disposables),this.disposables.add((0,o.ko)(this.rowsContainer,r.B.Change,(e=>this.onTouchChange(e)))),this.disposables.add((0,o.ko)(this.scrollableElement.getDomNode(),"scroll",(e=>e.target.scrollTop=0))),this.disposables.add((0,o.ko)(this.domNode,"dragover",(e=>this.onDragOver(this.toDragEvent(e))))),this.disposables.add((0,o.ko)(this.domNode,"drop",(e=>this.onDrop(this.toDragEvent(e))))),this.disposables.add((0,o.ko)(this.domNode,"dragleave",(e=>this.onDragLeave(this.toDragEvent(e))))),this.disposables.add((0,o.ko)(this.domNode,"dragend",(e=>this.onDragEnd(e)))),this.setRowLineHeight=null!==(w=n.setRowLineHeight)&&void 0!==w?w:C.setRowLineHeight,this.setRowHeight=null!==(b=n.setRowHeight)&&void 0!==b?b:C.setRowHeight,this.supportDynamicHeights=null!==(v=n.supportDynamicHeights)&&void 0!==v?v:C.supportDynamicHeights,this.dnd=null!==(y=n.dnd)&&void 0!==y?y:C.dnd,this.layout(null===(S=n.initialSize)||void 0===S?void 0:S.height,null===(k=n.initialSize)||void 0===k?void 0:k.width)}updateOptions(e){let t;void 0!==e.additionalScrollHeight&&(this.additionalScrollHeight=e.additionalScrollHeight,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),void 0!==e.smoothScrolling&&this.scrollable.setSmoothScrollDuration(e.smoothScrolling?125:0),void 0!==e.horizontalScrolling&&(this.horizontalScrolling=e.horizontalScrolling),void 0!==e.scrollByPage&&(t=Object.assign(Object.assign({},null!=t?t:{}),{scrollByPage:e.scrollByPage})),void 0!==e.mouseWheelScrollSensitivity&&(t=Object.assign(Object.assign({},null!=t?t:{}),{mouseWheelScrollSensitivity:e.mouseWheelScrollSensitivity})),void 0!==e.fastScrollSensitivity&&(t=Object.assign(Object.assign({},null!=t?t:{}),{fastScrollSensitivity:e.fastScrollSensitivity})),t&&this.scrollableElement.updateOptions(t)}splice(e,t,i=[]){if(this.splicing)throw new Error("Can't run recursive splices.");this.splicing=!0;try{return this._splice(e,t,i)}finally{this.splicing=!1,this._onDidChangeContentHeight.fire(this.contentHeight)}}_splice(e,t,i=[]){const n=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),o={start:e,end:e+t},s=g.Q.intersect(n,o),r=new Map;for(let e=s.end-1;e>=s.start;e--){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){let i=r.get(t.templateId);i||(i=[],r.set(t.templateId,i));const n=this.renderers.get(t.templateId);n&&n.disposeElement&&n.disposeElement(t.element,e,t.row.templateData,t.size),i.push(t.row)}t.row=null}const a={start:e+t,end:this.items.length},l=g.Q.intersect(a,n),h=g.Q.relativeComplement(a,n),c=i.map((e=>({id:String(this.itemId++),element:e,templateId:this.virtualDelegate.getTemplateId(e),size:this.virtualDelegate.getHeight(e),width:void 0,hasDynamicHeight:!!this.virtualDelegate.hasDynamicHeight&&this.virtualDelegate.hasDynamicHeight(e),lastDynamicHeightWidth:void 0,row:null,uri:void 0,dropTarget:!1,dragStartDisposable:u.jG.None,checkedDisposable:u.jG.None})));let d;0===e&&t>=this.items.length?(this.rangeMap=new A,this.rangeMap.splice(0,0,c),d=this.items,this.items=c):(this.rangeMap.splice(e,t,c),d=this.items.splice(e,t,...c));const m=i.length-t,p=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),_=f(l,m),w=g.Q.intersect(p,_);for(let e=w.start;e<w.end;e++)this.updateItemInDOM(this.items[e],e);const b=g.Q.relativeComplement(_,p);for(const e of b)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);const v=h.map((e=>f(e,m))),C=[{start:e,end:e+i.length},...v].map((e=>g.Q.intersect(p,e))),y=this.getNextToLastElement(C);for(const e of C)for(let t=e.start;t<e.end;t++){const e=this.items[t],i=r.get(e.templateId),n=null==i?void 0:i.pop();this.insertItemInDOM(t,y,n)}for(const e of r.values())for(const t of e)this.cache.release(t);return this.eventuallyUpdateScrollDimensions(),this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight),d.map((e=>e.element))}eventuallyUpdateScrollDimensions(){this._scrollHeight=this.contentHeight,this.rowsContainer.style.height=`${this._scrollHeight}px`,this.scrollableElementUpdateDisposable||(this.scrollableElementUpdateDisposable=(0,o.PG)((()=>{this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight}),this.updateScrollWidth(),this.scrollableElementUpdateDisposable=null})))}eventuallyUpdateScrollWidth(){this.horizontalScrolling?this.scrollableElementWidthDelayer.trigger((()=>this.updateScrollWidth())):this.scrollableElementWidthDelayer.cancel()}updateScrollWidth(){if(!this.horizontalScrolling)return;let e=0;for(const t of this.items)void 0!==t.width&&(e=Math.max(e,t.width));this.scrollWidth=e,this.scrollableElement.setScrollDimensions({scrollWidth:0===e?0:e+10}),this._onDidChangeContentWidth.fire(this.scrollWidth)}rerender(){if(this.supportDynamicHeights){for(const e of this.items)e.lastDynamicHeightWidth=void 0;this._rerender(this.lastRenderTop,this.lastRenderHeight)}}get length(){return this.items.length}get renderHeight(){return this.scrollableElement.getScrollDimensions().height}get firstVisibleIndex(){const e=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),t=this.rangeMap.positionAt(e.start),i=this.rangeMap.positionAt(e.start+1);return-1!==i&&(i-t)/2+t<this.scrollTop?e.start+1:e.start}element(e){return this.items[e].element}domElement(e){const t=this.items[e].row;return t&&t.domNode}elementHeight(e){return this.items[e].size}elementTop(e){return this.rangeMap.positionAt(e)}indexAt(e){return this.rangeMap.indexAt(e)}indexAfter(e){return this.rangeMap.indexAfter(e)}layout(e,t){const i={height:"number"==typeof e?e:(0,o.H4)(this.domNode)};this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,i.scrollHeight=this.scrollHeight),this.scrollableElement.setScrollDimensions(i),void 0!==t&&(this.renderWidth=t,this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight)),this.horizontalScrolling&&this.scrollableElement.setScrollDimensions({width:"number"==typeof t?t:(0,o.y6)(this.domNode)})}render(e,t,i,n,o,s=!1){const r=this.getRenderRange(t,i),a=g.Q.relativeComplement(r,e),l=g.Q.relativeComplement(e,r),h=this.getNextToLastElement(a);if(s){const t=g.Q.intersect(e,r);for(let e=t.start;e<t.end;e++)this.updateItemInDOM(this.items[e],e)}this.cache.transact((()=>{for(const e of l)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);for(const e of a)for(let t=e.start;t<e.end;t++)this.insertItemInDOM(t,h)})),void 0!==n&&(this.rowsContainer.style.left=`-${n}px`),this.rowsContainer.style.top=`-${t}px`,this.horizontalScrolling&&void 0!==o&&(this.rowsContainer.style.width=`${Math.max(o,this.renderWidth)}px`),this.lastRenderTop=t,this.lastRenderHeight=i}insertItemInDOM(e,t,i){const n=this.items[e];let s=!1;if(!n.row)if(i)n.row=i;else{const e=this.cache.alloc(n.templateId);n.row=e.row,s=e.isReusingConnectedDomNode}const r=this.accessibilityProvider.getRole(n.element)||"listitem";n.row.domNode.setAttribute("role",r);const a=this.accessibilityProvider.isChecked(n.element);if("boolean"==typeof a)n.row.domNode.setAttribute("aria-checked",String(!!a));else if(a){const e=e=>n.row.domNode.setAttribute("aria-checked",String(!!e));e(a.value),n.checkedDisposable=a.onDidChange(e)}!s&&n.row.domNode.parentElement||(t?this.rowsContainer.insertBefore(n.row.domNode,t):this.rowsContainer.appendChild(n.row.domNode)),this.updateItemInDOM(n,e);const l=this.renderers.get(n.templateId);if(!l)throw new Error(`No renderer found for template id ${n.templateId}`);null==l||l.renderElement(n.element,e,n.row.templateData,n.size);const h=this.dnd.getDragURI(n.element);n.dragStartDisposable.dispose(),n.row.domNode.draggable=!!h,h&&(n.dragStartDisposable=(0,o.ko)(n.row.domNode,"dragstart",(e=>this.onDragStart(n.element,h,e)))),this.horizontalScrolling&&(this.measureItemWidth(n),this.eventuallyUpdateScrollWidth())}measureItemWidth(e){if(!e.row||!e.row.domNode)return;e.row.domNode.style.width="fit-content",e.width=(0,o.y6)(e.row.domNode);const t=window.getComputedStyle(e.row.domNode);t.paddingLeft&&(e.width+=parseFloat(t.paddingLeft)),t.paddingRight&&(e.width+=parseFloat(t.paddingRight)),e.row.domNode.style.width=""}updateItemInDOM(e,t){e.row.domNode.style.top=`${this.elementTop(t)}px`,this.setRowHeight&&(e.row.domNode.style.height=`${e.size}px`),this.setRowLineHeight&&(e.row.domNode.style.lineHeight=`${e.size}px`),e.row.domNode.setAttribute("data-index",`${t}`),e.row.domNode.setAttribute("data-last-element",t===this.length-1?"true":"false"),e.row.domNode.setAttribute("data-parity",t%2==0?"even":"odd"),e.row.domNode.setAttribute("aria-setsize",String(this.accessibilityProvider.getSetSize(e.element,t,this.length))),e.row.domNode.setAttribute("aria-posinset",String(this.accessibilityProvider.getPosInSet(e.element,t))),e.row.domNode.setAttribute("id",this.getElementDomId(t)),e.row.domNode.classList.toggle("drop-target",e.dropTarget)}removeItemFromDOM(e){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){const i=this.renderers.get(t.templateId);i&&i.disposeElement&&i.disposeElement(t.element,e,t.row.templateData,t.size),this.cache.release(t.row),t.row=null}this.horizontalScrolling&&this.eventuallyUpdateScrollWidth()}getScrollTop(){return this.scrollableElement.getScrollPosition().scrollTop}setScrollTop(e,t){this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),this.scrollableElement.setScrollPosition({scrollTop:e,reuseAnimation:t})}get scrollTop(){return this.getScrollTop()}set scrollTop(e){this.setScrollTop(e)}get scrollHeight(){return this._scrollHeight+(this.horizontalScrolling?10:0)+this.additionalScrollHeight}get onMouseClick(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"click")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseDblClick(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"dblclick")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseMiddleClick(){return d.Jh.filter(d.Jh.map(this.disposables.add(new s.f(this.domNode,"auxclick")).event,(e=>this.toMouseEvent(e)),this.disposables),(e=>1===e.browserEvent.button),this.disposables)}get onMouseDown(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"mousedown")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseOver(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"mouseover")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseOut(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"mouseout")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onContextMenu(){return d.Jh.any(d.Jh.map(this.disposables.add(new s.f(this.domNode,"contextmenu")).event,(e=>this.toMouseEvent(e)),this.disposables),d.Jh.map(this.disposables.add(new s.f(this.domNode,r.B.Contextmenu)).event,(e=>this.toGestureEvent(e)),this.disposables))}get onTouchStart(){return d.Jh.map(this.disposables.add(new s.f(this.domNode,"touchstart")).event,(e=>this.toTouchEvent(e)),this.disposables)}get onTap(){return d.Jh.map(this.disposables.add(new s.f(this.rowsContainer,r.B.Tap)).event,(e=>this.toGestureEvent(e)),this.disposables)}toMouseEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toTouchEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toGestureEvent(e){const t=this.getItemIndexFromEventTarget(e.initialTarget||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toDragEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}onScroll(e){try{const t=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight);this.render(t,e.scrollTop,e.height,e.scrollLeft,e.scrollWidth),this.supportDynamicHeights&&this._rerender(e.scrollTop,e.height,e.inSmoothScrolling)}catch(t){throw console.error("Got bad scroll event:",e),t}}onTouchChange(e){e.preventDefault(),e.stopPropagation(),this.scrollTop-=e.translationY}onDragStart(e,t,i){var s,r;if(!i.dataTransfer)return;const a=this.dnd.getDragElements(e);if(i.dataTransfer.effectAllowed="copyMove",i.dataTransfer.setData(n.t.TEXT,t),i.dataTransfer.setDragImage){let e;this.dnd.getDragLabel&&(e=this.dnd.getDragLabel(a,i)),void 0===e&&(e=String(a.length));const t=(0,o.$)(".monaco-drag-image");t.textContent=e;const n=(e=>{for(;e&&!e.classList.contains("monaco-workbench");)e=e.parentElement;return e||document.body})(this.domNode);n.appendChild(t),i.dataTransfer.setDragImage(t,-10,-10),setTimeout((()=>n.removeChild(t)),0)}this.domNode.classList.add("dragging"),this.currentDragData=new y(a),v.CurrentDragAndDropData=new S(a),null===(r=(s=this.dnd).onDragStart)||void 0===r||r.call(s,this.currentDragData,i)}onDragOver(e){var t;if(e.browserEvent.preventDefault(),this.onDragLeaveTimeout.dispose(),v.CurrentDragAndDropData&&"vscode-ui"===v.CurrentDragAndDropData.getData())return!1;if(this.setupDragAndDropScrollTopAnimation(e.browserEvent),!e.browserEvent.dataTransfer)return!1;if(!this.currentDragData)if(v.CurrentDragAndDropData)this.currentDragData=v.CurrentDragAndDropData;else{if(!e.browserEvent.dataTransfer.types)return!1;this.currentDragData=new k}const i=this.dnd.onDragOver(this.currentDragData,e.element,e.index,e.browserEvent);if(this.canDrop="boolean"==typeof i?i:i.accept,!this.canDrop)return this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),!1;let n;if(e.browserEvent.dataTransfer.dropEffect="boolean"!=typeof i&&0===i.effect?"copy":"move",n="boolean"!=typeof i&&i.feedback?i.feedback:void 0===e.index?[-1]:[e.index],n=(0,l.dM)(n).filter((e=>e>=-1&&e<this.length)).sort(((e,t)=>e-t)),n=-1===n[0]?[-1]:n,o=this.currentDragFeedback,s=n,Array.isArray(o)&&Array.isArray(s)?(0,l.aI)(o,s):o===s)return!0;var o,s;if(this.currentDragFeedback=n,this.currentDragFeedbackDisposable.dispose(),-1===n[0])this.domNode.classList.add("drop-target"),this.rowsContainer.classList.add("drop-target"),this.currentDragFeedbackDisposable=(0,u.s)((()=>{this.domNode.classList.remove("drop-target"),this.rowsContainer.classList.remove("drop-target")}));else{for(const e of n){const i=this.items[e];i.dropTarget=!0,null===(t=i.row)||void 0===t||t.domNode.classList.add("drop-target")}this.currentDragFeedbackDisposable=(0,u.s)((()=>{var e;for(const t of n){const i=this.items[t];i.dropTarget=!1,null===(e=i.row)||void 0===e||e.domNode.classList.remove("drop-target")}}))}return!0}onDragLeave(e){var t,i;this.onDragLeaveTimeout.dispose(),this.onDragLeaveTimeout=(0,h.EQ)((()=>this.clearDragOverFeedback()),100),this.currentDragData&&(null===(i=(t=this.dnd).onDragLeave)||void 0===i||i.call(t,this.currentDragData,e.element,e.index,e.browserEvent))}onDrop(e){if(!this.canDrop)return;const t=this.currentDragData;this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.domNode.classList.remove("dragging"),this.currentDragData=void 0,v.CurrentDragAndDropData=void 0,t&&e.browserEvent.dataTransfer&&(e.browserEvent.preventDefault(),t.update(e.browserEvent.dataTransfer),this.dnd.drop(t,e.element,e.index,e.browserEvent))}onDragEnd(e){var t,i;this.canDrop=!1,this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.domNode.classList.remove("dragging"),this.currentDragData=void 0,v.CurrentDragAndDropData=void 0,null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}clearDragOverFeedback(){this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),this.currentDragFeedbackDisposable=u.jG.None}setupDragAndDropScrollTopAnimation(e){if(!this.dragOverAnimationDisposable){const e=(0,o.cL)(this.domNode).top;this.dragOverAnimationDisposable=(0,o.i0)(this.animateDragAndDropScrollTop.bind(this,e))}this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationStopDisposable=(0,h.EQ)((()=>{this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}),1e3),this.dragOverMouseY=e.pageY}animateDragAndDropScrollTop(e){if(void 0===this.dragOverMouseY)return;const t=this.dragOverMouseY-e,i=this.renderHeight-35;t<35?this.scrollTop+=Math.max(-14,Math.floor(.3*(t-35))):t>i&&(this.scrollTop+=Math.min(14,Math.floor(.3*(t-i))))}teardownDragAndDropScrollTopAnimation(){this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}getItemIndexFromEventTarget(e){const t=this.scrollableElement.getDomNode();let i=e;for(;i instanceof HTMLElement&&i!==this.rowsContainer&&t.contains(i);){const e=i.getAttribute("data-index");if(e){const t=Number(e);if(!isNaN(t))return t}i=i.parentElement}}getRenderRange(e,t){return{start:this.rangeMap.indexAt(e),end:this.rangeMap.indexAfter(e+t-1)}}_rerender(e,t,i){const n=this.getRenderRange(e,t);let o,s;e===this.elementTop(n.start)?(o=n.start,s=0):n.end-n.start>1&&(o=n.start+1,s=this.elementTop(o)-e);let r=0;for(;;){const a=this.getRenderRange(e,t);let l=!1;for(let e=a.start;e<a.end;e++){const t=this.probeDynamicHeight(e);0!==t&&this.rangeMap.splice(e,1,[this.items[e]]),r+=t,l=l||0!==t}if(!l){0!==r&&this.eventuallyUpdateScrollDimensions();const t=g.Q.relativeComplement(n,a);for(const e of t)for(let t=e.start;t<e.end;t++)this.items[t].row&&this.removeItemFromDOM(t);const l=g.Q.relativeComplement(a,n);for(const e of l)for(let t=e.start;t<e.end;t++){const e=t+1,i=e<this.items.length?this.items[e].row:null,n=i?i.domNode:null;this.insertItemInDOM(t,n)}for(let e=a.start;e<a.end;e++)this.items[e].row&&this.updateItemInDOM(this.items[e],e);if("number"==typeof o){const t=this.scrollable.getFutureScrollPosition().scrollTop-e,n=this.elementTop(o)-s+t;this.setScrollTop(n,i)}return void this._onDidChangeContentHeight.fire(this.contentHeight)}}}probeDynamicHeight(e){var t,i,n;const o=this.items[e];if(this.virtualDelegate.getDynamicHeight){const e=this.virtualDelegate.getDynamicHeight(o.element);if(null!==e){const t=o.size;return o.size=e,o.lastDynamicHeightWidth=this.renderWidth,e-t}}if(!o.hasDynamicHeight||o.lastDynamicHeightWidth===this.renderWidth)return 0;if(this.virtualDelegate.hasDynamicHeight&&!this.virtualDelegate.hasDynamicHeight(o.element))return 0;const s=o.size;if(o.row)return o.row.domNode.style.height="",o.size=o.row.domNode.offsetHeight,o.lastDynamicHeightWidth=this.renderWidth,o.size-s;const{row:r}=this.cache.alloc(o.templateId);r.domNode.style.height="",this.rowsContainer.appendChild(r.domNode);const a=this.renderers.get(o.templateId);if(!a)throw new w.D7("Missing renderer for templateId: "+o.templateId);return a.renderElement(o.element,e,r.templateData,void 0),o.size=r.domNode.offsetHeight,null===(t=a.disposeElement)||void 0===t||t.call(a,o.element,e,r.templateData,void 0),null===(n=(i=this.virtualDelegate).setDynamicHeight)||void 0===n||n.call(i,o.element,o.size),o.lastDynamicHeightWidth=this.renderWidth,this.rowsContainer.removeChild(r.domNode),this.cache.release(r),o.size-s}getNextToLastElement(e){const t=e[e.length-1];if(!t)return null;const i=this.items[t.end];return i&&i.row?i.row.domNode:null}getElementDomId(e){return`${this.domId}_${e}`}dispose(){var e;if(this.items){for(const t of this.items)if(t.row){const i=this.renderers.get(t.row.templateId);i&&(null===(e=i.disposeElement)||void 0===e||e.call(i,t.element,-1,t.row.templateData,void 0),i.disposeTemplate(t.row.templateData))}this.items=[]}this.domNode&&this.domNode.parentNode&&this.domNode.parentNode.removeChild(this.domNode),(0,u.AS)(this.disposables)}}D.InstanceCount=0,b([c.B],D.prototype,"onMouseClick",null),b([c.B],D.prototype,"onMouseDblClick",null),b([c.B],D.prototype,"onMouseMiddleClick",null),b([c.B],D.prototype,"onMouseDown",null),b([c.B],D.prototype,"onMouseOver",null),b([c.B],D.prototype,"onMouseOut",null),b([c.B],D.prototype,"onContextMenu",null),b([c.B],D.prototype,"onTouchStart",null),b([c.B],D.prototype,"onTap",null)},3624:(e,t,i)=>{i.d(t,{hb:()=>Q,B8:()=>Y,MH:()=>z,_C:()=>b,Bm:()=>I,B6:()=>L,bm:()=>M,mh:()=>O,tX:()=>R,bG:()=>H});var n=i(8479),o=i(9923),s=i(192),r=i(9408),a=i(6413);class l{constructor(e){this.spliceables=e}splice(e,t,i){this.spliceables.forEach((n=>n.splice(e,t,i)))}}var h=i(8092),c=i(5404),d=i(7863),u=i(8844),g=i(3884),m=i(299),p=i(8300),f=i(6890),A=i(4541),_=i(2821);i(4929);class w extends Error{constructor(e,t){super(`ListError [${e}] ${t}`)}}var b,v,C=i(7368),y=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r},S=function(e,t,i,n){return new(i||(i=Promise))((function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(r,a)}l((n=n.apply(e,t||[])).next())}))};class k{constructor(e){this.trait=e,this.renderedElements=[]}get templateId(){return`template:${this.trait.name}`}renderTemplate(e){return e}renderElement(e,t,i){const n=this.renderedElements.findIndex((e=>e.templateData===i));if(n>=0){const e=this.renderedElements[n];this.trait.unrender(i),e.index=t}else{const e={index:t,templateData:i};this.renderedElements.push(e)}this.trait.renderIndex(t,i)}splice(e,t,i){const n=[];for(const o of this.renderedElements)o.index<e?n.push(o):o.index>=e+t&&n.push({index:o.index+i-t,templateData:o.templateData});this.renderedElements=n}renderIndexes(e){for(const{index:t,templateData:i}of this.renderedElements)e.indexOf(t)>-1&&this.trait.renderIndex(t,i)}disposeTemplate(e){const t=this.renderedElements.findIndex((t=>t.templateData===e));t<0||this.renderedElements.splice(t,1)}}class E{get name(){return this._trait}get renderer(){return new k(this)}constructor(e){this._trait=e,this.length=0,this.indexes=[],this.sortedIndexes=[],this._onChange=new g.vl,this.onChange=this._onChange.event}splice(e,t,i){var n;t=Math.max(0,Math.min(t,this.length-e));const o=i.length-t,s=e+t,r=[...this.sortedIndexes.filter((t=>t<e)),...i.map(((t,i)=>t?i+e:-1)).filter((e=>-1!==e)),...this.sortedIndexes.filter((e=>e>=s)).map((e=>e+o))],a=this.length+o;if(this.sortedIndexes.length>0&&0===r.length&&a>0){const t=null!==(n=this.sortedIndexes.find((t=>t>=e)))&&void 0!==n?n:a-1;r.push(Math.min(t,a-1))}this.renderer.splice(e,t,i.length),this._set(r,r),this.length=a}renderIndex(e,t){t.classList.toggle(this._trait,this.contains(e))}unrender(e){e.classList.remove(this._trait)}set(e,t){return this._set(e,[...e].sort(U),t)}_set(e,t,i){const n=this.indexes,o=this.sortedIndexes;this.indexes=e,this.sortedIndexes=t;const s=V(o,e);return this.renderer.renderIndexes(s),this._onChange.fire({indexes:e,browserEvent:i}),n}get(){return this.indexes}contains(e){return(0,h.El)(this.sortedIndexes,e,U)>=0}dispose(){(0,p.AS)(this._onChange)}}y([u.B],E.prototype,"renderer",null);class D extends E{constructor(e){super("selected"),this.setAriaSelected=e}renderIndex(e,t){super.renderIndex(e,t),this.setAriaSelected&&(this.contains(e)?t.setAttribute("aria-selected","true"):t.setAttribute("aria-selected","false"))}}class x{constructor(e,t,i){this.trait=e,this.view=t,this.identityProvider=i}splice(e,t,i){if(!this.identityProvider)return this.trait.splice(e,t,i.map((()=>!1)));const n=this.trait.get().map((e=>this.identityProvider.getId(this.view.element(e)).toString())),o=i.map((e=>n.indexOf(this.identityProvider.getId(e).toString())>-1));this.trait.splice(e,t,o)}}function L(e){return"INPUT"===e.tagName||"TEXTAREA"===e.tagName}function M(e){return!!e.classList.contains("monaco-editor")||!e.classList.contains("monaco-list")&&!!e.parentElement&&M(e.parentElement)}function I(e){return!!("A"===e.tagName&&e.classList.contains("monaco-button")||"DIV"===e.tagName&&e.classList.contains("monaco-button-dropdown"))||!e.classList.contains("monaco-list")&&!!e.parentElement&&I(e.parentElement)}class B{get onKeyDown(){return this.disposables.add(g.Jh.chain(this.disposables.add(new o.f(this.view.domNode,"keydown")).event).filter((e=>!L(e.target))).map((e=>new s.Z(e))))}constructor(e,t,i){this.list=e,this.view=t,this.disposables=new p.Cm,this.multipleSelectionDisposables=new p.Cm,this.onKeyDown.filter((e=>3===e.keyCode)).on(this.onEnter,this,this.disposables),this.onKeyDown.filter((e=>16===e.keyCode)).on(this.onUpArrow,this,this.disposables),this.onKeyDown.filter((e=>18===e.keyCode)).on(this.onDownArrow,this,this.disposables),this.onKeyDown.filter((e=>11===e.keyCode)).on(this.onPageUpArrow,this,this.disposables),this.onKeyDown.filter((e=>12===e.keyCode)).on(this.onPageDownArrow,this,this.disposables),this.onKeyDown.filter((e=>9===e.keyCode)).on(this.onEscape,this,this.disposables),!1!==i.multipleSelectionSupport&&this.onKeyDown.filter((e=>(A.zx?e.metaKey:e.ctrlKey)&&31===e.keyCode)).on(this.onCtrlA,this,this.multipleSelectionDisposables)}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionDisposables.clear(),e.multipleSelectionSupport&&this.onKeyDown.filter((e=>(A.zx?e.metaKey:e.ctrlKey)&&31===e.keyCode)).on(this.onCtrlA,this,this.multipleSelectionDisposables))}onEnter(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection(this.list.getFocus(),e.browserEvent)}onUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPrevious(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNext(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPreviousPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNextPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onCtrlA(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection((0,h.y1)(this.list.length),e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus()}onEscape(e){this.list.getSelection().length&&(e.preventDefault(),e.stopPropagation(),this.list.setSelection([],e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus())}dispose(){this.disposables.dispose(),this.multipleSelectionDisposables.dispose()}}y([u.B],B.prototype,"onKeyDown",null),function(e){e[e.Automatic=0]="Automatic",e[e.Trigger=1]="Trigger"}(b||(b={})),function(e){e[e.Idle=0]="Idle",e[e.Typing=1]="Typing"}(v||(v={}));const N=new class{mightProducePrintableCharacter(e){return!(e.ctrlKey||e.metaKey||e.altKey)&&(e.keyCode>=31&&e.keyCode<=56||e.keyCode>=21&&e.keyCode<=30||e.keyCode>=98&&e.keyCode<=107||e.keyCode>=85&&e.keyCode<=95)}};class T{constructor(e,t,i,n,o){this.list=e,this.view=t,this.keyboardNavigationLabelProvider=i,this.keyboardNavigationEventFilter=n,this.delegate=o,this.enabled=!1,this.state=v.Idle,this.mode=b.Automatic,this.triggered=!1,this.previouslyFocused=-1,this.enabledDisposables=new p.Cm,this.disposables=new p.Cm,this.updateOptions(e.options)}updateOptions(e){var t,i;null===(t=e.typeNavigationEnabled)||void 0===t||t?this.enable():this.disable(),this.mode=null!==(i=e.typeNavigationMode)&&void 0!==i?i:b.Automatic}enable(){if(this.enabled)return;let e=!1;const t=this.enabledDisposables.add(g.Jh.chain(this.enabledDisposables.add(new o.f(this.view.domNode,"keydown")).event)).filter((e=>!L(e.target))).filter((()=>this.mode===b.Automatic||this.triggered)).map((e=>new s.Z(e))).filter((t=>e||this.keyboardNavigationEventFilter(t))).filter((e=>this.delegate.mightProducePrintableCharacter(e))).forEach((e=>n.fs.stop(e,!0))).map((e=>e.browserEvent.key)).event,i=g.Jh.debounce(t,(()=>null),800,void 0,void 0,void 0,this.enabledDisposables);g.Jh.reduce(g.Jh.any(t,i),((e,t)=>null===t?null:(e||"")+t),void 0,this.enabledDisposables)(this.onInput,this,this.enabledDisposables),i(this.onClear,this,this.enabledDisposables),t((()=>e=!0),void 0,this.enabledDisposables),i((()=>e=!1),void 0,this.enabledDisposables),this.enabled=!0,this.triggered=!1}disable(){this.enabled&&(this.enabledDisposables.clear(),this.enabled=!1,this.triggered=!1)}onClear(){var e;const t=this.list.getFocus();if(t.length>0&&t[0]===this.previouslyFocused){const i=null===(e=this.list.options.accessibilityProvider)||void 0===e?void 0:e.getAriaLabel(this.list.element(t[0]));i&&(0,a.xE)(i)}this.previouslyFocused=-1}onInput(e){if(!e)return this.state=v.Idle,void(this.triggered=!1);const t=this.list.getFocus(),i=t.length>0?t[0]:0,n=this.state===v.Idle?1:0;this.state=v.Typing;for(let t=0;t<this.list.length;t++){const o=(i+t+n)%this.list.length,s=this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(this.view.element(o)),r=s&&s.toString();if(void 0===r||(0,m.WP)(e,r))return this.previouslyFocused=i,this.list.setFocus([o]),void this.list.reveal(o)}}dispose(){this.disable(),this.enabledDisposables.dispose(),this.disposables.dispose()}}class F{constructor(e,t){this.list=e,this.view=t,this.disposables=new p.Cm,this.disposables.add(g.Jh.chain(this.disposables.add(new o.f(t.domNode,"keydown")).event)).filter((e=>!L(e.target))).map((e=>new s.Z(e))).filter((e=>!(2!==e.keyCode||e.ctrlKey||e.metaKey||e.shiftKey||e.altKey))).on(this.onTab,this,this.disposables)}onTab(e){if(e.target!==this.view.domNode)return;const t=this.list.getFocus();if(0===t.length)return;const i=this.view.domElement(t[0]);if(!i)return;const n=i.querySelector("[tabIndex]");if(!(n&&n instanceof HTMLElement&&-1!==n.tabIndex))return;const o=window.getComputedStyle(n);"hidden"!==o.visibility&&"none"!==o.display&&(e.preventDefault(),e.stopPropagation(),n.focus())}dispose(){this.disposables.dispose()}}function R(e){return A.zx?e.browserEvent.metaKey:e.browserEvent.ctrlKey}function O(e){return e.browserEvent.shiftKey}const P={isSelectionSingleChangeEvent:R,isSelectionRangeChangeEvent:O};class z{constructor(e){this.list=e,this.disposables=new p.Cm,this._onPointer=new g.vl,this.onPointer=this._onPointer.event,!1!==e.options.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||P),this.mouseSupport=void 0===e.options.mouseSupport||!!e.options.mouseSupport,this.mouseSupport&&(e.onMouseDown(this.onMouseDown,this,this.disposables),e.onContextMenu(this.onContextMenu,this,this.disposables),e.onMouseDblClick(this.onDoubleClick,this,this.disposables),e.onTouchStart(this.onMouseDown,this,this.disposables),this.disposables.add(r.q.addTarget(e.getHTMLElement()))),g.Jh.any(e.onMouseClick,e.onMouseMiddleClick,e.onTap)(this.onViewPointer,this,this.disposables)}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionController=void 0,e.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||P))}isSelectionSingleChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionSingleChangeEvent(e)}isSelectionRangeChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionRangeChangeEvent(e)}isSelectionChangeEvent(e){return this.isSelectionSingleChangeEvent(e)||this.isSelectionRangeChangeEvent(e)}onMouseDown(e){M(e.browserEvent.target)||document.activeElement!==e.browserEvent.target&&this.list.domFocus()}onContextMenu(e){if(L(e.browserEvent.target)||M(e.browserEvent.target))return;const t=void 0===e.index?[]:[e.index];this.list.setFocus(t,e.browserEvent)}onViewPointer(e){if(!this.mouseSupport)return;if(L(e.browserEvent.target)||M(e.browserEvent.target))return;if(e.browserEvent.isHandledByList)return;e.browserEvent.isHandledByList=!0;const t=e.index;return void 0===t?(this.list.setFocus([],e.browserEvent),this.list.setSelection([],e.browserEvent),void this.list.setAnchor(void 0)):this.isSelectionRangeChangeEvent(e)||this.isSelectionChangeEvent(e)?this.changeSelection(e):(this.list.setFocus([t],e.browserEvent),this.list.setAnchor(t),(i=e.browserEvent)instanceof MouseEvent&&2===i.button||this.list.setSelection([t],e.browserEvent),void this._onPointer.fire(e));var i}onDoubleClick(e){if(L(e.browserEvent.target)||M(e.browserEvent.target))return;if(this.isSelectionChangeEvent(e))return;if(e.browserEvent.isHandledByList)return;e.browserEvent.isHandledByList=!0;const t=this.list.getFocus();this.list.setSelection(t,e.browserEvent)}changeSelection(e){const t=e.index;let i=this.list.getAnchor();if(this.isSelectionRangeChangeEvent(e)){if(void 0===i){const e=this.list.getFocus()[0];i=null!=e?e:t,this.list.setAnchor(i)}const n=Math.min(i,t),o=Math.max(i,t),s=(0,h.y1)(n,o+1),r=this.list.getSelection(),a=function(e,t){const i=e.indexOf(t);if(-1===i)return[];const n=[];let o=i-1;for(;o>=0&&e[o]===t-(i-o);)n.push(e[o--]);for(n.reverse(),o=i;o<e.length&&e[o]===t+(o-i);)n.push(e[o++]);return n}(V(r,[i]),i);if(0===a.length)return;const l=V(s,function(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){n++,o++;continue}e[n]<t[o]?i.push(e[n++]):o++}return i}(r,a));this.list.setSelection(l,e.browserEvent),this.list.setFocus([t],e.browserEvent)}else if(this.isSelectionSingleChangeEvent(e)){const i=this.list.getSelection(),n=i.filter((e=>e!==t));this.list.setFocus([t]),this.list.setAnchor(t),i.length===n.length?this.list.setSelection([...n,t],e.browserEvent):this.list.setSelection(n,e.browserEvent)}}dispose(){this.disposables.dispose()}}class Q{constructor(e,t){this.styleElement=e,this.selectorSuffix=t}style(e){var t,i;const o=this.selectorSuffix&&`.${this.selectorSuffix}`,s=[];e.listBackground&&s.push(`.monaco-list${o} .monaco-list-rows { background: ${e.listBackground}; }`),e.listFocusBackground&&(s.push(`.monaco-list${o}:focus .monaco-list-row.focused { background-color: ${e.listFocusBackground}; }`),s.push(`.monaco-list${o}:focus .monaco-list-row.focused:hover { background-color: ${e.listFocusBackground}; }`)),e.listFocusForeground&&s.push(`.monaco-list${o}:focus .monaco-list-row.focused { color: ${e.listFocusForeground}; }`),e.listActiveSelectionBackground&&(s.push(`.monaco-list${o}:focus .monaco-list-row.selected { background-color: ${e.listActiveSelectionBackground}; }`),s.push(`.monaco-list${o}:focus .monaco-list-row.selected:hover { background-color: ${e.listActiveSelectionBackground}; }`)),e.listActiveSelectionForeground&&s.push(`.monaco-list${o}:focus .monaco-list-row.selected { color: ${e.listActiveSelectionForeground}; }`),e.listActiveSelectionIconForeground&&s.push(`.monaco-list${o}:focus .monaco-list-row.selected .codicon { color: ${e.listActiveSelectionIconForeground}; }`),e.listFocusAndSelectionBackground&&s.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${o}:focus .monaco-list-row.selected.focused { background-color: ${e.listFocusAndSelectionBackground}; }\n\t\t\t`),e.listFocusAndSelectionForeground&&s.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${o}:focus .monaco-list-row.selected.focused { color: ${e.listFocusAndSelectionForeground}; }\n\t\t\t`),e.listInactiveFocusForeground&&(s.push(`.monaco-list${o} .monaco-list-row.focused { color:  ${e.listInactiveFocusForeground}; }`),s.push(`.monaco-list${o} .monaco-list-row.focused:hover { color:  ${e.listInactiveFocusForeground}; }`)),e.listInactiveSelectionIconForeground&&s.push(`.monaco-list${o} .monaco-list-row.focused .codicon { color:  ${e.listInactiveSelectionIconForeground}; }`),e.listInactiveFocusBackground&&(s.push(`.monaco-list${o} .monaco-list-row.focused { background-color:  ${e.listInactiveFocusBackground}; }`),s.push(`.monaco-list${o} .monaco-list-row.focused:hover { background-color:  ${e.listInactiveFocusBackground}; }`)),e.listInactiveSelectionBackground&&(s.push(`.monaco-list${o} .monaco-list-row.selected { background-color:  ${e.listInactiveSelectionBackground}; }`),s.push(`.monaco-list${o} .monaco-list-row.selected:hover { background-color:  ${e.listInactiveSelectionBackground}; }`)),e.listInactiveSelectionForeground&&s.push(`.monaco-list${o} .monaco-list-row.selected { color: ${e.listInactiveSelectionForeground}; }`),e.listHoverBackground&&s.push(`.monaco-list${o}:not(.drop-target):not(.dragging) .monaco-list-row:hover:not(.selected):not(.focused) { background-color: ${e.listHoverBackground}; }`),e.listHoverForeground&&s.push(`.monaco-list${o}:not(.drop-target):not(.dragging) .monaco-list-row:hover:not(.selected):not(.focused) { color:  ${e.listHoverForeground}; }`);const r=(0,n.gI)(e.listFocusAndSelectionOutline,(0,n.gI)(e.listSelectionOutline,null!==(t=e.listFocusOutline)&&void 0!==t?t:""));r&&s.push(`.monaco-list${o}:focus .monaco-list-row.focused.selected { outline: 1px solid ${r}; outline-offset: -1px;}`),e.listFocusOutline&&s.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${o}:focus .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t\t.monaco-workbench.context-menu-visible .monaco-list${o}.last-focused .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t`);const a=(0,n.gI)(e.listSelectionOutline,null!==(i=e.listInactiveFocusOutline)&&void 0!==i?i:"");a&&s.push(`.monaco-list${o} .monaco-list-row.focused.selected { outline: 1px dotted ${a}; outline-offset: -1px; }`),e.listSelectionOutline&&s.push(`.monaco-list${o} .monaco-list-row.selected { outline: 1px dotted ${e.listSelectionOutline}; outline-offset: -1px; }`),e.listInactiveFocusOutline&&s.push(`.monaco-list${o} .monaco-list-row.focused { outline: 1px dotted ${e.listInactiveFocusOutline}; outline-offset: -1px; }`),e.listHoverOutline&&s.push(`.monaco-list${o} .monaco-list-row:hover { outline: 1px dashed ${e.listHoverOutline}; outline-offset: -1px; }`),e.listDropBackground&&s.push(`\n\t\t\t\t.monaco-list${o}.drop-target,\n\t\t\t\t.monaco-list${o} .monaco-list-rows.drop-target,\n\t\t\t\t.monaco-list${o} .monaco-list-row.drop-target { background-color: ${e.listDropBackground} !important; color: inherit !important; }\n\t\t\t`),e.tableColumnsBorder&&s.push(`\n\t\t\t\t.monaco-table > .monaco-split-view2,\n\t\t\t\t.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table:hover > .monaco-split-view2,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: ${e.tableColumnsBorder};\n\t\t\t\t}\n\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: transparent;\n\t\t\t\t}\n\t\t\t`),e.tableOddRowsBackgroundColor&&s.push(`\n\t\t\t\t.monaco-table .monaco-list-row[data-parity=odd]:not(.focused):not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(:focus) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(.focused) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr {\n\t\t\t\t\tbackground-color: ${e.tableOddRowsBackgroundColor};\n\t\t\t\t}\n\t\t\t`),this.styleElement.textContent=s.join("\n")}}const H={listFocusBackground:"#7FB0D0",listActiveSelectionBackground:"#0E639C",listActiveSelectionForeground:"#FFFFFF",listActiveSelectionIconForeground:"#FFFFFF",listFocusAndSelectionOutline:"#90C2F9",listFocusAndSelectionBackground:"#094771",listFocusAndSelectionForeground:"#FFFFFF",listInactiveSelectionBackground:"#3F3F46",listInactiveSelectionIconForeground:"#FFFFFF",listHoverBackground:"#2A2D2E",listDropBackground:"#383B3D",treeIndentGuidesStroke:"#a9a9a9",treeInactiveIndentGuidesStroke:d.Q1.fromHex("#a9a9a9").transparent(.4).toString(),tableColumnsBorder:d.Q1.fromHex("#cccccc").transparent(.2).toString(),tableOddRowsBackgroundColor:d.Q1.fromHex("#cccccc").transparent(.04).toString(),listBackground:void 0,listFocusForeground:void 0,listInactiveSelectionForeground:void 0,listInactiveFocusForeground:void 0,listInactiveFocusBackground:void 0,listHoverForeground:void 0,listFocusOutline:void 0,listInactiveFocusOutline:void 0,listSelectionOutline:void 0,listHoverOutline:void 0},W={keyboardSupport:!0,mouseSupport:!0,multipleSelectionSupport:!0,dnd:{getDragURI:()=>null,onDragStart(){},onDragOver:()=>!1,drop(){}}};function V(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){i.push(e[n]),n++,o++;continue}e[n]<t[o]?i.push(e[n++]):i.push(t[o++])}return i}const U=(e,t)=>e-t;class j{constructor(e,t){this._templateId=e,this.renderers=t}get templateId(){return this._templateId}renderTemplate(e){return this.renderers.map((t=>t.renderTemplate(e)))}renderElement(e,t,i,n){let o=0;for(const s of this.renderers)s.renderElement(e,t,i[o++],n)}disposeElement(e,t,i,n){var o;let s=0;for(const r of this.renderers)null===(o=r.disposeElement)||void 0===o||o.call(r,e,t,i[s],n),s+=1}disposeTemplate(e){let t=0;for(const i of this.renderers)i.disposeTemplate(e[t++])}}class G{constructor(e){this.accessibilityProvider=e,this.templateId="a18n"}renderTemplate(e){return e}renderElement(e,t,i){const n=this.accessibilityProvider.getAriaLabel(e);n?i.setAttribute("aria-label",n):i.removeAttribute("aria-label");const o=this.accessibilityProvider.getAriaLevel&&this.accessibilityProvider.getAriaLevel(e);"number"==typeof o?i.setAttribute("aria-level",`${o}`):i.removeAttribute("aria-level")}disposeTemplate(e){}}class K{constructor(e,t){this.list=e,this.dnd=t}getDragElements(e){const t=this.list.getSelectedElements();return t.indexOf(e)>-1?t:[e]}getDragURI(e){return this.dnd.getDragURI(e)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e,t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,e,t)}onDragOver(e,t,i,n){return this.dnd.onDragOver(e,t,i,n)}onDragLeave(e,t,i,n){var o,s;null===(s=(o=this.dnd).onDragLeave)||void 0===s||s.call(o,e,t,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}drop(e,t,i,n){this.dnd.drop(e,t,i,n)}}class Y{get onDidChangeFocus(){return g.Jh.map(this.eventBufferer.wrapEvent(this.focus.onChange),(e=>this.toListEvent(e)),this.disposables)}get onDidChangeSelection(){return g.Jh.map(this.eventBufferer.wrapEvent(this.selection.onChange),(e=>this.toListEvent(e)),this.disposables)}get domId(){return this.view.domId}get onMouseClick(){return this.view.onMouseClick}get onMouseDblClick(){return this.view.onMouseDblClick}get onMouseMiddleClick(){return this.view.onMouseMiddleClick}get onPointer(){return this.mouseController.onPointer}get onMouseDown(){return this.view.onMouseDown}get onMouseOver(){return this.view.onMouseOver}get onMouseOut(){return this.view.onMouseOut}get onTouchStart(){return this.view.onTouchStart}get onTap(){return this.view.onTap}get onContextMenu(){let e=!1;const t=this.disposables.add(g.Jh.chain(this.disposables.add(new o.f(this.view.domNode,"keydown")).event)).map((e=>new s.Z(e))).filter((t=>e=58===t.keyCode||t.shiftKey&&68===t.keyCode)).map((e=>n.fs.stop(e,!0))).filter((()=>!1)).event,i=this.disposables.add(g.Jh.chain(this.disposables.add(new o.f(this.view.domNode,"keyup")).event)).forEach((()=>e=!1)).map((e=>new s.Z(e))).filter((e=>58===e.keyCode||e.shiftKey&&68===e.keyCode)).map((e=>n.fs.stop(e,!0))).map((({browserEvent:e})=>{const t=this.getFocus(),i=t.length?t[0]:void 0;return{index:i,element:void 0!==i?this.view.element(i):void 0,anchor:void 0!==i?this.view.domElement(i):this.view.domNode,browserEvent:e}})).event,r=this.disposables.add(g.Jh.chain(this.view.onContextMenu)).filter((t=>!e)).map((({element:e,index:t,browserEvent:i})=>({element:e,index:t,anchor:{x:i.pageX+1,y:i.pageY},browserEvent:i}))).event;return g.Jh.any(t,i,r)}get onKeyDown(){return this.disposables.add(new o.f(this.view.domNode,"keydown")).event}get onDidFocus(){return g.Jh.signal(this.disposables.add(new o.f(this.view.domNode,"focus",!0)).event)}constructor(e,t,i,o,s=W){var r,a,h,c;this.user=e,this._options=s,this.focus=new E("focused"),this.anchor=new E("anchor"),this.eventBufferer=new g.at,this._ariaLabel="",this.disposables=new p.Cm,this._onDidDispose=new g.vl,this.onDidDispose=this._onDidDispose.event;const d=this._options.accessibilityProvider&&this._options.accessibilityProvider.getWidgetRole?null===(r=this._options.accessibilityProvider)||void 0===r?void 0:r.getWidgetRole():"list";this.selection=new D("listbox"!==d);const u=[this.focus.renderer,this.selection.renderer];this.accessibilityProvider=s.accessibilityProvider,this.accessibilityProvider&&(u.push(new G(this.accessibilityProvider)),null===(h=(a=this.accessibilityProvider).onDidChangeActiveDescendant)||void 0===h||h.call(a,this.onDidChangeActiveDescendant,this,this.disposables)),o=o.map((e=>new j(e.templateId,[...u,e])));const m=Object.assign(Object.assign({},s),{dnd:s.dnd&&new K(this,s.dnd)});if(this.view=this.createListView(t,i,o,m),this.view.domNode.setAttribute("role",d),s.styleController)this.styleController=s.styleController(this.view.domId);else{const e=(0,n.li)(this.view.domNode);this.styleController=new Q(e,this.view.domId)}if(this.spliceable=new l([new x(this.focus,this.view,s.identityProvider),new x(this.selection,this.view,s.identityProvider),new x(this.anchor,this.view,s.identityProvider),this.view]),this.disposables.add(this.focus),this.disposables.add(this.selection),this.disposables.add(this.anchor),this.disposables.add(this.view),this.disposables.add(this._onDidDispose),this.disposables.add(new F(this,this.view)),("boolean"!=typeof s.keyboardSupport||s.keyboardSupport)&&(this.keyboardController=new B(this,this.view,s),this.disposables.add(this.keyboardController)),s.keyboardNavigationLabelProvider){const e=s.keyboardNavigationDelegate||N;this.typeNavigationController=new T(this,this.view,s.keyboardNavigationLabelProvider,null!==(c=s.keyboardNavigationEventFilter)&&void 0!==c?c:()=>!0,e),this.disposables.add(this.typeNavigationController)}this.mouseController=this.createMouseController(s),this.disposables.add(this.mouseController),this.onDidChangeFocus(this._onFocusChange,this,this.disposables),this.onDidChangeSelection(this._onSelectionChange,this,this.disposables),this.accessibilityProvider&&(this.ariaLabel=this.accessibilityProvider.getWidgetAriaLabel()),!1!==this._options.multipleSelectionSupport&&this.view.domNode.setAttribute("aria-multiselectable","true")}createListView(e,t,i,n){return new C.uO(e,t,i,n)}createMouseController(e){return new z(this)}updateOptions(e={}){var t,i;this._options=Object.assign(Object.assign({},this._options),e),null===(t=this.typeNavigationController)||void 0===t||t.updateOptions(this._options),void 0!==this._options.multipleSelectionController&&(this._options.multipleSelectionSupport?this.view.domNode.setAttribute("aria-multiselectable","true"):this.view.domNode.removeAttribute("aria-multiselectable")),this.mouseController.updateOptions(e),null===(i=this.keyboardController)||void 0===i||i.updateOptions(e),this.view.updateOptions(e)}get options(){return this._options}splice(e,t,i=[]){if(e<0||e>this.view.length)throw new w(this.user,`Invalid start index: ${e}`);if(t<0)throw new w(this.user,`Invalid delete count: ${t}`);0===t&&0===i.length||this.eventBufferer.bufferEvents((()=>this.spliceable.splice(e,t,i)))}rerender(){this.view.rerender()}element(e){return this.view.element(e)}get length(){return this.view.length}get contentHeight(){return this.view.contentHeight}get scrollTop(){return this.view.getScrollTop()}set scrollTop(e){this.view.setScrollTop(e)}get scrollHeight(){return this.view.scrollHeight}get firstVisibleIndex(){return this.view.firstVisibleIndex}get ariaLabel(){return this._ariaLabel}set ariaLabel(e){this._ariaLabel=e,this.view.domNode.setAttribute("aria-label",e)}domFocus(){this.view.domNode.focus({preventScroll:!0})}layout(e,t){this.view.layout(e,t)}setSelection(e,t){for(const t of e)if(t<0||t>=this.length)throw new w(this.user,`Invalid index ${t}`);this.selection.set(e,t)}getSelection(){return this.selection.get()}getSelectedElements(){return this.getSelection().map((e=>this.view.element(e)))}setAnchor(e){if(void 0!==e){if(e<0||e>=this.length)throw new w(this.user,`Invalid index ${e}`);this.anchor.set([e])}else this.anchor.set([])}getAnchor(){return(0,h.Fy)(this.anchor.get(),void 0)}getAnchorElement(){const e=this.getAnchor();return void 0===e?void 0:this.element(e)}setFocus(e,t){for(const t of e)if(t<0||t>=this.length)throw new w(this.user,`Invalid index ${t}`);this.focus.set(e,t)}focusNext(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),s=this.findNextIndex(o.length>0?o[0]+e:0,t,n);s>-1&&this.setFocus([s],i)}focusPrevious(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),s=this.findPreviousIndex(o.length>0?o[0]-e:0,t,n);s>-1&&this.setFocus([s],i)}focusNextPage(e,t){return S(this,void 0,void 0,(function*(){let i=this.view.indexAt(this.view.getScrollTop()+this.view.renderHeight);i=0===i?0:i-1;const n=this.getFocus()[0];if(n!==i&&(void 0===n||i>n)){const o=this.findPreviousIndex(i,!1,t);o>-1&&n!==o?this.setFocus([o],e):this.setFocus([i],e)}else{const o=this.view.getScrollTop();let s=o+this.view.renderHeight;i>n&&(s-=this.view.elementHeight(i)),this.view.setScrollTop(s),this.view.getScrollTop()!==o&&(this.setFocus([]),yield(0,c.wR)(0),yield this.focusNextPage(e,t))}}))}focusPreviousPage(e,t){return S(this,void 0,void 0,(function*(){let i;const n=this.view.getScrollTop();i=0===n?this.view.indexAt(n):this.view.indexAfter(n-1);const o=this.getFocus()[0];if(o!==i&&(void 0===o||o>=i)){const n=this.findNextIndex(i,!1,t);n>-1&&o!==n?this.setFocus([n],e):this.setFocus([i],e)}else{const i=n;this.view.setScrollTop(n-this.view.renderHeight),this.view.getScrollTop()!==i&&(this.setFocus([]),yield(0,c.wR)(0),yield this.focusPreviousPage(e,t))}}))}focusLast(e,t){if(0===this.length)return;const i=this.findPreviousIndex(this.length-1,!1,t);i>-1&&this.setFocus([i],e)}focusFirst(e,t){this.focusNth(0,e,t)}focusNth(e,t,i){if(0===this.length)return;const n=this.findNextIndex(e,!1,i);n>-1&&this.setFocus([n],t)}findNextIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e>=this.length&&!t)return-1;if(e%=this.length,!i||i(this.element(e)))return e;e++}return-1}findPreviousIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e<0&&!t)return-1;if(e=(this.length+e%this.length)%this.length,!i||i(this.element(e)))return e;e--}return-1}getFocus(){return this.focus.get()}getFocusedElements(){return this.getFocus().map((e=>this.view.element(e)))}reveal(e,t){if(e<0||e>=this.length)throw new w(this.user,`Invalid index ${e}`);const i=this.view.getScrollTop(),n=this.view.elementTop(e),o=this.view.elementHeight(e);if((0,_.Et)(t)){const e=o-this.view.renderHeight;this.view.setScrollTop(e*(0,f.qE)(t,0,1)+n)}else{const e=n+o,t=i+this.view.renderHeight;n<i&&e>=t||(n<i||e>=t&&o>=this.view.renderHeight?this.view.setScrollTop(n):e>=t&&this.view.setScrollTop(e-this.view.renderHeight))}}getHTMLElement(){return this.view.domNode}getElementID(e){return this.view.getElementDomId(e)}style(e){this.styleController.style(e)}toListEvent({indexes:e,browserEvent:t}){return{indexes:e,elements:e.map((e=>this.view.element(e))),browserEvent:t}}_onFocusChange(){const e=this.focus.get();this.view.domNode.classList.toggle("element-focused",e.length>0),this.onDidChangeActiveDescendant()}onDidChangeActiveDescendant(){var e;const t=this.focus.get();if(t.length>0){let i;(null===(e=this.accessibilityProvider)||void 0===e?void 0:e.getActiveDescendantId)&&(i=this.accessibilityProvider.getActiveDescendantId(this.view.element(t[0]))),this.view.domNode.setAttribute("aria-activedescendant",i||this.view.getElementDomId(t[0]))}else this.view.domNode.removeAttribute("aria-activedescendant")}_onSelectionChange(){const e=this.selection.get();this.view.domNode.classList.toggle("selection-none",0===e.length),this.view.domNode.classList.toggle("selection-single",1===e.length),this.view.domNode.classList.toggle("selection-multiple",e.length>1)}dispose(){this._onDidDispose.fire(),this.disposables.dispose(),this._onDidDispose.dispose()}}y([u.B],Y.prototype,"onDidChangeFocus",null),y([u.B],Y.prototype,"onDidChangeSelection",null),y([u.B],Y.prototype,"onContextMenu",null),y([u.B],Y.prototype,"onKeyDown",null),y([u.B],Y.prototype,"onDidFocus",null)},4841:(e,t,i)=>{i.d(t,{S:()=>r});var n=i(3925),o=i.n(n),s=i(5159);o()(s.A,{insert:"head",singleton:!1}),s.A.locals;const r="monaco-mouse-cursor-text"},472:(e,t,i)=>{i.d(t,{B:()=>m,m:()=>C});var n=i(8479),o=i(9923),s=i(9408),r=i(5404),a=i(8844),l=i(3884),h=i(8300),c=i(4541),d=i(3925),u=i.n(d),g=i(55);u()(g.A,{insert:"head",singleton:!1}),g.A.locals;var m,p=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r};!function(e){e.North="north",e.South="south",e.East="east",e.West="west"}(m||(m={}));const f=new l.vl,A=new l.vl;class _{constructor(){this.disposables=new h.Cm}get onPointerMove(){return this.disposables.add(new o.f(window,"mousemove")).event}get onPointerUp(){return this.disposables.add(new o.f(window,"mouseup")).event}dispose(){this.disposables.dispose()}}p([a.B],_.prototype,"onPointerMove",null),p([a.B],_.prototype,"onPointerUp",null);class w{get onPointerMove(){return this.disposables.add(new o.f(this.el,s.B.Change)).event}get onPointerUp(){return this.disposables.add(new o.f(this.el,s.B.End)).event}constructor(e){this.el=e,this.disposables=new h.Cm}dispose(){this.disposables.dispose()}}p([a.B],w.prototype,"onPointerMove",null),p([a.B],w.prototype,"onPointerUp",null);class b{get onPointerMove(){return this.factory.onPointerMove}get onPointerUp(){return this.factory.onPointerUp}constructor(e){this.factory=e}dispose(){}}p([a.B],b.prototype,"onPointerMove",null),p([a.B],b.prototype,"onPointerUp",null);const v="pointer-events-disabled";class C extends h.jG{get state(){return this._state}get orthogonalStartSash(){return this._orthogonalStartSash}get orthogonalEndSash(){return this._orthogonalEndSash}set state(e){this._state!==e&&(this.el.classList.toggle("disabled",0===e),this.el.classList.toggle("minimum",1===e),this.el.classList.toggle("maximum",2===e),this._state=e,this.onDidEnablementChange.fire(e))}set orthogonalStartSash(e){if(this.orthogonalStartDragHandleDisposables.clear(),this.orthogonalStartSashDisposables.clear(),e){const t=t=>{this.orthogonalStartDragHandleDisposables.clear(),0!==t&&(this._orthogonalStartDragHandle=(0,n.BC)(this.el,(0,n.$)(".orthogonal-drag-handle.start")),this.orthogonalStartDragHandleDisposables.add((0,h.s)((()=>this._orthogonalStartDragHandle.remove()))),this.orthogonalStartDragHandleDisposables.add(new o.f(this._orthogonalStartDragHandle,"mouseenter")).event((()=>C.onMouseEnter(e)),void 0,this.orthogonalStartDragHandleDisposables),this.orthogonalStartDragHandleDisposables.add(new o.f(this._orthogonalStartDragHandle,"mouseleave")).event((()=>C.onMouseLeave(e)),void 0,this.orthogonalStartDragHandleDisposables))};this.orthogonalStartSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalStartSash=e}set orthogonalEndSash(e){if(this.orthogonalEndDragHandleDisposables.clear(),this.orthogonalEndSashDisposables.clear(),e){const t=t=>{this.orthogonalEndDragHandleDisposables.clear(),0!==t&&(this._orthogonalEndDragHandle=(0,n.BC)(this.el,(0,n.$)(".orthogonal-drag-handle.end")),this.orthogonalEndDragHandleDisposables.add((0,h.s)((()=>this._orthogonalEndDragHandle.remove()))),this.orthogonalEndDragHandleDisposables.add(new o.f(this._orthogonalEndDragHandle,"mouseenter")).event((()=>C.onMouseEnter(e)),void 0,this.orthogonalEndDragHandleDisposables),this.orthogonalEndDragHandleDisposables.add(new o.f(this._orthogonalEndDragHandle,"mouseleave")).event((()=>C.onMouseLeave(e)),void 0,this.orthogonalEndDragHandleDisposables))};this.orthogonalEndSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalEndSash=e}constructor(e,t,i){super(),this.hoverDelay=300,this.hoverDelayer=this._register(new r.ve(this.hoverDelay)),this._state=3,this.onDidEnablementChange=this._register(new l.vl),this._onDidStart=this._register(new l.vl),this._onDidChange=this._register(new l.vl),this._onDidReset=this._register(new l.vl),this._onDidEnd=this._register(new l.vl),this.orthogonalStartSashDisposables=this._register(new h.Cm),this.orthogonalStartDragHandleDisposables=this._register(new h.Cm),this.orthogonalEndSashDisposables=this._register(new h.Cm),this.orthogonalEndDragHandleDisposables=this._register(new h.Cm),this.onDidStart=this._onDidStart.event,this.onDidChange=this._onDidChange.event,this.onDidReset=this._onDidReset.event,this.onDidEnd=this._onDidEnd.event,this.linkedSash=void 0,this.el=(0,n.BC)(e,(0,n.$)(".monaco-sash")),i.orthogonalEdge&&this.el.classList.add(`orthogonal-edge-${i.orthogonalEdge}`),c.zx&&this.el.classList.add("mac");const a=this._register(new o.f(this.el,"mousedown")).event;this._register(a((e=>this.onPointerStart(e,new _)),this));const d=this._register(new o.f(this.el,"dblclick")).event;this._register(d(this.onPointerDoublePress,this));const u=this._register(new o.f(this.el,"mouseenter")).event;this._register(u((()=>C.onMouseEnter(this))));const g=this._register(new o.f(this.el,"mouseleave")).event;this._register(g((()=>C.onMouseLeave(this)))),this._register(s.q.addTarget(this.el));const m=this._register(new o.f(this.el,s.B.Start)).event;this._register(m((e=>this.onPointerStart(e,new w(this.el))),this));const p=this._register(new o.f(this.el,s.B.Tap)).event;let b;this._register(p((e=>{if(b)return clearTimeout(b),b=void 0,void this.onPointerDoublePress(e);clearTimeout(b),b=setTimeout((()=>b=void 0),250)}),this)),"number"==typeof i.size?(this.size=i.size,0===i.orientation?this.el.style.width=`${this.size}px`:this.el.style.height=`${this.size}px`):(this.size=4,this._register(f.event((e=>{this.size=e,this.layout()})))),this._register(A.event((e=>this.hoverDelay=e))),this.layoutProvider=t,this.orthogonalStartSash=i.orthogonalStartSash,this.orthogonalEndSash=i.orthogonalEndSash,this.orientation=i.orientation||0,1===this.orientation?(this.el.classList.add("horizontal"),this.el.classList.remove("vertical")):(this.el.classList.remove("horizontal"),this.el.classList.add("vertical")),this.el.classList.toggle("debug",!1),this.layout()}onPointerStart(e,t){n.fs.stop(e);let i=!1;if(!e.__orthogonalSashEvent){const n=this.getOrthogonalSash(e);n&&(i=!0,e.__orthogonalSashEvent=!0,n.onPointerStart(e,new b(t)))}if(this.linkedSash&&!e.__linkedSashEvent&&(e.__linkedSashEvent=!0,this.linkedSash.onPointerStart(e,new b(t))),!this.state)return;const o=document.getElementsByTagName("iframe");for(const e of o)e.classList.add(v);const s=e.pageX,r=e.pageY,a=e.altKey,l={startX:s,currentX:s,startY:r,currentY:r,altKey:a};this.el.classList.add("active"),this._onDidStart.fire(l);const d=(0,n.li)(this.el),u=()=>{let e="";e=i?"all-scroll":1===this.orientation?1===this.state?"s-resize":2===this.state?"n-resize":c.zx?"row-resize":"ns-resize":1===this.state?"e-resize":2===this.state?"w-resize":c.zx?"col-resize":"ew-resize",d.textContent=`* { cursor: ${e} !important; }`},g=new h.Cm;u(),i||this.onDidEnablementChange.event(u,null,g),t.onPointerMove((e=>{n.fs.stop(e,!1);const t={startX:s,currentX:e.pageX,startY:r,currentY:e.pageY,altKey:a};this._onDidChange.fire(t)}),null,g),t.onPointerUp((e=>{n.fs.stop(e,!1),this.el.removeChild(d),this.el.classList.remove("active"),this._onDidEnd.fire(),g.dispose();for(const e of o)e.classList.remove(v)}),null,g),g.add(t)}onPointerDoublePress(e){const t=this.getOrthogonalSash(e);t&&t._onDidReset.fire(),this.linkedSash&&this.linkedSash._onDidReset.fire(),this._onDidReset.fire()}static onMouseEnter(e,t=!1){e.el.classList.contains("active")?(e.hoverDelayer.cancel(),e.el.classList.add("hover")):e.hoverDelayer.trigger((()=>e.el.classList.add("hover")),e.hoverDelay).then(void 0,(()=>{})),!t&&e.linkedSash&&C.onMouseEnter(e.linkedSash,!0)}static onMouseLeave(e,t=!1){e.hoverDelayer.cancel(),e.el.classList.remove("hover"),!t&&e.linkedSash&&C.onMouseLeave(e.linkedSash,!0)}clearSashHoverState(){C.onMouseLeave(this)}layout(){if(0===this.orientation){const e=this.layoutProvider;this.el.style.left=e.getVerticalSashLeft(this)-this.size/2+"px",e.getVerticalSashTop&&(this.el.style.top=e.getVerticalSashTop(this)+"px"),e.getVerticalSashHeight&&(this.el.style.height=e.getVerticalSashHeight(this)+"px")}else{const e=this.layoutProvider;this.el.style.top=e.getHorizontalSashTop(this)-this.size/2+"px",e.getHorizontalSashLeft&&(this.el.style.left=e.getHorizontalSashLeft(this)+"px"),e.getHorizontalSashWidth&&(this.el.style.width=e.getHorizontalSashWidth(this)+"px")}}getOrthogonalSash(e){var t;const i=null!==(t=e.initialTarget)&&void 0!==t?t:e.target;if(i&&i instanceof HTMLElement)return i.classList.contains("orthogonal-drag-handle")?i.classList.contains("start")?this.orthogonalStartSash:this.orthogonalEndSash:void 0}dispose(){super.dispose(),this.el.remove()}}},5443:(e,t,i)=>{i.d(t,{MU:()=>M,QC:()=>E,Se:()=>x,oO:()=>L});var n=i(2003),o=i(8479),s=i(7693),r=i(9121),a=i(6322),l=i(2776),h=i(5404),c=i(3483);class d extends l.x{constructor(e){super(),this._onActivate=e.onActivate,this.bgDomNode=document.createElement("div"),this.bgDomNode.className="arrow-background",this.bgDomNode.style.position="absolute",this.bgDomNode.style.width=e.bgWidth+"px",this.bgDomNode.style.height=e.bgHeight+"px",void 0!==e.top&&(this.bgDomNode.style.top="0px"),void 0!==e.left&&(this.bgDomNode.style.left="0px"),void 0!==e.bottom&&(this.bgDomNode.style.bottom="0px"),void 0!==e.right&&(this.bgDomNode.style.right="0px"),this.domNode=document.createElement("div"),this.domNode.className=e.className,this.domNode.classList.add(...c.L.asClassNameArray(e.icon)),this.domNode.style.position="absolute",this.domNode.style.width="11px",this.domNode.style.height="11px",void 0!==e.top&&(this.domNode.style.top=e.top+"px"),void 0!==e.left&&(this.domNode.style.left=e.left+"px"),void 0!==e.bottom&&(this.domNode.style.bottom=e.bottom+"px"),void 0!==e.right&&(this.domNode.style.right=e.right+"px"),this._pointerMoveMonitor=this._register(new a._),this._register(o.b2(this.bgDomNode,o.Bx.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._register(o.b2(this.domNode,o.Bx.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._pointerdownRepeatTimer=this._register(new h.vb),this._pointerdownScheduleRepeatTimer=this._register(new h.pc)}_arrowPointerDown(e){e.target&&e.target instanceof Element&&(this._onActivate(),this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancelAndSet((()=>{this._pointerdownRepeatTimer.cancelAndSet((()=>this._onActivate()),1e3/24)}),200),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{}),(()=>{this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancel()})),e.preventDefault())}}var u=i(8300);class g extends u.jG{constructor(e,t,i){super(),this._visibility=e,this._visibleClassName=t,this._invisibleClassName=i,this._domNode=null,this._isVisible=!1,this._isNeeded=!1,this._rawShouldBeVisible=!1,this._shouldBeVisible=!1,this._revealTimer=this._register(new h.pc)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this._updateShouldBeVisible())}setShouldBeVisible(e){this._rawShouldBeVisible=e,this._updateShouldBeVisible()}_applyVisibilitySetting(){return 2!==this._visibility&&(3===this._visibility||this._rawShouldBeVisible)}_updateShouldBeVisible(){const e=this._applyVisibilitySetting();this._shouldBeVisible!==e&&(this._shouldBeVisible=e,this.ensureVisibility())}setIsNeeded(e){this._isNeeded!==e&&(this._isNeeded=e,this.ensureVisibility())}setDomNode(e){this._domNode=e,this._domNode.setClassName(this._invisibleClassName),this.setShouldBeVisible(!1)}ensureVisibility(){this._isNeeded?this._shouldBeVisible?this._reveal():this._hide(!0):this._hide(!1)}_reveal(){this._isVisible||(this._isVisible=!0,this._revealTimer.setIfNotSet((()=>{var e;null===(e=this._domNode)||void 0===e||e.setClassName(this._visibleClassName)}),0))}_hide(e){var t;this._revealTimer.cancel(),this._isVisible&&(this._isVisible=!1,null===(t=this._domNode)||void 0===t||t.setClassName(this._invisibleClassName+(e?" fade":"")))}}var m=i(4541);class p extends l.x{constructor(e){super(),this._lazyRender=e.lazyRender,this._host=e.host,this._scrollable=e.scrollable,this._scrollByPage=e.scrollByPage,this._scrollbarState=e.scrollbarState,this._visibilityController=this._register(new g(e.visibility,"visible scrollbar "+e.extraScrollbarClassName,"invisible scrollbar "+e.extraScrollbarClassName)),this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._pointerMoveMonitor=this._register(new a._),this._shouldRender=!0,this.domNode=(0,s.Z)(document.createElement("div")),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this._visibilityController.setDomNode(this.domNode),this.domNode.setPosition("absolute"),this._register(o.ko(this.domNode.domNode,o.Bx.POINTER_DOWN,(e=>this._domNodePointerDown(e))))}_createArrow(e){const t=this._register(new d(e));this.domNode.domNode.appendChild(t.bgDomNode),this.domNode.domNode.appendChild(t.domNode)}_createSlider(e,t,i,n){this.slider=(0,s.Z)(document.createElement("div")),this.slider.setClassName("slider"),this.slider.setPosition("absolute"),this.slider.setTop(e),this.slider.setLeft(t),"number"==typeof i&&this.slider.setWidth(i),"number"==typeof n&&this.slider.setHeight(n),this.slider.setLayerHinting(!0),this.slider.setContain("strict"),this.domNode.domNode.appendChild(this.slider.domNode),this._register(o.ko(this.slider.domNode,o.Bx.POINTER_DOWN,(e=>{0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}))),this.onclick(this.slider.domNode,(e=>{e.leftButton&&e.stopPropagation()}))}_onElementSize(e){return this._scrollbarState.setVisibleSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollSize(e){return this._scrollbarState.setScrollSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollPosition(e){return this._scrollbarState.setScrollPosition(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}beginReveal(){this._visibilityController.setShouldBeVisible(!0)}beginHide(){this._visibilityController.setShouldBeVisible(!1)}render(){this._shouldRender&&(this._shouldRender=!1,this._renderDomNode(this._scrollbarState.getRectangleLargeSize(),this._scrollbarState.getRectangleSmallSize()),this._updateSlider(this._scrollbarState.getSliderSize(),this._scrollbarState.getArrowSize()+this._scrollbarState.getSliderPosition()))}_domNodePointerDown(e){e.target===this.domNode.domNode&&this._onPointerDown(e)}delegatePointerDown(e){const t=this.domNode.domNode.getClientRects()[0].top,i=t+this._scrollbarState.getSliderPosition(),n=t+this._scrollbarState.getSliderPosition()+this._scrollbarState.getSliderSize(),o=this._sliderPointerPosition(e);i<=o&&o<=n?0===e.button&&(e.preventDefault(),this._sliderPointerDown(e)):this._onPointerDown(e)}_onPointerDown(e){let t,i;if(e.target===this.domNode.domNode&&"number"==typeof e.offsetX&&"number"==typeof e.offsetY)t=e.offsetX,i=e.offsetY;else{const n=o.BK(this.domNode.domNode);t=e.pageX-n.left,i=e.pageY-n.top}const n=this._pointerDownRelativePosition(t,i);this._setDesiredScrollPositionNow(this._scrollByPage?this._scrollbarState.getDesiredScrollPositionFromOffsetPaged(n):this._scrollbarState.getDesiredScrollPositionFromOffset(n)),0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}_sliderPointerDown(e){if(!(e.target&&e.target instanceof Element))return;const t=this._sliderPointerPosition(e),i=this._sliderOrthogonalPointerPosition(e),n=this._scrollbarState.clone();this.slider.toggleClassName("active",!0),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{const o=this._sliderOrthogonalPointerPosition(e),s=Math.abs(o-i);if(m.uF&&s>140)return void this._setDesiredScrollPositionNow(n.getScrollPosition());const r=this._sliderPointerPosition(e)-t;this._setDesiredScrollPositionNow(n.getDesiredScrollPositionFromDelta(r))}),(()=>{this.slider.toggleClassName("active",!1),this._host.onDragEnd()})),this._host.onDragStart()}_setDesiredScrollPositionNow(e){const t={};this.writeScrollPosition(t,e),this._scrollable.setScrollPositionNow(t)}updateScrollbarSize(e){this._updateScrollbarSize(e),this._scrollbarState.setScrollbarSize(e),this._shouldRender=!0,this._lazyRender||this.render()}isNeeded(){return this._scrollbarState.isNeeded()}}class f{constructor(e,t,i,n,o,s){this._scrollbarSize=Math.round(t),this._oppositeScrollbarSize=Math.round(i),this._arrowSize=Math.round(e),this._visibleSize=n,this._scrollSize=o,this._scrollPosition=s,this._computedAvailableSize=0,this._computedIsNeeded=!1,this._computedSliderSize=0,this._computedSliderRatio=0,this._computedSliderPosition=0,this._refreshComputedValues()}clone(){return new f(this._arrowSize,this._scrollbarSize,this._oppositeScrollbarSize,this._visibleSize,this._scrollSize,this._scrollPosition)}setVisibleSize(e){const t=Math.round(e);return this._visibleSize!==t&&(this._visibleSize=t,this._refreshComputedValues(),!0)}setScrollSize(e){const t=Math.round(e);return this._scrollSize!==t&&(this._scrollSize=t,this._refreshComputedValues(),!0)}setScrollPosition(e){const t=Math.round(e);return this._scrollPosition!==t&&(this._scrollPosition=t,this._refreshComputedValues(),!0)}setScrollbarSize(e){this._scrollbarSize=Math.round(e)}setOppositeScrollbarSize(e){this._oppositeScrollbarSize=Math.round(e)}static _computeValues(e,t,i,n,o){const s=Math.max(0,i-e),r=Math.max(0,s-2*t),a=n>0&&n>i;if(!a)return{computedAvailableSize:Math.round(s),computedIsNeeded:a,computedSliderSize:Math.round(r),computedSliderRatio:0,computedSliderPosition:0};const l=Math.round(Math.max(20,Math.floor(i*r/n))),h=(r-l)/(n-i),c=o*h;return{computedAvailableSize:Math.round(s),computedIsNeeded:a,computedSliderSize:Math.round(l),computedSliderRatio:h,computedSliderPosition:Math.round(c)}}_refreshComputedValues(){const e=f._computeValues(this._oppositeScrollbarSize,this._arrowSize,this._visibleSize,this._scrollSize,this._scrollPosition);this._computedAvailableSize=e.computedAvailableSize,this._computedIsNeeded=e.computedIsNeeded,this._computedSliderSize=e.computedSliderSize,this._computedSliderRatio=e.computedSliderRatio,this._computedSliderPosition=e.computedSliderPosition}getArrowSize(){return this._arrowSize}getScrollPosition(){return this._scrollPosition}getRectangleLargeSize(){return this._computedAvailableSize}getRectangleSmallSize(){return this._scrollbarSize}isNeeded(){return this._computedIsNeeded}getSliderSize(){return this._computedSliderSize}getSliderPosition(){return this._computedSliderPosition}getDesiredScrollPositionFromOffset(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize-this._computedSliderSize/2;return Math.round(t/this._computedSliderRatio)}getDesiredScrollPositionFromOffsetPaged(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize;let i=this._scrollPosition;return t<this._computedSliderPosition?i-=this._visibleSize:i+=this._visibleSize,i}getDesiredScrollPositionFromDelta(e){if(!this._computedIsNeeded)return 0;const t=this._computedSliderPosition+e;return Math.round(t/this._computedSliderRatio)}}var A=i(8694);class _ extends p{constructor(e,t,i){const n=e.getScrollDimensions(),o=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new f(t.horizontalHasArrows?t.arrowSize:0,2===t.horizontal?0:t.horizontalScrollbarSize,2===t.vertical?0:t.verticalScrollbarSize,n.width,n.scrollWidth,o.scrollLeft),visibility:t.horizontal,extraScrollbarClassName:"horizontal",scrollable:e,scrollByPage:t.scrollByPage}),t.horizontalHasArrows){const e=(t.arrowSize-11)/2,i=(t.horizontalScrollbarSize-11)/2;this._createArrow({className:"scra",icon:A.W.scrollbarButtonLeft,top:i,left:e,bottom:void 0,right:void 0,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new r.$(null,1,0))}),this._createArrow({className:"scra",icon:A.W.scrollbarButtonRight,top:i,left:void 0,bottom:void 0,right:e,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new r.$(null,-1,0))})}this._createSlider(Math.floor((t.horizontalScrollbarSize-t.horizontalSliderSize)/2),0,void 0,t.horizontalSliderSize)}_updateSlider(e,t){this.slider.setWidth(e),this.slider.setLeft(t)}_renderDomNode(e,t){this.domNode.setWidth(e),this.domNode.setHeight(t),this.domNode.setLeft(0),this.domNode.setBottom(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollWidth)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollLeft)||this._shouldRender,this._shouldRender=this._onElementSize(e.width)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return e}_sliderPointerPosition(e){return e.pageX}_sliderOrthogonalPointerPosition(e){return e.pageY}_updateScrollbarSize(e){this.slider.setHeight(e)}writeScrollPosition(e,t){e.scrollLeft=t}updateOptions(e){this.updateScrollbarSize(2===e.horizontal?0:e.horizontalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._visibilityController.setVisibility(e.horizontal),this._scrollByPage=e.scrollByPage}}class w extends p{constructor(e,t,i){const n=e.getScrollDimensions(),o=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new f(t.verticalHasArrows?t.arrowSize:0,2===t.vertical?0:t.verticalScrollbarSize,0,n.height,n.scrollHeight,o.scrollTop),visibility:t.vertical,extraScrollbarClassName:"vertical",scrollable:e,scrollByPage:t.scrollByPage}),t.verticalHasArrows){const e=(t.arrowSize-11)/2,i=(t.verticalScrollbarSize-11)/2;this._createArrow({className:"scra",icon:A.W.scrollbarButtonUp,top:e,left:i,bottom:void 0,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new r.$(null,0,1))}),this._createArrow({className:"scra",icon:A.W.scrollbarButtonDown,top:void 0,left:i,bottom:e,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new r.$(null,0,-1))})}this._createSlider(0,Math.floor((t.verticalScrollbarSize-t.verticalSliderSize)/2),t.verticalSliderSize,void 0)}_updateSlider(e,t){this.slider.setHeight(e),this.slider.setTop(t)}_renderDomNode(e,t){this.domNode.setWidth(t),this.domNode.setHeight(e),this.domNode.setRight(0),this.domNode.setTop(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollHeight)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollTop)||this._shouldRender,this._shouldRender=this._onElementSize(e.height)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return t}_sliderPointerPosition(e){return e.pageY}_sliderOrthogonalPointerPosition(e){return e.pageX}_updateScrollbarSize(e){this.slider.setWidth(e)}writeScrollPosition(e,t){e.scrollTop=t}updateOptions(e){this.updateScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(0),this._visibilityController.setVisibility(e.vertical),this._scrollByPage=e.scrollByPage}}var b=i(3884),v=i(1955),C=i(3925),y=i.n(C),S=i(3487);y()(S.A,{insert:"head",singleton:!1}),S.A.locals;class k{constructor(e,t,i){this.timestamp=e,this.deltaX=t,this.deltaY=i,this.score=0}}class E{constructor(){this._capacity=5,this._memory=[],this._front=-1,this._rear=-1}isPhysicalMouseWheel(){if(-1===this._front&&-1===this._rear)return!1;let e=1,t=0,i=1,n=this._rear;for(;;){const o=n===this._front?e:Math.pow(2,-i);if(e-=o,t+=this._memory[n].score*o,n===this._front)break;n=(this._capacity+n-1)%this._capacity,i++}return t<=.5}acceptStandardWheelEvent(e){const t=window.devicePixelRatio/(0,n.getZoomFactor)();m.uF||m.j9?this.accept(Date.now(),e.deltaX/t,e.deltaY/t):this.accept(Date.now(),e.deltaX,e.deltaY)}accept(e,t,i){const n=new k(e,t,i);n.score=this._computeScore(n),-1===this._front&&-1===this._rear?(this._memory[0]=n,this._front=0,this._rear=0):(this._rear=(this._rear+1)%this._capacity,this._rear===this._front&&(this._front=(this._front+1)%this._capacity),this._memory[this._rear]=n)}_computeScore(e){if(Math.abs(e.deltaX)>0&&Math.abs(e.deltaY)>0)return 1;let t=.5;return-1===this._front&&-1===this._rear||this._memory[this._rear],this._isAlmostInt(e.deltaX)&&this._isAlmostInt(e.deltaY)||(t+=.25),Math.min(Math.max(t,0),1)}_isAlmostInt(e){return Math.abs(Math.round(e)-e)<.01}}E.INSTANCE=new E;class D extends l.x{get options(){return this._options}constructor(e,t,i){super(),this._onScroll=this._register(new b.vl),this.onScroll=this._onScroll.event,this._onWillScroll=this._register(new b.vl),e.style.overflow="hidden",this._options=function(e){const t={lazyRender:void 0!==e.lazyRender&&e.lazyRender,className:void 0!==e.className?e.className:"",useShadows:void 0===e.useShadows||e.useShadows,handleMouseWheel:void 0===e.handleMouseWheel||e.handleMouseWheel,flipAxes:void 0!==e.flipAxes&&e.flipAxes,consumeMouseWheelIfScrollbarIsNeeded:void 0!==e.consumeMouseWheelIfScrollbarIsNeeded&&e.consumeMouseWheelIfScrollbarIsNeeded,alwaysConsumeMouseWheel:void 0!==e.alwaysConsumeMouseWheel&&e.alwaysConsumeMouseWheel,scrollYToX:void 0!==e.scrollYToX&&e.scrollYToX,mouseWheelScrollSensitivity:void 0!==e.mouseWheelScrollSensitivity?e.mouseWheelScrollSensitivity:1,fastScrollSensitivity:void 0!==e.fastScrollSensitivity?e.fastScrollSensitivity:5,scrollPredominantAxis:void 0===e.scrollPredominantAxis||e.scrollPredominantAxis,mouseWheelSmoothScroll:void 0===e.mouseWheelSmoothScroll||e.mouseWheelSmoothScroll,arrowSize:void 0!==e.arrowSize?e.arrowSize:11,listenOnDomNode:void 0!==e.listenOnDomNode?e.listenOnDomNode:null,horizontal:void 0!==e.horizontal?e.horizontal:1,horizontalScrollbarSize:void 0!==e.horizontalScrollbarSize?e.horizontalScrollbarSize:10,horizontalSliderSize:void 0!==e.horizontalSliderSize?e.horizontalSliderSize:0,horizontalHasArrows:void 0!==e.horizontalHasArrows&&e.horizontalHasArrows,vertical:void 0!==e.vertical?e.vertical:1,verticalScrollbarSize:void 0!==e.verticalScrollbarSize?e.verticalScrollbarSize:10,verticalHasArrows:void 0!==e.verticalHasArrows&&e.verticalHasArrows,verticalSliderSize:void 0!==e.verticalSliderSize?e.verticalSliderSize:0,scrollByPage:void 0!==e.scrollByPage&&e.scrollByPage};return t.horizontalSliderSize=void 0!==e.horizontalSliderSize?e.horizontalSliderSize:t.horizontalScrollbarSize,t.verticalSliderSize=void 0!==e.verticalSliderSize?e.verticalSliderSize:t.verticalScrollbarSize,m.zx&&(t.className+=" mac"),t}(t),this._scrollable=i,this._register(this._scrollable.onScroll((e=>{this._onWillScroll.fire(e),this._onDidScroll(e),this._onScroll.fire(e)})));const n={onMouseWheel:e=>this._onMouseWheel(e),onDragStart:()=>this._onDragStart(),onDragEnd:()=>this._onDragEnd()};this._verticalScrollbar=this._register(new w(this._scrollable,this._options,n)),this._horizontalScrollbar=this._register(new _(this._scrollable,this._options,n)),this._domNode=document.createElement("div"),this._domNode.className="monaco-scrollable-element "+this._options.className,this._domNode.setAttribute("role","presentation"),this._domNode.style.position="relative",this._domNode.style.overflow="hidden",this._domNode.appendChild(e),this._domNode.appendChild(this._horizontalScrollbar.domNode.domNode),this._domNode.appendChild(this._verticalScrollbar.domNode.domNode),this._options.useShadows?(this._leftShadowDomNode=(0,s.Z)(document.createElement("div")),this._leftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._leftShadowDomNode.domNode),this._topShadowDomNode=(0,s.Z)(document.createElement("div")),this._topShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topShadowDomNode.domNode),this._topLeftShadowDomNode=(0,s.Z)(document.createElement("div")),this._topLeftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topLeftShadowDomNode.domNode)):(this._leftShadowDomNode=null,this._topShadowDomNode=null,this._topLeftShadowDomNode=null),this._listenOnDomNode=this._options.listenOnDomNode||this._domNode,this._mouseWheelToDispose=[],this._setListeningToMouseWheel(this._options.handleMouseWheel),this.onmouseover(this._listenOnDomNode,(e=>this._onMouseOver(e))),this.onmouseleave(this._listenOnDomNode,(e=>this._onMouseLeave(e))),this._hideTimeout=this._register(new h.pc),this._isDragging=!1,this._mouseIsOver=!1,this._shouldRender=!0,this._revealOnScroll=!0}dispose(){this._mouseWheelToDispose=(0,u.AS)(this._mouseWheelToDispose),super.dispose()}getDomNode(){return this._domNode}getOverviewRulerLayoutInfo(){return{parent:this._domNode,insertBefore:this._verticalScrollbar.domNode.domNode}}delegateVerticalScrollbarPointerDown(e){this._verticalScrollbar.delegatePointerDown(e)}getScrollDimensions(){return this._scrollable.getScrollDimensions()}setScrollDimensions(e){this._scrollable.setScrollDimensions(e,!1)}updateClassName(e){this._options.className=e,m.zx&&(this._options.className+=" mac"),this._domNode.className="monaco-scrollable-element "+this._options.className}updateOptions(e){void 0!==e.handleMouseWheel&&(this._options.handleMouseWheel=e.handleMouseWheel,this._setListeningToMouseWheel(this._options.handleMouseWheel)),void 0!==e.mouseWheelScrollSensitivity&&(this._options.mouseWheelScrollSensitivity=e.mouseWheelScrollSensitivity),void 0!==e.fastScrollSensitivity&&(this._options.fastScrollSensitivity=e.fastScrollSensitivity),void 0!==e.scrollPredominantAxis&&(this._options.scrollPredominantAxis=e.scrollPredominantAxis),void 0!==e.horizontal&&(this._options.horizontal=e.horizontal),void 0!==e.vertical&&(this._options.vertical=e.vertical),void 0!==e.horizontalScrollbarSize&&(this._options.horizontalScrollbarSize=e.horizontalScrollbarSize),void 0!==e.verticalScrollbarSize&&(this._options.verticalScrollbarSize=e.verticalScrollbarSize),void 0!==e.scrollByPage&&(this._options.scrollByPage=e.scrollByPage),this._horizontalScrollbar.updateOptions(this._options),this._verticalScrollbar.updateOptions(this._options),this._options.lazyRender||this._render()}delegateScrollFromMouseWheelEvent(e){this._onMouseWheel(new r.$(e))}_setListeningToMouseWheel(e){if(this._mouseWheelToDispose.length>0!==e&&(this._mouseWheelToDispose=(0,u.AS)(this._mouseWheelToDispose),e)){const e=e=>{this._onMouseWheel(new r.$(e))};this._mouseWheelToDispose.push(o.ko(this._listenOnDomNode,o.Bx.MOUSE_WHEEL,e,{passive:!1}))}}_onMouseWheel(e){const t=E.INSTANCE;t.acceptStandardWheelEvent(e);let i=!1;if(e.deltaY||e.deltaX){let n=e.deltaY*this._options.mouseWheelScrollSensitivity,o=e.deltaX*this._options.mouseWheelScrollSensitivity;this._options.scrollPredominantAxis&&(Math.abs(n)>=Math.abs(o)?o=0:n=0),this._options.flipAxes&&([n,o]=[o,n]);const s=!m.zx&&e.browserEvent&&e.browserEvent.shiftKey;!this._options.scrollYToX&&!s||o||(o=n,n=0),e.browserEvent&&e.browserEvent.altKey&&(o*=this._options.fastScrollSensitivity,n*=this._options.fastScrollSensitivity);const r=this._scrollable.getFutureScrollPosition();let a={};if(n){const e=50*n,t=r.scrollTop-(e<0?Math.floor(e):Math.ceil(e));this._verticalScrollbar.writeScrollPosition(a,t)}if(o){const e=50*o,t=r.scrollLeft-(e<0?Math.floor(e):Math.ceil(e));this._horizontalScrollbar.writeScrollPosition(a,t)}a=this._scrollable.validateScrollPosition(a),(r.scrollLeft!==a.scrollLeft||r.scrollTop!==a.scrollTop)&&(this._options.mouseWheelSmoothScroll&&t.isPhysicalMouseWheel()?this._scrollable.setScrollPositionSmooth(a):this._scrollable.setScrollPositionNow(a),i=!0)}let n=i;!n&&this._options.alwaysConsumeMouseWheel&&(n=!0),!n&&this._options.consumeMouseWheelIfScrollbarIsNeeded&&(this._verticalScrollbar.isNeeded()||this._horizontalScrollbar.isNeeded())&&(n=!0),n&&(e.preventDefault(),e.stopPropagation())}_onDidScroll(e){this._shouldRender=this._horizontalScrollbar.onDidScroll(e)||this._shouldRender,this._shouldRender=this._verticalScrollbar.onDidScroll(e)||this._shouldRender,this._options.useShadows&&(this._shouldRender=!0),this._revealOnScroll&&this._reveal(),this._options.lazyRender||this._render()}renderNow(){if(!this._options.lazyRender)throw new Error("Please use `lazyRender` together with `renderNow`!");this._render()}_render(){if(this._shouldRender&&(this._shouldRender=!1,this._horizontalScrollbar.render(),this._verticalScrollbar.render(),this._options.useShadows)){const e=this._scrollable.getCurrentScrollPosition(),t=e.scrollTop>0,i=e.scrollLeft>0,n=i?" left":"",o=t?" top":"",s=i||t?" top-left-corner":"";this._leftShadowDomNode.setClassName(`shadow${n}`),this._topShadowDomNode.setClassName(`shadow${o}`),this._topLeftShadowDomNode.setClassName(`shadow${s}${o}${n}`)}}_onDragStart(){this._isDragging=!0,this._reveal()}_onDragEnd(){this._isDragging=!1,this._hide()}_onMouseLeave(e){this._mouseIsOver=!1,this._hide()}_onMouseOver(e){this._mouseIsOver=!0,this._reveal()}_reveal(){this._verticalScrollbar.beginReveal(),this._horizontalScrollbar.beginReveal(),this._scheduleHide()}_hide(){this._mouseIsOver||this._isDragging||(this._verticalScrollbar.beginHide(),this._horizontalScrollbar.beginHide())}_scheduleHide(){this._mouseIsOver||this._isDragging||this._hideTimeout.cancelAndSet((()=>this._hide()),500)}}class x extends D{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new v.yE({forceIntegerValues:!0,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>o.PG(e)});super(e,t,i),this._register(i)}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}}class L extends D{constructor(e,t,i){super(e,t,i)}setScrollPosition(e){e.reuseAnimation?this._scrollable.setScrollPositionSmooth(e,e.reuseAnimation):this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}}class M extends D{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new v.yE({forceIntegerValues:!1,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>o.PG(e)});super(e,t,i),this._register(i),this._element=e,this.onScroll((e=>{e.scrollTopChanged&&(this._element.scrollTop=e.scrollTop),e.scrollLeftChanged&&(this._element.scrollLeft=e.scrollLeft)})),this.scanDomNode()}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}scanDomNode(){this.setScrollDimensions({width:this._element.clientWidth,scrollWidth:this._element.scrollWidth,height:this._element.clientHeight,scrollHeight:this._element.scrollHeight}),this.setScrollPosition({scrollLeft:this._element.scrollLeft,scrollTop:this._element.scrollTop})}}},771:(e,t,i)=>{i.d(t,{l:()=>c,F:()=>h});var n=i(2776),o=i(3483),s=i(3884),r=i(3925),a=i.n(r),l=i(2629);a()(l.A,{insert:"head",singleton:!1}),l.A.locals;const h={inputActiveOptionBorder:"#007ACC00",inputActiveOptionForeground:"#FFFFFF",inputActiveOptionBackground:"#0E639C50"};class c extends n.x{constructor(e){super(),this._onChange=this._register(new s.vl),this.onChange=this._onChange.event,this._onKeyDown=this._register(new s.vl),this.onKeyDown=this._onKeyDown.event,this._opts=e,this._checked=this._opts.isChecked;const t=["monaco-custom-toggle"];this._opts.icon&&(this._icon=this._opts.icon,t.push(...o.L.asClassNameArray(this._icon))),this._opts.actionClassName&&t.push(...this._opts.actionClassName.split(" ")),this._checked&&t.push("checked"),this.domNode=document.createElement("div"),this.domNode.title=this._opts.title,this.domNode.classList.add(...t),this._opts.notFocusable||(this.domNode.tabIndex=0),this.domNode.setAttribute("role","checkbox"),this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.setAttribute("aria-label",this._opts.title),this.applyStyles(),this.onclick(this.domNode,(e=>{this.enabled&&(this.checked=!this._checked,this._onChange.fire(!1),e.preventDefault())})),this._register(this.ignoreGesture(this.domNode)),this.onkeydown(this.domNode,(e=>{if(10===e.keyCode||3===e.keyCode)return this.checked=!this._checked,this._onChange.fire(!0),e.preventDefault(),void e.stopPropagation();this._onKeyDown.fire(e)}))}get enabled(){return"true"!==this.domNode.getAttribute("aria-disabled")}focus(){this.domNode.focus()}get checked(){return this._checked}set checked(e){this._checked=e,this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.classList.toggle("checked",this._checked),this.applyStyles()}width(){return 22}applyStyles(){this.domNode&&(this.domNode.style.borderColor=this._checked&&this._opts.inputActiveOptionBorder||"",this.domNode.style.color=this._checked&&this._opts.inputActiveOptionForeground||"inherit",this.domNode.style.backgroundColor=this._checked&&this._opts.inputActiveOptionBackground||"")}enable(){this.domNode.setAttribute("aria-disabled",String(!1))}disable(){this.domNode.setAttribute("aria-disabled",String(!0))}}},2776:(e,t,i)=>{i.d(t,{x:()=>l});var n=i(8479),o=i(192),s=i(9121),r=i(9408),a=i(8300);class l extends a.jG{onclick(e,t){this._register(n.ko(e,n.Bx.CLICK,(e=>t(new s.P(e)))))}onmousedown(e,t){this._register(n.ko(e,n.Bx.MOUSE_DOWN,(e=>t(new s.P(e)))))}onmouseover(e,t){this._register(n.ko(e,n.Bx.MOUSE_OVER,(e=>t(new s.P(e)))))}onmouseleave(e,t){this._register(n.ko(e,n.Bx.MOUSE_LEAVE,(e=>t(new s.P(e)))))}onkeydown(e,t){this._register(n.ko(e,n.Bx.KEY_DOWN,(e=>t(new o.Z(e)))))}onkeyup(e,t){this._register(n.ko(e,n.Bx.KEY_UP,(e=>t(new o.Z(e)))))}oninput(e,t){this._register(n.ko(e,n.Bx.INPUT,t))}onblur(e,t){this._register(n.ko(e,n.Bx.BLUR,t))}onfocus(e,t){this._register(n.ko(e,n.Bx.FOCUS,t))}ignoreGesture(e){return r.q.ignoreTarget(e)}}},4315:(e,t,i)=>{i.d(t,{HJ:()=>d,LN:()=>l,YH:()=>c,ih:()=>u,rc:()=>a,wv:()=>h});var n=i(3884),o=i(8300),s=i(1759),r=function(e,t,i,n){return new(i||(i=Promise))((function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(r,a)}l((n=n.apply(e,t||[])).next())}))};class a extends o.jG{constructor(e,t="",i="",o=!0,s){super(),this._onDidChange=this._register(new n.vl),this.onDidChange=this._onDidChange.event,this._enabled=!0,this._id=e,this._label=t,this._cssClass=i,this._enabled=o,this._actionCallback=s}get id(){return this._id}get label(){return this._label}set label(e){this._setLabel(e)}_setLabel(e){this._label!==e&&(this._label=e,this._onDidChange.fire({label:e}))}get tooltip(){return this._tooltip||""}set tooltip(e){this._setTooltip(e)}_setTooltip(e){this._tooltip!==e&&(this._tooltip=e,this._onDidChange.fire({tooltip:e}))}get class(){return this._cssClass}set class(e){this._setClass(e)}_setClass(e){this._cssClass!==e&&(this._cssClass=e,this._onDidChange.fire({class:e}))}get enabled(){return this._enabled}set enabled(e){this._setEnabled(e)}_setEnabled(e){this._enabled!==e&&(this._enabled=e,this._onDidChange.fire({enabled:e}))}get checked(){return this._checked}set checked(e){this._setChecked(e)}_setChecked(e){this._checked!==e&&(this._checked=e,this._onDidChange.fire({checked:e}))}run(e,t){return r(this,void 0,void 0,(function*(){this._actionCallback&&(yield this._actionCallback(e))}))}}class l extends o.jG{constructor(){super(...arguments),this._onWillRun=this._register(new n.vl),this.onWillRun=this._onWillRun.event,this._onDidRun=this._register(new n.vl),this.onDidRun=this._onDidRun.event}run(e,t){return r(this,void 0,void 0,(function*(){if(!e.enabled)return;let i;this._onWillRun.fire({action:e});try{yield this.runAction(e,t)}catch(e){i=e}this._onDidRun.fire({action:e,error:i})}))}runAction(e,t){return r(this,void 0,void 0,(function*(){yield e.run(t)}))}}class h{constructor(){this.id=h.ID,this.label="",this.tooltip="",this.class="separator",this.enabled=!1,this.checked=!1}static join(...e){let t=[];for(const i of e)i.length&&(t=t.length?[...t,new h,...i]:i);return t}run(){return r(this,void 0,void 0,(function*(){}))}}h.ID="vs.actions.separator";class c{get actions(){return this._actions}constructor(e,t,i,n){this.tooltip="",this.enabled=!0,this.checked=void 0,this.id=e,this.label=t,this.class=n,this._actions=i}run(){return r(this,void 0,void 0,(function*(){}))}}class d extends a{constructor(){super(d.ID,s.kg("submenu.empty","(empty)"),void 0,!1)}}function u(e){var t,i;return{id:e.id,label:e.label,class:void 0,enabled:null===(t=e.enabled)||void 0===t||t,checked:null!==(i=e.checked)&&void 0!==i&&i,run:()=>r(this,void 0,void 0,(function*(){return e.run()})),tooltip:e.label}}d.ID="vs.actions.empty"},8092:(e,t,i)=>{function n(e,t=0){return e[e.length-(1+t)]}function o(e){if(0===e.length)throw new Error("Invalid tail call");return[e.slice(0,e.length-1),e[e.length-1]]}function s(e,t,i=(e,t)=>e===t){if(e===t)return!0;if(!e||!t)return!1;if(e.length!==t.length)return!1;for(let n=0,o=e.length;n<o;n++)if(!i(e[n],t[n]))return!1;return!0}function r(e,t){const i=e.length-1;t<i&&(e[t]=e[i]),e.pop()}function a(e,t,i){return function(n){let o=0,s=n-1;for(;o<=s;){const n=(o+s)/2|0,r=i(e[n],t);if(r<0)o=n+1;else{if(!(r>0))return n;s=n-1}}return-(o+1)}(e.length)}function l(e,t,i){if((e|=0)>=t.length)throw new TypeError("invalid index");const n=t[Math.floor(t.length*Math.random())],o=[],s=[],r=[];for(const e of t){const t=i(e,n);t<0?o.push(e):t>0?s.push(e):r.push(e)}return e<o.length?l(e,o,i):e<o.length+r.length?r[0]:l(e-(o.length+r.length),s,i)}function h(e,t){const i=[];let n;for(const o of e.slice(0).sort(t))n&&0===t(n[0],o)?n.push(o):(n=[o],i.push(n));return i}function c(e){return e.filter((e=>!!e))}function d(e){return!Array.isArray(e)||0===e.length}function u(e){return Array.isArray(e)&&e.length>0}function g(e,t=e=>e){const i=new Set;return e.filter((e=>{const n=t(e);return!i.has(n)&&(i.add(n),!0)}))}function m(e,t){const i=function(e,t){for(let i=e.length-1;i>=0;i--)if(t(e[i]))return i;return-1}(e,t);if(-1!==i)return e[i]}function p(e,t){return e.length>0?e[0]:t}function f(e,t){let i="number"==typeof t?e:0;"number"==typeof t?i=e:(i=0,t=e);const n=[];if(i<=t)for(let e=i;e<t;e++)n.push(e);else for(let e=i;e>t;e--)n.push(e);return n}function A(e,t,i){const n=e.slice(0,t),o=e.slice(t);return n.concat(i,o)}function _(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.unshift(t))}function w(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.push(t))}function b(e,t){for(const i of t)e.push(i)}function v(e,t,i,n){const o=C(e,t),s=e.splice(o,i);return function(e,t,i){const n=C(e,t),o=e.length,s=i.length;e.length=o+s;for(let t=o-1;t>=n;t--)e[t+s]=e[t];for(let t=0;t<s;t++)e[t+n]=i[t]}(e,o,n),s}function C(e,t){return t<0?Math.max(t+e.length,0):Math.min(t,e.length)}var y;function S(e,t){return(i,n)=>t(e(i),e(n))}function k(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>=0&&(i=o)}return i}function E(e,t){return function(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>0&&(i=o)}return i}(e,((e,i)=>-t(e,i)))}i.d(t,{$z:()=>h,Ct:()=>d,E4:()=>b,EI:()=>u,El:()=>a,Fy:()=>p,Jw:()=>k,Ly:()=>E,RT:()=>n,SO:()=>l,UH:()=>r,Uk:()=>m,V4:()=>v,VE:()=>S,Yc:()=>c,_A:()=>_,aI:()=>s,bS:()=>o,c1:()=>x,dM:()=>g,j3:()=>D,nK:()=>A,r7:()=>w,y1:()=>f}),function(e){e.isLessThan=function(e){return e<0},e.isGreaterThan=function(e){return e>0},e.isNeitherLessOrGreaterThan=function(e){return 0===e},e.greaterThan=1,e.lessThan=-1,e.neitherLessOrGreaterThan=0}(y||(y={}));class D{constructor(e){this.items=e,this.firstIdx=0,this.lastIdx=this.items.length-1}get length(){return this.lastIdx-this.firstIdx+1}takeWhile(e){let t=this.firstIdx;for(;t<this.items.length&&e(this.items[t]);)t++;const i=t===this.firstIdx?null:this.items.slice(this.firstIdx,t);return this.firstIdx=t,i}takeFromEndWhile(e){let t=this.lastIdx;for(;t>=0&&e(this.items[t]);)t--;const i=t===this.lastIdx?null:this.items.slice(t+1,this.lastIdx+1);return this.lastIdx=t,i}peek(){if(0!==this.length)return this.items[this.firstIdx]}dequeue(){const e=this.items[this.firstIdx];return this.firstIdx++,e}takeCount(e){const t=this.items.slice(this.firstIdx,this.firstIdx+e);return this.firstIdx+=e,t}}class x{constructor(e){this.iterate=e}toArray(){const e=[];return this.iterate((t=>(e.push(t),!0))),e}filter(e){return new x((t=>this.iterate((i=>!e(i)||t(i)))))}map(e){return new x((t=>this.iterate((i=>t(e(i))))))}findLast(e){let t;return this.iterate((i=>(e(i)&&(t=i),!0))),t}findLastMaxBy(e){let t,i=!0;return this.iterate((n=>((i||y.isGreaterThan(e(n,t)))&&(i=!1,t=n),!0))),t}}x.empty=new x((e=>{}))},2448:(e,t,i)=>{i.d(t,{Ft:()=>r,Xo:()=>a,ok:()=>o,xb:()=>s});var n=i(3329);function o(e,t){if(!e)throw new Error(t?`Assertion failed (${t})`:"Assertion Failed")}function s(e,t="Unreachable"){throw new Error(t)}function r(e){e()||(e(),(0,n.dz)(new n.D7("Assertion Failed")))}function a(e,t){let i=0;for(;i<e.length-1;){if(!t(e[i],e[i+1]))return!1;i++}return!0}},5404:(e,t,i)=>{i.d(t,{EQ:()=>A,HC:()=>S,Qg:()=>d,SS:()=>u,Th:()=>p,Zv:()=>y,cx:()=>v,kb:()=>C,pc:()=>_,uC:()=>b,vb:()=>w,ve:()=>m,wR:()=>f});var n=i(9377),o=i(3329),s=i(3884),r=i(8300),a=i(4541),l=i(113),h=function(e,t,i,n){return new(i||(i=Promise))((function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(r,a)}l((n=n.apply(e,t||[])).next())}))},c=function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,i=e[Symbol.asyncIterator];return i?i.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),t={},n("next"),n("throw"),n("return"),t[Symbol.asyncIterator]=function(){return this},t);function n(i){t[i]=e[i]&&function(t){return new Promise((function(n,o){!function(e,t,i,n){Promise.resolve(n).then((function(t){e({value:t,done:i})}),t)}(n,o,(t=e[i](t)).done,t.value)}))}}};function d(e){return!!e&&"function"==typeof e.then}function u(e){const t=new n.Q,i=e(t.token),s=new Promise(((e,n)=>{const s=t.token.onCancellationRequested((()=>{s.dispose(),t.dispose(),n(new o.AL)}));Promise.resolve(i).then((i=>{s.dispose(),t.dispose(),e(i)}),(e=>{s.dispose(),t.dispose(),n(e)}))}));return new class{cancel(){t.cancel()}then(e,t){return s.then(e,t)}catch(e){return this.then(void 0,e)}finally(e){return s.finally(e)}}}class g{constructor(){this.activePromise=null,this.queuedPromise=null,this.queuedPromiseFactory=null}queue(e){if(this.activePromise){if(this.queuedPromiseFactory=e,!this.queuedPromise){const e=()=>{this.queuedPromise=null;const e=this.queue(this.queuedPromiseFactory);return this.queuedPromiseFactory=null,e};this.queuedPromise=new Promise((t=>{this.activePromise.then(e,e).then(t)}))}return new Promise(((e,t)=>{this.queuedPromise.then(e,t)}))}return this.activePromise=e(),new Promise(((e,t)=>{this.activePromise.then((t=>{this.activePromise=null,e(t)}),(e=>{this.activePromise=null,t(e)}))}))}}class m{constructor(e){this.defaultDelay=e,this.deferred=null,this.completionPromise=null,this.doResolve=null,this.doReject=null,this.task=null}trigger(e,t=this.defaultDelay){this.task=e,this.cancelTimeout(),this.completionPromise||(this.completionPromise=new Promise(((e,t)=>{this.doResolve=e,this.doReject=t})).then((()=>{if(this.completionPromise=null,this.doResolve=null,this.task){const e=this.task;return this.task=null,e()}})));const i=()=>{var e;this.deferred=null,null===(e=this.doResolve)||void 0===e||e.call(this,null)};return this.deferred=t===l.h?(e=>{let t=!0;return queueMicrotask((()=>{t&&(t=!1,e())})),{isTriggered:()=>t,dispose:()=>{t=!1}}})(i):((e,t)=>{let i=!0;const n=setTimeout((()=>{i=!1,t()}),e);return{isTriggered:()=>i,dispose:()=>{clearTimeout(n),i=!1}}})(t,i),this.completionPromise}isTriggered(){var e;return!!(null===(e=this.deferred)||void 0===e?void 0:e.isTriggered())}cancel(){var e;this.cancelTimeout(),this.completionPromise&&(null===(e=this.doReject)||void 0===e||e.call(this,new o.AL),this.completionPromise=null)}cancelTimeout(){var e;null===(e=this.deferred)||void 0===e||e.dispose(),this.deferred=null}dispose(){this.cancel()}}class p{constructor(e){this.delayer=new m(e),this.throttler=new g}trigger(e,t){return this.delayer.trigger((()=>this.throttler.queue(e)),t)}cancel(){this.delayer.cancel()}dispose(){this.delayer.dispose()}}function f(e,t){return t?new Promise(((i,n)=>{const s=setTimeout((()=>{r.dispose(),i()}),e),r=t.onCancellationRequested((()=>{clearTimeout(s),r.dispose(),n(new o.AL)}))})):u((t=>f(e,t)))}function A(e,t=0){const i=setTimeout(e,t);return(0,r.s)((()=>clearTimeout(i)))}class _{constructor(e,t){this._token=-1,"function"==typeof e&&"number"==typeof t&&this.setIfNotSet(e,t)}dispose(){this.cancel()}cancel(){-1!==this._token&&(clearTimeout(this._token),this._token=-1)}cancelAndSet(e,t){this.cancel(),this._token=setTimeout((()=>{this._token=-1,e()}),t)}setIfNotSet(e,t){-1===this._token&&(this._token=setTimeout((()=>{this._token=-1,e()}),t))}}class w{constructor(){this._token=-1}dispose(){this.cancel()}cancel(){-1!==this._token&&(clearInterval(this._token),this._token=-1)}cancelAndSet(e,t){this.cancel(),this._token=setInterval((()=>{e()}),t)}}class b{constructor(e,t){this.timeoutToken=-1,this.runner=e,this.timeout=t,this.timeoutHandler=this.onTimeout.bind(this)}dispose(){this.cancel(),this.runner=null}cancel(){this.isScheduled()&&(clearTimeout(this.timeoutToken),this.timeoutToken=-1)}schedule(e=this.timeout){this.cancel(),this.timeoutToken=setTimeout(this.timeoutHandler,e)}get delay(){return this.timeout}set delay(e){this.timeout=e}isScheduled(){return-1!==this.timeoutToken}onTimeout(){this.timeoutToken=-1,this.runner&&this.doRun()}doRun(){var e;null===(e=this.runner)||void 0===e||e.call(this)}}let v;v="function"!=typeof requestIdleCallback||"function"!=typeof cancelIdleCallback?e=>{(0,a._p)((()=>{if(t)return;const i=Date.now()+15;e(Object.freeze({didTimeout:!0,timeRemaining:()=>Math.max(0,i-Date.now())}))}));let t=!1;return{dispose(){t||(t=!0)}}}:(e,t)=>{const i=requestIdleCallback(e,"number"==typeof t?{timeout:t}:void 0);let n=!1;return{dispose(){n||(n=!0,cancelIdleCallback(i))}}};class C{constructor(e){this._didRun=!1,this._executor=()=>{try{this._value=e()}catch(e){this._error=e}finally{this._didRun=!0}},this._handle=v((()=>this._executor()))}dispose(){this._handle.dispose()}get value(){if(this._didRun||(this._handle.dispose(),this._executor()),this._error)throw this._error;return this._value}get isInitialized(){return this._didRun}}class y{get isRejected(){var e;return 1===(null===(e=this.outcome)||void 0===e?void 0:e.outcome)}get isSettled(){return!!this.outcome}constructor(){this.p=new Promise(((e,t)=>{this.completeCallback=e,this.errorCallback=t}))}complete(e){return new Promise((t=>{this.completeCallback(e),this.outcome={outcome:0,value:e},t()}))}error(e){return new Promise((t=>{this.errorCallback(e),this.outcome={outcome:1,value:e},t()}))}cancel(){return this.error(new o.AL)}}var S;!function(e){e.settled=function(e){return h(this,void 0,void 0,(function*(){let t;const i=yield Promise.all(e.map((e=>e.then((e=>e),(e=>{t||(t=e)})))));if(void 0!==t)throw t;return i}))},e.withAsyncBody=function(e){return new Promise(((t,i)=>h(this,void 0,void 0,(function*(){try{yield e(t,i)}catch(e){i(e)}}))))}}(S||(S={}));class k{static fromArray(e){return new k((t=>{t.emitMany(e)}))}static fromPromise(e){return new k((t=>h(this,void 0,void 0,(function*(){t.emitMany(yield e)}))))}static fromPromises(e){return new k((t=>h(this,void 0,void 0,(function*(){yield Promise.all(e.map((e=>h(this,void 0,void 0,(function*(){return t.emitOne(yield e)})))))}))))}static merge(e){return new k((t=>h(this,void 0,void 0,(function*(){yield Promise.all(e.map((e=>{var i,n,o;return h(this,void 0,void 0,(function*(){var s,r,a,l;try{for(i=!0,n=c(e);!(s=(o=yield n.next()).done);i=!0){l=o.value,i=!1;const e=l;t.emitOne(e)}}catch(e){r={error:e}}finally{try{i||s||!(a=n.return)||(yield a.call(n))}finally{if(r)throw r.error}}}))})))}))))}constructor(e){this._state=0,this._results=[],this._error=null,this._onStateChanged=new s.vl,queueMicrotask((()=>h(this,void 0,void 0,(function*(){const t={emitOne:e=>this.emitOne(e),emitMany:e=>this.emitMany(e),reject:e=>this.reject(e)};try{yield Promise.resolve(e(t)),this.resolve()}catch(e){this.reject(e)}finally{t.emitOne=void 0,t.emitMany=void 0,t.reject=void 0}}))))}[Symbol.asyncIterator](){let e=0;return{next:()=>h(this,void 0,void 0,(function*(){for(;;){if(2===this._state)throw this._error;if(e<this._results.length)return{done:!1,value:this._results[e++]};if(1===this._state)return{done:!0,value:void 0};yield s.Jh.toPromise(this._onStateChanged.event)}}))}}static map(e,t){return new k((i=>h(this,void 0,void 0,(function*(){var n,o,s,r;try{for(var a,l=!0,h=c(e);!(n=(a=yield h.next()).done);l=!0){r=a.value,l=!1;const e=r;i.emitOne(t(e))}}catch(e){o={error:e}}finally{try{l||n||!(s=h.return)||(yield s.call(h))}finally{if(o)throw o.error}}}))))}map(e){return k.map(this,e)}static filter(e,t){return new k((i=>h(this,void 0,void 0,(function*(){var n,o,s,r;try{for(var a,l=!0,h=c(e);!(n=(a=yield h.next()).done);l=!0){r=a.value,l=!1;const e=r;t(e)&&i.emitOne(e)}}catch(e){o={error:e}}finally{try{l||n||!(s=h.return)||(yield s.call(h))}finally{if(o)throw o.error}}}))))}filter(e){return k.filter(this,e)}static coalesce(e){return k.filter(e,(e=>!!e))}coalesce(){return k.coalesce(this)}static toPromise(e){var t,i,n,o,s,r,a;return h(this,void 0,void 0,(function*(){const l=[];try{for(t=!0,i=c(e);n=yield i.next(),!(o=n.done);t=!0){a=n.value,t=!1;const e=a;l.push(e)}}catch(e){s={error:e}}finally{try{t||o||!(r=i.return)||(yield r.call(i))}finally{if(s)throw s.error}}return l}))}toPromise(){return k.toPromise(this)}emitOne(e){0===this._state&&(this._results.push(e),this._onStateChanged.fire())}emitMany(e){0===this._state&&(this._results=this._results.concat(e),this._onStateChanged.fire())}resolve(){0===this._state&&(this._state=1,this._onStateChanged.fire())}reject(e){0===this._state&&(this._state=2,this._error=e,this._onStateChanged.fire())}}k.EMPTY=k.fromArray([])},5888:(e,t,i)=>{i.d(t,{$l:()=>a,Gs:()=>u,MB:()=>r,Sw:()=>c,bb:()=>h,gN:()=>l,pJ:()=>d});var n=i(4100);const o="undefined"!=typeof Buffer;let s;new n.d((()=>new Uint8Array(256)));class r{static wrap(e){return o&&!Buffer.isBuffer(e)&&(e=Buffer.from(e.buffer,e.byteOffset,e.byteLength)),new r(e)}constructor(e){this.buffer=e,this.byteLength=this.buffer.byteLength}toString(){return o?this.buffer.toString():(s||(s=new TextDecoder),s.decode(this.buffer))}}function a(e,t){return(0|e[t+0])>>>0|e[t+1]<<8>>>0}function l(e,t,i){e[i+0]=255&t,t>>>=8,e[i+1]=255&t}function h(e,t){return e[t]*Math.pow(2,24)+e[t+1]*Math.pow(2,16)+e[t+2]*Math.pow(2,8)+e[t+3]}function c(e,t,i){e[i+3]=t,t>>>=8,e[i+2]=t,t>>>=8,e[i+1]=t,t>>>=8,e[i]=t}function d(e,t){return e[t]}function u(e,t,i){e[i]=t}},38:(e,t,i)=>{i.d(t,{V:()=>o,o:()=>n});class n{constructor(e){this.fn=e,this.lastCache=void 0,this.lastArgKey=void 0}get(e){const t=JSON.stringify(e);return this.lastArgKey!==t&&(this.lastArgKey=t,this.lastCache=this.fn(e)),this.lastCache}}class o{get cachedValues(){return this._map}constructor(e){this.fn=e,this._map=new Map}get(e){if(this._map.has(e))return this._map.get(e);const t=this.fn(e);return this._map.set(e,t),t}}},9377:(e,t,i)=>{i.d(t,{Q:()=>a,X:()=>s});var n=i(3884);const o=Object.freeze((function(e,t){const i=setTimeout(e.bind(t),0);return{dispose(){clearTimeout(i)}}}));var s;!function(e){e.isCancellationToken=function(t){return t===e.None||t===e.Cancelled||t instanceof r||!(!t||"object"!=typeof t)&&"boolean"==typeof t.isCancellationRequested&&"function"==typeof t.onCancellationRequested},e.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:n.Jh.None}),e.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:o})}(s||(s={}));class r{constructor(){this._isCancelled=!1,this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?o:(this._emitter||(this._emitter=new n.vl),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}}class a{constructor(e){this._token=void 0,this._parentListener=void 0,this._parentListener=e&&e.onCancellationRequested(this.cancel,this)}get token(){return this._token||(this._token=new r),this._token}cancel(){this._token?this._token instanceof r&&this._token.cancel():this._token=s.Cancelled}dispose(e=!1){var t;e&&this.cancel(),null===(t=this._parentListener)||void 0===t||t.dispose(),this._token?this._token instanceof r&&this._token.dispose():this._token=s.None}}},8694:(e,t,i)=>{i.d(t,{J:()=>r,W:()=>a});var n=i(2821);const o=Object.create(null);function s(e,t){if((0,n.Kg)(t)){const i=o[t];if(void 0===i)throw new Error(`${e} references an unknown codicon: ${t}`);t=i}return o[e]=t,{id:e}}function r(){return o}const a={add:s("add",6e4),plus:s("plus",6e4),gistNew:s("gist-new",6e4),repoCreate:s("repo-create",6e4),lightbulb:s("lightbulb",60001),lightBulb:s("light-bulb",60001),repo:s("repo",60002),repoDelete:s("repo-delete",60002),gistFork:s("gist-fork",60003),repoForked:s("repo-forked",60003),gitPullRequest:s("git-pull-request",60004),gitPullRequestAbandoned:s("git-pull-request-abandoned",60004),recordKeys:s("record-keys",60005),keyboard:s("keyboard",60005),tag:s("tag",60006),tagAdd:s("tag-add",60006),tagRemove:s("tag-remove",60006),person:s("person",60007),personFollow:s("person-follow",60007),personOutline:s("person-outline",60007),personFilled:s("person-filled",60007),gitBranch:s("git-branch",60008),gitBranchCreate:s("git-branch-create",60008),gitBranchDelete:s("git-branch-delete",60008),sourceControl:s("source-control",60008),mirror:s("mirror",60009),mirrorPublic:s("mirror-public",60009),star:s("star",60010),starAdd:s("star-add",60010),starDelete:s("star-delete",60010),starEmpty:s("star-empty",60010),comment:s("comment",60011),commentAdd:s("comment-add",60011),alert:s("alert",60012),warning:s("warning",60012),search:s("search",60013),searchSave:s("search-save",60013),logOut:s("log-out",60014),signOut:s("sign-out",60014),logIn:s("log-in",60015),signIn:s("sign-in",60015),eye:s("eye",60016),eyeUnwatch:s("eye-unwatch",60016),eyeWatch:s("eye-watch",60016),circleFilled:s("circle-filled",60017),primitiveDot:s("primitive-dot",60017),closeDirty:s("close-dirty",60017),debugBreakpoint:s("debug-breakpoint",60017),debugBreakpointDisabled:s("debug-breakpoint-disabled",60017),debugHint:s("debug-hint",60017),primitiveSquare:s("primitive-square",60018),edit:s("edit",60019),pencil:s("pencil",60019),info:s("info",60020),issueOpened:s("issue-opened",60020),gistPrivate:s("gist-private",60021),gitForkPrivate:s("git-fork-private",60021),lock:s("lock",60021),mirrorPrivate:s("mirror-private",60021),close:s("close",60022),removeClose:s("remove-close",60022),x:s("x",60022),repoSync:s("repo-sync",60023),sync:s("sync",60023),clone:s("clone",60024),desktopDownload:s("desktop-download",60024),beaker:s("beaker",60025),microscope:s("microscope",60025),vm:s("vm",60026),deviceDesktop:s("device-desktop",60026),file:s("file",60027),fileText:s("file-text",60027),more:s("more",60028),ellipsis:s("ellipsis",60028),kebabHorizontal:s("kebab-horizontal",60028),mailReply:s("mail-reply",60029),reply:s("reply",60029),organization:s("organization",60030),organizationFilled:s("organization-filled",60030),organizationOutline:s("organization-outline",60030),newFile:s("new-file",60031),fileAdd:s("file-add",60031),newFolder:s("new-folder",60032),fileDirectoryCreate:s("file-directory-create",60032),trash:s("trash",60033),trashcan:s("trashcan",60033),history:s("history",60034),clock:s("clock",60034),folder:s("folder",60035),fileDirectory:s("file-directory",60035),symbolFolder:s("symbol-folder",60035),logoGithub:s("logo-github",60036),markGithub:s("mark-github",60036),github:s("github",60036),terminal:s("terminal",60037),console:s("console",60037),repl:s("repl",60037),zap:s("zap",60038),symbolEvent:s("symbol-event",60038),error:s("error",60039),stop:s("stop",60039),variable:s("variable",60040),symbolVariable:s("symbol-variable",60040),array:s("array",60042),symbolArray:s("symbol-array",60042),symbolModule:s("symbol-module",60043),symbolPackage:s("symbol-package",60043),symbolNamespace:s("symbol-namespace",60043),symbolObject:s("symbol-object",60043),symbolMethod:s("symbol-method",60044),symbolFunction:s("symbol-function",60044),symbolConstructor:s("symbol-constructor",60044),symbolBoolean:s("symbol-boolean",60047),symbolNull:s("symbol-null",60047),symbolNumeric:s("symbol-numeric",60048),symbolNumber:s("symbol-number",60048),symbolStructure:s("symbol-structure",60049),symbolStruct:s("symbol-struct",60049),symbolParameter:s("symbol-parameter",60050),symbolTypeParameter:s("symbol-type-parameter",60050),symbolKey:s("symbol-key",60051),symbolText:s("symbol-text",60051),symbolReference:s("symbol-reference",60052),goToFile:s("go-to-file",60052),symbolEnum:s("symbol-enum",60053),symbolValue:s("symbol-value",60053),symbolRuler:s("symbol-ruler",60054),symbolUnit:s("symbol-unit",60054),activateBreakpoints:s("activate-breakpoints",60055),archive:s("archive",60056),arrowBoth:s("arrow-both",60057),arrowDown:s("arrow-down",60058),arrowLeft:s("arrow-left",60059),arrowRight:s("arrow-right",60060),arrowSmallDown:s("arrow-small-down",60061),arrowSmallLeft:s("arrow-small-left",60062),arrowSmallRight:s("arrow-small-right",60063),arrowSmallUp:s("arrow-small-up",60064),arrowUp:s("arrow-up",60065),bell:s("bell",60066),bold:s("bold",60067),book:s("book",60068),bookmark:s("bookmark",60069),debugBreakpointConditionalUnverified:s("debug-breakpoint-conditional-unverified",60070),debugBreakpointConditional:s("debug-breakpoint-conditional",60071),debugBreakpointConditionalDisabled:s("debug-breakpoint-conditional-disabled",60071),debugBreakpointDataUnverified:s("debug-breakpoint-data-unverified",60072),debugBreakpointData:s("debug-breakpoint-data",60073),debugBreakpointDataDisabled:s("debug-breakpoint-data-disabled",60073),debugBreakpointLogUnverified:s("debug-breakpoint-log-unverified",60074),debugBreakpointLog:s("debug-breakpoint-log",60075),debugBreakpointLogDisabled:s("debug-breakpoint-log-disabled",60075),briefcase:s("briefcase",60076),broadcast:s("broadcast",60077),browser:s("browser",60078),bug:s("bug",60079),calendar:s("calendar",60080),caseSensitive:s("case-sensitive",60081),check:s("check",60082),checklist:s("checklist",60083),chevronDown:s("chevron-down",60084),dropDownButton:s("drop-down-button",60084),chevronLeft:s("chevron-left",60085),chevronRight:s("chevron-right",60086),chevronUp:s("chevron-up",60087),chromeClose:s("chrome-close",60088),chromeMaximize:s("chrome-maximize",60089),chromeMinimize:s("chrome-minimize",60090),chromeRestore:s("chrome-restore",60091),circle:s("circle",60092),circleOutline:s("circle-outline",60092),debugBreakpointUnverified:s("debug-breakpoint-unverified",60092),circleSlash:s("circle-slash",60093),circuitBoard:s("circuit-board",60094),clearAll:s("clear-all",60095),clippy:s("clippy",60096),closeAll:s("close-all",60097),cloudDownload:s("cloud-download",60098),cloudUpload:s("cloud-upload",60099),code:s("code",60100),collapseAll:s("collapse-all",60101),colorMode:s("color-mode",60102),commentDiscussion:s("comment-discussion",60103),compareChanges:s("compare-changes",60157),creditCard:s("credit-card",60105),dash:s("dash",60108),dashboard:s("dashboard",60109),database:s("database",60110),debugContinue:s("debug-continue",60111),debugDisconnect:s("debug-disconnect",60112),debugPause:s("debug-pause",60113),debugRestart:s("debug-restart",60114),debugStart:s("debug-start",60115),debugStepInto:s("debug-step-into",60116),debugStepOut:s("debug-step-out",60117),debugStepOver:s("debug-step-over",60118),debugStop:s("debug-stop",60119),debug:s("debug",60120),deviceCameraVideo:s("device-camera-video",60121),deviceCamera:s("device-camera",60122),deviceMobile:s("device-mobile",60123),diffAdded:s("diff-added",60124),diffIgnored:s("diff-ignored",60125),diffModified:s("diff-modified",60126),diffRemoved:s("diff-removed",60127),diffRenamed:s("diff-renamed",60128),diff:s("diff",60129),discard:s("discard",60130),editorLayout:s("editor-layout",60131),emptyWindow:s("empty-window",60132),exclude:s("exclude",60133),extensions:s("extensions",60134),eyeClosed:s("eye-closed",60135),fileBinary:s("file-binary",60136),fileCode:s("file-code",60137),fileMedia:s("file-media",60138),filePdf:s("file-pdf",60139),fileSubmodule:s("file-submodule",60140),fileSymlinkDirectory:s("file-symlink-directory",60141),fileSymlinkFile:s("file-symlink-file",60142),fileZip:s("file-zip",60143),files:s("files",60144),filter:s("filter",60145),flame:s("flame",60146),foldDown:s("fold-down",60147),foldUp:s("fold-up",60148),fold:s("fold",60149),folderActive:s("folder-active",60150),folderOpened:s("folder-opened",60151),gear:s("gear",60152),gift:s("gift",60153),gistSecret:s("gist-secret",60154),gist:s("gist",60155),gitCommit:s("git-commit",60156),gitCompare:s("git-compare",60157),gitMerge:s("git-merge",60158),githubAction:s("github-action",60159),githubAlt:s("github-alt",60160),globe:s("globe",60161),grabber:s("grabber",60162),graph:s("graph",60163),gripper:s("gripper",60164),heart:s("heart",60165),home:s("home",60166),horizontalRule:s("horizontal-rule",60167),hubot:s("hubot",60168),inbox:s("inbox",60169),issueClosed:s("issue-closed",60324),issueReopened:s("issue-reopened",60171),issues:s("issues",60172),italic:s("italic",60173),jersey:s("jersey",60174),json:s("json",60175),bracket:s("bracket",60175),kebabVertical:s("kebab-vertical",60176),key:s("key",60177),law:s("law",60178),lightbulbAutofix:s("lightbulb-autofix",60179),linkExternal:s("link-external",60180),link:s("link",60181),listOrdered:s("list-ordered",60182),listUnordered:s("list-unordered",60183),liveShare:s("live-share",60184),loading:s("loading",60185),location:s("location",60186),mailRead:s("mail-read",60187),mail:s("mail",60188),markdown:s("markdown",60189),megaphone:s("megaphone",60190),mention:s("mention",60191),milestone:s("milestone",60192),mortarBoard:s("mortar-board",60193),move:s("move",60194),multipleWindows:s("multiple-windows",60195),mute:s("mute",60196),noNewline:s("no-newline",60197),note:s("note",60198),octoface:s("octoface",60199),openPreview:s("open-preview",60200),package_:s("package",60201),paintcan:s("paintcan",60202),pin:s("pin",60203),play:s("play",60204),run:s("run",60204),plug:s("plug",60205),preserveCase:s("preserve-case",60206),preview:s("preview",60207),project:s("project",60208),pulse:s("pulse",60209),question:s("question",60210),quote:s("quote",60211),radioTower:s("radio-tower",60212),reactions:s("reactions",60213),references:s("references",60214),refresh:s("refresh",60215),regex:s("regex",60216),remoteExplorer:s("remote-explorer",60217),remote:s("remote",60218),remove:s("remove",60219),replaceAll:s("replace-all",60220),replace:s("replace",60221),repoClone:s("repo-clone",60222),repoForcePush:s("repo-force-push",60223),repoPull:s("repo-pull",60224),repoPush:s("repo-push",60225),report:s("report",60226),requestChanges:s("request-changes",60227),rocket:s("rocket",60228),rootFolderOpened:s("root-folder-opened",60229),rootFolder:s("root-folder",60230),rss:s("rss",60231),ruby:s("ruby",60232),saveAll:s("save-all",60233),saveAs:s("save-as",60234),save:s("save",60235),screenFull:s("screen-full",60236),screenNormal:s("screen-normal",60237),searchStop:s("search-stop",60238),server:s("server",60240),settingsGear:s("settings-gear",60241),settings:s("settings",60242),shield:s("shield",60243),smiley:s("smiley",60244),sortPrecedence:s("sort-precedence",60245),splitHorizontal:s("split-horizontal",60246),splitVertical:s("split-vertical",60247),squirrel:s("squirrel",60248),starFull:s("star-full",60249),starHalf:s("star-half",60250),symbolClass:s("symbol-class",60251),symbolColor:s("symbol-color",60252),symbolCustomColor:s("symbol-customcolor",60252),symbolConstant:s("symbol-constant",60253),symbolEnumMember:s("symbol-enum-member",60254),symbolField:s("symbol-field",60255),symbolFile:s("symbol-file",60256),symbolInterface:s("symbol-interface",60257),symbolKeyword:s("symbol-keyword",60258),symbolMisc:s("symbol-misc",60259),symbolOperator:s("symbol-operator",60260),symbolProperty:s("symbol-property",60261),wrench:s("wrench",60261),wrenchSubaction:s("wrench-subaction",60261),symbolSnippet:s("symbol-snippet",60262),tasklist:s("tasklist",60263),telescope:s("telescope",60264),textSize:s("text-size",60265),threeBars:s("three-bars",60266),thumbsdown:s("thumbsdown",60267),thumbsup:s("thumbsup",60268),tools:s("tools",60269),triangleDown:s("triangle-down",60270),triangleLeft:s("triangle-left",60271),triangleRight:s("triangle-right",60272),triangleUp:s("triangle-up",60273),twitter:s("twitter",60274),unfold:s("unfold",60275),unlock:s("unlock",60276),unmute:s("unmute",60277),unverified:s("unverified",60278),verified:s("verified",60279),versions:s("versions",60280),vmActive:s("vm-active",60281),vmOutline:s("vm-outline",60282),vmRunning:s("vm-running",60283),watch:s("watch",60284),whitespace:s("whitespace",60285),wholeWord:s("whole-word",60286),window:s("window",60287),wordWrap:s("word-wrap",60288),zoomIn:s("zoom-in",60289),zoomOut:s("zoom-out",60290),listFilter:s("list-filter",60291),listFlat:s("list-flat",60292),listSelection:s("list-selection",60293),selection:s("selection",60293),listTree:s("list-tree",60294),debugBreakpointFunctionUnverified:s("debug-breakpoint-function-unverified",60295),debugBreakpointFunction:s("debug-breakpoint-function",60296),debugBreakpointFunctionDisabled:s("debug-breakpoint-function-disabled",60296),debugStackframeActive:s("debug-stackframe-active",60297),circleSmallFilled:s("circle-small-filled",60298),debugStackframeDot:s("debug-stackframe-dot",60298),debugStackframe:s("debug-stackframe",60299),debugStackframeFocused:s("debug-stackframe-focused",60299),debugBreakpointUnsupported:s("debug-breakpoint-unsupported",60300),symbolString:s("symbol-string",60301),debugReverseContinue:s("debug-reverse-continue",60302),debugStepBack:s("debug-step-back",60303),debugRestartFrame:s("debug-restart-frame",60304),callIncoming:s("call-incoming",60306),callOutgoing:s("call-outgoing",60307),menu:s("menu",60308),expandAll:s("expand-all",60309),feedback:s("feedback",60310),groupByRefType:s("group-by-ref-type",60311),ungroupByRefType:s("ungroup-by-ref-type",60312),account:s("account",60313),bellDot:s("bell-dot",60314),debugConsole:s("debug-console",60315),library:s("library",60316),output:s("output",60317),runAll:s("run-all",60318),syncIgnored:s("sync-ignored",60319),pinned:s("pinned",60320),githubInverted:s("github-inverted",60321),debugAlt:s("debug-alt",60305),serverProcess:s("server-process",60322),serverEnvironment:s("server-environment",60323),pass:s("pass",60324),stopCircle:s("stop-circle",60325),playCircle:s("play-circle",60326),record:s("record",60327),debugAltSmall:s("debug-alt-small",60328),vmConnect:s("vm-connect",60329),cloud:s("cloud",60330),merge:s("merge",60331),exportIcon:s("export",60332),graphLeft:s("graph-left",60333),magnet:s("magnet",60334),notebook:s("notebook",60335),redo:s("redo",60336),checkAll:s("check-all",60337),pinnedDirty:s("pinned-dirty",60338),passFilled:s("pass-filled",60339),circleLargeFilled:s("circle-large-filled",60340),circleLarge:s("circle-large",60341),circleLargeOutline:s("circle-large-outline",60341),combine:s("combine",60342),gather:s("gather",60342),table:s("table",60343),variableGroup:s("variable-group",60344),typeHierarchy:s("type-hierarchy",60345),typeHierarchySub:s("type-hierarchy-sub",60346),typeHierarchySuper:s("type-hierarchy-super",60347),gitPullRequestCreate:s("git-pull-request-create",60348),runAbove:s("run-above",60349),runBelow:s("run-below",60350),notebookTemplate:s("notebook-template",60351),debugRerun:s("debug-rerun",60352),workspaceTrusted:s("workspace-trusted",60353),workspaceUntrusted:s("workspace-untrusted",60354),workspaceUnspecified:s("workspace-unspecified",60355),terminalCmd:s("terminal-cmd",60356),terminalDebian:s("terminal-debian",60357),terminalLinux:s("terminal-linux",60358),terminalPowershell:s("terminal-powershell",60359),terminalTmux:s("terminal-tmux",60360),terminalUbuntu:s("terminal-ubuntu",60361),terminalBash:s("terminal-bash",60362),arrowSwap:s("arrow-swap",60363),copy:s("copy",60364),personAdd:s("person-add",60365),filterFilled:s("filter-filled",60366),wand:s("wand",60367),debugLineByLine:s("debug-line-by-line",60368),inspect:s("inspect",60369),layers:s("layers",60370),layersDot:s("layers-dot",60371),layersActive:s("layers-active",60372),compass:s("compass",60373),compassDot:s("compass-dot",60374),compassActive:s("compass-active",60375),azure:s("azure",60376),issueDraft:s("issue-draft",60377),gitPullRequestClosed:s("git-pull-request-closed",60378),gitPullRequestDraft:s("git-pull-request-draft",60379),debugAll:s("debug-all",60380),debugCoverage:s("debug-coverage",60381),runErrors:s("run-errors",60382),folderLibrary:s("folder-library",60383),debugContinueSmall:s("debug-continue-small",60384),beakerStop:s("beaker-stop",60385),graphLine:s("graph-line",60386),graphScatter:s("graph-scatter",60387),pieChart:s("pie-chart",60388),bracketDot:s("bracket-dot",60389),bracketError:s("bracket-error",60390),lockSmall:s("lock-small",60391),azureDevops:s("azure-devops",60392),verifiedFilled:s("verified-filled",60393),newLine:s("newline",60394),layout:s("layout",60395),layoutActivitybarLeft:s("layout-activitybar-left",60396),layoutActivitybarRight:s("layout-activitybar-right",60397),layoutPanelLeft:s("layout-panel-left",60398),layoutPanelCenter:s("layout-panel-center",60399),layoutPanelJustify:s("layout-panel-justify",60400),layoutPanelRight:s("layout-panel-right",60401),layoutPanel:s("layout-panel",60402),layoutSidebarLeft:s("layout-sidebar-left",60403),layoutSidebarRight:s("layout-sidebar-right",60404),layoutStatusbar:s("layout-statusbar",60405),layoutMenubar:s("layout-menubar",60406),layoutCentered:s("layout-centered",60407),layoutSidebarRightOff:s("layout-sidebar-right-off",60416),layoutPanelOff:s("layout-panel-off",60417),layoutSidebarLeftOff:s("layout-sidebar-left-off",60418),target:s("target",60408),indent:s("indent",60409),recordSmall:s("record-small",60410),errorSmall:s("error-small",60411),arrowCircleDown:s("arrow-circle-down",60412),arrowCircleLeft:s("arrow-circle-left",60413),arrowCircleRight:s("arrow-circle-right",60414),arrowCircleUp:s("arrow-circle-up",60415),heartFilled:s("heart-filled",60420),map:s("map",60421),mapFilled:s("map-filled",60422),circleSmall:s("circle-small",60423),bellSlash:s("bell-slash",60424),bellSlashDot:s("bell-slash-dot",60425),commentUnresolved:s("comment-unresolved",60426),gitPullRequestGoToChanges:s("git-pull-request-go-to-changes",60427),gitPullRequestNewChanges:s("git-pull-request-new-changes",60428),searchFuzzy:s("search-fuzzy",60429),commentDraft:s("comment-draft",60430),send:s("send",60431),sparkle:s("sparkle",60432),insert:s("insert",60433),dialogError:s("dialog-error","error"),dialogWarning:s("dialog-warning","warning"),dialogInfo:s("dialog-info","info"),dialogClose:s("dialog-close","close"),treeItemExpanded:s("tree-item-expanded","chevron-down"),treeFilterOnTypeOn:s("tree-filter-on-type-on","list-filter"),treeFilterOnTypeOff:s("tree-filter-on-type-off","list-selection"),treeFilterClear:s("tree-filter-clear","close"),treeItemLoading:s("tree-item-loading","loading"),menuSelection:s("menu-selection","check"),menuSubmenu:s("menu-submenu","chevron-right"),menuBarMore:s("menubar-more","more"),scrollbarButtonLeft:s("scrollbar-button-left","triangle-left"),scrollbarButtonRight:s("scrollbar-button-right","triangle-right"),scrollbarButtonUp:s("scrollbar-button-up","triangle-up"),scrollbarButtonDown:s("scrollbar-button-down","triangle-down"),toolBarMore:s("toolbar-more","more"),quickInputBack:s("quick-input-back","arrow-left")}},7863:(e,t,i)=>{function n(e,t){const i=Math.pow(10,t);return Math.round(e*i)/i}i.d(t,{Q1:()=>a,bU:()=>o,hB:()=>s});class o{constructor(e,t,i,o=1){this._rgbaBrand=void 0,this.r=0|Math.min(255,Math.max(0,e)),this.g=0|Math.min(255,Math.max(0,t)),this.b=0|Math.min(255,Math.max(0,i)),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.r===t.r&&e.g===t.g&&e.b===t.b&&e.a===t.a}}class s{constructor(e,t,i,o){this._hslaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.l=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.l===t.l&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=e.a,r=Math.max(t,i,n),a=Math.min(t,i,n);let l=0,h=0;const c=(a+r)/2,d=r-a;if(d>0){switch(h=Math.min(c<=.5?d/(2*c):d/(2-2*c),1),r){case t:l=(i-n)/d+(i<n?6:0);break;case i:l=(n-t)/d+2;break;case n:l=(t-i)/d+4}l*=60,l=Math.round(l)}return new s(l,h,c,o)}static _hue2rgb(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e}static toRGBA(e){const t=e.h/360,{s:i,l:n,a:r}=e;let a,l,h;if(0===i)a=l=h=n;else{const e=n<.5?n*(1+i):n+i-n*i,o=2*n-e;a=s._hue2rgb(o,e,t+1/3),l=s._hue2rgb(o,e,t),h=s._hue2rgb(o,e,t-1/3)}return new o(Math.round(255*a),Math.round(255*l),Math.round(255*h),r)}}class r{constructor(e,t,i,o){this._hsvaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.v=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.v===t.v&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=Math.max(t,i,n),s=o-Math.min(t,i,n),a=0===o?0:s/o;let l;return l=0===s?0:o===t?((i-n)/s%6+6)%6:o===i?(n-t)/s+2:(t-i)/s+4,new r(Math.round(60*l),a,o,e.a)}static toRGBA(e){const{h:t,s:i,v:n,a:s}=e,r=n*i,a=r*(1-Math.abs(t/60%2-1)),l=n-r;let[h,c,d]=[0,0,0];return t<60?(h=r,c=a):t<120?(h=a,c=r):t<180?(c=r,d=a):t<240?(c=a,d=r):t<300?(h=a,d=r):t<=360&&(h=r,d=a),h=Math.round(255*(h+l)),c=Math.round(255*(c+l)),d=Math.round(255*(d+l)),new o(h,c,d,s)}}class a{static fromHex(e){return a.Format.CSS.parseHex(e)||a.red}static equals(e,t){return!e&&!t||!(!e||!t)&&e.equals(t)}get hsla(){return this._hsla?this._hsla:s.fromRGBA(this.rgba)}get hsva(){return this._hsva?this._hsva:r.fromRGBA(this.rgba)}constructor(e){if(!e)throw new Error("Color needs a value");if(e instanceof o)this.rgba=e;else if(e instanceof s)this._hsla=e,this.rgba=s.toRGBA(e);else{if(!(e instanceof r))throw new Error("Invalid color ctor argument");this._hsva=e,this.rgba=r.toRGBA(e)}}equals(e){return!!e&&o.equals(this.rgba,e.rgba)&&s.equals(this.hsla,e.hsla)&&r.equals(this.hsva,e.hsva)}getRelativeLuminance(){return n(.2126*a._relativeLuminanceForComponent(this.rgba.r)+.7152*a._relativeLuminanceForComponent(this.rgba.g)+.0722*a._relativeLuminanceForComponent(this.rgba.b),4)}static _relativeLuminanceForComponent(e){const t=e/255;return t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4)}isLighter(){return(299*this.rgba.r+587*this.rgba.g+114*this.rgba.b)/1e3>=128}isLighterThan(e){return this.getRelativeLuminance()>e.getRelativeLuminance()}isDarkerThan(e){return this.getRelativeLuminance()<e.getRelativeLuminance()}lighten(e){return new a(new s(this.hsla.h,this.hsla.s,this.hsla.l+this.hsla.l*e,this.hsla.a))}darken(e){return new a(new s(this.hsla.h,this.hsla.s,this.hsla.l-this.hsla.l*e,this.hsla.a))}transparent(e){const{r:t,g:i,b:n,a:s}=this.rgba;return new a(new o(t,i,n,s*e))}isTransparent(){return 0===this.rgba.a}isOpaque(){return 1===this.rgba.a}opposite(){return new a(new o(255-this.rgba.r,255-this.rgba.g,255-this.rgba.b,this.rgba.a))}makeOpaque(e){if(this.isOpaque()||1!==e.rgba.a)return this;const{r:t,g:i,b:n,a:s}=this.rgba;return new a(new o(e.rgba.r-s*(e.rgba.r-t),e.rgba.g-s*(e.rgba.g-i),e.rgba.b-s*(e.rgba.b-n),1))}toString(){return this._toString||(this._toString=a.Format.CSS.format(this)),this._toString}static getLighterColor(e,t,i){if(e.isLighterThan(t))return e;i=i||.5;const n=e.getRelativeLuminance(),o=t.getRelativeLuminance();return i=i*(o-n)/o,e.lighten(i)}static getDarkerColor(e,t,i){if(e.isDarkerThan(t))return e;i=i||.5;const n=e.getRelativeLuminance();return i=i*(n-t.getRelativeLuminance())/n,e.darken(i)}}a.white=new a(new o(255,255,255,1)),a.black=new a(new o(0,0,0,1)),a.red=new a(new o(255,0,0,1)),a.blue=new a(new o(0,0,255,1)),a.green=new a(new o(0,255,0,1)),a.cyan=new a(new o(0,255,255,1)),a.lightgrey=new a(new o(211,211,211,1)),a.transparent=new a(new o(0,0,0,0)),function(e){let t;!function(t){let i;!function(t){function i(e){const t=e.toString(16);return 2!==t.length?"0"+t:t}function n(e){switch(e){case 48:return 0;case 49:return 1;case 50:return 2;case 51:return 3;case 52:return 4;case 53:return 5;case 54:return 6;case 55:return 7;case 56:return 8;case 57:return 9;case 97:case 65:return 10;case 98:case 66:return 11;case 99:case 67:return 12;case 100:case 68:return 13;case 101:case 69:return 14;case 102:case 70:return 15}return 0}t.formatRGB=function(t){return 1===t.rgba.a?`rgb(${t.rgba.r}, ${t.rgba.g}, ${t.rgba.b})`:e.Format.CSS.formatRGBA(t)},t.formatRGBA=function(e){return`rgba(${e.rgba.r}, ${e.rgba.g}, ${e.rgba.b}, ${+e.rgba.a.toFixed(2)})`},t.formatHSL=function(t){return 1===t.hsla.a?`hsl(${t.hsla.h}, ${(100*t.hsla.s).toFixed(2)}%, ${(100*t.hsla.l).toFixed(2)}%)`:e.Format.CSS.formatHSLA(t)},t.formatHSLA=function(e){return`hsla(${e.hsla.h}, ${(100*e.hsla.s).toFixed(2)}%, ${(100*e.hsla.l).toFixed(2)}%, ${e.hsla.a.toFixed(2)})`},t.formatHex=function(e){return`#${i(e.rgba.r)}${i(e.rgba.g)}${i(e.rgba.b)}`},t.formatHexA=function(t,n=!1){return n&&1===t.rgba.a?e.Format.CSS.formatHex(t):`#${i(t.rgba.r)}${i(t.rgba.g)}${i(t.rgba.b)}${i(Math.round(255*t.rgba.a))}`},t.format=function(t){return t.isOpaque()?e.Format.CSS.formatHex(t):e.Format.CSS.formatRGBA(t)},t.parseHex=function(t){const i=t.length;if(0===i)return null;if(35!==t.charCodeAt(0))return null;if(7===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),s=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),r=16*n(t.charCodeAt(5))+n(t.charCodeAt(6));return new e(new o(i,s,r,1))}if(9===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),s=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),r=16*n(t.charCodeAt(5))+n(t.charCodeAt(6)),a=16*n(t.charCodeAt(7))+n(t.charCodeAt(8));return new e(new o(i,s,r,a/255))}if(4===i){const i=n(t.charCodeAt(1)),s=n(t.charCodeAt(2)),r=n(t.charCodeAt(3));return new e(new o(16*i+i,16*s+s,16*r+r))}if(5===i){const i=n(t.charCodeAt(1)),s=n(t.charCodeAt(2)),r=n(t.charCodeAt(3)),a=n(t.charCodeAt(4));return new e(new o(16*i+i,16*s+s,16*r+r,(16*a+a)/255))}return null}}(i=t.CSS||(t.CSS={}))}(t=e.Format||(e.Format={}))}(a||(a={}))},8844:(e,t,i)=>{function n(e,t,i){let n=null,o=null;if("function"==typeof i.value?(n="value",o=i.value,0!==o.length&&console.warn("Memoize should only be used in functions with zero parameters")):"function"==typeof i.get&&(n="get",o=i.get),!o)throw new Error("not supported");const s=`$memoize$${t}`;i[n]=function(...e){return this.hasOwnProperty(s)||Object.defineProperty(this,s,{configurable:!1,enumerable:!1,writable:!1,value:o.apply(this,e)}),this[s]}}i.d(t,{B:()=>n})},3329:(e,t,i)=>{i.d(t,{AL:()=>h,D7:()=>p,EM:()=>g,MB:()=>l,M_:()=>s,Qg:()=>d,aD:()=>c,cU:()=>r,dz:()=>o,iH:()=>u});const n=new class{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(e){setTimeout((()=>{if(e.stack){if(m.isErrorNoTelemetry(e))throw new m(e.message+"\n\n"+e.stack);throw new Error(e.message+"\n\n"+e.stack)}throw e}),0)}}emit(e){this.listeners.forEach((t=>{t(e)}))}onUnexpectedError(e){this.unexpectedErrorHandler(e),this.emit(e)}onUnexpectedExternalError(e){this.unexpectedErrorHandler(e)}};function o(e){l(e)||n.onUnexpectedError(e)}function s(e){l(e)||n.onUnexpectedExternalError(e)}function r(e){if(e instanceof Error){const{name:t,message:i}=e;return{$isError:!0,name:t,message:i,stack:e.stacktrace||e.stack,noTelemetry:m.isErrorNoTelemetry(e)}}return e}const a="Canceled";function l(e){return e instanceof h||e instanceof Error&&e.name===a&&e.message===a}class h extends Error{constructor(){super(a),this.name=this.message}}function c(){const e=new Error(a);return e.name=e.message,e}function d(e){return e?new Error(`Illegal argument: ${e}`):new Error("Illegal argument")}function u(e){return e?new Error(`Illegal state: ${e}`):new Error("Illegal state")}class g extends Error{constructor(e){super("NotSupported"),e&&(this.message=e)}}class m extends Error{constructor(e){super(e),this.name="CodeExpectedError"}static fromError(e){if(e instanceof m)return e;const t=new m;return t.message=e.message,t.stack=e.stack,t}static isErrorNoTelemetry(e){return"CodeExpectedError"===e.name}}class p extends Error{constructor(e){super(e||"An unexpected bug occurred."),Object.setPrototypeOf(this,p.prototype)}}},3884:(e,t,i)=>{i.d(t,{Jh:()=>n,QT:()=>_,Wj:()=>b,at:()=>w,ci:()=>g,fV:()=>f,uI:()=>A,vl:()=>u});var n,o=i(3329),s=i(8300),r=i(6423),a=i(3839);!function(e){function t(e){return(t,i=null,n)=>{let o,s=!1;return o=e((e=>{if(!s)return o?o.dispose():s=!0,t.call(i,e)}),null,n),s&&o.dispose(),o}}function i(e,t,i){return a(((i,n=null,o)=>e((e=>i.call(n,t(e))),null,o)),i)}function n(e,t,i){return a(((i,n=null,o)=>e((e=>{t(e),i.call(n,e)}),null,o)),i)}function o(e,t,i){return a(((i,n=null,o)=>e((e=>t(e)&&i.call(n,e)),null,o)),i)}function r(e,t,n,o){let s=n;return i(e,(e=>(s=t(s,e),s)),o)}function a(e,t){let i;const n=new u({onWillAddFirstListener(){i=e(n.fire,n)},onDidRemoveLastListener(){null==i||i.dispose()}});return null==t||t.add(n),n.event}function l(e,t,i=100,n=!1,o=!1,s,r){let a,l,h,c,d=0;const g=new u({leakWarningThreshold:s,onWillAddFirstListener(){a=e((e=>{d++,l=t(l,e),n&&!h&&(g.fire(l),l=void 0),c=()=>{const e=l;l=void 0,h=void 0,(!n||d>1)&&g.fire(e),d=0},"number"==typeof i?(clearTimeout(h),h=setTimeout(c,i)):void 0===h&&(h=0,queueMicrotask(c))}))},onWillRemoveListener(){o&&d>0&&(null==c||c())},onDidRemoveLastListener(){c=void 0,a.dispose()}});return null==r||r.add(g),g.event}function h(e,t=(e,t)=>e===t,i){let n,s=!0;return o(e,(e=>{const i=s||!t(e,n);return s=!1,n=e,i}),i)}e.None=()=>s.jG.None,e.defer=function(e,t){return l(e,(()=>{}),0,void 0,!0,void 0,t)},e.once=t,e.map=i,e.forEach=n,e.filter=o,e.signal=function(e){return e},e.any=function(...e){return(t,i=null,n)=>(0,s.qE)(...e.map((e=>e((e=>t.call(i,e)),null,n))))},e.reduce=r,e.debounce=l,e.accumulate=function(t,i=0,n){return e.debounce(t,((e,t)=>e?(e.push(t),e):[t]),i,void 0,!0,void 0,n)},e.latch=h,e.split=function(t,i,n){return[e.filter(t,i,n),e.filter(t,(e=>!i(e)),n)]},e.buffer=function(e,t=!1,i=[]){let n=i.slice(),o=e((e=>{n?n.push(e):r.fire(e)}));const s=()=>{null==n||n.forEach((e=>r.fire(e))),n=null},r=new u({onWillAddFirstListener(){o||(o=e((e=>r.fire(e))))},onDidAddFirstListener(){n&&(t?setTimeout(s):s())},onDidRemoveLastListener(){o&&o.dispose(),o=null}});return r.event};class c{constructor(e){this.event=e,this.disposables=new s.Cm}map(e){return new c(i(this.event,e,this.disposables))}forEach(e){return new c(n(this.event,e,this.disposables))}filter(e){return new c(o(this.event,e,this.disposables))}reduce(e,t){return new c(r(this.event,e,t,this.disposables))}latch(){return new c(h(this.event,void 0,this.disposables))}debounce(e,t=100,i=!1,n=!1,o){return new c(l(this.event,e,t,i,n,o,this.disposables))}on(e,t,i){return this.event(e,t,i)}once(e,i,n){return t(this.event)(e,i,n)}dispose(){this.disposables.dispose()}}e.chain=function(e){return new c(e)},e.fromNodeEventEmitter=function(e,t,i=e=>e){const n=(...e)=>o.fire(i(...e)),o=new u({onWillAddFirstListener:()=>e.on(t,n),onDidRemoveLastListener:()=>e.removeListener(t,n)});return o.event},e.fromDOMEventEmitter=function(e,t,i=e=>e){const n=(...e)=>o.fire(i(...e)),o=new u({onWillAddFirstListener:()=>e.addEventListener(t,n),onDidRemoveLastListener:()=>e.removeEventListener(t,n)});return o.event},e.toPromise=function(e){return new Promise((i=>t(e)(i)))},e.runAndSubscribe=function(e,t){return t(void 0),e((e=>t(e)))},e.runAndSubscribeWithStore=function(e,t){let i=null;function n(e){null==i||i.dispose(),i=new s.Cm,t(e,i)}n(void 0);const o=e((e=>n(e)));return(0,s.s)((()=>{o.dispose(),null==i||i.dispose()}))};class d{constructor(e,t){this._observable=e,this._counter=0,this._hasChanged=!1;const i={onWillAddFirstListener:()=>{e.addObserver(this)},onDidRemoveLastListener:()=>{e.removeObserver(this)}};this.emitter=new u(i),t&&t.add(this.emitter)}beginUpdate(e){this._counter++}handlePossibleChange(e){}handleChange(e,t){this._hasChanged=!0}endUpdate(e){this._counter--,0===this._counter&&(this._observable.reportChanges(),this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this._observable.get())))}}e.fromObservable=function(e,t){return new d(e,t).emitter.event},e.fromObservableLight=function(e){return t=>{let i=0,n=!1;const o={beginUpdate(){i++},endUpdate(){i--,0===i&&(e.reportChanges(),n&&(n=!1,t()))},handlePossibleChange(){},handleChange(){n=!0}};return e.addObserver(o),{dispose(){e.removeObserver(o)}}}}}(n||(n={}));class l{constructor(e){this.listenerCount=0,this.invocationCount=0,this.elapsedOverall=0,this.durations=[],this.name=`${e}_${l._idPool++}`,l.all.add(this)}start(e){this._stopWatch=new a.W(!0),this.listenerCount=e}stop(){if(this._stopWatch){const e=this._stopWatch.elapsed();this.durations.push(e),this.elapsedOverall+=e,this.invocationCount+=1,this._stopWatch=void 0}}}l.all=new Set,l._idPool=0;class h{constructor(e,t=Math.random().toString(18).slice(2,5)){this.threshold=e,this.name=t,this._warnCountdown=0}dispose(){var e;null===(e=this._stacks)||void 0===e||e.clear()}check(e,t){const i=this.threshold;if(i<=0||t<i)return;this._stacks||(this._stacks=new Map);const n=this._stacks.get(e.value)||0;if(this._stacks.set(e.value,n+1),this._warnCountdown-=1,this._warnCountdown<=0){let e;this._warnCountdown=.5*i;let n=0;for(const[t,i]of this._stacks)(!e||n<i)&&(e=t,n=i);console.warn(`[${this.name}] potential listener LEAK detected, having ${t} listeners already. MOST frequent listener (${n}):`),console.warn(e)}return()=>{const t=this._stacks.get(e.value)||0;this._stacks.set(e.value,t-1)}}}class c{static create(){var e;return new c(null!==(e=(new Error).stack)&&void 0!==e?e:"")}constructor(e){this.value=e}print(){console.warn(this.value.split("\n").slice(2).join("\n"))}}class d{constructor(e,t,i){this.callback=e,this.callbackThis=t,this.stack=i,this.subscription=new s.St}invoke(e){this.callback.call(this.callbackThis,e)}}class u{constructor(e){var t,i,n,o,s;this._disposed=!1,this._options=e,this._leakageMon=(null===(t=this._options)||void 0===t?void 0:t.leakWarningThreshold)?new h(null!==(n=null===(i=this._options)||void 0===i?void 0:i.leakWarningThreshold)&&void 0!==n?n:-1):void 0,this._perfMon=(null===(o=this._options)||void 0===o?void 0:o._profName)?new l(this._options._profName):void 0,this._deliveryQueue=null===(s=this._options)||void 0===s?void 0:s.deliveryQueue}dispose(){var e,t,i,n;this._disposed||(this._disposed=!0,this._listeners&&this._listeners.clear(),null===(e=this._deliveryQueue)||void 0===e||e.clear(this),null===(i=null===(t=this._options)||void 0===t?void 0:t.onDidRemoveLastListener)||void 0===i||i.call(t),null===(n=this._leakageMon)||void 0===n||n.dispose())}get event(){return this._event||(this._event=(e,t,i)=>{var n,o,a;if(this._listeners||(this._listeners=new r.w),this._leakageMon&&this._listeners.size>3*this._leakageMon.threshold)return console.warn(`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far`),s.jG.None;const l=this._listeners.isEmpty();let h,u;l&&(null===(n=this._options)||void 0===n?void 0:n.onWillAddFirstListener)&&this._options.onWillAddFirstListener(this),this._leakageMon&&this._listeners.size>=Math.ceil(.2*this._leakageMon.threshold)&&(u=c.create(),h=this._leakageMon.check(u,this._listeners.size+1));const g=new d(e,t,u),m=this._listeners.push(g);l&&(null===(o=this._options)||void 0===o?void 0:o.onDidAddFirstListener)&&this._options.onDidAddFirstListener(this),(null===(a=this._options)||void 0===a?void 0:a.onDidAddListener)&&this._options.onDidAddListener(this,e,t);const p=g.subscription.set((()=>{var e,t;null==h||h(),!this._disposed&&(null===(t=null===(e=this._options)||void 0===e?void 0:e.onWillRemoveListener)||void 0===t||t.call(e,this),m(),this._options&&this._options.onDidRemoveLastListener)&&(this._listeners&&!this._listeners.isEmpty()||this._options.onDidRemoveLastListener(this))}));return i instanceof s.Cm?i.add(p):Array.isArray(i)&&i.push(p),p}),this._event}fire(e){var t,i,n;if(this._listeners){this._deliveryQueue||(this._deliveryQueue=new m(null===(t=this._options)||void 0===t?void 0:t.onListenerError));for(const t of this._listeners)this._deliveryQueue.push(this,t,e);null===(i=this._perfMon)||void 0===i||i.start(this._deliveryQueue.size),this._deliveryQueue.deliver(),null===(n=this._perfMon)||void 0===n||n.stop()}}hasListeners(){return!!this._listeners&&!this._listeners.isEmpty()}}class g{constructor(e=o.dz){this._onListenerError=e,this._queue=new r.w}get size(){return this._queue.size}push(e,t,i){this._queue.push(new p(e,t,i))}clear(e){const t=new r.w;for(const i of this._queue)i.emitter!==e&&t.push(i);this._queue=t}deliver(){for(;this._queue.size>0;){const e=this._queue.shift();try{e.listener.invoke(e.event)}catch(e){this._onListenerError(e)}}}}class m extends g{clear(e){this._queue.clear()}}class p{constructor(e,t,i){this.emitter=e,this.listener=t,this.event=i}}class f extends u{constructor(e){super(e),this._isPaused=0,this._eventQueue=new r.w,this._mergeFn=null==e?void 0:e.merge}pause(){this._isPaused++}resume(){if(0!==this._isPaused&&0==--this._isPaused)if(this._mergeFn){if(this._eventQueue.size>0){const e=Array.from(this._eventQueue);this._eventQueue.clear(),super.fire(this._mergeFn(e))}}else for(;!this._isPaused&&0!==this._eventQueue.size;)super.fire(this._eventQueue.shift())}fire(e){this._listeners&&(0!==this._isPaused?this._eventQueue.push(e):super.fire(e))}}class A extends f{constructor(e){var t;super(e),this._delay=null!==(t=e.delay)&&void 0!==t?t:100}fire(e){this._handle||(this.pause(),this._handle=setTimeout((()=>{this._handle=void 0,this.resume()}),this._delay)),super.fire(e)}}class _ extends u{constructor(e){super(e),this._queuedEvents=[],this._mergeFn=null==e?void 0:e.merge}fire(e){this.hasListeners()&&(this._queuedEvents.push(e),1===this._queuedEvents.length&&queueMicrotask((()=>{this._mergeFn?super.fire(this._mergeFn(this._queuedEvents)):this._queuedEvents.forEach((e=>super.fire(e))),this._queuedEvents=[]})))}}class w{constructor(){this.buffers=[]}wrapEvent(e){return(t,i,n)=>e((e=>{const n=this.buffers[this.buffers.length-1];n?n.push((()=>t.call(i,e))):t.call(i,e)}),void 0,n)}bufferEvents(e){const t=[];this.buffers.push(t);const i=e();return this.buffers.pop(),t.forEach((e=>e())),i}}class b{constructor(){this.listening=!1,this.inputEvent=n.None,this.inputEventListener=s.jG.None,this.emitter=new u({onDidAddFirstListener:()=>{this.listening=!0,this.inputEventListener=this.inputEvent(this.emitter.fire,this.emitter)},onDidRemoveLastListener:()=>{this.listening=!1,this.inputEventListener.dispose()}}),this.event=this.emitter.event}set input(e){this.inputEvent=e,this.listening&&(this.inputEventListener.dispose(),this.inputEventListener=e(this.emitter.fire,this.emitter))}dispose(){this.inputEventListener.dispose(),this.emitter.dispose()}}},7224:(e,t,i)=>{i.d(t,{No:()=>u,TH:()=>a,Zn:()=>h,_1:()=>c,kb:()=>l});var n=i(1331),o=i(4541),s=i(5306);function r(e){return 47===e||92===e}function a(e){return e.replace(/[\\/]/g,n.SA.sep)}function l(e){return-1===e.indexOf("/")&&(e=a(e)),/^[a-zA-Z]:(\/|$)/.test(e)&&(e="/"+e),e}function h(e,t=n.SA.sep){if(!e)return"";const i=e.length,o=e.charCodeAt(0);if(r(o)){if(r(e.charCodeAt(1))&&!r(e.charCodeAt(2))){let n=3;const o=n;for(;n<i&&!r(e.charCodeAt(n));n++);if(o!==n&&!r(e.charCodeAt(n+1)))for(n+=1;n<i;n++)if(r(e.charCodeAt(n)))return e.slice(0,n+1).replace(/[\\/]/g,t)}return t}if(d(o)&&58===e.charCodeAt(1))return r(e.charCodeAt(2))?e.slice(0,2)+t:e.slice(0,2);let s=e.indexOf("://");if(-1!==s)for(s+=3;s<i;s++)if(r(e.charCodeAt(s)))return e.slice(0,s+1);return""}function c(e,t,i,o=n.Vn){if(e===t)return!0;if(!e||!t)return!1;if(t.length>e.length)return!1;if(i){if(!(0,s.ns)(e,t))return!1;if(t.length===e.length)return!0;let i=t.length;return t.charAt(t.length-1)===o&&i--,e.charAt(i)===o}return t.charAt(t.length-1)!==o&&(t+=o),0===e.indexOf(t)}function d(e){return e>=65&&e<=90||e>=97&&e<=122}function u(e,t=o.uF){return!!t&&d(e.charCodeAt(0))&&58===e.charCodeAt(1)}},299:(e,t,i)=>{i.d(t,{Jo:()=>y,Nd:()=>z,WJ:()=>S,WP:()=>r,dt:()=>Q,ne:()=>P,uU:()=>W,yr:()=>C});var n=i(2154),o=i(5306);function s(...e){return function(t,i){for(let n=0,o=e.length;n<o;n++){const o=e[n](t,i);if(o)return o}return null}}a.bind(void 0,!1);const r=a.bind(void 0,!0);function a(e,t,i){if(!i||i.length<t.length)return null;let n;return n=e?o.ns(i,t):0===i.indexOf(t),n?t.length>0?[{start:0,end:t.length}]:[]:null}function l(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]===t[n]){let o=null;return(o=l(e,t,i+1,n+1))?p({start:n,end:n+1},o):null}return l(e,t,i,n+1)}function h(e){return 97<=e&&e<=122}function c(e){return 65<=e&&e<=90}function d(e){return 48<=e&&e<=57}function u(e){return 32===e||9===e||10===e||13===e}const g=new Set;function m(e){return h(e)||c(e)||d(e)}function p(e,t){return 0===t.length?t=[e]:e.end===t[0].start?t[0].start=e.start:t.unshift(e),t}function f(e,t){for(let i=t;i<e.length;i++){const t=e.charCodeAt(i);if(c(t)||d(t)||i>0&&!m(e.charCodeAt(i-1)))return i}return e.length}function A(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]!==t[n].toLowerCase())return null;{let o=null,s=n+1;for(o=A(e,t,i+1,n+1);!o&&(s=f(t,s))<t.length;)o=A(e,t,i+1,s),s++;return null===o?null:p({start:n,end:n+1},o)}}function _(e,t){if(!t)return null;if(0===(t=t.trim()).length)return null;if(!function(e){let t=0,i=0,n=0,o=0;for(let s=0;s<e.length;s++)n=e.charCodeAt(s),c(n)&&t++,h(n)&&i++,u(n)&&o++;return 0!==t&&0!==i||0!==o?t<=5:e.length<=30}(e))return null;if(t.length>60)return null;const i=function(e){let t=0,i=0,n=0,o=0,s=0;for(let r=0;r<e.length;r++)s=e.charCodeAt(r),c(s)&&t++,h(s)&&i++,m(s)&&n++,d(s)&&o++;return{upperPercent:t/e.length,lowerPercent:i/e.length,alphaPercent:n/e.length,numericPercent:o/e.length}}(t);if(!function(e){const{upperPercent:t,lowerPercent:i,alphaPercent:n,numericPercent:o}=e;return i>.2&&t<.8&&n>.6&&o<.2}(i)){if(!function(e){const{upperPercent:t,lowerPercent:i}=e;return 0===i&&t>.6}(i))return null;t=t.toLowerCase()}let n=null,o=0;for(e=e.toLowerCase();o<t.length&&null===(n=A(e,t,0,o));)o=f(t,o+1);return n}"()[]{}<>`'\"-/;:,.?!".split("").forEach((e=>g.add(e.charCodeAt(0))));const w=s(r,_,(function(e,t){const i=t.toLowerCase().indexOf(e.toLowerCase());return-1===i?null:[{start:i,end:i+e.length}]})),b=s(r,_,(function(e,t){return l(e.toLowerCase(),t.toLowerCase(),0,0)})),v=new n.qK(1e4);function C(e,t,i=!1){if("string"!=typeof e||"string"!=typeof t)return null;let n=v.get(e);n||(n=new RegExp(o.Bm(e),"i"),v.set(e,n));const s=n.exec(t);return s?[{start:s.index,end:s.index+s[0].length}]:i?b(e,t):w(e,t)}function y(e,t,i,n,o,s){const r=Math.min(13,e.length);for(;i<r;i++){const r=Q(e,t,i,n,o,s,{firstMatchCanBeWeak:!0,boostFullMatch:!0});if(r)return r}return[0,s]}function S(e){if(void 0===e)return[];const t=[],i=e[1];for(let n=e.length-1;n>1;n--){const o=e[n]+i,s=t[t.length-1];s&&s.end===o?s.end=o+1:t.push({start:o,end:o+1})}return t}const k=128;function E(){const e=[],t=[];for(let e=0;e<=k;e++)t[e]=0;for(let i=0;i<=k;i++)e.push(t.slice(0));return e}function D(e){const t=[];for(let i=0;i<=e;i++)t[i]=0;return t}const x=D(2*k),L=D(2*k),M=E(),I=E(),B=E(),N=!1;function T(e,t,i,n,o){function s(e,t,i=" "){for(;e.length<t;)e=i+e;return e}let r=` |   |${n.split("").map((e=>s(e,3))).join("|")}\n`;for(let n=0;n<=i;n++)r+=0===n?" |":`${t[n-1]}|`,r+=e[n].slice(0,o+1).map((e=>s(e.toString(),3))).join("|")+"\n";return r}function F(e,t){if(t<0||t>=e.length)return!1;const i=e.codePointAt(t);switch(i){case 95:case 45:case 46:case 32:case 47:case 92:case 39:case 34:case 58:case 36:case 60:case 62:case 40:case 41:case 91:case 93:case 123:case 125:return!0;case void 0:return!1;default:return!!o.Ss(i)}}function R(e,t){if(t<0||t>=e.length)return!1;switch(e.charCodeAt(t)){case 32:case 9:return!0;default:return!1}}function O(e,t,i){return t[e]!==i[e]}var P;!function(e){e.Default=[-100,0],e.isDefault=function(e){return!e||2===e.length&&-100===e[0]&&0===e[1]}}(P||(P={}));class z{constructor(e,t){this.firstMatchCanBeWeak=e,this.boostFullMatch=t}}function Q(e,t,i,n,o,s,r=z.default){const a=e.length>k?k:e.length,l=n.length>k?k:n.length;if(i>=a||s>=l||a-i>l-s)return;if(!function(e,t,i,n,o,s,r=!1){for(;t<i&&o<s;)e[t]===n[o]&&(r&&(x[t]=o),t+=1),o+=1;return t===i}(t,i,a,o,s,l,!0))return;!function(e,t,i,n,o,s){let r=e-1,a=t-1;for(;r>=i&&a>=n;)o[r]===s[a]&&(L[r]=a,r--),a--}(a,l,i,s,t,o);let h=1,c=1,d=i,u=s;const g=[!1];for(h=1,d=i;d<a;h++,d++){const r=x[d],m=L[d],p=d+1<a?L[d+1]:l;for(c=r-s+1,u=r;u<p;c++,u++){let a=Number.MIN_SAFE_INTEGER,p=!1;u<=m&&(a=H(e,t,d,i,n,o,u,l,s,0===M[h-1][c-1],g));let f=0;a!==Number.MAX_SAFE_INTEGER&&(p=!0,f=a+I[h-1][c-1]);const A=u>r,_=A?I[h][c-1]+(M[h][c-1]>0?-5:0):0,w=u>r+1&&M[h][c-1]>0,b=w?I[h][c-2]+(M[h][c-2]>0?-5:0):0;if(w&&(!A||b>=_)&&(!p||b>=f))I[h][c]=b,B[h][c]=3,M[h][c]=0;else if(A&&(!p||_>=f))I[h][c]=_,B[h][c]=2,M[h][c]=0;else{if(!p)throw new Error("not possible");I[h][c]=f,B[h][c]=1,M[h][c]=M[h-1][c-1]+1}}}if(N&&function(e,t,i,n){e=e.substr(t),i=i.substr(n),console.log(T(I,e,e.length,i,i.length)),console.log(T(B,e,e.length,i,i.length)),console.log(T(M,e,e.length,i,i.length))}(e,i,n,s),!g[0]&&!r.firstMatchCanBeWeak)return;h--,c--;const m=[I[h][c],s];let p=0,f=0;for(;h>=1;){let e=c;do{const t=B[h][e];if(3===t)e-=2;else{if(2!==t)break;e-=1}}while(e>=1);p>1&&t[i+h-1]===o[s+c-1]&&!O(e+s-1,n,o)&&p+1>M[h][e]&&(e=c),e===c?p++:p=1,f||(f=e),h--,c=e-1,m.push(c)}l===a&&r.boostFullMatch&&(m[0]+=2);const A=f-a;return m[0]-=A,m}function H(e,t,i,n,o,s,r,a,l,h,c){if(t[i]!==s[r])return Number.MIN_SAFE_INTEGER;let d=1,u=!1;return r===i-n?d=e[i]===o[r]?7:5:!O(r,o,s)||0!==r&&O(r-1,o,s)?!F(s,r)||0!==r&&F(s,r-1)?(F(s,r-1)||R(s,r-1))&&(d=5,u=!0):d=5:(d=e[i]===o[r]?7:5,u=!0),d>1&&i===n&&(c[0]=!0),u||(u=O(r,o,s)||F(s,r-1)||R(s,r-1)),i===n?r>l&&(d-=u?3:5):d+=h?u?2:0:u?0:1,r+1===a&&(d-=u?3:5),d}function W(e,t,i,n,o,s,r){return function(e,t,i,n,o,s,r,a){let l=Q(e,t,i,n,o,s,a);if(e.length>=3){const t=Math.min(7,e.length-1);for(let r=i+1;r<t;r++){const t=V(e,r);if(t){const e=Q(t,t.toLowerCase(),i,n,o,s,a);e&&(e[0]-=3,(!l||e[0]>l[0])&&(l=e))}}}return l}(e,t,i,n,o,s,0,r)}function V(e,t){if(t+1>=e.length)return;const i=e[t],n=e[t+1];return i!==n?e.slice(0,t)+n+i+e.slice(t+2):void 0}z.default={boostFullMatch:!0,firstMatchCanBeWeak:!1}},1387:(e,t,i)=>{function n(e){const t=this;let i,n=!1;return function(){return n||(n=!0,i=e.apply(t,arguments)),i}}i.d(t,{O:()=>n})},4509:(e,t,i)=>{i.d(t,{e2:()=>a,sN:()=>s,tW:()=>o,v7:()=>d});var n=i(5306);function o(e){return s(e,0)}function s(e,t){switch(typeof e){case"object":return null===e?r(349,t):Array.isArray(e)?(i=e,n=r(104579,n=t),i.reduce(((e,t)=>s(t,e)),n)):function(e,t){return t=r(181387,t),Object.keys(e).sort().reduce(((t,i)=>(t=a(i,t),s(e[i],t))),t)}(e,t);case"string":return a(e,t);case"boolean":return function(e,t){return r(e?433:863,t)}(e,t);case"number":return r(e,t);case"undefined":return r(937,t);default:return r(617,t)}var i,n}function r(e,t){return(t<<5)-t+e|0}function a(e,t){t=r(149417,t);for(let i=0,n=e.length;i<n;i++)t=r(e.charCodeAt(i),t);return t}function l(e,t,i=32){const n=i-t;return(e<<t|(~((1<<n)-1)&e)>>>n)>>>0}function h(e,t=0,i=e.byteLength,n=0){for(let o=0;o<i;o++)e[t+o]=n}function c(e,t=32){return e instanceof ArrayBuffer?Array.from(new Uint8Array(e)).map((e=>e.toString(16).padStart(2,"0"))).join(""):function(e,t,i="0"){for(;e.length<t;)e=i+e;return e}((e>>>0).toString(16),t/4)}class d{constructor(){this._h0=1732584193,this._h1=4023233417,this._h2=2562383102,this._h3=271733878,this._h4=3285377520,this._buff=new Uint8Array(67),this._buffDV=new DataView(this._buff.buffer),this._buffLen=0,this._totalLen=0,this._leftoverHighSurrogate=0,this._finished=!1}update(e){const t=e.length;if(0===t)return;const i=this._buff;let o,s,r=this._buffLen,a=this._leftoverHighSurrogate;for(0!==a?(o=a,s=-1,a=0):(o=e.charCodeAt(0),s=0);;){let l=o;if(n.pc(o)){if(!(s+1<t)){a=o;break}{const t=e.charCodeAt(s+1);n.LJ(t)?(s++,l=n.z_(o,t)):l=65533}}else n.LJ(o)&&(l=65533);if(r=this._push(i,r,l),s++,!(s<t))break;o=e.charCodeAt(s)}this._buffLen=r,this._leftoverHighSurrogate=a}_push(e,t,i){return i<128?e[t++]=i:i<2048?(e[t++]=192|(1984&i)>>>6,e[t++]=128|(63&i)>>>0):i<65536?(e[t++]=224|(61440&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0):(e[t++]=240|(1835008&i)>>>18,e[t++]=128|(258048&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0),t>=64&&(this._step(),t-=64,this._totalLen+=64,e[0]=e[64],e[1]=e[65],e[2]=e[66]),t}digest(){return this._finished||(this._finished=!0,this._leftoverHighSurrogate&&(this._leftoverHighSurrogate=0,this._buffLen=this._push(this._buff,this._buffLen,65533)),this._totalLen+=this._buffLen,this._wrapUp()),c(this._h0)+c(this._h1)+c(this._h2)+c(this._h3)+c(this._h4)}_wrapUp(){this._buff[this._buffLen++]=128,h(this._buff,this._buffLen),this._buffLen>56&&(this._step(),h(this._buff));const e=8*this._totalLen;this._buffDV.setUint32(56,Math.floor(e/4294967296),!1),this._buffDV.setUint32(60,e%4294967296,!1),this._step()}_step(){const e=d._bigBlock32,t=this._buffDV;for(let i=0;i<64;i+=4)e.setUint32(i,t.getUint32(i,!1),!1);for(let t=64;t<320;t+=4)e.setUint32(t,l(e.getUint32(t-12,!1)^e.getUint32(t-32,!1)^e.getUint32(t-56,!1)^e.getUint32(t-64,!1),1),!1);let i,n,o,s=this._h0,r=this._h1,a=this._h2,h=this._h3,c=this._h4;for(let t=0;t<80;t++)t<20?(i=r&a|~r&h,n=1518500249):t<40?(i=r^a^h,n=1859775393):t<60?(i=r&a|r&h|a&h,n=2400959708):(i=r^a^h,n=3395469782),o=l(s,5)+i+c+n+e.getUint32(4*t,!1)&4294967295,c=h,h=a,a=l(r,30),r=s,s=o;this._h0=this._h0+s&4294967295,this._h1=this._h1+r&4294967295,this._h2=this._h2+a&4294967295,this._h3=this._h3+h&4294967295,this._h4=this._h4+c&4294967295}}d._bigBlock32=new DataView(new ArrayBuffer(320))},5702:(e,t,i)=>{i.d(t,{Bc:()=>l,VS:()=>h,_W:()=>u,nI:()=>g,nK:()=>c,oO:()=>d});var n=i(3329),o=i(9804),s=i(9405),r=i(5306),a=i(6926);class l{constructor(e="",t=!1){var i,o,s;if(this.value=e,"string"!=typeof this.value)throw(0,n.Qg)("value");"boolean"==typeof t?(this.isTrusted=t,this.supportThemeIcons=!1,this.supportHtml=!1):(this.isTrusted=null!==(i=t.isTrusted)&&void 0!==i?i:void 0,this.supportThemeIcons=null!==(o=t.supportThemeIcons)&&void 0!==o&&o,this.supportHtml=null!==(s=t.supportHtml)&&void 0!==s&&s)}appendText(e,t=0){var i;return this.value+=(i=this.supportThemeIcons?(0,o.m2)(e):e,i.replace(/[\\`*_{}[\]()#+\-!~]/g,"\\$&")).replace(/([ \t]+)/g,((e,t)=>"&nbsp;".repeat(t.length))).replace(/\>/gm,"\\>").replace(/\n/g,1===t?"\\\n":"\n\n"),this}appendMarkdown(e){return this.value+=e,this}appendCodeblock(e,t){return this.value+="\n```",this.value+=e,this.value+="\n",this.value+=t,this.value+="\n```\n",this}appendLink(e,t,i){return this.value+="[",this.value+=this._escape(t,"]"),this.value+="](",this.value+=this._escape(String(e),")"),i&&(this.value+=` "${this._escape(this._escape(i,'"'),")")}"`),this.value+=")",this}_escape(e,t){const i=new RegExp((0,r.bm)(t),"g");return e.replace(i,((t,i)=>"\\"!==e.charAt(i-1)?`\\${t}`:t))}}function h(e){return e instanceof l||!(!e||"object"!=typeof e)&&!("string"!=typeof e.value||"boolean"!=typeof e.isTrusted&&"object"!=typeof e.isTrusted&&void 0!==e.isTrusted||"boolean"!=typeof e.supportThemeIcons&&void 0!==e.supportThemeIcons)}function c(e,t){return e===t||!(!e||!t)&&e.value===t.value&&e.isTrusted===t.isTrusted&&e.supportThemeIcons===t.supportThemeIcons&&e.supportHtml===t.supportHtml&&(e.baseUri===t.baseUri||!!e.baseUri&&!!t.baseUri&&(0,s.n4)(a.r.from(e.baseUri),a.r.from(t.baseUri)))}function d(e){return e.replace(/"/g,"&quot;")}function u(e){return e?e.replace(/\\([\\`*_{}[\]()#+\-.!~])/g,"$1"):e}function g(e){const t=[],i=e.split("|").map((e=>e.trim()));e=i[0];const n=i[1];if(n){const e=/height=(\d+)/.exec(n),i=/width=(\d+)/.exec(n),o=e?e[1]:"",s=i?i[1]:"",r=isFinite(parseInt(s)),a=isFinite(parseInt(o));r&&t.push(`width="${s}"`),a&&t.push(`height="${o}"`)}return{href:e,dimensions:t}}},9804:(e,t,i)=>{i.d(t,{R$:()=>m,_k:()=>f,m2:()=>h,pS:()=>g,pz:()=>A,sA:()=>d});var n=i(299),o=i(5306),s=i(3483);const r="$(",a=new RegExp(`\\$\\(${s.L.iconNameExpression}(?:${s.L.iconModifierExpression})?\\)`,"g"),l=new RegExp(`(\\\\)?${a.source}`,"g");function h(e){return e.replace(l,((e,t)=>t?e:`\\${e}`))}const c=new RegExp(`\\\\${a.source}`,"g");function d(e){return e.replace(c,(e=>`\\${e}`))}const u=new RegExp(`(\\s)?(\\\\)?${a.source}(\\s)?`,"g");function g(e){return-1===e.indexOf(r)?e:e.replace(u,((e,t,i,n)=>i?e:t||n||""))}function m(e){return e?e.replace(/\$\((.*?)\)/g,((e,t)=>` ${t} `)).trim():""}const p=new RegExp(`\\$\\(${s.L.iconNameCharacter}+\\)`,"g");function f(e){p.lastIndex=0;let t="";const i=[];let n=0;for(;;){const o=p.lastIndex,s=p.exec(e),r=e.substring(o,null==s?void 0:s.index);if(r.length>0){t+=r;for(let e=0;e<r.length;e++)i.push(n)}if(!s)break;n+=s[0].length}return{text:t,iconOffsets:i}}function A(e,t,i=!1){const{text:s,iconOffsets:r}=t;if(!r||0===r.length)return(0,n.yr)(e,s,i);const a=(0,o.NB)(s," "),l=s.length-a.length,h=(0,n.yr)(e,a,i);if(h)for(const e of h){const t=r[e.start+l]+l;e.start+=t,e.end+=t}return h}},9582:(e,t,i)=>{i.d(t,{n:()=>n,r:()=>o});class n{constructor(e){this._prefix=e,this._lastId=0}nextId(){return this._prefix+ ++this._lastId}}const o=new n("id#")},6037:(e,t,i)=>{i.d(t,{M:()=>o});var n=i(3884);const o=new class{constructor(){this._onDidChange=new n.vl,this.onDidChange=this._onDidChange.event,this._enabled=!0}get enabled(){return this._enabled}enable(){this._enabled=!0,this._onDidChange.fire()}disable(){this._enabled=!1,this._onDidChange.fire()}}},7580:(e,t,i)=>{var n;i.d(t,{f:()=>n}),function(e){function t(e){return e&&"object"==typeof e&&"function"==typeof e[Symbol.iterator]}e.is=t;const i=Object.freeze([]);function*n(e){yield e}e.empty=function(){return i},e.single=n,e.wrap=function(e){return t(e)?e:n(e)},e.from=function(e){return e||i},e.isEmpty=function(e){return!e||!0===e[Symbol.iterator]().next().done},e.first=function(e){return e[Symbol.iterator]().next().value},e.some=function(e,t){for(const i of e)if(t(i))return!0;return!1},e.find=function(e,t){for(const i of e)if(t(i))return i},e.filter=function*(e,t){for(const i of e)t(i)&&(yield i)},e.map=function*(e,t){let i=0;for(const n of e)yield t(n,i++)},e.concat=function*(...e){for(const t of e)for(const e of t)yield e},e.reduce=function(e,t,i){let n=i;for(const i of e)n=t(n,i);return n},e.slice=function*(e,t,i=e.length){for(t<0&&(t+=e.length),i<0?i+=e.length:i>e.length&&(i=e.length);t<i;t++)yield e[t]},e.consume=function(t,i=Number.POSITIVE_INFINITY){const n=[];if(0===i)return[n,t];const o=t[Symbol.iterator]();for(let t=0;t<i;t++){const t=o.next();if(t.done)return[n,e.empty()];n.push(t.value)}return[n,{[Symbol.iterator]:()=>o}]}}(n||(n={}))},9833:(e,t,i)=>{i.d(t,{Fo:()=>u,YM:()=>m,m5:()=>p,uw:()=>a});class n{constructor(){this._keyCodeToStr=[],this._strToKeyCode=Object.create(null)}define(e,t){this._keyCodeToStr[e]=t,this._strToKeyCode[t.toLowerCase()]=e}keyCodeToStr(e){return this._keyCodeToStr[e]}strToKeyCode(e){return this._strToKeyCode[e.toLowerCase()]||0}}const o=new n,s=new n,r=new n,a=new Array(230),l={},h=[],c=Object.create(null),d=Object.create(null),u=[],g=[];for(let e=0;e<=193;e++)u[e]=-1;for(let e=0;e<=132;e++)g[e]=-1;var m;function p(e,t){return(e|(65535&t)<<16>>>0)>>>0}!function(){const e="",t=[[1,0,"None",0,"unknown",0,"VK_UNKNOWN",e,e],[1,1,"Hyper",0,e,0,e,e,e],[1,2,"Super",0,e,0,e,e,e],[1,3,"Fn",0,e,0,e,e,e],[1,4,"FnLock",0,e,0,e,e,e],[1,5,"Suspend",0,e,0,e,e,e],[1,6,"Resume",0,e,0,e,e,e],[1,7,"Turbo",0,e,0,e,e,e],[1,8,"Sleep",0,e,0,"VK_SLEEP",e,e],[1,9,"WakeUp",0,e,0,e,e,e],[0,10,"KeyA",31,"A",65,"VK_A",e,e],[0,11,"KeyB",32,"B",66,"VK_B",e,e],[0,12,"KeyC",33,"C",67,"VK_C",e,e],[0,13,"KeyD",34,"D",68,"VK_D",e,e],[0,14,"KeyE",35,"E",69,"VK_E",e,e],[0,15,"KeyF",36,"F",70,"VK_F",e,e],[0,16,"KeyG",37,"G",71,"VK_G",e,e],[0,17,"KeyH",38,"H",72,"VK_H",e,e],[0,18,"KeyI",39,"I",73,"VK_I",e,e],[0,19,"KeyJ",40,"J",74,"VK_J",e,e],[0,20,"KeyK",41,"K",75,"VK_K",e,e],[0,21,"KeyL",42,"L",76,"VK_L",e,e],[0,22,"KeyM",43,"M",77,"VK_M",e,e],[0,23,"KeyN",44,"N",78,"VK_N",e,e],[0,24,"KeyO",45,"O",79,"VK_O",e,e],[0,25,"KeyP",46,"P",80,"VK_P",e,e],[0,26,"KeyQ",47,"Q",81,"VK_Q",e,e],[0,27,"KeyR",48,"R",82,"VK_R",e,e],[0,28,"KeyS",49,"S",83,"VK_S",e,e],[0,29,"KeyT",50,"T",84,"VK_T",e,e],[0,30,"KeyU",51,"U",85,"VK_U",e,e],[0,31,"KeyV",52,"V",86,"VK_V",e,e],[0,32,"KeyW",53,"W",87,"VK_W",e,e],[0,33,"KeyX",54,"X",88,"VK_X",e,e],[0,34,"KeyY",55,"Y",89,"VK_Y",e,e],[0,35,"KeyZ",56,"Z",90,"VK_Z",e,e],[0,36,"Digit1",22,"1",49,"VK_1",e,e],[0,37,"Digit2",23,"2",50,"VK_2",e,e],[0,38,"Digit3",24,"3",51,"VK_3",e,e],[0,39,"Digit4",25,"4",52,"VK_4",e,e],[0,40,"Digit5",26,"5",53,"VK_5",e,e],[0,41,"Digit6",27,"6",54,"VK_6",e,e],[0,42,"Digit7",28,"7",55,"VK_7",e,e],[0,43,"Digit8",29,"8",56,"VK_8",e,e],[0,44,"Digit9",30,"9",57,"VK_9",e,e],[0,45,"Digit0",21,"0",48,"VK_0",e,e],[1,46,"Enter",3,"Enter",13,"VK_RETURN",e,e],[1,47,"Escape",9,"Escape",27,"VK_ESCAPE",e,e],[1,48,"Backspace",1,"Backspace",8,"VK_BACK",e,e],[1,49,"Tab",2,"Tab",9,"VK_TAB",e,e],[1,50,"Space",10,"Space",32,"VK_SPACE",e,e],[0,51,"Minus",88,"-",189,"VK_OEM_MINUS","-","OEM_MINUS"],[0,52,"Equal",86,"=",187,"VK_OEM_PLUS","=","OEM_PLUS"],[0,53,"BracketLeft",92,"[",219,"VK_OEM_4","[","OEM_4"],[0,54,"BracketRight",94,"]",221,"VK_OEM_6","]","OEM_6"],[0,55,"Backslash",93,"\\",220,"VK_OEM_5","\\","OEM_5"],[0,56,"IntlHash",0,e,0,e,e,e],[0,57,"Semicolon",85,";",186,"VK_OEM_1",";","OEM_1"],[0,58,"Quote",95,"'",222,"VK_OEM_7","'","OEM_7"],[0,59,"Backquote",91,"`",192,"VK_OEM_3","`","OEM_3"],[0,60,"Comma",87,",",188,"VK_OEM_COMMA",",","OEM_COMMA"],[0,61,"Period",89,".",190,"VK_OEM_PERIOD",".","OEM_PERIOD"],[0,62,"Slash",90,"/",191,"VK_OEM_2","/","OEM_2"],[1,63,"CapsLock",8,"CapsLock",20,"VK_CAPITAL",e,e],[1,64,"F1",59,"F1",112,"VK_F1",e,e],[1,65,"F2",60,"F2",113,"VK_F2",e,e],[1,66,"F3",61,"F3",114,"VK_F3",e,e],[1,67,"F4",62,"F4",115,"VK_F4",e,e],[1,68,"F5",63,"F5",116,"VK_F5",e,e],[1,69,"F6",64,"F6",117,"VK_F6",e,e],[1,70,"F7",65,"F7",118,"VK_F7",e,e],[1,71,"F8",66,"F8",119,"VK_F8",e,e],[1,72,"F9",67,"F9",120,"VK_F9",e,e],[1,73,"F10",68,"F10",121,"VK_F10",e,e],[1,74,"F11",69,"F11",122,"VK_F11",e,e],[1,75,"F12",70,"F12",123,"VK_F12",e,e],[1,76,"PrintScreen",0,e,0,e,e,e],[1,77,"ScrollLock",84,"ScrollLock",145,"VK_SCROLL",e,e],[1,78,"Pause",7,"PauseBreak",19,"VK_PAUSE",e,e],[1,79,"Insert",19,"Insert",45,"VK_INSERT",e,e],[1,80,"Home",14,"Home",36,"VK_HOME",e,e],[1,81,"PageUp",11,"PageUp",33,"VK_PRIOR",e,e],[1,82,"Delete",20,"Delete",46,"VK_DELETE",e,e],[1,83,"End",13,"End",35,"VK_END",e,e],[1,84,"PageDown",12,"PageDown",34,"VK_NEXT",e,e],[1,85,"ArrowRight",17,"RightArrow",39,"VK_RIGHT","Right",e],[1,86,"ArrowLeft",15,"LeftArrow",37,"VK_LEFT","Left",e],[1,87,"ArrowDown",18,"DownArrow",40,"VK_DOWN","Down",e],[1,88,"ArrowUp",16,"UpArrow",38,"VK_UP","Up",e],[1,89,"NumLock",83,"NumLock",144,"VK_NUMLOCK",e,e],[1,90,"NumpadDivide",113,"NumPad_Divide",111,"VK_DIVIDE",e,e],[1,91,"NumpadMultiply",108,"NumPad_Multiply",106,"VK_MULTIPLY",e,e],[1,92,"NumpadSubtract",111,"NumPad_Subtract",109,"VK_SUBTRACT",e,e],[1,93,"NumpadAdd",109,"NumPad_Add",107,"VK_ADD",e,e],[1,94,"NumpadEnter",3,e,0,e,e,e],[1,95,"Numpad1",99,"NumPad1",97,"VK_NUMPAD1",e,e],[1,96,"Numpad2",100,"NumPad2",98,"VK_NUMPAD2",e,e],[1,97,"Numpad3",101,"NumPad3",99,"VK_NUMPAD3",e,e],[1,98,"Numpad4",102,"NumPad4",100,"VK_NUMPAD4",e,e],[1,99,"Numpad5",103,"NumPad5",101,"VK_NUMPAD5",e,e],[1,100,"Numpad6",104,"NumPad6",102,"VK_NUMPAD6",e,e],[1,101,"Numpad7",105,"NumPad7",103,"VK_NUMPAD7",e,e],[1,102,"Numpad8",106,"NumPad8",104,"VK_NUMPAD8",e,e],[1,103,"Numpad9",107,"NumPad9",105,"VK_NUMPAD9",e,e],[1,104,"Numpad0",98,"NumPad0",96,"VK_NUMPAD0",e,e],[1,105,"NumpadDecimal",112,"NumPad_Decimal",110,"VK_DECIMAL",e,e],[0,106,"IntlBackslash",97,"OEM_102",226,"VK_OEM_102",e,e],[1,107,"ContextMenu",58,"ContextMenu",93,e,e,e],[1,108,"Power",0,e,0,e,e,e],[1,109,"NumpadEqual",0,e,0,e,e,e],[1,110,"F13",71,"F13",124,"VK_F13",e,e],[1,111,"F14",72,"F14",125,"VK_F14",e,e],[1,112,"F15",73,"F15",126,"VK_F15",e,e],[1,113,"F16",74,"F16",127,"VK_F16",e,e],[1,114,"F17",75,"F17",128,"VK_F17",e,e],[1,115,"F18",76,"F18",129,"VK_F18",e,e],[1,116,"F19",77,"F19",130,"VK_F19",e,e],[1,117,"F20",78,"F20",131,"VK_F20",e,e],[1,118,"F21",79,"F21",132,"VK_F21",e,e],[1,119,"F22",80,"F22",133,"VK_F22",e,e],[1,120,"F23",81,"F23",134,"VK_F23",e,e],[1,121,"F24",82,"F24",135,"VK_F24",e,e],[1,122,"Open",0,e,0,e,e,e],[1,123,"Help",0,e,0,e,e,e],[1,124,"Select",0,e,0,e,e,e],[1,125,"Again",0,e,0,e,e,e],[1,126,"Undo",0,e,0,e,e,e],[1,127,"Cut",0,e,0,e,e,e],[1,128,"Copy",0,e,0,e,e,e],[1,129,"Paste",0,e,0,e,e,e],[1,130,"Find",0,e,0,e,e,e],[1,131,"AudioVolumeMute",117,"AudioVolumeMute",173,"VK_VOLUME_MUTE",e,e],[1,132,"AudioVolumeUp",118,"AudioVolumeUp",175,"VK_VOLUME_UP",e,e],[1,133,"AudioVolumeDown",119,"AudioVolumeDown",174,"VK_VOLUME_DOWN",e,e],[1,134,"NumpadComma",110,"NumPad_Separator",108,"VK_SEPARATOR",e,e],[0,135,"IntlRo",115,"ABNT_C1",193,"VK_ABNT_C1",e,e],[1,136,"KanaMode",0,e,0,e,e,e],[0,137,"IntlYen",0,e,0,e,e,e],[1,138,"Convert",0,e,0,e,e,e],[1,139,"NonConvert",0,e,0,e,e,e],[1,140,"Lang1",0,e,0,e,e,e],[1,141,"Lang2",0,e,0,e,e,e],[1,142,"Lang3",0,e,0,e,e,e],[1,143,"Lang4",0,e,0,e,e,e],[1,144,"Lang5",0,e,0,e,e,e],[1,145,"Abort",0,e,0,e,e,e],[1,146,"Props",0,e,0,e,e,e],[1,147,"NumpadParenLeft",0,e,0,e,e,e],[1,148,"NumpadParenRight",0,e,0,e,e,e],[1,149,"NumpadBackspace",0,e,0,e,e,e],[1,150,"NumpadMemoryStore",0,e,0,e,e,e],[1,151,"NumpadMemoryRecall",0,e,0,e,e,e],[1,152,"NumpadMemoryClear",0,e,0,e,e,e],[1,153,"NumpadMemoryAdd",0,e,0,e,e,e],[1,154,"NumpadMemorySubtract",0,e,0,e,e,e],[1,155,"NumpadClear",131,"Clear",12,"VK_CLEAR",e,e],[1,156,"NumpadClearEntry",0,e,0,e,e,e],[1,0,e,5,"Ctrl",17,"VK_CONTROL",e,e],[1,0,e,4,"Shift",16,"VK_SHIFT",e,e],[1,0,e,6,"Alt",18,"VK_MENU",e,e],[1,0,e,57,"Meta",91,"VK_COMMAND",e,e],[1,157,"ControlLeft",5,e,0,"VK_LCONTROL",e,e],[1,158,"ShiftLeft",4,e,0,"VK_LSHIFT",e,e],[1,159,"AltLeft",6,e,0,"VK_LMENU",e,e],[1,160,"MetaLeft",57,e,0,"VK_LWIN",e,e],[1,161,"ControlRight",5,e,0,"VK_RCONTROL",e,e],[1,162,"ShiftRight",4,e,0,"VK_RSHIFT",e,e],[1,163,"AltRight",6,e,0,"VK_RMENU",e,e],[1,164,"MetaRight",57,e,0,"VK_RWIN",e,e],[1,165,"BrightnessUp",0,e,0,e,e,e],[1,166,"BrightnessDown",0,e,0,e,e,e],[1,167,"MediaPlay",0,e,0,e,e,e],[1,168,"MediaRecord",0,e,0,e,e,e],[1,169,"MediaFastForward",0,e,0,e,e,e],[1,170,"MediaRewind",0,e,0,e,e,e],[1,171,"MediaTrackNext",124,"MediaTrackNext",176,"VK_MEDIA_NEXT_TRACK",e,e],[1,172,"MediaTrackPrevious",125,"MediaTrackPrevious",177,"VK_MEDIA_PREV_TRACK",e,e],[1,173,"MediaStop",126,"MediaStop",178,"VK_MEDIA_STOP",e,e],[1,174,"Eject",0,e,0,e,e,e],[1,175,"MediaPlayPause",127,"MediaPlayPause",179,"VK_MEDIA_PLAY_PAUSE",e,e],[1,176,"MediaSelect",128,"LaunchMediaPlayer",181,"VK_MEDIA_LAUNCH_MEDIA_SELECT",e,e],[1,177,"LaunchMail",129,"LaunchMail",180,"VK_MEDIA_LAUNCH_MAIL",e,e],[1,178,"LaunchApp2",130,"LaunchApp2",183,"VK_MEDIA_LAUNCH_APP2",e,e],[1,179,"LaunchApp1",0,e,0,"VK_MEDIA_LAUNCH_APP1",e,e],[1,180,"SelectTask",0,e,0,e,e,e],[1,181,"LaunchScreenSaver",0,e,0,e,e,e],[1,182,"BrowserSearch",120,"BrowserSearch",170,"VK_BROWSER_SEARCH",e,e],[1,183,"BrowserHome",121,"BrowserHome",172,"VK_BROWSER_HOME",e,e],[1,184,"BrowserBack",122,"BrowserBack",166,"VK_BROWSER_BACK",e,e],[1,185,"BrowserForward",123,"BrowserForward",167,"VK_BROWSER_FORWARD",e,e],[1,186,"BrowserStop",0,e,0,"VK_BROWSER_STOP",e,e],[1,187,"BrowserRefresh",0,e,0,"VK_BROWSER_REFRESH",e,e],[1,188,"BrowserFavorites",0,e,0,"VK_BROWSER_FAVORITES",e,e],[1,189,"ZoomToggle",0,e,0,e,e,e],[1,190,"MailReply",0,e,0,e,e,e],[1,191,"MailForward",0,e,0,e,e,e],[1,192,"MailSend",0,e,0,e,e,e],[1,0,e,114,"KeyInComposition",229,e,e,e],[1,0,e,116,"ABNT_C2",194,"VK_ABNT_C2",e,e],[1,0,e,96,"OEM_8",223,"VK_OEM_8",e,e],[1,0,e,0,e,0,"VK_KANA",e,e],[1,0,e,0,e,0,"VK_HANGUL",e,e],[1,0,e,0,e,0,"VK_JUNJA",e,e],[1,0,e,0,e,0,"VK_FINAL",e,e],[1,0,e,0,e,0,"VK_HANJA",e,e],[1,0,e,0,e,0,"VK_KANJI",e,e],[1,0,e,0,e,0,"VK_CONVERT",e,e],[1,0,e,0,e,0,"VK_NONCONVERT",e,e],[1,0,e,0,e,0,"VK_ACCEPT",e,e],[1,0,e,0,e,0,"VK_MODECHANGE",e,e],[1,0,e,0,e,0,"VK_SELECT",e,e],[1,0,e,0,e,0,"VK_PRINT",e,e],[1,0,e,0,e,0,"VK_EXECUTE",e,e],[1,0,e,0,e,0,"VK_SNAPSHOT",e,e],[1,0,e,0,e,0,"VK_HELP",e,e],[1,0,e,0,e,0,"VK_APPS",e,e],[1,0,e,0,e,0,"VK_PROCESSKEY",e,e],[1,0,e,0,e,0,"VK_PACKET",e,e],[1,0,e,0,e,0,"VK_DBE_SBCSCHAR",e,e],[1,0,e,0,e,0,"VK_DBE_DBCSCHAR",e,e],[1,0,e,0,e,0,"VK_ATTN",e,e],[1,0,e,0,e,0,"VK_CRSEL",e,e],[1,0,e,0,e,0,"VK_EXSEL",e,e],[1,0,e,0,e,0,"VK_EREOF",e,e],[1,0,e,0,e,0,"VK_PLAY",e,e],[1,0,e,0,e,0,"VK_ZOOM",e,e],[1,0,e,0,e,0,"VK_NONAME",e,e],[1,0,e,0,e,0,"VK_PA1",e,e],[1,0,e,0,e,0,"VK_OEM_CLEAR",e,e]],i=[],n=[];for(const e of t){const[t,m,p,f,A,_,w,b,v]=e;if(n[m]||(n[m]=!0,h[m]=p,c[p]=m,d[p.toLowerCase()]=m,t&&(u[m]=f,0!==f&&3!==f&&5!==f&&4!==f&&6!==f&&57!==f&&(g[f]=m))),!i[f]){if(i[f]=!0,!A)throw new Error(`String representation missing for key code ${f} around scan code ${p}`);o.define(f,A),s.define(f,b||A),r.define(f,v||b||A)}_&&(a[_]=f),w&&(l[w]=f)}g[3]=46}(),function(e){e.toString=function(e){return o.keyCodeToStr(e)},e.fromString=function(e){return o.strToKeyCode(e)},e.toUserSettingsUS=function(e){return s.keyCodeToStr(e)},e.toUserSettingsGeneral=function(e){return r.keyCodeToStr(e)},e.fromUserSettings=function(e){return s.strToKeyCode(e)||r.strToKeyCode(e)},e.toElectronAccelerator=function(e){if(e>=98&&e<=113)return null;switch(e){case 16:return"Up";case 18:return"Down";case 15:return"Left";case 17:return"Right"}return o.keyCodeToStr(e)}}(m||(m={}))},5565:(e,t,i)=>{i.d(t,{G$:()=>l,Of:()=>s,r0:()=>r,rr:()=>a});var n=i(1759);class o{constructor(e,t,i=t){this.modifierLabels=[null],this.modifierLabels[2]=e,this.modifierLabels[1]=t,this.modifierLabels[3]=i}toLabel(e,t,i){if(0===t.length)return null;const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=i(s);if(null===r)return null;n[o]=h(s,r,this.modifierLabels[e])}return n.join(" ")}}const s=new o({ctrlKey:"⌃",shiftKey:"⇧",altKey:"⌥",metaKey:"⌘",separator:""},{ctrlKey:n.kg({key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.kg({key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.kg({key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.kg({key:"windowsKey",comment:["This is the short form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.kg({key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.kg({key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.kg({key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.kg({key:"superKey",comment:["This is the short form for the Super key on the keyboard"]},"Super"),separator:"+"}),r=new o({ctrlKey:n.kg({key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.kg({key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.kg({key:"optKey.long",comment:["This is the long form for the Alt/Option key on the keyboard"]},"Option"),metaKey:n.kg({key:"cmdKey.long",comment:["This is the long form for the Command key on the keyboard"]},"Command"),separator:"+"},{ctrlKey:n.kg({key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.kg({key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.kg({key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.kg({key:"windowsKey.long",comment:["This is the long form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.kg({key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.kg({key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.kg({key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.kg({key:"superKey.long",comment:["This is the long form for the Super key on the keyboard"]},"Super"),separator:"+"}),a=new o({ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Cmd",separator:"+"},{ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Super",separator:"+"}),l=new o({ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"cmd",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"win",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"meta",separator:"+"});function h(e,t,i){if(null===t)return"";const n=[];return e.ctrlKey&&n.push(i.ctrlKey),e.shiftKey&&n.push(i.shiftKey),e.altKey&&n.push(i.altKey),e.metaKey&&n.push(i.metaKey),""!==t&&n.push(t),n.join(i.separator)}},6021:(e,t,i)=>{i.d(t,{FW:()=>l,Zv:()=>o,dG:()=>r,z5:()=>h});var n=i(3329);function o(e,t){if("number"==typeof e){if(0===e)return null;const i=(65535&e)>>>0,n=(4294901760&e)>>>16;return new a(0!==n?[s(i,t),s(n,t)]:[s(i,t)])}{const i=[];for(let n=0;n<e.length;n++)i.push(s(e[n],t));return new a(i)}}function s(e,t){const i=!!(2048&e),n=!!(256&e);return new r(2===t?n:i,!!(1024&e),!!(512&e),2===t?i:n,255&e)}class r{constructor(e,t,i,n,o){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyCode=o}equals(e){return e instanceof r&&this.ctrlKey===e.ctrlKey&&this.shiftKey===e.shiftKey&&this.altKey===e.altKey&&this.metaKey===e.metaKey&&this.keyCode===e.keyCode}isModifierKey(){return 0===this.keyCode||5===this.keyCode||57===this.keyCode||6===this.keyCode||4===this.keyCode}isDuplicateModifierCase(){return this.ctrlKey&&5===this.keyCode||this.shiftKey&&4===this.keyCode||this.altKey&&6===this.keyCode||this.metaKey&&57===this.keyCode}}class a{constructor(e){if(0===e.length)throw(0,n.Qg)("chords");this.chords=e}}class l{constructor(e,t,i,n,o,s){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyLabel=o,this.keyAriaLabel=s}}class h{}},4100:(e,t,i)=>{i.d(t,{d:()=>n});class n{constructor(e){this.executor=e,this._didRun=!1}get value(){if(!this._didRun)try{this._value=this.executor()}catch(e){this._error=e}finally{this._didRun=!0}if(this._error)throw this._error;return this._value}get rawValue(){return this._value}}},8300:(e,t,i)=>{i.d(t,{$w:()=>w,AS:()=>d,BO:()=>_,Cm:()=>m,HE:()=>f,St:()=>A,Xm:()=>c,jG:()=>p,lC:()=>h,qE:()=>u,s:()=>g});var n=i(1387),o=i(7580);let s=null;function r(e){return null==s||s.trackDisposable(e),e}function a(e){null==s||s.markAsDisposed(e)}function l(e,t){null==s||s.setParent(e,t)}function h(e){return null==s||s.markAsSingleton(e),e}function c(e){return"function"==typeof e.dispose&&0===e.dispose.length}function d(e){if(o.f.is(e)){const t=[];for(const i of e)if(i)try{i.dispose()}catch(e){t.push(e)}if(1===t.length)throw t[0];if(t.length>1)throw new AggregateError(t,"Encountered errors while disposing of store");return Array.isArray(e)?[]:e}if(e)return e.dispose(),e}function u(...e){const t=g((()=>d(e)));return function(e,t){if(s)for(const i of e)s.setParent(i,t)}(e,t),t}function g(e){const t=r({dispose:(0,n.O)((()=>{a(t),e()}))});return t}class m{constructor(){this._toDispose=new Set,this._isDisposed=!1,r(this)}dispose(){this._isDisposed||(a(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){if(0!==this._toDispose.size)try{d(this._toDispose)}finally{this._toDispose.clear()}}add(e){if(!e)return e;if(e===this)throw new Error("Cannot register a disposable on itself!");return l(e,this),this._isDisposed?m.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(e),e}}m.DISABLE_DISPOSED_WARNING=!1;class p{constructor(){this._store=new m,r(this),l(this._store,this)}dispose(){a(this),this._store.dispose()}_register(e){if(e===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(e)}}p.None=Object.freeze({dispose(){}});class f{constructor(){this._isDisposed=!1,r(this)}get value(){return this._isDisposed?void 0:this._value}set value(e){var t;this._isDisposed||e===this._value||(null===(t=this._value)||void 0===t||t.dispose(),e&&l(e,this),this._value=e)}clear(){this.value=void 0}dispose(){var e;this._isDisposed=!0,a(this),null===(e=this._value)||void 0===e||e.dispose(),this._value=void 0}}class A{constructor(){this.dispose=()=>{},this.unset=()=>{},this.isset=()=>!1,r(this)}set(e){let t=e;return this.unset=()=>t=void 0,this.isset=()=>void 0!==t,this.dispose=()=>{t&&(t(),t=void 0,a(this))},this}}class _{constructor(e){this.object=e}dispose(){}}class w{constructor(){this._store=new Map,this._isDisposed=!1,r(this)}dispose(){a(this),this._isDisposed=!0,this.clearAndDisposeAll()}clearAndDisposeAll(){if(this._store.size)try{d(this._store.values())}finally{this._store.clear()}}get(e){return this._store.get(e)}set(e,t,i=!1){var n;this._isDisposed&&console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack),i||null===(n=this._store.get(e))||void 0===n||n.dispose(),this._store.set(e,t)}deleteAndDispose(e){var t;null===(t=this._store.get(e))||void 0===t||t.dispose(),this._store.delete(e)}[Symbol.iterator](){return this._store[Symbol.iterator]()}}},6423:(e,t,i)=>{i.d(t,{w:()=>o});class n{constructor(e){this.element=e,this.next=n.Undefined,this.prev=n.Undefined}}n.Undefined=new n(void 0);class o{constructor(){this._first=n.Undefined,this._last=n.Undefined,this._size=0}get size(){return this._size}isEmpty(){return this._first===n.Undefined}clear(){let e=this._first;for(;e!==n.Undefined;){const t=e.next;e.prev=n.Undefined,e.next=n.Undefined,e=t}this._first=n.Undefined,this._last=n.Undefined,this._size=0}unshift(e){return this._insert(e,!1)}push(e){return this._insert(e,!0)}_insert(e,t){const i=new n(e);if(this._first===n.Undefined)this._first=i,this._last=i;else if(t){const e=this._last;this._last=i,i.prev=e,e.next=i}else{const e=this._first;this._first=i,i.next=e,e.prev=i}this._size+=1;let o=!1;return()=>{o||(o=!0,this._remove(i))}}shift(){if(this._first!==n.Undefined){const e=this._first.element;return this._remove(this._first),e}}pop(){if(this._last!==n.Undefined){const e=this._last.element;return this._remove(this._last),e}}_remove(e){if(e.prev!==n.Undefined&&e.next!==n.Undefined){const t=e.prev;t.next=e.next,e.next.prev=t}else e.prev===n.Undefined&&e.next===n.Undefined?(this._first=n.Undefined,this._last=n.Undefined):e.next===n.Undefined?(this._last=this._last.prev,this._last.next=n.Undefined):e.prev===n.Undefined&&(this._first=this._first.next,this._first.prev=n.Undefined);this._size-=1}*[Symbol.iterator](){let e=this._first;for(;e!==n.Undefined;)yield e.element,e=e.next}}},2154:(e,t,i)=>{var n,o;i.d(t,{fT:()=>r,qK:()=>l});class s{constructor(e,t){this.uri=e,this.value=t}}class r{constructor(e,t){this[n]="ResourceMap",e instanceof r?(this.map=new Map(e.map),this.toKey=null!=t?t:r.defaultToKey):(this.map=new Map,this.toKey=null!=e?e:r.defaultToKey)}set(e,t){return this.map.set(this.toKey(e),new s(e,t)),this}get(e){var t;return null===(t=this.map.get(this.toKey(e)))||void 0===t?void 0:t.value}has(e){return this.map.has(this.toKey(e))}get size(){return this.map.size}clear(){this.map.clear()}delete(e){return this.map.delete(this.toKey(e))}forEach(e,t){void 0!==t&&(e=e.bind(t));for(const[t,i]of this.map)e(i.value,i.uri,this)}*values(){for(const e of this.map.values())yield e.value}*keys(){for(const e of this.map.values())yield e.uri}*entries(){for(const e of this.map.values())yield[e.uri,e.value]}*[(n=Symbol.toStringTag,Symbol.iterator)](){for(const[,e]of this.map)yield[e.uri,e.value]}}r.defaultToKey=e=>e.toString();class a{constructor(){this[o]="LinkedMap",this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){var e;return null===(e=this._head)||void 0===e?void 0:e.value}get last(){var e;return null===(e=this._tail)||void 0===e?void 0:e.value}has(e){return this._map.has(e)}get(e,t=0){const i=this._map.get(e);if(i)return 0!==t&&this.touch(i,t),i.value}set(e,t,i=0){let n=this._map.get(e);if(n)n.value=t,0!==i&&this.touch(n,i);else{switch(n={key:e,value:t,next:void 0,previous:void 0},i){case 0:case 2:default:this.addItemLast(n);break;case 1:this.addItemFirst(n)}this._map.set(e,n),this._size++}return this}delete(e){return!!this.remove(e)}remove(e){const t=this._map.get(e);if(t)return this._map.delete(e),this.removeItem(t),this._size--,t.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");const e=this._head;return this._map.delete(e.key),this.removeItem(e),this._size--,e.value}forEach(e,t){const i=this._state;let n=this._head;for(;n;){if(t?e.bind(t)(n.value,n.key,this):e(n.value,n.key,this),this._state!==i)throw new Error("LinkedMap got modified during iteration.");n=n.next}}keys(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator]:()=>n,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.key,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}values(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator]:()=>n,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.value,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}entries(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator]:()=>n,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:[i.key,i.value],done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(e){if(e>=this.size)return;if(0===e)return void this.clear();let t=this._head,i=this.size;for(;t&&i>e;)this._map.delete(t.key),t=t.next,i--;this._head=t,this._size=i,t&&(t.previous=void 0),this._state++}addItemFirst(e){if(this._head||this._tail){if(!this._head)throw new Error("Invalid list");e.next=this._head,this._head.previous=e}else this._tail=e;this._head=e,this._state++}addItemLast(e){if(this._head||this._tail){if(!this._tail)throw new Error("Invalid list");e.previous=this._tail,this._tail.next=e}else this._head=e;this._tail=e,this._state++}removeItem(e){if(e===this._head&&e===this._tail)this._head=void 0,this._tail=void 0;else if(e===this._head){if(!e.next)throw new Error("Invalid list");e.next.previous=void 0,this._head=e.next}else if(e===this._tail){if(!e.previous)throw new Error("Invalid list");e.previous.next=void 0,this._tail=e.previous}else{const t=e.next,i=e.previous;if(!t||!i)throw new Error("Invalid list");t.previous=i,i.next=t}e.next=void 0,e.previous=void 0,this._state++}touch(e,t){if(!this._head||!this._tail)throw new Error("Invalid list");if(1===t||2===t)if(1===t){if(e===this._head)return;const t=e.next,i=e.previous;e===this._tail?(i.next=void 0,this._tail=i):(t.previous=i,i.next=t),e.previous=void 0,e.next=this._head,this._head.previous=e,this._head=e,this._state++}else if(2===t){if(e===this._tail)return;const t=e.next,i=e.previous;e===this._head?(t.previous=void 0,this._head=t):(t.previous=i,i.next=t),e.next=void 0,e.previous=this._tail,this._tail.next=e,this._tail=e,this._state++}}toJSON(){const e=[];return this.forEach(((t,i)=>{e.push([i,t])})),e}fromJSON(e){this.clear();for(const[t,i]of e)this.set(t,i)}}class l extends a{constructor(e,t=1){super(),this._limit=e,this._ratio=Math.min(Math.max(0,t),1)}get limit(){return this._limit}set limit(e){this._limit=e,this.checkTrim()}get(e,t=2){return super.get(e,t)}peek(e){return super.get(e,0)}set(e,t){return super.set(e,t,2),this.checkTrim(),this}checkTrim(){this.size>this._limit&&this.trimOld(Math.round(this._limit*this._ratio))}}},5558:(e,t,i)=>{i.d(t,{As:()=>r,qg:()=>a});var n=i(5888),o=i(5306),s=i(6926);function r(e){return JSON.stringify(e,l)}function a(e){let t=JSON.parse(e);return t=h(t),t}function l(e,t){return t instanceof RegExp?{$mid:2,source:t.source,flags:(0,o.RH)(t)}:t}function h(e,t=0){if(!e||t>200)return e;if("object"==typeof e){switch(e.$mid){case 1:return s.r.revive(e);case 2:return new RegExp(e.source,e.flags);case 16:return new Date(e.source)}if(e instanceof n.MB||e instanceof Uint8Array)return e;if(Array.isArray(e))for(let i=0;i<e.length;++i)e[i]=h(e[i],t+1);else for(const i in e)Object.hasOwnProperty.call(e,i)&&(e[i]=h(e[i],t+1))}return e}},2694:(e,t,i)=>{i.d(t,{K:()=>n});const n=Object.freeze({text:"text/plain",binary:"application/octet-stream",unknown:"application/unknown",markdown:"text/markdown",latex:"text/latex",uriList:"text/uri-list"})},7446:(e,t,i)=>{i.d(t,{Ez:()=>a,ny:()=>n,zl:()=>h});var n,o=i(3329),s=i(4541),r=i(6926);!function(e){e.inMemory="inmemory",e.vscode="vscode",e.internal="private",e.walkThrough="walkThrough",e.walkThroughSnippet="walkThroughSnippet",e.http="http",e.https="https",e.file="file",e.mailto="mailto",e.untitled="untitled",e.data="data",e.command="command",e.vscodeRemote="vscode-remote",e.vscodeRemoteResource="vscode-remote-resource",e.vscodeUserData="vscode-userdata",e.vscodeCustomEditor="vscode-custom-editor",e.vscodeNotebookCell="vscode-notebook-cell",e.vscodeNotebookCellMetadata="vscode-notebook-cell-metadata",e.vscodeNotebookCellOutput="vscode-notebook-cell-output",e.vscodeInteractive="vscode-interactive",e.vscodeInteractiveInput="vscode-interactive-input",e.vscodeSettings="vscode-settings",e.vscodeWorkspaceTrust="vscode-workspace-trust",e.vscodeTerminal="vscode-terminal",e.vscodeChatSesssion="vscode-chat-editor",e.webviewPanel="webview-panel",e.vscodeWebview="vscode-webview",e.extension="extension",e.vscodeFileResource="vscode-file",e.tmp="tmp",e.vsls="vsls",e.vscodeSourceControl="vscode-scm"}(n||(n={}));const a=new class{constructor(){this._hosts=Object.create(null),this._ports=Object.create(null),this._connectionTokens=Object.create(null),this._preferredWebSchema="http",this._delegate=null,this._remoteResourcesPath=`/${n.vscodeRemoteResource}`}setPreferredWebSchema(e){this._preferredWebSchema=e}rewrite(e){if(this._delegate)try{return this._delegate(e)}catch(t){return o.dz(t),e}const t=e.authority;let i=this._hosts[t];i&&-1!==i.indexOf(":")&&-1===i.indexOf("[")&&(i=`[${i}]`);const a=this._ports[t],l=this._connectionTokens[t];let h=`path=${encodeURIComponent(e.path)}`;return"string"==typeof l&&(h+=`&tkn=${encodeURIComponent(l)}`),r.r.from({scheme:s.HZ?this._preferredWebSchema:n.vscodeRemoteResource,authority:`${i}:${a}`,path:this._remoteResourcesPath,query:h})}};class l{uriToBrowserUri(e){return e.scheme===n.vscodeRemote?a.rewrite(e):e.scheme===n.file&&(s.ib||s.p7&&s.zQ.origin===`${n.vscodeFileResource}://${l.FALLBACK_AUTHORITY}`)?e.with({scheme:n.vscodeFileResource,authority:e.authority||l.FALLBACK_AUTHORITY,query:null,fragment:null}):e}}l.FALLBACK_AUTHORITY="vscode-app";const h=new l;var c;!function(e){const t=new Map([["1",{"Cross-Origin-Opener-Policy":"same-origin"}],["2",{"Cross-Origin-Embedder-Policy":"require-corp"}],["3",{"Cross-Origin-Opener-Policy":"same-origin","Cross-Origin-Embedder-Policy":"require-corp"}]]);e.CoopAndCoep=Object.freeze(t.get("3"));const i="vscode-coi";e.getHeadersFromQuery=function(e){let n;"string"==typeof e?n=new URL(e).searchParams:e instanceof URL?n=e.searchParams:r.r.isUri(e)&&(n=new URL(e.toString(!0)).searchParams);const o=null==n?void 0:n.get(i);if(o)return t.get(o)},e.addSearchParam=function(e,t,n){if(!globalThis.crossOriginIsolated)return;const o=t&&n?"3":n?"2":"1";e instanceof URLSearchParams?e.set(i,o):e[i]=o}}(c||(c={}))},6890:(e,t,i)=>{function n(e,t,i){return Math.min(Math.max(e,t),i)}i.d(t,{Uq:()=>o,mu:()=>s,qE:()=>n});class o{constructor(){this._n=1,this._val=0}update(e){return this._val=this._val+(e-this._val)/this._n,this._n+=1,this._val}get value(){return this._val}}class s{constructor(e){this._n=0,this._val=0,this._values=[],this._index=0,this._sum=0,this._values=new Array(e),this._values.fill(0,0,e)}update(e){const t=this._values[this._index];return this._values[this._index]=e,this._index=(this._index+1)%this._values.length,this._sum-=t,this._sum+=e,this._n<this._values.length&&(this._n+=1),this._val=this._sum/this._n,this._val}get value(){return this._val}}},3104:(e,t,i)=>{i.d(t,{Go:()=>o,PI:()=>a,V0:()=>d,aI:()=>c,co:()=>h,kT:()=>u,ol:()=>s});var n=i(2821);function o(e){if(!e||"object"!=typeof e)return e;if(e instanceof RegExp)return e;const t=Array.isArray(e)?[]:{};return Object.entries(e).forEach((([e,i])=>{t[e]=i&&"object"==typeof i?o(i):i})),t}function s(e){if(!e||"object"!=typeof e)return e;const t=[e];for(;t.length>0;){const e=t.shift();Object.freeze(e);for(const i in e)if(r.call(e,i)){const o=e[i];"object"!=typeof o||Object.isFrozen(o)||(0,n.iu)(o)||t.push(o)}}return e}const r=Object.prototype.hasOwnProperty;function a(e,t){return l(e,t,new Set)}function l(e,t,i){if((0,n.z)(e))return e;const o=t(e);if(void 0!==o)return o;if(Array.isArray(e)){const n=[];for(const o of e)n.push(l(o,t,i));return n}if((0,n.Gv)(e)){if(i.has(e))throw new Error("Cannot clone recursive data-structure");i.add(e);const n={};for(const o in e)r.call(e,o)&&(n[o]=l(e[o],t,i));return i.delete(e),n}return e}function h(e,t,i=!0){return(0,n.Gv)(e)?((0,n.Gv)(t)&&Object.keys(t).forEach((o=>{o in e?i&&((0,n.Gv)(e[o])&&(0,n.Gv)(t[o])?h(e[o],t[o],i):e[o]=t[o]):e[o]=t[o]})),e):t}function c(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(typeof e!=typeof t)return!1;if("object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;let i,n;if(Array.isArray(e)){if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(!c(e[i],t[i]))return!1}else{const o=[];for(n in e)o.push(n);o.sort();const s=[];for(n in t)s.push(n);if(s.sort(),!c(o,s))return!1;for(i=0;i<o.length;i++)if(!c(e[o[i]],t[o[i]]))return!1}return!0}function d(e){const t=[];for(const i of function(e){let t=[],i=Object.getPrototypeOf(e);for(;Object.prototype!==i;)t=t.concat(Object.getOwnPropertyNames(i)),i=Object.getPrototypeOf(i);return t}(e))"function"==typeof e[i]&&t.push(i);return t}function u(e,t){const i=e=>function(){const i=Array.prototype.slice.call(arguments,0);return t(e,i)},n={};for(const t of e)n[t]=i(t);return n}},1331:(e,t,i)=>{i.d(t,{P8:()=>D,pD:()=>E,LC:()=>x,S8:()=>y,SA:()=>C,V8:()=>k,hd:()=>S,Vn:()=>L,IN:()=>b});var n=i(4541);let o;if(void 0!==n.zQ.vscode&&void 0!==n.zQ.vscode.process){const e=n.zQ.vscode.process;o={get platform(){return e.platform},get arch(){return e.arch},get env(){return e.env},cwd:()=>e.cwd()}}else o="undefined"!=typeof process?{get platform(){return process.platform},get arch(){return process.arch},get env(){return process.env},cwd:()=>process.env.VSCODE_CWD||process.cwd()}:{get platform(){return n.uF?"win32":n.zx?"darwin":"linux"},get arch(){},get env(){return{}},cwd:()=>"/"};const s=o.cwd,r=o.env,a=o.platform,l=46,h=47,c=92,d=58;class u extends Error{constructor(e,t,i){let n;"string"==typeof t&&0===t.indexOf("not ")?(n="must not be",t=t.replace(/^not /,"")):n="must be";const o=-1!==e.indexOf(".")?"property":"argument";let s=`The "${e}" ${o} ${n} of type ${t}`;s+=". Received type "+typeof i,super(s),this.code="ERR_INVALID_ARG_TYPE"}}function g(e,t){if("string"!=typeof e)throw new u(t,"string",e)}const m="win32"===a;function p(e){return e===h||e===c}function f(e){return e===h}function A(e){return e>=65&&e<=90||e>=97&&e<=122}function _(e,t,i,n){let o="",s=0,r=-1,a=0,c=0;for(let d=0;d<=e.length;++d){if(d<e.length)c=e.charCodeAt(d);else{if(n(c))break;c=h}if(n(c)){if(r===d-1||1===a);else if(2===a){if(o.length<2||2!==s||o.charCodeAt(o.length-1)!==l||o.charCodeAt(o.length-2)!==l){if(o.length>2){const e=o.lastIndexOf(i);-1===e?(o="",s=0):(o=o.slice(0,e),s=o.length-1-o.lastIndexOf(i)),r=d,a=0;continue}if(0!==o.length){o="",s=0,r=d,a=0;continue}}t&&(o+=o.length>0?`${i}..`:"..",s=2)}else o.length>0?o+=`${i}${e.slice(r+1,d)}`:o=e.slice(r+1,d),s=d-r-1;r=d,a=0}else c===l&&-1!==a?++a:a=-1}return o}function w(e,t){!function(e){if(null===e||"object"!=typeof e)throw new u("pathObject","Object",e)}(t);const i=t.dir||t.root,n=t.base||`${t.name||""}${t.ext||""}`;return i?i===t.root?`${i}${n}`:`${i}${e}${n}`:n}const b={resolve(...e){let t="",i="",n=!1;for(let o=e.length-1;o>=-1;o--){let a;if(o>=0){if(a=e[o],g(a,"path"),0===a.length)continue}else 0===t.length?a=s():(a=r[`=${t}`]||s(),(void 0===a||a.slice(0,2).toLowerCase()!==t.toLowerCase()&&a.charCodeAt(2)===c)&&(a=`${t}\\`));const l=a.length;let h=0,u="",m=!1;const f=a.charCodeAt(0);if(1===l)p(f)&&(h=1,m=!0);else if(p(f))if(m=!0,p(a.charCodeAt(1))){let e=2,t=e;for(;e<l&&!p(a.charCodeAt(e));)e++;if(e<l&&e!==t){const i=a.slice(t,e);for(t=e;e<l&&p(a.charCodeAt(e));)e++;if(e<l&&e!==t){for(t=e;e<l&&!p(a.charCodeAt(e));)e++;e!==l&&e===t||(u=`\\\\${i}\\${a.slice(t,e)}`,h=e)}}}else h=1;else A(f)&&a.charCodeAt(1)===d&&(u=a.slice(0,2),h=2,l>2&&p(a.charCodeAt(2))&&(m=!0,h=3));if(u.length>0)if(t.length>0){if(u.toLowerCase()!==t.toLowerCase())continue}else t=u;if(n){if(t.length>0)break}else if(i=`${a.slice(h)}\\${i}`,n=m,m&&t.length>0)break}return i=_(i,!n,"\\",p),n?`${t}\\${i}`:`${t}${i}`||"."},normalize(e){g(e,"path");const t=e.length;if(0===t)return".";let i,n=0,o=!1;const s=e.charCodeAt(0);if(1===t)return f(s)?"\\":e;if(p(s))if(o=!0,p(e.charCodeAt(1))){let o=2,s=o;for(;o<t&&!p(e.charCodeAt(o));)o++;if(o<t&&o!==s){const r=e.slice(s,o);for(s=o;o<t&&p(e.charCodeAt(o));)o++;if(o<t&&o!==s){for(s=o;o<t&&!p(e.charCodeAt(o));)o++;if(o===t)return`\\\\${r}\\${e.slice(s)}\\`;o!==s&&(i=`\\\\${r}\\${e.slice(s,o)}`,n=o)}}}else n=1;else A(s)&&e.charCodeAt(1)===d&&(i=e.slice(0,2),n=2,t>2&&p(e.charCodeAt(2))&&(o=!0,n=3));let r=n<t?_(e.slice(n),!o,"\\",p):"";return 0!==r.length||o||(r="."),r.length>0&&p(e.charCodeAt(t-1))&&(r+="\\"),void 0===i?o?`\\${r}`:r:o?`${i}\\${r}`:`${i}${r}`},isAbsolute(e){g(e,"path");const t=e.length;if(0===t)return!1;const i=e.charCodeAt(0);return p(i)||t>2&&A(i)&&e.charCodeAt(1)===d&&p(e.charCodeAt(2))},join(...e){if(0===e.length)return".";let t,i;for(let n=0;n<e.length;++n){const o=e[n];g(o,"path"),o.length>0&&(void 0===t?t=i=o:t+=`\\${o}`)}if(void 0===t)return".";let n=!0,o=0;if("string"==typeof i&&p(i.charCodeAt(0))){++o;const e=i.length;e>1&&p(i.charCodeAt(1))&&(++o,e>2&&(p(i.charCodeAt(2))?++o:n=!1))}if(n){for(;o<t.length&&p(t.charCodeAt(o));)o++;o>=2&&(t=`\\${t.slice(o)}`)}return b.normalize(t)},relative(e,t){if(g(e,"from"),g(t,"to"),e===t)return"";const i=b.resolve(e),n=b.resolve(t);if(i===n)return"";if((e=i.toLowerCase())===(t=n.toLowerCase()))return"";let o=0;for(;o<e.length&&e.charCodeAt(o)===c;)o++;let s=e.length;for(;s-1>o&&e.charCodeAt(s-1)===c;)s--;const r=s-o;let a=0;for(;a<t.length&&t.charCodeAt(a)===c;)a++;let l=t.length;for(;l-1>a&&t.charCodeAt(l-1)===c;)l--;const h=l-a,d=r<h?r:h;let u=-1,m=0;for(;m<d;m++){const i=e.charCodeAt(o+m);if(i!==t.charCodeAt(a+m))break;i===c&&(u=m)}if(m!==d){if(-1===u)return n}else{if(h>d){if(t.charCodeAt(a+m)===c)return n.slice(a+m+1);if(2===m)return n.slice(a+m)}r>d&&(e.charCodeAt(o+m)===c?u=m:2===m&&(u=3)),-1===u&&(u=0)}let p="";for(m=o+u+1;m<=s;++m)m!==s&&e.charCodeAt(m)!==c||(p+=0===p.length?"..":"\\..");return a+=u,p.length>0?`${p}${n.slice(a,l)}`:(n.charCodeAt(a)===c&&++a,n.slice(a,l))},toNamespacedPath(e){if("string"!=typeof e||0===e.length)return e;const t=b.resolve(e);if(t.length<=2)return e;if(t.charCodeAt(0)===c){if(t.charCodeAt(1)===c){const e=t.charCodeAt(2);if(63!==e&&e!==l)return`\\\\?\\UNC\\${t.slice(2)}`}}else if(A(t.charCodeAt(0))&&t.charCodeAt(1)===d&&t.charCodeAt(2)===c)return`\\\\?\\${t}`;return e},dirname(e){g(e,"path");const t=e.length;if(0===t)return".";let i=-1,n=0;const o=e.charCodeAt(0);if(1===t)return p(o)?e:".";if(p(o)){if(i=n=1,p(e.charCodeAt(1))){let o=2,s=o;for(;o<t&&!p(e.charCodeAt(o));)o++;if(o<t&&o!==s){for(s=o;o<t&&p(e.charCodeAt(o));)o++;if(o<t&&o!==s){for(s=o;o<t&&!p(e.charCodeAt(o));)o++;if(o===t)return e;o!==s&&(i=n=o+1)}}}}else A(o)&&e.charCodeAt(1)===d&&(i=t>2&&p(e.charCodeAt(2))?3:2,n=i);let s=-1,r=!0;for(let i=t-1;i>=n;--i)if(p(e.charCodeAt(i))){if(!r){s=i;break}}else r=!1;if(-1===s){if(-1===i)return".";s=i}return e.slice(0,s)},basename(e,t){void 0!==t&&g(t,"ext"),g(e,"path");let i,n=0,o=-1,s=!0;if(e.length>=2&&A(e.charCodeAt(0))&&e.charCodeAt(1)===d&&(n=2),void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let r=t.length-1,a=-1;for(i=e.length-1;i>=n;--i){const l=e.charCodeAt(i);if(p(l)){if(!s){n=i+1;break}}else-1===a&&(s=!1,a=i+1),r>=0&&(l===t.charCodeAt(r)?-1==--r&&(o=i):(r=-1,o=a))}return n===o?o=a:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=n;--i)if(p(e.charCodeAt(i))){if(!s){n=i+1;break}}else-1===o&&(s=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){g(e,"path");let t=0,i=-1,n=0,o=-1,s=!0,r=0;e.length>=2&&e.charCodeAt(1)===d&&A(e.charCodeAt(0))&&(t=n=2);for(let a=e.length-1;a>=t;--a){const t=e.charCodeAt(a);if(p(t)){if(!s){n=a+1;break}}else-1===o&&(s=!1,o=a+1),t===l?-1===i?i=a:1!==r&&(r=1):-1!==i&&(r=-1)}return-1===i||-1===o||0===r||1===r&&i===o-1&&i===n+1?"":e.slice(i,o)},format:w.bind(null,"\\"),parse(e){g(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.length;let n=0,o=e.charCodeAt(0);if(1===i)return p(o)?(t.root=t.dir=e,t):(t.base=t.name=e,t);if(p(o)){if(n=1,p(e.charCodeAt(1))){let t=2,o=t;for(;t<i&&!p(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&p(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&!p(e.charCodeAt(t));)t++;t===i?n=t:t!==o&&(n=t+1)}}}}else if(A(o)&&e.charCodeAt(1)===d){if(i<=2)return t.root=t.dir=e,t;if(n=2,p(e.charCodeAt(2))){if(3===i)return t.root=t.dir=e,t;n=3}}n>0&&(t.root=e.slice(0,n));let s=-1,r=n,a=-1,h=!0,c=e.length-1,u=0;for(;c>=n;--c)if(o=e.charCodeAt(c),p(o)){if(!h){r=c+1;break}}else-1===a&&(h=!1,a=c+1),o===l?-1===s?s=c:1!==u&&(u=1):-1!==s&&(u=-1);return-1!==a&&(-1===s||0===u||1===u&&s===a-1&&s===r+1?t.base=t.name=e.slice(r,a):(t.name=e.slice(r,s),t.base=e.slice(r,a),t.ext=e.slice(s,a))),t.dir=r>0&&r!==n?e.slice(0,r-1):t.root,t},sep:"\\",delimiter:";",win32:null,posix:null},v=(()=>{if(m){const e=/\\/g;return()=>{const t=s().replace(e,"/");return t.slice(t.indexOf("/"))}}return()=>s()})(),C={resolve(...e){let t="",i=!1;for(let n=e.length-1;n>=-1&&!i;n--){const o=n>=0?e[n]:v();g(o,"path"),0!==o.length&&(t=`${o}/${t}`,i=o.charCodeAt(0)===h)}return t=_(t,!i,"/",f),i?`/${t}`:t.length>0?t:"."},normalize(e){if(g(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===h,i=e.charCodeAt(e.length-1)===h;return 0===(e=_(e,!t,"/",f)).length?t?"/":i?"./":".":(i&&(e+="/"),t?`/${e}`:e)},isAbsolute:e=>(g(e,"path"),e.length>0&&e.charCodeAt(0)===h),join(...e){if(0===e.length)return".";let t;for(let i=0;i<e.length;++i){const n=e[i];g(n,"path"),n.length>0&&(void 0===t?t=n:t+=`/${n}`)}return void 0===t?".":C.normalize(t)},relative(e,t){if(g(e,"from"),g(t,"to"),e===t)return"";if((e=C.resolve(e))===(t=C.resolve(t)))return"";const i=e.length,n=i-1,o=t.length-1,s=n<o?n:o;let r=-1,a=0;for(;a<s;a++){const i=e.charCodeAt(1+a);if(i!==t.charCodeAt(1+a))break;i===h&&(r=a)}if(a===s)if(o>s){if(t.charCodeAt(1+a)===h)return t.slice(1+a+1);if(0===a)return t.slice(1+a)}else n>s&&(e.charCodeAt(1+a)===h?r=a:0===a&&(r=0));let l="";for(a=1+r+1;a<=i;++a)a!==i&&e.charCodeAt(a)!==h||(l+=0===l.length?"..":"/..");return`${l}${t.slice(1+r)}`},toNamespacedPath:e=>e,dirname(e){if(g(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===h;let i=-1,n=!0;for(let t=e.length-1;t>=1;--t)if(e.charCodeAt(t)===h){if(!n){i=t;break}}else n=!1;return-1===i?t?"/":".":t&&1===i?"//":e.slice(0,i)},basename(e,t){void 0!==t&&g(t,"ext"),g(e,"path");let i,n=0,o=-1,s=!0;if(void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let r=t.length-1,a=-1;for(i=e.length-1;i>=0;--i){const l=e.charCodeAt(i);if(l===h){if(!s){n=i+1;break}}else-1===a&&(s=!1,a=i+1),r>=0&&(l===t.charCodeAt(r)?-1==--r&&(o=i):(r=-1,o=a))}return n===o?o=a:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=0;--i)if(e.charCodeAt(i)===h){if(!s){n=i+1;break}}else-1===o&&(s=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){g(e,"path");let t=-1,i=0,n=-1,o=!0,s=0;for(let r=e.length-1;r>=0;--r){const a=e.charCodeAt(r);if(a!==h)-1===n&&(o=!1,n=r+1),a===l?-1===t?t=r:1!==s&&(s=1):-1!==t&&(s=-1);else if(!o){i=r+1;break}}return-1===t||-1===n||0===s||1===s&&t===n-1&&t===i+1?"":e.slice(t,n)},format:w.bind(null,"/"),parse(e){g(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.charCodeAt(0)===h;let n;i?(t.root="/",n=1):n=0;let o=-1,s=0,r=-1,a=!0,c=e.length-1,d=0;for(;c>=n;--c){const t=e.charCodeAt(c);if(t!==h)-1===r&&(a=!1,r=c+1),t===l?-1===o?o=c:1!==d&&(d=1):-1!==o&&(d=-1);else if(!a){s=c+1;break}}if(-1!==r){const n=0===s&&i?1:s;-1===o||0===d||1===d&&o===r-1&&o===s+1?t.base=t.name=e.slice(n,r):(t.name=e.slice(n,o),t.base=e.slice(n,r),t.ext=e.slice(o,r))}return s>0?t.dir=e.slice(0,s-1):i&&(t.dir="/"),t},sep:"/",delimiter:":",win32:null,posix:null};C.win32=b.win32=b,C.posix=b.posix=C;const y=m?b.normalize:C.normalize,S=m?b.resolve:C.resolve,k=m?b.relative:C.relative,E=m?b.dirname:C.dirname,D=m?b.basename:C.basename,x=m?b.extname:C.extname,L=m?b.sep:C.sep},4541:(e,t,i)=>{i.d(t,{Fr:()=>N,H8:()=>H,HZ:()=>M,OS:()=>O,UP:()=>U,_p:()=>R,cm:()=>Q,gm:()=>W,ib:()=>L,j9:()=>x,nr:()=>V,p7:()=>I,uF:()=>E,un:()=>B,zQ:()=>v,zx:()=>D});var n,o=i(1759);const s="en";let r,a,l=!1,h=!1,c=!1,d=!1,u=!1,g=!1,m=!1,p=!1,f=!1,A=!1,_=null,w=null,b=null;const v="object"==typeof self?self:"object"==typeof i.g?i.g:{};let C;void 0!==v.vscode&&void 0!==v.vscode.process?C=v.vscode.process:"undefined"!=typeof process&&(C=process);const y="string"==typeof(null===(n=null==C?void 0:C.versions)||void 0===n?void 0:n.electron),S=y&&"renderer"===(null==C?void 0:C.type);if("object"!=typeof navigator||S)if("object"==typeof C){l="win32"===C.platform,h="darwin"===C.platform,c="linux"===C.platform,d=c&&!!C.env.SNAP&&!!C.env.SNAP_REVISION,m=y,f=!!C.env.CI||!!C.env.BUILD_ARTIFACTSTAGINGDIRECTORY,r=s,_=s;const t=C.env.VSCODE_NLS_CONFIG;if(t)try{const e=JSON.parse(t),i=e.availableLanguages["*"];r=e.locale,w=e.osLocale,_=i||s,b=e._translationsConfigFile}catch(e){}u=!0}else console.error("Unable to resolve platform.");else a=navigator.userAgent,l=a.indexOf("Windows")>=0,h=a.indexOf("Macintosh")>=0,p=(a.indexOf("Macintosh")>=0||a.indexOf("iPad")>=0||a.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,c=a.indexOf("Linux")>=0,A=(null==a?void 0:a.indexOf("Mobi"))>=0,g=!0,r=o.AM(o.kg({key:"ensureLoaderPluginIsLoaded",comment:["{Locked}"]},"_"))||s,_=r,w=navigator.language;let k=0;h?k=1:l?k=3:c&&(k=2);const E=l,D=h,x=c,L=u,M=g,I=g&&"function"==typeof v.importScripts,B=p,N=A,T=a,F="function"==typeof v.postMessage&&!v.importScripts,R=(()=>{if(F){const e=[];v.addEventListener("message",(t=>{if(t.data&&t.data.vscodeScheduleAsyncWork)for(let i=0,n=e.length;i<n;i++){const n=e[i];if(n.id===t.data.vscodeScheduleAsyncWork)return e.splice(i,1),void n.callback()}}));let t=0;return i=>{const n=++t;e.push({id:n,callback:i}),v.postMessage({vscodeScheduleAsyncWork:n},"*")}}return e=>setTimeout(e)})(),O=h||p?2:l?1:3;let P=!0,z=!1;function Q(){if(!z){z=!0;const e=new Uint8Array(2);e[0]=1,e[1]=2;const t=new Uint16Array(e.buffer);P=513===t[0]}return P}const H=!!(T&&T.indexOf("Chrome")>=0),W=!!(T&&T.indexOf("Firefox")>=0),V=!!(!H&&T&&T.indexOf("Safari")>=0),U=!!(T&&T.indexOf("Edg/")>=0);T&&T.indexOf("Android")},4101:(e,t,i)=>{var n;i.d(t,{Q:()=>n}),function(e){function t(e,t){if(e.start>=t.end||t.start>=e.end)return{start:0,end:0};const i=Math.max(e.start,t.start),n=Math.min(e.end,t.end);return n-i<=0?{start:0,end:0}:{start:i,end:n}}function i(e){return e.end-e.start<=0}e.intersect=t,e.isEmpty=i,e.intersects=function(e,n){return!i(t(e,n))},e.relativeComplement=function(e,t){const n=[],o={start:e.start,end:Math.min(t.start,e.end)},s={start:Math.max(t.end,e.start),end:e.end};return i(o)||n.push(o),i(s)||n.push(s),n}}(n||(n={}))},9405:(e,t,i)=>{i.d(t,{B6:()=>b,Fd:()=>f,LC:()=>m,P8:()=>g,n4:()=>u,o1:()=>A,pD:()=>p});var n=i(7224),o=i(7446),s=i(1331),r=i(4541),a=i(5306),l=i(6926);function h(e){return(0,l.I)(e,!0)}class c{constructor(e){this._ignorePathCasing=e}compare(e,t,i=!1){return e===t?0:(0,a.UD)(this.getComparisonKey(e,i),this.getComparisonKey(t,i))}isEqual(e,t,i=!1){return e===t||!(!e||!t)&&this.getComparisonKey(e,i)===this.getComparisonKey(t,i)}getComparisonKey(e,t=!1){return e.with({path:this._ignorePathCasing(e)?e.path.toLowerCase():void 0,fragment:t?null:void 0}).toString()}isEqualOrParent(e,t,i=!1){if(e.scheme===t.scheme){if(e.scheme===o.ny.file)return n._1(h(e),h(t),this._ignorePathCasing(e))&&e.query===t.query&&(i||e.fragment===t.fragment);if(_(e.authority,t.authority))return n._1(e.path,t.path,this._ignorePathCasing(e),"/")&&e.query===t.query&&(i||e.fragment===t.fragment)}return!1}joinPath(e,...t){return l.r.joinPath(e,...t)}basenameOrAuthority(e){return g(e)||e.authority}basename(e){return s.SA.basename(e.path)}extname(e){return s.SA.extname(e.path)}dirname(e){if(0===e.path.length)return e;let t;return e.scheme===o.ny.file?t=l.r.file(s.pD(h(e))).path:(t=s.SA.dirname(e.path),e.authority&&t.length&&47!==t.charCodeAt(0)&&(console.error(`dirname("${e.toString})) resulted in a relative path`),t="/")),e.with({path:t})}normalizePath(e){if(!e.path.length)return e;let t;return t=e.scheme===o.ny.file?l.r.file(s.S8(h(e))).path:s.SA.normalize(e.path),e.with({path:t})}relativePath(e,t){if(e.scheme!==t.scheme||!_(e.authority,t.authority))return;if(e.scheme===o.ny.file){const i=s.V8(h(e),h(t));return r.uF?n.TH(i):i}let i=e.path||"/";const a=t.path||"/";if(this._ignorePathCasing(e)){let e=0;for(const t=Math.min(i.length,a.length);e<t&&(i.charCodeAt(e)===a.charCodeAt(e)||i.charAt(e).toLowerCase()===a.charAt(e).toLowerCase());e++);i=a.substr(0,e)+i.substr(e)}return s.SA.relative(i,a)}resolvePath(e,t){if(e.scheme===o.ny.file){const i=l.r.file(s.hd(h(e),t));return e.with({authority:i.authority,path:i.path})}return t=n.kb(t),e.with({path:s.SA.resolve(e.path,t)})}isAbsolutePath(e){return!!e.path&&"/"===e.path[0]}isEqualAuthority(e,t){return e===t||void 0!==e&&void 0!==t&&(0,a.Q_)(e,t)}hasTrailingPathSeparator(e,t=s.Vn){if(e.scheme===o.ny.file){const i=h(e);return i.length>n.Zn(i).length&&i[i.length-1]===t}{const t=e.path;return t.length>1&&47===t.charCodeAt(t.length-1)&&!/^[a-zA-Z]:(\/$|\\$)/.test(e.fsPath)}}removeTrailingPathSeparator(e,t=s.Vn){return w(e,t)?e.with({path:e.path.substr(0,e.path.length-1)}):e}addTrailingPathSeparator(e,t=s.Vn){let i=!1;if(e.scheme===o.ny.file){const o=h(e);i=void 0!==o&&o.length===n.Zn(o).length&&o[o.length-1]===t}else{t="/";const n=e.path;i=1===n.length&&47===n.charCodeAt(n.length-1)}return i||w(e,t)?e:e.with({path:e.path+"/"})}}const d=new c((()=>!1)),u=(new c((e=>e.scheme!==o.ny.file||!r.j9)),new c((e=>!0)),d.isEqual.bind(d)),g=(d.isEqualOrParent.bind(d),d.getComparisonKey.bind(d),d.basenameOrAuthority.bind(d),d.basename.bind(d)),m=d.extname.bind(d),p=d.dirname.bind(d),f=(d.joinPath.bind(d),d.normalizePath.bind(d)),A=(d.relativePath.bind(d),d.resolvePath.bind(d)),_=(d.isAbsolutePath.bind(d),d.isEqualAuthority.bind(d)),w=d.hasTrailingPathSeparator.bind(d);var b;d.removeTrailingPathSeparator.bind(d),d.addTrailingPathSeparator.bind(d),function(e){e.META_DATA_LABEL="label",e.META_DATA_DESCRIPTION="description",e.META_DATA_SIZE="size",e.META_DATA_MIME="mime",e.parseMetaData=function(t){const i=new Map;t.path.substring(t.path.indexOf(";")+1,t.path.lastIndexOf(";")).split(";").forEach((e=>{const[t,n]=e.split(":");t&&n&&i.set(t,n)}));const n=t.path.substring(0,t.path.indexOf(";"));return n&&i.set(e.META_DATA_MIME,n),i}}(b||(b={}))},1955:(e,t,i)=>{i.d(t,{yE:()=>r});var n=i(3884),o=i(8300);class s{constructor(e,t,i,n,o,s,r){this._forceIntegerValues=e,this._scrollStateBrand=void 0,this._forceIntegerValues&&(t|=0,i|=0,n|=0,o|=0,s|=0,r|=0),this.rawScrollLeft=n,this.rawScrollTop=r,t<0&&(t=0),n+t>i&&(n=i-t),n<0&&(n=0),o<0&&(o=0),r+o>s&&(r=s-o),r<0&&(r=0),this.width=t,this.scrollWidth=i,this.scrollLeft=n,this.height=o,this.scrollHeight=s,this.scrollTop=r}equals(e){return this.rawScrollLeft===e.rawScrollLeft&&this.rawScrollTop===e.rawScrollTop&&this.width===e.width&&this.scrollWidth===e.scrollWidth&&this.scrollLeft===e.scrollLeft&&this.height===e.height&&this.scrollHeight===e.scrollHeight&&this.scrollTop===e.scrollTop}withScrollDimensions(e,t){return new s(this._forceIntegerValues,void 0!==e.width?e.width:this.width,void 0!==e.scrollWidth?e.scrollWidth:this.scrollWidth,t?this.rawScrollLeft:this.scrollLeft,void 0!==e.height?e.height:this.height,void 0!==e.scrollHeight?e.scrollHeight:this.scrollHeight,t?this.rawScrollTop:this.scrollTop)}withScrollPosition(e){return new s(this._forceIntegerValues,this.width,this.scrollWidth,void 0!==e.scrollLeft?e.scrollLeft:this.rawScrollLeft,this.height,this.scrollHeight,void 0!==e.scrollTop?e.scrollTop:this.rawScrollTop)}createScrollEvent(e,t){const i=this.width!==e.width,n=this.scrollWidth!==e.scrollWidth,o=this.scrollLeft!==e.scrollLeft,s=this.height!==e.height,r=this.scrollHeight!==e.scrollHeight,a=this.scrollTop!==e.scrollTop;return{inSmoothScrolling:t,oldWidth:e.width,oldScrollWidth:e.scrollWidth,oldScrollLeft:e.scrollLeft,width:this.width,scrollWidth:this.scrollWidth,scrollLeft:this.scrollLeft,oldHeight:e.height,oldScrollHeight:e.scrollHeight,oldScrollTop:e.scrollTop,height:this.height,scrollHeight:this.scrollHeight,scrollTop:this.scrollTop,widthChanged:i,scrollWidthChanged:n,scrollLeftChanged:o,heightChanged:s,scrollHeightChanged:r,scrollTopChanged:a}}}class r extends o.jG{constructor(e){super(),this._scrollableBrand=void 0,this._onScroll=this._register(new n.vl),this.onScroll=this._onScroll.event,this._smoothScrollDuration=e.smoothScrollDuration,this._scheduleAtNextAnimationFrame=e.scheduleAtNextAnimationFrame,this._state=new s(e.forceIntegerValues,0,0,0,0,0,0),this._smoothScrolling=null}dispose(){this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),super.dispose()}setSmoothScrollDuration(e){this._smoothScrollDuration=e}validateScrollPosition(e){return this._state.withScrollPosition(e)}getScrollDimensions(){return this._state}setScrollDimensions(e,t){var i;const n=this._state.withScrollDimensions(e,t);this._setState(n,Boolean(this._smoothScrolling)),null===(i=this._smoothScrolling)||void 0===i||i.acceptScrollDimensions(this._state)}getFutureScrollPosition(){return this._smoothScrolling?this._smoothScrolling.to:this._state}getCurrentScrollPosition(){return this._state}setScrollPositionNow(e){const t=this._state.withScrollPosition(e);this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),this._setState(t,!1)}setScrollPositionSmooth(e,t){if(0===this._smoothScrollDuration)return this.setScrollPositionNow(e);if(this._smoothScrolling){e={scrollLeft:void 0===e.scrollLeft?this._smoothScrolling.to.scrollLeft:e.scrollLeft,scrollTop:void 0===e.scrollTop?this._smoothScrolling.to.scrollTop:e.scrollTop};const i=this._state.withScrollPosition(e);if(this._smoothScrolling.to.scrollLeft===i.scrollLeft&&this._smoothScrolling.to.scrollTop===i.scrollTop)return;let n;n=t?new h(this._smoothScrolling.from,i,this._smoothScrolling.startTime,this._smoothScrolling.duration):this._smoothScrolling.combine(this._state,i,this._smoothScrollDuration),this._smoothScrolling.dispose(),this._smoothScrolling=n}else{const t=this._state.withScrollPosition(e);this._smoothScrolling=h.start(this._state,t,this._smoothScrollDuration)}this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))}hasPendingScrollAnimation(){return Boolean(this._smoothScrolling)}_performSmoothScrolling(){if(!this._smoothScrolling)return;const e=this._smoothScrolling.tick(),t=this._state.withScrollPosition(e);return this._setState(t,!0),this._smoothScrolling?e.isDone?(this._smoothScrolling.dispose(),void(this._smoothScrolling=null)):void(this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))):void 0}_setState(e,t){const i=this._state;i.equals(e)||(this._state=e,this._onScroll.fire(this._state.createScrollEvent(i,t)))}}class a{constructor(e,t,i){this.scrollLeft=e,this.scrollTop=t,this.isDone=i}}function l(e,t){const i=t-e;return function(t){return e+i*(1-(n=1-t,Math.pow(n,3)));var n}}class h{constructor(e,t,i,n){this.from=e,this.to=t,this.duration=n,this.startTime=i,this.animationFrameDisposable=null,this._initAnimations()}_initAnimations(){this.scrollLeft=this._initAnimation(this.from.scrollLeft,this.to.scrollLeft,this.to.width),this.scrollTop=this._initAnimation(this.from.scrollTop,this.to.scrollTop,this.to.height)}_initAnimation(e,t,i){if(Math.abs(e-t)>2.5*i){let r,a;return e<t?(r=e+.75*i,a=t-.75*i):(r=e-.75*i,a=t+.75*i),n=l(e,r),o=l(a,t),s=.33,function(e){return e<s?n(e/s):o((e-s)/(1-s))}}var n,o,s;return l(e,t)}dispose(){null!==this.animationFrameDisposable&&(this.animationFrameDisposable.dispose(),this.animationFrameDisposable=null)}acceptScrollDimensions(e){this.to=e.withScrollPosition(this.to),this._initAnimations()}tick(){return this._tick(Date.now())}_tick(e){const t=(e-this.startTime)/this.duration;if(t<1){const e=this.scrollLeft(t),i=this.scrollTop(t);return new a(e,i,!1)}return new a(this.to.scrollLeft,this.to.scrollTop,!0)}combine(e,t,i){return h.start(e,t,i)}static start(e,t,i){i+=10;const n=Date.now()-10;return new h(e,t,n,i)}}},7333:(e,t,i)=>{i.d(t,{A:()=>s});var n,o=i(5306);!function(e){e[e.Ignore=0]="Ignore",e[e.Info=1]="Info",e[e.Warning=2]="Warning",e[e.Error=3]="Error"}(n||(n={})),function(e){const t="error",i="warning",n="info";e.fromValue=function(s){return s?o.Q_(t,s)?e.Error:o.Q_(i,s)||o.Q_("warn",s)?e.Warning:o.Q_(n,s)?e.Info:e.Ignore:e.Ignore},e.toString=function(o){switch(o){case e.Error:return t;case e.Warning:return i;case e.Info:return n;default:return"ignore"}}}(n||(n={}));const s=n},3839:(e,t,i)=>{i.d(t,{W:()=>s});var n=i(4541);const o=n.zQ.performance&&"function"==typeof n.zQ.performance.now;class s{static create(e=!0){return new s(e)}constructor(e){this._highResolution=o&&e,this._startTime=this._now(),this._stopTime=-1}stop(){this._stopTime=this._now()}elapsed(){return-1!==this._stopTime?this._stopTime-this._startTime:this._now()-this._startTime}_now(){return this._highResolution?n.zQ.performance.now():Date.now()}}},5306:(e,t,i)=>{i.d(t,{$X:()=>G,AV:()=>r,BO:()=>u,Bm:()=>g,DB:()=>k,E_:()=>W,GP:()=>l,HG:()=>_,LJ:()=>N,LU:()=>q,Lv:()=>E,MV:()=>z,NB:()=>d,OS:()=>m,Q_:()=>x,Qp:()=>M,RH:()=>f,Ss:()=>Y,UD:()=>v,UU:()=>w,Vi:()=>I,W1:()=>y,Wd:()=>ee,Wv:()=>D,Z5:()=>F,_J:()=>j,aC:()=>U,bm:()=>c,eY:()=>p,ih:()=>h,iy:()=>P,km:()=>O,lF:()=>C,lT:()=>b,m:()=>Q,ne:()=>K,ns:()=>L,pc:()=>B,r_:()=>J,tk:()=>$,tl:()=>ie,uz:()=>A,y_:()=>ne,z_:()=>T,zd:()=>S});var n,o=i(38),s=i(4100);function r(e){return!e||"string"!=typeof e||0===e.trim().length}const a=/{(\d+)}/g;function l(e,...t){return 0===t.length?e:e.replace(a,(function(e,i){const n=parseInt(i,10);return isNaN(n)||n<0||n>=t.length?e:t[n]}))}function h(e){return e.replace(/[<>&]/g,(function(e){switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";default:return e}}))}function c(e){return e.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g,"\\$&")}function d(e,t){if(!e||!t)return e;const i=t.length;if(0===i||0===e.length)return e;let n=0;for(;e.indexOf(t,n)===n;)n+=i;return e.substring(n)}function u(e,t){if(!e||!t)return e;const i=t.length,n=e.length;if(0===i||0===n)return e;let o=n,s=-1;for(;s=e.lastIndexOf(t,o-1),-1!==s&&s+i===o;){if(0===s)return"";o=s}return e.substring(0,o)}function g(e){return e.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g,"\\$&").replace(/[\*]/g,".*")}function m(e,t,i={}){if(!e)throw new Error("Cannot create regex from empty string");t||(e=c(e)),i.wholeWord&&(/\B/.test(e.charAt(0))||(e="\\b"+e),/\B/.test(e.charAt(e.length-1))||(e+="\\b"));let n="";return i.global&&(n+="g"),i.matchCase||(n+="i"),i.multiline&&(n+="m"),i.unicode&&(n+="u"),new RegExp(e,n)}function p(e){return"^"!==e.source&&"^$"!==e.source&&"$"!==e.source&&"^\\s*$"!==e.source&&!(!e.exec("")||0!==e.lastIndex)}function f(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.unicode?"u":"")}function A(e){return e.split(/\r\n|\r|\n/)}function _(e){for(let t=0,i=e.length;t<i;t++){const i=e.charCodeAt(t);if(32!==i&&9!==i)return t}return-1}function w(e,t=0,i=e.length){for(let n=t;n<i;n++){const i=e.charCodeAt(n);if(32!==i&&9!==i)return e.substring(t,n)}return e.substring(t,i)}function b(e,t=e.length-1){for(let i=t;i>=0;i--){const t=e.charCodeAt(i);if(32!==t&&9!==t)return i}return-1}function v(e,t){return e<t?-1:e>t?1:0}function C(e,t,i=0,n=e.length,o=0,s=t.length){for(;i<n&&o<s;i++,o++){const n=e.charCodeAt(i),s=t.charCodeAt(o);if(n<s)return-1;if(n>s)return 1}const r=n-i,a=s-o;return r<a?-1:r>a?1:0}function y(e,t){return S(e,t,0,e.length,0,t.length)}function S(e,t,i=0,n=e.length,o=0,s=t.length){for(;i<n&&o<s;i++,o++){let r=e.charCodeAt(i),a=t.charCodeAt(o);if(r===a)continue;if(r>=128||a>=128)return C(e.toLowerCase(),t.toLowerCase(),i,n,o,s);E(r)&&(r-=32),E(a)&&(a-=32);const l=r-a;if(0!==l)return l}const r=n-i,a=s-o;return r<a?-1:r>a?1:0}function k(e){return e>=48&&e<=57}function E(e){return e>=97&&e<=122}function D(e){return e>=65&&e<=90}function x(e,t){return e.length===t.length&&0===S(e,t)}function L(e,t){const i=t.length;return!(t.length>e.length)&&0===S(e,t,0,i)}function M(e,t){const i=Math.min(e.length,t.length);let n;for(n=0;n<i;n++)if(e.charCodeAt(n)!==t.charCodeAt(n))return n;return i}function I(e,t){const i=Math.min(e.length,t.length);let n;const o=e.length-1,s=t.length-1;for(n=0;n<i;n++)if(e.charCodeAt(o-n)!==t.charCodeAt(s-n))return n;return i}function B(e){return 55296<=e&&e<=56319}function N(e){return 56320<=e&&e<=57343}function T(e,t){return t-56320+(e-55296<<10)+65536}function F(e,t,i){const n=e.charCodeAt(i);if(B(n)&&i+1<t){const t=e.charCodeAt(i+1);if(N(t))return T(n,t)}return n}class R{get offset(){return this._offset}constructor(e,t=0){this._str=e,this._len=e.length,this._offset=t}setOffset(e){this._offset=e}prevCodePoint(){const e=function(e,t){const i=e.charCodeAt(t-1);if(N(i)&&t>1){const n=e.charCodeAt(t-2);if(B(n))return T(n,i)}return i}(this._str,this._offset);return this._offset-=e>=65536?2:1,e}nextCodePoint(){const e=F(this._str,this._len,this._offset);return this._offset+=e>=65536?2:1,e}eol(){return this._offset>=this._len}}class O{get offset(){return this._iterator.offset}constructor(e,t=0){this._iterator=new R(e,t)}nextGraphemeLength(){const e=Z.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.nextCodePoint());for(;!t.eol();){const i=t.offset,o=e.getGraphemeBreakType(t.nextCodePoint());if(X(n,o)){t.setOffset(i);break}n=o}return t.offset-i}prevGraphemeLength(){const e=Z.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.prevCodePoint());for(;t.offset>0;){const i=t.offset,o=e.getGraphemeBreakType(t.prevCodePoint());if(X(o,n)){t.setOffset(i);break}n=o}return i-t.offset}eol(){return this._iterator.eol()}}function P(e,t){return new O(e,t).nextGraphemeLength()}function z(e,t){return new O(e,t).prevGraphemeLength()}function Q(e,t){t>0&&N(e.charCodeAt(t))&&t--;const i=t+P(e,t);return[i-z(e,i),i]}let H;function W(e){return H||(H=/(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u088E\u08A0-\u08C9\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDC7\uFDF0-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE35\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDD23\uDE80-\uDEA9\uDEAD-\uDF45\uDF51-\uDF81\uDF86-\uDFF6]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD4B-\uDFFF]|\uD83B[\uDC00-\uDEBB])/),H.test(e)}const V=/^[\t\n\r\x20-\x7E]*$/;function U(e){return V.test(e)}const j=/[\u2028\u2029]/;function G(e){return j.test(e)}function K(e){return e>=11904&&e<=55215||e>=63744&&e<=64255||e>=65281&&e<=65374}function Y(e){return e>=127462&&e<=127487||8986===e||8987===e||9200===e||9203===e||e>=9728&&e<=10175||11088===e||11093===e||e>=127744&&e<=128591||e>=128640&&e<=128764||e>=128992&&e<=129008||e>=129280&&e<=129535||e>=129648&&e<=129782}const J=String.fromCharCode(65279);function q(e){return!!(e&&e.length>0&&65279===e.charCodeAt(0))}function $(e){return(e%=52)<26?String.fromCharCode(97+e):String.fromCharCode(65+e-26)}function X(e,t){return 0===e?5!==t&&7!==t:!(2===e&&3===t||4!==e&&2!==e&&3!==e&&4!==t&&2!==t&&3!==t&&(8===e&&(8===t||9===t||11===t||12===t)||!(11!==e&&9!==e||9!==t&&10!==t)||(12===e||10===e)&&10===t||5===t||13===t||7===t||1===e||13===e&&14===t||6===e&&6===t))}class Z{static getInstance(){return Z._INSTANCE||(Z._INSTANCE=new Z),Z._INSTANCE}constructor(){this._data=JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]")}getGraphemeBreakType(e){if(e<32)return 10===e?3:13===e?2:4;if(e<127)return 0;const t=this._data,i=t.length/3;let n=1;for(;n<=i;)if(e<t[3*n])n*=2;else{if(!(e>t[3*n+1]))return t[3*n+2];n=2*n+1}return 0}}function ee(e,t){if(0===e)return 0;const i=function(e,t){const i=new R(t,e);let n=i.prevCodePoint();for(;te(n)||65039===n||8419===n;){if(0===i.offset)return;n=i.prevCodePoint()}if(!Y(n))return;let o=i.offset;return o>0&&8205===i.prevCodePoint()&&(o=i.offset),o}(e,t);if(void 0!==i)return i;const n=new R(t,e);return n.prevCodePoint(),n.offset}function te(e){return 127995<=e&&e<=127999}Z._INSTANCE=null;class ie{static getInstance(e){return ie.cache.get(Array.from(e))}static getLocales(){return ie._locales.value}constructor(e){this.confusableDictionary=e}isAmbiguous(e){return this.confusableDictionary.has(e)}getPrimaryConfusable(e){return this.confusableDictionary.get(e)}getConfusableCodePoints(){return new Set(this.confusableDictionary.keys())}}n=ie,ie.ambiguousCharacterData=new s.d((()=>JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}'))),ie.cache=new o.o((e=>{function t(e){const t=new Map;for(let i=0;i<e.length;i+=2)t.set(e[i],e[i+1]);return t}function i(e,t){if(!e)return t;const i=new Map;for(const[n,o]of e)t.has(n)&&i.set(n,o);return i}const o=n.ambiguousCharacterData.value;let s,r=e.filter((e=>!e.startsWith("_")&&e in o));0===r.length&&(r=["_default"]);for(const e of r)s=i(s,t(o[e]));const a=function(e,t){const i=new Map(e);for(const[e,n]of t)i.set(e,n);return i}(t(o._common),s);return new ie(a)})),ie._locales=new s.d((()=>Object.keys(ie.ambiguousCharacterData.value).filter((e=>!e.startsWith("_")))));class ne{static getRawData(){return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]")}static getData(){return this._data||(this._data=new Set(ne.getRawData())),this._data}static isInvisibleCharacter(e){return ne.getData().has(e)}static get codePoints(){return ne.getData()}}ne._data=void 0},113:(e,t,i)=>{i.d(t,{h:()=>n});const n=Symbol("MicrotaskDelay")},9171:(e,t,i)=>{i.d(t,{cB:()=>h});var n=i(5306);class o{constructor(){this._value="",this._pos=0}reset(e){return this._value=e,this._pos=0,this}next(){return this._pos+=1,this}hasNext(){return this._pos<this._value.length-1}cmp(e){return e.charCodeAt(0)-this._value.charCodeAt(this._pos)}value(){return this._value[this._pos]}}class s{constructor(e=!0){this._caseSensitive=e}reset(e){return this._value=e,this._from=0,this._to=0,this.next()}hasNext(){return this._to<this._value.length}next(){this._from=this._to;let e=!0;for(;this._to<this._value.length;this._to++)if(46===this._value.charCodeAt(this._to)){if(!e)break;this._from++}else e=!1;return this}cmp(e){return this._caseSensitive?(0,n.lF)(e,this._value,0,e.length,this._from,this._to):(0,n.zd)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class r{constructor(e=!0,t=!0){this._splitOnBackslash=e,this._caseSensitive=t}reset(e){this._from=0,this._to=0,this._value=e,this._valueLen=e.length;for(let t=e.length-1;t>=0;t--,this._valueLen--){const e=this._value.charCodeAt(t);if(!(47===e||this._splitOnBackslash&&92===e))break}return this.next()}hasNext(){return this._to<this._valueLen}next(){this._from=this._to;let e=!0;for(;this._to<this._valueLen;this._to++){const t=this._value.charCodeAt(this._to);if(47===t||this._splitOnBackslash&&92===t){if(!e)break;this._from++}else e=!1}return this}cmp(e){return this._caseSensitive?(0,n.lF)(e,this._value,0,e.length,this._from,this._to):(0,n.zd)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class a{constructor(e,t){this._ignorePathCasing=e,this._ignoreQueryAndFragment=t,this._states=[],this._stateIdx=0}reset(e){return this._value=e,this._states=[],this._value.scheme&&this._states.push(1),this._value.authority&&this._states.push(2),this._value.path&&(this._pathIterator=new r(!1,!this._ignorePathCasing(e)),this._pathIterator.reset(e.path),this._pathIterator.value()&&this._states.push(3)),this._ignoreQueryAndFragment(e)||(this._value.query&&this._states.push(4),this._value.fragment&&this._states.push(5)),this._stateIdx=0,this}next(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()?this._pathIterator.next():this._stateIdx+=1,this}hasNext(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()||this._stateIdx<this._states.length-1}cmp(e){if(1===this._states[this._stateIdx])return(0,n.W1)(e,this._value.scheme);if(2===this._states[this._stateIdx])return(0,n.W1)(e,this._value.authority);if(3===this._states[this._stateIdx])return this._pathIterator.cmp(e);if(4===this._states[this._stateIdx])return(0,n.UD)(e,this._value.query);if(5===this._states[this._stateIdx])return(0,n.UD)(e,this._value.fragment);throw new Error}value(){if(1===this._states[this._stateIdx])return this._value.scheme;if(2===this._states[this._stateIdx])return this._value.authority;if(3===this._states[this._stateIdx])return this._pathIterator.value();if(4===this._states[this._stateIdx])return this._value.query;if(5===this._states[this._stateIdx])return this._value.fragment;throw new Error}}class l{constructor(){this.height=1}rotateLeft(){const e=this.right;return this.right=e.left,e.left=this,this.updateHeight(),e.updateHeight(),e}rotateRight(){const e=this.left;return this.left=e.right,e.right=this,this.updateHeight(),e.updateHeight(),e}updateHeight(){this.height=1+Math.max(this.heightLeft,this.heightRight)}balanceFactor(){return this.heightRight-this.heightLeft}get heightLeft(){var e,t;return null!==(t=null===(e=this.left)||void 0===e?void 0:e.height)&&void 0!==t?t:0}get heightRight(){var e,t;return null!==(t=null===(e=this.right)||void 0===e?void 0:e.height)&&void 0!==t?t:0}}class h{static forUris(e=()=>!1,t=()=>!1){return new h(new a(e,t))}static forStrings(){return new h(new o)}static forConfigKeys(){return new h(new s)}constructor(e){this._iter=e}clear(){this._root=void 0}set(e,t){const i=this._iter.reset(e);let n;this._root||(this._root=new l,this._root.segment=i.value());const o=[];for(n=this._root;;){const e=i.cmp(n.segment);if(e>0)n.left||(n.left=new l,n.left.segment=i.value()),o.push([-1,n]),n=n.left;else if(e<0)n.right||(n.right=new l,n.right.segment=i.value()),o.push([1,n]),n=n.right;else{if(!i.hasNext())break;i.next(),n.mid||(n.mid=new l,n.mid.segment=i.value()),o.push([0,n]),n=n.mid}}const s=n.value;n.value=t,n.key=e;for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i<-1||i>1){const i=o[e][0],n=o[e+1][0];if(1===i&&1===n)o[e][1]=t.rotateLeft();else if(-1===i&&-1===n)o[e][1]=t.rotateRight();else if(1===i&&-1===n)t.right=o[e+1][1]=o[e+1][1].rotateRight(),o[e][1]=t.rotateLeft();else{if(-1!==i||1!==n)throw new Error;t.left=o[e+1][1]=o[e+1][1].rotateLeft(),o[e][1]=t.rotateRight()}if(e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}return s}get(e){var t;return null===(t=this._getNode(e))||void 0===t?void 0:t.value}_getNode(e){const t=this._iter.reset(e);let i=this._root;for(;i;){const e=t.cmp(i.segment);if(e>0)i=i.left;else if(e<0)i=i.right;else{if(!t.hasNext())break;t.next(),i=i.mid}}return i}has(e){const t=this._getNode(e);return!(void 0===(null==t?void 0:t.value)&&void 0===(null==t?void 0:t.mid))}delete(e){return this._delete(e,!1)}deleteSuperstr(e){return this._delete(e,!0)}_delete(e,t){var i;const n=this._iter.reset(e),o=[];let s=this._root;for(;s;){const e=n.cmp(s.segment);if(e>0)o.push([-1,s]),s=s.left;else if(e<0)o.push([1,s]),s=s.right;else{if(!n.hasNext())break;n.next(),o.push([0,s]),s=s.mid}}if(s){if(t?(s.left=void 0,s.mid=void 0,s.right=void 0,s.height=1):(s.key=void 0,s.value=void 0),!s.mid&&!s.value)if(s.left&&s.right){const e=this._min(s.right);if(e.key){const{key:t,value:i,segment:n}=e;this._delete(e.key,!1),s.key=t,s.value=i,s.segment=n}}else{const e=null!==(i=s.left)&&void 0!==i?i:s.right;if(o.length>0){const[t,i]=o[o.length-1];switch(t){case-1:i.left=e;break;case 0:i.mid=e;break;case 1:i.right=e}}else this._root=e}for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i>1?(t.right.balanceFactor()>=0||(t.right=t.right.rotateRight()),o[e][1]=t.rotateLeft()):i<-1&&(t.left.balanceFactor()<=0||(t.left=t.left.rotateLeft()),o[e][1]=t.rotateRight()),e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}}_min(e){for(;e.left;)e=e.left;return e}findSubstr(e){const t=this._iter.reset(e);let i,n=this._root;for(;n;){const e=t.cmp(n.segment);if(e>0)n=n.left;else if(e<0)n=n.right;else{if(!t.hasNext())break;t.next(),i=n.value||i,n=n.mid}}return n&&n.value||i}findSuperstr(e){return this._findSuperstrOrElement(e,!1)}_findSuperstrOrElement(e,t){const i=this._iter.reset(e);let n=this._root;for(;n;){const e=i.cmp(n.segment);if(e>0)n=n.left;else if(e<0)n=n.right;else{if(!i.hasNext())return n.mid?this._entries(n.mid):t?n.value:void 0;i.next(),n=n.mid}}}forEach(e){for(const[t,i]of this)e(i,t)}*[Symbol.iterator](){yield*this._entries(this._root)}_entries(e){const t=[];return this._dfsEntries(e,t),t[Symbol.iterator]()}_dfsEntries(e,t){e&&(e.left&&this._dfsEntries(e.left,t),e.value&&t.push([e.key,e.value]),e.mid&&this._dfsEntries(e.mid,t),e.right&&this._dfsEntries(e.right,t))}}},3483:(e,t,i)=>{i.d(t,{L:()=>o});var n,o,s=i(8694);!function(e){e.isThemeColor=function(e){return e&&"object"==typeof e&&"string"==typeof e.id}}(n||(n={})),function(e){e.iconNameSegment="[A-Za-z0-9]+",e.iconNameExpression="[A-Za-z0-9-]+",e.iconModifierExpression="~[A-Za-z]+",e.iconNameCharacter="[A-Za-z0-9~-]";const t=new RegExp(`^(${e.iconNameExpression})(${e.iconModifierExpression})?$`);function i(e){const n=t.exec(e.id);if(!n)return i(s.W.error);const[,o,r]=n,a=["codicon","codicon-"+o];return r&&a.push("codicon-modifier-"+r.substring(1)),a}e.asClassNameArray=i,e.asClassName=function(e){return i(e).join(" ")},e.asCSSSelector=function(e){return"."+i(e).join(".")},e.isThemeIcon=function(e){return e&&"object"==typeof e&&"string"==typeof e.id&&(void 0===e.color||n.isThemeColor(e.color))};const o=new RegExp(`^\\$\\((${e.iconNameExpression}(?:${e.iconModifierExpression})?)\\)$`);e.fromString=function(e){const t=o.exec(e);if(!t)return;const[,i]=t;return{id:i}},e.fromId=function(e){return{id:e}},e.modify=function(e,t){let i=e.id;const n=i.lastIndexOf("~");return-1!==n&&(i=i.substring(0,n)),t&&(i=`${i}~${t}`),{id:i}},e.getModifier=function(e){const t=e.id.lastIndexOf("~");if(-1!==t)return e.id.substring(t+1)},e.isEqual=function(e,t){var i,n;return e.id===t.id&&(null===(i=e.color)||void 0===i?void 0:i.id)===(null===(n=t.color)||void 0===n?void 0:n.id)}}(o||(o={}))},2821:(e,t,i)=>{function n(e){return"string"==typeof e}function o(e){return!("object"!=typeof e||null===e||Array.isArray(e)||e instanceof RegExp||e instanceof Date)}function s(e){const t=Object.getPrototypeOf(Uint8Array);return"object"==typeof e&&e instanceof t}function r(e){return"number"==typeof e&&!isNaN(e)}function a(e){return!!e&&"function"==typeof e[Symbol.iterator]}function l(e){return!0===e||!1===e}function h(e){return void 0===e}function c(e){return!d(e)}function d(e){return h(e)||null===e}function u(e,t){if(!e)throw new Error(t?`Unexpected type, expected '${t}'`:"Unexpected type")}function g(e){return"function"==typeof e}function m(e,t){const i=Math.min(e.length,t.length);for(let n=0;n<i;n++)p(e[n],t[n])}function p(e,t){if(n(t)){if(typeof e!==t)throw new Error(`argument does not match constraint: typeof ${t}`)}else if(g(t)){try{if(e instanceof t)return}catch(e){}if(!d(e)&&e.constructor===t)return;if(1===t.length&&!0===t.call(void 0,e))return;throw new Error("argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true")}}function f(e){return null===e?void 0:e}function A(e){return void 0===e?null:e}i.d(t,{Et:()=>r,Gv:()=>o,Kg:()=>n,Lm:()=>l,O9:()=>c,Tn:()=>g,UH:()=>f,b0:()=>h,cu:()=>A,iu:()=>s,j:()=>u,jx:()=>m,xZ:()=>a,z:()=>d})},946:(e,t,i)=>{function n(e){return e<0?0:e>255?255:0|e}function o(e){return e<0?0:e>4294967295?4294967295:0|e}i.d(t,{W:()=>n,j:()=>o})},6926:(e,t,i)=>{i.d(t,{I:()=>A,r:()=>d});var n=i(1331),o=i(4541);const s=/^\w[\w\d+.-]*$/,r=/^\//,a=/^\/\//,l="",h="/",c=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;class d{static isUri(e){return e instanceof d||!!e&&"string"==typeof e.authority&&"string"==typeof e.fragment&&"string"==typeof e.path&&"string"==typeof e.query&&"string"==typeof e.scheme&&"string"==typeof e.fsPath&&"function"==typeof e.with&&"function"==typeof e.toString}constructor(e,t,i,n,o,c=!1){"object"==typeof e?(this.scheme=e.scheme||l,this.authority=e.authority||l,this.path=e.path||l,this.query=e.query||l,this.fragment=e.fragment||l):(this.scheme=function(e,t){return e||t?e:"file"}(e,c),this.authority=t||l,this.path=function(e,t){switch(e){case"https":case"http":case"file":t?t[0]!==h&&(t=h+t):t=h}return t}(this.scheme,i||l),this.query=n||l,this.fragment=o||l,function(e,t){if(!e.scheme&&t)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${e.authority}", path: "${e.path}", query: "${e.query}", fragment: "${e.fragment}"}`);if(e.scheme&&!s.test(e.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(e.path)if(e.authority){if(!r.test(e.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(a.test(e.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}(this,c))}get fsPath(){return A(this,!1)}with(e){if(!e)return this;let{scheme:t,authority:i,path:n,query:o,fragment:s}=e;return void 0===t?t=this.scheme:null===t&&(t=l),void 0===i?i=this.authority:null===i&&(i=l),void 0===n?n=this.path:null===n&&(n=l),void 0===o?o=this.query:null===o&&(o=l),void 0===s?s=this.fragment:null===s&&(s=l),t===this.scheme&&i===this.authority&&n===this.path&&o===this.query&&s===this.fragment?this:new g(t,i,n,o,s)}static parse(e,t=!1){const i=c.exec(e);return i?new g(i[2]||l,v(i[4]||l),v(i[5]||l),v(i[7]||l),v(i[9]||l),t):new g(l,l,l,l,l)}static file(e){let t=l;if(o.uF&&(e=e.replace(/\\/g,h)),e[0]===h&&e[1]===h){const i=e.indexOf(h,2);-1===i?(t=e.substring(2),e=h):(t=e.substring(2,i),e=e.substring(i)||h)}return new g("file",t,e,l,l)}static from(e,t){return new g(e.scheme,e.authority,e.path,e.query,e.fragment,t)}static joinPath(e,...t){if(!e.path)throw new Error("[UriError]: cannot call joinPath on URI without path");let i;return i=o.uF&&"file"===e.scheme?d.file(n.IN.join(A(e,!0),...t)).path:n.SA.join(e.path,...t),e.with({path:i})}toString(e=!1){return _(this,e)}toJSON(){return this}static revive(e){var t,i;if(e){if(e instanceof d)return e;{const n=new g(e);return n._formatted=null!==(t=e.external)&&void 0!==t?t:null,n._fsPath=e._sep===u&&null!==(i=e.fsPath)&&void 0!==i?i:null,n}}return e}}const u=o.uF?1:void 0;class g extends d{constructor(){super(...arguments),this._formatted=null,this._fsPath=null}get fsPath(){return this._fsPath||(this._fsPath=A(this,!1)),this._fsPath}toString(e=!1){return e?_(this,!0):(this._formatted||(this._formatted=_(this,!1)),this._formatted)}toJSON(){const e={$mid:1};return this._fsPath&&(e.fsPath=this._fsPath,e._sep=u),this._formatted&&(e.external=this._formatted),this.path&&(e.path=this.path),this.scheme&&(e.scheme=this.scheme),this.authority&&(e.authority=this.authority),this.query&&(e.query=this.query),this.fragment&&(e.fragment=this.fragment),e}}const m={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function p(e,t,i){let n,o=-1;for(let s=0;s<e.length;s++){const r=e.charCodeAt(s);if(r>=97&&r<=122||r>=65&&r<=90||r>=48&&r<=57||45===r||46===r||95===r||126===r||t&&47===r||i&&91===r||i&&93===r||i&&58===r)-1!==o&&(n+=encodeURIComponent(e.substring(o,s)),o=-1),void 0!==n&&(n+=e.charAt(s));else{void 0===n&&(n=e.substr(0,s));const t=m[r];void 0!==t?(-1!==o&&(n+=encodeURIComponent(e.substring(o,s)),o=-1),n+=t):-1===o&&(o=s)}}return-1!==o&&(n+=encodeURIComponent(e.substring(o))),void 0!==n?n:e}function f(e){let t;for(let i=0;i<e.length;i++){const n=e.charCodeAt(i);35===n||63===n?(void 0===t&&(t=e.substr(0,i)),t+=m[n]):void 0!==t&&(t+=e[i])}return void 0!==t?t:e}function A(e,t){let i;return i=e.authority&&e.path.length>1&&"file"===e.scheme?`//${e.authority}${e.path}`:47===e.path.charCodeAt(0)&&(e.path.charCodeAt(1)>=65&&e.path.charCodeAt(1)<=90||e.path.charCodeAt(1)>=97&&e.path.charCodeAt(1)<=122)&&58===e.path.charCodeAt(2)?t?e.path.substr(1):e.path[1].toLowerCase()+e.path.substr(2):e.path,o.uF&&(i=i.replace(/\//g,"\\")),i}function _(e,t){const i=t?f:p;let n="",{scheme:o,authority:s,path:r,query:a,fragment:l}=e;if(o&&(n+=o,n+=":"),(s||"file"===o)&&(n+=h,n+=h),s){let e=s.indexOf("@");if(-1!==e){const t=s.substr(0,e);s=s.substr(e+1),e=t.lastIndexOf(":"),-1===e?n+=i(t,!1,!1):(n+=i(t.substr(0,e),!1,!1),n+=":",n+=i(t.substr(e+1),!1,!0)),n+="@"}s=s.toLowerCase(),e=s.lastIndexOf(":"),-1===e?n+=i(s,!1,!0):(n+=i(s.substr(0,e),!1,!0),n+=s.substr(e))}if(r){if(r.length>=3&&47===r.charCodeAt(0)&&58===r.charCodeAt(2)){const e=r.charCodeAt(1);e>=65&&e<=90&&(r=`/${String.fromCharCode(e+32)}:${r.substr(3)}`)}else if(r.length>=2&&58===r.charCodeAt(1)){const e=r.charCodeAt(0);e>=65&&e<=90&&(r=`${String.fromCharCode(e+32)}:${r.substr(2)}`)}n+=i(r,!0,!1)}return a&&(n+="?",n+=i(a,!1,!1)),l&&(n+="#",n+=t?l:p(l,!1,!1)),n}function w(e){try{return decodeURIComponent(e)}catch(t){return e.length>3?e.substr(0,3)+w(e.substr(3)):e}}const b=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function v(e){return e.match(b)?e.replace(b,(e=>w(e))):e}},9022:(e,t,i)=>{i.r(t),i.d(t,{conf:()=>n,language:()=>o});var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}],folding:{markers:{start:new RegExp("^\\s*//\\s*(?:(?:#?region\\b)|(?:<editor-fold\\b))"),end:new RegExp("^\\s*//\\s*(?:(?:#?endregion\\b)|(?:</editor-fold>))")}}},o={defaultToken:"",tokenPostfix:".java",keywords:["abstract","continue","for","new","switch","assert","default","goto","package","synchronized","boolean","do","if","private","this","break","double","implements","protected","throw","byte","else","import","public","throws","case","enum","instanceof","return","transient","catch","extends","int","short","try","char","final","interface","static","void","class","finally","long","strictfp","volatile","const","float","native","super","while","true","false","yield","record","sealed","non-sealed","permits"],operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,tokenizer:{root:[["non-sealed","keyword.non-sealed"],[/[a-zA-Z_$][\w$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,"annotation"],[/(@digits)[eE]([\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?[fFdD]?/,"number.float"],[/0[xX](@hexdigits)[Ll]?/,"number.hex"],[/0(@octaldigits)[Ll]?/,"number.octal"],[/0[bB](@binarydigits)[Ll]?/,"number.binary"],[/(@digits)[fFdD]/,"number.float"],[/(@digits)[lL]?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"""/,"string","@multistring"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@javadoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],javadoc:[[/[^\/*]+/,"comment.doc"],[/\/\*/,"comment.doc.invalid"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],multistring:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"""/,"string","@pop"],[/./,"string"]]}}},8089:(e,t,i)=>{i.r(t),i.d(t,{conf:()=>c,language:()=>d});var n=i(8544),o=Object.defineProperty,s=Object.getOwnPropertyDescriptor,r=Object.getOwnPropertyNames,a=Object.prototype.hasOwnProperty,l={};((e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let i of r(t))a.call(e,i)||"default"===i||o(e,i,{get:()=>t[i],enumerable:!(n=s(t,i))||n.enumerable})})(l,n);var h={defaultToken:"invalid",tokenPostfix:".ts",keywords:["abstract","any","as","asserts","bigint","boolean","break","case","catch","class","continue","const","constructor","debugger","declare","default","delete","do","else","enum","export","extends","false","finally","for","from","function","get","if","implements","import","in","infer","instanceof","interface","is","keyof","let","module","namespace","never","new","null","number","object","out","package","private","protected","public","override","readonly","require","global","return","satisfies","set","static","string","super","switch","symbol","this","throw","true","try","type","typeof","undefined","unique","unknown","var","void","while","with","yield","async","await","of"],operators:["<=",">=","==","!=","===","!==","=>","+","-","**","*","/","%","++","--","<<","</",">>",">>>","&","|","^","!","~","&&","||","??","?",":","=","+=","-=","*=","**=","/=","%=","<<=",">>=",">>>=","&=","|=","^=","@"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,regexpctl:/[(){}\[\]\$\^|\-*+?\.]/,regexpesc:/\\(?:[bBdDfnrstvwWn0\\\/]|@regexpctl|c[A-Z]|x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4})/,tokenizer:{root:[[/[{}]/,"delimiter.bracket"],{include:"common"}],common:[[/#?[a-z_$][\w$]*/,{cases:{"@keywords":"keyword","@default":"identifier"}}],[/[A-Z][\w\$]*/,"type.identifier"],{include:"@whitespace"},[/\/(?=([^\\\/]|\\.)+\/([dgimsuy]*)(\s*)(\.|;|,|\)|\]|\}|$))/,{token:"regexp",bracket:"@open",next:"@regexp"}],[/[()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/!(?=([^=]|$))/,"delimiter"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/(@digits)[eE]([\-+]?(@digits))?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?/,"number.float"],[/0[xX](@hexdigits)n?/,"number.hex"],[/0[oO]?(@octaldigits)n?/,"number.octal"],[/0[bB](@binarydigits)n?/,"number.binary"],[/(@digits)n?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string_double"],[/'/,"string","@string_single"],[/`/,"string","@string_backtick"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@jsdoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],jsdoc:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],regexp:[[/(\{)(\d+(?:,\d*)?)(\})/,["regexp.escape.control","regexp.escape.control","regexp.escape.control"]],[/(\[)(\^?)(?=(?:[^\]\\\/]|\\.)+)/,["regexp.escape.control",{token:"regexp.escape.control",next:"@regexrange"}]],[/(\()(\?:|\?=|\?!)/,["regexp.escape.control","regexp.escape.control"]],[/[()]/,"regexp.escape.control"],[/@regexpctl/,"regexp.escape.control"],[/[^\\\/]/,"regexp"],[/@regexpesc/,"regexp.escape"],[/\\\./,"regexp.invalid"],[/(\/)([dgimsuy]*)/,[{token:"regexp",bracket:"@close",next:"@pop"},"keyword.other"]]],regexrange:[[/-/,"regexp.escape.control"],[/\^/,"regexp.invalid"],[/@regexpesc/,"regexp.escape"],[/[^\]]/,"regexp"],[/\]/,{token:"regexp.escape.control",next:"@pop",bracket:"@close"}]],string_double:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],string_single:[[/[^\\']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/'/,"string","@pop"]],string_backtick:[[/\$\{/,{token:"delimiter.bracket",next:"@bracketCounting"}],[/[^\\`$]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/`/,"string","@pop"]],bracketCounting:[[/\{/,"delimiter.bracket","@bracketCounting"],[/\}/,"delimiter.bracket","@pop"],{include:"common"}]}},c={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],onEnterRules:[{beforeText:/^\s*\/\*\*(?!\/)([^\*]|\*(?!\/))*$/,afterText:/^\s*\*\/$/,action:{indentAction:l.languages.IndentAction.IndentOutdent,appendText:" * "}},{beforeText:/^\s*\/\*\*(?!\/)([^\*]|\*(?!\/))*$/,action:{indentAction:l.languages.IndentAction.None,appendText:" * "}},{beforeText:/^(\t|(\ \ ))*\ \*(\ ([^\*]|\*(?!\/))*)?$/,action:{indentAction:l.languages.IndentAction.None,appendText:"* "}},{beforeText:/^(\t|(\ \ ))*\ \*\/\s*$/,action:{indentAction:l.languages.IndentAction.None,removeText:1}}],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"',notIn:["string"]},{open:"'",close:"'",notIn:["string","comment"]},{open:"`",close:"`",notIn:["string","comment"]},{open:"/**",close:" */",notIn:["string"]}],folding:{markers:{start:new RegExp("^\\s*//\\s*#?region\\b"),end:new RegExp("^\\s*//\\s*#?endregion\\b")}}},d={defaultToken:"invalid",tokenPostfix:".js",keywords:["break","case","catch","class","continue","const","constructor","debugger","default","delete","do","else","export","extends","false","finally","for","from","function","get","if","import","in","instanceof","let","new","null","return","set","static","super","switch","symbol","this","throw","true","try","typeof","undefined","var","void","while","with","yield","async","await","of"],typeKeywords:[],operators:h.operators,symbols:h.symbols,escapes:h.escapes,digits:h.digits,octaldigits:h.octaldigits,binarydigits:h.binarydigits,hexdigits:h.hexdigits,regexpctl:h.regexpctl,regexpesc:h.regexpesc,tokenizer:h.tokenizer}},4460:(e,t,i)=>{i.r(t),i.d(t,{conf:()=>h,language:()=>c});var n=i(8544),o=Object.defineProperty,s=Object.getOwnPropertyDescriptor,r=Object.getOwnPropertyNames,a=Object.prototype.hasOwnProperty,l={};((e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let i of r(t))a.call(e,i)||"default"===i||o(e,i,{get:()=>t[i],enumerable:!(n=s(t,i))||n.enumerable})})(l,n);var h={comments:{blockComment:["\x3c!--","--\x3e"]},brackets:[["<",">"]],autoClosingPairs:[{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'}],surroundingPairs:[{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'}],onEnterRules:[{beforeText:new RegExp("<([_:\\w][_:\\w-.\\d]*)([^/>]*(?!/)>)[^<]*$","i"),afterText:/^<\/([_:\w][_:\w-.\d]*)\s*>$/i,action:{indentAction:l.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp("<(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$","i"),action:{indentAction:l.languages.IndentAction.Indent}}]},c={defaultToken:"",tokenPostfix:".xml",ignoreCase:!0,qualifiedName:/(?:[\w\.\-]+:)?[\w\.\-]+/,tokenizer:{root:[[/[^<&]+/,""],{include:"@whitespace"},[/(<)(@qualifiedName)/,[{token:"delimiter"},{token:"tag",next:"@tag"}]],[/(<\/)(@qualifiedName)(\s*)(>)/,[{token:"delimiter"},{token:"tag"},"",{token:"delimiter"}]],[/(<\?)(@qualifiedName)/,[{token:"delimiter"},{token:"metatag",next:"@tag"}]],[/(<\!)(@qualifiedName)/,[{token:"delimiter"},{token:"metatag",next:"@tag"}]],[/<\!\[CDATA\[/,{token:"delimiter.cdata",next:"@cdata"}],[/&\w+;/,"string.escape"]],cdata:[[/[^\]]+/,""],[/\]\]>/,{token:"delimiter.cdata",next:"@pop"}],[/\]/,""]],tag:[[/[ \t\r\n]+/,""],[/(@qualifiedName)(\s*=\s*)("[^"]*"|'[^']*')/,["attribute.name","","attribute.value"]],[/(@qualifiedName)(\s*=\s*)("[^">?\/]*|'[^'>?\/]*)(?=[\?\/]\>)/,["attribute.name","","attribute.value"]],[/(@qualifiedName)(\s*=\s*)("[^">]*|'[^'>]*)/,["attribute.name","","attribute.value"]],[/@qualifiedName/,"attribute.name"],[/\?>/,{token:"delimiter",next:"@pop"}],[/(\/)(>)/,[{token:"tag"},{token:"delimiter",next:"@pop"}]],[/>/,{token:"delimiter",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,""],[/<!--/,{token:"comment",next:"@comment"}]],comment:[[/[^<\-]+/,"comment.content"],[/-->/,{token:"comment",next:"@pop"}],[/<!--/,"comment.content.invalid"],[/[<\-]/,"comment.content"]]}}},4787:(e,t,i)=>{i.d(t,{M:()=>o});var n=i(7693);function o(e,t){e instanceof n.D?(e.setFontFamily(t.getMassagedFontFamily()),e.setFontWeight(t.fontWeight),e.setFontSize(t.fontSize),e.setFontFeatureSettings(t.fontFeatureSettings),e.setFontVariationSettings(t.fontVariationSettings),e.setLineHeight(t.lineHeight),e.setLetterSpacing(t.letterSpacing)):(e.style.fontFamily=t.getMassagedFontFamily(),e.style.fontWeight=t.fontWeight,e.style.fontSize=t.fontSize+"px",e.style.fontFeatureSettings=t.fontFeatureSettings,e.style.fontVariationSettings=t.fontVariationSettings,e.style.lineHeight=t.lineHeight+"px",e.style.letterSpacing=t.letterSpacing+"px")}},2381:(e,t,i)=>{i.d(t,{u:()=>s});var n=i(8300),o=i(3884);class s extends n.jG{constructor(e,t){super(),this._onDidChange=this._register(new o.vl),this.onDidChange=this._onDidChange.event,this._referenceDomElement=e,this._width=-1,this._height=-1,this._resizeObserver=null,this.measureReferenceDomElement(!1,t)}dispose(){this.stopObserving(),super.dispose()}getWidth(){return this._width}getHeight(){return this._height}startObserving(){!this._resizeObserver&&this._referenceDomElement&&(this._resizeObserver=new ResizeObserver((e=>{e&&e[0]&&e[0].contentRect?this.observe({width:e[0].contentRect.width,height:e[0].contentRect.height}):this.observe()})),this._resizeObserver.observe(this._referenceDomElement))}stopObserving(){this._resizeObserver&&(this._resizeObserver.disconnect(),this._resizeObserver=null)}observe(e){this.measureReferenceDomElement(!0,e)}measureReferenceDomElement(e,t){let i=0,n=0;t?(i=t.width,n=t.height):this._referenceDomElement&&(i=this._referenceDomElement.clientWidth,n=this._referenceDomElement.clientHeight),i=Math.max(5,i),n=Math.max(5,n),this._width===i&&this._height===n||(this._width=i,this._height=n,e&&this._onDidChange.fire())}}},9588:(e,t,i)=>{i.d(t,{T:()=>g});var n=i(2003),o=i(3884),s=i(8300),r=i(4787);class a{constructor(e,t){this.chr=e,this.type=t,this.width=0}fulfill(e){this.width=e}}class l{constructor(e,t){this._bareFontInfo=e,this._requests=t,this._container=null,this._testElements=null}read(){this._createDomElements(),document.body.appendChild(this._container),this._readFromDomElements(),document.body.removeChild(this._container),this._container=null,this._testElements=null}_createDomElements(){const e=document.createElement("div");e.style.position="absolute",e.style.top="-50000px",e.style.width="50000px";const t=document.createElement("div");(0,r.M)(t,this._bareFontInfo),e.appendChild(t);const i=document.createElement("div");(0,r.M)(i,this._bareFontInfo),i.style.fontWeight="bold",e.appendChild(i);const n=document.createElement("div");(0,r.M)(n,this._bareFontInfo),n.style.fontStyle="italic",e.appendChild(n);const o=[];for(const e of this._requests){let s;0===e.type&&(s=t),2===e.type&&(s=i),1===e.type&&(s=n),s.appendChild(document.createElement("br"));const r=document.createElement("span");l._render(r,e),s.appendChild(r),o.push(r)}this._container=e,this._testElements=o}static _render(e,t){if(" "===t.chr){let t=" ";for(let e=0;e<8;e++)t+=t;e.innerText=t}else{let i=t.chr;for(let e=0;e<8;e++)i+=i;e.textContent=i}}_readFromDomElements(){for(let e=0,t=this._requests.length;e<t;e++){const t=this._requests[e],i=this._testElements[e];t.fulfill(i.offsetWidth/256)}}}var h=i(6522),c=i(9214);class d extends s.jG{constructor(){super(),this._onDidChange=this._register(new o.vl),this.onDidChange=this._onDidChange.event,this._cache=new u,this._evictUntrustedReadingsTimeout=-1}dispose(){-1!==this._evictUntrustedReadingsTimeout&&(window.clearTimeout(this._evictUntrustedReadingsTimeout),this._evictUntrustedReadingsTimeout=-1),super.dispose()}clearAllFontInfos(){this._cache=new u,this._onDidChange.fire()}_writeToCache(e,t){this._cache.put(e,t),t.isTrusted||-1!==this._evictUntrustedReadingsTimeout||(this._evictUntrustedReadingsTimeout=window.setTimeout((()=>{this._evictUntrustedReadingsTimeout=-1,this._evictUntrustedReadings()}),5e3))}_evictUntrustedReadings(){const e=this._cache.getValues();let t=!1;for(const i of e)i.isTrusted||(t=!0,this._cache.remove(i));t&&this._onDidChange.fire()}readFontInfo(e){if(!this._cache.has(e)){let t=this._actualReadFontInfo(e);(t.typicalHalfwidthCharacterWidth<=2||t.typicalFullwidthCharacterWidth<=2||t.spaceWidth<=2||t.maxDigitWidth<=2)&&(t=new c.YJ({pixelRatio:n.PixelRatio.value,fontFamily:t.fontFamily,fontWeight:t.fontWeight,fontSize:t.fontSize,fontFeatureSettings:t.fontFeatureSettings,fontVariationSettings:t.fontVariationSettings,lineHeight:t.lineHeight,letterSpacing:t.letterSpacing,isMonospace:t.isMonospace,typicalHalfwidthCharacterWidth:Math.max(t.typicalHalfwidthCharacterWidth,5),typicalFullwidthCharacterWidth:Math.max(t.typicalFullwidthCharacterWidth,5),canUseHalfwidthRightwardsArrow:t.canUseHalfwidthRightwardsArrow,spaceWidth:Math.max(t.spaceWidth,5),middotWidth:Math.max(t.middotWidth,5),wsmiddotWidth:Math.max(t.wsmiddotWidth,5),maxDigitWidth:Math.max(t.maxDigitWidth,5)},!1)),this._writeToCache(e,t)}return this._cache.get(e)}_createRequest(e,t,i,n){const o=new a(e,t);return i.push(o),null==n||n.push(o),o}_actualReadFontInfo(e){const t=[],i=[],o=this._createRequest("n",0,t,i),s=this._createRequest("ｍ",0,t,null),r=this._createRequest(" ",0,t,i),a=this._createRequest("0",0,t,i),d=this._createRequest("1",0,t,i),u=this._createRequest("2",0,t,i),g=this._createRequest("3",0,t,i),m=this._createRequest("4",0,t,i),p=this._createRequest("5",0,t,i),f=this._createRequest("6",0,t,i),A=this._createRequest("7",0,t,i),_=this._createRequest("8",0,t,i),w=this._createRequest("9",0,t,i),b=this._createRequest("→",0,t,i),v=this._createRequest("￫",0,t,null),C=this._createRequest("·",0,t,i),y=this._createRequest(String.fromCharCode(11825),0,t,null),S="|/-_ilm%";for(let e=0,n=8;e<n;e++)this._createRequest(S.charAt(e),0,t,i),this._createRequest(S.charAt(e),1,t,i),this._createRequest(S.charAt(e),2,t,i);!function(e,t){new l(e,t).read()}(e,t);const k=Math.max(a.width,d.width,u.width,g.width,m.width,p.width,f.width,A.width,_.width,w.width);let E=e.fontFeatureSettings===h.Bc.OFF;const D=i[0].width;for(let e=1,t=i.length;E&&e<t;e++){const t=D-i[e].width;if(t<-.001||t>.001){E=!1;break}}let x=!0;return E&&v.width!==D&&(x=!1),v.width>b.width&&(x=!1),new c.YJ({pixelRatio:n.PixelRatio.value,fontFamily:e.fontFamily,fontWeight:e.fontWeight,fontSize:e.fontSize,fontFeatureSettings:e.fontFeatureSettings,fontVariationSettings:e.fontVariationSettings,lineHeight:e.lineHeight,letterSpacing:e.letterSpacing,isMonospace:E,typicalHalfwidthCharacterWidth:o.width,typicalFullwidthCharacterWidth:s.width,canUseHalfwidthRightwardsArrow:x,spaceWidth:r.width,middotWidth:C.width,wsmiddotWidth:y.width,maxDigitWidth:k},!0)}}class u{constructor(){this._keys=Object.create(null),this._values=Object.create(null)}has(e){const t=e.getId();return!!this._values[t]}get(e){const t=e.getId();return this._values[t]}put(e,t){const i=e.getId();this._keys[i]=e,this._values[i]=t}remove(e){const t=e.getId();delete this._keys[t],delete this._values[t]}getValues(){return Object.keys(this._keys).map((e=>this._values[e]))}}const g=new d},7832:(e,t,i)=>{i.d(t,{DX:()=>A,E_:()=>w,Fl:()=>b,HW:()=>v,aU:()=>S,dS:()=>n,ih:()=>k,ks:()=>_,tc:()=>E,uB:()=>m});var n,o=i(1759),s=(i(6926),i(423)),r=(i(3736),i(4900),i(8677)),a=i(8661),l=i(6690),h=(i(3961),i(3815)),c=i(4741),d=i(7941),u=i(2821),g=i(2427);class m{constructor(e){this.id=e.id,this.precondition=e.precondition,this._kbOpts=e.kbOpts,this._menuOpts=e.menuOpts,this._description=e.description}register(){if(Array.isArray(this._menuOpts)?this._menuOpts.forEach(this._registerMenuItem,this):this._menuOpts&&this._registerMenuItem(this._menuOpts),this._kbOpts){const e=Array.isArray(this._kbOpts)?this._kbOpts:[this._kbOpts];for(const t of e){let e=t.kbExpr;this.precondition&&(e=e?l.M$.and(e,this.precondition):this.precondition);const i={id:this.id,weight:t.weight,args:t.args,when:e,primary:t.primary,secondary:t.secondary,win:t.win,linux:t.linux,mac:t.mac};h.f.registerKeybindingRule(i)}}a.w.registerCommand({id:this.id,handler:(e,t)=>this.runCommand(e,t),description:this._description})}_registerMenuItem(e){r.ZG.appendMenuItem(e.menuId,{group:e.group,command:{id:this.id,title:e.title,icon:e.icon,precondition:this.precondition},when:e.when,order:e.order})}}class p extends m{constructor(){super(...arguments),this._implementations=[]}addImplementation(e,t,i){return this._implementations.push({priority:e,name:t,implementation:i}),this._implementations.sort(((e,t)=>t.priority-e.priority)),{dispose:()=>{for(let e=0;e<this._implementations.length;e++)if(this._implementations[e].implementation===i)return void this._implementations.splice(e,1)}}}runCommand(e,t){const i=e.get(g.rr);i.trace(`Executing Command '${this.id}' which has ${this._implementations.length} bound.`);for(const n of this._implementations){const o=n.implementation(e,t);if(o){if(i.trace(`Command '${this.id}' was handled by '${n.name}'.`),"boolean"==typeof o)return;return o}}i.trace(`The Command '${this.id}' was not handled by any implementation.`)}}class f extends m{constructor(e,t){super(t),this.command=e}runCommand(e,t){return this.command.runCommand(e,t)}}class A extends m{static bindToContribution(e){return class extends A{constructor(e){super(e),this._callback=e.handler}runEditorCommand(t,i,n){const o=e(i);o&&this._callback(o,n)}}}static runEditorCommand(e,t,i,n){const o=e.get(s.T),r=o.getFocusedCodeEditor()||o.getActiveCodeEditor();if(r)return r.invokeWithinContext((e=>{if(e.get(l.fN).contextMatchesRules((0,u.UH)(i)))return n(e,r,t)}))}runCommand(e,t){return A.runEditorCommand(e,t,this.precondition,((e,t,i)=>this.runEditorCommand(e,t,i)))}}class _ extends A{static convertOptions(e){let t;function i(t){return t.menuId||(t.menuId=r.D8.EditorContext),t.title||(t.title=e.label),t.when=l.M$.and(e.precondition,t.when),t}return t=Array.isArray(e.menuOpts)?e.menuOpts:e.menuOpts?[e.menuOpts]:[],Array.isArray(e.contextMenuOpts)?t.push(...e.contextMenuOpts.map(i)):e.contextMenuOpts&&t.push(i(e.contextMenuOpts)),e.menuOpts=t,e}constructor(e){super(_.convertOptions(e)),this.label=e.label,this.alias=e.alias}runEditorCommand(e,t,i){return this.reportTelemetry(e,t),this.run(e,t,i||{})}reportTelemetry(e,t){e.get(d.k).publicLog2("editorActionInvoked",{name:this.label,id:this.id})}}function w(e){return C.INSTANCE.registerEditorCommand(e),e}function b(e){const t=new e;return C.INSTANCE.registerEditorAction(t),t}function v(e,t,i){C.INSTANCE.registerEditorContribution(e,t,i)}!function(e){e.getEditorCommand=function(e){return C.INSTANCE.getEditorCommand(e)},e.getEditorActions=function(){return C.INSTANCE.getEditorActions()},e.getEditorContributions=function(){return C.INSTANCE.getEditorContributions()},e.getSomeEditorContributions=function(e){return C.INSTANCE.getEditorContributions().filter((t=>e.indexOf(t.id)>=0))},e.getDiffEditorContributions=function(){return C.INSTANCE.getDiffEditorContributions()}}(n||(n={}));class C{constructor(){this.editorContributions=[],this.diffEditorContributions=[],this.editorActions=[],this.editorCommands=Object.create(null)}registerEditorContribution(e,t,i){this.editorContributions.push({id:e,ctor:t,instantiation:i})}getEditorContributions(){return this.editorContributions.slice(0)}getDiffEditorContributions(){return this.diffEditorContributions.slice(0)}registerEditorAction(e){e.register(),this.editorActions.push(e)}getEditorActions(){return this.editorActions}registerEditorCommand(e){e.register(),this.editorCommands[e.id]=e}getEditorCommand(e){return this.editorCommands[e]||null}}function y(e){return e.register(),e}C.INSTANCE=new C,c.O.add("editor.contributions",C.INSTANCE);const S=y(new p({id:"undo",precondition:void 0,kbOpts:{weight:0,primary:2104},menuOpts:[{menuId:r.D8.MenubarEditMenu,group:"1_do",title:o.kg({key:"miUndo",comment:["&& denotes a mnemonic"]},"&&Undo"),order:1},{menuId:r.D8.CommandPalette,group:"",title:o.kg("undo","Undo"),order:1}]}));y(new f(S,{id:"default:undo",precondition:void 0}));const k=y(new p({id:"redo",precondition:void 0,kbOpts:{weight:0,primary:2103,secondary:[3128],mac:{primary:3128}},menuOpts:[{menuId:r.D8.MenubarEditMenu,group:"1_do",title:o.kg({key:"miRedo",comment:["&& denotes a mnemonic"]},"&&Redo"),order:2},{menuId:r.D8.CommandPalette,group:"",title:o.kg("redo","Redo"),order:1}]}));y(new f(k,{id:"default:redo",precondition:void 0}));const E=y(new p({id:"editor.action.selectAll",precondition:void 0,kbOpts:{weight:0,kbExpr:null,primary:2079},menuOpts:[{menuId:r.D8.MenubarSelectionMenu,group:"1_basic",title:o.kg({key:"miSelectAll",comment:["&& denotes a mnemonic"]},"&&Select All"),order:1},{menuId:r.D8.CommandPalette,group:"",title:o.kg("selectAll","Select All"),order:1}]}))},423:(e,t,i)=>{i.d(t,{T:()=>n});const n=(0,i(3961).u1)("codeEditorService")},3456:(e,t,i)=>{i.d(t,{D:()=>n});class n{static capture(e){if(0===e.getScrollTop()||e.hasPendingScrollAnimation())return new n(e.getScrollTop(),e.getContentHeight(),null,0,null);let t=null,i=0;const o=e.getVisibleRanges();if(o.length>0){t=o[0].getStartPosition();const n=e.getTopForPosition(t.lineNumber,t.column);i=e.getScrollTop()-n}return new n(e.getScrollTop(),e.getContentHeight(),t,i,e.getPosition())}constructor(e,t,i,n,o){this._initialScrollTop=e,this._initialContentHeight=t,this._visiblePosition=i,this._visiblePositionScrollDelta=n,this._cursorPosition=o}restore(e){if((this._initialContentHeight!==e.getContentHeight()||this._initialScrollTop!==e.getScrollTop())&&this._visiblePosition){const t=e.getTopForPosition(this._visiblePosition.lineNumber,this._visiblePosition.column);e.setScrollTop(t+this._visiblePositionScrollDelta)}}restoreRelativeVerticalPositionOfCursor(e){if(this._initialContentHeight===e.getContentHeight()&&this._initialScrollTop===e.getScrollTop())return;const t=e.getPosition();if(!this._cursorPosition||!t)return;const i=e.getTopForLineNumber(t.lineNumber)-e.getTopForLineNumber(this._cursorPosition.lineNumber);e.setScrollTop(e.getScrollTop()+i)}}},9446:(e,t,i)=>{i.d(t,{x:()=>kr});var n=i(5736),o=i(7832);let s=class{constructor(e,t){}dispose(){}};var r;s.ID="editor.contrib.markerDecorations",s=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r}([(r=n.A,function(e,t){r(e,t,1)})],s),(0,o.HW)(s.ID,s,0);var a=i(3925),l=i.n(a),h=i(4470);l()(h.A,{insert:"head",singleton:!1}),h.A.locals;var c=i(1759),d=i(8479),u=i(3329),g=i(3884),m=i(8300),p=i(7446),f=i(2003),A=i(8092),_=i(3104),w=i(4541),b=i(2381),v=i(9588);class C{constructor(e,t){this.key=e,this.migrate=t}apply(e){const t=C._read(e,this.key);this.migrate(t,(t=>C._read(e,t)),((t,i)=>C._write(e,t,i)))}static _read(e,t){if(void 0===e)return;const i=t.indexOf(".");if(i>=0){const n=t.substring(0,i);return this._read(e[n],t.substring(i+1))}return e[t]}static _write(e,t,i){const n=t.indexOf(".");if(n>=0){const o=t.substring(0,n);return e[o]=e[o]||{},void this._write(e[o],t.substring(n+1),i)}e[t]=i}}function y(e,t){C.items.push(new C(e,t))}function S(e,t){y(e,((i,n,o)=>{if(void 0!==i)for(const[n,s]of t)if(i===n)return void o(e,s)}))}C.items=[],S("wordWrap",[[!0,"on"],[!1,"off"]]),S("lineNumbers",[[!0,"on"],[!1,"off"]]),S("cursorBlinking",[["visible","solid"]]),S("renderWhitespace",[[!0,"boundary"],[!1,"none"]]),S("renderLineHighlight",[[!0,"line"],[!1,"none"]]),S("acceptSuggestionOnEnter",[[!0,"on"],[!1,"off"]]),S("tabCompletion",[[!1,"off"],[!0,"onlySnippets"]]),S("hover",[[!0,{enabled:!0}],[!1,{enabled:!1}]]),S("parameterHints",[[!0,{enabled:!0}],[!1,{enabled:!1}]]),S("autoIndent",[[!1,"advanced"],[!0,"full"]]),S("matchBrackets",[[!0,"always"],[!1,"never"]]),S("renderFinalNewline",[[!0,"on"],[!1,"off"]]),S("cursorSmoothCaretAnimation",[[!0,"on"],[!1,"off"]]),y("autoClosingBrackets",((e,t,i)=>{!1===e&&(i("autoClosingBrackets","never"),void 0===t("autoClosingQuotes")&&i("autoClosingQuotes","never"),void 0===t("autoSurround")&&i("autoSurround","never"))})),y("renderIndentGuides",((e,t,i)=>{void 0!==e&&(i("renderIndentGuides",void 0),void 0===t("guides.indentation")&&i("guides.indentation",!!e))})),y("highlightActiveIndentGuide",((e,t,i)=>{void 0!==e&&(i("highlightActiveIndentGuide",void 0),void 0===t("guides.highlightActiveIndentation")&&i("guides.highlightActiveIndentation",!!e))}));const k={method:"showMethods",function:"showFunctions",constructor:"showConstructors",deprecated:"showDeprecated",field:"showFields",variable:"showVariables",class:"showClasses",struct:"showStructs",interface:"showInterfaces",module:"showModules",property:"showProperties",event:"showEvents",operator:"showOperators",unit:"showUnits",value:"showValues",constant:"showConstants",enum:"showEnums",enumMember:"showEnumMembers",keyword:"showKeywords",text:"showWords",color:"showColors",file:"showFiles",reference:"showReferences",folder:"showFolders",typeParameter:"showTypeParameters",snippet:"showSnippets"};y("suggest.filteredTypes",((e,t,i)=>{if(e&&"object"==typeof e){for(const n of Object.entries(k))!1===e[n[0]]&&void 0===t(`suggest.${n[1]}`)&&i(`suggest.${n[1]}`,!1);i("suggest.filteredTypes",void 0)}})),y("quickSuggestions",((e,t,i)=>{if("boolean"==typeof e){const t=e?"on":"off";i("quickSuggestions",{comments:t,strings:t,other:t})}})),y("experimental.stickyScroll.enabled",((e,t,i)=>{"boolean"==typeof e&&(i("experimental.stickyScroll.enabled",void 0),void 0===t("stickyScroll.enabled")&&i("stickyScroll.enabled",e))})),y("experimental.stickyScroll.maxLineCount",((e,t,i)=>{"number"==typeof e&&(i("experimental.stickyScroll.maxLineCount",void 0),void 0===t("stickyScroll.maxLineCount")&&i("stickyScroll.maxLineCount",e))}));const E=new class{constructor(){this._tabFocusTerminal=!1,this._tabFocusEditor=!1,this._onDidChangeTabFocus=new g.vl,this.onDidChangeTabFocus=this._onDidChangeTabFocus.event}getTabFocusMode(e){return"terminalFocus"===e?this._tabFocusTerminal:this._tabFocusEditor}setTabFocusMode(e,t){"terminalFocus"===t?this._tabFocusTerminal=e:this._tabFocusEditor=e,this._onDidChangeTabFocus.fire()}};var D=i(6522),x=i(3945),L=i(9214),M=i(3327);let I=class extends m.jG{constructor(e,t,i,n){super(),this._accessibilityService=n,this._onDidChange=this._register(new g.vl),this.onDidChange=this._onDidChange.event,this._onDidChangeFast=this._register(new g.vl),this.onDidChangeFast=this._onDidChangeFast.event,this._isDominatedByLongLines=!1,this._viewLineCount=1,this._lineNumbersDigitCount=1,this._reservedHeight=0,this._glyphMarginDecorationLaneCount=1,this._computeOptionsMemory=new D.n0,this.isSimpleWidget=e,this._containerObserver=this._register(new b.u(i,t.dimension)),this._rawOptions=R(t),this._validatedOptions=F.validateOptions(this._rawOptions),this.options=this._computeOptions(),this.options.get(11)&&this._containerObserver.startObserving(),this._register(x.D.onDidChangeZoomLevel((()=>this._recomputeOptions()))),this._register(E.onDidChangeTabFocus((()=>this._recomputeOptions()))),this._register(this._containerObserver.onDidChange((()=>this._recomputeOptions()))),this._register(v.T.onDidChange((()=>this._recomputeOptions()))),this._register(f.PixelRatio.onDidChange((()=>this._recomputeOptions()))),this._register(this._accessibilityService.onDidChangeScreenReaderOptimized((()=>this._recomputeOptions())))}_recomputeOptions(){const e=this._computeOptions(),t=F.checkEquals(this.options,e);null!==t&&(this.options=e,this._onDidChangeFast.fire(t),this._onDidChange.fire(t))}_computeOptions(){const e=this._readEnvConfiguration(),t=L._8.createFromValidatedSettings(this._validatedOptions,e.pixelRatio,this.isSimpleWidget),i=this._readFontInfo(t),n={memory:this._computeOptionsMemory,outerWidth:e.outerWidth,outerHeight:e.outerHeight-this._reservedHeight,fontInfo:i,extraEditorClassName:e.extraEditorClassName,isDominatedByLongLines:this._isDominatedByLongLines,viewLineCount:this._viewLineCount,lineNumbersDigitCount:this._lineNumbersDigitCount,emptySelectionClipboard:e.emptySelectionClipboard,pixelRatio:e.pixelRatio,tabFocusMode:E.getTabFocusMode("editorFocus"),accessibilitySupport:e.accessibilitySupport,glyphMarginDecorationLaneCount:this._glyphMarginDecorationLaneCount};return F.computeOptions(this._validatedOptions,n)}_readEnvConfiguration(){return{extraEditorClassName:B(),outerWidth:this._containerObserver.getWidth(),outerHeight:this._containerObserver.getHeight(),emptySelectionClipboard:f.isWebKit||f.isFirefox,pixelRatio:f.PixelRatio.value,accessibilitySupport:this._accessibilityService.isScreenReaderOptimized()?2:this._accessibilityService.getAccessibilitySupport()}}_readFontInfo(e){return v.T.readFontInfo(e)}getRawOptions(){return this._rawOptions}updateOptions(e){const t=R(e);F.applyUpdate(this._rawOptions,t)&&(this._validatedOptions=F.validateOptions(this._rawOptions),this._recomputeOptions())}observeContainer(e){this._containerObserver.observe(e)}setIsDominatedByLongLines(e){this._isDominatedByLongLines!==e&&(this._isDominatedByLongLines=e,this._recomputeOptions())}setModelLineCount(e){const t=function(e){let t=0;for(;e;)e=Math.floor(e/10),t++;return t||1}(e);this._lineNumbersDigitCount!==t&&(this._lineNumbersDigitCount=t,this._recomputeOptions())}setViewLineCount(e){this._viewLineCount!==e&&(this._viewLineCount=e,this._recomputeOptions())}setReservedHeight(e){this._reservedHeight!==e&&(this._reservedHeight=e,this._recomputeOptions())}setGlyphMarginDecorationLaneCount(e){this._glyphMarginDecorationLaneCount!==e&&(this._glyphMarginDecorationLaneCount=e,this._recomputeOptions())}};function B(){let e="";return f.isSafari||f.isWebkitWebView||(e+="no-user-select "),f.isSafari&&(e+="no-minimap-shadow ",e+="enable-user-select "),w.zx&&(e+="mac "),e}I=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r}([function(e,t){return function(e,i){t(e,i,3)}}(0,M.j)],I);class N{constructor(){this._values=[]}_read(e){return this._values[e]}get(e){return this._values[e]}_write(e,t){this._values[e]=t}}class T{constructor(){this._values=[]}_read(e){if(e>=this._values.length)throw new Error("Cannot read uninitialized value");return this._values[e]}get(e){return this._read(e)}_write(e,t){this._values[e]=t}}class F{static validateOptions(e){const t=new N;for(const i of D.BE){const n="_never_"===i.name?void 0:e[i.name];t._write(i.id,i.validate(n))}return t}static computeOptions(e,t){const i=new T;for(const n of D.BE)i._write(n.id,n.compute(t,i,e._read(n.id)));return i}static _deepEquals(e,t){if("object"!=typeof e||"object"!=typeof t||!e||!t)return e===t;if(Array.isArray(e)||Array.isArray(t))return!(!Array.isArray(e)||!Array.isArray(t))&&A.aI(e,t);if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!F._deepEquals(e[i],t[i]))return!1;return!0}static checkEquals(e,t){const i=[];let n=!1;for(const o of D.BE){const s=!F._deepEquals(e._read(o.id),t._read(o.id));i[o.id]=s,s&&(n=!0)}return n?new D.lw(i):null}static applyUpdate(e,t){let i=!1;for(const n of D.BE)if(t.hasOwnProperty(n.name)){const o=n.applyUpdate(e[n.name],t[n.name]);e[n.name]=o.newValue,i=i||o.didChange}return i}}function R(e){const t=_.Go(e);return function(e){C.items.forEach((t=>t.apply(e)))}(t),t}var O=i(423),P=i(3100),z=i(7693),Q=i(9408),H=i(9121),W=i(6322),V=i(5404),U=i(4628);class j{constructor(e,t){this.x=e,this.y=t,this._pageCoordinatesBrand=void 0}toClientCoordinates(){return new G(this.x-window.scrollX,this.y-window.scrollY)}}class G{constructor(e,t){this.clientX=e,this.clientY=t,this._clientCoordinatesBrand=void 0}toPageCoordinates(){return new j(this.clientX+window.scrollX,this.clientY+window.scrollY)}}class K{constructor(e,t,i,n){this.x=e,this.y=t,this.width=i,this.height=n,this._editorPagePositionBrand=void 0}}class Y{constructor(e,t){this.x=e,this.y=t,this._positionRelativeToEditorBrand=void 0}}function J(e){const t=d.BK(e);return new K(t.left,t.top,t.width,t.height)}function q(e,t,i){const n=t.width/e.offsetWidth,o=t.height/e.offsetHeight,s=(i.x-t.x)/n,r=(i.y-t.y)/o;return new Y(s,r)}class $ extends H.P{constructor(e,t,i){super(e),this._editorMouseEventBrand=void 0,this.isFromPointerCapture=t,this.pos=new j(this.posx,this.posy),this.editorPos=J(i),this.relativePos=q(i,this.editorPos,this.pos)}}class X{constructor(e){this._editorViewDomNode=e}_create(e){return new $(e,!1,this._editorViewDomNode)}onContextMenu(e,t){return d.ko(e,"contextmenu",(e=>{t(this._create(e))}))}onMouseUp(e,t){return d.ko(e,"mouseup",(e=>{t(this._create(e))}))}onMouseDown(e,t){return d.ko(e,d.Bx.MOUSE_DOWN,(e=>{t(this._create(e))}))}onPointerDown(e,t){return d.ko(e,d.Bx.POINTER_DOWN,(e=>{t(this._create(e),e.pointerId)}))}onMouseLeave(e,t){return d.ko(e,d.Bx.MOUSE_LEAVE,(e=>{t(this._create(e))}))}onMouseMove(e,t){return d.ko(e,"mousemove",(e=>t(this._create(e))))}}class Z{constructor(e){this._editorViewDomNode=e}_create(e){return new $(e,!1,this._editorViewDomNode)}onPointerUp(e,t){return d.ko(e,"pointerup",(e=>{t(this._create(e))}))}onPointerDown(e,t){return d.ko(e,d.Bx.POINTER_DOWN,(e=>{t(this._create(e),e.pointerId)}))}onPointerLeave(e,t){return d.ko(e,d.Bx.POINTER_LEAVE,(e=>{t(this._create(e))}))}onPointerMove(e,t){return d.ko(e,"pointermove",(e=>t(this._create(e))))}}class ee extends m.jG{constructor(e){super(),this._editorViewDomNode=e,this._globalPointerMoveMonitor=this._register(new W._),this._keydownListener=null}startMonitoring(e,t,i,n,o){this._keydownListener=d.b2(document,"keydown",(e=>{e.toKeyCodeChord().isModifierKey()||this._globalPointerMoveMonitor.stopMonitoring(!0,e.browserEvent)}),!0),this._globalPointerMoveMonitor.startMonitoring(e,t,i,(e=>{n(new $(e,!0,this._editorViewDomNode))}),(e=>{this._keydownListener.dispose(),o(e)}))}stopMonitoring(){this._globalPointerMoveMonitor.stopMonitoring(!0)}}class te{constructor(e){this._editor=e,this._instanceId=++te._idPool,this._counter=0,this._rules=new Map,this._garbageCollectionScheduler=new V.uC((()=>this.garbageCollect()),1e3)}createClassNameRef(e){const t=this.getOrCreateRule(e);return t.increaseRefCount(),{className:t.className,dispose:()=>{t.decreaseRefCount(),this._garbageCollectionScheduler.schedule()}}}getOrCreateRule(e){const t=this.computeUniqueKey(e);let i=this._rules.get(t);if(!i){const n=this._counter++;i=new ie(t,`dyn-rule-${this._instanceId}-${n}`,d.Cl(this._editor.getContainerDomNode())?this._editor.getContainerDomNode():void 0,e),this._rules.set(t,i)}return i}computeUniqueKey(e){return JSON.stringify(e)}garbageCollect(){for(const e of this._rules.values())e.hasReferences()||(this._rules.delete(e.key),e.dispose())}}te._idPool=0;class ie{constructor(e,t,i,n){this.key=e,this.className=t,this.properties=n,this._referenceCount=0,this._styleElement=d.li(i),this._styleElement.textContent=this.getCssText(this.className,this.properties)}getCssText(e,t){let i=`.${e} {`;for(const e in t){const n=t[e];let o;o="object"==typeof n?(0,U.GuP)(n.id):n,i+=`\n\t${ne(e)}: ${o};`}return i+="\n}",i}dispose(){this._styleElement.remove()}increaseRefCount(){this._referenceCount++}decreaseRefCount(){this._referenceCount--}hasReferences(){return this._referenceCount>0}}function ne(e){return e.replace(/(^[A-Z])/,(([e])=>e.toLowerCase())).replace(/([A-Z])/g,(([e])=>`-${e.toLowerCase()}`))}class oe extends m.jG{constructor(){super(),this._shouldRender=!0}shouldRender(){return this._shouldRender}forceShouldRender(){this._shouldRender=!0}setShouldRender(){this._shouldRender=!0}onDidRender(){this._shouldRender=!1}onCompositionStart(e){return!1}onCompositionEnd(e){return!1}onConfigurationChanged(e){return!1}onCursorStateChanged(e){return!1}onDecorationsChanged(e){return!1}onFlushed(e){return!1}onFocusChanged(e){return!1}onLanguageConfigurationChanged(e){return!1}onLineMappingChanged(e){return!1}onLinesChanged(e){return!1}onLinesDeleted(e){return!1}onLinesInserted(e){return!1}onRevealRangeRequest(e){return!1}onScrollChanged(e){return!1}onThemeChanged(e){return!1}onTokensChanged(e){return!1}onTokensColorsChanged(e){return!1}onZonesChanged(e){return!1}handleEvents(e){let t=!1;for(let i=0,n=e.length;i<n;i++){const n=e[i];switch(n.type){case 0:this.onCompositionStart(n)&&(t=!0);break;case 1:this.onCompositionEnd(n)&&(t=!0);break;case 2:this.onConfigurationChanged(n)&&(t=!0);break;case 3:this.onCursorStateChanged(n)&&(t=!0);break;case 4:this.onDecorationsChanged(n)&&(t=!0);break;case 5:this.onFlushed(n)&&(t=!0);break;case 6:this.onFocusChanged(n)&&(t=!0);break;case 7:this.onLanguageConfigurationChanged(n)&&(t=!0);break;case 8:this.onLineMappingChanged(n)&&(t=!0);break;case 9:this.onLinesChanged(n)&&(t=!0);break;case 10:this.onLinesDeleted(n)&&(t=!0);break;case 11:this.onLinesInserted(n)&&(t=!0);break;case 12:this.onRevealRangeRequest(n)&&(t=!0);break;case 13:this.onScrollChanged(n)&&(t=!0);break;case 15:this.onTokensChanged(n)&&(t=!0);break;case 14:this.onThemeChanged(n)&&(t=!0);break;case 16:this.onTokensColorsChanged(n)&&(t=!0);break;case 17:this.onZonesChanged(n)&&(t=!0);break;default:console.info("View received unknown event: "),console.info(n)}}t&&(this._shouldRender=!0)}}class se extends oe{constructor(e){super(),this._context=e,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),super.dispose()}}class re{static write(e,t){e.setAttribute("data-mprt",String(t))}static read(e){const t=e.getAttribute("data-mprt");return null===t?0:parseInt(t,10)}static collect(e,t){const i=[];let n=0;for(;e&&e!==document.body&&e!==t;)e.nodeType===e.ELEMENT_NODE&&(i[n++]=this.read(e)),e=e.parentElement;const o=new Uint8Array(n);for(let e=0;e<n;e++)o[e]=i[n-e-1];return o}}class ae{constructor(e,t){this._restrictedRenderingContextBrand=void 0,this._viewLayout=e,this.viewportData=t,this.scrollWidth=this._viewLayout.getScrollWidth(),this.scrollHeight=this._viewLayout.getScrollHeight(),this.visibleRange=this.viewportData.visibleRange,this.bigNumbersDelta=this.viewportData.bigNumbersDelta;const i=this._viewLayout.getCurrentViewport();this.scrollTop=i.top,this.scrollLeft=i.left,this.viewportWidth=i.width,this.viewportHeight=i.height}getScrolledTopFromAbsoluteTop(e){return e-this.scrollTop}getVerticalOffsetForLineNumber(e,t){return this._viewLayout.getVerticalOffsetForLineNumber(e,t)}getVerticalOffsetAfterLineNumber(e,t){return this._viewLayout.getVerticalOffsetAfterLineNumber(e,t)}getDecorationsInViewport(){return this.viewportData.getDecorationsInViewport()}}class le extends ae{constructor(e,t,i){super(e,t),this._renderingContextBrand=void 0,this._viewLines=i}linesVisibleRangesForRange(e,t){return this._viewLines.linesVisibleRangesForRange(e,t)}visibleRangeForPosition(e){return this._viewLines.visibleRangeForPosition(e)}}class he{constructor(e,t,i){this.outsideRenderedLine=e,this.lineNumber=t,this.ranges=i}}class ce{static from(e){const t=new Array(e.length);for(let i=0,n=e.length;i<n;i++){const n=e[i];t[i]=new ce(n.left,n.width)}return t}constructor(e,t){this._horizontalRangeBrand=void 0,this.left=Math.round(e),this.width=Math.round(t)}toString(){return`[${this.left},${this.width}]`}}class de{constructor(e,t){this._floatHorizontalRangeBrand=void 0,this.left=e,this.width=t}toString(){return`[${this.left},${this.width}]`}static compare(e,t){return e.left-t.left}}class ue{constructor(e,t){this.outsideRenderedLine=e,this.originalLeft=t,this.left=Math.round(this.originalLeft)}}class ge{constructor(e,t){this.outsideRenderedLine=e,this.ranges=t}}class me{static _createRange(){return this._handyReadyRange||(this._handyReadyRange=document.createRange()),this._handyReadyRange}static _detachRange(e,t){e.selectNodeContents(t)}static _readClientRects(e,t,i,n,o){const s=this._createRange();try{return s.setStart(e,t),s.setEnd(i,n),s.getClientRects()}catch(e){return null}finally{this._detachRange(s,o)}}static _mergeAdjacentRanges(e){if(1===e.length)return e;e.sort(de.compare);const t=[];let i=0,n=e[0];for(let o=1,s=e.length;o<s;o++){const s=e[o];n.left+n.width+.9>=s.left?n.width=Math.max(n.width,s.left+s.width-n.left):(t[i++]=n,n=s)}return t[i++]=n,t}static _createHorizontalRangesFromClientRects(e,t,i){if(!e||0===e.length)return null;const n=[];for(let o=0,s=e.length;o<s;o++){const s=e[o];n[o]=new de(Math.max(0,(s.left-t)/i),s.width/i)}return this._mergeAdjacentRanges(n)}static readHorizontalRanges(e,t,i,n,o,s){const r=e.children.length-1;if(0>r)return null;if((t=Math.min(r,Math.max(0,t)))===(n=Math.min(r,Math.max(0,n)))&&i===o&&0===i&&!e.children[t].firstChild){const i=e.children[t].getClientRects();return s.markDidDomLayout(),this._createHorizontalRangesFromClientRects(i,s.clientRectDeltaLeft,s.clientRectScale)}t!==n&&n>0&&0===o&&(n--,o=1073741824);let a=e.children[t].firstChild,l=e.children[n].firstChild;if(a&&l||(!a&&0===i&&t>0&&(a=e.children[t-1].firstChild,i=1073741824),!l&&0===o&&n>0&&(l=e.children[n-1].firstChild,o=1073741824)),!a||!l)return null;i=Math.min(a.textContent.length,Math.max(0,i)),o=Math.min(l.textContent.length,Math.max(0,o));const h=this._readClientRects(a,i,l,o,s.endNode);return s.markDidDomLayout(),this._createHorizontalRangesFromClientRects(h,s.clientRectDeltaLeft,s.clientRectScale)}}var pe=i(6347),fe=i(7529),Ae=i(2733);const _e=!!w.ib||!(w.j9||f.isFirefox||f.isSafari);let we=!0;class be{constructor(e,t){this.themeType=t;const i=e.options,n=i.get(48),o=i.get(36);this.renderWhitespace="off"===o?i.get(95):"none",this.renderControlCharacters=i.get(90),this.spaceWidth=n.spaceWidth,this.middotWidth=n.middotWidth,this.wsmiddotWidth=n.wsmiddotWidth,this.useMonospaceOptimizations=n.isMonospace&&!i.get(31),this.canUseHalfwidthRightwardsArrow=n.canUseHalfwidthRightwardsArrow,this.lineHeight=i.get(64),this.stopRenderingLineAfter=i.get(113),this.fontLigatures=i.get(49)}equals(e){return this.themeType===e.themeType&&this.renderWhitespace===e.renderWhitespace&&this.renderControlCharacters===e.renderControlCharacters&&this.spaceWidth===e.spaceWidth&&this.middotWidth===e.middotWidth&&this.wsmiddotWidth===e.wsmiddotWidth&&this.useMonospaceOptimizations===e.useMonospaceOptimizations&&this.canUseHalfwidthRightwardsArrow===e.canUseHalfwidthRightwardsArrow&&this.lineHeight===e.lineHeight&&this.stopRenderingLineAfter===e.stopRenderingLineAfter&&this.fontLigatures===e.fontLigatures}}class ve{constructor(e){this._options=e,this._isMaybeInvalid=!0,this._renderedViewLine=null}getDomNode(){return this._renderedViewLine&&this._renderedViewLine.domNode?this._renderedViewLine.domNode.domNode:null}setDomNode(e){if(!this._renderedViewLine)throw new Error("I have no rendered view line to set the dom node to...");this._renderedViewLine.domNode=(0,z.Z)(e)}onContentChanged(){this._isMaybeInvalid=!0}onTokensChanged(){this._isMaybeInvalid=!0}onDecorationsChanged(){this._isMaybeInvalid=!0}onOptionsChanged(e){this._isMaybeInvalid=!0,this._options=e}onSelectionChanged(){return!(!(0,Ae.Bb)(this._options.themeType)&&"selection"!==this._options.renderWhitespace||(this._isMaybeInvalid=!0,0))}renderLine(e,t,i,n){if(!1===this._isMaybeInvalid)return!1;this._isMaybeInvalid=!1;const o=i.getViewLineRenderingData(e),s=this._options,r=pe.d.filter(o.inlineDecorations,e,o.minColumn,o.maxColumn);let a=null;if((0,Ae.Bb)(s.themeType)||"selection"===this._options.renderWhitespace){const t=i.selections;for(const i of t){if(i.endLineNumber<e||i.startLineNumber>e)continue;const t=i.startLineNumber===e?i.startColumn:o.minColumn,n=i.endLineNumber===e?i.endColumn:o.maxColumn;t<n&&((0,Ae.Bb)(s.themeType)&&r.push(new pe.d(t,n,"inline-selected-text",0)),"selection"===this._options.renderWhitespace&&(a||(a=[]),a.push(new fe.MT(t-1,n-1))))}}const l=new fe.zL(s.useMonospaceOptimizations,s.canUseHalfwidthRightwardsArrow,o.content,o.continuesWithWrappedLine,o.isBasicASCII,o.containsRTL,o.minColumn-1,o.tokens,r,o.tabSize,o.startVisibleColumn,s.spaceWidth,s.middotWidth,s.wsmiddotWidth,s.stopRenderingLineAfter,s.renderWhitespace,s.renderControlCharacters,s.fontLigatures!==D.Bc.OFF,a);if(this._renderedViewLine&&this._renderedViewLine.input.equals(l))return!1;n.appendString('<div style="top:'),n.appendString(String(t)),n.appendString("px;height:"),n.appendString(String(this._options.lineHeight)),n.appendString('px;" class="'),n.appendString(ve.CLASS_NAME),n.appendString('">');const h=(0,fe.UW)(l,n);n.appendString("</div>");let c=null;return we&&_e&&o.isBasicASCII&&s.useMonospaceOptimizations&&0===h.containsForeignElements&&(c=new Ce(this._renderedViewLine?this._renderedViewLine.domNode:null,l,h.characterMapping)),c||(c=ke(this._renderedViewLine?this._renderedViewLine.domNode:null,l,h.characterMapping,h.containsRTL,h.containsForeignElements)),this._renderedViewLine=c,!0}layoutLine(e,t){this._renderedViewLine&&this._renderedViewLine.domNode&&(this._renderedViewLine.domNode.setTop(t),this._renderedViewLine.domNode.setHeight(this._options.lineHeight))}getWidth(e){return this._renderedViewLine?this._renderedViewLine.getWidth(e):0}getWidthIsFast(){return!this._renderedViewLine||this._renderedViewLine.getWidthIsFast()}needsMonospaceFontCheck(){return!!this._renderedViewLine&&this._renderedViewLine instanceof Ce}monospaceAssumptionsAreValid(){return this._renderedViewLine&&this._renderedViewLine instanceof Ce?this._renderedViewLine.monospaceAssumptionsAreValid():we}onMonospaceAssumptionsInvalidated(){this._renderedViewLine&&this._renderedViewLine instanceof Ce&&(this._renderedViewLine=this._renderedViewLine.toSlowRenderedLine())}getVisibleRangesForRange(e,t,i,n){if(!this._renderedViewLine)return null;t=Math.min(this._renderedViewLine.input.lineContent.length+1,Math.max(1,t)),i=Math.min(this._renderedViewLine.input.lineContent.length+1,Math.max(1,i));const o=this._renderedViewLine.input.stopRenderingLineAfter;if(-1!==o&&t>o+1&&i>o+1)return new ge(!0,[new de(this.getWidth(n),0)]);-1!==o&&t>o+1&&(t=o+1),-1!==o&&i>o+1&&(i=o+1);const s=this._renderedViewLine.getVisibleRangesForRange(e,t,i,n);return s&&s.length>0?new ge(!1,s):null}getColumnOfNodeOffset(e,t,i){return this._renderedViewLine?this._renderedViewLine.getColumnOfNodeOffset(e,t,i):1}}ve.CLASS_NAME="view-line";class Ce{constructor(e,t,i){this._cachedWidth=-1,this.domNode=e,this.input=t;const n=Math.floor(t.lineContent.length/300);if(n>0){this._keyColumnPixelOffsetCache=new Float32Array(n);for(let e=0;e<n;e++)this._keyColumnPixelOffsetCache[e]=-1}else this._keyColumnPixelOffsetCache=null;this._characterMapping=i,this._charWidth=t.spaceWidth}getWidth(e){if(!this.domNode||this.input.lineContent.length<300){const e=this._characterMapping.getHorizontalOffset(this._characterMapping.length);return Math.round(this._charWidth*e)}return-1===this._cachedWidth&&(this._cachedWidth=this._getReadingTarget(this.domNode).offsetWidth,null==e||e.markDidDomLayout()),this._cachedWidth}getWidthIsFast(){return this.input.lineContent.length<300||-1!==this._cachedWidth}monospaceAssumptionsAreValid(){if(!this.domNode)return we;if(this.input.lineContent.length<300){const e=this.getWidth(null),t=this.domNode.domNode.firstChild.offsetWidth;Math.abs(e-t)>=2&&(console.warn("monospace assumptions have been violated, therefore disabling monospace optimizations!"),we=!1)}return we}toSlowRenderedLine(){return ke(this.domNode,this.input,this._characterMapping,!1,0)}getVisibleRangesForRange(e,t,i,n){const o=this._getColumnPixelOffset(e,t,n),s=this._getColumnPixelOffset(e,i,n);return[new de(o,s-o)]}_getColumnPixelOffset(e,t,i){if(t<=300){const e=this._characterMapping.getHorizontalOffset(t);return this._charWidth*e}const n=Math.floor((t-1)/300)-1,o=300*(n+1)+1;let s=-1;if(this._keyColumnPixelOffsetCache&&(s=this._keyColumnPixelOffsetCache[n],-1===s&&(s=this._actualReadPixelOffset(e,o,i),this._keyColumnPixelOffsetCache[n]=s)),-1===s){const e=this._characterMapping.getHorizontalOffset(t);return this._charWidth*e}const r=this._characterMapping.getHorizontalOffset(o),a=this._characterMapping.getHorizontalOffset(t);return s+this._charWidth*(a-r)}_getReadingTarget(e){return e.domNode.firstChild}_actualReadPixelOffset(e,t,i){if(!this.domNode)return-1;const n=this._characterMapping.getDomPosition(t),o=me.readHorizontalRanges(this._getReadingTarget(this.domNode),n.partIndex,n.charIndex,n.partIndex,n.charIndex,i);return o&&0!==o.length?o[0].left:-1}getColumnOfNodeOffset(e,t,i){const n=t.textContent.length;let o=-1;for(;t;)t=t.previousSibling,o++;return this._characterMapping.getColumn(new fe.wZ(o,i),n)}}class ye{constructor(e,t,i,n,o){if(this.domNode=e,this.input=t,this._characterMapping=i,this._isWhitespaceOnly=/^\s*$/.test(t.lineContent),this._containsForeignElements=o,this._cachedWidth=-1,this._pixelOffsetCache=null,!n||0===this._characterMapping.length){this._pixelOffsetCache=new Float32Array(Math.max(2,this._characterMapping.length+1));for(let e=0,t=this._characterMapping.length;e<=t;e++)this._pixelOffsetCache[e]=-1}}_getReadingTarget(e){return e.domNode.firstChild}getWidth(e){return this.domNode?(-1===this._cachedWidth&&(this._cachedWidth=this._getReadingTarget(this.domNode).offsetWidth,null==e||e.markDidDomLayout()),this._cachedWidth):0}getWidthIsFast(){return-1!==this._cachedWidth}getVisibleRangesForRange(e,t,i,n){if(!this.domNode)return null;if(null!==this._pixelOffsetCache){const o=this._readPixelOffset(this.domNode,e,t,n);if(-1===o)return null;const s=this._readPixelOffset(this.domNode,e,i,n);return-1===s?null:[new de(o,s-o)]}return this._readVisibleRangesForRange(this.domNode,e,t,i,n)}_readVisibleRangesForRange(e,t,i,n,o){if(i===n){const n=this._readPixelOffset(e,t,i,o);return-1===n?null:[new de(n,0)]}return this._readRawVisibleRangesForRange(e,i,n,o)}_readPixelOffset(e,t,i,n){if(0===this._characterMapping.length){if(0===this._containsForeignElements)return 0;if(2===this._containsForeignElements)return 0;if(1===this._containsForeignElements)return this.getWidth(n);const t=this._getReadingTarget(e);return t.firstChild?(n.markDidDomLayout(),t.firstChild.offsetWidth):0}if(null!==this._pixelOffsetCache){const o=this._pixelOffsetCache[i];if(-1!==o)return o;const s=this._actualReadPixelOffset(e,t,i,n);return this._pixelOffsetCache[i]=s,s}return this._actualReadPixelOffset(e,t,i,n)}_actualReadPixelOffset(e,t,i,n){if(0===this._characterMapping.length){const t=me.readHorizontalRanges(this._getReadingTarget(e),0,0,0,0,n);return t&&0!==t.length?t[0].left:-1}if(i===this._characterMapping.length&&this._isWhitespaceOnly&&0===this._containsForeignElements)return this.getWidth(n);const o=this._characterMapping.getDomPosition(i),s=me.readHorizontalRanges(this._getReadingTarget(e),o.partIndex,o.charIndex,o.partIndex,o.charIndex,n);if(!s||0===s.length)return-1;const r=s[0].left;if(this.input.isBasicASCII){const e=this._characterMapping.getHorizontalOffset(i),t=Math.round(this.input.spaceWidth*e);if(Math.abs(t-r)<=1)return t}return r}_readRawVisibleRangesForRange(e,t,i,n){if(1===t&&i===this._characterMapping.length)return[new de(0,this.getWidth(n))];const o=this._characterMapping.getDomPosition(t),s=this._characterMapping.getDomPosition(i);return me.readHorizontalRanges(this._getReadingTarget(e),o.partIndex,o.charIndex,s.partIndex,s.charIndex,n)}getColumnOfNodeOffset(e,t,i){const n=t.textContent.length;let o=-1;for(;t;)t=t.previousSibling,o++;return this._characterMapping.getColumn(new fe.wZ(o,i),n)}}class Se extends ye{_readVisibleRangesForRange(e,t,i,n,o){const s=super._readVisibleRangesForRange(e,t,i,n,o);if(!s||0===s.length||i===n||1===i&&n===this._characterMapping.length)return s;if(!this.input.containsRTL){const i=this._readPixelOffset(e,t,n,o);if(-1!==i){const e=s[s.length-1];e.left<i&&(e.width=i-e.left)}}return s}}const ke=f.isWebKit?function(e,t,i,n,o){return new Se(e,t,i,n,o)}:function(e,t,i,n,o){return new ye(e,t,i,n,o)};var Ee,De=i(8047),xe=i(3959),Le=i(6103);class Me{static whitespaceVisibleColumn(e,t,i){const n=e.length;let o=0,s=-1,r=-1;for(let a=0;a<n;a++){if(a===t)return[s,r,o];switch(o%i==0&&(s=a,r=o),e.charCodeAt(a)){case 32:o+=1;break;case 9:o=Le.A.nextRenderTabStop(o,i);break;default:return[-1,-1,-1]}}return t===n?[s,r,o]:[-1,-1,-1]}static atomicPosition(e,t,i,n){const o=e.length,[s,r,a]=Me.whitespaceVisibleColumn(e,t,i);if(-1===a)return-1;let l;switch(n){case 0:l=!0;break;case 1:l=!1;break;case 2:if(a%i==0)return t;l=a%i<=i/2}if(l){if(-1===s)return-1;let t=r;for(let n=s;n<o;++n){if(t===r+i)return s;switch(e.charCodeAt(n)){case 32:t+=1;break;case 9:t=Le.A.nextRenderTabStop(t,i);break;default:return-1}}return t===r+i?s:-1}const h=Le.A.nextRenderTabStop(a,i);let c=a;for(let n=t;n<o;n++){if(c===h)return n;switch(e.charCodeAt(n)){case 32:c+=1;break;case 9:c=Le.A.nextRenderTabStop(c,i);break;default:return-1}}return c===h?o:-1}}class Ie{constructor(e=null){this.hitTarget=e,this.type=0}}class Be{constructor(e,t,i){this.position=e,this.spanNode=t,this.injectedText=i,this.type=1}}!function(e){e.createFromDOMInfo=function(e,t,i){const n=e.getPositionFromDOMInfo(t,i);return n?new Be(n,t,null):new Ie(t)}}(Ee||(Ee={}));class Ne{constructor(e,t){this.lastViewCursorsRenderData=e,this.lastTextareaPosition=t}}class Te{static _deduceRage(e,t=null){return!t&&e?new xe.Q(e.lineNumber,e.column,e.lineNumber,e.column):null!=t?t:null}static createUnknown(e,t,i){return{type:0,element:e,mouseColumn:t,position:i,range:this._deduceRage(i)}}static createTextarea(e,t){return{type:1,element:e,mouseColumn:t,position:null,range:null}}static createMargin(e,t,i,n,o,s){return{type:e,element:t,mouseColumn:i,position:n,range:o,detail:s}}static createViewZone(e,t,i,n,o){return{type:e,element:t,mouseColumn:i,position:n,range:this._deduceRage(n),detail:o}}static createContentText(e,t,i,n,o){return{type:6,element:e,mouseColumn:t,position:i,range:this._deduceRage(i,n),detail:o}}static createContentEmpty(e,t,i,n){return{type:7,element:e,mouseColumn:t,position:i,range:this._deduceRage(i),detail:n}}static createContentWidget(e,t,i){return{type:9,element:e,mouseColumn:t,position:null,range:null,detail:i}}static createScrollbar(e,t,i){return{type:11,element:e,mouseColumn:t,position:i,range:this._deduceRage(i)}}static createOverlayWidget(e,t,i){return{type:12,element:e,mouseColumn:t,position:null,range:null,detail:i}}static createOutsideEditor(e,t,i,n){return{type:13,element:null,mouseColumn:e,position:t,range:this._deduceRage(t),outsidePosition:i,outsideDistance:n}}static _typeToString(e){return 1===e?"TEXTAREA":2===e?"GUTTER_GLYPH_MARGIN":3===e?"GUTTER_LINE_NUMBERS":4===e?"GUTTER_LINE_DECORATIONS":5===e?"GUTTER_VIEW_ZONE":6===e?"CONTENT_TEXT":7===e?"CONTENT_EMPTY":8===e?"CONTENT_VIEW_ZONE":9===e?"CONTENT_WIDGET":10===e?"OVERVIEW_RULER":11===e?"SCROLLBAR":12===e?"OVERLAY_WIDGET":"UNKNOWN"}static toString(e){return this._typeToString(e.type)+": "+e.position+" - "+e.range+" - "+JSON.stringify(e.detail)}}class Fe{static isTextArea(e){return 2===e.length&&3===e[0]&&6===e[1]}static isChildOfViewLines(e){return e.length>=4&&3===e[0]&&7===e[3]}static isStrictChildOfViewLines(e){return e.length>4&&3===e[0]&&7===e[3]}static isChildOfScrollableElement(e){return e.length>=2&&3===e[0]&&5===e[1]}static isChildOfMinimap(e){return e.length>=2&&3===e[0]&&8===e[1]}static isChildOfContentWidgets(e){return e.length>=4&&3===e[0]&&1===e[3]}static isChildOfOverflowingContentWidgets(e){return e.length>=1&&2===e[0]}static isChildOfOverlayWidgets(e){return e.length>=2&&3===e[0]&&4===e[1]}}class Re{constructor(e,t,i){this.viewModel=e.viewModel;const n=e.configuration.options;this.layoutInfo=n.get(140),this.viewDomNode=t.viewDomNode,this.lineHeight=n.get(64),this.stickyTabStops=n.get(112),this.typicalHalfwidthCharacterWidth=n.get(48).typicalHalfwidthCharacterWidth,this.lastRenderData=i,this._context=e,this._viewHelper=t}getZoneAtCoord(e){return Re.getZoneAtCoord(this._context,e)}static getZoneAtCoord(e,t){const i=e.viewLayout.getWhitespaceAtVerticalOffset(t);if(i){const n=i.verticalOffset+i.height/2,o=e.viewModel.getLineCount();let s,r=null,a=null;return i.afterLineNumber!==o&&(a=new De.y(i.afterLineNumber+1,1)),i.afterLineNumber>0&&(r=new De.y(i.afterLineNumber,e.viewModel.getLineMaxColumn(i.afterLineNumber))),s=null===a?r:null===r?a:t<n?r:a,{viewZoneId:i.id,afterLineNumber:i.afterLineNumber,positionBefore:r,positionAfter:a,position:s}}return null}getFullLineRangeAtCoord(e){if(this._context.viewLayout.isAfterLines(e)){const e=this._context.viewModel.getLineCount(),t=this._context.viewModel.getLineMaxColumn(e);return{range:new xe.Q(e,t,e,t),isAfterLines:!0}}const t=this._context.viewLayout.getLineNumberAtVerticalOffset(e),i=this._context.viewModel.getLineMaxColumn(t);return{range:new xe.Q(t,1,t,i),isAfterLines:!1}}getLineNumberAtVerticalOffset(e){return this._context.viewLayout.getLineNumberAtVerticalOffset(e)}isAfterLines(e){return this._context.viewLayout.isAfterLines(e)}isInTopPadding(e){return this._context.viewLayout.isInTopPadding(e)}isInBottomPadding(e){return this._context.viewLayout.isInBottomPadding(e)}getVerticalOffsetForLineNumber(e){return this._context.viewLayout.getVerticalOffsetForLineNumber(e)}findAttribute(e,t){return Re._findAttribute(e,t,this._viewHelper.viewDomNode)}static _findAttribute(e,t,i){for(;e&&e!==document.body;){if(e.hasAttribute&&e.hasAttribute(t))return e.getAttribute(t);if(e===i)return null;e=e.parentNode}return null}getLineWidth(e){return this._viewHelper.getLineWidth(e)}visibleRangeForPosition(e,t){return this._viewHelper.visibleRangeForPosition(e,t)}getPositionFromDOMInfo(e,t){return this._viewHelper.getPositionFromDOMInfo(e,t)}getCurrentScrollTop(){return this._context.viewLayout.getCurrentScrollTop()}getCurrentScrollLeft(){return this._context.viewLayout.getCurrentScrollLeft()}}class Oe{constructor(e,t,i,n){this.editorPos=t,this.pos=i,this.relativePos=n,this.mouseVerticalOffset=Math.max(0,e.getCurrentScrollTop()+this.relativePos.y),this.mouseContentHorizontalOffset=e.getCurrentScrollLeft()+this.relativePos.x-e.layoutInfo.contentLeft,this.isInMarginArea=this.relativePos.x<e.layoutInfo.contentLeft&&this.relativePos.x>=e.layoutInfo.glyphMarginLeft,this.isInContentArea=!this.isInMarginArea,this.mouseColumn=Math.max(0,He._getMouseColumn(this.mouseContentHorizontalOffset,e.typicalHalfwidthCharacterWidth))}}class Pe extends Oe{constructor(e,t,i,n,o){super(e,t,i,n),this._ctx=e,o?(this.target=o,this.targetPath=re.collect(o,e.viewDomNode)):(this.target=null,this.targetPath=new Uint8Array(0))}toString(){return`pos(${this.pos.x},${this.pos.y}), editorPos(${this.editorPos.x},${this.editorPos.y}), relativePos(${this.relativePos.x},${this.relativePos.y}), mouseVerticalOffset: ${this.mouseVerticalOffset}, mouseContentHorizontalOffset: ${this.mouseContentHorizontalOffset}\n\ttarget: ${this.target?this.target.outerHTML:null}`}_getMouseColumn(e=null){return e&&e.column<this._ctx.viewModel.getLineMaxColumn(e.lineNumber)?Le.A.visibleColumnFromColumn(this._ctx.viewModel.getLineContent(e.lineNumber),e.column,this._ctx.viewModel.model.getOptions().tabSize)+1:this.mouseColumn}fulfillUnknown(e=null){return Te.createUnknown(this.target,this._getMouseColumn(e),e)}fulfillTextarea(){return Te.createTextarea(this.target,this._getMouseColumn())}fulfillMargin(e,t,i,n){return Te.createMargin(e,this.target,this._getMouseColumn(t),t,i,n)}fulfillViewZone(e,t,i){return Te.createViewZone(e,this.target,this._getMouseColumn(t),t,i)}fulfillContentText(e,t,i){return Te.createContentText(this.target,this._getMouseColumn(e),e,t,i)}fulfillContentEmpty(e,t){return Te.createContentEmpty(this.target,this._getMouseColumn(e),e,t)}fulfillContentWidget(e){return Te.createContentWidget(this.target,this._getMouseColumn(),e)}fulfillScrollbar(e){return Te.createScrollbar(this.target,this._getMouseColumn(e),e)}fulfillOverlayWidget(e){return Te.createOverlayWidget(this.target,this._getMouseColumn(),e)}withTarget(e){return new Pe(this._ctx,this.editorPos,this.pos,this.relativePos,e)}}const ze={isAfterLines:!0};function Qe(e){return{isAfterLines:!1,horizontalDistanceToText:e}}class He{constructor(e,t){this._context=e,this._viewHelper=t}mouseTargetIsWidget(e){const t=e.target,i=re.collect(t,this._viewHelper.viewDomNode);return!(!Fe.isChildOfContentWidgets(i)&&!Fe.isChildOfOverflowingContentWidgets(i)&&!Fe.isChildOfOverlayWidgets(i))}createMouseTarget(e,t,i,n,o){const s=new Re(this._context,this._viewHelper,e),r=new Pe(s,t,i,n,o);try{const e=He._createMouseTarget(s,r,!1);if(6===e.type&&s.stickyTabStops&&null!==e.position){const t=He._snapToSoftTabBoundary(e.position,s.viewModel),i=xe.Q.fromPositions(t,t).plusRange(e.range);return r.fulfillContentText(t,i,e.detail)}return e}catch(e){return r.fulfillUnknown()}}static _createMouseTarget(e,t,i){if(null===t.target){if(i)return t.fulfillUnknown();const n=He._doHitTest(e,t);return 1===n.type?He.createMouseTargetFromHitTestPosition(e,t,n.spanNode,n.position,n.injectedText):this._createMouseTarget(e,t.withTarget(n.hitTarget),!0)}const n=t;let o=null;return o=o||He._hitTestContentWidget(e,n),o=o||He._hitTestOverlayWidget(e,n),o=o||He._hitTestMinimap(e,n),o=o||He._hitTestScrollbarSlider(e,n),o=o||He._hitTestViewZone(e,n),o=o||He._hitTestMargin(e,n),o=o||He._hitTestViewCursor(e,n),o=o||He._hitTestTextArea(e,n),o=o||He._hitTestViewLines(e,n,i),o=o||He._hitTestScrollbar(e,n),o||t.fulfillUnknown()}static _hitTestContentWidget(e,t){if(Fe.isChildOfContentWidgets(t.targetPath)||Fe.isChildOfOverflowingContentWidgets(t.targetPath)){const i=e.findAttribute(t.target,"widgetId");return i?t.fulfillContentWidget(i):t.fulfillUnknown()}return null}static _hitTestOverlayWidget(e,t){if(Fe.isChildOfOverlayWidgets(t.targetPath)){const i=e.findAttribute(t.target,"widgetId");return i?t.fulfillOverlayWidget(i):t.fulfillUnknown()}return null}static _hitTestViewCursor(e,t){if(t.target){const i=e.lastRenderData.lastViewCursorsRenderData;for(const e of i)if(t.target===e.domNode)return t.fulfillContentText(e.position,null,{mightBeForeignElement:!1,injectedText:null})}if(t.isInContentArea){const i=e.lastRenderData.lastViewCursorsRenderData,n=t.mouseContentHorizontalOffset,o=t.mouseVerticalOffset;for(const s of i){if(n<s.contentLeft)continue;if(n>s.contentLeft+s.width)continue;const i=e.getVerticalOffsetForLineNumber(s.position.lineNumber);if(i<=o&&o<=i+s.height)return t.fulfillContentText(s.position,null,{mightBeForeignElement:!1,injectedText:null})}}return null}static _hitTestViewZone(e,t){const i=e.getZoneAtCoord(t.mouseVerticalOffset);if(i){const e=t.isInContentArea?8:5;return t.fulfillViewZone(e,i.position,i)}return null}static _hitTestTextArea(e,t){return Fe.isTextArea(t.targetPath)?e.lastRenderData.lastTextareaPosition?t.fulfillContentText(e.lastRenderData.lastTextareaPosition,null,{mightBeForeignElement:!1,injectedText:null}):t.fulfillTextarea():null}static _hitTestMargin(e,t){if(t.isInMarginArea){const i=e.getFullLineRangeAtCoord(t.mouseVerticalOffset),n=i.range.getStartPosition();let o=Math.abs(t.relativePos.x);const s={isAfterLines:i.isAfterLines,glyphMarginLeft:e.layoutInfo.glyphMarginLeft,glyphMarginWidth:e.layoutInfo.glyphMarginWidth,lineNumbersWidth:e.layoutInfo.lineNumbersWidth,offsetX:o};return o-=e.layoutInfo.glyphMarginLeft,o<=e.layoutInfo.glyphMarginWidth?t.fulfillMargin(2,n,i.range,s):(o-=e.layoutInfo.glyphMarginWidth,o<=e.layoutInfo.lineNumbersWidth?t.fulfillMargin(3,n,i.range,s):(o-=e.layoutInfo.lineNumbersWidth,t.fulfillMargin(4,n,i.range,s)))}return null}static _hitTestViewLines(e,t,i){if(!Fe.isChildOfViewLines(t.targetPath))return null;if(e.isInTopPadding(t.mouseVerticalOffset))return t.fulfillContentEmpty(new De.y(1,1),ze);if(e.isAfterLines(t.mouseVerticalOffset)||e.isInBottomPadding(t.mouseVerticalOffset)){const i=e.viewModel.getLineCount(),n=e.viewModel.getLineMaxColumn(i);return t.fulfillContentEmpty(new De.y(i,n),ze)}if(i){if(Fe.isStrictChildOfViewLines(t.targetPath)){const i=e.getLineNumberAtVerticalOffset(t.mouseVerticalOffset);if(0===e.viewModel.getLineLength(i)){const n=e.getLineWidth(i),o=Qe(t.mouseContentHorizontalOffset-n);return t.fulfillContentEmpty(new De.y(i,1),o)}const n=e.getLineWidth(i);if(t.mouseContentHorizontalOffset>=n){const o=Qe(t.mouseContentHorizontalOffset-n),s=new De.y(i,e.viewModel.getLineMaxColumn(i));return t.fulfillContentEmpty(s,o)}}return t.fulfillUnknown()}const n=He._doHitTest(e,t);return 1===n.type?He.createMouseTargetFromHitTestPosition(e,t,n.spanNode,n.position,n.injectedText):this._createMouseTarget(e,t.withTarget(n.hitTarget),!0)}static _hitTestMinimap(e,t){if(Fe.isChildOfMinimap(t.targetPath)){const i=e.getLineNumberAtVerticalOffset(t.mouseVerticalOffset),n=e.viewModel.getLineMaxColumn(i);return t.fulfillScrollbar(new De.y(i,n))}return null}static _hitTestScrollbarSlider(e,t){if(Fe.isChildOfScrollableElement(t.targetPath)&&t.target&&1===t.target.nodeType){const i=t.target.className;if(i&&/\b(slider|scrollbar)\b/.test(i)){const i=e.getLineNumberAtVerticalOffset(t.mouseVerticalOffset),n=e.viewModel.getLineMaxColumn(i);return t.fulfillScrollbar(new De.y(i,n))}}return null}static _hitTestScrollbar(e,t){if(Fe.isChildOfScrollableElement(t.targetPath)){const i=e.getLineNumberAtVerticalOffset(t.mouseVerticalOffset),n=e.viewModel.getLineMaxColumn(i);return t.fulfillScrollbar(new De.y(i,n))}return null}getMouseColumn(e){const t=this._context.configuration.options,i=t.get(140),n=this._context.viewLayout.getCurrentScrollLeft()+e.x-i.contentLeft;return He._getMouseColumn(n,t.get(48).typicalHalfwidthCharacterWidth)}static _getMouseColumn(e,t){return e<0?1:Math.round(e/t)+1}static createMouseTargetFromHitTestPosition(e,t,i,n,o){const s=n.lineNumber,r=n.column,a=e.getLineWidth(s);if(t.mouseContentHorizontalOffset>a){const e=Qe(t.mouseContentHorizontalOffset-a);return t.fulfillContentEmpty(n,e)}const l=e.visibleRangeForPosition(s,r);if(!l)return t.fulfillUnknown(n);const h=l.left;if(Math.abs(t.mouseContentHorizontalOffset-h)<1)return t.fulfillContentText(n,null,{mightBeForeignElement:!!o,injectedText:o});const c=[];if(c.push({offset:l.left,column:r}),r>1){const t=e.visibleRangeForPosition(s,r-1);t&&c.push({offset:t.left,column:r-1})}if(r<e.viewModel.getLineMaxColumn(s)){const t=e.visibleRangeForPosition(s,r+1);t&&c.push({offset:t.left,column:r+1})}c.sort(((e,t)=>e.offset-t.offset));const d=t.pos.toClientCoordinates(),u=i.getBoundingClientRect(),g=u.left<=d.clientX&&d.clientX<=u.right;let m=null;for(let e=1;e<c.length;e++){const i=c[e-1],o=c[e];if(i.offset<=t.mouseContentHorizontalOffset&&t.mouseContentHorizontalOffset<=o.offset){m=new xe.Q(s,i.column,s,o.column),n=Math.abs(i.offset-t.mouseContentHorizontalOffset)<Math.abs(o.offset-t.mouseContentHorizontalOffset)?new De.y(s,i.column):new De.y(s,o.column);break}}return t.fulfillContentText(n,m,{mightBeForeignElement:!g||!!o,injectedText:o})}static _doHitTestWithCaretRangeFromPoint(e,t){const i=e.getLineNumberAtVerticalOffset(t.mouseVerticalOffset),n=e.getVerticalOffsetForLineNumber(i),o=n+e.lineHeight;if(!(i===e.viewModel.getLineCount()&&t.mouseVerticalOffset>o)){const i=Math.floor((n+o)/2);let s=t.pos.y+(i-t.mouseVerticalOffset);s<=t.editorPos.y&&(s=t.editorPos.y+1),s>=t.editorPos.y+t.editorPos.height&&(s=t.editorPos.y+t.editorPos.height-1);const r=new j(t.pos.x,s),a=this._actualDoHitTestWithCaretRangeFromPoint(e,r.toClientCoordinates());if(1===a.type)return a}return this._actualDoHitTestWithCaretRangeFromPoint(e,t.pos.toClientCoordinates())}static _actualDoHitTestWithCaretRangeFromPoint(e,t){const i=d.jG(e.viewDomNode);let n;if(n=i?void 0===i.caretRangeFromPoint?function(e,t,i){const n=document.createRange();let o=e.elementFromPoint(t,i);if(null!==o){for(;o&&o.firstChild&&o.firstChild.nodeType!==o.firstChild.TEXT_NODE&&o.lastChild&&o.lastChild.firstChild;)o=o.lastChild;const e=o.getBoundingClientRect(),i=`${window.getComputedStyle(o,null).getPropertyValue("font-style")} ${window.getComputedStyle(o,null).getPropertyValue("font-variant")} ${window.getComputedStyle(o,null).getPropertyValue("font-weight")} ${window.getComputedStyle(o,null).getPropertyValue("font-size")}/${window.getComputedStyle(o,null).getPropertyValue("line-height")} ${window.getComputedStyle(o,null).getPropertyValue("font-family")}`,s=o.innerText;let r,a=e.left,l=0;if(t>e.left+e.width)l=s.length;else{const e=We.getInstance();for(let n=0;n<s.length+1;n++){if(r=e.getCharWidth(s.charAt(n),i)/2,a+=r,t<a){l=n;break}a+=r}}n.setStart(o.firstChild,l),n.setEnd(o.firstChild,l)}return n}(i,t.clientX,t.clientY):i.caretRangeFromPoint(t.clientX,t.clientY):document.caretRangeFromPoint(t.clientX,t.clientY),!n||!n.startContainer)return new Ie;const o=n.startContainer;if(o.nodeType===o.TEXT_NODE){const t=o.parentNode,i=t?t.parentNode:null,s=i?i.parentNode:null;return(s&&s.nodeType===s.ELEMENT_NODE?s.className:null)===ve.CLASS_NAME?Ee.createFromDOMInfo(e,t,n.startOffset):new Ie(o.parentNode)}if(o.nodeType===o.ELEMENT_NODE){const t=o.parentNode,i=t?t.parentNode:null;return(i&&i.nodeType===i.ELEMENT_NODE?i.className:null)===ve.CLASS_NAME?Ee.createFromDOMInfo(e,o,o.textContent.length):new Ie(o)}return new Ie}static _doHitTestWithCaretPositionFromPoint(e,t){const i=document.caretPositionFromPoint(t.clientX,t.clientY);if(i.offsetNode.nodeType===i.offsetNode.TEXT_NODE){const t=i.offsetNode.parentNode,n=t?t.parentNode:null,o=n?n.parentNode:null;return(o&&o.nodeType===o.ELEMENT_NODE?o.className:null)===ve.CLASS_NAME?Ee.createFromDOMInfo(e,i.offsetNode.parentNode,i.offset):new Ie(i.offsetNode.parentNode)}if(i.offsetNode.nodeType===i.offsetNode.ELEMENT_NODE){const t=i.offsetNode.parentNode,n=t&&t.nodeType===t.ELEMENT_NODE?t.className:null,o=t?t.parentNode:null,s=o&&o.nodeType===o.ELEMENT_NODE?o.className:null;if(n===ve.CLASS_NAME){const t=i.offsetNode.childNodes[Math.min(i.offset,i.offsetNode.childNodes.length-1)];if(t)return Ee.createFromDOMInfo(e,t,0)}else if(s===ve.CLASS_NAME)return Ee.createFromDOMInfo(e,i.offsetNode,0)}return new Ie(i.offsetNode)}static _snapToSoftTabBoundary(e,t){const i=t.getLineContent(e.lineNumber),{tabSize:n}=t.model.getOptions(),o=Me.atomicPosition(i,e.column-1,n,2);return-1!==o?new De.y(e.lineNumber,o+1):e}static _doHitTest(e,t){let i=new Ie;if("function"==typeof document.caretRangeFromPoint?i=this._doHitTestWithCaretRangeFromPoint(e,t):document.caretPositionFromPoint&&(i=this._doHitTestWithCaretPositionFromPoint(e,t.pos.toClientCoordinates())),1===i.type){const t=e.viewModel.getInjectedTextAt(i.position),n=e.viewModel.normalizePosition(i.position,2);!t&&n.equals(i.position)||(i=new Be(n,i.spanNode,t))}return i}}class We{static getInstance(){return We._INSTANCE||(We._INSTANCE=new We),We._INSTANCE}constructor(){this._cache={},this._canvas=document.createElement("canvas")}getCharWidth(e,t){const i=e+t;if(this._cache[i])return this._cache[i];const n=this._canvas.getContext("2d");n.font=t;const o=n.measureText(e).width;return this._cache[i]=o,o}}We._INSTANCE=null;var Ve=i(5443);class Ue extends oe{constructor(e,t,i){super(),this._mouseLeaveMonitor=null,this._context=e,this.viewController=t,this.viewHelper=i,this.mouseTargetFactory=new He(this._context,i),this._mouseDownOperation=this._register(new je(this._context,this.viewController,this.viewHelper,this.mouseTargetFactory,((e,t)=>this._createMouseTarget(e,t)),(e=>this._getMouseColumn(e)))),this.lastMouseLeaveTime=-1,this._height=this._context.configuration.options.get(140).height;const n=new X(this.viewHelper.viewDomNode);this._register(n.onContextMenu(this.viewHelper.viewDomNode,(e=>this._onContextMenu(e,!0)))),this._register(n.onMouseMove(this.viewHelper.viewDomNode,(e=>{this._onMouseMove(e),this._mouseLeaveMonitor||(this._mouseLeaveMonitor=d.ko(document,"mousemove",(e=>{this.viewHelper.viewDomNode.contains(e.target)||this._onMouseLeave(new $(e,!1,this.viewHelper.viewDomNode))})))}))),this._register(n.onMouseUp(this.viewHelper.viewDomNode,(e=>this._onMouseUp(e)))),this._register(n.onMouseLeave(this.viewHelper.viewDomNode,(e=>this._onMouseLeave(e))));let o=0;this._register(n.onPointerDown(this.viewHelper.viewDomNode,((e,t)=>{o=t}))),this._register(d.ko(this.viewHelper.viewDomNode,d.Bx.POINTER_UP,(e=>{this._mouseDownOperation.onPointerUp()}))),this._register(n.onMouseDown(this.viewHelper.viewDomNode,(e=>this._onMouseDown(e,o)))),this._setupMouseWheelZoomListener(),this._context.addEventHandler(this)}_setupMouseWheelZoomListener(){const e=Ve.QC.INSTANCE;let t=0,i=x.D.getZoomLevel(),n=!1,o=0;function s(e){return w.zx?(e.metaKey||e.ctrlKey)&&!e.shiftKey&&!e.altKey:e.ctrlKey&&!e.metaKey&&!e.shiftKey&&!e.altKey}this._register(d.ko(this.viewHelper.viewDomNode,d.Bx.MOUSE_WHEEL,(r=>{if(this.viewController.emitMouseWheel(r),!this._context.configuration.options.get(73))return;const a=new H.$(r);if(e.acceptStandardWheelEvent(a),e.isPhysicalMouseWheel()){if(s(r)){const e=x.D.getZoomLevel(),t=a.deltaY>0?1:-1;x.D.setZoomLevel(e+t),a.preventDefault(),a.stopPropagation()}}else Date.now()-t>50&&(i=x.D.getZoomLevel(),n=s(r),o=0),t=Date.now(),o+=a.deltaY,n&&(x.D.setZoomLevel(i+o/5),a.preventDefault(),a.stopPropagation())}),{capture:!0,passive:!1}))}dispose(){this._context.removeEventHandler(this),this._mouseLeaveMonitor&&(this._mouseLeaveMonitor.dispose(),this._mouseLeaveMonitor=null),super.dispose()}onConfigurationChanged(e){if(e.hasChanged(140)){const e=this._context.configuration.options.get(140).height;this._height!==e&&(this._height=e,this._mouseDownOperation.onHeightChanged())}return!1}onCursorStateChanged(e){return this._mouseDownOperation.onCursorStateChanged(e),!1}onFocusChanged(e){return!1}getTargetAtClientPoint(e,t){const i=new G(e,t).toPageCoordinates(),n=J(this.viewHelper.viewDomNode);if(i.y<n.y||i.y>n.y+n.height||i.x<n.x||i.x>n.x+n.width)return null;const o=q(this.viewHelper.viewDomNode,n,i);return this.mouseTargetFactory.createMouseTarget(this.viewHelper.getLastRenderData(),n,i,o,null)}_createMouseTarget(e,t){let i=e.target;if(!this.viewHelper.viewDomNode.contains(i)){const t=d.jG(this.viewHelper.viewDomNode);t&&(i=t.elementsFromPoint(e.posx,e.posy).find((e=>this.viewHelper.viewDomNode.contains(e))))}return this.mouseTargetFactory.createMouseTarget(this.viewHelper.getLastRenderData(),e.editorPos,e.pos,e.relativePos,t?i:null)}_getMouseColumn(e){return this.mouseTargetFactory.getMouseColumn(e.relativePos)}_onContextMenu(e,t){this.viewController.emitContextMenu({event:e,target:this._createMouseTarget(e,t)})}_onMouseMove(e){this.mouseTargetFactory.mouseTargetIsWidget(e)||e.preventDefault(),this._mouseDownOperation.isActive()||e.timestamp<this.lastMouseLeaveTime||this.viewController.emitMouseMove({event:e,target:this._createMouseTarget(e,!0)})}_onMouseLeave(e){this._mouseLeaveMonitor&&(this._mouseLeaveMonitor.dispose(),this._mouseLeaveMonitor=null),this.lastMouseLeaveTime=(new Date).getTime(),this.viewController.emitMouseLeave({event:e,target:null})}_onMouseUp(e){this.viewController.emitMouseUp({event:e,target:this._createMouseTarget(e,!0)})}_onMouseDown(e,t){const i=this._createMouseTarget(e,!0),n=6===i.type||7===i.type,o=2===i.type||3===i.type||4===i.type,s=3===i.type,r=this._context.configuration.options.get(105),a=8===i.type||5===i.type,l=9===i.type;let h=e.leftButton||e.middleButton;w.zx&&e.leftButton&&e.ctrlKey&&(h=!1);const c=()=>{e.preventDefault(),this.viewHelper.focusTextArea()};if(h&&(n||s&&r))c(),this._mouseDownOperation.start(i.type,e,t);else if(o)e.preventDefault();else if(a){const n=i.detail;h&&this.viewHelper.shouldSuppressMouseDownOnViewZone(n.viewZoneId)&&(c(),this._mouseDownOperation.start(i.type,e,t),e.preventDefault())}else l&&this.viewHelper.shouldSuppressMouseDownOnWidget(i.detail)&&(c(),e.preventDefault());this.viewController.emitMouseDown({event:e,target:i})}}class je extends m.jG{constructor(e,t,i,n,o,s){super(),this._context=e,this._viewController=t,this._viewHelper=i,this._mouseTargetFactory=n,this._createMouseTarget=o,this._getMouseColumn=s,this._mouseMoveMonitor=this._register(new ee(this._viewHelper.viewDomNode)),this._topBottomDragScrolling=this._register(new Ge(this._context,this._viewHelper,this._mouseTargetFactory,((e,t,i)=>this._dispatchMouse(e,t,i)))),this._mouseState=new Ye,this._currentSelection=new P.L(1,1,1,1),this._isActive=!1,this._lastMouseEvent=null}dispose(){super.dispose()}isActive(){return this._isActive}_onMouseDownThenMove(e){this._lastMouseEvent=e,this._mouseState.setModifiers(e);const t=this._findMousePosition(e,!1);t&&(this._mouseState.isDragAndDrop?this._viewController.emitMouseDrag({event:e,target:t}):13!==t.type||"above"!==t.outsidePosition&&"below"!==t.outsidePosition?(this._topBottomDragScrolling.stop(),this._dispatchMouse(t,!0,1)):this._topBottomDragScrolling.start(t,e))}start(e,t,i){this._lastMouseEvent=t,this._mouseState.setStartedOnLineNumbers(3===e),this._mouseState.setStartButtons(t),this._mouseState.setModifiers(t);const n=this._findMousePosition(t,!0);if(!n||!n.position)return;this._mouseState.trySetCount(t.detail,n.position),t.detail=this._mouseState.count;const o=this._context.configuration.options;if(!o.get(88)&&o.get(33)&&!o.get(20)&&!this._mouseState.altKey&&t.detail<2&&!this._isActive&&!this._currentSelection.isEmpty()&&6===n.type&&n.position&&this._currentSelection.containsPosition(n.position))return this._mouseState.isDragAndDrop=!0,this._isActive=!0,void this._mouseMoveMonitor.startMonitoring(this._viewHelper.viewLinesDomNode,i,t.buttons,(e=>this._onMouseDownThenMove(e)),(e=>{const t=this._findMousePosition(this._lastMouseEvent,!1);e&&e instanceof KeyboardEvent?this._viewController.emitMouseDropCanceled():this._viewController.emitMouseDrop({event:this._lastMouseEvent,target:t?this._createMouseTarget(this._lastMouseEvent,!0):null}),this._stop()}));this._mouseState.isDragAndDrop=!1,this._dispatchMouse(n,t.shiftKey,1),this._isActive||(this._isActive=!0,this._mouseMoveMonitor.startMonitoring(this._viewHelper.viewLinesDomNode,i,t.buttons,(e=>this._onMouseDownThenMove(e)),(()=>this._stop())))}_stop(){this._isActive=!1,this._topBottomDragScrolling.stop()}onHeightChanged(){this._mouseMoveMonitor.stopMonitoring()}onPointerUp(){this._mouseMoveMonitor.stopMonitoring()}onCursorStateChanged(e){this._currentSelection=e.selections[0]}_getPositionOutsideEditor(e){const t=e.editorPos,i=this._context.viewModel,n=this._context.viewLayout,o=this._getMouseColumn(e);if(e.posy<t.y){const i=t.y-e.posy,s=Math.max(n.getCurrentScrollTop()-i,0),r=Re.getZoneAtCoord(this._context,s);if(r){const e=this._helpPositionJumpOverViewZone(r);if(e)return Te.createOutsideEditor(o,e,"above",i)}const a=n.getLineNumberAtVerticalOffset(s);return Te.createOutsideEditor(o,new De.y(a,1),"above",i)}if(e.posy>t.y+t.height){const s=e.posy-t.y-t.height,r=n.getCurrentScrollTop()+e.relativePos.y,a=Re.getZoneAtCoord(this._context,r);if(a){const e=this._helpPositionJumpOverViewZone(a);if(e)return Te.createOutsideEditor(o,e,"below",s)}const l=n.getLineNumberAtVerticalOffset(r);return Te.createOutsideEditor(o,new De.y(l,i.getLineMaxColumn(l)),"below",s)}const s=n.getLineNumberAtVerticalOffset(n.getCurrentScrollTop()+e.relativePos.y);if(e.posx<t.x){const i=t.x-e.posx;return Te.createOutsideEditor(o,new De.y(s,1),"left",i)}if(e.posx>t.x+t.width){const n=e.posx-t.x-t.width;return Te.createOutsideEditor(o,new De.y(s,i.getLineMaxColumn(s)),"right",n)}return null}_findMousePosition(e,t){const i=this._getPositionOutsideEditor(e);if(i)return i;const n=this._createMouseTarget(e,t);if(!n.position)return null;if(8===n.type||5===n.type){const e=this._helpPositionJumpOverViewZone(n.detail);if(e)return Te.createViewZone(n.type,n.element,n.mouseColumn,e,n.detail)}return n}_helpPositionJumpOverViewZone(e){const t=new De.y(this._currentSelection.selectionStartLineNumber,this._currentSelection.selectionStartColumn),i=e.positionBefore,n=e.positionAfter;return i&&n?i.isBefore(t)?i:n:null}_dispatchMouse(e,t,i){e.position&&this._viewController.dispatchMouse({position:e.position,mouseColumn:e.mouseColumn,startedOnLineNumbers:this._mouseState.startedOnLineNumbers,revealType:i,inSelectionMode:t,mouseDownCount:this._mouseState.count,altKey:this._mouseState.altKey,ctrlKey:this._mouseState.ctrlKey,metaKey:this._mouseState.metaKey,shiftKey:this._mouseState.shiftKey,leftButton:this._mouseState.leftButton,middleButton:this._mouseState.middleButton,onInjectedText:6===e.type&&null!==e.detail.injectedText})}}class Ge extends m.jG{constructor(e,t,i,n){super(),this._context=e,this._viewHelper=t,this._mouseTargetFactory=i,this._dispatchMouse=n,this._operation=null}dispose(){super.dispose(),this.stop()}start(e,t){this._operation?this._operation.setPosition(e,t):this._operation=new Ke(this._context,this._viewHelper,this._mouseTargetFactory,this._dispatchMouse,e,t)}stop(){this._operation&&(this._operation.dispose(),this._operation=null)}}class Ke extends m.jG{constructor(e,t,i,n,o,s){super(),this._context=e,this._viewHelper=t,this._mouseTargetFactory=i,this._dispatchMouse=n,this._position=o,this._mouseEvent=s,this._lastTime=Date.now(),this._animationFrameDisposable=d.PG((()=>this._execute()))}dispose(){this._animationFrameDisposable.dispose()}setPosition(e,t){this._position=e,this._mouseEvent=t}_tick(){const e=Date.now(),t=e-this._lastTime;return this._lastTime=e,t}_getScrollSpeed(){const e=this._context.configuration.options.get(64),t=this._context.configuration.options.get(140).height/e,i=this._position.outsideDistance/e;return i<=1.5?Math.max(30,t*(1+i)):i<=3?Math.max(60,t*(2+i)):Math.max(200,t*(7+i))}_execute(){const e=this._context.configuration.options.get(64),t=this._getScrollSpeed()*(this._tick()/1e3)*e,i="above"===this._position.outsidePosition?-t:t;this._context.viewModel.viewLayout.deltaScrollNow(0,i),this._viewHelper.renderNow();const n=this._context.viewLayout.getLinesViewportData(),o="above"===this._position.outsidePosition?n.startLineNumber:n.endLineNumber;let s;{const e=J(this._viewHelper.viewDomNode),t=this._context.configuration.options.get(140).horizontalScrollbarHeight,i=new j(this._mouseEvent.pos.x,e.y+e.height-t-.1),n=q(this._viewHelper.viewDomNode,e,i);s=this._mouseTargetFactory.createMouseTarget(this._viewHelper.getLastRenderData(),e,i,n,null)}s.position&&s.position.lineNumber===o||(s="above"===this._position.outsidePosition?Te.createOutsideEditor(this._position.mouseColumn,new De.y(o,1),"above",this._position.outsideDistance):Te.createOutsideEditor(this._position.mouseColumn,new De.y(o,this._context.viewModel.getLineMaxColumn(o)),"below",this._position.outsideDistance)),this._dispatchMouse(s,!0,2),this._animationFrameDisposable=d.PG((()=>this._execute()))}}class Ye{get altKey(){return this._altKey}get ctrlKey(){return this._ctrlKey}get metaKey(){return this._metaKey}get shiftKey(){return this._shiftKey}get leftButton(){return this._leftButton}get middleButton(){return this._middleButton}get startedOnLineNumbers(){return this._startedOnLineNumbers}constructor(){this._altKey=!1,this._ctrlKey=!1,this._metaKey=!1,this._shiftKey=!1,this._leftButton=!1,this._middleButton=!1,this._startedOnLineNumbers=!1,this._lastMouseDownPosition=null,this._lastMouseDownPositionEqualCount=0,this._lastMouseDownCount=0,this._lastSetMouseDownCountTime=0,this.isDragAndDrop=!1}get count(){return this._lastMouseDownCount}setModifiers(e){this._altKey=e.altKey,this._ctrlKey=e.ctrlKey,this._metaKey=e.metaKey,this._shiftKey=e.shiftKey}setStartButtons(e){this._leftButton=e.leftButton,this._middleButton=e.middleButton}setStartedOnLineNumbers(e){this._startedOnLineNumbers=e}trySetCount(e,t){const i=(new Date).getTime();i-this._lastSetMouseDownCountTime>Ye.CLEAR_MOUSE_DOWN_COUNT_TIME&&(e=1),this._lastSetMouseDownCountTime=i,e>this._lastMouseDownCount+1&&(e=this._lastMouseDownCount+1),this._lastMouseDownPosition&&this._lastMouseDownPosition.equals(t)?this._lastMouseDownPositionEqualCount++:this._lastMouseDownPositionEqualCount=1,this._lastMouseDownPosition=t,this._lastMouseDownCount=Math.min(e,this._lastMouseDownPositionEqualCount)}}Ye.CLEAR_MOUSE_DOWN_COUNT_TIME=400;var Je,qe=i(4179),$e=i(9923),Xe=i(192);!function(e){const t={total:0,min:Number.MAX_VALUE,max:0},i=Object.assign({},t),n=Object.assign({},t),o=Object.assign({},t);let s=0;const r={keydown:0,input:0,render:0};function a(){1===r.keydown&&(performance.mark("keydown/end"),r.keydown=2)}function l(){performance.mark("input/start"),r.input=1,d()}function h(){1===r.input&&(performance.mark("input/end"),r.input=2)}function c(){1===r.render&&(performance.mark("render/end"),r.render=2)}function d(){setTimeout(u)}function u(){2===r.keydown&&2===r.input&&2===r.render&&(performance.mark("inputlatency/end"),performance.measure("keydown","keydown/start","keydown/end"),performance.measure("input","input/start","input/end"),performance.measure("render","render/start","render/end"),performance.measure("inputlatency","inputlatency/start","inputlatency/end"),g("keydown",t),g("input",i),g("render",n),g("inputlatency",o),s++,performance.clearMarks("keydown/start"),performance.clearMarks("keydown/end"),performance.clearMarks("input/start"),performance.clearMarks("input/end"),performance.clearMarks("render/start"),performance.clearMarks("render/end"),performance.clearMarks("inputlatency/start"),performance.clearMarks("inputlatency/end"),performance.clearMeasures("keydown"),performance.clearMeasures("input"),performance.clearMeasures("render"),performance.clearMeasures("inputlatency"),r.keydown=0,r.input=0,r.render=0)}function g(e,t){const i=performance.getEntriesByName(e)[0].duration;t.total+=i,t.min=Math.min(t.min,i),t.max=Math.max(t.max,i)}function m(e){return{average:e.total/s,max:e.max,min:e.min}}function p(e){e.total=0,e.min=Number.MAX_VALUE,e.max=0}e.onKeyDown=function(){u(),performance.mark("inputlatency/start"),performance.mark("keydown/start"),r.keydown=1,queueMicrotask(a)},e.onBeforeInput=l,e.onInput=function(){0===r.input&&l(),queueMicrotask(h)},e.onKeyUp=function(){u()},e.onSelectionChange=function(){u()},e.onRenderStart=function(){2===r.keydown&&2===r.input&&0===r.render&&(performance.mark("render/start"),r.render=1,queueMicrotask(c),d())},e.getAndClearMeasurements=function(){if(0===s)return;const e={keydown:m(t),input:m(i),render:m(n),total:m(o),sampleCount:s};return p(t),p(i),p(n),p(o),s=0,e}}(Je||(Je={}));var Ze,et=i(2694),tt=i(5306);class it{constructor(e,t,i,n,o){this.value=e,this.selectionStart=t,this.selectionEnd=i,this.selection=n,this.newlineCountBeforeSelection=o}toString(){return`[ <${this.value}>, selectionStart: ${this.selectionStart}, selectionEnd: ${this.selectionEnd}]`}static readFromTextArea(e,t){const i=e.getValue(),n=e.getSelectionStart(),o=e.getSelectionEnd();let s;return t&&i.substring(0,n)===t.value.substring(0,t.selectionStart)&&(s=t.newlineCountBeforeSelection),new it(i,n,o,null,s)}collapseSelection(){return this.selectionStart===this.value.length?this:new it(this.value,this.value.length,this.value.length,null,void 0)}writeToTextArea(e,t,i){t.setValue(e,this.value),i&&t.setSelectionRange(e,this.selectionStart,this.selectionEnd)}deduceEditorPosition(e){var t,i,n,o,s,r,a,l;if(e<=this.selectionStart){const n=this.value.substring(e,this.selectionStart);return this._finishDeduceEditorPosition(null!==(i=null===(t=this.selection)||void 0===t?void 0:t.getStartPosition())&&void 0!==i?i:null,n,-1)}if(e>=this.selectionEnd){const t=this.value.substring(this.selectionEnd,e);return this._finishDeduceEditorPosition(null!==(o=null===(n=this.selection)||void 0===n?void 0:n.getEndPosition())&&void 0!==o?o:null,t,1)}const h=this.value.substring(this.selectionStart,e);if(-1===h.indexOf(String.fromCharCode(8230)))return this._finishDeduceEditorPosition(null!==(r=null===(s=this.selection)||void 0===s?void 0:s.getStartPosition())&&void 0!==r?r:null,h,1);const c=this.value.substring(e,this.selectionEnd);return this._finishDeduceEditorPosition(null!==(l=null===(a=this.selection)||void 0===a?void 0:a.getEndPosition())&&void 0!==l?l:null,c,-1)}_finishDeduceEditorPosition(e,t,i){let n=0,o=-1;for(;-1!==(o=t.indexOf("\n",o+1));)n++;return[e,i*t.length,n]}static deduceInput(e,t,i){if(!e)return{text:"",replacePrevCharCnt:0,replaceNextCharCnt:0,positionDelta:0};const n=Math.min(tt.Qp(e.value,t.value),e.selectionStart,t.selectionStart),o=Math.min(tt.Vi(e.value,t.value),e.value.length-e.selectionEnd,t.value.length-t.selectionEnd),s=(e.value.substring(n,e.value.length-o),t.value.substring(n,t.value.length-o)),r=e.selectionStart-n,a=e.selectionEnd-n;return t.selectionStart-n==t.selectionEnd-n?{text:s,replacePrevCharCnt:e.selectionStart-n,replaceNextCharCnt:0,positionDelta:0}:{text:s,replacePrevCharCnt:a-r,replaceNextCharCnt:0,positionDelta:0}}static deduceAndroidCompositionInput(e,t){if(!e)return{text:"",replacePrevCharCnt:0,replaceNextCharCnt:0,positionDelta:0};if(e.value===t.value)return{text:"",replacePrevCharCnt:0,replaceNextCharCnt:0,positionDelta:t.selectionEnd-e.selectionEnd};const i=Math.min(tt.Qp(e.value,t.value),e.selectionEnd),n=Math.min(tt.Vi(e.value,t.value),e.value.length-e.selectionEnd),o=e.value.substring(i,e.value.length-n),s=t.value.substring(i,t.value.length-n),r=(e.selectionStart,e.selectionEnd-i),a=(t.selectionStart,t.selectionEnd-i);return{text:s,replacePrevCharCnt:r,replaceNextCharCnt:o.length-r,positionDelta:a-s.length}}}it.EMPTY=new it("",0,0,null,void 0);class nt{static _getPageOfLine(e,t){return Math.floor((e-1)/t)}static _getRangeForPage(e,t){const i=e*t,n=i+1,o=i+t;return new xe.Q(n,1,o+1,1)}static fromEditorSelection(e,t,i,n){const o=500,s=nt._getPageOfLine(t.startLineNumber,i),r=nt._getRangeForPage(s,i),a=nt._getPageOfLine(t.endLineNumber,i),l=nt._getRangeForPage(a,i);let h=r.intersectRanges(new xe.Q(1,1,t.startLineNumber,t.startColumn));if(n&&e.getValueLengthInRange(h,1)>o){const t=e.modifyPosition(h.getEndPosition(),-500);h=xe.Q.fromPositions(t,h.getEndPosition())}const c=e.getValueInRange(h,1),d=e.getLineCount(),u=e.getLineMaxColumn(d);let g=l.intersectRanges(new xe.Q(t.endLineNumber,t.endColumn,d,u));if(n&&e.getValueLengthInRange(g,1)>o){const t=e.modifyPosition(g.getStartPosition(),o);g=xe.Q.fromPositions(g.getStartPosition(),t)}const m=e.getValueInRange(g,1);let p;if(s===a||s+1===a)p=e.getValueInRange(t,1);else{const i=r.intersectRanges(t),n=l.intersectRanges(t);p=e.getValueInRange(i,1)+String.fromCharCode(8230)+e.getValueInRange(n,1)}return n&&p.length>1e3&&(p=p.substring(0,o)+String.fromCharCode(8230)+p.substring(p.length-o,p.length)),new it(c+p+m,c.length,c.length+p.length,t,h.endLineNumber-h.startLineNumber)}}!function(e){e.Tap="-monaco-textarea-synthetic-tap"}(Ze||(Ze={}));class ot{constructor(){this._lastState=null}set(e,t){this._lastState={lastCopiedValue:e,data:t}}get(e){return this._lastState&&this._lastState.lastCopiedValue===e?this._lastState.data:(this._lastState=null,null)}}ot.INSTANCE=new ot;class st{constructor(){this._lastTypeTextLength=0}handleCompositionUpdate(e){const t={text:e=e||"",replacePrevCharCnt:this._lastTypeTextLength,replaceNextCharCnt:0,positionDelta:0};return this._lastTypeTextLength=e.length,t}}class rt extends m.jG{get textAreaState(){return this._textAreaState}constructor(e,t,i,n){super(),this._host=e,this._textArea=t,this._OS=i,this._browser=n,this._onFocus=this._register(new g.vl),this.onFocus=this._onFocus.event,this._onBlur=this._register(new g.vl),this.onBlur=this._onBlur.event,this._onKeyDown=this._register(new g.vl),this.onKeyDown=this._onKeyDown.event,this._onKeyUp=this._register(new g.vl),this.onKeyUp=this._onKeyUp.event,this._onCut=this._register(new g.vl),this.onCut=this._onCut.event,this._onPaste=this._register(new g.vl),this.onPaste=this._onPaste.event,this._onType=this._register(new g.vl),this.onType=this._onType.event,this._onCompositionStart=this._register(new g.vl),this.onCompositionStart=this._onCompositionStart.event,this._onCompositionUpdate=this._register(new g.vl),this.onCompositionUpdate=this._onCompositionUpdate.event,this._onCompositionEnd=this._register(new g.vl),this.onCompositionEnd=this._onCompositionEnd.event,this._onSelectionChangeRequest=this._register(new g.vl),this.onSelectionChangeRequest=this._onSelectionChangeRequest.event,this._asyncTriggerCut=this._register(new V.uC((()=>this._onCut.fire()),0)),this._asyncFocusGainWriteScreenReaderContent=this._register(new V.uC((()=>this.writeScreenReaderContent("asyncFocusGain")),0)),this._textAreaState=it.EMPTY,this._selectionChangeListener=null,this.writeScreenReaderContent("ctor"),this._hasFocus=!1,this._currentComposition=null;let o=null;this._register(this._textArea.onKeyDown((e=>{const t=new Xe.Z(e);(114===t.keyCode||this._currentComposition&&1===t.keyCode)&&t.stopPropagation(),t.equals(9)&&t.preventDefault(),o=t,this._onKeyDown.fire(t)}))),this._register(this._textArea.onKeyUp((e=>{const t=new Xe.Z(e);this._onKeyUp.fire(t)}))),this._register(this._textArea.onCompositionStart((e=>{const t=new st;if(this._currentComposition)this._currentComposition=t;else{if(this._currentComposition=t,2===this._OS&&o&&o.equals(114)&&this._textAreaState.selectionStart===this._textAreaState.selectionEnd&&this._textAreaState.selectionStart>0&&this._textAreaState.value.substr(this._textAreaState.selectionStart-1,1)===e.data&&("ArrowRight"===o.code||"ArrowLeft"===o.code))return t.handleCompositionUpdate("x"),void this._onCompositionStart.fire({data:e.data});this._browser.isAndroid,this._onCompositionStart.fire({data:e.data})}}))),this._register(this._textArea.onCompositionUpdate((e=>{const t=this._currentComposition;if(!t)return;if(this._browser.isAndroid){const t=it.readFromTextArea(this._textArea,this._textAreaState),i=it.deduceAndroidCompositionInput(this._textAreaState,t);return this._textAreaState=t,this._onType.fire(i),void this._onCompositionUpdate.fire(e)}const i=t.handleCompositionUpdate(e.data);this._textAreaState=it.readFromTextArea(this._textArea,this._textAreaState),this._onType.fire(i),this._onCompositionUpdate.fire(e)}))),this._register(this._textArea.onCompositionEnd((e=>{const t=this._currentComposition;if(!t)return;if(this._currentComposition=null,this._browser.isAndroid){const e=it.readFromTextArea(this._textArea,this._textAreaState),t=it.deduceAndroidCompositionInput(this._textAreaState,e);return this._textAreaState=e,this._onType.fire(t),void this._onCompositionEnd.fire()}const i=t.handleCompositionUpdate(e.data);this._textAreaState=it.readFromTextArea(this._textArea,this._textAreaState),this._onType.fire(i),this._onCompositionEnd.fire()}))),this._register(this._textArea.onInput((e=>{if(this._textArea.setIgnoreSelectionChangeTime("received input event"),this._currentComposition)return;const t=it.readFromTextArea(this._textArea,this._textAreaState),i=it.deduceInput(this._textAreaState,t,2===this._OS);(0!==i.replacePrevCharCnt||1!==i.text.length||!tt.pc(i.text.charCodeAt(0))&&127!==i.text.charCodeAt(0))&&(this._textAreaState=t,""===i.text&&0===i.replacePrevCharCnt&&0===i.replaceNextCharCnt&&0===i.positionDelta||this._onType.fire(i))}))),this._register(this._textArea.onCut((e=>{this._textArea.setIgnoreSelectionChangeTime("received cut event"),this._ensureClipboardGetsEditorSelection(e),this._asyncTriggerCut.schedule()}))),this._register(this._textArea.onCopy((e=>{this._ensureClipboardGetsEditorSelection(e)}))),this._register(this._textArea.onPaste((e=>{if(this._textArea.setIgnoreSelectionChangeTime("received paste event"),e.preventDefault(),!e.clipboardData)return;let[t,i]=at.getTextData(e.clipboardData);t&&(i=i||ot.INSTANCE.get(t),this._onPaste.fire({text:t,metadata:i}))}))),this._register(this._textArea.onFocus((()=>{const e=this._hasFocus;this._setHasFocus(!0),this._browser.isSafari&&!e&&this._hasFocus&&this._asyncFocusGainWriteScreenReaderContent.schedule()}))),this._register(this._textArea.onBlur((()=>{this._currentComposition&&(this._currentComposition=null,this.writeScreenReaderContent("blurWithoutCompositionEnd"),this._onCompositionEnd.fire()),this._setHasFocus(!1)}))),this._register(this._textArea.onSyntheticTap((()=>{this._browser.isAndroid&&this._currentComposition&&(this._currentComposition=null,this.writeScreenReaderContent("tapWithoutCompositionEnd"),this._onCompositionEnd.fire())})))}_installSelectionChangeListener(){let e=0;return d.ko(document,"selectionchange",(t=>{if(Je.onSelectionChange(),!this._hasFocus)return;if(this._currentComposition)return;if(!this._browser.isChrome)return;const i=Date.now(),n=i-e;if(e=i,n<5)return;const o=i-this._textArea.getIgnoreSelectionChangeTime();if(this._textArea.resetSelectionChangeTime(),o<100)return;if(!this._textAreaState.selection)return;const s=this._textArea.getValue();if(this._textAreaState.value!==s)return;const r=this._textArea.getSelectionStart(),a=this._textArea.getSelectionEnd();if(this._textAreaState.selectionStart===r&&this._textAreaState.selectionEnd===a)return;const l=this._textAreaState.deduceEditorPosition(r),h=this._host.deduceModelPosition(l[0],l[1],l[2]),c=this._textAreaState.deduceEditorPosition(a),d=this._host.deduceModelPosition(c[0],c[1],c[2]),u=new P.L(h.lineNumber,h.column,d.lineNumber,d.column);this._onSelectionChangeRequest.fire(u)}))}dispose(){super.dispose(),this._selectionChangeListener&&(this._selectionChangeListener.dispose(),this._selectionChangeListener=null)}focusTextArea(){this._setHasFocus(!0),this.refreshFocusState()}isFocused(){return this._hasFocus}refreshFocusState(){this._setHasFocus(this._textArea.hasFocus())}_setHasFocus(e){this._hasFocus!==e&&(this._hasFocus=e,this._selectionChangeListener&&(this._selectionChangeListener.dispose(),this._selectionChangeListener=null),this._hasFocus&&(this._selectionChangeListener=this._installSelectionChangeListener()),this._hasFocus&&this.writeScreenReaderContent("focusgain"),this._hasFocus?this._onFocus.fire():this._onBlur.fire())}_setAndWriteTextAreaState(e,t){this._hasFocus||(t=t.collapseSelection()),t.writeToTextArea(e,this._textArea,this._hasFocus),this._textAreaState=t}writeScreenReaderContent(e){this._currentComposition||this._setAndWriteTextAreaState(e,this._host.getScreenReaderContent())}_ensureClipboardGetsEditorSelection(e){const t=this._host.getDataToCopy(),i={version:1,isFromEmptySelection:t.isFromEmptySelection,multicursorText:t.multicursorText,mode:t.mode};ot.INSTANCE.set(this._browser.isFirefox?t.text.replace(/\r\n/g,"\n"):t.text,i),e.preventDefault(),e.clipboardData&&at.setTextData(e.clipboardData,t.text,t.html,i)}}class at{static getTextData(e){const t=e.getData(et.K.text);let i=null;const n=e.getData("vscode-editor-data");if("string"==typeof n)try{i=JSON.parse(n),1!==i.version&&(i=null)}catch(e){}return 0===t.length&&null===i&&e.files.length>0?[Array.prototype.slice.call(e.files,0).map((e=>e.name)).join("\n"),null]:[t,i]}static setTextData(e,t,i,n){e.setData(et.K.text,t),"string"==typeof i&&e.setData("text/html",i),e.setData("vscode-editor-data",JSON.stringify(n))}}class lt extends m.jG{constructor(e){super(),this._actual=e,this.onKeyDown=this._register(new $e.f(this._actual,"keydown")).event,this.onKeyUp=this._register(new $e.f(this._actual,"keyup")).event,this.onCompositionStart=this._register(new $e.f(this._actual,"compositionstart")).event,this.onCompositionUpdate=this._register(new $e.f(this._actual,"compositionupdate")).event,this.onCompositionEnd=this._register(new $e.f(this._actual,"compositionend")).event,this.onBeforeInput=this._register(new $e.f(this._actual,"beforeinput")).event,this.onInput=this._register(new $e.f(this._actual,"input")).event,this.onCut=this._register(new $e.f(this._actual,"cut")).event,this.onCopy=this._register(new $e.f(this._actual,"copy")).event,this.onPaste=this._register(new $e.f(this._actual,"paste")).event,this.onFocus=this._register(new $e.f(this._actual,"focus")).event,this.onBlur=this._register(new $e.f(this._actual,"blur")).event,this._onSyntheticTap=this._register(new g.vl),this.onSyntheticTap=this._onSyntheticTap.event,this._ignoreSelectionChangeTime=0,this._register(this.onKeyDown((()=>Je.onKeyDown()))),this._register(this.onBeforeInput((()=>Je.onBeforeInput()))),this._register(this.onInput((()=>Je.onInput()))),this._register(this.onKeyUp((()=>Je.onKeyUp()))),this._register(d.ko(this._actual,Ze.Tap,(()=>this._onSyntheticTap.fire())))}hasFocus(){const e=d.jG(this._actual);return e?e.activeElement===this._actual:!!d.qD(this._actual)&&document.activeElement===this._actual}setIgnoreSelectionChangeTime(e){this._ignoreSelectionChangeTime=Date.now()}getIgnoreSelectionChangeTime(){return this._ignoreSelectionChangeTime}resetSelectionChangeTime(){this._ignoreSelectionChangeTime=0}getValue(){return this._actual.value}setValue(e,t){const i=this._actual;i.value!==t&&(this.setIgnoreSelectionChangeTime("setValue"),i.value=t)}getSelectionStart(){return"backward"===this._actual.selectionDirection?this._actual.selectionEnd:this._actual.selectionStart}getSelectionEnd(){return"backward"===this._actual.selectionDirection?this._actual.selectionStart:this._actual.selectionEnd}setSelectionRange(e,t,i){const n=this._actual;let o=null;const s=d.jG(n);o=s?s.activeElement:document.activeElement;const r=o===n,a=n.selectionStart,l=n.selectionEnd;if(r&&a===t&&l===i)f.isFirefox&&window.parent!==window&&n.focus();else{if(r)return this.setIgnoreSelectionChangeTime("setSelectionRange"),n.setSelectionRange(t,i),void(f.isFirefox&&window.parent!==window&&n.focus());try{const e=d.zK(n);this.setIgnoreSelectionChangeTime("setSelectionRange"),n.focus(),n.setSelectionRange(t,i),d.wk(n,e)}catch(e){}}}}class ht extends Ue{constructor(e,t,i){super(e,t,i),this._register(Q.q.addTarget(this.viewHelper.linesContentDomNode)),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Tap,(e=>this.onTap(e)))),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Change,(e=>this.onChange(e)))),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Contextmenu,(e=>this._onContextMenu(new $(e,!1,this.viewHelper.viewDomNode),!1)))),this._lastPointerType="mouse",this._register(d.ko(this.viewHelper.linesContentDomNode,"pointerdown",(e=>{const t=e.pointerType;this._lastPointerType="mouse"!==t?"touch"===t?"touch":"pen":"mouse"})));const n=new Z(this.viewHelper.viewDomNode);this._register(n.onPointerMove(this.viewHelper.viewDomNode,(e=>this._onMouseMove(e)))),this._register(n.onPointerUp(this.viewHelper.viewDomNode,(e=>this._onMouseUp(e)))),this._register(n.onPointerLeave(this.viewHelper.viewDomNode,(e=>this._onMouseLeave(e)))),this._register(n.onPointerDown(this.viewHelper.viewDomNode,((e,t)=>this._onMouseDown(e,t))))}onTap(e){if(!e.initialTarget||!this.viewHelper.linesContentDomNode.contains(e.initialTarget))return;e.preventDefault(),this.viewHelper.focusTextArea();const t=this._createMouseTarget(new $(e,!1,this.viewHelper.viewDomNode),!1);t.position&&this.viewController.dispatchMouse({position:t.position,mouseColumn:t.position.column,startedOnLineNumbers:!1,revealType:1,mouseDownCount:e.tapCount,inSelectionMode:!1,altKey:!1,ctrlKey:!1,metaKey:!1,shiftKey:!1,leftButton:!1,middleButton:!1,onInjectedText:6===t.type&&null!==t.detail.injectedText})}onChange(e){"touch"===this._lastPointerType&&this._context.viewModel.viewLayout.deltaScrollNow(-e.translationX,-e.translationY)}_onMouseDown(e,t){"touch"!==e.browserEvent.pointerType&&super._onMouseDown(e,t)}}class ct extends Ue{constructor(e,t,i){super(e,t,i),this._register(Q.q.addTarget(this.viewHelper.linesContentDomNode)),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Tap,(e=>this.onTap(e)))),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Change,(e=>this.onChange(e)))),this._register(d.ko(this.viewHelper.linesContentDomNode,Q.B.Contextmenu,(e=>this._onContextMenu(new $(e,!1,this.viewHelper.viewDomNode),!1))))}onTap(e){e.preventDefault(),this.viewHelper.focusTextArea();const t=this._createMouseTarget(new $(e,!1,this.viewHelper.viewDomNode),!1);if(t.position){const e=document.createEvent("CustomEvent");e.initEvent(Ze.Tap,!1,!0),this.viewHelper.dispatchTextAreaEvent(e),this.viewController.moveTo(t.position,1)}}onChange(e){this._context.viewModel.viewLayout.deltaScrollNow(-e.translationX,-e.translationY)}}class dt extends m.jG{constructor(e,t,i){super(),w.un&&qe.e.pointerEvents?this.handler=this._register(new ht(e,t,i)):window.TouchEvent?this.handler=this._register(new ct(e,t,i)):this.handler=this._register(new Ue(e,t,i))}getTargetAtClientPoint(e,t){return this.handler.getTargetAtClientPoint(e,t)}}var ut=i(7078);l()(ut.A,{insert:"head",singleton:!1}),ut.A.locals;var gt=i(4787),mt=i(4602);l()(mt.A,{insert:"head",singleton:!1}),mt.A.locals;class pt extends oe{}var ft=i(2186),At=i(4309);class _t extends pt{constructor(e){super(),this._context=e,this._readConfig(),this._lastCursorModelPosition=new De.y(1,1),this._renderResult=null,this._activeLineNumber=1,this._context.addEventHandler(this)}_readConfig(){const e=this._context.configuration.options;this._lineHeight=e.get(64);const t=e.get(65);this._renderLineNumbers=t.renderType,this._renderCustomLineNumbers=t.renderFn,this._renderFinalNewline=e.get(91);const i=e.get(140);this._lineNumbersLeft=i.lineNumbersLeft,this._lineNumbersWidth=i.lineNumbersWidth}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){return this._readConfig(),!0}onCursorStateChanged(e){const t=e.selections[0].getPosition();this._lastCursorModelPosition=this._context.viewModel.coordinatesConverter.convertViewPositionToModelPosition(t);let i=!1;return this._activeLineNumber!==t.lineNumber&&(this._activeLineNumber=t.lineNumber,i=!0),2!==this._renderLineNumbers&&3!==this._renderLineNumbers||(i=!0),i}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}_getLineRenderLineNumber(e){const t=this._context.viewModel.coordinatesConverter.convertViewPositionToModelPosition(new De.y(e,1));if(1!==t.column)return"";const i=t.lineNumber;if(this._renderCustomLineNumbers)return this._renderCustomLineNumbers(i);if(2===this._renderLineNumbers){const e=Math.abs(this._lastCursorModelPosition.lineNumber-i);return 0===e?'<span class="relative-current-line-number">'+i+"</span>":String(e)}return 3===this._renderLineNumbers?this._lastCursorModelPosition.lineNumber===i||i%10==0?String(i):"":String(i)}prepareRender(e){if(0===this._renderLineNumbers)return void(this._renderResult=null);const t=w.j9?this._lineHeight%2==0?" lh-even":" lh-odd":"",i=e.visibleRange.startLineNumber,n=e.visibleRange.endLineNumber,o=this._context.viewModel.getLineCount(),s=[];for(let e=i;e<=n;e++){const n=e-i,r=this._getLineRenderLineNumber(e);if(!r){s[n]="";continue}let a="";if(e===o&&0===this._context.viewModel.getLineLength(e)){if("off"===this._renderFinalNewline){s[n]="";continue}"dimmed"===this._renderFinalNewline&&(a=" dimmed-line-number")}e===this._activeLineNumber&&(a=" active-line-number"),s[n]=`<div class="${_t.CLASS_NAME}${t}${a}" style="left:${this._lineNumbersLeft}px;width:${this._lineNumbersWidth}px;">${r}</div>`}this._renderResult=s}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}_t.CLASS_NAME="line-numbers",(0,ft.zy)(((e,t)=>{const i=e.getColor(At.Qt),n=e.getColor(At.JB);n?t.addRule(`.monaco-editor .line-numbers.dimmed-line-number { color: ${n}; }`):i&&t.addRule(`.monaco-editor .line-numbers.dimmed-line-number { color: ${i.transparent(.4)}; }`)}));var wt=i(200);l()(wt.A,{insert:"head",singleton:!1}),wt.A.locals;class bt extends se{constructor(e){super(e);const t=this._context.configuration.options,i=t.get(140);this._canUseLayerHinting=!t.get(30),this._contentLeft=i.contentLeft,this._glyphMarginLeft=i.glyphMarginLeft,this._glyphMarginWidth=i.glyphMarginWidth,this._domNode=(0,z.Z)(document.createElement("div")),this._domNode.setClassName(bt.OUTER_CLASS_NAME),this._domNode.setPosition("absolute"),this._domNode.setAttribute("role","presentation"),this._domNode.setAttribute("aria-hidden","true"),this._glyphMarginBackgroundDomNode=(0,z.Z)(document.createElement("div")),this._glyphMarginBackgroundDomNode.setClassName(bt.CLASS_NAME),this._domNode.appendChild(this._glyphMarginBackgroundDomNode)}dispose(){super.dispose()}getDomNode(){return this._domNode}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(140);return this._canUseLayerHinting=!t.get(30),this._contentLeft=i.contentLeft,this._glyphMarginLeft=i.glyphMarginLeft,this._glyphMarginWidth=i.glyphMarginWidth,!0}onScrollChanged(e){return super.onScrollChanged(e)||e.scrollTopChanged}prepareRender(e){}render(e){this._domNode.setLayerHinting(this._canUseLayerHinting),this._domNode.setContain("strict");const t=e.scrollTop-e.bigNumbersDelta;this._domNode.setTop(-t);const i=Math.min(e.scrollHeight,1e6);this._domNode.setHeight(i),this._domNode.setWidth(this._contentLeft),this._glyphMarginBackgroundDomNode.setLeft(this._glyphMarginLeft),this._glyphMarginBackgroundDomNode.setWidth(this._glyphMarginWidth),this._glyphMarginBackgroundDomNode.setHeight(i)}}bt.CLASS_NAME="glyph-margin",bt.OUTER_CLASS_NAME="margin";var vt=i(6516),Ct=i(4841),yt=i(3666),St=i(7863),kt=i(6037);class Et{constructor(e,t,i,n,o){this._context=e,this.modelLineNumber=t,this.distanceToModelLineStart=i,this.widthOfHiddenLineTextBefore=n,this.distanceToModelLineEnd=o,this._visibleTextAreaBrand=void 0,this.startPosition=null,this.endPosition=null,this.visibleTextareaStart=null,this.visibleTextareaEnd=null,this._previousPresentation=null}prepareRender(e){const t=new De.y(this.modelLineNumber,this.distanceToModelLineStart+1),i=new De.y(this.modelLineNumber,this._context.viewModel.model.getLineMaxColumn(this.modelLineNumber)-this.distanceToModelLineEnd);this.startPosition=this._context.viewModel.coordinatesConverter.convertModelPositionToViewPosition(t),this.endPosition=this._context.viewModel.coordinatesConverter.convertModelPositionToViewPosition(i),this.startPosition.lineNumber===this.endPosition.lineNumber?(this.visibleTextareaStart=e.visibleRangeForPosition(this.startPosition),this.visibleTextareaEnd=e.visibleRangeForPosition(this.endPosition)):(this.visibleTextareaStart=null,this.visibleTextareaEnd=null)}definePresentation(e){return this._previousPresentation||(this._previousPresentation=e||{foreground:1,italic:!1,bold:!1,underline:!1,strikethrough:!1}),this._previousPresentation}}const Dt=f.isFirefox;class xt extends se{constructor(e,t,i){super(e),this._primaryCursorPosition=new De.y(1,1),this._primaryCursorVisibleRange=null,this._viewController=t,this._visibleRangeProvider=i,this._scrollLeft=0,this._scrollTop=0;const n=this._context.configuration.options,o=n.get(140);this._setAccessibilityOptions(n),this._contentLeft=o.contentLeft,this._contentWidth=o.contentWidth,this._contentHeight=o.height,this._fontInfo=n.get(48),this._lineHeight=n.get(64),this._emptySelectionClipboard=n.get(35),this._copyWithSyntaxHighlighting=n.get(23),this._visibleTextArea=null,this._selections=[new P.L(1,1,1,1)],this._modelSelections=[new P.L(1,1,1,1)],this._lastRenderPosition=null,this.textArea=(0,z.Z)(document.createElement("textarea")),re.write(this.textArea,6),this.textArea.setClassName(`inputarea ${Ct.S}`),this.textArea.setAttribute("wrap",this._textAreaWrapping&&!this._visibleTextArea?"on":"off");const{tabSize:s}=this._context.viewModel.model.getOptions();this.textArea.domNode.style.tabSize=s*this._fontInfo.spaceWidth+"px",this.textArea.setAttribute("autocorrect","off"),this.textArea.setAttribute("autocapitalize","off"),this.textArea.setAttribute("autocomplete","off"),this.textArea.setAttribute("spellcheck","false"),this.textArea.setAttribute("aria-label",this._getAriaLabel(n)),this.textArea.setAttribute("tabindex",String(n.get(120))),this.textArea.setAttribute("role","textbox"),this.textArea.setAttribute("aria-roledescription",c.kg("editor","editor")),this.textArea.setAttribute("aria-multiline","true"),this.textArea.setAttribute("aria-haspopup","false"),this.textArea.setAttribute("aria-autocomplete","both"),this._ensureReadOnlyAttribute(),this.textAreaCover=(0,z.Z)(document.createElement("div")),this.textAreaCover.setPosition("absolute");const r={getLineCount:()=>this._context.viewModel.getLineCount(),getLineMaxColumn:e=>this._context.viewModel.getLineMaxColumn(e),getValueInRange:(e,t)=>this._context.viewModel.getValueInRange(e,t),getValueLengthInRange:(e,t)=>this._context.viewModel.getValueLengthInRange(e,t),modifyPosition:(e,t)=>this._context.viewModel.modifyPosition(e,t)},a={getDataToCopy:()=>{const e=this._context.viewModel.getPlainTextToCopy(this._modelSelections,this._emptySelectionClipboard,w.uF),t=this._context.viewModel.model.getEOL(),i=this._emptySelectionClipboard&&1===this._modelSelections.length&&this._modelSelections[0].isEmpty(),n=Array.isArray(e)?e:null,o=Array.isArray(e)?e.join(t):e;let s,r=null;if(this._copyWithSyntaxHighlighting&&o.length<65536){const e=this._context.viewModel.getRichTextToCopy(this._modelSelections,this._emptySelectionClipboard);e&&(s=e.html,r=e.mode)}return{isFromEmptySelection:i,multicursorText:n,text:o,html:s,mode:r}},getScreenReaderContent:()=>{if(1===this._accessibilitySupport){const e=this._selections[0];if(w.zx&&e.isEmpty()){const t=e.getStartPosition();let i=this._getWordBeforePosition(t);if(0===i.length&&(i=this._getCharacterBeforePosition(t)),i.length>0)return new it(i,i.length,i.length,xe.Q.fromPositions(t),0)}const t=500;if(w.zx&&!e.isEmpty()&&r.getValueLengthInRange(e,0)<t){const t=r.getValueInRange(e,0);return new it(t,0,t.length,e,0)}if(f.isSafari&&!e.isEmpty()){const e="vscode-placeholder";return new it(e,0,e.length,null,void 0)}return it.EMPTY}if(f.isAndroid){const e=this._selections[0];if(e.isEmpty()){const t=e.getStartPosition(),[i,n]=this._getAndroidWordAtPosition(t);if(i.length>0)return new it(i,n,n,xe.Q.fromPositions(t),0)}return it.EMPTY}return nt.fromEditorSelection(r,this._selections[0],this._accessibilityPageSize,0===this._accessibilitySupport)},deduceModelPosition:(e,t,i)=>this._context.viewModel.deduceModelPositionRelativeToViewPosition(e,t,i)},l=this._register(new lt(this.textArea.domNode));this._textAreaInput=this._register(new rt(a,l,w.OS,f)),this._register(this._textAreaInput.onKeyDown((e=>{this._viewController.emitKeyDown(e)}))),this._register(this._textAreaInput.onKeyUp((e=>{this._viewController.emitKeyUp(e)}))),this._register(this._textAreaInput.onPaste((e=>{let t=!1,i=null,n=null;e.metadata&&(t=this._emptySelectionClipboard&&!!e.metadata.isFromEmptySelection,i=void 0!==e.metadata.multicursorText?e.metadata.multicursorText:null,n=e.metadata.mode),this._viewController.paste(e.text,t,i,n)}))),this._register(this._textAreaInput.onCut((()=>{this._viewController.cut()}))),this._register(this._textAreaInput.onType((e=>{e.replacePrevCharCnt||e.replaceNextCharCnt||e.positionDelta?this._viewController.compositionType(e.text,e.replacePrevCharCnt,e.replaceNextCharCnt,e.positionDelta):this._viewController.type(e.text)}))),this._register(this._textAreaInput.onSelectionChangeRequest((e=>{this._viewController.setSelection(e)}))),this._register(this._textAreaInput.onCompositionStart((e=>{const t=this.textArea.domNode,i=this._modelSelections[0],{distanceToModelLineStart:n,widthOfHiddenTextBefore:o}=(()=>{const e=t.value.substring(0,Math.min(t.selectionStart,t.selectionEnd)),n=e.lastIndexOf("\n"),o=e.substring(n+1),s=o.lastIndexOf("\t"),r=o.length-s-1,a=i.getStartPosition(),l=Math.min(a.column-1,r),h=a.column-1-l,c=o.substring(0,o.length-l),{tabSize:d}=this._context.viewModel.model.getOptions(),u=function(e,t,i){if(0===e.length)return 0;const n=document.createElement("div");n.style.position="absolute",n.style.top="-50000px",n.style.width="50000px";const o=document.createElement("span");(0,gt.M)(o,t),o.style.whiteSpace="pre",o.style.tabSize=i*t.spaceWidth+"px",o.append(e),n.appendChild(o),document.body.appendChild(n);const s=o.offsetWidth;return document.body.removeChild(n),s}(c,this._fontInfo,d);return{distanceToModelLineStart:h,widthOfHiddenTextBefore:u}})(),{distanceToModelLineEnd:s}=(()=>{const e=t.value.substring(Math.max(t.selectionStart,t.selectionEnd)),n=e.indexOf("\n"),o=-1===n?e:e.substring(0,n),s=o.indexOf("\t"),r=-1===s?o.length:o.length-s-1,a=i.getEndPosition(),l=Math.min(this._context.viewModel.model.getLineMaxColumn(a.lineNumber)-a.column,r);return{distanceToModelLineEnd:this._context.viewModel.model.getLineMaxColumn(a.lineNumber)-a.column-l}})();this._context.viewModel.revealRange("keyboard",!0,xe.Q.fromPositions(this._selections[0].getStartPosition()),0,1),this._visibleTextArea=new Et(this._context,i.startLineNumber,n,o,s),this.textArea.setAttribute("wrap",this._textAreaWrapping&&!this._visibleTextArea?"on":"off"),this._visibleTextArea.prepareRender(this._visibleRangeProvider),this._render(),this.textArea.setClassName(`inputarea ${Ct.S} ime-input`),this._viewController.compositionStart(),this._context.viewModel.onCompositionStart()}))),this._register(this._textAreaInput.onCompositionUpdate((e=>{this._visibleTextArea&&(this._visibleTextArea.prepareRender(this._visibleRangeProvider),this._render())}))),this._register(this._textAreaInput.onCompositionEnd((()=>{this._visibleTextArea=null,this.textArea.setAttribute("wrap",this._textAreaWrapping&&!this._visibleTextArea?"on":"off"),this._render(),this.textArea.setClassName(`inputarea ${Ct.S}`),this._viewController.compositionEnd(),this._context.viewModel.onCompositionEnd()}))),this._register(this._textAreaInput.onFocus((()=>{this._context.viewModel.setHasFocus(!0)}))),this._register(this._textAreaInput.onBlur((()=>{this._context.viewModel.setHasFocus(!1)}))),this._register(kt.M.onDidChange((()=>{this._ensureReadOnlyAttribute()})))}writeScreenReaderContent(e){this._textAreaInput.writeScreenReaderContent(e)}dispose(){super.dispose()}_getAndroidWordAtPosition(e){const t=this._context.viewModel.getLineContent(e.lineNumber),i=(0,vt.i)('`~!@#$%^&*()-=+[{]}\\|;:",.<>/?');let n=!0,o=e.column,s=!0,r=e.column,a=0;for(;a<50&&(n||s);){if(n&&o<=1&&(n=!1),n){const e=t.charCodeAt(o-2);0!==i.get(e)?n=!1:o--}if(s&&r>t.length&&(s=!1),s){const e=t.charCodeAt(r-1);0!==i.get(e)?s=!1:r++}a++}return[t.substring(o-1,r-1),e.column-o]}_getWordBeforePosition(e){const t=this._context.viewModel.getLineContent(e.lineNumber),i=(0,vt.i)(this._context.configuration.options.get(126));let n=e.column,o=0;for(;n>1;){const s=t.charCodeAt(n-2);if(0!==i.get(s)||o>50)return t.substring(n-1,e.column-1);o++,n--}return t.substring(0,e.column-1)}_getCharacterBeforePosition(e){if(e.column>1){const t=this._context.viewModel.getLineContent(e.lineNumber).charAt(e.column-2);if(!tt.pc(t.charCodeAt(0)))return t}return""}_getAriaLabel(e){return 1===e.get(2)?c.kg("accessibilityOffAriaLabel","The editor is not accessible at this time. Press {0} for options.",w.j9?"Shift+Alt+F1":"Alt+F1"):e.get(4)}_setAccessibilityOptions(e){this._accessibilitySupport=e.get(2);const t=e.get(3);2===this._accessibilitySupport&&t===D.qB.accessibilityPageSize.defaultValue?this._accessibilityPageSize=500:this._accessibilityPageSize=t;const i=e.get(140).wrappingColumn;if(-1!==i&&1!==this._accessibilitySupport){const t=e.get(48);this._textAreaWrapping=!0,this._textAreaWidth=Math.round(i*t.typicalHalfwidthCharacterWidth)}else this._textAreaWrapping=!1,this._textAreaWidth=Dt?0:1}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(140);this._setAccessibilityOptions(t),this._contentLeft=i.contentLeft,this._contentWidth=i.contentWidth,this._contentHeight=i.height,this._fontInfo=t.get(48),this._lineHeight=t.get(64),this._emptySelectionClipboard=t.get(35),this._copyWithSyntaxHighlighting=t.get(23),this.textArea.setAttribute("wrap",this._textAreaWrapping&&!this._visibleTextArea?"on":"off");const{tabSize:n}=this._context.viewModel.model.getOptions();return this.textArea.domNode.style.tabSize=n*this._fontInfo.spaceWidth+"px",this.textArea.setAttribute("aria-label",this._getAriaLabel(t)),this.textArea.setAttribute("tabindex",String(t.get(120))),(e.hasChanged(32)||e.hasChanged(88))&&this._ensureReadOnlyAttribute(),e.hasChanged(2)&&this._textAreaInput.writeScreenReaderContent("strategy changed"),!0}onCursorStateChanged(e){return this._selections=e.selections.slice(0),this._modelSelections=e.modelSelections.slice(0),this._textAreaInput.writeScreenReaderContent("selection changed"),!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return this._scrollLeft=e.scrollLeft,this._scrollTop=e.scrollTop,!0}onZonesChanged(e){return!0}isFocused(){return this._textAreaInput.isFocused()}focusTextArea(){this._textAreaInput.focusTextArea()}getLastRenderData(){return this._lastRenderPosition}setAriaOptions(e){e.activeDescendant?(this.textArea.setAttribute("aria-haspopup","true"),this.textArea.setAttribute("aria-autocomplete","list"),this.textArea.setAttribute("aria-activedescendant",e.activeDescendant)):(this.textArea.setAttribute("aria-haspopup","false"),this.textArea.setAttribute("aria-autocomplete","both"),this.textArea.removeAttribute("aria-activedescendant")),e.role&&this.textArea.setAttribute("role",e.role)}_ensureReadOnlyAttribute(){const e=this._context.configuration.options;!kt.M.enabled||e.get(32)&&e.get(88)?this.textArea.setAttribute("readonly","true"):this.textArea.removeAttribute("readonly")}prepareRender(e){var t;this._primaryCursorPosition=new De.y(this._selections[0].positionLineNumber,this._selections[0].positionColumn),this._primaryCursorVisibleRange=e.visibleRangeForPosition(this._primaryCursorPosition),null===(t=this._visibleTextArea)||void 0===t||t.prepareRender(e)}render(e){this._textAreaInput.writeScreenReaderContent("render"),this._render()}_render(){var e;if(this._visibleTextArea){const e=this._visibleTextArea.visibleTextareaStart,t=this._visibleTextArea.visibleTextareaEnd,i=this._visibleTextArea.startPosition,n=this._visibleTextArea.endPosition;if(i&&n&&e&&t&&t.left>=this._scrollLeft&&e.left<=this._scrollLeft+this._contentWidth){const o=this._context.viewLayout.getVerticalOffsetForLineNumber(this._primaryCursorPosition.lineNumber)-this._scrollTop,s=this._newlinecount(this.textArea.domNode.value.substr(0,this.textArea.domNode.selectionStart));let r=this._visibleTextArea.widthOfHiddenLineTextBefore,a=this._contentLeft+e.left-this._scrollLeft,l=t.left-e.left+1;if(a<this._contentLeft){const e=this._contentLeft-a;a+=e,r+=e,l-=e}l>this._contentWidth&&(l=this._contentWidth);const h=this._context.viewModel.getViewLineData(i.lineNumber),c=h.tokens.findTokenIndexAtOffset(i.column-1),d=c===h.tokens.findTokenIndexAtOffset(n.column-1),u=this._visibleTextArea.definePresentation(d?h.tokens.getPresentation(c):null);this.textArea.domNode.scrollTop=s*this._lineHeight,this.textArea.domNode.scrollLeft=r,this._doRender({lastRenderPosition:null,top:o,left:a,width:l,height:this._lineHeight,useCover:!1,color:(yt.dG.getColorMap()||[])[u.foreground],italic:u.italic,bold:u.bold,underline:u.underline,strikethrough:u.strikethrough})}return}if(!this._primaryCursorVisibleRange)return void this._renderAtTopLeft();const t=this._contentLeft+this._primaryCursorVisibleRange.left-this._scrollLeft;if(t<this._contentLeft||t>this._contentLeft+this._contentWidth)return void this._renderAtTopLeft();const i=this._context.viewLayout.getVerticalOffsetForLineNumber(this._selections[0].positionLineNumber)-this._scrollTop;if(i<0||i>this._contentHeight)this._renderAtTopLeft();else if(w.zx){this._doRender({lastRenderPosition:this._primaryCursorPosition,top:i,left:this._textAreaWrapping?this._contentLeft:t,width:this._textAreaWidth,height:this._lineHeight,useCover:!1}),this.textArea.domNode.scrollLeft=this._primaryCursorVisibleRange.left;const n=null!==(e=this._textAreaInput.textAreaState.newlineCountBeforeSelection)&&void 0!==e?e:this._newlinecount(this.textArea.domNode.value.substr(0,this.textArea.domNode.selectionStart));this.textArea.domNode.scrollTop=n*this._lineHeight}else this._doRender({lastRenderPosition:this._primaryCursorPosition,top:i,left:this._textAreaWrapping?this._contentLeft:t,width:this._textAreaWidth,height:Dt?0:1,useCover:!1})}_newlinecount(e){let t=0,i=-1;for(;i=e.indexOf("\n",i+1),-1!==i;)t++;return t}_renderAtTopLeft(){this._doRender({lastRenderPosition:null,top:0,left:0,width:this._textAreaWidth,height:Dt?0:1,useCover:!0})}_doRender(e){this._lastRenderPosition=e.lastRenderPosition;const t=this.textArea,i=this.textAreaCover;(0,gt.M)(t,this._fontInfo),t.setTop(e.top),t.setLeft(e.left),t.setWidth(e.width),t.setHeight(e.height),t.setColor(e.color?St.Q1.Format.CSS.formatHex(e.color):""),t.setFontStyle(e.italic?"italic":""),e.bold&&t.setFontWeight("bold"),t.setTextDecoration(`${e.underline?" underline":""}${e.strikethrough?" line-through":""}`),i.setTop(e.useCover?e.top:0),i.setLeft(e.useCover?e.left:0),i.setWidth(e.useCover?e.width:0),i.setHeight(e.useCover?e.height:0);const n=this._context.configuration.options;n.get(55)?i.setClassName("monaco-editor-background textAreaCover "+bt.OUTER_CLASS_NAME):0!==n.get(65).renderType?i.setClassName("monaco-editor-background textAreaCover "+_t.CLASS_NAME):i.setClassName("monaco-editor-background textAreaCover")}}var Lt=i(2821),Mt=i(6413),It=i(4650),Bt=i(5317);const Nt=()=>!0,Tt=()=>!1,Ft=e=>" "===e||"\t"===e;class Rt{static shouldRecreate(e){return e.hasChanged(140)||e.hasChanged(126)||e.hasChanged(35)||e.hasChanged(74)||e.hasChanged(76)||e.hasChanged(77)||e.hasChanged(5)||e.hasChanged(9)||e.hasChanged(7)||e.hasChanged(8)||e.hasChanged(12)||e.hasChanged(124)||e.hasChanged(48)||e.hasChanged(88)}constructor(e,t,i,n){this.languageConfigurationService=n,this._cursorMoveConfigurationBrand=void 0,this._languageId=e;const o=i.options,s=o.get(140),r=o.get(48);this.readOnly=o.get(88),this.tabSize=t.tabSize,this.indentSize=t.indentSize,this.insertSpaces=t.insertSpaces,this.stickyTabStops=o.get(112),this.lineHeight=r.lineHeight,this.typicalHalfwidthCharacterWidth=r.typicalHalfwidthCharacterWidth,this.pageSize=Math.max(1,Math.floor(s.height/this.lineHeight)-2),this.useTabStops=o.get(124),this.wordSeparators=o.get(126),this.emptySelectionClipboard=o.get(35),this.copyWithSyntaxHighlighting=o.get(23),this.multiCursorMergeOverlapping=o.get(74),this.multiCursorPaste=o.get(76),this.multiCursorLimit=o.get(77),this.autoClosingBrackets=o.get(5),this.autoClosingQuotes=o.get(9),this.autoClosingDelete=o.get(7),this.autoClosingOvertype=o.get(8),this.autoSurround=o.get(12),this.autoIndent=o.get(10),this.surroundingPairs={},this._electricChars=null,this.shouldAutoCloseBefore={quote:this._getShouldAutoClose(e,this.autoClosingQuotes,!0),bracket:this._getShouldAutoClose(e,this.autoClosingBrackets,!1)},this.autoClosingPairs=this.languageConfigurationService.getLanguageConfiguration(e).getAutoClosingPairs();const a=this.languageConfigurationService.getLanguageConfiguration(e).getSurroundingPairs();if(a)for(const e of a)this.surroundingPairs[e.open]=e.close}get electricChars(){var e;if(!this._electricChars){this._electricChars={};const t=null===(e=this.languageConfigurationService.getLanguageConfiguration(this._languageId).electricCharacter)||void 0===e?void 0:e.getElectricCharacters();if(t)for(const e of t)this._electricChars[e]=!0}return this._electricChars}onElectricCharacter(e,t,i){const n=(0,It.BQ)(t,i-1),o=this.languageConfigurationService.getLanguageConfiguration(n.languageId).electricCharacter;return o?o.onElectricCharacter(e,n,i-n.firstCharOffset):null}normalizeIndentation(e){return(0,Bt.P)(e,this.indentSize,this.insertSpaces)}_getShouldAutoClose(e,t,i){switch(t){case"beforeWhitespace":return Ft;case"languageDefined":return this._getLanguageDefinedShouldAutoClose(e,i);case"always":return Nt;case"never":return Tt}}_getLanguageDefinedShouldAutoClose(e,t){const i=this.languageConfigurationService.getLanguageConfiguration(e).getAutoCloseBeforeSet(t);return e=>-1!==i.indexOf(e)}visibleColumnFromColumn(e,t){return Le.A.visibleColumnFromColumn(e.getLineContent(t.lineNumber),t.column,this.tabSize)}columnFromVisibleColumn(e,t,i){const n=Le.A.columnFromVisibleColumn(e.getLineContent(t),i,this.tabSize),o=e.getLineMinColumn(t);if(n<o)return o;const s=e.getLineMaxColumn(t);return n>s?s:n}}class Ot{static fromModelState(e){return new Pt(e)}static fromViewState(e){return new zt(e)}static fromModelSelection(e){const t=P.L.liftSelection(e),i=new Qt(xe.Q.fromPositions(t.getSelectionStart()),0,0,t.getPosition(),0);return Ot.fromModelState(i)}static fromModelSelections(e){const t=[];for(let i=0,n=e.length;i<n;i++)t[i]=this.fromModelSelection(e[i]);return t}constructor(e,t){this._cursorStateBrand=void 0,this.modelState=e,this.viewState=t}equals(e){return this.viewState.equals(e.viewState)&&this.modelState.equals(e.modelState)}}class Pt{constructor(e){this.modelState=e,this.viewState=null}}class zt{constructor(e){this.modelState=null,this.viewState=e}}class Qt{constructor(e,t,i,n,o){this.selectionStart=e,this.selectionStartKind=t,this.selectionStartLeftoverVisibleColumns=i,this.position=n,this.leftoverVisibleColumns=o,this._singleCursorStateBrand=void 0,this.selection=Qt._computeSelection(this.selectionStart,this.position)}equals(e){return this.selectionStartLeftoverVisibleColumns===e.selectionStartLeftoverVisibleColumns&&this.leftoverVisibleColumns===e.leftoverVisibleColumns&&this.selectionStartKind===e.selectionStartKind&&this.position.equals(e.position)&&this.selectionStart.equalsRange(e.selectionStart)}hasSelection(){return!this.selection.isEmpty()||!this.selectionStart.isEmpty()}move(e,t,i,n){return e?new Qt(this.selectionStart,this.selectionStartKind,this.selectionStartLeftoverVisibleColumns,new De.y(t,i),n):new Qt(new xe.Q(t,i,t,i),0,n,new De.y(t,i),n)}static _computeSelection(e,t){return e.isEmpty()||!t.isBeforeOrEqual(e.getStartPosition())?P.L.fromPositions(e.getStartPosition(),t):P.L.fromPositions(e.getEndPosition(),t)}}class Ht{constructor(e,t,i){this._editOperationResultBrand=void 0,this.type=e,this.commands=t,this.shouldPushStackElementBefore=i.shouldPushStackElementBefore,this.shouldPushStackElementAfter=i.shouldPushStackElementAfter}}function Wt(e){return"'"===e||'"'===e||"`"===e}class Vt{static columnSelect(e,t,i,n,o,s){const r=Math.abs(o-i)+1,a=i>o,l=n>s,h=n<s,c=[];for(let o=0;o<r;o++){const r=i+(a?-o:o),d=e.columnFromVisibleColumn(t,r,n),u=e.columnFromVisibleColumn(t,r,s),g=e.visibleColumnFromColumn(t,new De.y(r,d)),m=e.visibleColumnFromColumn(t,new De.y(r,u));if(h){if(g>s)continue;if(m<n)continue}if(l){if(m>n)continue;if(g<s)continue}c.push(new Qt(new xe.Q(r,d,r,d),0,0,new De.y(r,u),0))}if(0===c.length)for(let e=0;e<r;e++){const n=i+(a?-e:e),o=t.getLineMaxColumn(n);c.push(new Qt(new xe.Q(n,o,n,o),0,0,new De.y(n,o),0))}return{viewStates:c,reversed:a,fromLineNumber:i,fromVisualColumn:n,toLineNumber:o,toVisualColumn:s}}static columnSelectLeft(e,t,i){let n=i.toViewVisualColumn;return n>0&&n--,Vt.columnSelect(e,t,i.fromViewLineNumber,i.fromViewVisualColumn,i.toViewLineNumber,n)}static columnSelectRight(e,t,i){let n=0;const o=Math.min(i.fromViewLineNumber,i.toViewLineNumber),s=Math.max(i.fromViewLineNumber,i.toViewLineNumber);for(let i=o;i<=s;i++){const o=t.getLineMaxColumn(i),s=e.visibleColumnFromColumn(t,new De.y(i,o));n=Math.max(n,s)}let r=i.toViewVisualColumn;return r<n&&r++,this.columnSelect(e,t,i.fromViewLineNumber,i.fromViewVisualColumn,i.toViewLineNumber,r)}static columnSelectUp(e,t,i,n){const o=n?e.pageSize:1,s=Math.max(1,i.toViewLineNumber-o);return this.columnSelect(e,t,i.fromViewLineNumber,i.fromViewVisualColumn,s,i.toViewVisualColumn)}static columnSelectDown(e,t,i,n){const o=n?e.pageSize:1,s=Math.min(t.getLineCount(),i.toViewLineNumber+o);return this.columnSelect(e,t,i.fromViewLineNumber,i.fromViewVisualColumn,s,i.toViewVisualColumn)}}class Ut{constructor(e,t,i=!1){this._range=e,this._text=t,this.insertsAutoWhitespace=i}getEditOperations(e,t){t.addTrackedEditOperation(this._range,this._text)}computeCursorState(e,t){const i=t.getInverseEditOperations()[0].range;return P.L.fromPositions(i.getEndPosition())}}class jt{constructor(e,t,i=!1){this._range=e,this._text=t,this.insertsAutoWhitespace=i}getEditOperations(e,t){t.addTrackedEditOperation(this._range,this._text)}computeCursorState(e,t){const i=t.getInverseEditOperations()[0].range;return P.L.fromPositions(i.getStartPosition())}}class Gt{constructor(e,t,i,n,o=!1){this._range=e,this._text=t,this._columnDeltaOffset=n,this._lineNumberDeltaOffset=i,this.insertsAutoWhitespace=o}getEditOperations(e,t){t.addTrackedEditOperation(this._range,this._text)}computeCursorState(e,t){const i=t.getInverseEditOperations()[0].range;return P.L.fromPositions(i.getEndPosition().delta(this._lineNumberDeltaOffset,this._columnDeltaOffset))}}class Kt{constructor(e,t,i,n=!1){this._range=e,this._text=t,this._initialSelection=i,this._forceMoveMarkers=n,this._selectionId=null}getEditOperations(e,t){t.addTrackedEditOperation(this._range,this._text,this._forceMoveMarkers),this._selectionId=t.trackSelection(this._initialSelection)}computeCursorState(e,t){return t.getTrackedSelection(this._selectionId)}}class Yt{constructor(e,t,i){this._cursorPositionBrand=void 0,this.lineNumber=e,this.column=t,this.leftoverVisibleColumns=i}}class Jt{static leftPosition(e,t){if(t.column>e.getLineMinColumn(t.lineNumber))return t.delta(void 0,-tt.MV(e.getLineContent(t.lineNumber),t.column-1));if(t.lineNumber>1){const i=t.lineNumber-1;return new De.y(i,e.getLineMaxColumn(i))}return t}static leftPositionAtomicSoftTabs(e,t,i){if(t.column<=e.getLineIndentColumn(t.lineNumber)){const n=e.getLineMinColumn(t.lineNumber),o=e.getLineContent(t.lineNumber),s=Me.atomicPosition(o,t.column-1,i,0);if(-1!==s&&s+1>=n)return new De.y(t.lineNumber,s+1)}return this.leftPosition(e,t)}static left(e,t,i){const n=e.stickyTabStops?Jt.leftPositionAtomicSoftTabs(t,i,e.tabSize):Jt.leftPosition(t,i);return new Yt(n.lineNumber,n.column,0)}static moveLeft(e,t,i,n,o){let s,r;if(i.hasSelection()&&!n)s=i.selection.startLineNumber,r=i.selection.startColumn;else{const n=i.position.delta(void 0,-(o-1)),a=t.normalizePosition(Jt.clipPositionColumn(n,t),0),l=Jt.left(e,t,a);s=l.lineNumber,r=l.column}return i.move(n,s,r,0)}static clipPositionColumn(e,t){return new De.y(e.lineNumber,Jt.clipRange(e.column,t.getLineMinColumn(e.lineNumber),t.getLineMaxColumn(e.lineNumber)))}static clipRange(e,t,i){return e<t?t:e>i?i:e}static rightPosition(e,t,i){return i<e.getLineMaxColumn(t)?i+=tt.iy(e.getLineContent(t),i-1):t<e.getLineCount()&&(t+=1,i=e.getLineMinColumn(t)),new De.y(t,i)}static rightPositionAtomicSoftTabs(e,t,i,n,o){if(i<e.getLineIndentColumn(t)){const o=e.getLineContent(t),s=Me.atomicPosition(o,i-1,n,1);if(-1!==s)return new De.y(t,s+1)}return this.rightPosition(e,t,i)}static right(e,t,i){const n=e.stickyTabStops?Jt.rightPositionAtomicSoftTabs(t,i.lineNumber,i.column,e.tabSize,e.indentSize):Jt.rightPosition(t,i.lineNumber,i.column);return new Yt(n.lineNumber,n.column,0)}static moveRight(e,t,i,n,o){let s,r;if(i.hasSelection()&&!n)s=i.selection.endLineNumber,r=i.selection.endColumn;else{const n=i.position.delta(void 0,o-1),a=t.normalizePosition(Jt.clipPositionColumn(n,t),1),l=Jt.right(e,t,a);s=l.lineNumber,r=l.column}return i.move(n,s,r,0)}static vertical(e,t,i,n,o,s,r,a){const l=Le.A.visibleColumnFromColumn(t.getLineContent(i),n,e.tabSize)+o,h=t.getLineCount(),c=1===i&&1===n,d=i===h&&n===t.getLineMaxColumn(i),u=s<i?c:d;if((i=s)<1?(i=1,n=r?t.getLineMinColumn(i):Math.min(t.getLineMaxColumn(i),n)):i>h?(i=h,n=r?t.getLineMaxColumn(i):Math.min(t.getLineMaxColumn(i),n)):n=e.columnFromVisibleColumn(t,i,l),o=u?0:l-Le.A.visibleColumnFromColumn(t.getLineContent(i),n,e.tabSize),void 0!==a){const e=new De.y(i,n),s=t.normalizePosition(e,a);o+=n-s.column,i=s.lineNumber,n=s.column}return new Yt(i,n,o)}static down(e,t,i,n,o,s,r){return this.vertical(e,t,i,n,o,i+s,r,4)}static moveDown(e,t,i,n,o){let s,r;i.hasSelection()&&!n?(s=i.selection.endLineNumber,r=i.selection.endColumn):(s=i.position.lineNumber,r=i.position.column);const a=Jt.down(e,t,s,r,i.leftoverVisibleColumns,o,!0);return i.move(n,a.lineNumber,a.column,a.leftoverVisibleColumns)}static translateDown(e,t,i){const n=i.selection,o=Jt.down(e,t,n.selectionStartLineNumber,n.selectionStartColumn,i.selectionStartLeftoverVisibleColumns,1,!1),s=Jt.down(e,t,n.positionLineNumber,n.positionColumn,i.leftoverVisibleColumns,1,!1);return new Qt(new xe.Q(o.lineNumber,o.column,o.lineNumber,o.column),0,o.leftoverVisibleColumns,new De.y(s.lineNumber,s.column),s.leftoverVisibleColumns)}static up(e,t,i,n,o,s,r){return this.vertical(e,t,i,n,o,i-s,r,3)}static moveUp(e,t,i,n,o){let s,r;i.hasSelection()&&!n?(s=i.selection.startLineNumber,r=i.selection.startColumn):(s=i.position.lineNumber,r=i.position.column);const a=Jt.up(e,t,s,r,i.leftoverVisibleColumns,o,!0);return i.move(n,a.lineNumber,a.column,a.leftoverVisibleColumns)}static translateUp(e,t,i){const n=i.selection,o=Jt.up(e,t,n.selectionStartLineNumber,n.selectionStartColumn,i.selectionStartLeftoverVisibleColumns,1,!1),s=Jt.up(e,t,n.positionLineNumber,n.positionColumn,i.leftoverVisibleColumns,1,!1);return new Qt(new xe.Q(o.lineNumber,o.column,o.lineNumber,o.column),0,o.leftoverVisibleColumns,new De.y(s.lineNumber,s.column),s.leftoverVisibleColumns)}static _isBlankLine(e,t){return 0===e.getLineFirstNonWhitespaceColumn(t)}static moveToPrevBlankLine(e,t,i,n){let o=i.position.lineNumber;for(;o>1&&this._isBlankLine(t,o);)o--;for(;o>1&&!this._isBlankLine(t,o);)o--;return i.move(n,o,t.getLineMinColumn(o),0)}static moveToNextBlankLine(e,t,i,n){const o=t.getLineCount();let s=i.position.lineNumber;for(;s<o&&this._isBlankLine(t,s);)s++;for(;s<o&&!this._isBlankLine(t,s);)s++;return i.move(n,s,t.getLineMinColumn(s),0)}static moveToBeginningOfLine(e,t,i,n){const o=i.position.lineNumber,s=t.getLineMinColumn(o),r=t.getLineFirstNonWhitespaceColumn(o)||s;let a;return a=i.position.column===r?s:r,i.move(n,o,a,0)}static moveToEndOfLine(e,t,i,n,o){const s=i.position.lineNumber,r=t.getLineMaxColumn(s);return i.move(n,s,r,o?1073741824-r:0)}static moveToBeginningOfBuffer(e,t,i,n){return i.move(n,1,1,0)}static moveToEndOfBuffer(e,t,i,n){const o=t.getLineCount(),s=t.getLineMaxColumn(o);return i.move(n,o,s,0)}}class qt{static deleteRight(e,t,i,n){const o=[];let s=3!==e;for(let e=0,r=n.length;e<r;e++){const r=n[e];let a=r;if(a.isEmpty()){const e=r.getPosition(),n=Jt.right(t,i,e);a=new xe.Q(n.lineNumber,n.column,e.lineNumber,e.column)}a.isEmpty()?o[e]=null:(a.startLineNumber!==a.endLineNumber&&(s=!0),o[e]=new Ut(a,""))}return[s,o]}static isAutoClosingPairDelete(e,t,i,n,o,s,r){if("never"===t&&"never"===i)return!1;if("never"===e)return!1;for(let a=0,l=s.length;a<l;a++){const l=s[a],h=l.getPosition();if(!l.isEmpty())return!1;const c=o.getLineContent(h.lineNumber);if(h.column<2||h.column>=c.length+1)return!1;const d=c.charAt(h.column-2),u=n.get(d);if(!u)return!1;if(Wt(d)){if("never"===i)return!1}else if("never"===t)return!1;const g=c.charAt(h.column-1);let m=!1;for(const e of u)e.open===d&&e.close===g&&(m=!0);if(!m)return!1;if("auto"===e){let e=!1;for(let t=0,i=r.length;t<i;t++){const i=r[t];if(h.lineNumber===i.startLineNumber&&h.column===i.startColumn){e=!0;break}}if(!e)return!1}}return!0}static _runAutoClosingPairDelete(e,t,i){const n=[];for(let e=0,t=i.length;e<t;e++){const t=i[e].getPosition(),o=new xe.Q(t.lineNumber,t.column-1,t.lineNumber,t.column+1);n[e]=new Ut(o,"")}return[!0,n]}static deleteLeft(e,t,i,n,o){if(this.isAutoClosingPairDelete(t.autoClosingDelete,t.autoClosingBrackets,t.autoClosingQuotes,t.autoClosingPairs.autoClosingPairsOpenByEnd,i,n,o))return this._runAutoClosingPairDelete(t,i,n);const s=[];let r=2!==e;for(let e=0,o=n.length;e<o;e++){const o=qt.getDeleteRange(n[e],i,t);o.isEmpty()?s[e]=null:(o.startLineNumber!==o.endLineNumber&&(r=!0),s[e]=new Ut(o,""))}return[r,s]}static getDeleteRange(e,t,i){if(!e.isEmpty())return e;const n=e.getPosition();if(i.useTabStops&&n.column>1){const e=t.getLineContent(n.lineNumber),o=tt.HG(e),s=-1===o?e.length+1:o+1;if(n.column<=s){const e=i.visibleColumnFromColumn(t,n),o=Le.A.prevIndentTabStop(e,i.indentSize),s=i.columnFromVisibleColumn(t,n.lineNumber,o);return new xe.Q(n.lineNumber,s,n.lineNumber,n.column)}}return xe.Q.fromPositions(qt.getPositionAfterDeleteLeft(n,t),n)}static getPositionAfterDeleteLeft(e,t){if(e.column>1){const i=tt.Wd(e.column-1,t.getLineContent(e.lineNumber));return e.with(void 0,i+1)}if(e.lineNumber>1){const i=e.lineNumber-1;return new De.y(i,t.getLineMaxColumn(i))}return e}static cut(e,t,i){const n=[];let o=null;i.sort(((e,t)=>De.y.compare(e.getStartPosition(),t.getEndPosition())));for(let s=0,r=i.length;s<r;s++){const r=i[s];if(r.isEmpty())if(e.emptySelectionClipboard){const e=r.getPosition();let i,a,l,h;e.lineNumber<t.getLineCount()?(i=e.lineNumber,a=1,l=e.lineNumber+1,h=1):e.lineNumber>1&&(null==o?void 0:o.endLineNumber)!==e.lineNumber?(i=e.lineNumber-1,a=t.getLineMaxColumn(e.lineNumber-1),l=e.lineNumber,h=t.getLineMaxColumn(e.lineNumber)):(i=e.lineNumber,a=1,l=e.lineNumber,h=t.getLineMaxColumn(e.lineNumber));const c=new xe.Q(i,a,l,h);o=c,c.isEmpty()?n[s]=null:n[s]=new Ut(c,"")}else n[s]=null;else n[s]=new Ut(r,"")}return new Ht(0,n,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!0})}}class $t{static _createWord(e,t,i,n,o){return{start:n,end:o,wordType:t,nextCharClass:i}}static _findPreviousWordOnLine(e,t,i){const n=t.getLineContent(i.lineNumber);return this._doFindPreviousWordOnLine(n,e,i)}static _doFindPreviousWordOnLine(e,t,i){let n=0;for(let o=i.column-2;o>=0;o--){const i=e.charCodeAt(o),s=t.get(i);if(0===s){if(2===n)return this._createWord(e,n,s,o+1,this._findEndOfWord(e,t,n,o+1));n=1}else if(2===s){if(1===n)return this._createWord(e,n,s,o+1,this._findEndOfWord(e,t,n,o+1));n=2}else if(1===s&&0!==n)return this._createWord(e,n,s,o+1,this._findEndOfWord(e,t,n,o+1))}return 0!==n?this._createWord(e,n,1,0,this._findEndOfWord(e,t,n,0)):null}static _findEndOfWord(e,t,i,n){const o=e.length;for(let s=n;s<o;s++){const n=e.charCodeAt(s),o=t.get(n);if(1===o)return s;if(1===i&&2===o)return s;if(2===i&&0===o)return s}return o}static _findNextWordOnLine(e,t,i){const n=t.getLineContent(i.lineNumber);return this._doFindNextWordOnLine(n,e,i)}static _doFindNextWordOnLine(e,t,i){let n=0;const o=e.length;for(let s=i.column-1;s<o;s++){const i=e.charCodeAt(s),o=t.get(i);if(0===o){if(2===n)return this._createWord(e,n,o,this._findStartOfWord(e,t,n,s-1),s);n=1}else if(2===o){if(1===n)return this._createWord(e,n,o,this._findStartOfWord(e,t,n,s-1),s);n=2}else if(1===o&&0!==n)return this._createWord(e,n,o,this._findStartOfWord(e,t,n,s-1),s)}return 0!==n?this._createWord(e,n,1,this._findStartOfWord(e,t,n,o-1),o):null}static _findStartOfWord(e,t,i,n){for(let o=n;o>=0;o--){const n=e.charCodeAt(o),s=t.get(n);if(1===s)return o+1;if(1===i&&2===s)return o+1;if(2===i&&0===s)return o+1}return 0}static moveWordLeft(e,t,i,n){let o=i.lineNumber,s=i.column;1===s&&o>1&&(o-=1,s=t.getLineMaxColumn(o));let r=$t._findPreviousWordOnLine(e,t,new De.y(o,s));if(0===n)return new De.y(o,r?r.start+1:1);if(1===n)return r&&2===r.wordType&&r.end-r.start==1&&0===r.nextCharClass&&(r=$t._findPreviousWordOnLine(e,t,new De.y(o,r.start+1))),new De.y(o,r?r.start+1:1);if(3===n){for(;r&&2===r.wordType;)r=$t._findPreviousWordOnLine(e,t,new De.y(o,r.start+1));return new De.y(o,r?r.start+1:1)}return r&&s<=r.end+1&&(r=$t._findPreviousWordOnLine(e,t,new De.y(o,r.start+1))),new De.y(o,r?r.end+1:1)}static _moveWordPartLeft(e,t){const i=t.lineNumber,n=e.getLineMaxColumn(i);if(1===t.column)return i>1?new De.y(i-1,e.getLineMaxColumn(i-1)):t;const o=e.getLineContent(i);for(let e=t.column-1;e>1;e--){const t=o.charCodeAt(e-2),s=o.charCodeAt(e-1);if(95===t&&95!==s)return new De.y(i,e);if(45===t&&45!==s)return new De.y(i,e);if((tt.Lv(t)||tt.DB(t))&&tt.Wv(s))return new De.y(i,e);if(tt.Wv(t)&&tt.Wv(s)&&e+1<n){const t=o.charCodeAt(e);if(tt.Lv(t)||tt.DB(t))return new De.y(i,e)}}return new De.y(i,1)}static moveWordRight(e,t,i,n){let o=i.lineNumber,s=i.column,r=!1;s===t.getLineMaxColumn(o)&&o<t.getLineCount()&&(r=!0,o+=1,s=1);let a=$t._findNextWordOnLine(e,t,new De.y(o,s));if(2===n)a&&2===a.wordType&&a.end-a.start==1&&0===a.nextCharClass&&(a=$t._findNextWordOnLine(e,t,new De.y(o,a.end+1))),s=a?a.end+1:t.getLineMaxColumn(o);else if(3===n){for(r&&(s=0);a&&(2===a.wordType||a.start+1<=s);)a=$t._findNextWordOnLine(e,t,new De.y(o,a.end+1));s=a?a.start+1:t.getLineMaxColumn(o)}else a&&!r&&s>=a.start+1&&(a=$t._findNextWordOnLine(e,t,new De.y(o,a.end+1))),s=a?a.start+1:t.getLineMaxColumn(o);return new De.y(o,s)}static _moveWordPartRight(e,t){const i=t.lineNumber,n=e.getLineMaxColumn(i);if(t.column===n)return i<e.getLineCount()?new De.y(i+1,1):t;const o=e.getLineContent(i);for(let e=t.column+1;e<n;e++){const t=o.charCodeAt(e-2),s=o.charCodeAt(e-1);if(95!==t&&95===s)return new De.y(i,e);if(45!==t&&45===s)return new De.y(i,e);if((tt.Lv(t)||tt.DB(t))&&tt.Wv(s))return new De.y(i,e);if(tt.Wv(t)&&tt.Wv(s)&&e+1<n){const t=o.charCodeAt(e);if(tt.Lv(t)||tt.DB(t))return new De.y(i,e)}}return new De.y(i,n)}static _deleteWordLeftWhitespace(e,t){const i=e.getLineContent(t.lineNumber),n=t.column-2,o=tt.lT(i,n);return o+1<n?new xe.Q(t.lineNumber,o+2,t.lineNumber,t.column):null}static deleteWordLeft(e,t){const i=e.wordSeparators,n=e.model,o=e.selection,s=e.whitespaceHeuristics;if(!o.isEmpty())return o;if(qt.isAutoClosingPairDelete(e.autoClosingDelete,e.autoClosingBrackets,e.autoClosingQuotes,e.autoClosingPairs.autoClosingPairsOpenByEnd,e.model,[e.selection],e.autoClosedCharacters)){const t=e.selection.getPosition();return new xe.Q(t.lineNumber,t.column-1,t.lineNumber,t.column+1)}const r=new De.y(o.positionLineNumber,o.positionColumn);let a=r.lineNumber,l=r.column;if(1===a&&1===l)return null;if(s){const e=this._deleteWordLeftWhitespace(n,r);if(e)return e}let h=$t._findPreviousWordOnLine(i,n,r);return 0===t?h?l=h.start+1:l>1?l=1:(a--,l=n.getLineMaxColumn(a)):(h&&l<=h.end+1&&(h=$t._findPreviousWordOnLine(i,n,new De.y(a,h.start+1))),h?l=h.end+1:l>1?l=1:(a--,l=n.getLineMaxColumn(a))),new xe.Q(a,l,r.lineNumber,r.column)}static deleteInsideWord(e,t,i){if(!i.isEmpty())return i;const n=new De.y(i.positionLineNumber,i.positionColumn);return this._deleteInsideWordWhitespace(t,n)||this._deleteInsideWordDetermineDeleteRange(e,t,n)}static _charAtIsWhitespace(e,t){const i=e.charCodeAt(t);return 32===i||9===i}static _deleteInsideWordWhitespace(e,t){const i=e.getLineContent(t.lineNumber),n=i.length;if(0===n)return null;let o=Math.max(t.column-2,0);if(!this._charAtIsWhitespace(i,o))return null;let s=Math.min(t.column-1,n-1);if(!this._charAtIsWhitespace(i,s))return null;for(;o>0&&this._charAtIsWhitespace(i,o-1);)o--;for(;s+1<n&&this._charAtIsWhitespace(i,s+1);)s++;return new xe.Q(t.lineNumber,o+1,t.lineNumber,s+2)}static _deleteInsideWordDetermineDeleteRange(e,t,i){const n=t.getLineContent(i.lineNumber),o=n.length;if(0===o)return i.lineNumber>1?new xe.Q(i.lineNumber-1,t.getLineMaxColumn(i.lineNumber-1),i.lineNumber,1):i.lineNumber<t.getLineCount()?new xe.Q(i.lineNumber,1,i.lineNumber+1,1):new xe.Q(i.lineNumber,1,i.lineNumber,1);const s=e=>e.start+1<=i.column&&i.column<=e.end+1,r=(e,t)=>(e=Math.min(e,i.column),t=Math.max(t,i.column),new xe.Q(i.lineNumber,e,i.lineNumber,t)),a=e=>{let t=e.start+1,i=e.end+1,s=!1;for(;i-1<o&&this._charAtIsWhitespace(n,i-1);)s=!0,i++;if(!s)for(;t>1&&this._charAtIsWhitespace(n,t-2);)t--;return r(t,i)},l=$t._findPreviousWordOnLine(e,t,i);if(l&&s(l))return a(l);const h=$t._findNextWordOnLine(e,t,i);return h&&s(h)?a(h):l&&h?r(l.end+1,h.start+1):l?r(l.start+1,l.end+1):h?r(h.start+1,h.end+1):r(1,o+1)}static _deleteWordPartLeft(e,t){if(!t.isEmpty())return t;const i=t.getPosition(),n=$t._moveWordPartLeft(e,i);return new xe.Q(i.lineNumber,i.column,n.lineNumber,n.column)}static _findFirstNonWhitespaceChar(e,t){const i=e.length;for(let n=t;n<i;n++){const t=e.charAt(n);if(" "!==t&&"\t"!==t)return n}return i}static _deleteWordRightWhitespace(e,t){const i=e.getLineContent(t.lineNumber),n=t.column-1,o=this._findFirstNonWhitespaceChar(i,n);return n+1<o?new xe.Q(t.lineNumber,t.column,t.lineNumber,o+1):null}static deleteWordRight(e,t){const i=e.wordSeparators,n=e.model,o=e.selection,s=e.whitespaceHeuristics;if(!o.isEmpty())return o;const r=new De.y(o.positionLineNumber,o.positionColumn);let a=r.lineNumber,l=r.column;const h=n.getLineCount(),c=n.getLineMaxColumn(a);if(a===h&&l===c)return null;if(s){const e=this._deleteWordRightWhitespace(n,r);if(e)return e}let d=$t._findNextWordOnLine(i,n,r);return 2===t?d?l=d.end+1:l<c||a===h?l=c:(a++,d=$t._findNextWordOnLine(i,n,new De.y(a,1)),l=d?d.start+1:n.getLineMaxColumn(a)):(d&&l>=d.start+1&&(d=$t._findNextWordOnLine(i,n,new De.y(a,d.end+1))),d?l=d.start+1:l<c||a===h?l=c:(a++,d=$t._findNextWordOnLine(i,n,new De.y(a,1)),l=d?d.start+1:n.getLineMaxColumn(a))),new xe.Q(a,l,r.lineNumber,r.column)}static _deleteWordPartRight(e,t){if(!t.isEmpty())return t;const i=t.getPosition(),n=$t._moveWordPartRight(e,i);return new xe.Q(i.lineNumber,i.column,n.lineNumber,n.column)}static _createWordAtPosition(e,t,i){const n=new xe.Q(t,i.start+1,t,i.end+1);return{word:e.getValueInRange(n),startColumn:n.startColumn,endColumn:n.endColumn}}static getWordAtPosition(e,t,i){const n=(0,vt.i)(t),o=$t._findPreviousWordOnLine(n,e,i);if(o&&1===o.wordType&&o.start<=i.column-1&&i.column-1<=o.end)return $t._createWordAtPosition(e,i.lineNumber,o);const s=$t._findNextWordOnLine(n,e,i);return s&&1===s.wordType&&s.start<=i.column-1&&i.column-1<=s.end?$t._createWordAtPosition(e,i.lineNumber,s):null}static word(e,t,i,n,o){const s=(0,vt.i)(e.wordSeparators),r=$t._findPreviousWordOnLine(s,t,o),a=$t._findNextWordOnLine(s,t,o);if(!n){let e,i;return r&&1===r.wordType&&r.start<=o.column-1&&o.column-1<=r.end?(e=r.start+1,i=r.end+1):a&&1===a.wordType&&a.start<=o.column-1&&o.column-1<=a.end?(e=a.start+1,i=a.end+1):(e=r?r.end+1:1,i=a?a.start+1:t.getLineMaxColumn(o.lineNumber)),new Qt(new xe.Q(o.lineNumber,e,o.lineNumber,i),1,0,new De.y(o.lineNumber,i),0)}let l,h;r&&1===r.wordType&&r.start<o.column-1&&o.column-1<r.end?(l=r.start+1,h=r.end+1):a&&1===a.wordType&&a.start<o.column-1&&o.column-1<a.end?(l=a.start+1,h=a.end+1):(l=o.column,h=o.column);const c=o.lineNumber;let d;if(i.selectionStart.containsPosition(o))d=i.selectionStart.endColumn;else if(o.isBeforeOrEqual(i.selectionStart.getStartPosition())){d=l;const e=new De.y(c,d);i.selectionStart.containsPosition(e)&&(d=i.selectionStart.endColumn)}else{d=h;const e=new De.y(c,d);i.selectionStart.containsPosition(e)&&(d=i.selectionStart.startColumn)}return i.move(!0,c,d,0)}}class Xt{static addCursorDown(e,t,i){const n=[];let o=0;for(let s=0,r=t.length;s<r;s++){const r=t[s];n[o++]=new Ot(r.modelState,r.viewState),n[o++]=i?Ot.fromModelState(Jt.translateDown(e.cursorConfig,e.model,r.modelState)):Ot.fromViewState(Jt.translateDown(e.cursorConfig,e,r.viewState))}return n}static addCursorUp(e,t,i){const n=[];let o=0;for(let s=0,r=t.length;s<r;s++){const r=t[s];n[o++]=new Ot(r.modelState,r.viewState),n[o++]=i?Ot.fromModelState(Jt.translateUp(e.cursorConfig,e.model,r.modelState)):Ot.fromViewState(Jt.translateUp(e.cursorConfig,e,r.viewState))}return n}static moveToBeginningOfLine(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o];n[o]=this._moveToLineStart(e,s,i)}return n}static _moveToLineStart(e,t,i){const n=t.viewState.position.column,o=n===t.modelState.position.column,s=t.viewState.position.lineNumber,r=e.getLineFirstNonWhitespaceColumn(s);return o||n===r?this._moveToLineStartByModel(e,t,i):this._moveToLineStartByView(e,t,i)}static _moveToLineStartByView(e,t,i){return Ot.fromViewState(Jt.moveToBeginningOfLine(e.cursorConfig,e,t.viewState,i))}static _moveToLineStartByModel(e,t,i){return Ot.fromModelState(Jt.moveToBeginningOfLine(e.cursorConfig,e.model,t.modelState,i))}static moveToEndOfLine(e,t,i,n){const o=[];for(let s=0,r=t.length;s<r;s++){const r=t[s];o[s]=this._moveToLineEnd(e,r,i,n)}return o}static _moveToLineEnd(e,t,i,n){const o=t.viewState.position,s=e.getLineMaxColumn(o.lineNumber),r=o.column===s,a=t.modelState.position,l=e.model.getLineMaxColumn(a.lineNumber),h=s-o.column==l-a.column;return r||h?this._moveToLineEndByModel(e,t,i,n):this._moveToLineEndByView(e,t,i,n)}static _moveToLineEndByView(e,t,i,n){return Ot.fromViewState(Jt.moveToEndOfLine(e.cursorConfig,e,t.viewState,i,n))}static _moveToLineEndByModel(e,t,i,n){return Ot.fromModelState(Jt.moveToEndOfLine(e.cursorConfig,e.model,t.modelState,i,n))}static expandLineSelection(e,t){const i=[];for(let n=0,o=t.length;n<o;n++){const o=t[n],s=o.modelState.selection.startLineNumber,r=e.model.getLineCount();let a,l=o.modelState.selection.endLineNumber;l===r?a=e.model.getLineMaxColumn(r):(l++,a=1),i[n]=Ot.fromModelState(new Qt(new xe.Q(s,1,s,1),0,0,new De.y(l,a),0))}return i}static moveToBeginningOfBuffer(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o];n[o]=Ot.fromModelState(Jt.moveToBeginningOfBuffer(e.cursorConfig,e.model,s.modelState,i))}return n}static moveToEndOfBuffer(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o];n[o]=Ot.fromModelState(Jt.moveToEndOfBuffer(e.cursorConfig,e.model,s.modelState,i))}return n}static selectAll(e,t){const i=e.model.getLineCount(),n=e.model.getLineMaxColumn(i);return Ot.fromModelState(new Qt(new xe.Q(1,1,1,1),0,0,new De.y(i,n),0))}static line(e,t,i,n,o){const s=e.model.validatePosition(n),r=o?e.coordinatesConverter.validateViewPosition(new De.y(o.lineNumber,o.column),s):e.coordinatesConverter.convertModelPositionToViewPosition(s);if(!i){const t=e.model.getLineCount();let i=s.lineNumber+1,n=1;return i>t&&(i=t,n=e.model.getLineMaxColumn(i)),Ot.fromModelState(new Qt(new xe.Q(s.lineNumber,1,i,n),2,0,new De.y(i,n),0))}const a=t.modelState.selectionStart.getStartPosition().lineNumber;if(s.lineNumber<a)return Ot.fromViewState(t.viewState.move(!0,r.lineNumber,1,0));if(s.lineNumber>a){const i=e.getLineCount();let n=r.lineNumber+1,o=1;return n>i&&(n=i,o=e.getLineMaxColumn(n)),Ot.fromViewState(t.viewState.move(!0,n,o,0))}{const e=t.modelState.selectionStart.getEndPosition();return Ot.fromModelState(t.modelState.move(!0,e.lineNumber,e.column,0))}}static word(e,t,i,n){const o=e.model.validatePosition(n);return Ot.fromModelState($t.word(e.cursorConfig,e.model,t.modelState,i,o))}static cancelSelection(e,t){if(!t.modelState.hasSelection())return new Ot(t.modelState,t.viewState);const i=t.viewState.position.lineNumber,n=t.viewState.position.column;return Ot.fromViewState(new Qt(new xe.Q(i,n,i,n),0,0,new De.y(i,n),0))}static moveTo(e,t,i,n,o){if(i){if(1===t.modelState.selectionStartKind)return this.word(e,t,i,n);if(2===t.modelState.selectionStartKind)return this.line(e,t,i,n,o)}const s=e.model.validatePosition(n),r=o?e.coordinatesConverter.validateViewPosition(new De.y(o.lineNumber,o.column),s):e.coordinatesConverter.convertModelPositionToViewPosition(s);return Ot.fromViewState(t.viewState.move(i,r.lineNumber,r.column,0))}static simpleMove(e,t,i,n,o,s){switch(i){case 0:return 4===s?this._moveHalfLineLeft(e,t,n):this._moveLeft(e,t,n,o);case 1:return 4===s?this._moveHalfLineRight(e,t,n):this._moveRight(e,t,n,o);case 2:return 2===s?this._moveUpByViewLines(e,t,n,o):this._moveUpByModelLines(e,t,n,o);case 3:return 2===s?this._moveDownByViewLines(e,t,n,o):this._moveDownByModelLines(e,t,n,o);case 4:return 2===s?t.map((t=>Ot.fromViewState(Jt.moveToPrevBlankLine(e.cursorConfig,e,t.viewState,n)))):t.map((t=>Ot.fromModelState(Jt.moveToPrevBlankLine(e.cursorConfig,e.model,t.modelState,n))));case 5:return 2===s?t.map((t=>Ot.fromViewState(Jt.moveToNextBlankLine(e.cursorConfig,e,t.viewState,n)))):t.map((t=>Ot.fromModelState(Jt.moveToNextBlankLine(e.cursorConfig,e.model,t.modelState,n))));case 6:return this._moveToViewMinColumn(e,t,n);case 7:return this._moveToViewFirstNonWhitespaceColumn(e,t,n);case 8:return this._moveToViewCenterColumn(e,t,n);case 9:return this._moveToViewMaxColumn(e,t,n);case 10:return this._moveToViewLastNonWhitespaceColumn(e,t,n);default:return null}}static viewportMove(e,t,i,n,o){const s=e.getCompletelyVisibleViewRange(),r=e.coordinatesConverter.convertViewRangeToModelRange(s);switch(i){case 11:{const i=this._firstLineNumberInRange(e.model,r,o),s=e.model.getLineFirstNonWhitespaceColumn(i);return[this._moveToModelPosition(e,t[0],n,i,s)]}case 13:{const i=this._lastLineNumberInRange(e.model,r,o),s=e.model.getLineFirstNonWhitespaceColumn(i);return[this._moveToModelPosition(e,t[0],n,i,s)]}case 12:{const i=Math.round((r.startLineNumber+r.endLineNumber)/2),o=e.model.getLineFirstNonWhitespaceColumn(i);return[this._moveToModelPosition(e,t[0],n,i,o)]}case 14:{const i=[];for(let o=0,r=t.length;o<r;o++){const r=t[o];i[o]=this.findPositionInViewportIfOutside(e,r,s,n)}return i}default:return null}}static findPositionInViewportIfOutside(e,t,i,n){const o=t.viewState.position.lineNumber;if(i.startLineNumber<=o&&o<=i.endLineNumber-1)return new Ot(t.modelState,t.viewState);{let s;s=o>i.endLineNumber-1?i.endLineNumber-1:o<i.startLineNumber?i.startLineNumber:o;const r=Jt.vertical(e.cursorConfig,e,o,t.viewState.position.column,t.viewState.leftoverVisibleColumns,s,!1);return Ot.fromViewState(t.viewState.move(n,r.lineNumber,r.column,r.leftoverVisibleColumns))}}static _firstLineNumberInRange(e,t,i){let n=t.startLineNumber;return t.startColumn!==e.getLineMinColumn(n)&&n++,Math.min(t.endLineNumber,n+i-1)}static _lastLineNumberInRange(e,t,i){let n=t.startLineNumber;return t.startColumn!==e.getLineMinColumn(n)&&n++,Math.max(n,t.endLineNumber-i+1)}static _moveLeft(e,t,i,n){return t.map((t=>Ot.fromViewState(Jt.moveLeft(e.cursorConfig,e,t.viewState,i,n))))}static _moveHalfLineLeft(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=Math.round(e.getLineContent(r).length/2);n[o]=Ot.fromViewState(Jt.moveLeft(e.cursorConfig,e,s.viewState,i,a))}return n}static _moveRight(e,t,i,n){return t.map((t=>Ot.fromViewState(Jt.moveRight(e.cursorConfig,e,t.viewState,i,n))))}static _moveHalfLineRight(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=Math.round(e.getLineContent(r).length/2);n[o]=Ot.fromViewState(Jt.moveRight(e.cursorConfig,e,s.viewState,i,a))}return n}static _moveDownByViewLines(e,t,i,n){const o=[];for(let s=0,r=t.length;s<r;s++){const r=t[s];o[s]=Ot.fromViewState(Jt.moveDown(e.cursorConfig,e,r.viewState,i,n))}return o}static _moveDownByModelLines(e,t,i,n){const o=[];for(let s=0,r=t.length;s<r;s++){const r=t[s];o[s]=Ot.fromModelState(Jt.moveDown(e.cursorConfig,e.model,r.modelState,i,n))}return o}static _moveUpByViewLines(e,t,i,n){const o=[];for(let s=0,r=t.length;s<r;s++){const r=t[s];o[s]=Ot.fromViewState(Jt.moveUp(e.cursorConfig,e,r.viewState,i,n))}return o}static _moveUpByModelLines(e,t,i,n){const o=[];for(let s=0,r=t.length;s<r;s++){const r=t[s];o[s]=Ot.fromModelState(Jt.moveUp(e.cursorConfig,e.model,r.modelState,i,n))}return o}static _moveToViewPosition(e,t,i,n,o){return Ot.fromViewState(t.viewState.move(i,n,o,0))}static _moveToModelPosition(e,t,i,n,o){return Ot.fromModelState(t.modelState.move(i,n,o,0))}static _moveToViewMinColumn(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=e.getLineMinColumn(r);n[o]=this._moveToViewPosition(e,s,i,r,a)}return n}static _moveToViewFirstNonWhitespaceColumn(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=e.getLineFirstNonWhitespaceColumn(r);n[o]=this._moveToViewPosition(e,s,i,r,a)}return n}static _moveToViewCenterColumn(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=Math.round((e.getLineMaxColumn(r)+e.getLineMinColumn(r))/2);n[o]=this._moveToViewPosition(e,s,i,r,a)}return n}static _moveToViewMaxColumn(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=e.getLineMaxColumn(r);n[o]=this._moveToViewPosition(e,s,i,r,a)}return n}static _moveToViewLastNonWhitespaceColumn(e,t,i){const n=[];for(let o=0,s=t.length;o<s;o++){const s=t[o],r=s.viewState.position.lineNumber,a=e.getLineLastNonWhitespaceColumn(r);n[o]=this._moveToViewPosition(e,s,i,r,a)}return n}}var Zt;!function(e){e.description={description:"Move cursor to a logical position in the view",args:[{name:"Cursor move argument object",description:"Property-value pairs that can be passed through this argument:\n\t\t\t\t\t* 'to': A mandatory logical position value providing where to move the cursor.\n\t\t\t\t\t\t```\n\t\t\t\t\t\t'left', 'right', 'up', 'down', 'prevBlankLine', 'nextBlankLine',\n\t\t\t\t\t\t'wrappedLineStart', 'wrappedLineEnd', 'wrappedLineColumnCenter'\n\t\t\t\t\t\t'wrappedLineFirstNonWhitespaceCharacter', 'wrappedLineLastNonWhitespaceCharacter'\n\t\t\t\t\t\t'viewPortTop', 'viewPortCenter', 'viewPortBottom', 'viewPortIfOutside'\n\t\t\t\t\t\t```\n\t\t\t\t\t* 'by': Unit to move. Default is computed based on 'to' value.\n\t\t\t\t\t\t```\n\t\t\t\t\t\t'line', 'wrappedLine', 'character', 'halfLine'\n\t\t\t\t\t\t```\n\t\t\t\t\t* 'value': Number of units to move. Default is '1'.\n\t\t\t\t\t* 'select': If 'true' makes the selection. Default is 'false'.\n\t\t\t\t",constraint:function(e){if(!Lt.Gv(e))return!1;const t=e;return!(!Lt.Kg(t.to)||!Lt.b0(t.select)&&!Lt.Lm(t.select)||!Lt.b0(t.by)&&!Lt.Kg(t.by)||!Lt.b0(t.value)&&!Lt.Et(t.value))},schema:{type:"object",required:["to"],properties:{to:{type:"string",enum:["left","right","up","down","prevBlankLine","nextBlankLine","wrappedLineStart","wrappedLineEnd","wrappedLineColumnCenter","wrappedLineFirstNonWhitespaceCharacter","wrappedLineLastNonWhitespaceCharacter","viewPortTop","viewPortCenter","viewPortBottom","viewPortIfOutside"]},by:{type:"string",enum:["line","wrappedLine","character","halfLine"]},value:{type:"number",default:1},select:{type:"boolean",default:!1}}}}]},e.RawDirection={Left:"left",Right:"right",Up:"up",Down:"down",PrevBlankLine:"prevBlankLine",NextBlankLine:"nextBlankLine",WrappedLineStart:"wrappedLineStart",WrappedLineFirstNonWhitespaceCharacter:"wrappedLineFirstNonWhitespaceCharacter",WrappedLineColumnCenter:"wrappedLineColumnCenter",WrappedLineEnd:"wrappedLineEnd",WrappedLineLastNonWhitespaceCharacter:"wrappedLineLastNonWhitespaceCharacter",ViewPortTop:"viewPortTop",ViewPortCenter:"viewPortCenter",ViewPortBottom:"viewPortBottom",ViewPortIfOutside:"viewPortIfOutside"},e.RawUnit={Line:"line",WrappedLine:"wrappedLine",Character:"character",HalfLine:"halfLine"},e.parse=function(t){if(!t.to)return null;let i;switch(t.to){case e.RawDirection.Left:i=0;break;case e.RawDirection.Right:i=1;break;case e.RawDirection.Up:i=2;break;case e.RawDirection.Down:i=3;break;case e.RawDirection.PrevBlankLine:i=4;break;case e.RawDirection.NextBlankLine:i=5;break;case e.RawDirection.WrappedLineStart:i=6;break;case e.RawDirection.WrappedLineFirstNonWhitespaceCharacter:i=7;break;case e.RawDirection.WrappedLineColumnCenter:i=8;break;case e.RawDirection.WrappedLineEnd:i=9;break;case e.RawDirection.WrappedLineLastNonWhitespaceCharacter:i=10;break;case e.RawDirection.ViewPortTop:i=11;break;case e.RawDirection.ViewPortBottom:i=13;break;case e.RawDirection.ViewPortCenter:i=12;break;case e.RawDirection.ViewPortIfOutside:i=14;break;default:return null}let n=0;switch(t.by){case e.RawUnit.Line:n=1;break;case e.RawUnit.WrappedLine:n=2;break;case e.RawUnit.Character:n=3;break;case e.RawUnit.HalfLine:n=4}return{direction:i,unit:n,select:!!t.select,value:t.value||1}}}(Zt||(Zt={}));var ei=i(1976),ti=i(1920);function ii(e,t,i,n){const o=(0,ti.P6)(t,i.startLineNumber,i.startColumn),s=n.getLanguageConfiguration(o.languageId);if(!s)return null;const r=o.getLineContent(),a=r.substr(0,i.startColumn-1-o.firstCharOffset);let l;l=i.isEmpty()?r.substr(i.startColumn-1-o.firstCharOffset):(0,ti.P6)(t,i.endLineNumber,i.endColumn).getLineContent().substr(i.endColumn-1-o.firstCharOffset);let h="";if(i.startLineNumber>1&&0===o.firstCharOffset){const e=(0,ti.P6)(t,i.startLineNumber-1);e.languageId===o.languageId&&(h=e.getLineContent())}const c=s.onEnter(e,h,a,l);if(!c)return null;const d=c.indentAction;let u=c.appendText;const g=c.removeText||0;u?d===ei.l.Indent&&(u="\t"+u):u=d===ei.l.Indent||d===ei.l.IndentOutdent?"\t":"";let m=(0,ti.Cw)(t,i.startLineNumber,i.startColumn);return g&&(m=m.substring(0,m.length-g)),{indentAction:d,appendText:u,removeText:g,indentation:m}}const ni=Object.create(null);function oi(e,t){if(t<=0)return"";ni[e]||(ni[e]=["",e]);const i=ni[e];for(let n=i.length;n<=t;n++)i[n]=i[n-1]+e;return i[t]}let si=class e{static unshiftIndent(e,t,i,n,o){const s=Le.A.visibleColumnFromColumn(e,t,i);if(o){const e=oi(" ",n);return oi(e,Le.A.prevIndentTabStop(s,n)/n)}return oi("\t",Le.A.prevRenderTabStop(s,i)/i)}static shiftIndent(e,t,i,n,o){const s=Le.A.visibleColumnFromColumn(e,t,i);if(o){const e=oi(" ",n);return oi(e,Le.A.nextIndentTabStop(s,n)/n)}return oi("\t",Le.A.nextRenderTabStop(s,i)/i)}constructor(e,t,i){this._languageConfigurationService=i,this._opts=t,this._selection=e,this._selectionId=null,this._useLastEditRangeForCursorEndPosition=!1,this._selectionStartColumnStaysPut=!1}_addEditOperation(e,t,i){this._useLastEditRangeForCursorEndPosition?e.addTrackedEditOperation(t,i):e.addEditOperation(t,i)}getEditOperations(t,i){const n=this._selection.startLineNumber;let o=this._selection.endLineNumber;1===this._selection.endColumn&&n!==o&&(o-=1);const{tabSize:s,indentSize:r,insertSpaces:a}=this._opts,l=n===o;if(this._opts.useTabStops){this._selection.isEmpty()&&/^\s*$/.test(t.getLineContent(n))&&(this._useLastEditRangeForCursorEndPosition=!0);let h=0,c=0;for(let d=n;d<=o;d++,h=c){c=0;const o=t.getLineContent(d);let u,g=tt.HG(o);if((!this._opts.isUnshift||0!==o.length&&0!==g)&&(l||this._opts.isUnshift||0!==o.length)){if(-1===g&&(g=o.length),d>1&&Le.A.visibleColumnFromColumn(o,g+1,s)%r!=0&&t.tokenization.isCheapToTokenize(d-1)){const e=ii(this._opts.autoIndent,t,new xe.Q(d-1,t.getLineMaxColumn(d-1),d-1,t.getLineMaxColumn(d-1)),this._languageConfigurationService);if(e){if(c=h,e.appendText)for(let t=0,i=e.appendText.length;t<i&&c<r&&32===e.appendText.charCodeAt(t);t++)c++;e.removeText&&(c=Math.max(0,c-e.removeText));for(let e=0;e<c&&0!==g&&32===o.charCodeAt(g-1);e++)g--}}this._opts.isUnshift&&0===g||(u=this._opts.isUnshift?e.unshiftIndent(o,g+1,s,r,a):e.shiftIndent(o,g+1,s,r,a),this._addEditOperation(i,new xe.Q(d,1,d,g+1),u),d!==n||this._selection.isEmpty()||(this._selectionStartColumnStaysPut=this._selection.startColumn<=g+1))}}}else{!this._opts.isUnshift&&this._selection.isEmpty()&&0===t.getLineLength(n)&&(this._useLastEditRangeForCursorEndPosition=!0);const e=a?oi(" ",r):"\t";for(let s=n;s<=o;s++){const o=t.getLineContent(s);let a=tt.HG(o);if((!this._opts.isUnshift||0!==o.length&&0!==a)&&(l||this._opts.isUnshift||0!==o.length)&&(-1===a&&(a=o.length),!this._opts.isUnshift||0!==a))if(this._opts.isUnshift){a=Math.min(a,r);for(let e=0;e<a;e++)if(9===o.charCodeAt(e)){a=e+1;break}this._addEditOperation(i,new xe.Q(s,1,s,a+1),"")}else this._addEditOperation(i,new xe.Q(s,1,s,1),e),s!==n||this._selection.isEmpty()||(this._selectionStartColumnStaysPut=1===this._selection.startColumn)}}this._selectionId=i.trackSelection(this._selection)}computeCursorState(e,t){if(this._useLastEditRangeForCursorEndPosition){const e=t.getInverseEditOperations()[0];return new P.L(e.range.endLineNumber,e.range.endColumn,e.range.endLineNumber,e.range.endColumn)}const i=t.getTrackedSelection(this._selectionId);if(this._selectionStartColumnStaysPut){const e=this._selection.startColumn;return i.startColumn<=e?i:0===i.getDirection()?new P.L(i.startLineNumber,e,i.endLineNumber,i.endColumn):new P.L(i.endLineNumber,i.endColumn,i.startLineNumber,e)}return i}};si=function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r}([function(e,t){return function(e,i){t(e,i,2)}}(0,ti.JZ)],si);class ri{constructor(e,t,i){this._range=e,this._charBeforeSelection=t,this._charAfterSelection=i}getEditOperations(e,t){t.addTrackedEditOperation(new xe.Q(this._range.startLineNumber,this._range.startColumn,this._range.startLineNumber,this._range.startColumn),this._charBeforeSelection),t.addTrackedEditOperation(new xe.Q(this._range.endLineNumber,this._range.endColumn,this._range.endLineNumber,this._range.endColumn),this._charAfterSelection)}computeCursorState(e,t){const i=t.getInverseEditOperations(),n=i[0].range,o=i[1].range;return new P.L(n.endLineNumber,n.endColumn,o.endLineNumber,o.endColumn-this._charAfterSelection.length)}}class ai{constructor(e,t,i){this._position=e,this._text=t,this._charAfter=i}getEditOperations(e,t){t.addTrackedEditOperation(new xe.Q(this._position.lineNumber,this._position.column,this._position.lineNumber,this._position.column),this._text+this._charAfter)}computeCursorState(e,t){const i=t.getInverseEditOperations()[0].range;return new P.L(i.endLineNumber,i.startColumn,i.endLineNumber,i.endColumn-this._charAfter.length)}}function li(e,t,i,n=!0,o){if(e<4)return null;const s=o.getLanguageConfiguration(t.tokenization.getLanguageId()).indentRulesSupport;if(!s)return null;if(i<=1)return{indentation:"",action:null};for(let e=i-1;e>0&&""===t.getLineContent(e);e--)if(1===e)return{indentation:"",action:null};const r=function(e,t,i){const n=e.tokenization.getLanguageIdAtPosition(t,0);if(t>1){let o,s=-1;for(o=t-1;o>=1;o--){if(e.tokenization.getLanguageIdAtPosition(o,0)!==n)return s;const t=e.getLineContent(o);if(!i.shouldIgnore(t)&&!/^\s+$/.test(t)&&""!==t)return o;s=o}}return-1}(t,i,s);if(r<0)return null;if(r<1)return{indentation:"",action:null};const a=t.getLineContent(r);if(s.shouldIncrease(a)||s.shouldIndentNextLine(a))return{indentation:tt.UU(a),action:ei.l.Indent,line:r};if(s.shouldDecrease(a))return{indentation:tt.UU(a),action:null,line:r};{if(1===r)return{indentation:tt.UU(t.getLineContent(r)),action:null,line:r};const e=r-1,i=s.getIndentMetadata(t.getLineContent(e));if(!(3&i)&&4&i){let i=0;for(let n=e-1;n>0;n--)if(!s.shouldIndentNextLine(t.getLineContent(n))){i=n;break}return{indentation:tt.UU(t.getLineContent(i+1)),action:null,line:i+1}}if(n)return{indentation:tt.UU(t.getLineContent(r)),action:null,line:r};for(let e=r;e>0;e--){const i=t.getLineContent(e);if(s.shouldIncrease(i))return{indentation:tt.UU(i),action:ei.l.Indent,line:e};if(s.shouldIndentNextLine(i)){let i=0;for(let n=e-1;n>0;n--)if(!s.shouldIndentNextLine(t.getLineContent(e))){i=n;break}return{indentation:tt.UU(t.getLineContent(i+1)),action:null,line:i+1}}if(s.shouldDecrease(i))return{indentation:tt.UU(i),action:null,line:e}}return{indentation:tt.UU(t.getLineContent(1)),action:null,line:1}}}class hi{static indent(e,t,i){if(null===t||null===i)return[];const n=[];for(let t=0,o=i.length;t<o;t++)n[t]=new si(i[t],{isUnshift:!1,tabSize:e.tabSize,indentSize:e.indentSize,insertSpaces:e.insertSpaces,useTabStops:e.useTabStops,autoIndent:e.autoIndent},e.languageConfigurationService);return n}static outdent(e,t,i){const n=[];for(let t=0,o=i.length;t<o;t++)n[t]=new si(i[t],{isUnshift:!0,tabSize:e.tabSize,indentSize:e.indentSize,insertSpaces:e.insertSpaces,useTabStops:e.useTabStops,autoIndent:e.autoIndent},e.languageConfigurationService);return n}static shiftIndent(e,t,i){return i=i||1,si.shiftIndent(t,t.length+i,e.tabSize,e.indentSize,e.insertSpaces)}static unshiftIndent(e,t,i){return i=i||1,si.unshiftIndent(t,t.length+i,e.tabSize,e.indentSize,e.insertSpaces)}static _distributedPaste(e,t,i,n){const o=[];for(let e=0,t=i.length;e<t;e++)o[e]=new Ut(i[e],n[e]);return new Ht(0,o,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!0})}static _simplePaste(e,t,i,n,o){const s=[];for(let e=0,t=i.length;e<t;e++){const t=i[e],r=t.getPosition();if(o&&!t.isEmpty()&&(o=!1),o&&n.indexOf("\n")!==n.length-1&&(o=!1),o){const i=new xe.Q(r.lineNumber,1,r.lineNumber,1);s[e]=new Kt(i,n,t,!0)}else s[e]=new Ut(t,n)}return new Ht(0,s,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!0})}static _distributePasteToCursors(e,t,i,n,o){if(n)return null;if(1===t.length)return null;if(o&&o.length===t.length)return o;if("spread"===e.multiCursorPaste){10===i.charCodeAt(i.length-1)&&(i=i.substr(0,i.length-1)),13===i.charCodeAt(i.length-1)&&(i=i.substr(0,i.length-1));const e=tt.uz(i);if(e.length===t.length)return e}return null}static paste(e,t,i,n,o,s){const r=this._distributePasteToCursors(e,i,n,o,s);return r?(i=i.sort(xe.Q.compareRangesUsingStarts),this._distributedPaste(e,t,i,r)):this._simplePaste(e,t,i,n,o)}static _goodIndentForLine(e,t,i){let n=null,o="";const s=li(e.autoIndent,t,i,!1,e.languageConfigurationService);if(s)n=s.action,o=s.indentation;else if(i>1){let n;for(n=i-1;n>=1;n--){const e=t.getLineContent(n);if(tt.lT(e)>=0)break}if(n<1)return null;const s=t.getLineMaxColumn(n),r=ii(e.autoIndent,t,new xe.Q(n,s,n,s),e.languageConfigurationService);r&&(o=r.indentation+r.appendText)}return n&&(n===ei.l.Indent&&(o=hi.shiftIndent(e,o)),n===ei.l.Outdent&&(o=hi.unshiftIndent(e,o)),o=e.normalizeIndentation(o)),o||null}static _replaceJumpToNextIndent(e,t,i,n){let o="";const s=i.getStartPosition();if(e.insertSpaces){const i=e.visibleColumnFromColumn(t,s),n=e.indentSize,r=n-i%n;for(let e=0;e<r;e++)o+=" "}else o="\t";return new Ut(i,o,n)}static tab(e,t,i){const n=[];for(let o=0,s=i.length;o<s;o++){const s=i[o];if(s.isEmpty()){const i=t.getLineContent(s.startLineNumber);if(/^\s*$/.test(i)&&t.tokenization.isCheapToTokenize(s.startLineNumber)){let r=this._goodIndentForLine(e,t,s.startLineNumber);r=r||"\t";const a=e.normalizeIndentation(r);if(!i.startsWith(a)){n[o]=new Ut(new xe.Q(s.startLineNumber,1,s.startLineNumber,i.length+1),a,!0);continue}}n[o]=this._replaceJumpToNextIndent(e,t,s,!0)}else{if(s.startLineNumber===s.endLineNumber){const i=t.getLineMaxColumn(s.startLineNumber);if(1!==s.startColumn||s.endColumn!==i){n[o]=this._replaceJumpToNextIndent(e,t,s,!1);continue}}n[o]=new si(s,{isUnshift:!1,tabSize:e.tabSize,indentSize:e.indentSize,insertSpaces:e.insertSpaces,useTabStops:e.useTabStops,autoIndent:e.autoIndent},e.languageConfigurationService)}}return n}static compositionType(e,t,i,n,o,s,r,a){const l=n.map((e=>this._compositionType(i,e,o,s,r,a)));return new Ht(4,l,{shouldPushStackElementBefore:gi(e,4),shouldPushStackElementAfter:!1})}static _compositionType(e,t,i,n,o,s){if(!t.isEmpty())return null;const r=t.getPosition(),a=Math.max(1,r.column-n),l=Math.min(e.getLineMaxColumn(r.lineNumber),r.column+o),h=new xe.Q(r.lineNumber,a,r.lineNumber,l);return e.getValueInRange(h)===i&&0===s?null:new Gt(h,i,0,s)}static _typeCommand(e,t,i){return i?new jt(e,t,!0):new Ut(e,t,!0)}static _enter(e,t,i,n){if(0===e.autoIndent)return hi._typeCommand(n,"\n",i);if(!t.tokenization.isCheapToTokenize(n.getStartPosition().lineNumber)||1===e.autoIndent){const o=t.getLineContent(n.startLineNumber),s=tt.UU(o).substring(0,n.startColumn-1);return hi._typeCommand(n,"\n"+e.normalizeIndentation(s),i)}const o=ii(e.autoIndent,t,n,e.languageConfigurationService);if(o){if(o.indentAction===ei.l.None)return hi._typeCommand(n,"\n"+e.normalizeIndentation(o.indentation+o.appendText),i);if(o.indentAction===ei.l.Indent)return hi._typeCommand(n,"\n"+e.normalizeIndentation(o.indentation+o.appendText),i);if(o.indentAction===ei.l.IndentOutdent){const t=e.normalizeIndentation(o.indentation),s=e.normalizeIndentation(o.indentation+o.appendText),r="\n"+s+"\n"+t;return i?new jt(n,r,!0):new Gt(n,r,-1,s.length-t.length,!0)}if(o.indentAction===ei.l.Outdent){const t=hi.unshiftIndent(e,o.indentation);return hi._typeCommand(n,"\n"+e.normalizeIndentation(t+o.appendText),i)}}const s=t.getLineContent(n.startLineNumber),r=tt.UU(s).substring(0,n.startColumn-1);if(e.autoIndent>=4){const o=function(e,t,i,n,o){if(e<4)return null;t.tokenization.forceTokenization(i.startLineNumber);const s=t.tokenization.getLineTokens(i.startLineNumber),r=(0,It.BQ)(s,i.startColumn-1),a=r.getLineContent();let l,h,c=!1;r.firstCharOffset>0&&s.getLanguageId(0)!==r.languageId?(c=!0,l=a.substr(0,i.startColumn-1-r.firstCharOffset)):l=s.getLineContent().substring(0,i.startColumn-1),h=i.isEmpty()?a.substr(i.startColumn-1-r.firstCharOffset):(0,ti.P6)(t,i.endLineNumber,i.endColumn).getLineContent().substr(i.endColumn-1-r.firstCharOffset);const d=o.getLanguageConfiguration(r.languageId).indentRulesSupport;if(!d)return null;const u=l,g=tt.UU(l),m={tokenization:{getLineTokens:e=>t.tokenization.getLineTokens(e),getLanguageId:()=>t.getLanguageId(),getLanguageIdAtPosition:(e,i)=>t.getLanguageIdAtPosition(e,i)},getLineContent:e=>e===i.startLineNumber?u:t.getLineContent(e)},p=tt.UU(s.getLineContent()),f=li(e,m,i.startLineNumber+1,void 0,o);if(!f){const e=c?p:g;return{beforeEnter:e,afterEnter:e}}let A=c?p:f.indentation;return f.action===ei.l.Indent&&(A=n.shiftIndent(A)),d.shouldDecrease(h)&&(A=n.unshiftIndent(A)),{beforeEnter:c?p:g,afterEnter:A}}(e.autoIndent,t,n,{unshiftIndent:t=>hi.unshiftIndent(e,t),shiftIndent:t=>hi.shiftIndent(e,t),normalizeIndentation:t=>e.normalizeIndentation(t)},e.languageConfigurationService);if(o){let s=e.visibleColumnFromColumn(t,n.getEndPosition());const r=n.endColumn,a=t.getLineContent(n.endLineNumber),l=tt.HG(a);if(n=l>=0?n.setEndPosition(n.endLineNumber,Math.max(n.endColumn,l+1)):n.setEndPosition(n.endLineNumber,t.getLineMaxColumn(n.endLineNumber)),i)return new jt(n,"\n"+e.normalizeIndentation(o.afterEnter),!0);{let t=0;return r<=l+1&&(e.insertSpaces||(s=Math.ceil(s/e.indentSize)),t=Math.min(s+1-e.normalizeIndentation(o.afterEnter).length-1,0)),new Gt(n,"\n"+e.normalizeIndentation(o.afterEnter),0,t,!0)}}}return hi._typeCommand(n,"\n"+e.normalizeIndentation(r),i)}static _isAutoIndentType(e,t,i){if(e.autoIndent<4)return!1;for(let e=0,n=i.length;e<n;e++)if(!t.tokenization.isCheapToTokenize(i[e].getEndPosition().lineNumber))return!1;return!0}static _runAutoIndentType(e,t,i,n){const o=(0,ti.Cw)(t,i.startLineNumber,i.startColumn),s=function(e,t,i,n,o,s){if(e<4)return null;const r=(0,ti.P6)(t,i.startLineNumber,i.startColumn);if(r.firstCharOffset)return null;const a=s.getLanguageConfiguration(r.languageId).indentRulesSupport;if(!a)return null;const l=r.getLineContent(),h=l.substr(0,i.startColumn-1-r.firstCharOffset);let c;if(c=i.isEmpty()?l.substr(i.startColumn-1-r.firstCharOffset):(0,ti.P6)(t,i.endLineNumber,i.endColumn).getLineContent().substr(i.endColumn-1-r.firstCharOffset),!a.shouldDecrease(h+c)&&a.shouldDecrease(h+n+c)){const n=li(e,t,i.startLineNumber,!1,s);if(!n)return null;let r=n.indentation;return n.action!==ei.l.Indent&&(r=o.unshiftIndent(r)),r}return null}(e.autoIndent,t,i,n,{shiftIndent:t=>hi.shiftIndent(e,t),unshiftIndent:t=>hi.unshiftIndent(e,t)},e.languageConfigurationService);if(null===s)return null;if(s!==e.normalizeIndentation(o)){const o=t.getLineFirstNonWhitespaceColumn(i.startLineNumber);return 0===o?hi._typeCommand(new xe.Q(i.startLineNumber,1,i.endLineNumber,i.endColumn),e.normalizeIndentation(s)+n,!1):hi._typeCommand(new xe.Q(i.startLineNumber,1,i.endLineNumber,i.endColumn),e.normalizeIndentation(s)+t.getLineContent(i.startLineNumber).substring(o-1,i.startColumn-1)+n,!1)}return null}static _isAutoClosingOvertype(e,t,i,n,o){if("never"===e.autoClosingOvertype)return!1;if(!e.autoClosingPairs.autoClosingPairsCloseSingleChar.has(o))return!1;for(let s=0,r=i.length;s<r;s++){const r=i[s];if(!r.isEmpty())return!1;const a=r.getPosition(),l=t.getLineContent(a.lineNumber);if(l.charAt(a.column-1)!==o)return!1;const h=Wt(o);if(92===(a.column>2?l.charCodeAt(a.column-2):0)&&h)return!1;if("auto"===e.autoClosingOvertype){let e=!1;for(let t=0,i=n.length;t<i;t++){const i=n[t];if(a.lineNumber===i.startLineNumber&&a.column===i.startColumn){e=!0;break}}if(!e)return!1}}return!0}static _runAutoClosingOvertype(e,t,i,n,o){const s=[];for(let e=0,t=n.length;e<t;e++){const t=n[e].getPosition(),i=new xe.Q(t.lineNumber,t.column,t.lineNumber,t.column+1);s[e]=new Ut(i,o)}return new Ht(4,s,{shouldPushStackElementBefore:gi(e,4),shouldPushStackElementAfter:!1})}static _isBeforeClosingBrace(e,t){const i=t.charAt(0),n=e.autoClosingPairs.autoClosingPairsOpenByStart.get(i)||[],o=e.autoClosingPairs.autoClosingPairsCloseByStart.get(i)||[],s=n.some((e=>t.startsWith(e.open))),r=o.some((e=>t.startsWith(e.close)));return!s&&r}static _findAutoClosingPairOpen(e,t,i,n){const o=e.autoClosingPairs.autoClosingPairsOpenByEnd.get(n);if(!o)return null;let s=null;for(const e of o)if(null===s||e.open.length>s.open.length){let o=!0;for(const s of i)if(t.getValueInRange(new xe.Q(s.lineNumber,s.column-e.open.length+1,s.lineNumber,s.column))+n!==e.open){o=!1;break}o&&(s=e)}return s}static _findContainedAutoClosingPair(e,t){if(t.open.length<=1)return null;const i=t.close.charAt(t.close.length-1),n=e.autoClosingPairs.autoClosingPairsCloseByEnd.get(i)||[];let o=null;for(const e of n)e.open!==t.open&&t.open.includes(e.open)&&t.close.endsWith(e.close)&&(!o||e.open.length>o.open.length)&&(o=e);return o}static _getAutoClosingPairClose(e,t,i,n,o){const s=Wt(n),r=s?e.autoClosingQuotes:e.autoClosingBrackets,a=s?e.shouldAutoCloseBefore.quote:e.shouldAutoCloseBefore.bracket;if("never"===r)return null;for(const e of i)if(!e.isEmpty())return null;const l=i.map((e=>{const t=e.getPosition();return o?{lineNumber:t.lineNumber,beforeColumn:t.column-n.length,afterColumn:t.column}:{lineNumber:t.lineNumber,beforeColumn:t.column,afterColumn:t.column}})),h=this._findAutoClosingPairOpen(e,t,l.map((e=>new De.y(e.lineNumber,e.beforeColumn))),n);if(!h)return null;const c=this._findContainedAutoClosingPair(e,h),d=c?c.close:"";let u=!0;for(const i of l){const{lineNumber:o,beforeColumn:s,afterColumn:l}=i,c=t.getLineContent(o),g=c.substring(0,s-1),m=c.substring(l-1);if(m.startsWith(d)||(u=!1),m.length>0){const t=m.charAt(0);if(!hi._isBeforeClosingBrace(e,m)&&!a(t))return null}if(1===h.open.length&&("'"===n||'"'===n)&&"always"!==r){const t=(0,vt.i)(e.wordSeparators);if(g.length>0){const e=g.charCodeAt(g.length-1);if(0===t.get(e))return null}}if(!t.tokenization.isCheapToTokenize(o))return null;t.tokenization.forceTokenization(o);const p=t.tokenization.getLineTokens(o),f=(0,It.BQ)(p,s-1);if(!h.shouldAutoClose(f,s-f.firstCharOffset))return null;const A=h.findNeutralCharacter();if(A){const e=t.tokenization.getTokenTypeIfInsertingCharacter(o,s,A);if(!h.isOK(e))return null}}return u?h.close.substring(0,h.close.length-d.length):h.close}static _runAutoClosingOpenCharType(e,t,i,n,o,s,r){const a=[];for(let e=0,t=n.length;e<t;e++){const t=n[e];a[e]=new ci(t,o,!s,r)}return new Ht(4,a,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!1})}static _shouldSurroundChar(e,t){return Wt(t)?"quotes"===e.autoSurround||"languageDefined"===e.autoSurround:"brackets"===e.autoSurround||"languageDefined"===e.autoSurround}static _isSurroundSelectionType(e,t,i,n){if(!hi._shouldSurroundChar(e,n)||!e.surroundingPairs.hasOwnProperty(n))return!1;const o=Wt(n);for(const e of i){if(e.isEmpty())return!1;let i=!0;for(let n=e.startLineNumber;n<=e.endLineNumber;n++){const o=t.getLineContent(n),s=n===e.startLineNumber?e.startColumn-1:0,r=n===e.endLineNumber?e.endColumn-1:o.length,a=o.substring(s,r);if(/[^ \t]/.test(a)){i=!1;break}}if(i)return!1;if(o&&e.startLineNumber===e.endLineNumber&&e.startColumn+1===e.endColumn&&Wt(t.getValueInRange(e)))return!1}return!0}static _runSurroundSelectionType(e,t,i,n,o){const s=[];for(let e=0,i=n.length;e<i;e++){const i=n[e],r=t.surroundingPairs[o];s[e]=new ri(i,o,r)}return new Ht(0,s,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!0})}static _isTypeInterceptorElectricChar(e,t,i){return!(1!==i.length||!t.tokenization.isCheapToTokenize(i[0].getEndPosition().lineNumber))}static _typeInterceptorElectricChar(e,t,i,n,o){if(!t.electricChars.hasOwnProperty(o)||!n.isEmpty())return null;const s=n.getPosition();i.tokenization.forceTokenization(s.lineNumber);const r=i.tokenization.getLineTokens(s.lineNumber);let a;try{a=t.onElectricCharacter(o,r,s.column)}catch(e){return(0,u.dz)(e),null}if(!a)return null;if(a.matchOpenBracket){const n=(r.getLineContent()+o).lastIndexOf(a.matchOpenBracket)+1,l=i.bracketPairs.findMatchingBracketUp(a.matchOpenBracket,{lineNumber:s.lineNumber,column:n},500);if(l){if(l.startLineNumber===s.lineNumber)return null;const n=i.getLineContent(l.startLineNumber),r=tt.UU(n),a=t.normalizeIndentation(r),h=i.getLineContent(s.lineNumber),c=i.getLineFirstNonWhitespaceColumn(s.lineNumber)||s.column,d=a+h.substring(c-1,s.column-1)+o,u=new xe.Q(s.lineNumber,1,s.lineNumber,s.column),g=new Ut(u,d);return new Ht(ui(d,e),[g],{shouldPushStackElementBefore:!1,shouldPushStackElementAfter:!0})}}return null}static compositionEndWithInterceptors(e,t,i,n,o,s){if(!n)return null;let r=null;for(const e of n)if(null===r)r=e.insertedText;else if(r!==e.insertedText)return null;if(!r||1!==r.length)return null;const a=r;let l=!1;for(const e of n)if(0!==e.deletedText.length){l=!0;break}if(l){if(!hi._shouldSurroundChar(t,a)||!t.surroundingPairs.hasOwnProperty(a))return null;const e=Wt(a);for(const t of n){if(0!==t.deletedSelectionStart||t.deletedSelectionEnd!==t.deletedText.length)return null;if(/^[ \t]+$/.test(t.deletedText))return null;if(e&&Wt(t.deletedText))return null}const i=[];for(const e of o){if(!e.isEmpty())return null;i.push(e.getPosition())}if(i.length!==n.length)return null;const s=[];for(let e=0,o=i.length;e<o;e++)s.push(new ai(i[e],n[e].deletedText,t.surroundingPairs[a]));return new Ht(4,s,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!1})}if(this._isAutoClosingOvertype(t,i,o,s,a)){const e=o.map((e=>new Ut(new xe.Q(e.positionLineNumber,e.positionColumn,e.positionLineNumber,e.positionColumn+1),"",!1)));return new Ht(4,e,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!1})}const h=this._getAutoClosingPairClose(t,i,o,a,!0);return null!==h?this._runAutoClosingOpenCharType(e,t,i,o,a,!0,h):null}static typeWithInterceptors(e,t,i,n,o,s,r){if(!e&&"\n"===r){const e=[];for(let t=0,s=o.length;t<s;t++)e[t]=hi._enter(i,n,!1,o[t]);return new Ht(4,e,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!1})}if(!e&&this._isAutoIndentType(i,n,o)){const e=[];let t=!1;for(let s=0,a=o.length;s<a;s++)if(e[s]=this._runAutoIndentType(i,n,o[s],r),!e[s]){t=!0;break}if(!t)return new Ht(4,e,{shouldPushStackElementBefore:!0,shouldPushStackElementAfter:!1})}if(this._isAutoClosingOvertype(i,n,o,s,r))return this._runAutoClosingOvertype(t,i,n,o,r);if(!e){const e=this._getAutoClosingPairClose(i,n,o,r,!1);if(e)return this._runAutoClosingOpenCharType(t,i,n,o,r,!1,e)}if(!e&&this._isSurroundSelectionType(i,n,o,r))return this._runSurroundSelectionType(t,i,n,o,r);if(!e&&this._isTypeInterceptorElectricChar(i,n,o)){const e=this._typeInterceptorElectricChar(t,i,n,o[0],r);if(e)return e}const a=[];for(let e=0,t=o.length;e<t;e++)a[e]=new Ut(o[e],r);const l=ui(r,t);return new Ht(l,a,{shouldPushStackElementBefore:gi(t,l),shouldPushStackElementAfter:!1})}static typeWithoutInterceptors(e,t,i,n,o){const s=[];for(let e=0,t=n.length;e<t;e++)s[e]=new Ut(n[e],o);const r=ui(o,e);return new Ht(r,s,{shouldPushStackElementBefore:gi(e,r),shouldPushStackElementAfter:!1})}static lineInsertBefore(e,t,i){if(null===t||null===i)return[];const n=[];for(let o=0,s=i.length;o<s;o++){let s=i[o].positionLineNumber;if(1===s)n[o]=new jt(new xe.Q(1,1,1,1),"\n");else{s--;const i=t.getLineMaxColumn(s);n[o]=this._enter(e,t,!1,new xe.Q(s,i,s,i))}}return n}static lineInsertAfter(e,t,i){if(null===t||null===i)return[];const n=[];for(let o=0,s=i.length;o<s;o++){const s=i[o].positionLineNumber,r=t.getLineMaxColumn(s);n[o]=this._enter(e,t,!1,new xe.Q(s,r,s,r))}return n}static lineBreakInsert(e,t,i){const n=[];for(let o=0,s=i.length;o<s;o++)n[o]=this._enter(e,t,!0,i[o]);return n}}class ci extends Gt{constructor(e,t,i,n){super(e,(i?t:"")+n,0,-n.length),this._openCharacter=t,this._closeCharacter=n,this.closeCharacterRange=null,this.enclosingRange=null}computeCursorState(e,t){const i=t.getInverseEditOperations()[0].range;return this.closeCharacterRange=new xe.Q(i.startLineNumber,i.endColumn-this._closeCharacter.length,i.endLineNumber,i.endColumn),this.enclosingRange=new xe.Q(i.startLineNumber,i.endColumn-this._openCharacter.length-this._closeCharacter.length,i.endLineNumber,i.endColumn),super.computeCursorState(e,t)}}class di{constructor(e,t,i,n,o,s){this.deletedText=e,this.deletedSelectionStart=t,this.deletedSelectionEnd=i,this.insertedText=n,this.insertedSelectionStart=o,this.insertedSelectionEnd=s}}function ui(e,t){return" "===e?5===t||6===t?6:5:4}function gi(e,t){return!(!pi(e)||pi(t))||5!==e&&mi(e)!==mi(t)}function mi(e){return 6===e||5===e?"space":e}function pi(e){return 4===e||5===e||6===e}var fi,Ai,_i,wi=i(3952),bi=i(6690),vi=i(3815);class Ci extends o.DX{runEditorCommand(e,t,i){const n=t._getViewModel();n&&this.runCoreEditorCommand(n,i||{})}}!function(e){e.description={description:"Scroll editor in the given direction",args:[{name:"Editor scroll argument object",description:"Property-value pairs that can be passed through this argument:\n\t\t\t\t\t* 'to': A mandatory direction value.\n\t\t\t\t\t\t```\n\t\t\t\t\t\t'up', 'down'\n\t\t\t\t\t\t```\n\t\t\t\t\t* 'by': Unit to move. Default is computed based on 'to' value.\n\t\t\t\t\t\t```\n\t\t\t\t\t\t'line', 'wrappedLine', 'page', 'halfPage', 'editor'\n\t\t\t\t\t\t```\n\t\t\t\t\t* 'value': Number of units to move. Default is '1'.\n\t\t\t\t\t* 'revealCursor': If 'true' reveals the cursor if it is outside view port.\n\t\t\t\t",constraint:function(e){if(!Lt.Gv(e))return!1;const t=e;return!(!Lt.Kg(t.to)||!Lt.b0(t.by)&&!Lt.Kg(t.by)||!Lt.b0(t.value)&&!Lt.Et(t.value)||!Lt.b0(t.revealCursor)&&!Lt.Lm(t.revealCursor))},schema:{type:"object",required:["to"],properties:{to:{type:"string",enum:["up","down"]},by:{type:"string",enum:["line","wrappedLine","page","halfPage","editor"]},value:{type:"number",default:1},revealCursor:{type:"boolean"}}}}]},e.RawDirection={Up:"up",Right:"right",Down:"down",Left:"left"},e.RawUnit={Line:"line",WrappedLine:"wrappedLine",Page:"page",HalfPage:"halfPage",Editor:"editor",Column:"column"},e.parse=function(t){let i,n;switch(t.to){case e.RawDirection.Up:i=1;break;case e.RawDirection.Right:i=2;break;case e.RawDirection.Down:i=3;break;case e.RawDirection.Left:i=4;break;default:return null}switch(t.by){case e.RawUnit.Line:n=1;break;case e.RawUnit.WrappedLine:n=2;break;case e.RawUnit.Page:n=3;break;case e.RawUnit.HalfPage:n=4;break;case e.RawUnit.Editor:n=5;break;case e.RawUnit.Column:n=6;break;default:n=2}return{direction:i,unit:n,value:Math.floor(t.value||1),revealCursor:!!t.revealCursor,select:!!t.select}}}(fi||(fi={})),function(e){e.description={description:"Reveal the given line at the given logical position",args:[{name:"Reveal line argument object",description:"Property-value pairs that can be passed through this argument:\n\t\t\t\t\t* 'lineNumber': A mandatory line number value.\n\t\t\t\t\t* 'at': Logical position at which line has to be revealed.\n\t\t\t\t\t\t```\n\t\t\t\t\t\t'top', 'center', 'bottom'\n\t\t\t\t\t\t```\n\t\t\t\t",constraint:function(e){if(!Lt.Gv(e))return!1;const t=e;return!(!Lt.Et(t.lineNumber)&&!Lt.Kg(t.lineNumber)||!Lt.b0(t.at)&&!Lt.Kg(t.at))},schema:{type:"object",required:["lineNumber"],properties:{lineNumber:{type:["number","string"]},at:{type:"string",enum:["top","center","bottom"]}}}}]},e.RawAtArgument={Top:"top",Center:"center",Bottom:"bottom"}}(Ai||(Ai={}));class yi{constructor(e){e.addImplementation(1e4,"code-editor",((e,t)=>{const i=e.get(O.T).getFocusedCodeEditor();return!(!i||!i.hasTextFocus())&&this._runEditorCommand(e,i,t)})),e.addImplementation(1e3,"generic-dom-input-textarea",((e,t)=>{const i=document.activeElement;return!!(i&&["input","textarea"].indexOf(i.tagName.toLowerCase())>=0)&&(this.runDOMCommand(),!0)})),e.addImplementation(0,"generic-dom",((e,t)=>{const i=e.get(O.T).getActiveCodeEditor();return!!i&&(i.focus(),this._runEditorCommand(e,i,t))}))}_runEditorCommand(e,t,i){return this.runEditorCommand(e,t,i)||!0}}!function(e){class t extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){t.position&&(e.model.pushStackElement(),e.setCursorStates(t.source,3,[Xt.moveTo(e,e.getPrimaryCursorState(),this._inSelectionMode,t.position,t.viewPosition)])&&2!==t.revealType&&e.revealPrimaryCursor(t.source,!0,!0))}}e.MoveTo=(0,o.E_)(new t({id:"_moveTo",inSelectionMode:!1,precondition:void 0})),e.MoveToSelect=(0,o.E_)(new t({id:"_moveToSelect",inSelectionMode:!0,precondition:void 0}));class i extends Ci{runCoreEditorCommand(e,t){e.model.pushStackElement();const i=this._getColumnSelectResult(e,e.getPrimaryCursorState(),e.getCursorColumnSelectData(),t);null!==i&&(e.setCursorStates(t.source,3,i.viewStates.map((e=>Ot.fromViewState(e)))),e.setCursorColumnSelectData({isReal:!0,fromViewLineNumber:i.fromLineNumber,fromViewVisualColumn:i.fromVisualColumn,toViewLineNumber:i.toLineNumber,toViewVisualColumn:i.toVisualColumn}),i.reversed?e.revealTopMostCursor(t.source):e.revealBottomMostCursor(t.source))}}e.ColumnSelect=(0,o.E_)(new class extends i{constructor(){super({id:"columnSelect",precondition:void 0})}_getColumnSelectResult(e,t,i,n){if(void 0===n.position||void 0===n.viewPosition||void 0===n.mouseColumn)return null;const o=e.model.validatePosition(n.position),s=e.coordinatesConverter.validateViewPosition(new De.y(n.viewPosition.lineNumber,n.viewPosition.column),o),r=n.doColumnSelect?i.fromViewLineNumber:s.lineNumber,a=n.doColumnSelect?i.fromViewVisualColumn:n.mouseColumn-1;return Vt.columnSelect(e.cursorConfig,e,r,a,s.lineNumber,n.mouseColumn-1)}}),e.CursorColumnSelectLeft=(0,o.E_)(new class extends i{constructor(){super({id:"cursorColumnSelectLeft",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3599,linux:{primary:0}}})}_getColumnSelectResult(e,t,i,n){return Vt.columnSelectLeft(e.cursorConfig,e,i)}}),e.CursorColumnSelectRight=(0,o.E_)(new class extends i{constructor(){super({id:"cursorColumnSelectRight",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3601,linux:{primary:0}}})}_getColumnSelectResult(e,t,i,n){return Vt.columnSelectRight(e.cursorConfig,e,i)}});class n extends i{constructor(e){super(e),this._isPaged=e.isPaged}_getColumnSelectResult(e,t,i,n){return Vt.columnSelectUp(e.cursorConfig,e,i,this._isPaged)}}e.CursorColumnSelectUp=(0,o.E_)(new n({isPaged:!1,id:"cursorColumnSelectUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3600,linux:{primary:0}}})),e.CursorColumnSelectPageUp=(0,o.E_)(new n({isPaged:!0,id:"cursorColumnSelectPageUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3595,linux:{primary:0}}}));class s extends i{constructor(e){super(e),this._isPaged=e.isPaged}_getColumnSelectResult(e,t,i,n){return Vt.columnSelectDown(e.cursorConfig,e,i,this._isPaged)}}e.CursorColumnSelectDown=(0,o.E_)(new s({isPaged:!1,id:"cursorColumnSelectDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3602,linux:{primary:0}}})),e.CursorColumnSelectPageDown=(0,o.E_)(new s({isPaged:!0,id:"cursorColumnSelectPageDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3596,linux:{primary:0}}}));class r extends Ci{constructor(){super({id:"cursorMove",precondition:void 0,description:Zt.description})}runCoreEditorCommand(e,t){const i=Zt.parse(t);i&&this._runCursorMove(e,t.source,i)}_runCursorMove(e,t,i){e.model.pushStackElement(),e.setCursorStates(t,3,r._move(e,e.getCursorStates(),i)),e.revealPrimaryCursor(t,!0)}static _move(e,t,i){const n=i.select,o=i.value;switch(i.direction){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:return Xt.simpleMove(e,t,i.direction,n,o,i.unit);case 11:case 13:case 12:case 14:return Xt.viewportMove(e,t,i.direction,n,o);default:return null}}}e.CursorMoveImpl=r,e.CursorMove=(0,o.E_)(new r);class a extends Ci{constructor(e){super(e),this._staticArgs=e.args}runCoreEditorCommand(e,t){let i=this._staticArgs;-1===this._staticArgs.value&&(i={direction:this._staticArgs.direction,unit:this._staticArgs.unit,select:this._staticArgs.select,value:t.pageSize||e.cursorConfig.pageSize}),e.model.pushStackElement(),e.setCursorStates(t.source,3,Xt.simpleMove(e,e.getCursorStates(),i.direction,i.select,i.value,i.unit)),e.revealPrimaryCursor(t.source,!0)}}e.CursorLeft=(0,o.E_)(new a({args:{direction:0,unit:0,select:!1,value:1},id:"cursorLeft",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:15,mac:{primary:15,secondary:[288]}}})),e.CursorLeftSelect=(0,o.E_)(new a({args:{direction:0,unit:0,select:!0,value:1},id:"cursorLeftSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1039}})),e.CursorRight=(0,o.E_)(new a({args:{direction:1,unit:0,select:!1,value:1},id:"cursorRight",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:17,mac:{primary:17,secondary:[292]}}})),e.CursorRightSelect=(0,o.E_)(new a({args:{direction:1,unit:0,select:!0,value:1},id:"cursorRightSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1041}})),e.CursorUp=(0,o.E_)(new a({args:{direction:2,unit:2,select:!1,value:1},id:"cursorUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:16,mac:{primary:16,secondary:[302]}}})),e.CursorUpSelect=(0,o.E_)(new a({args:{direction:2,unit:2,select:!0,value:1},id:"cursorUpSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1040,secondary:[3088],mac:{primary:1040},linux:{primary:1040}}})),e.CursorPageUp=(0,o.E_)(new a({args:{direction:2,unit:2,select:!1,value:-1},id:"cursorPageUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:11}})),e.CursorPageUpSelect=(0,o.E_)(new a({args:{direction:2,unit:2,select:!0,value:-1},id:"cursorPageUpSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1035}})),e.CursorDown=(0,o.E_)(new a({args:{direction:3,unit:2,select:!1,value:1},id:"cursorDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:18,mac:{primary:18,secondary:[300]}}})),e.CursorDownSelect=(0,o.E_)(new a({args:{direction:3,unit:2,select:!0,value:1},id:"cursorDownSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1042,secondary:[3090],mac:{primary:1042},linux:{primary:1042}}})),e.CursorPageDown=(0,o.E_)(new a({args:{direction:3,unit:2,select:!1,value:-1},id:"cursorPageDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:12}})),e.CursorPageDownSelect=(0,o.E_)(new a({args:{direction:3,unit:2,select:!0,value:-1},id:"cursorPageDownSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1036}})),e.CreateCursor=(0,o.E_)(new class extends Ci{constructor(){super({id:"createCursor",precondition:void 0})}runCoreEditorCommand(e,t){if(!t.position)return;let i;i=t.wholeLine?Xt.line(e,e.getPrimaryCursorState(),!1,t.position,t.viewPosition):Xt.moveTo(e,e.getPrimaryCursorState(),!1,t.position,t.viewPosition);const n=e.getCursorStates();if(n.length>1){const o=i.modelState?i.modelState.position:null,s=i.viewState?i.viewState.position:null;for(let i=0,r=n.length;i<r;i++){const r=n[i];if((!o||r.modelState.selection.containsPosition(o))&&(!s||r.viewState.selection.containsPosition(s)))return n.splice(i,1),e.model.pushStackElement(),void e.setCursorStates(t.source,3,n)}}n.push(i),e.model.pushStackElement(),e.setCursorStates(t.source,3,n)}}),e.LastCursorMoveToSelect=(0,o.E_)(new class extends Ci{constructor(){super({id:"_lastCursorMoveToSelect",precondition:void 0})}runCoreEditorCommand(e,t){if(!t.position)return;const i=e.getLastAddedCursorIndex(),n=e.getCursorStates(),o=n.slice(0);o[i]=Xt.moveTo(e,n[i],!0,t.position,t.viewPosition),e.model.pushStackElement(),e.setCursorStates(t.source,3,o)}});class l extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,Xt.moveToBeginningOfLine(e,e.getCursorStates(),this._inSelectionMode)),e.revealPrimaryCursor(t.source,!0)}}e.CursorHome=(0,o.E_)(new l({inSelectionMode:!1,id:"cursorHome",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:14,mac:{primary:14,secondary:[2063]}}})),e.CursorHomeSelect=(0,o.E_)(new l({inSelectionMode:!0,id:"cursorHomeSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1038,mac:{primary:1038,secondary:[3087]}}}));class h extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,this._exec(e.getCursorStates())),e.revealPrimaryCursor(t.source,!0)}_exec(e){const t=[];for(let i=0,n=e.length;i<n;i++){const n=e[i],o=n.modelState.position.lineNumber;t[i]=Ot.fromModelState(n.modelState.move(this._inSelectionMode,o,1,0))}return t}}e.CursorLineStart=(0,o.E_)(new h({inSelectionMode:!1,id:"cursorLineStart",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:0,mac:{primary:287}}})),e.CursorLineStartSelect=(0,o.E_)(new h({inSelectionMode:!0,id:"cursorLineStartSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:0,mac:{primary:1311}}}));class d extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,Xt.moveToEndOfLine(e,e.getCursorStates(),this._inSelectionMode,t.sticky||!1)),e.revealPrimaryCursor(t.source,!0)}}e.CursorEnd=(0,o.E_)(new d({inSelectionMode:!1,id:"cursorEnd",precondition:void 0,kbOpts:{args:{sticky:!1},weight:0,kbExpr:wi.R.textInputFocus,primary:13,mac:{primary:13,secondary:[2065]}},description:{description:"Go to End",args:[{name:"args",schema:{type:"object",properties:{sticky:{description:c.kg("stickydesc","Stick to the end even when going to longer lines"),type:"boolean",default:!1}}}}]}})),e.CursorEndSelect=(0,o.E_)(new d({inSelectionMode:!0,id:"cursorEndSelect",precondition:void 0,kbOpts:{args:{sticky:!1},weight:0,kbExpr:wi.R.textInputFocus,primary:1037,mac:{primary:1037,secondary:[3089]}},description:{description:"Select to End",args:[{name:"args",schema:{type:"object",properties:{sticky:{description:c.kg("stickydesc","Stick to the end even when going to longer lines"),type:"boolean",default:!1}}}}]}}));class u extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,this._exec(e,e.getCursorStates())),e.revealPrimaryCursor(t.source,!0)}_exec(e,t){const i=[];for(let n=0,o=t.length;n<o;n++){const o=t[n],s=o.modelState.position.lineNumber,r=e.model.getLineMaxColumn(s);i[n]=Ot.fromModelState(o.modelState.move(this._inSelectionMode,s,r,0))}return i}}e.CursorLineEnd=(0,o.E_)(new u({inSelectionMode:!1,id:"cursorLineEnd",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:0,mac:{primary:291}}})),e.CursorLineEndSelect=(0,o.E_)(new u({inSelectionMode:!0,id:"cursorLineEndSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:0,mac:{primary:1315}}}));class g extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,Xt.moveToBeginningOfBuffer(e,e.getCursorStates(),this._inSelectionMode)),e.revealPrimaryCursor(t.source,!0)}}e.CursorTop=(0,o.E_)(new g({inSelectionMode:!1,id:"cursorTop",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2062,mac:{primary:2064}}})),e.CursorTopSelect=(0,o.E_)(new g({inSelectionMode:!0,id:"cursorTopSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3086,mac:{primary:3088}}}));class m extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,Xt.moveToEndOfBuffer(e,e.getCursorStates(),this._inSelectionMode)),e.revealPrimaryCursor(t.source,!0)}}e.CursorBottom=(0,o.E_)(new m({inSelectionMode:!1,id:"cursorBottom",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2061,mac:{primary:2066}}})),e.CursorBottomSelect=(0,o.E_)(new m({inSelectionMode:!0,id:"cursorBottomSelect",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:3085,mac:{primary:3090}}}));class p extends Ci{constructor(){super({id:"editorScroll",precondition:void 0,description:fi.description})}determineScrollMethod(e){return[6].includes(e.unit)&&[4,2].includes(e.direction)?this._runHorizontalEditorScroll.bind(this):[1,2,3,4,5,6].includes(e.unit)&&[1,3].includes(e.direction)?this._runVerticalEditorScroll.bind(this):null}runCoreEditorCommand(e,t){const i=fi.parse(t);if(!i)return;const n=this.determineScrollMethod(i);n&&n(e,t.source,i)}_runVerticalEditorScroll(e,t,i){const n=this._computeDesiredScrollTop(e,i);if(i.revealCursor){const o=e.getCompletelyVisibleViewRangeAtScrollTop(n);e.setCursorStates(t,3,[Xt.findPositionInViewportIfOutside(e,e.getPrimaryCursorState(),o,i.select)])}e.viewLayout.setScrollPosition({scrollTop:n},0)}_computeDesiredScrollTop(e,t){if(1===t.unit){const i=e.viewLayout.getFutureViewport(),n=e.getCompletelyVisibleViewRangeAtScrollTop(i.top),o=e.coordinatesConverter.convertViewRangeToModelRange(n);let s;s=1===t.direction?Math.max(1,o.startLineNumber-t.value):Math.min(e.model.getLineCount(),o.startLineNumber+t.value);const r=e.coordinatesConverter.convertModelPositionToViewPosition(new De.y(s,1));return e.viewLayout.getVerticalOffsetForLineNumber(r.lineNumber)}if(5===t.unit){let i=0;return 3===t.direction&&(i=e.model.getLineCount()-e.cursorConfig.pageSize),e.viewLayout.getVerticalOffsetForLineNumber(i)}let i;i=3===t.unit?e.cursorConfig.pageSize*t.value:4===t.unit?Math.round(e.cursorConfig.pageSize/2)*t.value:t.value;const n=(1===t.direction?-1:1)*i;return e.viewLayout.getCurrentScrollTop()+n*e.cursorConfig.lineHeight}_runHorizontalEditorScroll(e,t,i){const n=this._computeDesiredScrollLeft(e,i);e.viewLayout.setScrollPosition({scrollLeft:n},0)}_computeDesiredScrollLeft(e,t){const i=(4===t.direction?-1:1)*t.value;return e.viewLayout.getCurrentScrollLeft()+i*e.cursorConfig.typicalHalfwidthCharacterWidth}}e.EditorScrollImpl=p,e.EditorScroll=(0,o.E_)(new p),e.ScrollLineUp=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollLineUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2064,mac:{primary:267}}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Up,by:fi.RawUnit.WrappedLine,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollPageUp=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollPageUp",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2059,win:{primary:523},linux:{primary:523}}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Up,by:fi.RawUnit.Page,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollEditorTop=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollEditorTop",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Up,by:fi.RawUnit.Editor,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollLineDown=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollLineDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2066,mac:{primary:268}}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Down,by:fi.RawUnit.WrappedLine,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollPageDown=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollPageDown",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:2060,win:{primary:524},linux:{primary:524}}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Down,by:fi.RawUnit.Page,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollEditorBottom=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollEditorBottom",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Down,by:fi.RawUnit.Editor,value:1,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollLeft=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollLeft",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Left,by:fi.RawUnit.Column,value:2,revealCursor:!1,select:!1,source:i.source})}}),e.ScrollRight=(0,o.E_)(new class extends Ci{constructor(){super({id:"scrollRight",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus}})}runCoreEditorCommand(t,i){e.EditorScroll.runCoreEditorCommand(t,{to:fi.RawDirection.Right,by:fi.RawUnit.Column,value:2,revealCursor:!1,select:!1,source:i.source})}});class A extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){t.position&&(e.model.pushStackElement(),e.setCursorStates(t.source,3,[Xt.word(e,e.getPrimaryCursorState(),this._inSelectionMode,t.position)]),2!==t.revealType&&e.revealPrimaryCursor(t.source,!0,!0))}}e.WordSelect=(0,o.E_)(new A({inSelectionMode:!1,id:"_wordSelect",precondition:void 0})),e.WordSelectDrag=(0,o.E_)(new A({inSelectionMode:!0,id:"_wordSelectDrag",precondition:void 0})),e.LastCursorWordSelect=(0,o.E_)(new class extends Ci{constructor(){super({id:"lastCursorWordSelect",precondition:void 0})}runCoreEditorCommand(e,t){if(!t.position)return;const i=e.getLastAddedCursorIndex(),n=e.getCursorStates(),o=n.slice(0),s=n[i];o[i]=Xt.word(e,s,s.modelState.hasSelection(),t.position),e.model.pushStackElement(),e.setCursorStates(t.source,3,o)}});class _ extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){t.position&&(e.model.pushStackElement(),e.setCursorStates(t.source,3,[Xt.line(e,e.getPrimaryCursorState(),this._inSelectionMode,t.position,t.viewPosition)]),2!==t.revealType&&e.revealPrimaryCursor(t.source,!1,!0))}}e.LineSelect=(0,o.E_)(new _({inSelectionMode:!1,id:"_lineSelect",precondition:void 0})),e.LineSelectDrag=(0,o.E_)(new _({inSelectionMode:!0,id:"_lineSelectDrag",precondition:void 0}));class w extends Ci{constructor(e){super(e),this._inSelectionMode=e.inSelectionMode}runCoreEditorCommand(e,t){if(!t.position)return;const i=e.getLastAddedCursorIndex(),n=e.getCursorStates(),o=n.slice(0);o[i]=Xt.line(e,n[i],this._inSelectionMode,t.position,t.viewPosition),e.model.pushStackElement(),e.setCursorStates(t.source,3,o)}}e.LastCursorLineSelect=(0,o.E_)(new w({inSelectionMode:!1,id:"lastCursorLineSelect",precondition:void 0})),e.LastCursorLineSelectDrag=(0,o.E_)(new w({inSelectionMode:!0,id:"lastCursorLineSelectDrag",precondition:void 0})),e.CancelSelection=(0,o.E_)(new class extends Ci{constructor(){super({id:"cancelSelection",precondition:wi.R.hasNonEmptySelection,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:9,secondary:[1033]}})}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,[Xt.cancelSelection(e,e.getPrimaryCursorState())]),e.revealPrimaryCursor(t.source,!0)}}),e.RemoveSecondaryCursors=(0,o.E_)(new class extends Ci{constructor(){super({id:"removeSecondaryCursors",precondition:wi.R.hasMultipleSelections,kbOpts:{weight:1,kbExpr:wi.R.textInputFocus,primary:9,secondary:[1033]}})}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates(t.source,3,[e.getPrimaryCursorState()]),e.revealPrimaryCursor(t.source,!0),(0,Mt.h5)(c.kg("removedCursor","Removed secondary cursors"))}}),e.RevealLine=(0,o.E_)(new class extends Ci{constructor(){super({id:"revealLine",precondition:void 0,description:Ai.description})}runCoreEditorCommand(e,t){const i=t,n=i.lineNumber||0;let o="number"==typeof n?n+1:parseInt(n)+1;o<1&&(o=1);const s=e.model.getLineCount();o>s&&(o=s);const r=new xe.Q(o,1,o,e.model.getLineMaxColumn(o));let a=0;if(i.at)switch(i.at){case Ai.RawAtArgument.Top:a=3;break;case Ai.RawAtArgument.Center:a=1;break;case Ai.RawAtArgument.Bottom:a=4}const l=e.coordinatesConverter.convertModelRangeToViewRange(r);e.revealRange(t.source,!1,l,a,0)}}),e.SelectAll=new class extends yi{constructor(){super(o.tc)}runDOMCommand(){f.isFirefox&&(document.activeElement.focus(),document.activeElement.select()),document.execCommand("selectAll")}runEditorCommand(e,t,i){const n=t._getViewModel();n&&this.runCoreEditorCommand(n,i)}runCoreEditorCommand(e,t){e.model.pushStackElement(),e.setCursorStates("keyboard",3,[Xt.selectAll(e,e.getPrimaryCursorState())])}},e.SetSelection=(0,o.E_)(new class extends Ci{constructor(){super({id:"setSelection",precondition:void 0})}runCoreEditorCommand(e,t){t.selection&&(e.model.pushStackElement(),e.setCursorStates(t.source,3,[Ot.fromModelSelection(t.selection)]))}})}(_i||(_i={}));const Si=bi.M$.and(wi.R.textInputFocus,wi.R.columnSelection);function ki(e,t){vi.f.registerKeybindingRule({id:e,primary:t,when:Si,weight:1})}function Ei(e){return e.register(),e}var Di;ki(_i.CursorColumnSelectLeft.id,1039),ki(_i.CursorColumnSelectRight.id,1041),ki(_i.CursorColumnSelectUp.id,1040),ki(_i.CursorColumnSelectPageUp.id,1035),ki(_i.CursorColumnSelectDown.id,1042),ki(_i.CursorColumnSelectPageDown.id,1036),function(e){class t extends o.DX{runEditorCommand(e,t,i){const n=t._getViewModel();n&&this.runCoreEditingCommand(t,n,i||{})}}e.CoreEditingCommand=t,e.LineBreakInsert=(0,o.E_)(new class extends t{constructor(){super({id:"lineBreakInsert",precondition:wi.R.writable,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:0,mac:{primary:301}}})}runCoreEditingCommand(e,t,i){e.pushUndoStop(),e.executeCommands(this.id,hi.lineBreakInsert(t.cursorConfig,t.model,t.getCursorStates().map((e=>e.modelState.selection))))}}),e.Outdent=(0,o.E_)(new class extends t{constructor(){super({id:"outdent",precondition:wi.R.writable,kbOpts:{weight:0,kbExpr:bi.M$.and(wi.R.editorTextFocus,wi.R.tabDoesNotMoveFocus),primary:1026}})}runCoreEditingCommand(e,t,i){e.pushUndoStop(),e.executeCommands(this.id,hi.outdent(t.cursorConfig,t.model,t.getCursorStates().map((e=>e.modelState.selection)))),e.pushUndoStop()}}),e.Tab=(0,o.E_)(new class extends t{constructor(){super({id:"tab",precondition:wi.R.writable,kbOpts:{weight:0,kbExpr:bi.M$.and(wi.R.editorTextFocus,wi.R.tabDoesNotMoveFocus),primary:2}})}runCoreEditingCommand(e,t,i){e.pushUndoStop(),e.executeCommands(this.id,hi.tab(t.cursorConfig,t.model,t.getCursorStates().map((e=>e.modelState.selection)))),e.pushUndoStop()}}),e.DeleteLeft=(0,o.E_)(new class extends t{constructor(){super({id:"deleteLeft",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:1,secondary:[1025],mac:{primary:1,secondary:[1025,294,257]}}})}runCoreEditingCommand(e,t,i){const[n,o]=qt.deleteLeft(t.getPrevEditOperationType(),t.cursorConfig,t.model,t.getCursorStates().map((e=>e.modelState.selection)),t.getCursorAutoClosedCharacters());n&&e.pushUndoStop(),e.executeCommands(this.id,o),t.setPrevEditOperationType(2)}}),e.DeleteRight=(0,o.E_)(new class extends t{constructor(){super({id:"deleteRight",precondition:void 0,kbOpts:{weight:0,kbExpr:wi.R.textInputFocus,primary:20,mac:{primary:20,secondary:[290,276]}}})}runCoreEditingCommand(e,t,i){const[n,o]=qt.deleteRight(t.getPrevEditOperationType(),t.cursorConfig,t.model,t.getCursorStates().map((e=>e.modelState.selection)));n&&e.pushUndoStop(),e.executeCommands(this.id,o),t.setPrevEditOperationType(3)}}),e.Undo=new class extends yi{constructor(){super(o.aU)}runDOMCommand(){document.execCommand("undo")}runEditorCommand(e,t,i){if(t.hasModel()&&!0!==t.getOption(88))return t.getModel().undo()}},e.Redo=new class extends yi{constructor(){super(o.ih)}runDOMCommand(){document.execCommand("redo")}runEditorCommand(e,t,i){if(t.hasModel()&&!0!==t.getOption(88))return t.getModel().redo()}}}(Di||(Di={}));class xi extends o.uB{constructor(e,t,i){super({id:e,precondition:void 0,description:i}),this._handlerId=t}runCommand(e,t){const i=e.get(O.T).getFocusedCodeEditor();i&&i.trigger("keyboard",this._handlerId,t)}}function Li(e,t){Ei(new xi("default:"+e,e)),Ei(new xi(e,e,t))}Li("type",{description:"Type",args:[{name:"args",schema:{type:"object",required:["text"],properties:{text:{type:"string"}}}}]}),Li("replacePreviousChar"),Li("compositionType"),Li("compositionStart"),Li("compositionEnd"),Li("paste"),Li("cut");class Mi{constructor(e,t,i,n){this.configuration=e,this.viewModel=t,this.userInputEvents=i,this.commandDelegate=n}paste(e,t,i,n){this.commandDelegate.paste(e,t,i,n)}type(e){this.commandDelegate.type(e)}compositionType(e,t,i,n){this.commandDelegate.compositionType(e,t,i,n)}compositionStart(){this.commandDelegate.startComposition()}compositionEnd(){this.commandDelegate.endComposition()}cut(){this.commandDelegate.cut()}setSelection(e){_i.SetSelection.runCoreEditorCommand(this.viewModel,{source:"keyboard",selection:e})}_validateViewColumn(e){const t=this.viewModel.getLineMinColumn(e.lineNumber);return e.column<t?new De.y(e.lineNumber,t):e}_hasMulticursorModifier(e){switch(this.configuration.options.get(75)){case"altKey":return e.altKey;case"ctrlKey":return e.ctrlKey;case"metaKey":return e.metaKey;default:return!1}}_hasNonMulticursorModifier(e){switch(this.configuration.options.get(75)){case"altKey":return e.ctrlKey||e.metaKey;case"ctrlKey":return e.altKey||e.metaKey;case"metaKey":return e.ctrlKey||e.altKey;default:return!1}}dispatchMouse(e){const t=this.configuration.options,i=w.j9&&t.get(103),n=t.get(20);e.middleButton&&!i?this._columnSelect(e.position,e.mouseColumn,e.inSelectionMode):e.startedOnLineNumbers?this._hasMulticursorModifier(e)?e.inSelectionMode?this._lastCursorLineSelect(e.position,e.revealType):this._createCursor(e.position,!0):e.inSelectionMode?this._lineSelectDrag(e.position,e.revealType):this._lineSelect(e.position,e.revealType):e.mouseDownCount>=4?this._selectAll():3===e.mouseDownCount?this._hasMulticursorModifier(e)?e.inSelectionMode?this._lastCursorLineSelectDrag(e.position,e.revealType):this._lastCursorLineSelect(e.position,e.revealType):e.inSelectionMode?this._lineSelectDrag(e.position,e.revealType):this._lineSelect(e.position,e.revealType):2===e.mouseDownCount?e.onInjectedText||(this._hasMulticursorModifier(e)?this._lastCursorWordSelect(e.position,e.revealType):e.inSelectionMode?this._wordSelectDrag(e.position,e.revealType):this._wordSelect(e.position,e.revealType)):this._hasMulticursorModifier(e)?this._hasNonMulticursorModifier(e)||(e.shiftKey?this._columnSelect(e.position,e.mouseColumn,!0):e.inSelectionMode?this._lastCursorMoveToSelect(e.position,e.revealType):this._createCursor(e.position,!1)):e.inSelectionMode?e.altKey||n?this._columnSelect(e.position,e.mouseColumn,!0):this._moveToSelect(e.position,e.revealType):this.moveTo(e.position,e.revealType)}_usualArgs(e,t){return e=this._validateViewColumn(e),{source:"mouse",position:this._convertViewToModelPosition(e),viewPosition:e,revealType:t}}moveTo(e,t){_i.MoveTo.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_moveToSelect(e,t){_i.MoveToSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_columnSelect(e,t,i){e=this._validateViewColumn(e),_i.ColumnSelect.runCoreEditorCommand(this.viewModel,{source:"mouse",position:this._convertViewToModelPosition(e),viewPosition:e,mouseColumn:t,doColumnSelect:i})}_createCursor(e,t){e=this._validateViewColumn(e),_i.CreateCursor.runCoreEditorCommand(this.viewModel,{source:"mouse",position:this._convertViewToModelPosition(e),viewPosition:e,wholeLine:t})}_lastCursorMoveToSelect(e,t){_i.LastCursorMoveToSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_wordSelect(e,t){_i.WordSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_wordSelectDrag(e,t){_i.WordSelectDrag.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_lastCursorWordSelect(e,t){_i.LastCursorWordSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_lineSelect(e,t){_i.LineSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_lineSelectDrag(e,t){_i.LineSelectDrag.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_lastCursorLineSelect(e,t){_i.LastCursorLineSelect.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_lastCursorLineSelectDrag(e,t){_i.LastCursorLineSelectDrag.runCoreEditorCommand(this.viewModel,this._usualArgs(e,t))}_selectAll(){_i.SelectAll.runCoreEditorCommand(this.viewModel,{source:"mouse"})}_convertViewToModelPosition(e){return this.viewModel.coordinatesConverter.convertViewPositionToModelPosition(e)}emitKeyDown(e){this.userInputEvents.emitKeyDown(e)}emitKeyUp(e){this.userInputEvents.emitKeyUp(e)}emitContextMenu(e){this.userInputEvents.emitContextMenu(e)}emitMouseMove(e){this.userInputEvents.emitMouseMove(e)}emitMouseLeave(e){this.userInputEvents.emitMouseLeave(e)}emitMouseUp(e){this.userInputEvents.emitMouseUp(e)}emitMouseDown(e){this.userInputEvents.emitMouseDown(e)}emitMouseDrag(e){this.userInputEvents.emitMouseDrag(e)}emitMouseDrop(e){this.userInputEvents.emitMouseDrop(e)}emitMouseDropCanceled(){this.userInputEvents.emitMouseDropCanceled()}emitMouseWheel(e){this.userInputEvents.emitMouseWheel(e)}}class Ii{constructor(e){this.onKeyDown=null,this.onKeyUp=null,this.onContextMenu=null,this.onMouseMove=null,this.onMouseLeave=null,this.onMouseDown=null,this.onMouseUp=null,this.onMouseDrag=null,this.onMouseDrop=null,this.onMouseDropCanceled=null,this.onMouseWheel=null,this._coordinatesConverter=e}emitKeyDown(e){var t;null===(t=this.onKeyDown)||void 0===t||t.call(this,e)}emitKeyUp(e){var t;null===(t=this.onKeyUp)||void 0===t||t.call(this,e)}emitContextMenu(e){var t;null===(t=this.onContextMenu)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseMove(e){var t;null===(t=this.onMouseMove)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseLeave(e){var t;null===(t=this.onMouseLeave)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseDown(e){var t;null===(t=this.onMouseDown)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseUp(e){var t;null===(t=this.onMouseUp)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseDrag(e){var t;null===(t=this.onMouseDrag)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseDrop(e){var t;null===(t=this.onMouseDrop)||void 0===t||t.call(this,this._convertViewToModelMouseEvent(e))}emitMouseDropCanceled(){var e;null===(e=this.onMouseDropCanceled)||void 0===e||e.call(this)}emitMouseWheel(e){var t;null===(t=this.onMouseWheel)||void 0===t||t.call(this,e)}_convertViewToModelMouseEvent(e){return e.target?{event:e.event,target:this._convertViewToModelMouseTarget(e.target)}:e}_convertViewToModelMouseTarget(e){return Ii.convertViewToModelMouseTarget(e,this._coordinatesConverter)}static convertViewToModelMouseTarget(e,t){const i=Object.assign({},e);return i.position&&(i.position=t.convertViewPositionToModelPosition(i.position)),i.range&&(i.range=t.convertViewRangeToModelRange(i.range)),5!==i.type&&8!==i.type||(i.detail=this.convertViewToModelViewZoneData(i.detail,t)),i}static convertViewToModelViewZoneData(e,t){return{viewZoneId:e.viewZoneId,positionBefore:e.positionBefore?t.convertViewPositionToModelPosition(e.positionBefore):e.positionBefore,positionAfter:e.positionAfter?t.convertViewPositionToModelPosition(e.positionAfter):e.positionAfter,position:t.convertViewPositionToModelPosition(e.position),afterLineNumber:t.convertViewPositionToModelPosition(new De.y(e.afterLineNumber,1)).lineNumber}}}var Bi=i(6123),Ni=i(8866);class Ti{constructor(e){this._createLine=e,this._set(1,[])}flush(){this._set(1,[])}_set(e,t){this._lines=t,this._rendLineNumberStart=e}_get(){return{rendLineNumberStart:this._rendLineNumberStart,lines:this._lines}}getStartLineNumber(){return this._rendLineNumberStart}getEndLineNumber(){return this._rendLineNumberStart+this._lines.length-1}getCount(){return this._lines.length}getLine(e){const t=e-this._rendLineNumberStart;if(t<0||t>=this._lines.length)throw new u.D7("Illegal value for lineNumber");return this._lines[t]}onLinesDeleted(e,t){if(0===this.getCount())return null;const i=this.getStartLineNumber(),n=this.getEndLineNumber();if(t<i){const i=t-e+1;return this._rendLineNumberStart-=i,null}if(e>n)return null;let o=0,s=0;for(let r=i;r<=n;r++){const i=r-this._rendLineNumberStart;e<=r&&r<=t&&(0===s?(o=i,s=1):s++)}if(e<i){let n=0;n=t<i?t-e+1:i-e,this._rendLineNumberStart-=n}return this._lines.splice(o,s)}onLinesChanged(e,t){const i=e+t-1;if(0===this.getCount())return!1;const n=this.getStartLineNumber(),o=this.getEndLineNumber();let s=!1;for(let t=e;t<=i;t++)t>=n&&t<=o&&(this._lines[t-this._rendLineNumberStart].onContentChanged(),s=!0);return s}onLinesInserted(e,t){if(0===this.getCount())return null;const i=t-e+1,n=this.getStartLineNumber(),o=this.getEndLineNumber();if(e<=n)return this._rendLineNumberStart+=i,null;if(e>o)return null;if(i+e>o)return this._lines.splice(e-this._rendLineNumberStart,o-e+1);const s=[];for(let e=0;e<i;e++)s[e]=this._createLine();const r=e-this._rendLineNumberStart,a=this._lines.slice(0,r),l=this._lines.slice(r,this._lines.length-i),h=this._lines.slice(this._lines.length-i,this._lines.length);return this._lines=a.concat(s).concat(l),h}onTokensChanged(e){if(0===this.getCount())return!1;const t=this.getStartLineNumber(),i=this.getEndLineNumber();let n=!1;for(let o=0,s=e.length;o<s;o++){const s=e[o];if(s.toLineNumber<t||s.fromLineNumber>i)continue;const r=Math.max(t,s.fromLineNumber),a=Math.min(i,s.toLineNumber);for(let e=r;e<=a;e++){const t=e-this._rendLineNumberStart;this._lines[t].onTokensChanged(),n=!0}}return n}}class Fi{constructor(e){this._host=e,this.domNode=this._createDomNode(),this._linesCollection=new Ti((()=>this._host.createVisibleLine()))}_createDomNode(){const e=(0,z.Z)(document.createElement("div"));return e.setClassName("view-layer"),e.setPosition("absolute"),e.domNode.setAttribute("role","presentation"),e.domNode.setAttribute("aria-hidden","true"),e}onConfigurationChanged(e){return!!e.hasChanged(140)}onFlushed(e){return this._linesCollection.flush(),!0}onLinesChanged(e){return this._linesCollection.onLinesChanged(e.fromLineNumber,e.count)}onLinesDeleted(e){const t=this._linesCollection.onLinesDeleted(e.fromLineNumber,e.toLineNumber);if(t)for(let e=0,i=t.length;e<i;e++){const i=t[e].getDomNode();i&&this.domNode.domNode.removeChild(i)}return!0}onLinesInserted(e){const t=this._linesCollection.onLinesInserted(e.fromLineNumber,e.toLineNumber);if(t)for(let e=0,i=t.length;e<i;e++){const i=t[e].getDomNode();i&&this.domNode.domNode.removeChild(i)}return!0}onScrollChanged(e){return e.scrollTopChanged}onTokensChanged(e){return this._linesCollection.onTokensChanged(e.ranges)}onZonesChanged(e){return!0}getStartLineNumber(){return this._linesCollection.getStartLineNumber()}getEndLineNumber(){return this._linesCollection.getEndLineNumber()}getVisibleLine(e){return this._linesCollection.getLine(e)}renderLines(e){const t=this._linesCollection._get(),i=new Ri(this.domNode.domNode,this._host,e),n={rendLineNumberStart:t.rendLineNumberStart,lines:t.lines,linesLength:t.lines.length},o=i.render(n,e.startLineNumber,e.endLineNumber,e.relativeVerticalOffset);this._linesCollection._set(o.rendLineNumberStart,o.lines)}}class Ri{constructor(e,t,i){this.domNode=e,this.host=t,this.viewportData=i}render(e,t,i,n){const o={rendLineNumberStart:e.rendLineNumberStart,lines:e.lines.slice(0),linesLength:e.linesLength};if(o.rendLineNumberStart+o.linesLength-1<t||i<o.rendLineNumberStart){o.rendLineNumberStart=t,o.linesLength=i-t+1,o.lines=[];for(let e=t;e<=i;e++)o.lines[e-t]=this.host.createVisibleLine();return this._finishRendering(o,!0,n),o}if(this._renderUntouchedLines(o,Math.max(t-o.rendLineNumberStart,0),Math.min(i-o.rendLineNumberStart,o.linesLength-1),n,t),o.rendLineNumberStart>t){const e=t,s=Math.min(i,o.rendLineNumberStart-1);e<=s&&(this._insertLinesBefore(o,e,s,n,t),o.linesLength+=s-e+1)}else if(o.rendLineNumberStart<t){const e=Math.min(o.linesLength,t-o.rendLineNumberStart);e>0&&(this._removeLinesBefore(o,e),o.linesLength-=e)}if(o.rendLineNumberStart=t,o.rendLineNumberStart+o.linesLength-1<i){const e=o.rendLineNumberStart+o.linesLength,s=i;e<=s&&(this._insertLinesAfter(o,e,s,n,t),o.linesLength+=s-e+1)}else if(o.rendLineNumberStart+o.linesLength-1>i){const e=Math.max(0,i-o.rendLineNumberStart+1),t=o.linesLength-1-e+1;t>0&&(this._removeLinesAfter(o,t),o.linesLength-=t)}return this._finishRendering(o,!1,n),o}_renderUntouchedLines(e,t,i,n,o){const s=e.rendLineNumberStart,r=e.lines;for(let e=t;e<=i;e++){const t=s+e;r[e].layoutLine(t,n[t-o])}}_insertLinesBefore(e,t,i,n,o){const s=[];let r=0;for(let e=t;e<=i;e++)s[r++]=this.host.createVisibleLine();e.lines=s.concat(e.lines)}_removeLinesBefore(e,t){for(let i=0;i<t;i++){const t=e.lines[i].getDomNode();t&&this.domNode.removeChild(t)}e.lines.splice(0,t)}_insertLinesAfter(e,t,i,n,o){const s=[];let r=0;for(let e=t;e<=i;e++)s[r++]=this.host.createVisibleLine();e.lines=e.lines.concat(s)}_removeLinesAfter(e,t){const i=e.linesLength-t;for(let n=0;n<t;n++){const t=e.lines[i+n].getDomNode();t&&this.domNode.removeChild(t)}e.lines.splice(i,t)}_finishRenderingNewLines(e,t,i,n){Ri._ttPolicy&&(i=Ri._ttPolicy.createHTML(i));const o=this.domNode.lastChild;t||!o?this.domNode.innerHTML=i:o.insertAdjacentHTML("afterend",i);let s=this.domNode.lastChild;for(let t=e.linesLength-1;t>=0;t--){const i=e.lines[t];n[t]&&(i.setDomNode(s),s=s.previousSibling)}}_finishRenderingInvalidLines(e,t,i){const n=document.createElement("div");Ri._ttPolicy&&(t=Ri._ttPolicy.createHTML(t)),n.innerHTML=t;for(let t=0;t<e.linesLength;t++){const o=e.lines[t];if(i[t]){const e=n.firstChild,t=o.getDomNode();t.parentNode.replaceChild(e,t),o.setDomNode(e)}}}_finishRendering(e,t,i){const n=Ri._sb,o=e.linesLength,s=e.lines,r=e.rendLineNumberStart,a=[];{n.reset();let l=!1;for(let e=0;e<o;e++){const t=s[e];a[e]=!1,t.getDomNode()||t.renderLine(e+r,i[e],this.viewportData,n)&&(a[e]=!0,l=!0)}l&&this._finishRenderingNewLines(e,t,n.build(),a)}{n.reset();let t=!1;const l=[];for(let e=0;e<o;e++){const o=s[e];l[e]=!1,a[e]||o.renderLine(e+r,i[e],this.viewportData,n)&&(l[e]=!0,t=!0)}t&&this._finishRenderingInvalidLines(e,n.build(),l)}}}Ri._ttPolicy=(0,Bi.H)("editorViewLayer",{createHTML:e=>e}),Ri._sb=new Ni.fe(1e5);class Oi extends se{constructor(e){super(e),this._visibleLines=new Fi(this),this.domNode=this._visibleLines.domNode;const t=this._context.configuration.options.get(48);(0,gt.M)(this.domNode,t),this._dynamicOverlays=[],this._isFocused=!1,this.domNode.setClassName("view-overlays")}shouldRender(){if(super.shouldRender())return!0;for(let e=0,t=this._dynamicOverlays.length;e<t;e++)if(this._dynamicOverlays[e].shouldRender())return!0;return!1}dispose(){super.dispose();for(let e=0,t=this._dynamicOverlays.length;e<t;e++)this._dynamicOverlays[e].dispose();this._dynamicOverlays=[]}getDomNode(){return this.domNode}createVisibleLine(){return new Pi(this._context.configuration,this._dynamicOverlays)}addDynamicOverlay(e){this._dynamicOverlays.push(e)}onConfigurationChanged(e){this._visibleLines.onConfigurationChanged(e);const t=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();for(let n=t;n<=i;n++)this._visibleLines.getVisibleLine(n).onConfigurationChanged(e);const n=this._context.configuration.options.get(48);return(0,gt.M)(this.domNode,n),!0}onFlushed(e){return this._visibleLines.onFlushed(e)}onFocusChanged(e){return this._isFocused=e.isFocused,!0}onLinesChanged(e){return this._visibleLines.onLinesChanged(e)}onLinesDeleted(e){return this._visibleLines.onLinesDeleted(e)}onLinesInserted(e){return this._visibleLines.onLinesInserted(e)}onScrollChanged(e){return this._visibleLines.onScrollChanged(e)||!0}onTokensChanged(e){return this._visibleLines.onTokensChanged(e)}onZonesChanged(e){return this._visibleLines.onZonesChanged(e)}prepareRender(e){const t=this._dynamicOverlays.filter((e=>e.shouldRender()));for(let i=0,n=t.length;i<n;i++){const n=t[i];n.prepareRender(e),n.onDidRender()}}render(e){this._viewOverlaysRender(e),this.domNode.toggleClassName("focused",this._isFocused)}_viewOverlaysRender(e){this._visibleLines.renderLines(e.viewportData)}}class Pi{constructor(e,t){this._configuration=e,this._lineHeight=this._configuration.options.get(64),this._dynamicOverlays=t,this._domNode=null,this._renderedContent=null}getDomNode(){return this._domNode?this._domNode.domNode:null}setDomNode(e){this._domNode=(0,z.Z)(e)}onContentChanged(){}onTokensChanged(){}onConfigurationChanged(e){this._lineHeight=this._configuration.options.get(64)}renderLine(e,t,i,n){let o="";for(let t=0,n=this._dynamicOverlays.length;t<n;t++)o+=this._dynamicOverlays[t].render(i.startLineNumber,e);return this._renderedContent!==o&&(this._renderedContent=o,n.appendString('<div style="position:absolute;top:'),n.appendString(String(t)),n.appendString("px;width:100%;height:"),n.appendString(String(this._lineHeight)),n.appendString('px;">'),n.appendString(o),n.appendString("</div>"),!0)}layoutLine(e,t){this._domNode&&(this._domNode.setTop(t),this._domNode.setHeight(this._lineHeight))}}class zi extends Oi{constructor(e){super(e);const t=this._context.configuration.options.get(140);this._contentWidth=t.contentWidth,this.domNode.setHeight(0)}onConfigurationChanged(e){const t=this._context.configuration.options.get(140);return this._contentWidth=t.contentWidth,super.onConfigurationChanged(e)||!0}onScrollChanged(e){return super.onScrollChanged(e)||e.scrollWidthChanged}_viewOverlaysRender(e){super._viewOverlaysRender(e),this.domNode.setWidth(Math.max(e.scrollWidth,this._contentWidth))}}class Qi extends Oi{constructor(e){super(e);const t=this._context.configuration.options,i=t.get(140);this._contentLeft=i.contentLeft,this.domNode.setClassName("margin-view-overlays"),this.domNode.setWidth(1),(0,gt.M)(this.domNode,t.get(48))}onConfigurationChanged(e){const t=this._context.configuration.options;(0,gt.M)(this.domNode,t.get(48));const i=t.get(140);return this._contentLeft=i.contentLeft,super.onConfigurationChanged(e)||!0}onScrollChanged(e){return super.onScrollChanged(e)||e.scrollHeightChanged}_viewOverlaysRender(e){super._viewOverlaysRender(e);const t=Math.min(e.scrollHeight,1e6);this.domNode.setHeight(t),this.domNode.setWidth(this._contentLeft)}}class Hi extends se{constructor(e,t){super(e),this._viewDomNode=t,this._widgets={},this.domNode=(0,z.Z)(document.createElement("div")),re.write(this.domNode,1),this.domNode.setClassName("contentWidgets"),this.domNode.setPosition("absolute"),this.domNode.setTop(0),this.overflowingContentWidgetsDomNode=(0,z.Z)(document.createElement("div")),re.write(this.overflowingContentWidgetsDomNode,2),this.overflowingContentWidgetsDomNode.setClassName("overflowingContentWidgets")}dispose(){super.dispose(),this._widgets={}}onConfigurationChanged(e){const t=Object.keys(this._widgets);for(const i of t)this._widgets[i].onConfigurationChanged(e);return!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLineMappingChanged(e){return this._updateAnchorsViewPositions(),!0}onLinesChanged(e){return this._updateAnchorsViewPositions(),!0}onLinesDeleted(e){return this._updateAnchorsViewPositions(),!0}onLinesInserted(e){return this._updateAnchorsViewPositions(),!0}onScrollChanged(e){return!0}onZonesChanged(e){return!0}_updateAnchorsViewPositions(){const e=Object.keys(this._widgets);for(const t of e)this._widgets[t].updateAnchorViewPosition()}addWidget(e){const t=new Wi(this._context,this._viewDomNode,e);this._widgets[t.id]=t,t.allowEditorOverflow?this.overflowingContentWidgetsDomNode.appendChild(t.domNode):this.domNode.appendChild(t.domNode),this.setShouldRender()}setWidgetPosition(e,t,i,n,o){this._widgets[e.getId()].setPosition(t,i,n,o),this.setShouldRender()}removeWidget(e){const t=e.getId();if(this._widgets.hasOwnProperty(t)){const e=this._widgets[t];delete this._widgets[t];const i=e.domNode.domNode;i.parentNode.removeChild(i),i.removeAttribute("monaco-visible-content-widget"),this.setShouldRender()}}shouldSuppressMouseDownOnWidget(e){return!!this._widgets.hasOwnProperty(e)&&this._widgets[e].suppressMouseDown}onBeforeRender(e){const t=Object.keys(this._widgets);for(const i of t)this._widgets[i].onBeforeRender(e)}prepareRender(e){const t=Object.keys(this._widgets);for(const i of t)this._widgets[i].prepareRender(e)}render(e){const t=Object.keys(this._widgets);for(const i of t)this._widgets[i].render(e)}}class Wi{constructor(e,t,i){this._primaryAnchor=new Vi(null,null),this._secondaryAnchor=new Vi(null,null),this._context=e,this._viewDomNode=t,this._actual=i,this.domNode=(0,z.Z)(this._actual.getDomNode()),this.id=this._actual.getId(),this.allowEditorOverflow=this._actual.allowEditorOverflow||!1,this.suppressMouseDown=this._actual.suppressMouseDown||!1;const n=this._context.configuration.options,o=n.get(140);this._fixedOverflowWidgets=n.get(40),this._contentWidth=o.contentWidth,this._contentLeft=o.contentLeft,this._lineHeight=n.get(64),this._affinity=null,this._preference=[],this._cachedDomNodeOffsetWidth=-1,this._cachedDomNodeOffsetHeight=-1,this._maxWidth=this._getMaxWidth(),this._isVisible=!1,this._renderData=null,this.domNode.setPosition(this._fixedOverflowWidgets&&this.allowEditorOverflow?"fixed":"absolute"),this.domNode.setDisplay("none"),this.domNode.setVisibility("hidden"),this.domNode.setAttribute("widgetId",this.id),this.domNode.setMaxWidth(this._maxWidth)}onConfigurationChanged(e){const t=this._context.configuration.options;if(this._lineHeight=t.get(64),e.hasChanged(140)){const e=t.get(140);this._contentLeft=e.contentLeft,this._contentWidth=e.contentWidth,this._maxWidth=this._getMaxWidth()}}updateAnchorViewPosition(){this._setPosition(this._affinity,this._primaryAnchor.modelPosition,this._secondaryAnchor.modelPosition)}_setPosition(e,t,i){function n(e,t,i){if(!e)return new Vi(null,null);const n=t.model.validatePosition(e);if(t.coordinatesConverter.modelPositionIsVisible(n)){const o=t.coordinatesConverter.convertModelPositionToViewPosition(n,null!=i?i:void 0);return new Vi(e,o)}return new Vi(e,null)}this._affinity=e,this._primaryAnchor=n(t,this._context.viewModel,this._affinity),this._secondaryAnchor=n(i,this._context.viewModel,this._affinity)}_getMaxWidth(){return this.allowEditorOverflow?window.innerWidth||document.documentElement.offsetWidth||document.body.offsetWidth:this._contentWidth}setPosition(e,t,i,n){this._setPosition(n,e,t),this._preference=i,this._primaryAnchor.viewPosition&&this._preference&&this._preference.length>0?this.domNode.setDisplay("block"):this.domNode.setDisplay("none"),this._cachedDomNodeOffsetWidth=-1,this._cachedDomNodeOffsetHeight=-1}_layoutBoxInViewport(e,t,i,n){const o=e.top,s=o,r=e.top+e.height,a=o-i,l=s>=i,h=r,c=n.viewportHeight-r>=i;let d=e.left;return d+t>n.scrollLeft+n.viewportWidth&&(d=n.scrollLeft+n.viewportWidth-t),d<n.scrollLeft&&(d=n.scrollLeft),{fitsAbove:l,aboveTop:a,fitsBelow:c,belowTop:h,left:d}}_layoutHorizontalSegmentInPage(e,t,i,n){const o=Math.max(15,t.left-n),s=Math.min(t.left+t.width+n,e.width-15);let r=t.left+i-window.scrollX;if(r+n>s){const e=r-(s-n);r-=e,i-=e}if(r<o){const e=r-o;r-=e,i-=e}return[i,r]}_layoutBoxInPage(e,t,i,n){const o=e.top-i,s=e.top+e.height,r=d.BK(this._viewDomNode.domNode),a=r.top+o-window.scrollY,l=r.top+s-window.scrollY,h=d.tG(document.body),[c,u]=this._layoutHorizontalSegmentInPage(h,r,e.left-n.scrollLeft+this._contentLeft,t),g=a>=22,m=l+i<=h.height-22;return this._fixedOverflowWidgets?{fitsAbove:g,aboveTop:Math.max(a,22),fitsBelow:m,belowTop:l,left:u}:{fitsAbove:g,aboveTop:o,fitsBelow:m,belowTop:s,left:c}}_prepareRenderWidgetAtExactPositionOverflowing(e){return new Ui(e.top,e.left+this._contentLeft)}_getAnchorsCoordinates(e){var t,i;return{primary:n(this._primaryAnchor.viewPosition,this._affinity,this._lineHeight),secondary:n((null===(t=this._secondaryAnchor.viewPosition)||void 0===t?void 0:t.lineNumber)===(null===(i=this._primaryAnchor.viewPosition)||void 0===i?void 0:i.lineNumber)?this._secondaryAnchor.viewPosition:null,this._affinity,this._lineHeight)};function n(t,i,n){if(!t)return null;const o=e.visibleRangeForPosition(t);if(!o)return null;const s=1===t.column&&3===i?0:o.left,r=e.getVerticalOffsetForLineNumber(t.lineNumber)-e.scrollTop;return new ji(r,s,n)}}_reduceAnchorCoordinates(e,t,i){if(!t)return e;const n=this._context.configuration.options.get(48);let o=t.left;return o=o<e.left?Math.max(o,e.left-i+n.typicalFullwidthCharacterWidth):Math.min(o,e.left+i-n.typicalFullwidthCharacterWidth),new ji(e.top,o,e.height)}_prepareRenderWidget(e){if(!this._preference||0===this._preference.length)return null;const{primary:t,secondary:i}=this._getAnchorsCoordinates(e);if(!t)return null;if(-1===this._cachedDomNodeOffsetWidth||-1===this._cachedDomNodeOffsetHeight){let e=null;if("function"==typeof this._actual.beforeRender&&(e=Gi(this._actual.beforeRender,this._actual)),e)this._cachedDomNodeOffsetWidth=e.width,this._cachedDomNodeOffsetHeight=e.height;else{const e=this.domNode.domNode.getBoundingClientRect();this._cachedDomNodeOffsetWidth=Math.round(e.width),this._cachedDomNodeOffsetHeight=Math.round(e.height)}}const n=this._reduceAnchorCoordinates(t,i,this._cachedDomNodeOffsetWidth);let o;o=this.allowEditorOverflow?this._layoutBoxInPage(n,this._cachedDomNodeOffsetWidth,this._cachedDomNodeOffsetHeight,e):this._layoutBoxInViewport(n,this._cachedDomNodeOffsetWidth,this._cachedDomNodeOffsetHeight,e);for(let e=1;e<=2;e++)for(const t of this._preference)if(1===t){if(!o)return null;if(2===e||o.fitsAbove)return{coordinate:new Ui(o.aboveTop,o.left),position:1}}else{if(2!==t)return this.allowEditorOverflow?{coordinate:this._prepareRenderWidgetAtExactPositionOverflowing(new Ui(n.top,n.left)),position:0}:{coordinate:new Ui(n.top,n.left),position:0};if(!o)return null;if(2===e||o.fitsBelow)return{coordinate:new Ui(o.belowTop,o.left),position:2}}return null}onBeforeRender(e){this._primaryAnchor.viewPosition&&this._preference&&(this._primaryAnchor.viewPosition.lineNumber<e.startLineNumber||this._primaryAnchor.viewPosition.lineNumber>e.endLineNumber||this.domNode.setMaxWidth(this._maxWidth))}prepareRender(e){this._renderData=this._prepareRenderWidget(e)}render(e){if(!this._renderData)return this._isVisible&&(this.domNode.removeAttribute("monaco-visible-content-widget"),this._isVisible=!1,this.domNode.setVisibility("hidden")),void("function"==typeof this._actual.afterRender&&Gi(this._actual.afterRender,this._actual,null));this.allowEditorOverflow?(this.domNode.setTop(this._renderData.coordinate.top),this.domNode.setLeft(this._renderData.coordinate.left)):(this.domNode.setTop(this._renderData.coordinate.top+e.scrollTop-e.bigNumbersDelta),this.domNode.setLeft(this._renderData.coordinate.left)),this._isVisible||(this.domNode.setVisibility("inherit"),this.domNode.setAttribute("monaco-visible-content-widget","true"),this._isVisible=!0),"function"==typeof this._actual.afterRender&&Gi(this._actual.afterRender,this._actual,this._renderData.position)}}class Vi{constructor(e,t){this.modelPosition=e,this.viewPosition=t}}class Ui{constructor(e,t){this.top=e,this.left=t,this._coordinateBrand=void 0}}class ji{constructor(e,t,i){this.top=e,this.left=t,this.height=i,this._anchorCoordinateBrand=void 0}}function Gi(e,t,...i){try{return e.call(t,...i)}catch(e){return null}}var Ki=i(5166);l()(Ki.A,{insert:"head",singleton:!1}),Ki.A.locals;class Yi extends pt{constructor(e){super(),this._context=e;const t=this._context.configuration.options,i=t.get(140);this._lineHeight=t.get(64),this._renderLineHighlight=t.get(92),this._renderLineHighlightOnlyWhenFocus=t.get(93),this._contentLeft=i.contentLeft,this._contentWidth=i.contentWidth,this._selectionIsEmpty=!0,this._focused=!1,this._cursorLineNumbers=[1],this._selections=[new P.L(1,1,1,1)],this._renderData=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),super.dispose()}_readFromSelections(){let e=!1;const t=this._selections.map((e=>e.positionLineNumber));t.sort(((e,t)=>e-t)),A.aI(this._cursorLineNumbers,t)||(this._cursorLineNumbers=t,e=!0);const i=this._selections.every((e=>e.isEmpty()));return this._selectionIsEmpty!==i&&(this._selectionIsEmpty=i,e=!0),e}onThemeChanged(e){return this._readFromSelections()}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(140);return this._lineHeight=t.get(64),this._renderLineHighlight=t.get(92),this._renderLineHighlightOnlyWhenFocus=t.get(93),this._contentLeft=i.contentLeft,this._contentWidth=i.contentWidth,!0}onCursorStateChanged(e){return this._selections=e.selections,this._readFromSelections()}onFlushed(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollWidthChanged||e.scrollTopChanged}onZonesChanged(e){return!0}onFocusChanged(e){return!!this._renderLineHighlightOnlyWhenFocus&&(this._focused=e.isFocused,!0)}prepareRender(e){if(!this._shouldRenderThis())return void(this._renderData=null);const t=this._renderOne(e),i=e.visibleRange.startLineNumber,n=e.visibleRange.endLineNumber,o=this._cursorLineNumbers.length;let s=0;const r=[];for(let e=i;e<=n;e++){const n=e-i;for(;s<o&&this._cursorLineNumbers[s]<e;)s++;s<o&&this._cursorLineNumbers[s]===e?r[n]=t:r[n]=""}this._renderData=r}render(e,t){if(!this._renderData)return"";const i=t-e;return i>=this._renderData.length?"":this._renderData[i]}_shouldRenderInMargin(){return("gutter"===this._renderLineHighlight||"all"===this._renderLineHighlight)&&(!this._renderLineHighlightOnlyWhenFocus||this._focused)}_shouldRenderInContent(){return("line"===this._renderLineHighlight||"all"===this._renderLineHighlight)&&this._selectionIsEmpty&&(!this._renderLineHighlightOnlyWhenFocus||this._focused)}}class Ji extends Yi{_renderOne(e){return`<div class="${"current-line"+(this._shouldRenderOther()?" current-line-both":"")}" style="width:${Math.max(e.scrollWidth,this._contentWidth)}px; height:${this._lineHeight}px;"></div>`}_shouldRenderThis(){return this._shouldRenderInContent()}_shouldRenderOther(){return this._shouldRenderInMargin()}}class qi extends Yi{_renderOne(e){return`<div class="${"current-line"+(this._shouldRenderInMargin()?" current-line-margin":"")+(this._shouldRenderOther()?" current-line-margin-both":"")}" style="width:${this._contentLeft}px; height:${this._lineHeight}px;"></div>`}_shouldRenderThis(){return!0}_shouldRenderOther(){return this._shouldRenderInContent()}}(0,ft.zy)(((e,t)=>{const i=e.getColor(At.kG);if(i&&(t.addRule(`.monaco-editor .view-overlays .current-line { background-color: ${i}; }`),t.addRule(`.monaco-editor .margin-view-overlays .current-line-margin { background-color: ${i}; border: none; }`)),!i||i.isTransparent()||e.defines(At.Mf)){const i=e.getColor(At.Mf);i&&(t.addRule(`.monaco-editor .view-overlays .current-line { border: 2px solid ${i}; }`),t.addRule(`.monaco-editor .margin-view-overlays .current-line-margin { border: 2px solid ${i}; }`),(0,Ae.Bb)(e.type)&&(t.addRule(".monaco-editor .view-overlays .current-line { border-width: 1px; }"),t.addRule(".monaco-editor .margin-view-overlays .current-line-margin { border-width: 1px; }")))}}));var $i=i(358);l()($i.A,{insert:"head",singleton:!1}),$i.A.locals;class Xi extends pt{constructor(e){super(),this._context=e;const t=this._context.configuration.options;this._lineHeight=t.get(64),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth,this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options;return this._lineHeight=t.get(64),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth,!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged||e.scrollWidthChanged}onZonesChanged(e){return!0}prepareRender(e){const t=e.getDecorationsInViewport();let i=[],n=0;for(let e=0,o=t.length;e<o;e++){const o=t[e];o.options.className&&(i[n++]=o)}i=i.sort(((e,t)=>{if(e.options.zIndex<t.options.zIndex)return-1;if(e.options.zIndex>t.options.zIndex)return 1;const i=e.options.className,n=t.options.className;return i<n?-1:i>n?1:xe.Q.compareRangesUsingStarts(e.range,t.range)}));const o=e.visibleRange.startLineNumber,s=e.visibleRange.endLineNumber,r=[];for(let e=o;e<=s;e++)r[e-o]="";this._renderWholeLineDecorations(e,i,r),this._renderNormalDecorations(e,i,r),this._renderResult=r}_renderWholeLineDecorations(e,t,i){const n=String(this._lineHeight),o=e.visibleRange.startLineNumber,s=e.visibleRange.endLineNumber;for(let e=0,r=t.length;e<r;e++){const r=t[e];if(!r.options.isWholeLine)continue;const a='<div class="cdr '+r.options.className+'" style="left:0;width:100%;height:'+n+'px;"></div>',l=Math.max(r.range.startLineNumber,o),h=Math.min(r.range.endLineNumber,s);for(let e=l;e<=h;e++)i[e-o]+=a}}_renderNormalDecorations(e,t,i){const n=String(this._lineHeight),o=e.visibleRange.startLineNumber;let s=null,r=!1,a=null;for(let l=0,h=t.length;l<h;l++){const h=t[l];if(h.options.isWholeLine)continue;const c=h.options.className,d=Boolean(h.options.showIfCollapsed);let u=h.range;d&&1===u.endColumn&&u.endLineNumber!==u.startLineNumber&&(u=new xe.Q(u.startLineNumber,u.startColumn,u.endLineNumber-1,this._context.viewModel.getLineMaxColumn(u.endLineNumber-1))),s===c&&r===d&&xe.Q.areIntersectingOrTouching(a,u)?a=xe.Q.plusRange(a,u):(null!==s&&this._renderNormalDecoration(e,a,s,r,n,o,i),s=c,r=d,a=u)}null!==s&&this._renderNormalDecoration(e,a,s,r,n,o,i)}_renderNormalDecoration(e,t,i,n,o,s,r){const a=e.linesVisibleRangesForRange(t,"findMatch"===i);if(a)for(let e=0,t=a.length;e<t;e++){const t=a[e];if(t.outsideRenderedLine)continue;const l=t.lineNumber-s;if(n&&1===t.ranges.length){const e=t.ranges[0];if(e.width<this._typicalHalfwidthCharacterWidth){const i=Math.round(e.left+e.width/2),n=Math.max(0,Math.round(i-this._typicalHalfwidthCharacterWidth/2));t.ranges[0]=new ce(n,this._typicalHalfwidthCharacterWidth)}}for(let e=0,n=t.ranges.length;e<n;e++){const n=t.ranges[e],s='<div class="cdr '+i+'" style="left:'+String(n.left)+"px;width:"+String(n.width)+"px;height:"+o+'px;"></div>';r[l]+=s}}}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}class Zi extends se{constructor(e,t,i,n){super(e);const o=this._context.configuration.options,s=o.get(99),r=o.get(72),a=o.get(38),l=o.get(102),h={listenOnDomNode:i.domNode,className:"editor-scrollable "+(0,ft.Pz)(e.theme.type),useShadows:!1,lazyRender:!0,vertical:s.vertical,horizontal:s.horizontal,verticalHasArrows:s.verticalHasArrows,horizontalHasArrows:s.horizontalHasArrows,verticalScrollbarSize:s.verticalScrollbarSize,verticalSliderSize:s.verticalSliderSize,horizontalScrollbarSize:s.horizontalScrollbarSize,horizontalSliderSize:s.horizontalSliderSize,handleMouseWheel:s.handleMouseWheel,alwaysConsumeMouseWheel:s.alwaysConsumeMouseWheel,arrowSize:s.arrowSize,mouseWheelScrollSensitivity:r,fastScrollSensitivity:a,scrollPredominantAxis:l,scrollByPage:s.scrollByPage};this.scrollbar=this._register(new Ve.oO(t.domNode,h,this._context.viewLayout.getScrollable())),re.write(this.scrollbar.getDomNode(),5),this.scrollbarDomNode=(0,z.Z)(this.scrollbar.getDomNode()),this.scrollbarDomNode.setPosition("absolute"),this._setLayout();const c=(e,t,i)=>{const n={};if(t){const t=e.scrollTop;t&&(n.scrollTop=this._context.viewLayout.getCurrentScrollTop()+t,e.scrollTop=0)}if(i){const t=e.scrollLeft;t&&(n.scrollLeft=this._context.viewLayout.getCurrentScrollLeft()+t,e.scrollLeft=0)}this._context.viewModel.viewLayout.setScrollPosition(n,1)};this._register(d.ko(i.domNode,"scroll",(e=>c(i.domNode,!0,!0)))),this._register(d.ko(t.domNode,"scroll",(e=>c(t.domNode,!0,!1)))),this._register(d.ko(n.domNode,"scroll",(e=>c(n.domNode,!0,!1)))),this._register(d.ko(this.scrollbarDomNode.domNode,"scroll",(e=>c(this.scrollbarDomNode.domNode,!0,!1))))}dispose(){super.dispose()}_setLayout(){const e=this._context.configuration.options,t=e.get(140);this.scrollbarDomNode.setLeft(t.contentLeft),"right"===e.get(70).side?this.scrollbarDomNode.setWidth(t.contentWidth+t.minimap.minimapWidth):this.scrollbarDomNode.setWidth(t.contentWidth),this.scrollbarDomNode.setHeight(t.height)}getOverviewRulerLayoutInfo(){return this.scrollbar.getOverviewRulerLayoutInfo()}getDomNode(){return this.scrollbarDomNode}delegateVerticalScrollbarPointerDown(e){this.scrollbar.delegateVerticalScrollbarPointerDown(e)}delegateScrollFromMouseWheelEvent(e){this.scrollbar.delegateScrollFromMouseWheelEvent(e)}onConfigurationChanged(e){if(e.hasChanged(99)||e.hasChanged(72)||e.hasChanged(38)){const e=this._context.configuration.options,t=e.get(99),i=e.get(72),n=e.get(38),o=e.get(102),s={vertical:t.vertical,horizontal:t.horizontal,verticalScrollbarSize:t.verticalScrollbarSize,horizontalScrollbarSize:t.horizontalScrollbarSize,scrollByPage:t.scrollByPage,handleMouseWheel:t.handleMouseWheel,mouseWheelScrollSensitivity:i,fastScrollSensitivity:n,scrollPredominantAxis:o};this.scrollbar.updateOptions(s)}return e.hasChanged(140)&&this._setLayout(),!0}onScrollChanged(e){return!0}onThemeChanged(e){return this.scrollbar.updateClassName("editor-scrollable "+(0,ft.Pz)(this._context.theme.type)),!0}prepareRender(e){}render(e){this.scrollbar.renderNow()}}var en=i(7394);l()(en.A,{insert:"head",singleton:!1}),en.A.locals;class tn{constructor(e,t,i,n,o){this._decorationToRenderBrand=void 0,this.startLineNumber=+e,this.endLineNumber=+t,this.className=String(i),this.zIndex=null!=n?n:0,this.decorationLane=null!=o?o:1}}class nn{constructor(e,t){this.className=e,this.zIndex=t}}class on{constructor(){this.lanes=[]}add(e,t){for(;e>=this.lanes.length;)this.lanes.push([]);this.lanes[e].push(t)}getLaneDecorations(e){return e<this.lanes.length?this.lanes[e]:[]}isEmpty(){for(const e of this.lanes)if(e.length>0)return!1;return!0}}class sn extends pt{_render(e,t,i,n){const o=[];for(let i=e;i<=t;i++)o[i-e]=new on;if(0===i.length)return o;i.sort(((e,t)=>e.className===t.className?e.startLineNumber===t.startLineNumber?e.endLineNumber-t.endLineNumber:e.startLineNumber-t.startLineNumber:e.className<t.className?-1:1));let s=null,r=0;for(let a=0,l=i.length;a<l;a++){const l=i[a],h=l.className,c=l.zIndex;let d=Math.max(l.startLineNumber,e)-e;const u=Math.min(l.endLineNumber,t)-e,g=Math.min(l.decorationLane,n);s===h?(d=Math.max(r+1,d),r=Math.max(r,u)):(s=h,r=u);for(let e=d;e<=r;e++)o[e].add(g,new nn(h,c))}return o}}class rn extends sn{constructor(e){super(),this._context=e;const t=this._context.configuration.options,i=t.get(140);this._lineHeight=t.get(64),this._glyphMargin=t.get(55),this._glyphMarginLeft=i.glyphMarginLeft,this._glyphMarginWidth=i.glyphMarginWidth,this._glyphMarginDecorationLaneCount=i.glyphMarginDecorationLaneCount,this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(140);return this._lineHeight=t.get(64),this._glyphMargin=t.get(55),this._glyphMarginLeft=i.glyphMarginLeft,this._glyphMarginWidth=i.glyphMarginWidth,this._glyphMarginDecorationLaneCount=i.glyphMarginDecorationLaneCount,!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}_getDecorations(e){var t;const i=e.getDecorationsInViewport(),n=[];let o=0;for(let e=0,s=i.length;e<s;e++){const s=i[e],r=s.options.glyphMarginClassName,a=s.options.zIndex,l=null===(t=s.options.glyphMargin)||void 0===t?void 0:t.position;r&&(n[o++]=new tn(s.range.startLineNumber,s.range.endLineNumber,r,a,l))}return n}prepareRender(e){if(!this._glyphMargin)return void(this._renderResult=null);const t=e.visibleRange.startLineNumber,i=e.visibleRange.endLineNumber,n=this._getDecorations(e),o=this._render(t,i,n,this._glyphMarginDecorationLaneCount),s=this._lineHeight.toString(),r='" style="width:'+Math.round(this._glyphMarginWidth/this._glyphMarginDecorationLaneCount).toString()+"px;height:"+s+"px;",a=[];for(let e=t;e<=i;e++){const i=e-t,n=o[i];if(n.isEmpty())a[i]="";else{let e="";for(let t=1;t<=this._glyphMarginDecorationLaneCount;t+=1){const i=n.getLaneDecorations(t);if(0===i.length)continue;i.sort(((e,t)=>t.zIndex-e.zIndex));const o=i[0],s=[o.className];for(let e=1;e<i.length;e+=1){const t=i[e];if(t.zIndex!==o.zIndex)break;s.push(t.className)}const a=(this._glyphMarginLeft+(t-1)*this._lineHeight).toString();e+='<div class="cgmr codicon '+s.join(" ")+r+"left:"+a+'px;"></div>'}a[i]=e}}this._renderResult=a}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}var an=i(9158);l()(an.A,{insert:"head",singleton:!1}),an.A.locals;var ln=i(5417),hn=i(89);class cn extends pt{constructor(e){super(),this._context=e,this._primaryPosition=null;const t=this._context.configuration.options,i=t.get(141),n=t.get(48);this._lineHeight=t.get(64),this._spaceWidth=n.spaceWidth,this._maxIndentLeft=-1===i.wrappingColumn?-1:i.wrappingColumn*n.typicalHalfwidthCharacterWidth,this._bracketPairGuideOptions=t.get(14),this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(141),n=t.get(48);return this._lineHeight=t.get(64),this._spaceWidth=n.spaceWidth,this._maxIndentLeft=-1===i.wrappingColumn?-1:i.wrappingColumn*n.typicalHalfwidthCharacterWidth,this._bracketPairGuideOptions=t.get(14),!0}onCursorStateChanged(e){var t;const i=e.selections[0].getPosition();return!(null===(t=this._primaryPosition)||void 0===t?void 0:t.equals(i))&&(this._primaryPosition=i,!0)}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}onLanguageConfigurationChanged(e){return!0}prepareRender(e){var t,i,n,o;if(!this._bracketPairGuideOptions.indentation&&!1===this._bracketPairGuideOptions.bracketPairs)return void(this._renderResult=null);const s=e.visibleRange.startLineNumber,r=e.visibleRange.endLineNumber,a=e.scrollWidth,l=this._lineHeight,h=this._primaryPosition,c=this.getGuidesByLine(s,Math.min(r+1,this._context.viewModel.getLineCount()),h),d=[];for(let h=s;h<=r;h++){const r=h-s,u=c[r];let g="";const m=null!==(i=null===(t=e.visibleRangeForPosition(new De.y(h,1)))||void 0===t?void 0:t.left)&&void 0!==i?i:0;for(const t of u){const i=-1===t.column?m+(t.visibleColumn-1)*this._spaceWidth:e.visibleRangeForPosition(new De.y(h,t.column)).left;if(i>a||this._maxIndentLeft>0&&i>this._maxIndentLeft)break;const s=t.horizontalLine?t.horizontalLine.top?"horizontal-top":"horizontal-bottom":"vertical",r=t.horizontalLine?(null!==(o=null===(n=e.visibleRangeForPosition(new De.y(h,t.horizontalLine.endColumn)))||void 0===n?void 0:n.left)&&void 0!==o?o:i+this._spaceWidth)-i:this._spaceWidth;g+=`<div class="core-guide ${t.className} ${s}" style="left:${i}px;height:${l}px;width:${r}px"></div>`}d[r]=g}this._renderResult=d}getGuidesByLine(e,t,i){const n=!1!==this._bracketPairGuideOptions.bracketPairs?this._context.viewModel.getBracketGuidesInRangeByLine(e,t,i,{highlightActive:this._bracketPairGuideOptions.highlightActiveBracketPair,horizontalGuides:!0===this._bracketPairGuideOptions.bracketPairsHorizontal?hn.N6.Enabled:"active"===this._bracketPairGuideOptions.bracketPairsHorizontal?hn.N6.EnabledForActive:hn.N6.Disabled,includeInactive:!0===this._bracketPairGuideOptions.bracketPairs}):null,o=this._bracketPairGuideOptions.indentation?this._context.viewModel.getLinesIndentGuides(e,t):null;let s=0,r=0,a=0;if(!1!==this._bracketPairGuideOptions.highlightActiveIndentation&&i){const n=this._context.viewModel.getActiveIndentGuide(i.lineNumber,e,t);s=n.startLineNumber,r=n.endLineNumber,a=n.indent}const{indentSize:l}=this._context.viewModel.model.getOptions(),h=[];for(let i=e;i<=t;i++){const t=new Array;h.push(t);const c=n?n[i-e]:[],d=new A.j3(c),u=o?o[i-e]:0;for(let e=1;e<=u;e++){const n=(e-1)*l+1,o=("always"===this._bracketPairGuideOptions.highlightActiveIndentation||0===c.length)&&s<=i&&i<=r&&e===a;t.push(...d.takeWhile((e=>e.visibleColumn<n))||[]);const h=d.peek();h&&h.visibleColumn===n&&!h.horizontalLine||t.push(new hn.TH(n,-1,o?"core-guide-indent-active":"core-guide-indent",null,-1,-1))}t.push(...d.takeWhile((e=>!0))||[])}return h}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}function dn(e){if(!e||!e.isTransparent())return e}(0,ft.zy)(((e,t)=>{const i=[{bracketColor:At.sN,guideColor:At.n4,guideColorActive:At.bB},{bracketColor:At.lQ,guideColor:At.I2,guideColorActive:At.WS},{bracketColor:At.ss,guideColor:At.Bo,guideColorActive:At.Pe},{bracketColor:At.l5,guideColor:At.If,guideColorActive:At.WD},{bracketColor:At.sH,guideColor:At.BD,guideColorActive:At.P1},{bracketColor:At.zp,guideColor:At.IW,guideColorActive:At.WY}],n=new ln.k,o=i.map((t=>{var i,n;const o=e.getColor(t.bracketColor),s=e.getColor(t.guideColor),r=e.getColor(t.guideColorActive),a=dn(null!==(i=dn(s))&&void 0!==i?i:null==o?void 0:o.transparent(.3)),l=dn(null!==(n=dn(r))&&void 0!==n?n:o);if(a&&l)return{guideColor:a,guideColorActive:l}})).filter(Lt.O9);if(o.length>0){for(let e=0;e<30;e++){const i=o[e%o.length];t.addRule(`.monaco-editor .${n.getInlineClassNameOfLevel(e).replace(/ /g,".")} { --guide-color: ${i.guideColor}; --guide-color-active: ${i.guideColorActive}; }`)}t.addRule(".monaco-editor .vertical { box-shadow: 1px 0 0 0 var(--guide-color) inset; }"),t.addRule(".monaco-editor .horizontal-top { border-top: 1px solid var(--guide-color); }"),t.addRule(".monaco-editor .horizontal-bottom { border-bottom: 1px solid var(--guide-color); }"),t.addRule(`.monaco-editor .vertical.${n.activeClassName} { box-shadow: 1px 0 0 0 var(--guide-color-active) inset; }`),t.addRule(`.monaco-editor .horizontal-top.${n.activeClassName} { border-top: 1px solid var(--guide-color-active); }`),t.addRule(`.monaco-editor .horizontal-bottom.${n.activeClassName} { border-bottom: 1px solid var(--guide-color-active); }`)}}));var un=i(9091);l()(un.A,{insert:"head",singleton:!1}),un.A.locals;class gn{get didDomLayout(){return this._didDomLayout}readClientRect(){if(!this._clientRectRead){this._clientRectRead=!0;const e=this._domNode.getBoundingClientRect();this.markDidDomLayout(),this._clientRectDeltaLeft=e.left,this._clientRectScale=e.width/this._domNode.offsetWidth}}get clientRectDeltaLeft(){return this._clientRectRead||this.readClientRect(),this._clientRectDeltaLeft}get clientRectScale(){return this._clientRectRead||this.readClientRect(),this._clientRectScale}constructor(e,t){this._domNode=e,this.endNode=t,this._didDomLayout=!1,this._clientRectDeltaLeft=0,this._clientRectScale=1,this._clientRectRead=!1}markDidDomLayout(){this._didDomLayout=!0}}class mn{constructor(){this._currentVisibleRange=new xe.Q(1,1,1,1)}getCurrentVisibleRange(){return this._currentVisibleRange}setCurrentVisibleRange(e){this._currentVisibleRange=e}}class pn{constructor(e,t,i,n,o,s,r){this.minimalReveal=e,this.lineNumber=t,this.startColumn=i,this.endColumn=n,this.startScrollTop=o,this.stopScrollTop=s,this.scrollType=r,this.type="range",this.minLineNumber=t,this.maxLineNumber=t}}class fn{constructor(e,t,i,n,o){this.minimalReveal=e,this.selections=t,this.startScrollTop=i,this.stopScrollTop=n,this.scrollType=o,this.type="selections";let s=t[0].startLineNumber,r=t[0].endLineNumber;for(let e=1,i=t.length;e<i;e++){const i=t[e];s=Math.min(s,i.startLineNumber),r=Math.max(r,i.endLineNumber)}this.minLineNumber=s,this.maxLineNumber=r}}class An extends se{constructor(e,t){super(e),this._linesContent=t,this._textRangeRestingSpot=document.createElement("div"),this._visibleLines=new Fi(this),this.domNode=this._visibleLines.domNode;const i=this._context.configuration,n=this._context.configuration.options,o=n.get(48),s=n.get(141);this._lineHeight=n.get(64),this._typicalHalfwidthCharacterWidth=o.typicalHalfwidthCharacterWidth,this._isViewportWrapping=s.isViewportWrapping,this._revealHorizontalRightPadding=n.get(96),this._cursorSurroundingLines=n.get(27),this._cursorSurroundingLinesStyle=n.get(28),this._canUseLayerHinting=!n.get(30),this._viewLineOptions=new be(i,this._context.theme.type),re.write(this.domNode,7),this.domNode.setClassName(`view-lines ${Ct.S}`),(0,gt.M)(this.domNode,o),this._maxLineWidth=0,this._asyncUpdateLineWidths=new V.uC((()=>{this._updateLineWidthsSlow()}),200),this._asyncCheckMonospaceFontAssumptions=new V.uC((()=>{this._checkMonospaceFontAssumptions()}),2e3),this._lastRenderedData=new mn,this._horizontalRevealRequest=null,this._stickyScrollEnabled=n.get(111).enabled,this._maxNumberStickyLines=n.get(111).maxLineCount}dispose(){this._asyncUpdateLineWidths.dispose(),this._asyncCheckMonospaceFontAssumptions.dispose(),super.dispose()}getDomNode(){return this.domNode}createVisibleLine(){return new ve(this._viewLineOptions)}onConfigurationChanged(e){this._visibleLines.onConfigurationChanged(e),e.hasChanged(141)&&(this._maxLineWidth=0);const t=this._context.configuration.options,i=t.get(48),n=t.get(141);return this._lineHeight=t.get(64),this._typicalHalfwidthCharacterWidth=i.typicalHalfwidthCharacterWidth,this._isViewportWrapping=n.isViewportWrapping,this._revealHorizontalRightPadding=t.get(96),this._cursorSurroundingLines=t.get(27),this._cursorSurroundingLinesStyle=t.get(28),this._canUseLayerHinting=!t.get(30),this._stickyScrollEnabled=t.get(111).enabled,this._maxNumberStickyLines=t.get(111).maxLineCount,(0,gt.M)(this.domNode,i),this._onOptionsMaybeChanged(),e.hasChanged(140)&&(this._maxLineWidth=0),!0}_onOptionsMaybeChanged(){const e=this._context.configuration,t=new be(e,this._context.theme.type);if(!this._viewLineOptions.equals(t)){this._viewLineOptions=t;const e=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();for(let t=e;t<=i;t++)this._visibleLines.getVisibleLine(t).onOptionsChanged(this._viewLineOptions);return!0}return!1}onCursorStateChanged(e){const t=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();let n=!1;for(let e=t;e<=i;e++)n=this._visibleLines.getVisibleLine(e).onSelectionChanged()||n;return n}onDecorationsChanged(e){{const e=this._visibleLines.getStartLineNumber(),t=this._visibleLines.getEndLineNumber();for(let i=e;i<=t;i++)this._visibleLines.getVisibleLine(i).onDecorationsChanged()}return!0}onFlushed(e){const t=this._visibleLines.onFlushed(e);return this._maxLineWidth=0,t}onLinesChanged(e){return this._visibleLines.onLinesChanged(e)}onLinesDeleted(e){return this._visibleLines.onLinesDeleted(e)}onLinesInserted(e){return this._visibleLines.onLinesInserted(e)}onRevealRangeRequest(e){const t=this._computeScrollTopToRevealRange(this._context.viewLayout.getFutureViewport(),e.source,e.minimalReveal,e.range,e.selections,e.verticalType);if(-1===t)return!1;let i=this._context.viewLayout.validateScrollPosition({scrollTop:t});e.revealHorizontal?e.range&&e.range.startLineNumber!==e.range.endLineNumber?i={scrollTop:i.scrollTop,scrollLeft:0}:e.range?this._horizontalRevealRequest=new pn(e.minimalReveal,e.range.startLineNumber,e.range.startColumn,e.range.endColumn,this._context.viewLayout.getCurrentScrollTop(),i.scrollTop,e.scrollType):e.selections&&e.selections.length>0&&(this._horizontalRevealRequest=new fn(e.minimalReveal,e.selections,this._context.viewLayout.getCurrentScrollTop(),i.scrollTop,e.scrollType)):this._horizontalRevealRequest=null;const n=Math.abs(this._context.viewLayout.getCurrentScrollTop()-i.scrollTop)<=this._lineHeight?1:e.scrollType;return this._context.viewModel.viewLayout.setScrollPosition(i,n),!0}onScrollChanged(e){if(this._horizontalRevealRequest&&e.scrollLeftChanged&&(this._horizontalRevealRequest=null),this._horizontalRevealRequest&&e.scrollTopChanged){const t=Math.min(this._horizontalRevealRequest.startScrollTop,this._horizontalRevealRequest.stopScrollTop),i=Math.max(this._horizontalRevealRequest.startScrollTop,this._horizontalRevealRequest.stopScrollTop);(e.scrollTop<t||e.scrollTop>i)&&(this._horizontalRevealRequest=null)}return this.domNode.setWidth(e.scrollWidth),this._visibleLines.onScrollChanged(e)||!0}onTokensChanged(e){return this._visibleLines.onTokensChanged(e)}onZonesChanged(e){return this._context.viewModel.viewLayout.setMaxLineWidth(this._maxLineWidth),this._visibleLines.onZonesChanged(e)}onThemeChanged(e){return this._onOptionsMaybeChanged()}getPositionFromDOMInfo(e,t){const i=this._getViewLineDomNode(e);if(null===i)return null;const n=this._getLineNumberFor(i);if(-1===n)return null;if(n<1||n>this._context.viewModel.getLineCount())return null;if(1===this._context.viewModel.getLineMaxColumn(n))return new De.y(n,1);const o=this._visibleLines.getStartLineNumber(),s=this._visibleLines.getEndLineNumber();if(n<o||n>s)return null;let r=this._visibleLines.getVisibleLine(n).getColumnOfNodeOffset(n,e,t);const a=this._context.viewModel.getLineMinColumn(n);return r<a&&(r=a),new De.y(n,r)}_getViewLineDomNode(e){for(;e&&1===e.nodeType;){if(e.className===ve.CLASS_NAME)return e;e=e.parentElement}return null}_getLineNumberFor(e){const t=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();for(let n=t;n<=i;n++)if(e===this._visibleLines.getVisibleLine(n).getDomNode())return n;return-1}getLineWidth(e){const t=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();if(e<t||e>i)return-1;const n=new gn(this.domNode.domNode,this._textRangeRestingSpot),o=this._visibleLines.getVisibleLine(e).getWidth(n);return this._updateLineWidthsSlowIfDomDidLayout(n),o}linesVisibleRangesForRange(e,t){if(this.shouldRender())return null;const i=e.endLineNumber,n=xe.Q.intersectRanges(e,this._lastRenderedData.getCurrentVisibleRange());if(!n)return null;const o=[];let s=0;const r=new gn(this.domNode.domNode,this._textRangeRestingSpot);let a=0;t&&(a=this._context.viewModel.coordinatesConverter.convertViewPositionToModelPosition(new De.y(n.startLineNumber,1)).lineNumber);const l=this._visibleLines.getStartLineNumber(),h=this._visibleLines.getEndLineNumber();for(let e=n.startLineNumber;e<=n.endLineNumber;e++){if(e<l||e>h)continue;const c=e===n.startLineNumber?n.startColumn:1,d=e===n.endLineNumber?n.endColumn:this._context.viewModel.getLineMaxColumn(e),u=this._visibleLines.getVisibleLine(e).getVisibleRangesForRange(e,c,d,r);if(u){if(t&&e<i){const t=a;a=this._context.viewModel.coordinatesConverter.convertViewPositionToModelPosition(new De.y(e+1,1)).lineNumber,t!==a&&(u.ranges[u.ranges.length-1].width+=this._typicalHalfwidthCharacterWidth)}o[s++]=new he(u.outsideRenderedLine,e,ce.from(u.ranges))}}return this._updateLineWidthsSlowIfDomDidLayout(r),0===s?null:o}_visibleRangesForLineRange(e,t,i){if(this.shouldRender())return null;if(e<this._visibleLines.getStartLineNumber()||e>this._visibleLines.getEndLineNumber())return null;const n=new gn(this.domNode.domNode,this._textRangeRestingSpot),o=this._visibleLines.getVisibleLine(e).getVisibleRangesForRange(e,t,i,n);return this._updateLineWidthsSlowIfDomDidLayout(n),o}visibleRangeForPosition(e){const t=this._visibleRangesForLineRange(e.lineNumber,e.column,e.column);return t?new ue(t.outsideRenderedLine,t.ranges[0].left):null}_updateLineWidthsFast(){return this._updateLineWidths(!0)}_updateLineWidthsSlow(){this._updateLineWidths(!1)}_updateLineWidthsSlowIfDomDidLayout(e){e.didDomLayout&&(this._asyncUpdateLineWidths.isScheduled()||(this._asyncUpdateLineWidths.cancel(),this._updateLineWidthsSlow()))}_updateLineWidths(e){const t=this._visibleLines.getStartLineNumber(),i=this._visibleLines.getEndLineNumber();let n=1,o=!0;for(let s=t;s<=i;s++){const t=this._visibleLines.getVisibleLine(s);!e||t.getWidthIsFast()?n=Math.max(n,t.getWidth(null)):o=!1}return o&&1===t&&i===this._context.viewModel.getLineCount()&&(this._maxLineWidth=0),this._ensureMaxLineWidth(n),o}_checkMonospaceFontAssumptions(){let e=-1,t=-1;const i=this._visibleLines.getStartLineNumber(),n=this._visibleLines.getEndLineNumber();for(let o=i;o<=n;o++){const i=this._visibleLines.getVisibleLine(o);if(i.needsMonospaceFontCheck()){const n=i.getWidth(null);n>t&&(t=n,e=o)}}if(-1!==e&&!this._visibleLines.getVisibleLine(e).monospaceAssumptionsAreValid())for(let e=i;e<=n;e++)this._visibleLines.getVisibleLine(e).onMonospaceAssumptionsInvalidated()}prepareRender(){throw new Error("Not supported")}render(){throw new Error("Not supported")}renderText(e){if(this._visibleLines.renderLines(e),this._lastRenderedData.setCurrentVisibleRange(e.visibleRange),this.domNode.setWidth(this._context.viewLayout.getScrollWidth()),this.domNode.setHeight(Math.min(this._context.viewLayout.getScrollHeight(),1e6)),this._horizontalRevealRequest){const t=this._horizontalRevealRequest;if(e.startLineNumber<=t.minLineNumber&&t.maxLineNumber<=e.endLineNumber){this._horizontalRevealRequest=null,this.onDidRender();const e=this._computeScrollLeftToReveal(t);e&&(this._isViewportWrapping||this._ensureMaxLineWidth(e.maxHorizontalOffset),this._context.viewModel.viewLayout.setScrollPosition({scrollLeft:e.scrollLeft},t.scrollType))}}if(this._updateLineWidthsFast()?this._asyncUpdateLineWidths.cancel():this._asyncUpdateLineWidths.schedule(),w.j9&&!this._asyncCheckMonospaceFontAssumptions.isScheduled()){const e=this._visibleLines.getStartLineNumber(),t=this._visibleLines.getEndLineNumber();for(let i=e;i<=t;i++)if(this._visibleLines.getVisibleLine(i).needsMonospaceFontCheck()){this._asyncCheckMonospaceFontAssumptions.schedule();break}}this._linesContent.setLayerHinting(this._canUseLayerHinting),this._linesContent.setContain("strict");const t=this._context.viewLayout.getCurrentScrollTop()-e.bigNumbersDelta;this._linesContent.setTop(-t),this._linesContent.setLeft(-this._context.viewLayout.getCurrentScrollLeft())}_ensureMaxLineWidth(e){const t=Math.ceil(e);this._maxLineWidth<t&&(this._maxLineWidth=t,this._context.viewModel.viewLayout.setMaxLineWidth(this._maxLineWidth))}_computeScrollTopToRevealRange(e,t,i,n,o,s){const r=e.top,a=e.height,l=r+a;let h,c,d;if(o&&o.length>0){let e=o[0].startLineNumber,t=o[0].endLineNumber;for(let i=1,n=o.length;i<n;i++){const n=o[i];e=Math.min(e,n.startLineNumber),t=Math.max(t,n.endLineNumber)}h=!1,c=this._context.viewLayout.getVerticalOffsetForLineNumber(e),d=this._context.viewLayout.getVerticalOffsetForLineNumber(t)+this._lineHeight}else{if(!n)return-1;h=!0,c=this._context.viewLayout.getVerticalOffsetForLineNumber(n.startLineNumber),d=this._context.viewLayout.getVerticalOffsetForLineNumber(n.endLineNumber)+this._lineHeight}let u,g=0,m=0;if("mouse"!==t&&!i||"default"!==this._cursorSurroundingLinesStyle){const e=Math.min(a/this._lineHeight/2,this._cursorSurroundingLines);g=this._stickyScrollEnabled?Math.max(e,this._maxNumberStickyLines)*this._lineHeight:e*this._lineHeight,m=Math.max(0,e-1)*this._lineHeight}else i||(g=this._lineHeight);if(i||0!==s&&4!==s||(m+=this._lineHeight),c-=g,d+=m,d-c>a){if(!h)return-1;u=c}else if(5===s||6===s)if(6===s&&r<=c&&d<=l)u=r;else{const e=c-Math.max(5*this._lineHeight,.2*a),t=d-a;u=Math.max(t,e)}else if(1===s||2===s)if(2===s&&r<=c&&d<=l)u=r;else{const e=(c+d)/2;u=Math.max(0,e-a/2)}else u=this._computeMinimumScrolling(r,l,c,d,3===s,4===s);return u}_computeScrollLeftToReveal(e){const t=this._context.viewLayout.getCurrentViewport(),i=this._context.configuration.options.get(140),n=t.left,o=n+t.width-i.verticalScrollbarWidth;let s=1073741824,r=0;if("range"===e.type){const t=this._visibleRangesForLineRange(e.lineNumber,e.startColumn,e.endColumn);if(!t)return null;for(const e of t.ranges)s=Math.min(s,Math.round(e.left)),r=Math.max(r,Math.round(e.left+e.width))}else for(const t of e.selections){if(t.startLineNumber!==t.endLineNumber)return null;const e=this._visibleRangesForLineRange(t.startLineNumber,t.startColumn,t.endColumn);if(!e)return null;for(const t of e.ranges)s=Math.min(s,Math.round(t.left)),r=Math.max(r,Math.round(t.left+t.width))}return e.minimalReveal||(s=Math.max(0,s-An.HORIZONTAL_EXTRA_PX),r+=this._revealHorizontalRightPadding),"selections"===e.type&&r-s>t.width?null:{scrollLeft:this._computeMinimumScrolling(n,o,s,r),maxHorizontalOffset:r}}_computeMinimumScrolling(e,t,i,n,o,s){o=!!o,s=!!s;const r=(t|=0)-(e|=0);return(n|=0)-(i|=0)<r?o?i:s?Math.max(0,n-r):i<e?i:n>t?Math.max(0,n-r):e:i}}An.HORIZONTAL_EXTRA_PX=30;var _n=i(9688);l()(_n.A,{insert:"head",singleton:!1}),_n.A.locals;class wn extends sn{constructor(e){super(),this._context=e;const t=this._context.configuration.options.get(140);this._decorationsLeft=t.decorationsLeft,this._decorationsWidth=t.decorationsWidth,this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options.get(140);return this._decorationsLeft=t.decorationsLeft,this._decorationsWidth=t.decorationsWidth,!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}_getDecorations(e){const t=e.getDecorationsInViewport(),i=[];let n=0;for(let e=0,o=t.length;e<o;e++){const o=t[e],s=o.options.linesDecorationsClassName,r=o.options.zIndex;s&&(i[n++]=new tn(o.range.startLineNumber,o.range.endLineNumber,s,r));const a=o.options.firstLineDecorationClassName;a&&(i[n++]=new tn(o.range.startLineNumber,o.range.startLineNumber,a,r))}return i}prepareRender(e){const t=e.visibleRange.startLineNumber,i=e.visibleRange.endLineNumber,n=this._render(t,i,this._getDecorations(e),1),o='" style="left:'+this._decorationsLeft.toString()+"px;width:"+this._decorationsWidth.toString()+'px;"></div>',s=[];for(let e=t;e<=i;e++){const i=e-t,r=n[i].getLaneDecorations(1);let a="";for(const e of r)a+='<div class="cldr '+e.className+o;s[i]=a}this._renderResult=s}render(e,t){return this._renderResult?this._renderResult[t-e]:""}}var bn=i(8346);l()(bn.A,{insert:"head",singleton:!1}),bn.A.locals;class vn extends sn{constructor(e){super(),this._context=e,this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){return!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}_getDecorations(e){const t=e.getDecorationsInViewport(),i=[];let n=0;for(let e=0,o=t.length;e<o;e++){const o=t[e],s=o.options.marginClassName,r=o.options.zIndex;s&&(i[n++]=new tn(o.range.startLineNumber,o.range.endLineNumber,s,r))}return i}prepareRender(e){const t=e.visibleRange.startLineNumber,i=e.visibleRange.endLineNumber,n=this._render(t,i,this._getDecorations(e),1),o=[];for(let e=t;e<=i;e++){const i=e-t,s=n[i].getLaneDecorations(1);let r="";for(const e of s)r+='<div class="cmdr '+e.className+'" style=""></div>';o[i]=r}this._renderResult=o}render(e,t){return this._renderResult?this._renderResult[t-e]:""}}var Cn=i(7974);l()(Cn.A,{insert:"head",singleton:!1}),Cn.A.locals;class yn{constructor(e,t,i,n){this._rgba8Brand=void 0,this.r=yn._clamp(e),this.g=yn._clamp(t),this.b=yn._clamp(i),this.a=yn._clamp(n)}equals(e){return this.r===e.r&&this.g===e.g&&this.b===e.b&&this.a===e.a}static _clamp(e){return e<0?0:e>255?255:0|e}}yn.Empty=new yn(0,0,0,0);class Sn extends m.jG{static getInstance(){return this._INSTANCE||(this._INSTANCE=(0,m.lC)(new Sn)),this._INSTANCE}constructor(){super(),this._onDidChange=new g.vl,this.onDidChange=this._onDidChange.event,this._updateColorMap(),this._register(yt.dG.onDidChange((e=>{e.changedColorMap&&this._updateColorMap()})))}_updateColorMap(){const e=yt.dG.getColorMap();if(!e)return this._colors=[yn.Empty],void(this._backgroundIsLight=!0);this._colors=[yn.Empty];for(let t=1;t<e.length;t++){const i=e[t].rgba;this._colors[t]=new yn(i.r,i.g,i.b,Math.round(255*i.a))}const t=e[2].getRelativeLuminance();this._backgroundIsLight=t>=.5,this._onDidChange.fire(void 0)}getColor(e){return(e<1||e>=this._colors.length)&&(e=2),this._colors[e]}backgroundIsLight(){return this._backgroundIsLight}}Sn._INSTANCE=null;var kn=i(7870);const En=(()=>{const e=[];for(let t=32;t<=126;t++)e.push(t);return e.push(65533),e})();var Dn=i(946);class xn{constructor(e,t){this.scale=t,this._minimapCharRendererBrand=void 0,this.charDataNormal=xn.soften(e,.8),this.charDataLight=xn.soften(e,50/60)}static soften(e,t){const i=new Uint8ClampedArray(e.length);for(let n=0,o=e.length;n<o;n++)i[n]=(0,Dn.W)(e[n]*t);return i}renderChar(e,t,i,n,o,s,r,a,l,h,c){const d=1*this.scale,u=2*this.scale,g=c?1:u;if(t+d>e.width||i+g>e.height)return void console.warn("bad render request outside image data");const m=h?this.charDataLight:this.charDataNormal,p=((e,t)=>(e-=32)<0||e>96?t<=2?(e+96)%96:95:e)(n,l),f=4*e.width,A=r.r,_=r.g,w=r.b,b=o.r-A,v=o.g-_,C=o.b-w,y=Math.max(s,a),S=e.data;let k=p*d*u,E=i*f+4*t;for(let e=0;e<g;e++){let e=E;for(let t=0;t<d;t++){const t=m[k++]/255*(s/255);S[e++]=A+b*t,S[e++]=_+v*t,S[e++]=w+C*t,S[e++]=y}E+=f}}blockRenderChar(e,t,i,n,o,s,r,a){const l=1*this.scale,h=2*this.scale,c=a?1:h;if(t+l>e.width||i+c>e.height)return void console.warn("bad render request outside image data");const d=4*e.width,u=o/255*.5,g=s.r,m=s.g,p=s.b,f=g+(n.r-g)*u,A=m+(n.g-m)*u,_=p+(n.b-p)*u,w=Math.max(o,r),b=e.data;let v=i*d+4*t;for(let e=0;e<c;e++){let e=v;for(let t=0;t<l;t++)b[e++]=f,b[e++]=A,b[e++]=_,b[e++]=w;v+=d}}}var Ln=i(1387);const Mn={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15},In=e=>{const t=new Uint8ClampedArray(e.length/2);for(let i=0;i<e.length;i+=2)t[i>>1]=Mn[e[i]]<<4|15&Mn[e[i+1]];return t},Bn={1:(0,Ln.O)((()=>In("0000511D6300CF609C709645A78432005642574171487021003C451900274D35D762755E8B629C5BA856AF57BA649530C167D1512A272A3F6038604460398526BCA2A968DB6F8957C768BE5FBE2FB467CF5D8D5B795DC7625B5DFF50DE64C466DB2FC47CD860A65E9A2EB96CB54CE06DA763AB2EA26860524D3763536601005116008177A8705E53AB738E6A982F88BAA35B5F5B626D9C636B449B737E5B7B678598869A662F6B5B8542706C704C80736A607578685B70594A49715A4522E792"))),2:(0,Ln.O)((()=>In("000000000000000055394F383D2800008B8B1F210002000081B1CBCBCC820000847AAF6B9AAF2119BE08B8881AD60000A44FD07DCCF107015338130C00000000385972265F390B406E2437634B4B48031B12B8A0847000001E15B29A402F0000000000004B33460B00007A752C2A0000000000004D3900000084394B82013400ABA5CFC7AD9C0302A45A3E5A98AB000089A43382D97900008BA54AA087A70A0248A6A7AE6DBE0000BF6F94987EA40A01A06DCFA7A7A9030496C32F77891D0000A99FB1A0AFA80603B29AB9CA75930D010C0948354D3900000C0948354F37460D0028BE673D8400000000AF9D7B6E00002B007AA8933400007AA642675C2700007984CFB9C3985B768772A8A6B7B20000CAAECAAFC4B700009F94A6009F840009D09F9BA4CA9C0000CC8FC76DC87F0000C991C472A2000000A894A48CA7B501079BA2C9C69BA20000B19A5D3FA89000005CA6009DA2960901B0A7F0669FB200009D009E00B7890000DAD0F5D092820000D294D4C48BD10000B5A7A4A3B1A50402CAB6CBA6A2000000B5A7A4A3B1A8044FCDADD19D9CB00000B7778F7B8AAE0803C9AB5D3F5D3F00009EA09EA0BAB006039EA0989A8C7900009B9EF4D6B7C00000A9A7816CACA80000ABAC84705D3F000096DA635CDC8C00006F486F266F263D4784006124097B00374F6D2D6D2D6D4A3A95872322000000030000000000008D8939130000000000002E22A5C9CBC70600AB25C0B5C9B400061A2DB04CA67001082AA6BEBEBFC606002321DACBC19E03087AA08B6768380000282FBAC0B8CA7A88AD25BBA5A29900004C396C5894A6000040485A6E356E9442A32CD17EADA70000B4237923628600003E2DE9C1D7B500002F25BBA5A2990000231DB6AFB4A804023025C0B5CAB588062B2CBDBEC0C706882435A75CA20000002326BD6A82A908048B4B9A5A668000002423A09CB4BB060025259C9D8A7900001C1FCAB2C7C700002A2A9387ABA200002626A4A47D6E9D14333163A0C87500004B6F9C2D643A257049364936493647358A34438355497F1A0000A24C1D590000D38DFFBDD4CD3126")))};class Nn{static create(e,t){if(this.lastCreated&&e===this.lastCreated.scale&&t===this.lastFontFamily)return this.lastCreated;let i;return i=Bn[e]?new xn(Bn[e](),e):Nn.createFromSampleData(Nn.createSampleData(t).data,e),this.lastFontFamily=t,this.lastCreated=i,i}static createSampleData(e){const t=document.createElement("canvas"),i=t.getContext("2d");t.style.height="16px",t.height=16,t.width=960,t.style.width="960px",i.fillStyle="#ffffff",i.font=`bold 16px ${e}`,i.textBaseline="middle";let n=0;for(const e of En)i.fillText(String.fromCharCode(e),n,8),n+=10;return i.getImageData(0,0,960,16)}static createFromSampleData(e,t){if(61440!==e.length)throw new Error("Unexpected source in MinimapCharRenderer");const i=Nn._downsample(e,t);return new xn(i,t)}static _downsampleChar(e,t,i,n,o){const s=1*o,r=2*o;let a=n,l=0;for(let n=0;n<r;n++){const o=n/r*16,h=(n+1)/r*16;for(let n=0;n<s;n++){const r=n/s*10,c=(n+1)/s*10;let d=0,u=0;for(let i=o;i<h;i++){const n=t+3840*Math.floor(i),o=1-(i-Math.floor(i));for(let t=r;t<c;t++){const i=1-(t-Math.floor(t)),s=n+4*Math.floor(t),r=i*o;u+=r,d+=e[s]*e[s+3]/255*r}}const g=d/u;l=Math.max(l,g),i[a++]=(0,Dn.W)(g)}}return l}static _downsample(e,t){const i=2*t*1*t,n=96*i,o=new Uint8ClampedArray(n);let s=0,r=0,a=0;for(let n=0;n<96;n++)a=Math.max(a,this._downsampleChar(e,r,o,s,t)),s+=i,r+=40;if(a>0){const e=255/a;for(let t=0;t<n;t++)o[t]*=e}return o}}var Tn=i(9853);class Fn{constructor(e,t,i){const n=e.options,o=n.get(138),s=n.get(140),r=s.minimap,a=n.get(48),l=n.get(70);this.renderMinimap=r.renderMinimap,this.size=l.size,this.minimapHeightIsEditorHeight=r.minimapHeightIsEditorHeight,this.scrollBeyondLastLine=n.get(101),this.paddingTop=n.get(81).top,this.paddingBottom=n.get(81).bottom,this.showSlider=l.showSlider,this.autohide=l.autohide,this.pixelRatio=o,this.typicalHalfwidthCharacterWidth=a.typicalHalfwidthCharacterWidth,this.lineHeight=n.get(64),this.minimapLeft=r.minimapLeft,this.minimapWidth=r.minimapWidth,this.minimapHeight=s.height,this.canvasInnerWidth=r.minimapCanvasInnerWidth,this.canvasInnerHeight=r.minimapCanvasInnerHeight,this.canvasOuterWidth=r.minimapCanvasOuterWidth,this.canvasOuterHeight=r.minimapCanvasOuterHeight,this.isSampling=r.minimapIsSampling,this.editorHeight=s.height,this.fontScale=r.minimapScale,this.minimapLineHeight=r.minimapLineHeight,this.minimapCharWidth=1*this.fontScale,this.charRenderer=(0,Ln.O)((()=>Nn.create(this.fontScale,a.fontFamily))),this.defaultBackgroundColor=i.getColor(2),this.backgroundColor=Fn._getMinimapBackground(t,this.defaultBackgroundColor),this.foregroundAlpha=Fn._getMinimapForegroundOpacity(t)}static _getMinimapBackground(e,t){const i=e.getColor(U.ILr);return i?new yn(i.rgba.r,i.rgba.g,i.rgba.b,Math.round(255*i.rgba.a)):t}static _getMinimapForegroundOpacity(e){const t=e.getColor(U.K1Z);return t?yn._clamp(Math.round(255*t.rgba.a)):255}equals(e){return this.renderMinimap===e.renderMinimap&&this.size===e.size&&this.minimapHeightIsEditorHeight===e.minimapHeightIsEditorHeight&&this.scrollBeyondLastLine===e.scrollBeyondLastLine&&this.paddingTop===e.paddingTop&&this.paddingBottom===e.paddingBottom&&this.showSlider===e.showSlider&&this.autohide===e.autohide&&this.pixelRatio===e.pixelRatio&&this.typicalHalfwidthCharacterWidth===e.typicalHalfwidthCharacterWidth&&this.lineHeight===e.lineHeight&&this.minimapLeft===e.minimapLeft&&this.minimapWidth===e.minimapWidth&&this.minimapHeight===e.minimapHeight&&this.canvasInnerWidth===e.canvasInnerWidth&&this.canvasInnerHeight===e.canvasInnerHeight&&this.canvasOuterWidth===e.canvasOuterWidth&&this.canvasOuterHeight===e.canvasOuterHeight&&this.isSampling===e.isSampling&&this.editorHeight===e.editorHeight&&this.fontScale===e.fontScale&&this.minimapLineHeight===e.minimapLineHeight&&this.minimapCharWidth===e.minimapCharWidth&&this.defaultBackgroundColor&&this.defaultBackgroundColor.equals(e.defaultBackgroundColor)&&this.backgroundColor&&this.backgroundColor.equals(e.backgroundColor)&&this.foregroundAlpha===e.foregroundAlpha}}class Rn{constructor(e,t,i,n,o,s,r,a,l){this.scrollTop=e,this.scrollHeight=t,this.sliderNeeded=i,this._computedSliderRatio=n,this.sliderTop=o,this.sliderHeight=s,this.topPaddingLineCount=r,this.startLineNumber=a,this.endLineNumber=l}getDesiredScrollTopFromDelta(e){return Math.round(this.scrollTop+e/this._computedSliderRatio)}getDesiredScrollTopFromTouchLocation(e){return Math.round((e-this.sliderHeight/2)/this._computedSliderRatio)}intersectWithViewport(e){const t=Math.max(this.startLineNumber,e.startLineNumber),i=Math.min(this.endLineNumber,e.endLineNumber);return t>i?null:[t,i]}getYForLineNumber(e,t){return+(e-this.startLineNumber+this.topPaddingLineCount)*t}static create(e,t,i,n,o,s,r,a,l,h,c){const d=e.pixelRatio,u=e.minimapLineHeight,g=Math.floor(e.canvasInnerHeight/u),m=e.lineHeight;if(e.minimapHeightIsEditorHeight){let t=a*e.lineHeight+e.paddingTop+e.paddingBottom;e.scrollBeyondLastLine&&(t+=Math.max(0,o-e.lineHeight-e.paddingBottom));const i=Math.max(1,Math.floor(o*o/t)),n=Math.max(0,e.minimapHeight-i),s=n/(h-o),c=l*s,d=n>0,u=Math.floor(e.canvasInnerHeight/e.minimapLineHeight),g=Math.floor(e.paddingTop/e.lineHeight);return new Rn(l,h,d,s,c,i,g,1,Math.min(r,u))}let p;if(s&&i!==r){const e=i-t+1;p=Math.floor(e*u/d)}else{const e=o/m;p=Math.floor(e*u/d)}const f=Math.floor(e.paddingTop/m);let A,_=Math.floor(e.paddingBottom/m);if(e.scrollBeyondLastLine){const e=o/m;_=Math.max(_,e-1)}A=_>0?(f+r+_-o/m-1)*u/d:Math.max(0,(f+r)*u/d-p),A=Math.min(e.minimapHeight-p,A);const w=A/(h-o),b=l*w;if(g>=f+r+_)return new Rn(l,h,A>0,w,b,p,f,1,r);{let i,o;i=t>1?t+f:Math.max(1,l/m);let s=Math.max(1,Math.floor(i-b*d/u));s<f?(o=f-s+1,s=1):(o=0,s=Math.max(1,s-f)),c&&c.scrollHeight===h&&(c.scrollTop>l&&(s=Math.min(s,c.startLineNumber),o=Math.max(o,c.topPaddingLineCount)),c.scrollTop<l&&(s=Math.max(s,c.startLineNumber),o=Math.min(o,c.topPaddingLineCount)));const a=Math.min(r,s-o+g-1),A=(l-n)/m;let _;return _=l>e.paddingTop?(t-s+o+A)*u/d:l/e.paddingTop*(o+A)*u/d,new Rn(l,h,!0,w,_,p,o,s,a)}}}class On{constructor(e){this.dy=e}onContentChanged(){this.dy=-1}onTokensChanged(){this.dy=-1}}On.INVALID=new On(-1);class Pn{constructor(e,t,i){this.renderedLayout=e,this._imageData=t,this._renderedLines=new Ti((()=>On.INVALID)),this._renderedLines._set(e.startLineNumber,i)}linesEquals(e){if(!this.scrollEquals(e))return!1;const t=this._renderedLines._get().lines;for(let e=0,i=t.length;e<i;e++)if(-1===t[e].dy)return!1;return!0}scrollEquals(e){return this.renderedLayout.startLineNumber===e.startLineNumber&&this.renderedLayout.endLineNumber===e.endLineNumber}_get(){const e=this._renderedLines._get();return{imageData:this._imageData,rendLineNumberStart:e.rendLineNumberStart,lines:e.lines}}onLinesChanged(e,t){return this._renderedLines.onLinesChanged(e,t)}onLinesDeleted(e,t){this._renderedLines.onLinesDeleted(e,t)}onLinesInserted(e,t){this._renderedLines.onLinesInserted(e,t)}onTokensChanged(e){return this._renderedLines.onTokensChanged(e)}}class zn{constructor(e,t,i,n){this._backgroundFillData=zn._createBackgroundFillData(t,i,n),this._buffers=[e.createImageData(t,i),e.createImageData(t,i)],this._lastUsedBuffer=0}getBuffer(){this._lastUsedBuffer=1-this._lastUsedBuffer;const e=this._buffers[this._lastUsedBuffer];return e.data.set(this._backgroundFillData),e}static _createBackgroundFillData(e,t,i){const n=i.r,o=i.g,s=i.b,r=i.a,a=new Uint8ClampedArray(e*t*4);let l=0;for(let i=0;i<t;i++)for(let t=0;t<e;t++)a[l]=n,a[l+1]=o,a[l+2]=s,a[l+3]=r,l+=4;return a}}class Qn{static compute(e,t,i){if(0===e.renderMinimap||!e.isSampling)return[null,[]];const{minimapLineCount:n}=D.xZ.computeContainedMinimapLineCount({viewLineCount:t,scrollBeyondLastLine:e.scrollBeyondLastLine,paddingTop:e.paddingTop,paddingBottom:e.paddingBottom,height:e.editorHeight,lineHeight:e.lineHeight,pixelRatio:e.pixelRatio}),o=t/n,s=o/2;if(!i||0===i.minimapLines.length){const e=[];if(e[0]=1,n>1){for(let t=0,i=n-1;t<i;t++)e[t]=Math.round(t*o+s);e[n-1]=t}return[new Qn(o,e),[]]}const r=i.minimapLines,a=r.length,l=[];let h=0,c=0,d=1,u=[],g=null;for(let e=0;e<n;e++){const i=Math.max(d,Math.round(e*o)),m=Math.max(i,Math.round((e+1)*o));for(;h<a&&r[h]<i;){if(u.length<10){const e=h+1+c;g&&"deleted"===g.type&&g._oldIndex===h-1?g.deleteToLineNumber++:(g={type:"deleted",_oldIndex:h,deleteFromLineNumber:e,deleteToLineNumber:e},u.push(g)),c--}h++}let p;if(h<a&&r[h]<=m)p=r[h],h++;else if(p=0===e?1:e+1===n?t:Math.round(e*o+s),u.length<10){const t=h+1+c;g&&"inserted"===g.type&&g._i===e-1?g.insertToLineNumber++:(g={type:"inserted",_i:e,insertFromLineNumber:t,insertToLineNumber:t},u.push(g)),c++}l[e]=p,d=p}if(u.length<10)for(;h<a;){const e=h+1+c;g&&"deleted"===g.type&&g._oldIndex===h-1?g.deleteToLineNumber++:(g={type:"deleted",_oldIndex:h,deleteFromLineNumber:e,deleteToLineNumber:e},u.push(g)),c--,h++}else u=[{type:"flush"}];return[new Qn(o,l),u]}constructor(e,t){this.samplingRatio=e,this.minimapLines=t}modelLineToMinimapLine(e){return Math.min(this.minimapLines.length,Math.max(1,Math.round(e/this.samplingRatio)))}modelLineRangeToMinimapLineRange(e,t){let i=this.modelLineToMinimapLine(e)-1;for(;i>0&&this.minimapLines[i-1]>=e;)i--;let n=this.modelLineToMinimapLine(t)-1;for(;n+1<this.minimapLines.length&&this.minimapLines[n+1]<=t;)n++;if(i===n){const n=this.minimapLines[i];if(n<e||n>t)return null}return[i+1,n+1]}decorationLineRangeToMinimapLineRange(e,t){let i=this.modelLineToMinimapLine(e),n=this.modelLineToMinimapLine(t);return e!==t&&n===i&&(n===this.minimapLines.length?i>1&&i--:n++),[i,n]}onLinesDeleted(e){const t=e.toLineNumber-e.fromLineNumber+1;let i=this.minimapLines.length,n=0;for(let o=this.minimapLines.length-1;o>=0&&!(this.minimapLines[o]<e.fromLineNumber);o--)this.minimapLines[o]<=e.toLineNumber?(this.minimapLines[o]=Math.max(1,e.fromLineNumber-1),i=Math.min(i,o),n=Math.max(n,o)):this.minimapLines[o]-=t;return[i,n]}onLinesInserted(e){const t=e.toLineNumber-e.fromLineNumber+1;for(let i=this.minimapLines.length-1;i>=0&&!(this.minimapLines[i]<e.fromLineNumber);i--)this.minimapLines[i]+=t}}class Hn extends se{constructor(e){super(e),this.tokensColorTracker=Sn.getInstance(),this._selections=[],this._minimapSelections=null,this.options=new Fn(this._context.configuration,this._context.theme,this.tokensColorTracker);const[t]=Qn.compute(this.options,this._context.viewModel.getLineCount(),null);this._samplingState=t,this._shouldCheckSampling=!1,this._actual=new Wn(e.theme,this)}dispose(){this._actual.dispose(),super.dispose()}getDomNode(){return this._actual.getDomNode()}_onOptionsMaybeChanged(){const e=new Fn(this._context.configuration,this._context.theme,this.tokensColorTracker);return!this.options.equals(e)&&(this.options=e,this._recreateLineSampling(),this._actual.onDidChangeOptions(),!0)}onConfigurationChanged(e){return this._onOptionsMaybeChanged()}onCursorStateChanged(e){return this._selections=e.selections,this._minimapSelections=null,this._actual.onSelectionChanged()}onDecorationsChanged(e){return!!e.affectsMinimap&&this._actual.onDecorationsChanged()}onFlushed(e){return this._samplingState&&(this._shouldCheckSampling=!0),this._actual.onFlushed()}onLinesChanged(e){if(this._samplingState){const t=this._samplingState.modelLineRangeToMinimapLineRange(e.fromLineNumber,e.fromLineNumber+e.count-1);return!!t&&this._actual.onLinesChanged(t[0],t[1]-t[0]+1)}return this._actual.onLinesChanged(e.fromLineNumber,e.count)}onLinesDeleted(e){if(this._samplingState){const[t,i]=this._samplingState.onLinesDeleted(e);return t<=i&&this._actual.onLinesChanged(t+1,i-t+1),this._shouldCheckSampling=!0,!0}return this._actual.onLinesDeleted(e.fromLineNumber,e.toLineNumber)}onLinesInserted(e){return this._samplingState?(this._samplingState.onLinesInserted(e),this._shouldCheckSampling=!0,!0):this._actual.onLinesInserted(e.fromLineNumber,e.toLineNumber)}onScrollChanged(e){return this._actual.onScrollChanged()}onThemeChanged(e){return this._actual.onThemeChanged(),this._onOptionsMaybeChanged(),!0}onTokensChanged(e){if(this._samplingState){const t=[];for(const i of e.ranges){const e=this._samplingState.modelLineRangeToMinimapLineRange(i.fromLineNumber,i.toLineNumber);e&&t.push({fromLineNumber:e[0],toLineNumber:e[1]})}return!!t.length&&this._actual.onTokensChanged(t)}return this._actual.onTokensChanged(e.ranges)}onTokensColorsChanged(e){return this._onOptionsMaybeChanged(),this._actual.onTokensColorsChanged()}onZonesChanged(e){return this._actual.onZonesChanged()}prepareRender(e){this._shouldCheckSampling&&(this._shouldCheckSampling=!1,this._recreateLineSampling())}render(e){let t=e.visibleRange.startLineNumber,i=e.visibleRange.endLineNumber;this._samplingState&&(t=this._samplingState.modelLineToMinimapLine(t),i=this._samplingState.modelLineToMinimapLine(i));const n={viewportContainsWhitespaceGaps:e.viewportData.whitespaceViewportData.length>0,scrollWidth:e.scrollWidth,scrollHeight:e.scrollHeight,viewportStartLineNumber:t,viewportEndLineNumber:i,viewportStartLineNumberVerticalOffset:e.getVerticalOffsetForLineNumber(t),scrollTop:e.scrollTop,scrollLeft:e.scrollLeft,viewportWidth:e.viewportWidth,viewportHeight:e.viewportHeight};this._actual.render(n)}_recreateLineSampling(){this._minimapSelections=null;const e=Boolean(this._samplingState),[t,i]=Qn.compute(this.options,this._context.viewModel.getLineCount(),this._samplingState);if(this._samplingState=t,e&&this._samplingState)for(const e of i)switch(e.type){case"deleted":this._actual.onLinesDeleted(e.deleteFromLineNumber,e.deleteToLineNumber);break;case"inserted":this._actual.onLinesInserted(e.insertFromLineNumber,e.insertToLineNumber);break;case"flush":this._actual.onFlushed()}}getLineCount(){return this._samplingState?this._samplingState.minimapLines.length:this._context.viewModel.getLineCount()}getRealLineCount(){return this._context.viewModel.getLineCount()}getLineContent(e){return this._samplingState?this._context.viewModel.getLineContent(this._samplingState.minimapLines[e-1]):this._context.viewModel.getLineContent(e)}getLineMaxColumn(e){return this._samplingState?this._context.viewModel.getLineMaxColumn(this._samplingState.minimapLines[e-1]):this._context.viewModel.getLineMaxColumn(e)}getMinimapLinesRenderingData(e,t,i){if(this._samplingState){const n=[];for(let o=0,s=t-e+1;o<s;o++)i[o]?n[o]=this._context.viewModel.getViewLineData(this._samplingState.minimapLines[e+o-1]):n[o]=null;return n}return this._context.viewModel.getMinimapLinesRenderingData(e,t,i).data}getSelections(){if(null===this._minimapSelections)if(this._samplingState){this._minimapSelections=[];for(const e of this._selections){const[t,i]=this._samplingState.decorationLineRangeToMinimapLineRange(e.startLineNumber,e.endLineNumber);this._minimapSelections.push(new P.L(t,e.startColumn,i,e.endColumn))}}else this._minimapSelections=this._selections;return this._minimapSelections}getMinimapDecorationsInViewport(e,t){let i;if(this._samplingState){const n=this._samplingState.minimapLines[e-1],o=this._samplingState.minimapLines[t-1];i=new xe.Q(n,1,o,this._context.viewModel.getLineMaxColumn(o))}else i=new xe.Q(e,1,t,this._context.viewModel.getLineMaxColumn(t));const n=this._context.viewModel.getMinimapDecorationsInRange(i);if(this._samplingState){const e=[];for(const t of n){if(!t.options.minimap)continue;const i=t.range,n=this._samplingState.modelLineToMinimapLine(i.startLineNumber),o=this._samplingState.modelLineToMinimapLine(i.endLineNumber);e.push(new kn.vo(new xe.Q(n,i.startColumn,o,i.endColumn),t.options))}return e}return n}getOptions(){return this._context.viewModel.model.getOptions()}revealLineNumber(e){this._samplingState&&(e=this._samplingState.minimapLines[e-1]),this._context.viewModel.revealRange("mouse",!1,new xe.Q(e,1,e,1),1,0)}setScrollTop(e){this._context.viewModel.viewLayout.setScrollPosition({scrollTop:e},1)}}class Wn extends m.jG{constructor(e,t){super(),this._renderDecorations=!1,this._gestureInProgress=!1,this._theme=e,this._model=t,this._lastRenderData=null,this._buffers=null,this._selectionColor=this._theme.getColor(U.yr0),this._domNode=(0,z.Z)(document.createElement("div")),re.write(this._domNode,8),this._domNode.setClassName(this._getMinimapDomNodeClassName()),this._domNode.setPosition("absolute"),this._domNode.setAttribute("role","presentation"),this._domNode.setAttribute("aria-hidden","true"),this._shadow=(0,z.Z)(document.createElement("div")),this._shadow.setClassName("minimap-shadow-hidden"),this._domNode.appendChild(this._shadow),this._canvas=(0,z.Z)(document.createElement("canvas")),this._canvas.setPosition("absolute"),this._canvas.setLeft(0),this._domNode.appendChild(this._canvas),this._decorationsCanvas=(0,z.Z)(document.createElement("canvas")),this._decorationsCanvas.setPosition("absolute"),this._decorationsCanvas.setClassName("minimap-decorations-layer"),this._decorationsCanvas.setLeft(0),this._domNode.appendChild(this._decorationsCanvas),this._slider=(0,z.Z)(document.createElement("div")),this._slider.setPosition("absolute"),this._slider.setClassName("minimap-slider"),this._slider.setLayerHinting(!0),this._slider.setContain("strict"),this._domNode.appendChild(this._slider),this._sliderHorizontal=(0,z.Z)(document.createElement("div")),this._sliderHorizontal.setPosition("absolute"),this._sliderHorizontal.setClassName("minimap-slider-horizontal"),this._slider.appendChild(this._sliderHorizontal),this._applyLayout(),this._pointerDownListener=d.b2(this._domNode.domNode,d.Bx.POINTER_DOWN,(e=>{if(e.preventDefault(),0===this._model.options.renderMinimap)return;if(!this._lastRenderData)return;if("proportional"!==this._model.options.size){if(0===e.button&&this._lastRenderData){const t=d.BK(this._slider.domNode),i=t.top+t.height/2;this._startSliderDragging(e,i,this._lastRenderData.renderedLayout)}return}const t=this._model.options.minimapLineHeight,i=this._model.options.canvasInnerHeight/this._model.options.canvasOuterHeight*e.offsetY;let n=Math.floor(i/t)+this._lastRenderData.renderedLayout.startLineNumber-this._lastRenderData.renderedLayout.topPaddingLineCount;n=Math.min(n,this._model.getLineCount()),this._model.revealLineNumber(n)})),this._sliderPointerMoveMonitor=new W._,this._sliderPointerDownListener=d.b2(this._slider.domNode,d.Bx.POINTER_DOWN,(e=>{e.preventDefault(),e.stopPropagation(),0===e.button&&this._lastRenderData&&this._startSliderDragging(e,e.pageY,this._lastRenderData.renderedLayout)})),this._gestureDisposable=Q.q.addTarget(this._domNode.domNode),this._sliderTouchStartListener=d.ko(this._domNode.domNode,Q.B.Start,(e=>{e.preventDefault(),e.stopPropagation(),this._lastRenderData&&(this._slider.toggleClassName("active",!0),this._gestureInProgress=!0,this.scrollDueToTouchEvent(e))}),{passive:!1}),this._sliderTouchMoveListener=d.ko(this._domNode.domNode,Q.B.Change,(e=>{e.preventDefault(),e.stopPropagation(),this._lastRenderData&&this._gestureInProgress&&this.scrollDueToTouchEvent(e)}),{passive:!1}),this._sliderTouchEndListener=d.b2(this._domNode.domNode,Q.B.End,(e=>{e.preventDefault(),e.stopPropagation(),this._gestureInProgress=!1,this._slider.toggleClassName("active",!1)}))}_startSliderDragging(e,t,i){if(!(e.target&&e.target instanceof Element))return;const n=e.pageX;this._slider.toggleClassName("active",!0);const o=(e,o)=>{const s=d.BK(this._domNode.domNode),r=Math.min(Math.abs(o-n),Math.abs(o-s.left),Math.abs(o-s.left-s.width));if(w.uF&&r>140)return void this._model.setScrollTop(i.scrollTop);const a=e-t;this._model.setScrollTop(i.getDesiredScrollTopFromDelta(a))};e.pageY!==t&&o(e.pageY,n),this._sliderPointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>o(e.pageY,e.pageX)),(()=>{this._slider.toggleClassName("active",!1)}))}scrollDueToTouchEvent(e){const t=this._domNode.domNode.getBoundingClientRect().top,i=this._lastRenderData.renderedLayout.getDesiredScrollTopFromTouchLocation(e.pageY-t);this._model.setScrollTop(i)}dispose(){this._pointerDownListener.dispose(),this._sliderPointerMoveMonitor.dispose(),this._sliderPointerDownListener.dispose(),this._gestureDisposable.dispose(),this._sliderTouchStartListener.dispose(),this._sliderTouchMoveListener.dispose(),this._sliderTouchEndListener.dispose(),super.dispose()}_getMinimapDomNodeClassName(){const e=["minimap"];return"always"===this._model.options.showSlider?e.push("slider-always"):e.push("slider-mouseover"),this._model.options.autohide&&e.push("autohide"),e.join(" ")}getDomNode(){return this._domNode}_applyLayout(){this._domNode.setLeft(this._model.options.minimapLeft),this._domNode.setWidth(this._model.options.minimapWidth),this._domNode.setHeight(this._model.options.minimapHeight),this._shadow.setHeight(this._model.options.minimapHeight),this._canvas.setWidth(this._model.options.canvasOuterWidth),this._canvas.setHeight(this._model.options.canvasOuterHeight),this._canvas.domNode.width=this._model.options.canvasInnerWidth,this._canvas.domNode.height=this._model.options.canvasInnerHeight,this._decorationsCanvas.setWidth(this._model.options.canvasOuterWidth),this._decorationsCanvas.setHeight(this._model.options.canvasOuterHeight),this._decorationsCanvas.domNode.width=this._model.options.canvasInnerWidth,this._decorationsCanvas.domNode.height=this._model.options.canvasInnerHeight,this._slider.setWidth(this._model.options.minimapWidth)}_getBuffer(){return this._buffers||this._model.options.canvasInnerWidth>0&&this._model.options.canvasInnerHeight>0&&(this._buffers=new zn(this._canvas.domNode.getContext("2d"),this._model.options.canvasInnerWidth,this._model.options.canvasInnerHeight,this._model.options.backgroundColor)),this._buffers?this._buffers.getBuffer():null}onDidChangeOptions(){this._lastRenderData=null,this._buffers=null,this._applyLayout(),this._domNode.setClassName(this._getMinimapDomNodeClassName())}onSelectionChanged(){return this._renderDecorations=!0,!0}onDecorationsChanged(){return this._renderDecorations=!0,!0}onFlushed(){return this._lastRenderData=null,!0}onLinesChanged(e,t){return!!this._lastRenderData&&this._lastRenderData.onLinesChanged(e,t)}onLinesDeleted(e,t){var i;return null===(i=this._lastRenderData)||void 0===i||i.onLinesDeleted(e,t),!0}onLinesInserted(e,t){var i;return null===(i=this._lastRenderData)||void 0===i||i.onLinesInserted(e,t),!0}onScrollChanged(){return this._renderDecorations=!0,!0}onThemeChanged(){return this._selectionColor=this._theme.getColor(U.yr0),this._renderDecorations=!0,!0}onTokensChanged(e){return!!this._lastRenderData&&this._lastRenderData.onTokensChanged(e)}onTokensColorsChanged(){return this._lastRenderData=null,this._buffers=null,!0}onZonesChanged(){return this._lastRenderData=null,!0}render(e){if(0===this._model.options.renderMinimap)return this._shadow.setClassName("minimap-shadow-hidden"),this._sliderHorizontal.setWidth(0),void this._sliderHorizontal.setHeight(0);e.scrollLeft+e.viewportWidth>=e.scrollWidth?this._shadow.setClassName("minimap-shadow-hidden"):this._shadow.setClassName("minimap-shadow-visible");const t=Rn.create(this._model.options,e.viewportStartLineNumber,e.viewportEndLineNumber,e.viewportStartLineNumberVerticalOffset,e.viewportHeight,e.viewportContainsWhitespaceGaps,this._model.getLineCount(),this._model.getRealLineCount(),e.scrollTop,e.scrollHeight,this._lastRenderData?this._lastRenderData.renderedLayout:null);this._slider.setDisplay(t.sliderNeeded?"block":"none"),this._slider.setTop(t.sliderTop),this._slider.setHeight(t.sliderHeight),this._sliderHorizontal.setLeft(0),this._sliderHorizontal.setWidth(this._model.options.minimapWidth),this._sliderHorizontal.setTop(0),this._sliderHorizontal.setHeight(t.sliderHeight),this.renderDecorations(t),this._lastRenderData=this.renderLines(t)}renderDecorations(e){if(this._renderDecorations){this._renderDecorations=!1;const t=this._model.getSelections();t.sort(xe.Q.compareRangesUsingStarts);const i=this._model.getMinimapDecorationsInViewport(e.startLineNumber,e.endLineNumber);i.sort(((e,t)=>(e.options.zIndex||0)-(t.options.zIndex||0)));const{canvasInnerWidth:n,canvasInnerHeight:o}=this._model.options,s=this._model.options.minimapLineHeight,r=this._model.options.minimapCharWidth,a=this._model.getOptions().tabSize,l=this._decorationsCanvas.domNode.getContext("2d");l.clearRect(0,0,n,o);const h=new Vn(e.startLineNumber,e.endLineNumber,!1);this._renderSelectionLineHighlights(l,t,h,e,s),this._renderDecorationsLineHighlights(l,i,h,e,s);const c=new Vn(e.startLineNumber,e.endLineNumber,null);this._renderSelectionsHighlights(l,t,c,e,s,a,r,n),this._renderDecorationsHighlights(l,i,c,e,s,a,r,n)}}_renderSelectionLineHighlights(e,t,i,n,o){if(!this._selectionColor||this._selectionColor.isTransparent())return;e.fillStyle=this._selectionColor.transparent(.5).toString();let s=0,r=0;for(const a of t){const t=n.intersectWithViewport(a);if(!t)continue;const[l,h]=t;for(let e=l;e<=h;e++)i.set(e,!0);const c=n.getYForLineNumber(l,o),d=n.getYForLineNumber(h,o);r>=c||(r>s&&e.fillRect(D.xq,s,e.canvas.width,r-s),s=c),r=d}r>s&&e.fillRect(D.xq,s,e.canvas.width,r-s)}_renderDecorationsLineHighlights(e,t,i,n,o){const s=new Map;for(let r=t.length-1;r>=0;r--){const a=t[r],l=a.options.minimap;if(!l||l.position!==Tn.R3.Inline)continue;const h=n.intersectWithViewport(a.range);if(!h)continue;const[c,d]=h,u=l.getColor(this._theme.value);if(!u||u.isTransparent())continue;let g=s.get(u.toString());g||(g=u.transparent(.5).toString(),s.set(u.toString(),g)),e.fillStyle=g;for(let t=c;t<=d;t++){if(i.has(t))continue;i.set(t,!0);const s=n.getYForLineNumber(c,o);e.fillRect(D.xq,s,e.canvas.width,o)}}}_renderSelectionsHighlights(e,t,i,n,o,s,r,a){if(this._selectionColor&&!this._selectionColor.isTransparent())for(const l of t){const t=n.intersectWithViewport(l);if(!t)continue;const[h,c]=t;for(let t=h;t<=c;t++)this.renderDecorationOnLine(e,i,l,this._selectionColor,n,t,o,o,s,r,a)}}_renderDecorationsHighlights(e,t,i,n,o,s,r,a){for(const l of t){const t=l.options.minimap;if(!t)continue;const h=n.intersectWithViewport(l.range);if(!h)continue;const[c,d]=h,u=t.getColor(this._theme.value);if(u&&!u.isTransparent())for(let h=c;h<=d;h++)switch(t.position){case Tn.R3.Inline:this.renderDecorationOnLine(e,i,l.range,u,n,h,o,o,s,r,a);continue;case Tn.R3.Gutter:{const t=n.getYForLineNumber(h,o),i=2;this.renderDecoration(e,u,i,t,2,o);continue}}}}renderDecorationOnLine(e,t,i,n,o,s,r,a,l,h,c){const d=o.getYForLineNumber(s,a);if(d+r<0||d>this._model.options.canvasInnerHeight)return;const{startLineNumber:u,endLineNumber:g}=i,m=u===s?i.startColumn:1,p=g===s?i.endColumn:this._model.getLineMaxColumn(s),f=this.getXOffsetForPosition(t,s,m,l,h,c),A=this.getXOffsetForPosition(t,s,p,l,h,c);this.renderDecoration(e,n,f,d,A-f,r)}getXOffsetForPosition(e,t,i,n,o,s){if(1===i)return D.xq;if((i-1)*o>=s)return s;let r=e.get(t);if(!r){const i=this._model.getLineContent(t);r=[D.xq];let a=D.xq;for(let e=1;e<i.length+1;e++){const t=i.charCodeAt(e-1),l=a+(9===t?n*o:tt.ne(t)?2*o:o);if(l>=s){r[e]=s;break}r[e]=l,a=l}e.set(t,r)}return i-1<r.length?r[i-1]:s}renderDecoration(e,t,i,n,o,s){e.fillStyle=t&&t.toString()||"",e.fillRect(i,n,o,s)}renderLines(e){const t=e.startLineNumber,i=e.endLineNumber,n=this._model.options.minimapLineHeight;if(this._lastRenderData&&this._lastRenderData.linesEquals(e)){const t=this._lastRenderData._get();return new Pn(e,t.imageData,t.lines)}const o=this._getBuffer();if(!o)return null;const[s,r,a]=Wn._renderUntouchedLines(o,e.topPaddingLineCount,t,i,n,this._lastRenderData),l=this._model.getMinimapLinesRenderingData(t,i,a),h=this._model.getOptions().tabSize,c=this._model.options.defaultBackgroundColor,d=this._model.options.backgroundColor,u=this._model.options.foregroundAlpha,g=this._model.tokensColorTracker,m=g.backgroundIsLight(),p=this._model.options.renderMinimap,f=this._model.options.charRenderer(),A=this._model.options.fontScale,_=this._model.options.minimapCharWidth,w=(1===p?2:3)*A,b=n>w?Math.floor((n-w)/2):0,v=d.a/255,C=new yn(Math.round((d.r-c.r)*v+c.r),Math.round((d.g-c.g)*v+c.g),Math.round((d.b-c.b)*v+c.b),255);let y=e.topPaddingLineCount*n;const S=[];for(let e=0,s=i-t+1;e<s;e++)a[e]&&Wn._renderLine(o,C,d.a,m,p,_,g,u,f,y,b,h,l[e],A,n),S[e]=new On(y),y+=n;const k=-1===s?0:s,E=(-1===r?o.height:r)-k;return this._canvas.domNode.getContext("2d").putImageData(o,0,0,0,k,o.width,E),new Pn(e,o,S)}static _renderUntouchedLines(e,t,i,n,o,s){const r=[];if(!s){for(let e=0,t=n-i+1;e<t;e++)r[e]=!0;return[-1,-1,r]}const a=s._get(),l=a.imageData.data,h=a.rendLineNumberStart,c=a.lines,d=c.length,u=e.width,g=e.data,m=(n-i+1)*o*u*4;let p=-1,f=-1,A=-1,_=-1,w=-1,b=-1,v=t*o;for(let e=i;e<=n;e++){const t=e-i,n=e-h,s=n>=0&&n<d?c[n].dy:-1;if(-1===s){r[t]=!0,v+=o;continue}const a=s*u*4,C=(s+o)*u*4,y=v*u*4,S=(v+o)*u*4;_===a&&b===y?(_=C,b=S):(-1!==A&&(g.set(l.subarray(A,_),w),-1===p&&0===A&&A===w&&(p=_),-1===f&&_===m&&A===w&&(f=A)),A=a,_=C,w=y,b=S),r[t]=!1,v+=o}return-1!==A&&(g.set(l.subarray(A,_),w),-1===p&&0===A&&A===w&&(p=_),-1===f&&_===m&&A===w&&(f=A)),[-1===p?-1:p/(4*u),-1===f?-1:f/(4*u),r]}static _renderLine(e,t,i,n,o,s,r,a,l,h,c,d,u,g,m){const p=u.content,f=u.tokens,A=e.width-s,_=1===m;let w=D.xq,b=0,v=0;for(let u=0,m=f.getCount();u<m;u++){const m=f.getEndOffset(u),C=f.getForeground(u),y=r.getColor(C);for(;b<m;b++){if(w>A)return;const r=p.charCodeAt(b);if(9===r){const e=d-(b+v)%d;v+=e-1,w+=e*s}else if(32===r)w+=s;else{const d=tt.ne(r)?2:1;for(let u=0;u<d;u++)if(2===o?l.blockRenderChar(e,w,h+c,y,a,t,i,_):l.renderChar(e,w,h+c,r,y,a,t,i,g,n,_),w+=s,w>A)return}}}}}class Vn{constructor(e,t,i){this._startLineNumber=e,this._endLineNumber=t,this._defaultValue=i,this._values=[];for(let e=0,t=this._endLineNumber-this._startLineNumber+1;e<t;e++)this._values[e]=i}has(e){return this.get(e)!==this._defaultValue}set(e,t){e<this._startLineNumber||e>this._endLineNumber||(this._values[e-this._startLineNumber]=t)}get(e){return e<this._startLineNumber||e>this._endLineNumber?this._defaultValue:this._values[e-this._startLineNumber]}}var Un=i(8298);l()(Un.A,{insert:"head",singleton:!1}),Un.A.locals;class jn extends se{constructor(e){super(e);const t=this._context.configuration.options.get(140);this._widgets={},this._verticalScrollbarWidth=t.verticalScrollbarWidth,this._minimapWidth=t.minimap.minimapWidth,this._horizontalScrollbarHeight=t.horizontalScrollbarHeight,this._editorHeight=t.height,this._editorWidth=t.width,this._domNode=(0,z.Z)(document.createElement("div")),re.write(this._domNode,4),this._domNode.setClassName("overlayWidgets")}dispose(){super.dispose(),this._widgets={}}getDomNode(){return this._domNode}onConfigurationChanged(e){const t=this._context.configuration.options.get(140);return this._verticalScrollbarWidth=t.verticalScrollbarWidth,this._minimapWidth=t.minimap.minimapWidth,this._horizontalScrollbarHeight=t.horizontalScrollbarHeight,this._editorHeight=t.height,this._editorWidth=t.width,!0}addWidget(e){const t=(0,z.Z)(e.getDomNode());this._widgets[e.getId()]={widget:e,preference:null,domNode:t},t.setPosition("absolute"),t.setAttribute("widgetId",e.getId()),this._domNode.appendChild(t),this.setShouldRender()}setWidgetPosition(e,t){const i=this._widgets[e.getId()];return i.preference!==t&&(i.preference=t,this.setShouldRender(),!0)}removeWidget(e){const t=e.getId();if(this._widgets.hasOwnProperty(t)){const e=this._widgets[t].domNode.domNode;delete this._widgets[t],e.parentNode.removeChild(e),this.setShouldRender()}}_renderWidget(e){const t=e.domNode;if(null!==e.preference)if(0===e.preference)t.setTop(0),t.setRight(2*this._verticalScrollbarWidth+this._minimapWidth);else if(1===e.preference){const e=t.domNode.clientHeight;t.setTop(this._editorHeight-e-2*this._horizontalScrollbarHeight),t.setRight(2*this._verticalScrollbarWidth+this._minimapWidth)}else 2===e.preference&&(t.setTop(0),t.domNode.style.right="50%");else t.setTop("")}prepareRender(e){}render(e){this._domNode.setWidth(this._editorWidth);const t=Object.keys(this._widgets);for(let e=0,i=t.length;e<i;e++){const i=t[e];this._renderWidget(this._widgets[i])}}}class Gn{constructor(e,t){const i=e.options;this.lineHeight=i.get(64),this.pixelRatio=i.get(138),this.overviewRulerLanes=i.get(80),this.renderBorder=i.get(79);const n=t.getColor(At.x9);this.borderColor=n?n.toString():null,this.hideCursor=i.get(57);const o=t.getColor(At.D0);this.cursorColor=o?o.transparent(.7).toString():null,this.themeType=t.type;const s=i.get(70),r=s.enabled,a=s.side,l=t.getColor(At.Xr),h=yt.dG.getDefaultBackground();this.backgroundColor=l||(r&&"right"===a?h:null);const c=i.get(140).overviewRuler;this.top=c.top,this.right=c.right,this.domWidth=c.width,this.domHeight=c.height,0===this.overviewRulerLanes?(this.canvasWidth=0,this.canvasHeight=0):(this.canvasWidth=this.domWidth*this.pixelRatio|0,this.canvasHeight=this.domHeight*this.pixelRatio|0);const[d,u]=this._initLanes(1,this.canvasWidth,this.overviewRulerLanes);this.x=d,this.w=u}_initLanes(e,t,i){const n=t-e;if(i>=3){const t=Math.floor(n/3),i=Math.floor(n/3),o=n-t-i,s=e+t;return[[0,e,s,e,e+t+o,e,s,e],[0,t,o,t+o,i,t+o+i,o+i,t+o+i]]}if(2===i){const t=Math.floor(n/2),i=n-t;return[[0,e,e,e,e+t,e,e,e],[0,t,t,t,i,t+i,t+i,t+i]]}return[[0,e,e,e,e,e,e,e],[0,n,n,n,n,n,n,n]]}equals(e){return this.lineHeight===e.lineHeight&&this.pixelRatio===e.pixelRatio&&this.overviewRulerLanes===e.overviewRulerLanes&&this.renderBorder===e.renderBorder&&this.borderColor===e.borderColor&&this.hideCursor===e.hideCursor&&this.cursorColor===e.cursorColor&&this.themeType===e.themeType&&St.Q1.equals(this.backgroundColor,e.backgroundColor)&&this.top===e.top&&this.right===e.right&&this.domWidth===e.domWidth&&this.domHeight===e.domHeight&&this.canvasWidth===e.canvasWidth&&this.canvasHeight===e.canvasHeight}}class Kn extends se{constructor(e){super(e),this._domNode=(0,z.Z)(document.createElement("canvas")),this._domNode.setClassName("decorationsOverviewRuler"),this._domNode.setPosition("absolute"),this._domNode.setLayerHinting(!0),this._domNode.setContain("strict"),this._domNode.setAttribute("aria-hidden","true"),this._updateSettings(!1),this._tokensColorTrackerListener=yt.dG.onDidChange((e=>{e.changedColorMap&&this._updateSettings(!0)})),this._cursorPositions=[]}dispose(){super.dispose(),this._tokensColorTrackerListener.dispose()}_updateSettings(e){const t=new Gn(this._context.configuration,this._context.theme);return!(this._settings&&this._settings.equals(t)||(this._settings=t,this._domNode.setTop(this._settings.top),this._domNode.setRight(this._settings.right),this._domNode.setWidth(this._settings.domWidth),this._domNode.setHeight(this._settings.domHeight),this._domNode.domNode.width=this._settings.canvasWidth,this._domNode.domNode.height=this._settings.canvasHeight,e&&this._render(),0))}onConfigurationChanged(e){return this._updateSettings(!1)}onCursorStateChanged(e){this._cursorPositions=[];for(let t=0,i=e.selections.length;t<i;t++)this._cursorPositions[t]=e.selections[t].getPosition();return this._cursorPositions.sort(De.y.compare),!0}onDecorationsChanged(e){return!!e.affectsOverviewRuler}onFlushed(e){return!0}onScrollChanged(e){return e.scrollHeightChanged}onZonesChanged(e){return!0}onThemeChanged(e){return this._updateSettings(!1)}getDomNode(){return this._domNode.domNode}prepareRender(e){}render(e){this._render()}_render(){const e=this._settings.backgroundColor;if(0===this._settings.overviewRulerLanes)return this._domNode.setBackgroundColor(e?St.Q1.Format.CSS.formatHexA(e):""),void this._domNode.setDisplay("none");this._domNode.setDisplay("block");const t=this._settings.canvasWidth,i=this._settings.canvasHeight,n=this._settings.lineHeight,o=this._context.viewLayout,s=i/this._context.viewLayout.getScrollHeight(),r=this._context.viewModel.getAllOverviewRulerDecorations(this._context.theme),a=6*this._settings.pixelRatio|0,l=a/2|0,h=this._domNode.domNode.getContext("2d");e?e.isOpaque()?(h.fillStyle=St.Q1.Format.CSS.formatHexA(e),h.fillRect(0,0,t,i)):(h.clearRect(0,0,t,i),h.fillStyle=St.Q1.Format.CSS.formatHexA(e),h.fillRect(0,0,t,i)):h.clearRect(0,0,t,i);const c=this._settings.x,d=this._settings.w;r.sort(kn.Uv.cmp);for(const e of r){const t=e.color,r=e.data;h.fillStyle=t;let u=0,g=0,m=0;for(let e=0,t=r.length/3;e<t;e++){const t=r[3*e],p=r[3*e+1],f=r[3*e+2];let A=o.getVerticalOffsetForLineNumber(p)*s|0,_=(o.getVerticalOffsetForLineNumber(f)+n)*s|0;if(_-A<a){let e=(A+_)/2|0;e<l?e=l:e+l>i&&(e=i-l),A=e-l,_=e+l}A>m+1||t!==u?(0!==e&&h.fillRect(c[u],g,d[u],m-g),u=t,g=A,m=_):_>m&&(m=_)}h.fillRect(c[u],g,d[u],m-g)}if(!this._settings.hideCursor&&this._settings.cursorColor){const e=2*this._settings.pixelRatio|0,t=e/2|0,n=this._settings.x[7],r=this._settings.w[7];h.fillStyle=this._settings.cursorColor;let a=-100,l=-100;for(let c=0,d=this._cursorPositions.length;c<d;c++){const d=this._cursorPositions[c];let u=o.getVerticalOffsetForLineNumber(d.lineNumber)*s|0;u<t?u=t:u+t>i&&(u=i-t);const g=u-t,m=g+e;g>l+1?(0!==c&&h.fillRect(n,a,r,l-a),a=g,l=m):m>l&&(l=m)}h.fillRect(n,a,r,l-a)}this._settings.renderBorder&&this._settings.borderColor&&this._settings.overviewRulerLanes>0&&(h.beginPath(),h.lineWidth=1,h.strokeStyle=this._settings.borderColor,h.moveTo(0,0),h.lineTo(0,i),h.stroke(),h.moveTo(0,0),h.lineTo(t,0),h.stroke())}}var Yn=i(8361);class Jn extends oe{constructor(e,t){super(),this._context=e;const i=this._context.configuration.options;this._domNode=(0,z.Z)(document.createElement("canvas")),this._domNode.setClassName(t),this._domNode.setPosition("absolute"),this._domNode.setLayerHinting(!0),this._domNode.setContain("strict"),this._zoneManager=new Yn.rW((e=>this._context.viewLayout.getVerticalOffsetForLineNumber(e))),this._zoneManager.setDOMWidth(0),this._zoneManager.setDOMHeight(0),this._zoneManager.setOuterHeight(this._context.viewLayout.getScrollHeight()),this._zoneManager.setLineHeight(i.get(64)),this._zoneManager.setPixelRatio(i.get(138)),this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options;return e.hasChanged(64)&&(this._zoneManager.setLineHeight(t.get(64)),this._render()),e.hasChanged(138)&&(this._zoneManager.setPixelRatio(t.get(138)),this._domNode.setWidth(this._zoneManager.getDOMWidth()),this._domNode.setHeight(this._zoneManager.getDOMHeight()),this._domNode.domNode.width=this._zoneManager.getCanvasWidth(),this._domNode.domNode.height=this._zoneManager.getCanvasHeight(),this._render()),!0}onFlushed(e){return this._render(),!0}onScrollChanged(e){return e.scrollHeightChanged&&(this._zoneManager.setOuterHeight(e.scrollHeight),this._render()),!0}onZonesChanged(e){return this._render(),!0}getDomNode(){return this._domNode.domNode}setLayout(e){this._domNode.setTop(e.top),this._domNode.setRight(e.right);let t=!1;t=this._zoneManager.setDOMWidth(e.width)||t,t=this._zoneManager.setDOMHeight(e.height)||t,t&&(this._domNode.setWidth(this._zoneManager.getDOMWidth()),this._domNode.setHeight(this._zoneManager.getDOMHeight()),this._domNode.domNode.width=this._zoneManager.getCanvasWidth(),this._domNode.domNode.height=this._zoneManager.getCanvasHeight(),this._render())}setZones(e){this._zoneManager.setZones(e),this._render()}_render(){if(0===this._zoneManager.getOuterHeight())return!1;const e=this._zoneManager.getCanvasWidth(),t=this._zoneManager.getCanvasHeight(),i=this._zoneManager.resolveColorZones(),n=this._zoneManager.getId2Color(),o=this._domNode.domNode.getContext("2d");return o.clearRect(0,0,e,t),i.length>0&&this._renderOneLane(o,i,n,e),!0}_renderOneLane(e,t,i,n){let o=0,s=0,r=0;for(const a of t){const t=a.colorId,l=a.from,h=a.to;t!==o?(e.fillRect(0,s,n,r-s),o=t,e.fillStyle=i[o],s=l,r=h):r>=l?r=Math.max(r,h):(e.fillRect(0,s,n,r-s),s=l,r=h)}e.fillRect(0,s,n,r-s)}}var qn=i(9166);l()(qn.A,{insert:"head",singleton:!1}),qn.A.locals;class $n extends se{constructor(e){super(e),this.domNode=(0,z.Z)(document.createElement("div")),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this.domNode.setClassName("view-rulers"),this._renderedRulers=[];const t=this._context.configuration.options;this._rulers=t.get(98),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth}dispose(){super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options;return this._rulers=t.get(98),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth,!0}onScrollChanged(e){return e.scrollHeightChanged}prepareRender(e){}_ensureRulersCount(){const e=this._renderedRulers.length,t=this._rulers.length;if(e===t)return;if(e<t){const{tabSize:i}=this._context.viewModel.model.getOptions(),n=i;let o=t-e;for(;o>0;){const e=(0,z.Z)(document.createElement("div"));e.setClassName("view-ruler"),e.setWidth(n),this.domNode.appendChild(e),this._renderedRulers.push(e),o--}return}let i=e-t;for(;i>0;){const e=this._renderedRulers.pop();this.domNode.removeChild(e),i--}}render(e){this._ensureRulersCount();for(let t=0,i=this._rulers.length;t<i;t++){const i=this._renderedRulers[t],n=this._rulers[t];i.setBoxShadow(n.color?`1px 0 0 0 ${n.color} inset`:""),i.setHeight(Math.min(e.scrollHeight,1e6)),i.setLeft(n.column*this._typicalHalfwidthCharacterWidth)}}}var Xn=i(3398);l()(Xn.A,{insert:"head",singleton:!1}),Xn.A.locals;class Zn extends se{constructor(e){super(e),this._scrollTop=0,this._width=0,this._updateWidth(),this._shouldShow=!1;const t=this._context.configuration.options.get(99);this._useShadows=t.useShadows,this._domNode=(0,z.Z)(document.createElement("div")),this._domNode.setAttribute("role","presentation"),this._domNode.setAttribute("aria-hidden","true")}dispose(){super.dispose()}_updateShouldShow(){const e=this._useShadows&&this._scrollTop>0;return this._shouldShow!==e&&(this._shouldShow=e,!0)}getDomNode(){return this._domNode}_updateWidth(){const e=this._context.configuration.options.get(140);0===e.minimap.renderMinimap||e.minimap.minimapWidth>0&&0===e.minimap.minimapLeft?this._width=e.width:this._width=e.width-e.verticalScrollbarWidth}onConfigurationChanged(e){const t=this._context.configuration.options.get(99);return this._useShadows=t.useShadows,this._updateWidth(),this._updateShouldShow(),!0}onScrollChanged(e){return this._scrollTop=e.scrollTop,this._updateShouldShow()}prepareRender(e){}render(e){this._domNode.setWidth(this._width),this._domNode.setClassName(this._shouldShow?"scroll-decoration":"")}}var eo=i(3270);l()(eo.A,{insert:"head",singleton:!1}),eo.A.locals;class to{constructor(e){this.left=e.left,this.width=e.width,this.startStyle=null,this.endStyle=null}}class io{constructor(e,t){this.lineNumber=e,this.ranges=t}}function no(e){return new to(e)}function oo(e){return new io(e.lineNumber,e.ranges.map(no))}class so extends pt{constructor(e){super(),this._previousFrameVisibleRangesWithStyle=[],this._context=e;const t=this._context.configuration.options;this._lineHeight=t.get(64),this._roundedSelection=t.get(97),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth,this._selections=[],this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=this._context.configuration.options;return this._lineHeight=t.get(64),this._roundedSelection=t.get(97),this._typicalHalfwidthCharacterWidth=t.get(48).typicalHalfwidthCharacterWidth,!0}onCursorStateChanged(e){return this._selections=e.selections.slice(0),!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}_visibleRangesHaveGaps(e){for(let t=0,i=e.length;t<i;t++)if(e[t].ranges.length>1)return!0;return!1}_enrichVisibleRangesWithStyle(e,t,i){const n=this._typicalHalfwidthCharacterWidth/4;let o=null,s=null;if(i&&i.length>0&&t.length>0){const n=t[0].lineNumber;if(n===e.startLineNumber)for(let e=0;!o&&e<i.length;e++)i[e].lineNumber===n&&(o=i[e].ranges[0]);const r=t[t.length-1].lineNumber;if(r===e.endLineNumber)for(let e=i.length-1;!s&&e>=0;e--)i[e].lineNumber===r&&(s=i[e].ranges[0]);o&&!o.startStyle&&(o=null),s&&!s.startStyle&&(s=null)}for(let e=0,i=t.length;e<i;e++){const r=t[e].ranges[0],a=r.left,l=r.left+r.width,h={top:0,bottom:0},c={top:0,bottom:0};if(e>0){const i=t[e-1].ranges[0].left,o=t[e-1].ranges[0].left+t[e-1].ranges[0].width;ro(a-i)<n?h.top=2:a>i&&(h.top=1),ro(l-o)<n?c.top=2:i<l&&l<o&&(c.top=1)}else o&&(h.top=o.startStyle.top,c.top=o.endStyle.top);if(e+1<i){const i=t[e+1].ranges[0].left,o=t[e+1].ranges[0].left+t[e+1].ranges[0].width;ro(a-i)<n?h.bottom=2:i<a&&a<o&&(h.bottom=1),ro(l-o)<n?c.bottom=2:l<o&&(c.bottom=1)}else s&&(h.bottom=s.startStyle.bottom,c.bottom=s.endStyle.bottom);r.startStyle=h,r.endStyle=c}}_getVisibleRangesWithStyle(e,t,i){const n=(t.linesVisibleRangesForRange(e,!0)||[]).map(oo);return!this._visibleRangesHaveGaps(n)&&this._roundedSelection&&this._enrichVisibleRangesWithStyle(t.visibleRange,n,i),n}_createSelectionPiece(e,t,i,n,o){return'<div class="cslr '+i+'" style="top:'+e.toString()+"px;left:"+n.toString()+"px;width:"+o.toString()+"px;height:"+t+'px;"></div>'}_actualRenderOneSelection(e,t,i,n){if(0===n.length)return;const o=!!n[0].ranges[0].startStyle,s=this._lineHeight.toString(),r=(this._lineHeight-1).toString(),a=n[0].lineNumber,l=n[n.length-1].lineNumber;for(let h=0,c=n.length;h<c;h++){const c=n[h],d=c.lineNumber,u=d-t,g=!i||d!==l&&d!==a?s:r,m=i&&d===a?1:0;let p="",f="";for(let e=0,t=c.ranges.length;e<t;e++){const t=c.ranges[e];if(o){const e=t.startStyle,i=t.endStyle;if(1===e.top||1===e.bottom){p+=this._createSelectionPiece(m,g,so.SELECTION_CLASS_NAME,t.left-so.ROUNDED_PIECE_WIDTH,so.ROUNDED_PIECE_WIDTH);let i=so.EDITOR_BACKGROUND_CLASS_NAME;1===e.top&&(i+=" "+so.SELECTION_TOP_RIGHT),1===e.bottom&&(i+=" "+so.SELECTION_BOTTOM_RIGHT),p+=this._createSelectionPiece(m,g,i,t.left-so.ROUNDED_PIECE_WIDTH,so.ROUNDED_PIECE_WIDTH)}if(1===i.top||1===i.bottom){p+=this._createSelectionPiece(m,g,so.SELECTION_CLASS_NAME,t.left+t.width,so.ROUNDED_PIECE_WIDTH);let e=so.EDITOR_BACKGROUND_CLASS_NAME;1===i.top&&(e+=" "+so.SELECTION_TOP_LEFT),1===i.bottom&&(e+=" "+so.SELECTION_BOTTOM_LEFT),p+=this._createSelectionPiece(m,g,e,t.left+t.width,so.ROUNDED_PIECE_WIDTH)}}let i=so.SELECTION_CLASS_NAME;if(o){const e=t.startStyle,n=t.endStyle;0===e.top&&(i+=" "+so.SELECTION_TOP_LEFT),0===e.bottom&&(i+=" "+so.SELECTION_BOTTOM_LEFT),0===n.top&&(i+=" "+so.SELECTION_TOP_RIGHT),0===n.bottom&&(i+=" "+so.SELECTION_BOTTOM_RIGHT)}f+=this._createSelectionPiece(m,g,i,t.left,t.width)}e[u][0]+=p,e[u][1]+=f}}prepareRender(e){const t=[],i=e.visibleRange.startLineNumber,n=e.visibleRange.endLineNumber;for(let e=i;e<=n;e++)t[e-i]=["",""];const o=[];for(let n=0,s=this._selections.length;n<s;n++){const s=this._selections[n];if(s.isEmpty()){o[n]=null;continue}const r=this._getVisibleRangesWithStyle(s,e,this._previousFrameVisibleRangesWithStyle[n]);o[n]=r,this._actualRenderOneSelection(t,i,this._selections.length>1,r)}this._previousFrameVisibleRangesWithStyle=o,this._renderResult=t.map((([e,t])=>e+t))}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}function ro(e){return e<0?-e:e}so.SELECTION_CLASS_NAME="selected-text",so.SELECTION_TOP_LEFT="top-left-radius",so.SELECTION_BOTTOM_LEFT="bottom-left-radius",so.SELECTION_TOP_RIGHT="top-right-radius",so.SELECTION_BOTTOM_RIGHT="bottom-right-radius",so.EDITOR_BACKGROUND_CLASS_NAME="monaco-editor-background",so.ROUNDED_PIECE_WIDTH=10,(0,ft.zy)(((e,t)=>{const i=e.getColor(U.rm4);i&&!i.isTransparent()&&t.addRule(`.monaco-editor .view-line span.inline-selected-text { color: ${i}; }`)}));var ao=i(1762);l()(ao.A,{insert:"head",singleton:!1}),ao.A.locals;class lo{constructor(e,t,i,n,o,s,r){this.top=e,this.left=t,this.paddingLeft=i,this.width=n,this.height=o,this.textContent=s,this.textContentClassName=r}}class ho{constructor(e){this._context=e;const t=this._context.configuration.options,i=t.get(48);this._cursorStyle=t.get(26),this._lineHeight=t.get(64),this._typicalHalfwidthCharacterWidth=i.typicalHalfwidthCharacterWidth,this._lineCursorWidth=Math.min(t.get(29),this._typicalHalfwidthCharacterWidth),this._isVisible=!0,this._domNode=(0,z.Z)(document.createElement("div")),this._domNode.setClassName(`cursor ${Ct.S}`),this._domNode.setHeight(this._lineHeight),this._domNode.setTop(0),this._domNode.setLeft(0),(0,gt.M)(this._domNode,i),this._domNode.setDisplay("none"),this._position=new De.y(1,1),this._lastRenderedContent="",this._renderData=null}getDomNode(){return this._domNode}getPosition(){return this._position}show(){this._isVisible||(this._domNode.setVisibility("inherit"),this._isVisible=!0)}hide(){this._isVisible&&(this._domNode.setVisibility("hidden"),this._isVisible=!1)}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(48);return this._cursorStyle=t.get(26),this._lineHeight=t.get(64),this._typicalHalfwidthCharacterWidth=i.typicalHalfwidthCharacterWidth,this._lineCursorWidth=Math.min(t.get(29),this._typicalHalfwidthCharacterWidth),(0,gt.M)(this._domNode,i),!0}onCursorPositionChanged(e,t){return this._domNode.domNode.style.transitionProperty=t?"none":"",this._position=e,!0}_getGraphemeAwarePosition(){const{lineNumber:e,column:t}=this._position,i=this._context.viewModel.getLineContent(e),[n,o]=tt.m(i,t-1);return[new De.y(e,n+1),i.substring(n,o)]}_prepareRender(e){let t="",i="";const[n,o]=this._getGraphemeAwarePosition();if(this._cursorStyle===D.m9.Line||this._cursorStyle===D.m9.LineThin){const s=e.visibleRangeForPosition(n);if(!s||s.outsideRenderedLine)return null;let r;this._cursorStyle===D.m9.Line?(r=d.vT(this._lineCursorWidth>0?this._lineCursorWidth:2),r>2&&(t=o,i=this._getTokenClassName(n))):r=d.vT(1);let a=s.left,l=0;r>=2&&a>=1&&(l=1,a-=l);const h=e.getVerticalOffsetForLineNumber(n.lineNumber)-e.bigNumbersDelta;return new lo(h,a,l,r,this._lineHeight,t,i)}const s=e.linesVisibleRangesForRange(new xe.Q(n.lineNumber,n.column,n.lineNumber,n.column+o.length),!1);if(!s||0===s.length)return null;const r=s[0];if(r.outsideRenderedLine||0===r.ranges.length)return null;const a=r.ranges[0],l="\t"===o||a.width<1?this._typicalHalfwidthCharacterWidth:a.width;this._cursorStyle===D.m9.Block&&(t=o,i=this._getTokenClassName(n));let h=e.getVerticalOffsetForLineNumber(n.lineNumber)-e.bigNumbersDelta,c=this._lineHeight;return this._cursorStyle!==D.m9.Underline&&this._cursorStyle!==D.m9.UnderlineThin||(h+=this._lineHeight-2,c=2),new lo(h,a.left,0,l,c,t,i)}_getTokenClassName(e){const t=this._context.viewModel.getViewLineData(e.lineNumber),i=t.tokens.findTokenIndexAtOffset(e.column-1);return t.tokens.getClassName(i)}prepareRender(e){this._renderData=this._prepareRender(e)}render(e){return this._renderData?(this._lastRenderedContent!==this._renderData.textContent&&(this._lastRenderedContent=this._renderData.textContent,this._domNode.domNode.textContent=this._lastRenderedContent),this._domNode.setClassName(`cursor ${Ct.S} ${this._renderData.textContentClassName}`),this._domNode.setDisplay("block"),this._domNode.setTop(this._renderData.top),this._domNode.setLeft(this._renderData.left),this._domNode.setPaddingLeft(this._renderData.paddingLeft),this._domNode.setWidth(this._renderData.width),this._domNode.setLineHeight(this._renderData.height),this._domNode.setHeight(this._renderData.height),{domNode:this._domNode.domNode,position:this._position,contentLeft:this._renderData.left,height:this._renderData.height,width:2}):(this._domNode.setDisplay("none"),null)}}class co extends se{constructor(e){super(e);const t=this._context.configuration.options;this._readOnly=t.get(88),this._cursorBlinking=t.get(24),this._cursorStyle=t.get(26),this._cursorSmoothCaretAnimation=t.get(25),this._selectionIsEmpty=!0,this._isComposingInput=!1,this._isVisible=!1,this._primaryCursor=new ho(this._context),this._secondaryCursors=[],this._renderData=[],this._domNode=(0,z.Z)(document.createElement("div")),this._domNode.setAttribute("role","presentation"),this._domNode.setAttribute("aria-hidden","true"),this._updateDomClassName(),this._domNode.appendChild(this._primaryCursor.getDomNode()),this._startCursorBlinkAnimation=new V.pc,this._cursorFlatBlinkInterval=new V.vb,this._blinkingEnabled=!1,this._editorHasFocus=!1,this._updateBlinking()}dispose(){super.dispose(),this._startCursorBlinkAnimation.dispose(),this._cursorFlatBlinkInterval.dispose()}getDomNode(){return this._domNode}onCompositionStart(e){return this._isComposingInput=!0,this._updateBlinking(),!0}onCompositionEnd(e){return this._isComposingInput=!1,this._updateBlinking(),!0}onConfigurationChanged(e){const t=this._context.configuration.options;this._readOnly=t.get(88),this._cursorBlinking=t.get(24),this._cursorStyle=t.get(26),this._cursorSmoothCaretAnimation=t.get(25),this._updateBlinking(),this._updateDomClassName(),this._primaryCursor.onConfigurationChanged(e);for(let t=0,i=this._secondaryCursors.length;t<i;t++)this._secondaryCursors[t].onConfigurationChanged(e);return!0}_onCursorPositionChanged(e,t,i){const n=this._secondaryCursors.length!==t.length||"explicit"===this._cursorSmoothCaretAnimation&&3!==i;if(this._primaryCursor.onCursorPositionChanged(e,n),this._updateBlinking(),this._secondaryCursors.length<t.length){const e=t.length-this._secondaryCursors.length;for(let t=0;t<e;t++){const e=new ho(this._context);this._domNode.domNode.insertBefore(e.getDomNode().domNode,this._primaryCursor.getDomNode().domNode.nextSibling),this._secondaryCursors.push(e)}}else if(this._secondaryCursors.length>t.length){const e=this._secondaryCursors.length-t.length;for(let t=0;t<e;t++)this._domNode.removeChild(this._secondaryCursors[0].getDomNode()),this._secondaryCursors.splice(0,1)}for(let e=0;e<t.length;e++)this._secondaryCursors[e].onCursorPositionChanged(t[e],n)}onCursorStateChanged(e){const t=[];for(let i=0,n=e.selections.length;i<n;i++)t[i]=e.selections[i].getPosition();this._onCursorPositionChanged(t[0],t.slice(1),e.reason);const i=e.selections[0].isEmpty();return this._selectionIsEmpty!==i&&(this._selectionIsEmpty=i,this._updateDomClassName()),!0}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onFocusChanged(e){return this._editorHasFocus=e.isFocused,this._updateBlinking(),!1}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return!0}onTokensChanged(e){const t=t=>{for(let i=0,n=e.ranges.length;i<n;i++)if(e.ranges[i].fromLineNumber<=t.lineNumber&&t.lineNumber<=e.ranges[i].toLineNumber)return!0;return!1};if(t(this._primaryCursor.getPosition()))return!0;for(const e of this._secondaryCursors)if(t(e.getPosition()))return!0;return!1}onZonesChanged(e){return!0}_getCursorBlinking(){return this._isComposingInput?0:this._editorHasFocus?this._readOnly?5:this._cursorBlinking:0}_updateBlinking(){this._startCursorBlinkAnimation.cancel(),this._cursorFlatBlinkInterval.cancel();const e=this._getCursorBlinking(),t=0===e,i=5===e;t?this._hide():this._show(),this._blinkingEnabled=!1,this._updateDomClassName(),t||i||(1===e?this._cursorFlatBlinkInterval.cancelAndSet((()=>{this._isVisible?this._hide():this._show()}),co.BLINK_INTERVAL):this._startCursorBlinkAnimation.setIfNotSet((()=>{this._blinkingEnabled=!0,this._updateDomClassName()}),co.BLINK_INTERVAL))}_updateDomClassName(){this._domNode.setClassName(this._getClassName())}_getClassName(){let e="cursors-layer";switch(this._selectionIsEmpty||(e+=" has-selection"),this._cursorStyle){case D.m9.Line:e+=" cursor-line-style";break;case D.m9.Block:e+=" cursor-block-style";break;case D.m9.Underline:e+=" cursor-underline-style";break;case D.m9.LineThin:e+=" cursor-line-thin-style";break;case D.m9.BlockOutline:e+=" cursor-block-outline-style";break;case D.m9.UnderlineThin:e+=" cursor-underline-thin-style";break;default:e+=" cursor-line-style"}if(this._blinkingEnabled)switch(this._getCursorBlinking()){case 1:e+=" cursor-blink";break;case 2:e+=" cursor-smooth";break;case 3:e+=" cursor-phase";break;case 4:e+=" cursor-expand";break;default:e+=" cursor-solid"}else e+=" cursor-solid";return"on"!==this._cursorSmoothCaretAnimation&&"explicit"!==this._cursorSmoothCaretAnimation||(e+=" cursor-smooth-caret-animation"),e}_show(){this._primaryCursor.show();for(let e=0,t=this._secondaryCursors.length;e<t;e++)this._secondaryCursors[e].show();this._isVisible=!0}_hide(){this._primaryCursor.hide();for(let e=0,t=this._secondaryCursors.length;e<t;e++)this._secondaryCursors[e].hide();this._isVisible=!1}prepareRender(e){this._primaryCursor.prepareRender(e);for(let t=0,i=this._secondaryCursors.length;t<i;t++)this._secondaryCursors[t].prepareRender(e)}render(e){const t=[];let i=0;const n=this._primaryCursor.render(e);n&&(t[i++]=n);for(let n=0,o=this._secondaryCursors.length;n<o;n++){const o=this._secondaryCursors[n].render(e);o&&(t[i++]=o)}this._renderData=t}getLastRenderData(){return this._renderData}}co.BLINK_INTERVAL=500,(0,ft.zy)(((e,t)=>{const i=e.getColor(At.D0);if(i){let n=e.getColor(At.kM);n||(n=i.opposite()),t.addRule(`.monaco-editor .cursors-layer .cursor { background-color: ${i}; border-color: ${i}; color: ${n}; }`),(0,Ae.Bb)(e.type)&&t.addRule(`.monaco-editor .cursors-layer.has-selection .cursor { border-left: 1px solid ${n}; border-right: 1px solid ${n}; }`)}}));const uo=()=>{throw new Error("Invalid change accessor")};class go extends se{constructor(e){super(e);const t=this._context.configuration.options,i=t.get(140);this._lineHeight=t.get(64),this._contentWidth=i.contentWidth,this._contentLeft=i.contentLeft,this.domNode=(0,z.Z)(document.createElement("div")),this.domNode.setClassName("view-zones"),this.domNode.setPosition("absolute"),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this.marginDomNode=(0,z.Z)(document.createElement("div")),this.marginDomNode.setClassName("margin-view-zones"),this.marginDomNode.setPosition("absolute"),this.marginDomNode.setAttribute("role","presentation"),this.marginDomNode.setAttribute("aria-hidden","true"),this._zones={}}dispose(){super.dispose(),this._zones={}}_recomputeWhitespacesProps(){const e=this._context.viewLayout.getWhitespaces(),t=new Map;for(const i of e)t.set(i.id,i);let i=!1;return this._context.viewModel.changeWhitespace((e=>{const n=Object.keys(this._zones);for(let o=0,s=n.length;o<s;o++){const s=n[o],r=this._zones[s],a=this._computeWhitespaceProps(r.delegate);r.isInHiddenArea=a.isInHiddenArea;const l=t.get(s);!l||l.afterLineNumber===a.afterViewLineNumber&&l.height===a.heightInPx||(e.changeOneWhitespace(s,a.afterViewLineNumber,a.heightInPx),this._safeCallOnComputedHeight(r.delegate,a.heightInPx),i=!0)}})),i}onConfigurationChanged(e){const t=this._context.configuration.options,i=t.get(140);return this._lineHeight=t.get(64),this._contentWidth=i.contentWidth,this._contentLeft=i.contentLeft,e.hasChanged(64)&&this._recomputeWhitespacesProps(),!0}onLineMappingChanged(e){return this._recomputeWhitespacesProps()}onLinesDeleted(e){return!0}onScrollChanged(e){return e.scrollTopChanged||e.scrollWidthChanged}onZonesChanged(e){return!0}onLinesInserted(e){return!0}_getZoneOrdinal(e){var t,i;return null!==(i=null!==(t=e.ordinal)&&void 0!==t?t:e.afterColumn)&&void 0!==i?i:1e4}_computeWhitespaceProps(e){if(0===e.afterLineNumber)return{isInHiddenArea:!1,afterViewLineNumber:0,heightInPx:this._heightInPixels(e),minWidthInPx:this._minWidthInPixels(e)};let t,i;if(void 0!==e.afterColumn)t=this._context.viewModel.model.validatePosition({lineNumber:e.afterLineNumber,column:e.afterColumn});else{const i=this._context.viewModel.model.validatePosition({lineNumber:e.afterLineNumber,column:1}).lineNumber;t=new De.y(i,this._context.viewModel.model.getLineMaxColumn(i))}i=t.column===this._context.viewModel.model.getLineMaxColumn(t.lineNumber)?this._context.viewModel.model.validatePosition({lineNumber:t.lineNumber+1,column:1}):this._context.viewModel.model.validatePosition({lineNumber:t.lineNumber,column:t.column+1});const n=this._context.viewModel.coordinatesConverter.convertModelPositionToViewPosition(t,e.afterColumnAffinity),o=e.showInHiddenAreas||this._context.viewModel.coordinatesConverter.modelPositionIsVisible(i);return{isInHiddenArea:!o,afterViewLineNumber:n.lineNumber,heightInPx:o?this._heightInPixels(e):0,minWidthInPx:this._minWidthInPixels(e)}}changeViewZones(e){let t=!1;return this._context.viewModel.changeWhitespace((i=>{const n={addZone:e=>(t=!0,this._addZone(i,e)),removeZone:e=>{e&&(t=this._removeZone(i,e)||t)},layoutZone:e=>{e&&(t=this._layoutZone(i,e)||t)}};!function(e,t){try{return e(t)}catch(e){(0,u.dz)(e)}}(e,n),n.addZone=uo,n.removeZone=uo,n.layoutZone=uo})),t}_addZone(e,t){const i=this._computeWhitespaceProps(t),n={whitespaceId:e.insertWhitespace(i.afterViewLineNumber,this._getZoneOrdinal(t),i.heightInPx,i.minWidthInPx),delegate:t,isInHiddenArea:i.isInHiddenArea,isVisible:!1,domNode:(0,z.Z)(t.domNode),marginDomNode:t.marginDomNode?(0,z.Z)(t.marginDomNode):null};return this._safeCallOnComputedHeight(n.delegate,i.heightInPx),n.domNode.setPosition("absolute"),n.domNode.domNode.style.width="100%",n.domNode.setDisplay("none"),n.domNode.setAttribute("monaco-view-zone",n.whitespaceId),this.domNode.appendChild(n.domNode),n.marginDomNode&&(n.marginDomNode.setPosition("absolute"),n.marginDomNode.domNode.style.width="100%",n.marginDomNode.setDisplay("none"),n.marginDomNode.setAttribute("monaco-view-zone",n.whitespaceId),this.marginDomNode.appendChild(n.marginDomNode)),this._zones[n.whitespaceId]=n,this.setShouldRender(),n.whitespaceId}_removeZone(e,t){if(this._zones.hasOwnProperty(t)){const i=this._zones[t];return delete this._zones[t],e.removeWhitespace(i.whitespaceId),i.domNode.removeAttribute("monaco-visible-view-zone"),i.domNode.removeAttribute("monaco-view-zone"),i.domNode.domNode.parentNode.removeChild(i.domNode.domNode),i.marginDomNode&&(i.marginDomNode.removeAttribute("monaco-visible-view-zone"),i.marginDomNode.removeAttribute("monaco-view-zone"),i.marginDomNode.domNode.parentNode.removeChild(i.marginDomNode.domNode)),this.setShouldRender(),!0}return!1}_layoutZone(e,t){if(this._zones.hasOwnProperty(t)){const i=this._zones[t],n=this._computeWhitespaceProps(i.delegate);return i.isInHiddenArea=n.isInHiddenArea,e.changeOneWhitespace(i.whitespaceId,n.afterViewLineNumber,n.heightInPx),this._safeCallOnComputedHeight(i.delegate,n.heightInPx),this.setShouldRender(),!0}return!1}shouldSuppressMouseDownOnViewZone(e){if(this._zones.hasOwnProperty(e)){const t=this._zones[e];return Boolean(t.delegate.suppressMouseDown)}return!1}_heightInPixels(e){return"number"==typeof e.heightInPx?e.heightInPx:"number"==typeof e.heightInLines?this._lineHeight*e.heightInLines:this._lineHeight}_minWidthInPixels(e){return"number"==typeof e.minWidthInPx?e.minWidthInPx:0}_safeCallOnComputedHeight(e,t){if("function"==typeof e.onComputedHeight)try{e.onComputedHeight(t)}catch(e){(0,u.dz)(e)}}_safeCallOnDomNodeTop(e,t){if("function"==typeof e.onDomNodeTop)try{e.onDomNodeTop(t)}catch(e){(0,u.dz)(e)}}prepareRender(e){}render(e){const t=e.viewportData.whitespaceViewportData,i={};let n=!1;for(const e of t)this._zones[e.id].isInHiddenArea||(i[e.id]=e,n=!0);const o=Object.keys(this._zones);for(let t=0,n=o.length;t<n;t++){const n=o[t],s=this._zones[n];let r=0,a=0,l="none";i.hasOwnProperty(n)?(r=i[n].verticalOffset-e.bigNumbersDelta,a=i[n].height,l="block",s.isVisible||(s.domNode.setAttribute("monaco-visible-view-zone","true"),s.isVisible=!0),this._safeCallOnDomNodeTop(s.delegate,e.getScrolledTopFromAbsoluteTop(i[n].verticalOffset))):(s.isVisible&&(s.domNode.removeAttribute("monaco-visible-view-zone"),s.isVisible=!1),this._safeCallOnDomNodeTop(s.delegate,e.getScrolledTopFromAbsoluteTop(-1e6))),s.domNode.setTop(r),s.domNode.setHeight(a),s.domNode.setDisplay(l),s.marginDomNode&&(s.marginDomNode.setTop(r),s.marginDomNode.setHeight(a),s.marginDomNode.setDisplay(l))}n&&(this.domNode.setWidth(Math.max(e.scrollWidth,this._contentWidth)),this.marginDomNode.setWidth(this._contentLeft))}}class mo{get type(){return this._theme.type}get value(){return this._theme}constructor(e){this._theme=e}update(e){this._theme=e}getColor(e){return this._theme.getColor(e)}}class po{constructor(e,t,i){this.configuration=e,this.theme=new mo(t),this.viewModel=i,this.viewLayout=i.viewLayout}addEventHandler(e){this.viewModel.addViewEventHandler(e)}removeEventHandler(e){this.viewModel.removeViewEventHandler(e)}}class fo{constructor(e,t,i,n){this.selections=e,this.startLineNumber=0|t.startLineNumber,this.endLineNumber=0|t.endLineNumber,this.relativeVerticalOffset=t.relativeVerticalOffset,this.bigNumbersDelta=0|t.bigNumbersDelta,this.whitespaceViewportData=i,this._model=n,this.visibleRange=new xe.Q(t.startLineNumber,this._model.getLineMinColumn(t.startLineNumber),t.endLineNumber,this._model.getLineMaxColumn(t.endLineNumber))}getViewLineRenderingData(e){return this._model.getViewportViewLineRenderingData(this.visibleRange,e)}getDecorationsInViewport(){return this._model.getDecorationsInViewport(this.visibleRange)}}var Ao=i(7108);l()(Ao.A,{insert:"head",singleton:!1}),Ao.A.locals;class _o extends se{constructor(e){super(e),this.blocks=[],this.contentWidth=-1,this.contentLeft=0,this.domNode=(0,z.Z)(document.createElement("div")),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this.domNode.setClassName("blockDecorations-container"),this.update()}update(){let e=!1;const t=this._context.configuration.options.get(140),i=t.contentWidth-t.verticalScrollbarWidth;this.contentWidth!==i&&(this.contentWidth=i,e=!0);const n=t.contentLeft;return this.contentLeft!==n&&(this.contentLeft=n,e=!0),e}dispose(){super.dispose()}onConfigurationChanged(e){return this.update()}onScrollChanged(e){return e.scrollTopChanged||e.scrollLeftChanged}onDecorationsChanged(e){return!0}onZonesChanged(e){return!0}prepareRender(e){}render(e){var t;let i=0;const n=e.getDecorationsInViewport();for(const o of n){if(!o.options.blockClassName)continue;let n,s,r=this.blocks[i];r||(r=this.blocks[i]=(0,z.Z)(document.createElement("div")),this.domNode.appendChild(r)),o.options.blockIsAfterEnd?(n=e.getVerticalOffsetAfterLineNumber(o.range.endLineNumber,!1),s=e.getVerticalOffsetAfterLineNumber(o.range.endLineNumber,!0)):(n=e.getVerticalOffsetForLineNumber(o.range.startLineNumber,!0),s=o.range.isEmpty()&&!o.options.blockDoesNotCollapse?e.getVerticalOffsetForLineNumber(o.range.startLineNumber,!1):e.getVerticalOffsetAfterLineNumber(o.range.endLineNumber,!0));const[a,l,h,c]=null!==(t=o.options.blockPadding)&&void 0!==t?t:[0,0,0,0];r.setClassName("blockDecorations-block "+o.options.blockClassName),r.setLeft(this.contentLeft-c),r.setWidth(this.contentWidth+c+l),r.setTop(n-e.scrollTop-a),r.setHeight(s-n+a+h),i++}for(let e=i;e<this.blocks.length;e++)this.blocks[e].domNode.remove();this.blocks.length=i}}var wo=i(774);l()(wo.A,{insert:"head",singleton:!1}),wo.A.locals;class bo extends pt{constructor(e){super(),this._context=e,this._options=new vo(this._context.configuration),this._selection=[],this._renderResult=null,this._context.addEventHandler(this)}dispose(){this._context.removeEventHandler(this),this._renderResult=null,super.dispose()}onConfigurationChanged(e){const t=new vo(this._context.configuration);return this._options.equals(t)?e.hasChanged(140):(this._options=t,!0)}onCursorStateChanged(e){return this._selection=e.selections,"selection"===this._options.renderWhitespace}onDecorationsChanged(e){return!0}onFlushed(e){return!0}onLinesChanged(e){return!0}onLinesDeleted(e){return!0}onLinesInserted(e){return!0}onScrollChanged(e){return e.scrollTopChanged}onZonesChanged(e){return!0}prepareRender(e){if("none"===this._options.renderWhitespace)return void(this._renderResult=null);const t=e.visibleRange.startLineNumber,i=e.visibleRange.endLineNumber-t+1,n=new Array(i);for(let e=0;e<i;e++)n[e]=!0;const o=this._context.viewModel.getMinimapLinesRenderingData(e.viewportData.startLineNumber,e.viewportData.endLineNumber,n);this._renderResult=[];for(let t=e.viewportData.startLineNumber;t<=e.viewportData.endLineNumber;t++){const i=t-e.viewportData.startLineNumber,n=o.data[i];let s=null;if("selection"===this._options.renderWhitespace){const e=this._selection;for(const i of e){if(i.endLineNumber<t||i.startLineNumber>t)continue;const e=i.startLineNumber===t?i.startColumn:n.minColumn,o=i.endLineNumber===t?i.endColumn:n.maxColumn;e<o&&(s||(s=[]),s.push(new fe.MT(e-1,o-1)))}}this._renderResult[i]=this._applyRenderWhitespace(e,t,s,n)}}_applyRenderWhitespace(e,t,i,n){if("selection"===this._options.renderWhitespace&&!i)return"";if("trailing"===this._options.renderWhitespace&&n.continuesWithWrappedLine)return"";const o=this._context.theme.getColor(At.w4),s=this._options.renderWithSVG,r=n.content,a=-1===this._options.stopRenderingLineAfter?r.length:Math.min(this._options.stopRenderingLineAfter,r.length),l=n.continuesWithWrappedLine,h=n.minColumn-1,c="boundary"===this._options.renderWhitespace,d="trailing"===this._options.renderWhitespace,u=this._options.lineHeight,g=this._options.middotWidth,m=this._options.wsmiddotWidth,p=this._options.spaceWidth,f=Math.abs(m-p)<Math.abs(g-p)?11825:183,A=this._options.canUseHalfwidthRightwardsArrow;let _,w="",b=!1,v=tt.HG(r);-1===v?(b=!0,v=a,_=a):_=tt.lT(r);let C=0,y=i&&i[C],S=0;for(let n=h;n<a;n++){const o=r.charCodeAt(n);if(y&&n>=y.endOffset&&(C++,y=i&&i[C]),9!==o&&32!==o)continue;if(d&&!b&&n<=_)continue;if(c&&n>=v&&n<=_&&32===o){const e=n-1>=0?r.charCodeAt(n-1):0,t=n+1<a?r.charCodeAt(n+1):0;if(32!==e&&32!==t)continue}if(c&&l&&n===a-1){const e=n-1>=0?r.charCodeAt(n-1):0;if(32===o&&32!==e&&9!==e)continue}if(i&&(!y||y.startOffset>n||y.endOffset<=n))continue;const h=e.visibleRangeForPosition(new De.y(t,n+1));h&&(s?(S=Math.max(S,h.left),w+=9===o?this._renderArrow(u,p,h.left):`<circle cx="${(h.left+p/2).toFixed(2)}" cy="${(u/2).toFixed(2)}" r="${(p/7).toFixed(2)}" />`):w+=9===o?`<div class="mwh" style="left:${h.left}px;height:${u}px;">${A?String.fromCharCode(65515):String.fromCharCode(8594)}</div>`:`<div class="mwh" style="left:${h.left}px;height:${u}px;">${String.fromCharCode(f)}</div>`)}return s?(S=Math.round(S+p),`<svg style="position:absolute;width:${S}px;height:${u}px" viewBox="0 0 ${S} ${u}" xmlns="http://www.w3.org/2000/svg" fill="${o}">`+w+"</svg>"):w}_renderArrow(e,t,i){const n=e/2,o=i,s={x:0,y:t/7/2},r={x:.8*t,y:s.y},a={x:r.x-.2*r.x,y:r.y+.2*r.x},l={x:a.x+.1*r.x,y:a.y+.1*r.x},h={x:l.x+.35*r.x,y:l.y-.35*r.x};return`<path d="M ${[s,r,a,l,h,{x:h.x,y:-h.y},{x:l.x,y:-l.y},{x:a.x,y:-a.y},{x:r.x,y:-r.y},{x:s.x,y:-s.y}].map((e=>`${(o+e.x).toFixed(2)} ${(n+e.y).toFixed(2)}`)).join(" L ")}" />`}render(e,t){if(!this._renderResult)return"";const i=t-e;return i<0||i>=this._renderResult.length?"":this._renderResult[i]}}class vo{constructor(e){const t=e.options,i=t.get(48),n=t.get(36);"off"===n?(this.renderWhitespace="none",this.renderWithSVG=!1):"svg"===n?(this.renderWhitespace=t.get(95),this.renderWithSVG=!0):(this.renderWhitespace=t.get(95),this.renderWithSVG=!1),this.spaceWidth=i.spaceWidth,this.middotWidth=i.middotWidth,this.wsmiddotWidth=i.wsmiddotWidth,this.canUseHalfwidthRightwardsArrow=i.canUseHalfwidthRightwardsArrow,this.lineHeight=t.get(64),this.stopRenderingLineAfter=t.get(113)}equals(e){return this.renderWhitespace===e.renderWhitespace&&this.renderWithSVG===e.renderWithSVG&&this.spaceWidth===e.spaceWidth&&this.middotWidth===e.middotWidth&&this.wsmiddotWidth===e.wsmiddotWidth&&this.canUseHalfwidthRightwardsArrow===e.canUseHalfwidthRightwardsArrow&&this.lineHeight===e.lineHeight&&this.stopRenderingLineAfter===e.stopRenderingLineAfter}}class Co extends oe{constructor(e,t,i,n,o,s){super(),this._selections=[new P.L(1,1,1,1)],this._renderAnimationFrame=null;const r=new Mi(t,n,o,e);this._context=new po(t,i,n),this._context.addEventHandler(this),this._viewParts=[],this._textAreaHandler=new xt(this._context,r,this._createTextAreaHandlerHelper()),this._viewParts.push(this._textAreaHandler),this._linesContent=(0,z.Z)(document.createElement("div")),this._linesContent.setClassName("lines-content monaco-editor-background"),this._linesContent.setPosition("absolute"),this.domNode=(0,z.Z)(document.createElement("div")),this.domNode.setClassName(this._getEditorClassName()),this.domNode.setAttribute("role","code"),this._overflowGuardContainer=(0,z.Z)(document.createElement("div")),re.write(this._overflowGuardContainer,3),this._overflowGuardContainer.setClassName("overflow-guard"),this._scrollbar=new Zi(this._context,this._linesContent,this.domNode,this._overflowGuardContainer),this._viewParts.push(this._scrollbar),this._viewLines=new An(this._context,this._linesContent),this._viewZones=new go(this._context),this._viewParts.push(this._viewZones);const a=new Kn(this._context);this._viewParts.push(a);const l=new Zn(this._context);this._viewParts.push(l);const h=new zi(this._context);this._viewParts.push(h),h.addDynamicOverlay(new Ji(this._context)),h.addDynamicOverlay(new so(this._context)),h.addDynamicOverlay(new cn(this._context)),h.addDynamicOverlay(new Xi(this._context)),h.addDynamicOverlay(new bo(this._context));const c=new Qi(this._context);this._viewParts.push(c),c.addDynamicOverlay(new qi(this._context)),c.addDynamicOverlay(new rn(this._context)),c.addDynamicOverlay(new vn(this._context)),c.addDynamicOverlay(new wn(this._context)),c.addDynamicOverlay(new _t(this._context));const d=new bt(this._context);d.getDomNode().appendChild(this._viewZones.marginDomNode),d.getDomNode().appendChild(c.getDomNode()),this._viewParts.push(d),this._contentWidgets=new Hi(this._context,this.domNode),this._viewParts.push(this._contentWidgets),this._viewCursors=new co(this._context),this._viewParts.push(this._viewCursors),this._overlayWidgets=new jn(this._context),this._viewParts.push(this._overlayWidgets);const u=new $n(this._context);this._viewParts.push(u);const g=new _o(this._context);this._viewParts.push(g);const m=new Hn(this._context);if(this._viewParts.push(m),a){const e=this._scrollbar.getOverviewRulerLayoutInfo();e.parent.insertBefore(a.getDomNode(),e.insertBefore)}this._linesContent.appendChild(h.getDomNode()),this._linesContent.appendChild(u.domNode),this._linesContent.appendChild(this._viewZones.domNode),this._linesContent.appendChild(this._viewLines.getDomNode()),this._linesContent.appendChild(this._contentWidgets.domNode),this._linesContent.appendChild(this._viewCursors.getDomNode()),this._overflowGuardContainer.appendChild(d.getDomNode()),this._overflowGuardContainer.appendChild(this._scrollbar.getDomNode()),this._overflowGuardContainer.appendChild(l.getDomNode()),this._overflowGuardContainer.appendChild(this._textAreaHandler.textArea),this._overflowGuardContainer.appendChild(this._textAreaHandler.textAreaCover),this._overflowGuardContainer.appendChild(this._overlayWidgets.getDomNode()),this._overflowGuardContainer.appendChild(m.getDomNode()),this._overflowGuardContainer.appendChild(g.domNode),this.domNode.appendChild(this._overflowGuardContainer),s?s.appendChild(this._contentWidgets.overflowingContentWidgetsDomNode.domNode):this.domNode.appendChild(this._contentWidgets.overflowingContentWidgetsDomNode),this._applyLayout(),this._pointerHandler=this._register(new dt(this._context,r,this._createPointerHandlerHelper()))}_flushAccumulatedAndRenderNow(){Je.onRenderStart(),this._renderNow()}_createPointerHandlerHelper(){return{viewDomNode:this.domNode.domNode,linesContentDomNode:this._linesContent.domNode,viewLinesDomNode:this._viewLines.getDomNode().domNode,focusTextArea:()=>{this.focus()},dispatchTextAreaEvent:e=>{this._textAreaHandler.textArea.domNode.dispatchEvent(e)},getLastRenderData:()=>{const e=this._viewCursors.getLastRenderData()||[],t=this._textAreaHandler.getLastRenderData();return new Ne(e,t)},renderNow:()=>{this.render(!0,!1)},shouldSuppressMouseDownOnViewZone:e=>this._viewZones.shouldSuppressMouseDownOnViewZone(e),shouldSuppressMouseDownOnWidget:e=>this._contentWidgets.shouldSuppressMouseDownOnWidget(e),getPositionFromDOMInfo:(e,t)=>(this._flushAccumulatedAndRenderNow(),this._viewLines.getPositionFromDOMInfo(e,t)),visibleRangeForPosition:(e,t)=>(this._flushAccumulatedAndRenderNow(),this._viewLines.visibleRangeForPosition(new De.y(e,t))),getLineWidth:e=>(this._flushAccumulatedAndRenderNow(),this._viewLines.getLineWidth(e))}}_createTextAreaHandlerHelper(){return{visibleRangeForPosition:e=>(this._flushAccumulatedAndRenderNow(),this._viewLines.visibleRangeForPosition(e))}}_applyLayout(){const e=this._context.configuration.options.get(140);this.domNode.setWidth(e.width),this.domNode.setHeight(e.height),this._overflowGuardContainer.setWidth(e.width),this._overflowGuardContainer.setHeight(e.height),this._linesContent.setWidth(1e6),this._linesContent.setHeight(1e6)}_getEditorClassName(){const e=this._textAreaHandler.isFocused()?" focused":"";return this._context.configuration.options.get(137)+" "+(0,ft.Pz)(this._context.theme.type)+e}handleEvents(e){super.handleEvents(e),this._scheduleRender()}onConfigurationChanged(e){return this.domNode.setClassName(this._getEditorClassName()),this._applyLayout(),!1}onCursorStateChanged(e){return this._selections=e.selections,!1}onFocusChanged(e){return this.domNode.setClassName(this._getEditorClassName()),!1}onThemeChanged(e){return this._context.theme.update(e.theme),this.domNode.setClassName(this._getEditorClassName()),!1}dispose(){null!==this._renderAnimationFrame&&(this._renderAnimationFrame.dispose(),this._renderAnimationFrame=null),this._contentWidgets.overflowingContentWidgetsDomNode.domNode.remove(),this._context.removeEventHandler(this),this._viewLines.dispose();for(const e of this._viewParts)e.dispose();super.dispose()}_scheduleRender(){null===this._renderAnimationFrame&&(this._renderAnimationFrame=d.Oq(this._onRenderScheduled.bind(this),100))}_onRenderScheduled(){this._renderAnimationFrame=null,this._flushAccumulatedAndRenderNow()}_renderNow(){!function(e){try{return e()}catch(e){(0,u.dz)(e)}}((()=>this._actualRender()))}_getViewPartsToRender(){const e=[];let t=0;for(const i of this._viewParts)i.shouldRender()&&(e[t++]=i);return e}_actualRender(){if(!d.qD(this.domNode.domNode))return;let e=this._getViewPartsToRender();if(!this._viewLines.shouldRender()&&0===e.length)return;const t=this._context.viewLayout.getLinesViewportData();this._context.viewModel.setViewport(t.startLineNumber,t.endLineNumber,t.centeredLineNumber);const i=new fo(this._selections,t,this._context.viewLayout.getWhitespaceViewportData(),this._context.viewModel);this._contentWidgets.shouldRender()&&this._contentWidgets.onBeforeRender(i),this._viewLines.shouldRender()&&(this._viewLines.renderText(i),this._viewLines.onDidRender(),e=this._getViewPartsToRender());const n=new le(this._context.viewLayout,i,this._viewLines);for(const t of e)t.prepareRender(n);for(const t of e)t.render(n),t.onDidRender()}delegateVerticalScrollbarPointerDown(e){this._scrollbar.delegateVerticalScrollbarPointerDown(e)}delegateScrollFromMouseWheelEvent(e){this._scrollbar.delegateScrollFromMouseWheelEvent(e)}restoreState(e){this._context.viewModel.viewLayout.setScrollPosition({scrollTop:e.scrollTop,scrollLeft:e.scrollLeft},1),this._context.viewModel.visibleLinesStabilized()}getOffsetForColumn(e,t){const i=this._context.viewModel.model.validatePosition({lineNumber:e,column:t}),n=this._context.viewModel.coordinatesConverter.convertModelPositionToViewPosition(i);this._flushAccumulatedAndRenderNow();const o=this._viewLines.visibleRangeForPosition(new De.y(n.lineNumber,n.column));return o?o.left:-1}getTargetAtClientPoint(e,t){const i=this._pointerHandler.getTargetAtClientPoint(e,t);return i?Ii.convertViewToModelMouseTarget(i,this._context.viewModel.coordinatesConverter):null}createOverviewRuler(e){return new Jn(this._context,e)}change(e){this._viewZones.changeViewZones(e),this._scheduleRender()}render(e,t){if(t){this._viewLines.forceShouldRender();for(const e of this._viewParts)e.forceShouldRender()}e?this._flushAccumulatedAndRenderNow():this._scheduleRender()}writeScreenReaderContent(e){this._textAreaHandler.writeScreenReaderContent(e)}focus(){this._textAreaHandler.focusTextArea()}isFocused(){return this._textAreaHandler.isFocused()}setAriaOptions(e){this._textAreaHandler.setAriaOptions(e)}addContentWidget(e){this._contentWidgets.addWidget(e.widget),this.layoutContentWidget(e),this._scheduleRender()}layoutContentWidget(e){var t,i,n,o,s,r,a,l;this._contentWidgets.setWidgetPosition(e.widget,null!==(i=null===(t=e.position)||void 0===t?void 0:t.position)&&void 0!==i?i:null,null!==(o=null===(n=e.position)||void 0===n?void 0:n.secondaryPosition)&&void 0!==o?o:null,null!==(r=null===(s=e.position)||void 0===s?void 0:s.preference)&&void 0!==r?r:null,null!==(l=null===(a=e.position)||void 0===a?void 0:a.positionAffinity)&&void 0!==l?l:null),this._scheduleRender()}removeContentWidget(e){this._contentWidgets.removeWidget(e.widget),this._scheduleRender()}addOverlayWidget(e){this._overlayWidgets.addWidget(e.widget),this.layoutOverlayWidget(e),this._scheduleRender()}layoutOverlayWidget(e){const t=e.position?e.position.preference:null;this._overlayWidgets.setWidgetPosition(e.widget,t)&&this._scheduleRender()}removeOverlayWidget(e){this._overlayWidgets.removeWidget(e.widget),this._scheduleRender()}}var yo=i(9613),So=i(2322),ko=i(1847);class Eo{constructor(e){this._selTrackedRange=null,this._trackSelection=!0,this._setState(e,new Qt(new xe.Q(1,1,1,1),0,0,new De.y(1,1),0),new Qt(new xe.Q(1,1,1,1),0,0,new De.y(1,1),0))}dispose(e){this._removeTrackedRange(e)}startTrackingSelection(e){this._trackSelection=!0,this._updateTrackedRange(e)}stopTrackingSelection(e){this._trackSelection=!1,this._removeTrackedRange(e)}_updateTrackedRange(e){this._trackSelection&&(this._selTrackedRange=e.model._setTrackedRange(this._selTrackedRange,this.modelState.selection,0))}_removeTrackedRange(e){this._selTrackedRange=e.model._setTrackedRange(this._selTrackedRange,null,0)}asCursorState(){return new Ot(this.modelState,this.viewState)}readSelectionFromMarkers(e){const t=e.model._getTrackedRange(this._selTrackedRange);return this.modelState.selection.isEmpty()&&!t.isEmpty()?P.L.fromRange(t.collapseToEnd(),this.modelState.selection.getDirection()):P.L.fromRange(t,this.modelState.selection.getDirection())}ensureValidState(e){this._setState(e,this.modelState,this.viewState)}setState(e,t,i){this._setState(e,t,i)}static _validatePositionWithCache(e,t,i,n){return t.equals(i)?n:e.normalizePosition(t,2)}static _validateViewState(e,t){const i=t.position,n=t.selectionStart.getStartPosition(),o=t.selectionStart.getEndPosition(),s=e.normalizePosition(i,2),r=this._validatePositionWithCache(e,n,i,s),a=this._validatePositionWithCache(e,o,n,r);return i.equals(s)&&n.equals(r)&&o.equals(a)?t:new Qt(xe.Q.fromPositions(r,a),t.selectionStartKind,t.selectionStartLeftoverVisibleColumns+n.column-r.column,s,t.leftoverVisibleColumns+i.column-s.column)}_setState(e,t,i){if(i&&(i=Eo._validateViewState(e.viewModel,i)),t){const i=e.model.validateRange(t.selectionStart),n=t.selectionStart.equalsRange(i)?t.selectionStartLeftoverVisibleColumns:0,o=e.model.validatePosition(t.position),s=t.position.equals(o)?t.leftoverVisibleColumns:0;t=new Qt(i,t.selectionStartKind,n,o,s)}else{if(!i)return;const n=e.model.validateRange(e.coordinatesConverter.convertViewRangeToModelRange(i.selectionStart)),o=e.model.validatePosition(e.coordinatesConverter.convertViewPositionToModelPosition(i.position));t=new Qt(n,i.selectionStartKind,i.selectionStartLeftoverVisibleColumns,o,i.leftoverVisibleColumns)}if(i){const n=e.coordinatesConverter.validateViewRange(i.selectionStart,t.selectionStart),o=e.coordinatesConverter.validateViewPosition(i.position,t.position);i=new Qt(n,t.selectionStartKind,t.selectionStartLeftoverVisibleColumns,o,t.leftoverVisibleColumns)}else{const n=e.coordinatesConverter.convertModelPositionToViewPosition(new De.y(t.selectionStart.startLineNumber,t.selectionStart.startColumn)),o=e.coordinatesConverter.convertModelPositionToViewPosition(new De.y(t.selectionStart.endLineNumber,t.selectionStart.endColumn)),s=new xe.Q(n.lineNumber,n.column,o.lineNumber,o.column),r=e.coordinatesConverter.convertModelPositionToViewPosition(t.position);i=new Qt(s,t.selectionStartKind,t.selectionStartLeftoverVisibleColumns,r,t.leftoverVisibleColumns)}this.modelState=t,this.viewState=i,this._updateTrackedRange(e)}}class Do{constructor(e){this.context=e,this.cursors=[new Eo(e)],this.lastAddedCursorIndex=0}dispose(){for(const e of this.cursors)e.dispose(this.context)}startTrackingSelections(){for(const e of this.cursors)e.startTrackingSelection(this.context)}stopTrackingSelections(){for(const e of this.cursors)e.stopTrackingSelection(this.context)}updateContext(e){this.context=e}ensureValidState(){for(const e of this.cursors)e.ensureValidState(this.context)}readSelectionFromMarkers(){return this.cursors.map((e=>e.readSelectionFromMarkers(this.context)))}getAll(){return this.cursors.map((e=>e.asCursorState()))}getViewPositions(){return this.cursors.map((e=>e.viewState.position))}getTopMostViewPosition(){return(0,A.Ly)(this.cursors,(0,A.VE)((e=>e.viewState.position),De.y.compare)).viewState.position}getBottomMostViewPosition(){return(0,A.Jw)(this.cursors,(0,A.VE)((e=>e.viewState.position),De.y.compare)).viewState.position}getSelections(){return this.cursors.map((e=>e.modelState.selection))}getViewSelections(){return this.cursors.map((e=>e.viewState.selection))}setSelections(e){this.setStates(Ot.fromModelSelections(e))}getPrimaryCursor(){return this.cursors[0].asCursorState()}setStates(e){null!==e&&(this.cursors[0].setState(this.context,e[0].modelState,e[0].viewState),this._setSecondaryStates(e.slice(1)))}_setSecondaryStates(e){const t=this.cursors.length-1,i=e.length;if(t<i){const e=i-t;for(let t=0;t<e;t++)this._addSecondaryCursor()}else if(t>i){const e=t-i;for(let t=0;t<e;t++)this._removeSecondaryCursor(this.cursors.length-2)}for(let t=0;t<i;t++)this.cursors[t+1].setState(this.context,e[t].modelState,e[t].viewState)}killSecondaryCursors(){this._setSecondaryStates([])}_addSecondaryCursor(){this.cursors.push(new Eo(this.context)),this.lastAddedCursorIndex=this.cursors.length-1}getLastAddedCursorIndex(){return 1===this.cursors.length||0===this.lastAddedCursorIndex?0:this.lastAddedCursorIndex}_removeSecondaryCursor(e){this.lastAddedCursorIndex>=e+1&&this.lastAddedCursorIndex--,this.cursors[e+1].dispose(this.context),this.cursors.splice(e+1,1)}normalize(){if(1===this.cursors.length)return;const e=this.cursors.slice(0),t=[];for(let i=0,n=e.length;i<n;i++)t.push({index:i,selection:e[i].modelState.selection});t.sort((0,A.VE)((e=>e.selection),xe.Q.compareRangesUsingStarts));for(let i=0;i<t.length-1;i++){const n=t[i],o=t[i+1],s=n.selection,r=o.selection;if(!this.context.cursorConfig.multiCursorMergeOverlapping)continue;let a;if(a=r.isEmpty()||s.isEmpty()?r.getStartPosition().isBeforeOrEqual(s.getEndPosition()):r.getStartPosition().isBefore(s.getEndPosition()),a){const s=n.index<o.index?i:i+1,r=n.index<o.index?i+1:i,a=t[r].index,l=t[s].index,h=t[r].selection,c=t[s].selection;if(!h.equalsSelection(c)){const i=h.plusRange(c),n=h.selectionStartLineNumber===h.startLineNumber&&h.selectionStartColumn===h.startColumn,o=c.selectionStartLineNumber===c.startLineNumber&&c.selectionStartColumn===c.startColumn;let r,d;a===this.lastAddedCursorIndex?(r=n,this.lastAddedCursorIndex=l):r=o,d=r?new P.L(i.startLineNumber,i.startColumn,i.endLineNumber,i.endColumn):new P.L(i.endLineNumber,i.endColumn,i.startLineNumber,i.startColumn),t[s].selection=d;const u=Ot.fromModelSelection(d);e[l].setState(this.context,u.modelState,u.viewState)}for(const e of t)e.index>a&&e.index--;e.splice(a,1),t.splice(r,1),this._removeSecondaryCursor(a-1),i--}}}}class xo{constructor(e,t,i,n){this._cursorContextBrand=void 0,this.model=e,this.viewModel=t,this.coordinatesConverter=i,this.cursorConfig=n}}var Lo=i(6089);class Mo{constructor(){this.type=0}}class Io{constructor(){this.type=1}}class Bo{constructor(e){this.type=2,this._source=e}hasChanged(e){return this._source.hasChanged(e)}}class No{constructor(e,t,i){this.selections=e,this.modelSelections=t,this.reason=i,this.type=3}}class To{constructor(e){this.type=4,e?(this.affectsMinimap=e.affectsMinimap,this.affectsOverviewRuler=e.affectsOverviewRuler,this.affectsGlyphMargin=e.affectsGlyphMargin):(this.affectsMinimap=!0,this.affectsOverviewRuler=!0,this.affectsGlyphMargin=!0)}}class Fo{constructor(){this.type=5}}class Ro{constructor(e){this.type=6,this.isFocused=e}}class Oo{constructor(){this.type=7}}class Po{constructor(){this.type=8}}class zo{constructor(e,t){this.fromLineNumber=e,this.count=t,this.type=9}}class Qo{constructor(e,t){this.type=10,this.fromLineNumber=e,this.toLineNumber=t}}class Ho{constructor(e,t){this.type=11,this.fromLineNumber=e,this.toLineNumber=t}}class Wo{constructor(e,t,i,n,o,s,r){this.source=e,this.minimalReveal=t,this.range=i,this.selections=n,this.verticalType=o,this.revealHorizontal=s,this.scrollType=r,this.type=12}}class Vo{constructor(e){this.type=13,this.scrollWidth=e.scrollWidth,this.scrollLeft=e.scrollLeft,this.scrollHeight=e.scrollHeight,this.scrollTop=e.scrollTop,this.scrollWidthChanged=e.scrollWidthChanged,this.scrollLeftChanged=e.scrollLeftChanged,this.scrollHeightChanged=e.scrollHeightChanged,this.scrollTopChanged=e.scrollTopChanged}}class Uo{constructor(e){this.theme=e,this.type=14}}class jo{constructor(e){this.type=15,this.ranges=e}}class Go{constructor(){this.type=16}}class Ko{constructor(){this.type=17}}class Yo extends m.jG{constructor(){super(),this._onEvent=this._register(new g.vl),this.onEvent=this._onEvent.event,this._eventHandlers=[],this._viewEventQueue=null,this._isConsumingViewEventQueue=!1,this._collector=null,this._collectorCnt=0,this._outgoingEvents=[]}emitOutgoingEvent(e){this._addOutgoingEvent(e),this._emitOutgoingEvents()}_addOutgoingEvent(e){for(let t=0,i=this._outgoingEvents.length;t<i;t++){const i=this._outgoingEvents[t].kind===e.kind?this._outgoingEvents[t].attemptToMerge(e):null;if(i)return void(this._outgoingEvents[t]=i)}this._outgoingEvents.push(e)}_emitOutgoingEvents(){for(;this._outgoingEvents.length>0;){if(this._collector||this._isConsumingViewEventQueue)return;const e=this._outgoingEvents.shift();e.isNoOp()||this._onEvent.fire(e)}}addViewEventHandler(e){for(let t=0,i=this._eventHandlers.length;t<i;t++)this._eventHandlers[t]===e&&console.warn("Detected duplicate listener in ViewEventDispatcher",e);this._eventHandlers.push(e)}removeViewEventHandler(e){for(let t=0;t<this._eventHandlers.length;t++)if(this._eventHandlers[t]===e){this._eventHandlers.splice(t,1);break}}beginEmitViewEvents(){return this._collectorCnt++,1===this._collectorCnt&&(this._collector=new Jo),this._collector}endEmitViewEvents(){if(this._collectorCnt--,0===this._collectorCnt){const e=this._collector.outgoingEvents,t=this._collector.viewEvents;this._collector=null;for(const t of e)this._addOutgoingEvent(t);t.length>0&&this._emitMany(t)}this._emitOutgoingEvents()}emitSingleViewEvent(e){try{this.beginEmitViewEvents().emitViewEvent(e)}finally{this.endEmitViewEvents()}}_emitMany(e){this._viewEventQueue?this._viewEventQueue=this._viewEventQueue.concat(e):this._viewEventQueue=e,this._isConsumingViewEventQueue||this._consumeViewEventQueue()}_consumeViewEventQueue(){try{this._isConsumingViewEventQueue=!0,this._doConsumeQueue()}finally{this._isConsumingViewEventQueue=!1}}_doConsumeQueue(){for(;this._viewEventQueue;){const e=this._viewEventQueue;this._viewEventQueue=null;const t=this._eventHandlers.slice(0);for(const i of t)i.handleEvents(e)}}}class Jo{constructor(){this.viewEvents=[],this.outgoingEvents=[]}emitViewEvent(e){this.viewEvents.push(e)}emitOutgoingEvent(e){this.outgoingEvents.push(e)}}class qo{constructor(e,t,i,n){this.kind=0,this._oldContentWidth=e,this._oldContentHeight=t,this.contentWidth=i,this.contentHeight=n,this.contentWidthChanged=this._oldContentWidth!==this.contentWidth,this.contentHeightChanged=this._oldContentHeight!==this.contentHeight}isNoOp(){return!this.contentWidthChanged&&!this.contentHeightChanged}attemptToMerge(e){return e.kind!==this.kind?null:new qo(this._oldContentWidth,this._oldContentHeight,e.contentWidth,e.contentHeight)}}class $o{constructor(e,t){this.kind=1,this.oldHasFocus=e,this.hasFocus=t}isNoOp(){return this.oldHasFocus===this.hasFocus}attemptToMerge(e){return e.kind!==this.kind?null:new $o(this.oldHasFocus,e.hasFocus)}}class Xo{constructor(e,t,i,n,o,s,r,a){this.kind=2,this._oldScrollWidth=e,this._oldScrollLeft=t,this._oldScrollHeight=i,this._oldScrollTop=n,this.scrollWidth=o,this.scrollLeft=s,this.scrollHeight=r,this.scrollTop=a,this.scrollWidthChanged=this._oldScrollWidth!==this.scrollWidth,this.scrollLeftChanged=this._oldScrollLeft!==this.scrollLeft,this.scrollHeightChanged=this._oldScrollHeight!==this.scrollHeight,this.scrollTopChanged=this._oldScrollTop!==this.scrollTop}isNoOp(){return!(this.scrollWidthChanged||this.scrollLeftChanged||this.scrollHeightChanged||this.scrollTopChanged)}attemptToMerge(e){return e.kind!==this.kind?null:new Xo(this._oldScrollWidth,this._oldScrollLeft,this._oldScrollHeight,this._oldScrollTop,e.scrollWidth,e.scrollLeft,e.scrollHeight,e.scrollTop)}}class Zo{constructor(){this.kind=3}isNoOp(){return!1}attemptToMerge(e){return e.kind!==this.kind?null:this}}class es{constructor(){this.kind=4}isNoOp(){return!1}attemptToMerge(e){return e.kind!==this.kind?null:this}}class ts{constructor(e,t,i,n,o,s,r){this.kind=6,this.oldSelections=e,this.selections=t,this.oldModelVersionId=i,this.modelVersionId=n,this.source=o,this.reason=s,this.reachedMaxCursorCount=r}static _selectionsAreEqual(e,t){if(!e&&!t)return!0;if(!e||!t)return!1;const i=e.length;if(i!==t.length)return!1;for(let n=0;n<i;n++)if(!e[n].equalsSelection(t[n]))return!1;return!0}isNoOp(){return ts._selectionsAreEqual(this.oldSelections,this.selections)&&this.oldModelVersionId===this.modelVersionId}attemptToMerge(e){return e.kind!==this.kind?null:new ts(this.oldSelections,e.selections,this.oldModelVersionId,e.modelVersionId,e.source,e.reason,this.reachedMaxCursorCount||e.reachedMaxCursorCount)}}class is{constructor(){this.kind=5}isNoOp(){return!1}attemptToMerge(e){return e.kind!==this.kind?null:this}}class ns{constructor(e){this.event=e,this.kind=7}isNoOp(){return!1}attemptToMerge(e){return null}}class os{constructor(e){this.event=e,this.kind=8}isNoOp(){return!1}attemptToMerge(e){return null}}class ss{constructor(e){this.event=e,this.kind=9}isNoOp(){return!1}attemptToMerge(e){return null}}class rs{constructor(e){this.event=e,this.kind=10}isNoOp(){return!1}attemptToMerge(e){return null}}class as{constructor(e){this.event=e,this.kind=11}isNoOp(){return!1}attemptToMerge(e){return null}}class ls{constructor(e){this.event=e,this.kind=12}isNoOp(){return!1}attemptToMerge(e){return null}}class hs extends m.jG{constructor(e,t,i,n){super(),this._model=e,this._knownModelVersionId=this._model.getVersionId(),this._viewModel=t,this._coordinatesConverter=i,this.context=new xo(this._model,this._viewModel,this._coordinatesConverter,n),this._cursors=new Do(this.context),this._hasFocus=!1,this._isHandling=!1,this._compositionState=null,this._columnSelectData=null,this._autoClosedActions=[],this._prevEditOperationType=0}dispose(){this._cursors.dispose(),this._autoClosedActions=(0,m.AS)(this._autoClosedActions),super.dispose()}updateConfiguration(e){this.context=new xo(this._model,this._viewModel,this._coordinatesConverter,e),this._cursors.updateContext(this.context)}onLineMappingChanged(e){this._knownModelVersionId===this._model.getVersionId()&&this.setStates(e,"viewModel",0,this.getCursorStates())}setHasFocus(e){this._hasFocus=e}_validateAutoClosedActions(){if(this._autoClosedActions.length>0){const e=this._cursors.getSelections();for(let t=0;t<this._autoClosedActions.length;t++){const i=this._autoClosedActions[t];i.isValid(e)||(i.dispose(),this._autoClosedActions.splice(t,1),t--)}}}getPrimaryCursorState(){return this._cursors.getPrimaryCursor()}getLastAddedCursorIndex(){return this._cursors.getLastAddedCursorIndex()}getCursorStates(){return this._cursors.getAll()}setStates(e,t,i,n){let o=!1;const s=this.context.cursorConfig.multiCursorLimit;null!==n&&n.length>s&&(n=n.slice(0,s),o=!0);const r=cs.from(this._model,this);return this._cursors.setStates(n),this._cursors.normalize(),this._columnSelectData=null,this._validateAutoClosedActions(),this._emitStateChangedIfNecessary(e,t,i,r,o)}setCursorColumnSelectData(e){this._columnSelectData=e}revealPrimary(e,t,i,n,o,s){const r=this._cursors.getViewPositions();let a=null,l=null;r.length>1?l=this._cursors.getViewSelections():a=xe.Q.fromPositions(r[0],r[0]),e.emitViewEvent(new Wo(t,i,a,l,n,o,s))}saveState(){const e=[],t=this._cursors.getSelections();for(let i=0,n=t.length;i<n;i++){const n=t[i];e.push({inSelectionMode:!n.isEmpty(),selectionStart:{lineNumber:n.selectionStartLineNumber,column:n.selectionStartColumn},position:{lineNumber:n.positionLineNumber,column:n.positionColumn}})}return e}restoreState(e,t){const i=[];for(let e=0,n=t.length;e<n;e++){const n=t[e];let o=1,s=1;n.position&&n.position.lineNumber&&(o=n.position.lineNumber),n.position&&n.position.column&&(s=n.position.column);let r=o,a=s;n.selectionStart&&n.selectionStart.lineNumber&&(r=n.selectionStart.lineNumber),n.selectionStart&&n.selectionStart.column&&(a=n.selectionStart.column),i.push({selectionStartLineNumber:r,selectionStartColumn:a,positionLineNumber:o,positionColumn:s})}this.setStates(e,"restoreState",0,Ot.fromModelSelections(i)),this.revealPrimary(e,"restoreState",!1,0,!0,1)}onModelContentChanged(e,t){if(t instanceof Lo.vn){if(this._isHandling)return;this._isHandling=!0;try{this.setStates(e,"modelChange",0,this.getCursorStates())}finally{this._isHandling=!1}}else{const i=t.rawContentChangedEvent;if(this._knownModelVersionId=i.versionId,this._isHandling)return;const n=i.containsEvent(1);if(this._prevEditOperationType=0,n)this._cursors.dispose(),this._cursors=new Do(this.context),this._validateAutoClosedActions(),this._emitStateChangedIfNecessary(e,"model",1,null,!1);else if(this._hasFocus&&i.resultingSelection&&i.resultingSelection.length>0){const t=Ot.fromModelSelections(i.resultingSelection);this.setStates(e,"modelChange",i.isUndoing?5:i.isRedoing?6:2,t)&&this.revealPrimary(e,"modelChange",!1,0,!0,0)}else{const t=this._cursors.readSelectionFromMarkers();this.setStates(e,"modelChange",2,Ot.fromModelSelections(t))}}}getSelection(){return this._cursors.getPrimaryCursor().modelState.selection}getTopMostViewPosition(){return this._cursors.getTopMostViewPosition()}getBottomMostViewPosition(){return this._cursors.getBottomMostViewPosition()}getCursorColumnSelectData(){if(this._columnSelectData)return this._columnSelectData;const e=this._cursors.getPrimaryCursor(),t=e.viewState.selectionStart.getStartPosition(),i=e.viewState.position;return{isReal:!1,fromViewLineNumber:t.lineNumber,fromViewVisualColumn:this.context.cursorConfig.visibleColumnFromColumn(this._viewModel,t),toViewLineNumber:i.lineNumber,toViewVisualColumn:this.context.cursorConfig.visibleColumnFromColumn(this._viewModel,i)}}getSelections(){return this._cursors.getSelections()}setSelections(e,t,i,n){this.setStates(e,t,n,Ot.fromModelSelections(i))}getPrevEditOperationType(){return this._prevEditOperationType}setPrevEditOperationType(e){this._prevEditOperationType=e}_pushAutoClosedAction(e,t){const i=[],n=[];for(let o=0,s=e.length;o<s;o++)i.push({range:e[o],options:{description:"auto-closed-character",inlineClassName:"auto-closed-character",stickiness:1}}),n.push({range:t[o],options:{description:"auto-closed-enclosing",stickiness:1}});const o=this._model.deltaDecorations([],i),s=this._model.deltaDecorations([],n);this._autoClosedActions.push(new ds(this._model,o,s))}_executeEditOperation(e){if(!e)return;e.shouldPushStackElementBefore&&this._model.pushStackElement();const t=us.executeCommands(this._model,this._cursors.getSelections(),e.commands);if(t){this._interpretCommandResult(t);const i=[],n=[];for(let t=0;t<e.commands.length;t++){const o=e.commands[t];o instanceof ci&&o.enclosingRange&&o.closeCharacterRange&&(i.push(o.closeCharacterRange),n.push(o.enclosingRange))}i.length>0&&this._pushAutoClosedAction(i,n),this._prevEditOperationType=e.type}e.shouldPushStackElementAfter&&this._model.pushStackElement()}_interpretCommandResult(e){e&&0!==e.length||(e=this._cursors.readSelectionFromMarkers()),this._columnSelectData=null,this._cursors.setSelections(e),this._cursors.normalize()}_emitStateChangedIfNecessary(e,t,i,n,o){const s=cs.from(this._model,this);if(s.equals(n))return!1;const r=this._cursors.getSelections(),a=this._cursors.getViewSelections();if(e.emitViewEvent(new No(a,r,i)),!n||n.cursorState.length!==s.cursorState.length||s.cursorState.some(((e,t)=>!e.modelState.equals(n.cursorState[t].modelState)))){const a=n?n.cursorState.map((e=>e.modelState.selection)):null,l=n?n.modelVersionId:0;e.emitOutgoingEvent(new ts(a,r,l,s.modelVersionId,t||"keyboard",i,o))}return!0}_findAutoClosingPairs(e){if(!e.length)return null;const t=[];for(let i=0,n=e.length;i<n;i++){const n=e[i];if(!n.text||n.text.indexOf("\n")>=0)return null;const o=n.text.match(/([)\]}>'"`])([^)\]}>'"`]*)$/);if(!o)return null;const s=o[1],r=this.context.cursorConfig.autoClosingPairs.autoClosingPairsCloseSingleChar.get(s);if(!r||1!==r.length)return null;const a=r[0].open,l=n.text.length-o[2].length-1,h=n.text.lastIndexOf(a,l-1);if(-1===h)return null;t.push([h,l])}return t}executeEdits(e,t,i,n){let o=null;"snippet"===t&&(o=this._findAutoClosingPairs(i)),o&&(i[0]._isTracked=!0);const s=[],r=[],a=this._model.pushEditOperations(this.getSelections(),i,(e=>{if(o)for(let t=0,i=o.length;t<i;t++){const[i,n]=o[t],a=e[t],l=a.range.startLineNumber,h=a.range.startColumn-1+i,c=a.range.startColumn-1+n;s.push(new xe.Q(l,c+1,l,c+2)),r.push(new xe.Q(l,h+1,l,c+2))}const t=n(e);return t&&(this._isHandling=!0),t}));a&&(this._isHandling=!1,this.setSelections(e,t,a,0)),s.length>0&&this._pushAutoClosedAction(s,r)}_executeEdit(e,t,i,n=0){if(this.context.cursorConfig.readOnly)return;const o=cs.from(this._model,this);this._cursors.stopTrackingSelections(),this._isHandling=!0;try{this._cursors.ensureValidState(),e()}catch(e){(0,u.dz)(e)}this._isHandling=!1,this._cursors.startTrackingSelections(),this._validateAutoClosedActions(),this._emitStateChangedIfNecessary(t,i,n,o,!1)&&this.revealPrimary(t,i,!1,0,!0,0)}getAutoClosedCharacters(){return ds.getAllAutoClosedCharacters(this._autoClosedActions)}startComposition(e){this._compositionState=new ms(this._model,this.getSelections())}endComposition(e,t){const i=this._compositionState?this._compositionState.deduceOutcome(this._model,this.getSelections()):null;this._compositionState=null,this._executeEdit((()=>{"keyboard"===t&&this._executeEditOperation(hi.compositionEndWithInterceptors(this._prevEditOperationType,this.context.cursorConfig,this._model,i,this.getSelections(),this.getAutoClosedCharacters()))}),e,t)}type(e,t,i){this._executeEdit((()=>{if("keyboard"===i){const e=t.length;let i=0;for(;i<e;){const e=tt.iy(t,i),n=t.substr(i,e);this._executeEditOperation(hi.typeWithInterceptors(!!this._compositionState,this._prevEditOperationType,this.context.cursorConfig,this._model,this.getSelections(),this.getAutoClosedCharacters(),n)),i+=e}}else this._executeEditOperation(hi.typeWithoutInterceptors(this._prevEditOperationType,this.context.cursorConfig,this._model,this.getSelections(),t))}),e,i)}compositionType(e,t,i,n,o,s){if(0!==t.length||0!==i||0!==n)this._executeEdit((()=>{this._executeEditOperation(hi.compositionType(this._prevEditOperationType,this.context.cursorConfig,this._model,this.getSelections(),t,i,n,o))}),e,s);else if(0!==o){const t=this.getSelections().map((e=>{const t=e.getPosition();return new P.L(t.lineNumber,t.column+o,t.lineNumber,t.column+o)}));this.setSelections(e,s,t,0)}}paste(e,t,i,n,o){this._executeEdit((()=>{this._executeEditOperation(hi.paste(this.context.cursorConfig,this._model,this.getSelections(),t,i,n||[]))}),e,o,4)}cut(e,t){this._executeEdit((()=>{this._executeEditOperation(qt.cut(this.context.cursorConfig,this._model,this.getSelections()))}),e,t)}executeCommand(e,t,i){this._executeEdit((()=>{this._cursors.killSecondaryCursors(),this._executeEditOperation(new Ht(0,[t],{shouldPushStackElementBefore:!1,shouldPushStackElementAfter:!1}))}),e,i)}executeCommands(e,t,i){this._executeEdit((()=>{this._executeEditOperation(new Ht(0,t,{shouldPushStackElementBefore:!1,shouldPushStackElementAfter:!1}))}),e,i)}}class cs{static from(e,t){return new cs(e.getVersionId(),t.getCursorStates())}constructor(e,t){this.modelVersionId=e,this.cursorState=t}equals(e){if(!e)return!1;if(this.modelVersionId!==e.modelVersionId)return!1;if(this.cursorState.length!==e.cursorState.length)return!1;for(let t=0,i=this.cursorState.length;t<i;t++)if(!this.cursorState[t].equals(e.cursorState[t]))return!1;return!0}}class ds{static getAllAutoClosedCharacters(e){let t=[];for(const i of e)t=t.concat(i.getAutoClosedCharactersRanges());return t}constructor(e,t,i){this._model=e,this._autoClosedCharactersDecorations=t,this._autoClosedEnclosingDecorations=i}dispose(){this._autoClosedCharactersDecorations=this._model.deltaDecorations(this._autoClosedCharactersDecorations,[]),this._autoClosedEnclosingDecorations=this._model.deltaDecorations(this._autoClosedEnclosingDecorations,[])}getAutoClosedCharactersRanges(){const e=[];for(let t=0;t<this._autoClosedCharactersDecorations.length;t++){const i=this._model.getDecorationRange(this._autoClosedCharactersDecorations[t]);i&&e.push(i)}return e}isValid(e){const t=[];for(let e=0;e<this._autoClosedEnclosingDecorations.length;e++){const i=this._model.getDecorationRange(this._autoClosedEnclosingDecorations[e]);if(i&&(t.push(i),i.startLineNumber!==i.endLineNumber))return!1}t.sort(xe.Q.compareRangesUsingStarts),e.sort(xe.Q.compareRangesUsingStarts);for(let i=0;i<e.length;i++){if(i>=t.length)return!1;if(!t[i].strictContainsRange(e[i]))return!1}return!0}}class us{static executeCommands(e,t,i){const n={model:e,selectionsBefore:t,trackedRanges:[],trackedRangesDirection:[]},o=this._innerExecuteCommands(n,i);for(let e=0,t=n.trackedRanges.length;e<t;e++)n.model._setTrackedRange(n.trackedRanges[e],null,0);return o}static _innerExecuteCommands(e,t){if(this._arrayIsEmpty(t))return null;const i=this._getEditOperations(e,t);if(0===i.operations.length)return null;const n=i.operations,o=this._getLoserCursorMap(n);if(o.hasOwnProperty("0"))return console.warn("Ignoring commands"),null;const s=[];for(let e=0,t=n.length;e<t;e++)o.hasOwnProperty(n[e].identifier.major.toString())||s.push(n[e]);i.hadTrackedEditOperation&&s.length>0&&(s[0]._isTracked=!0);let r=e.model.pushEditOperations(e.selectionsBefore,s,(i=>{const n=[];for(let t=0;t<e.selectionsBefore.length;t++)n[t]=[];for(const e of i)e.identifier&&n[e.identifier.major].push(e);const o=(e,t)=>e.identifier.minor-t.identifier.minor,s=[];for(let i=0;i<e.selectionsBefore.length;i++)n[i].length>0?(n[i].sort(o),s[i]=t[i].computeCursorState(e.model,{getInverseEditOperations:()=>n[i],getTrackedSelection:t=>{const i=parseInt(t,10),n=e.model._getTrackedRange(e.trackedRanges[i]);return 0===e.trackedRangesDirection[i]?new P.L(n.startLineNumber,n.startColumn,n.endLineNumber,n.endColumn):new P.L(n.endLineNumber,n.endColumn,n.startLineNumber,n.startColumn)}})):s[i]=e.selectionsBefore[i];return s}));r||(r=e.selectionsBefore);const a=[];for(const e in o)o.hasOwnProperty(e)&&a.push(parseInt(e,10));a.sort(((e,t)=>t-e));for(const e of a)r.splice(e,1);return r}static _arrayIsEmpty(e){for(let t=0,i=e.length;t<i;t++)if(e[t])return!1;return!0}static _getEditOperations(e,t){let i=[],n=!1;for(let o=0,s=t.length;o<s;o++){const s=t[o];if(s){const t=this._getEditOperationsFromCommand(e,o,s);i=i.concat(t.operations),n=n||t.hadTrackedEditOperation}}return{operations:i,hadTrackedEditOperation:n}}static _getEditOperationsFromCommand(e,t,i){const n=[];let o=0;const s=(e,s,r=!1)=>{xe.Q.isEmpty(e)&&""===s||n.push({identifier:{major:t,minor:o++},range:e,text:s,forceMoveMarkers:r,isAutoWhitespaceEdit:i.insertsAutoWhitespace})};let r=!1;const a={addEditOperation:s,addTrackedEditOperation:(e,t,i)=>{r=!0,s(e,t,i)},trackSelection:(t,i)=>{const n=P.L.liftSelection(t);let o;if(n.isEmpty())if("boolean"==typeof i)o=i?2:3;else{const t=e.model.getLineMaxColumn(n.startLineNumber);o=n.startColumn===t?2:3}else o=1;const s=e.trackedRanges.length,r=e.model._setTrackedRange(null,n,o);return e.trackedRanges[s]=r,e.trackedRangesDirection[s]=n.getDirection(),s.toString()}};try{i.getEditOperations(e.model,a)}catch(e){return(0,u.dz)(e),{operations:[],hadTrackedEditOperation:!1}}return{operations:n,hadTrackedEditOperation:r}}static _getLoserCursorMap(e){(e=e.slice(0)).sort(((e,t)=>-xe.Q.compareRangesUsingEnds(e.range,t.range)));const t={};for(let i=1;i<e.length;i++){const n=e[i-1],o=e[i];if(xe.Q.getStartPosition(n.range).isBefore(xe.Q.getEndPosition(o.range))){let s;s=n.identifier.major>o.identifier.major?n.identifier.major:o.identifier.major,t[s.toString()]=!0;for(let t=0;t<e.length;t++)e[t].identifier.major===s&&(e.splice(t,1),t<i&&i--,t--);i>0&&i--}}return t}}class gs{constructor(e,t,i){this.text=e,this.startSelection=t,this.endSelection=i}}class ms{static _capture(e,t){const i=[];for(const n of t){if(n.startLineNumber!==n.endLineNumber)return null;i.push(new gs(e.getLineContent(n.startLineNumber),n.startColumn-1,n.endColumn-1))}return i}constructor(e,t){this._original=ms._capture(e,t)}deduceOutcome(e,t){if(!this._original)return null;const i=ms._capture(e,t);if(!i)return null;if(this._original.length!==i.length)return null;const n=[];for(let e=0,t=this._original.length;e<t;e++)n.push(ms._deduceOutcome(this._original[e],i[e]));return n}static _deduceOutcome(e,t){const i=Math.min(e.startSelection,t.startSelection,tt.Qp(e.text,t.text)),n=Math.min(e.text.length-e.endSelection,t.text.length-t.endSelection,tt.Vi(e.text,t.text)),o=e.text.substring(i,e.text.length-n),s=t.text.substring(i,t.text.length-n);return new di(o,e.startSelection-i,e.endSelection-i,s,t.startSelection-i,t.endSelection-i)}}var ps=i(4275),fs=i(9440),As=i(1955);class _s{constructor(){this._hasPending=!1,this._inserts=[],this._changes=[],this._removes=[]}insert(e){this._hasPending=!0,this._inserts.push(e)}change(e){this._hasPending=!0,this._changes.push(e)}remove(e){this._hasPending=!0,this._removes.push(e)}mustCommit(){return this._hasPending}commit(e){if(!this._hasPending)return;const t=this._inserts,i=this._changes,n=this._removes;this._hasPending=!1,this._inserts=[],this._changes=[],this._removes=[],e._commitPendingChanges(t,i,n)}}class ws{constructor(e,t,i,n,o){this.id=e,this.afterLineNumber=t,this.ordinal=i,this.height=n,this.minWidth=o,this.prefixSum=0}}class bs{constructor(e,t,i,n){this._instanceId=tt.tk(++bs.INSTANCE_COUNT),this._pendingChanges=new _s,this._lastWhitespaceId=0,this._arr=[],this._prefixSumValidIndex=-1,this._minWidth=-1,this._lineCount=e,this._lineHeight=t,this._paddingTop=i,this._paddingBottom=n}static findInsertionIndex(e,t,i){let n=0,o=e.length;for(;n<o;){const s=n+o>>>1;t===e[s].afterLineNumber?i<e[s].ordinal?o=s:n=s+1:t<e[s].afterLineNumber?o=s:n=s+1}return n}setLineHeight(e){this._checkPendingChanges(),this._lineHeight=e}setPadding(e,t){this._paddingTop=e,this._paddingBottom=t}onFlushed(e){this._checkPendingChanges(),this._lineCount=e}changeWhitespace(e){let t=!1;try{e({insertWhitespace:(e,i,n,o)=>{t=!0,e|=0,i|=0,n|=0,o|=0;const s=this._instanceId+ ++this._lastWhitespaceId;return this._pendingChanges.insert(new ws(s,e,i,n,o)),s},changeOneWhitespace:(e,i,n)=>{t=!0,i|=0,n|=0,this._pendingChanges.change({id:e,newAfterLineNumber:i,newHeight:n})},removeWhitespace:e=>{t=!0,this._pendingChanges.remove({id:e})}})}finally{this._pendingChanges.commit(this)}return t}_commitPendingChanges(e,t,i){if((e.length>0||i.length>0)&&(this._minWidth=-1),e.length+t.length+i.length<=1){for(const t of e)this._insertWhitespace(t);for(const e of t)this._changeOneWhitespace(e.id,e.newAfterLineNumber,e.newHeight);for(const e of i){const t=this._findWhitespaceIndex(e.id);-1!==t&&this._removeWhitespace(t)}return}const n=new Set;for(const e of i)n.add(e.id);const o=new Map;for(const e of t)o.set(e.id,e);const s=e=>{const t=[];for(const i of e)if(!n.has(i.id)){if(o.has(i.id)){const e=o.get(i.id);i.afterLineNumber=e.newAfterLineNumber,i.height=e.newHeight}t.push(i)}return t},r=s(this._arr).concat(s(e));r.sort(((e,t)=>e.afterLineNumber===t.afterLineNumber?e.ordinal-t.ordinal:e.afterLineNumber-t.afterLineNumber)),this._arr=r,this._prefixSumValidIndex=-1}_checkPendingChanges(){this._pendingChanges.mustCommit()&&this._pendingChanges.commit(this)}_insertWhitespace(e){const t=bs.findInsertionIndex(this._arr,e.afterLineNumber,e.ordinal);this._arr.splice(t,0,e),this._prefixSumValidIndex=Math.min(this._prefixSumValidIndex,t-1)}_findWhitespaceIndex(e){const t=this._arr;for(let i=0,n=t.length;i<n;i++)if(t[i].id===e)return i;return-1}_changeOneWhitespace(e,t,i){const n=this._findWhitespaceIndex(e);if(-1!==n&&(this._arr[n].height!==i&&(this._arr[n].height=i,this._prefixSumValidIndex=Math.min(this._prefixSumValidIndex,n-1)),this._arr[n].afterLineNumber!==t)){const e=this._arr[n];this._removeWhitespace(n),e.afterLineNumber=t,this._insertWhitespace(e)}}_removeWhitespace(e){this._arr.splice(e,1),this._prefixSumValidIndex=Math.min(this._prefixSumValidIndex,e-1)}onLinesDeleted(e,t){this._checkPendingChanges(),e|=0,t|=0,this._lineCount-=t-e+1;for(let i=0,n=this._arr.length;i<n;i++){const n=this._arr[i].afterLineNumber;e<=n&&n<=t?this._arr[i].afterLineNumber=e-1:n>t&&(this._arr[i].afterLineNumber-=t-e+1)}}onLinesInserted(e,t){this._checkPendingChanges(),e|=0,t|=0,this._lineCount+=t-e+1;for(let i=0,n=this._arr.length;i<n;i++)e<=this._arr[i].afterLineNumber&&(this._arr[i].afterLineNumber+=t-e+1)}getWhitespacesTotalHeight(){return this._checkPendingChanges(),0===this._arr.length?0:this.getWhitespacesAccumulatedHeight(this._arr.length-1)}getWhitespacesAccumulatedHeight(e){this._checkPendingChanges(),e|=0;let t=Math.max(0,this._prefixSumValidIndex+1);0===t&&(this._arr[0].prefixSum=this._arr[0].height,t++);for(let i=t;i<=e;i++)this._arr[i].prefixSum=this._arr[i-1].prefixSum+this._arr[i].height;return this._prefixSumValidIndex=Math.max(this._prefixSumValidIndex,e),this._arr[e].prefixSum}getLinesTotalHeight(){return this._checkPendingChanges(),this._lineHeight*this._lineCount+this.getWhitespacesTotalHeight()+this._paddingTop+this._paddingBottom}getWhitespaceAccumulatedHeightBeforeLineNumber(e){this._checkPendingChanges(),e|=0;const t=this._findLastWhitespaceBeforeLineNumber(e);return-1===t?0:this.getWhitespacesAccumulatedHeight(t)}_findLastWhitespaceBeforeLineNumber(e){e|=0;const t=this._arr;let i=0,n=t.length-1;for(;i<=n;){const o=i+((n-i|0)/2|0)|0;if(t[o].afterLineNumber<e){if(o+1>=t.length||t[o+1].afterLineNumber>=e)return o;i=o+1|0}else n=o-1|0}return-1}_findFirstWhitespaceAfterLineNumber(e){e|=0;const t=this._findLastWhitespaceBeforeLineNumber(e)+1;return t<this._arr.length?t:-1}getFirstWhitespaceIndexAfterLineNumber(e){return this._checkPendingChanges(),e|=0,this._findFirstWhitespaceAfterLineNumber(e)}getVerticalOffsetForLineNumber(e,t=!1){let i;return this._checkPendingChanges(),i=(e|=0)>1?this._lineHeight*(e-1):0,i+this.getWhitespaceAccumulatedHeightBeforeLineNumber(e-(t?1:0))+this._paddingTop}getVerticalOffsetAfterLineNumber(e,t=!1){return this._checkPendingChanges(),e|=0,this._lineHeight*e+this.getWhitespaceAccumulatedHeightBeforeLineNumber(e+(t?1:0))+this._paddingTop}getWhitespaceMinWidth(){if(this._checkPendingChanges(),-1===this._minWidth){let e=0;for(let t=0,i=this._arr.length;t<i;t++)e=Math.max(e,this._arr[t].minWidth);this._minWidth=e}return this._minWidth}isAfterLines(e){return this._checkPendingChanges(),e>this.getLinesTotalHeight()}isInTopPadding(e){return 0!==this._paddingTop&&(this._checkPendingChanges(),e<this._paddingTop)}isInBottomPadding(e){return 0!==this._paddingBottom&&(this._checkPendingChanges(),e>=this.getLinesTotalHeight()-this._paddingBottom)}getLineNumberAtOrAfterVerticalOffset(e){if(this._checkPendingChanges(),(e|=0)<0)return 1;const t=0|this._lineCount,i=this._lineHeight;let n=1,o=t;for(;n<o;){const t=(n+o)/2|0,s=0|this.getVerticalOffsetForLineNumber(t);if(e>=s+i)n=t+1;else{if(e>=s)return t;o=t}}return n>t?t:n}getLinesViewportData(e,t){this._checkPendingChanges(),e|=0,t|=0;const i=this._lineHeight,n=0|this.getLineNumberAtOrAfterVerticalOffset(e),o=0|this.getVerticalOffsetForLineNumber(n);let s=0|this._lineCount,r=0|this.getFirstWhitespaceIndexAfterLineNumber(n);const a=0|this.getWhitespacesCount();let l,h;-1===r?(r=a,h=s+1,l=0):(h=0|this.getAfterLineNumberForWhitespaceIndex(r),l=0|this.getHeightForWhitespaceIndex(r));let c=o,d=c;const u=5e5;let g=0;o>=u&&(g=Math.floor(o/u)*u,g=Math.floor(g/i)*i,d-=g);const m=[],p=e+(t-e)/2;let f=-1;for(let e=n;e<=s;e++){for(-1===f&&(c<=p&&p<c+i||c>p)&&(f=e),c+=i,m[e-n]=d,d+=i;h===e;)d+=l,c+=l,r++,r>=a?h=s+1:(h=0|this.getAfterLineNumberForWhitespaceIndex(r),l=0|this.getHeightForWhitespaceIndex(r));if(c>=t){s=e;break}}-1===f&&(f=s);const A=0|this.getVerticalOffsetForLineNumber(s);let _=n,w=s;return _<w&&o<e&&_++,_<w&&A+i>t&&w--,{bigNumbersDelta:g,startLineNumber:n,endLineNumber:s,relativeVerticalOffset:m,centeredLineNumber:f,completelyVisibleStartLineNumber:_,completelyVisibleEndLineNumber:w}}getVerticalOffsetForWhitespaceIndex(e){this._checkPendingChanges(),e|=0;const t=this.getAfterLineNumberForWhitespaceIndex(e);let i,n;return i=t>=1?this._lineHeight*t:0,n=e>0?this.getWhitespacesAccumulatedHeight(e-1):0,i+n+this._paddingTop}getWhitespaceIndexAtOrAfterVerticallOffset(e){this._checkPendingChanges(),e|=0;let t=0,i=this.getWhitespacesCount()-1;if(i<0)return-1;if(e>=this.getVerticalOffsetForWhitespaceIndex(i)+this.getHeightForWhitespaceIndex(i))return-1;for(;t<i;){const n=Math.floor((t+i)/2),o=this.getVerticalOffsetForWhitespaceIndex(n);if(e>=o+this.getHeightForWhitespaceIndex(n))t=n+1;else{if(e>=o)return n;i=n}}return t}getWhitespaceAtVerticalOffset(e){this._checkPendingChanges(),e|=0;const t=this.getWhitespaceIndexAtOrAfterVerticallOffset(e);if(t<0)return null;if(t>=this.getWhitespacesCount())return null;const i=this.getVerticalOffsetForWhitespaceIndex(t);if(i>e)return null;const n=this.getHeightForWhitespaceIndex(t);return{id:this.getIdForWhitespaceIndex(t),afterLineNumber:this.getAfterLineNumberForWhitespaceIndex(t),verticalOffset:i,height:n}}getWhitespaceViewportData(e,t){this._checkPendingChanges(),e|=0,t|=0;const i=this.getWhitespaceIndexAtOrAfterVerticallOffset(e),n=this.getWhitespacesCount()-1;if(i<0)return[];const o=[];for(let e=i;e<=n;e++){const i=this.getVerticalOffsetForWhitespaceIndex(e),n=this.getHeightForWhitespaceIndex(e);if(i>=t)break;o.push({id:this.getIdForWhitespaceIndex(e),afterLineNumber:this.getAfterLineNumberForWhitespaceIndex(e),verticalOffset:i,height:n})}return o}getWhitespaces(){return this._checkPendingChanges(),this._arr.slice(0)}getWhitespacesCount(){return this._checkPendingChanges(),this._arr.length}getIdForWhitespaceIndex(e){return this._checkPendingChanges(),e|=0,this._arr[e].id}getAfterLineNumberForWhitespaceIndex(e){return this._checkPendingChanges(),e|=0,this._arr[e].afterLineNumber}getHeightForWhitespaceIndex(e){return this._checkPendingChanges(),e|=0,this._arr[e].height}}bs.INSTANCE_COUNT=0;class vs{constructor(e,t,i,n){(e|=0)<0&&(e=0),(t|=0)<0&&(t=0),(i|=0)<0&&(i=0),(n|=0)<0&&(n=0),this.width=e,this.contentWidth=t,this.scrollWidth=Math.max(e,t),this.height=i,this.contentHeight=n,this.scrollHeight=Math.max(i,n)}equals(e){return this.width===e.width&&this.contentWidth===e.contentWidth&&this.height===e.height&&this.contentHeight===e.contentHeight}}class Cs extends m.jG{constructor(e,t){super(),this._onDidContentSizeChange=this._register(new g.vl),this.onDidContentSizeChange=this._onDidContentSizeChange.event,this._dimensions=new vs(0,0,0,0),this._scrollable=this._register(new As.yE({forceIntegerValues:!0,smoothScrollDuration:e,scheduleAtNextAnimationFrame:t})),this.onDidScroll=this._scrollable.onScroll}getScrollable(){return this._scrollable}setSmoothScrollDuration(e){this._scrollable.setSmoothScrollDuration(e)}validateScrollPosition(e){return this._scrollable.validateScrollPosition(e)}getScrollDimensions(){return this._dimensions}setScrollDimensions(e){if(this._dimensions.equals(e))return;const t=this._dimensions;this._dimensions=e,this._scrollable.setScrollDimensions({width:e.width,scrollWidth:e.scrollWidth,height:e.height,scrollHeight:e.scrollHeight},!0);const i=t.contentWidth!==e.contentWidth,n=t.contentHeight!==e.contentHeight;(i||n)&&this._onDidContentSizeChange.fire(new qo(t.contentWidth,t.contentHeight,e.contentWidth,e.contentHeight))}getFutureScrollPosition(){return this._scrollable.getFutureScrollPosition()}getCurrentScrollPosition(){return this._scrollable.getCurrentScrollPosition()}setScrollPositionNow(e){this._scrollable.setScrollPositionNow(e)}setScrollPositionSmooth(e){this._scrollable.setScrollPositionSmooth(e)}hasPendingScrollAnimation(){return this._scrollable.hasPendingScrollAnimation()}}class ys extends m.jG{constructor(e,t,i){super(),this._configuration=e;const n=this._configuration.options,o=n.get(140),s=n.get(81);this._linesLayout=new bs(t,n.get(64),s.top,s.bottom),this._scrollable=this._register(new Cs(0,i)),this._configureSmoothScrollDuration(),this._scrollable.setScrollDimensions(new vs(o.contentWidth,0,o.height,0)),this.onDidScroll=this._scrollable.onDidScroll,this.onDidContentSizeChange=this._scrollable.onDidContentSizeChange,this._updateHeight()}dispose(){super.dispose()}getScrollable(){return this._scrollable.getScrollable()}onHeightMaybeChanged(){this._updateHeight()}_configureSmoothScrollDuration(){this._scrollable.setSmoothScrollDuration(this._configuration.options.get(110)?125:0)}onConfigurationChanged(e){const t=this._co