/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.spi;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.mqtt.spi.UserProperty;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.TopicFilterOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserPropsCustomizer
implements IUserPropsCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPropsCustomizer.class);
    private final IUserPropsCustomizer delegate;

    UserPropsCustomizer(List<IUserPropsCustomizer> customizers) {
        this.delegate = customizers.isEmpty() ? new DummyUserPropsCustomizer() : new AggregatedUserPropsCustomizer(customizers);
    }

    public Iterable<UserProperty> inbound(String topic, QoS pubQoS, ByteString payload, ClientInfo publisher, long hlc) {
        return this.delegate.inbound(topic, pubQoS, payload, publisher, hlc);
    }

    public Iterable<UserProperty> outbound(String topic, Message message, ClientInfo publisher, String topicFilter, TopicFilterOption option, ClientInfo subscriber, long hlc) {
        return this.delegate.outbound(topic, message, publisher, topicFilter, option, subscriber, hlc);
    }

    private static class DummyUserPropsCustomizer
    implements IUserPropsCustomizer {
        private DummyUserPropsCustomizer() {
        }

        public Iterable<UserProperty> inbound(String topic, QoS pubQoS, ByteString payload, ClientInfo publisher, long hlc) {
            return Collections.emptyList();
        }

        public Iterable<UserProperty> outbound(String topic, Message message, ClientInfo publisher, String topicFilter, TopicFilterOption option, ClientInfo subscriber, long hlc) {
            return Collections.emptyList();
        }
    }

    private static class AggregatedUserPropsCustomizer
    implements IUserPropsCustomizer {
        private final List<IUserPropsCustomizer> customizers;

        private AggregatedUserPropsCustomizer(List<IUserPropsCustomizer> customizers) {
            this.customizers = customizers;
        }

        public Iterable<UserProperty> inbound(String topic, QoS pubQoS, ByteString payload, ClientInfo publisher, long hlc) {
            return Iterables.concat((Iterable)Lists.transform(this.customizers, customizer -> {
                try {
                    return customizer.inbound(topic, pubQoS, payload, publisher, hlc);
                }
                catch (Throwable e) {
                    log.error("Error customizing inbound user properties for topic: {}", (Object)topic, (Object)e);
                    return Collections.emptyList();
                }
            }));
        }

        public Iterable<UserProperty> outbound(String topic, Message message, ClientInfo publisher, String topicFilter, TopicFilterOption option, ClientInfo subscriber, long hlc) {
            return Iterables.concat((Iterable)Lists.transform(this.customizers, customizer -> {
                try {
                    return customizer.outbound(topic, message, publisher, topicFilter, option, subscriber, hlc);
                }
                catch (Throwable e) {
                    log.error("Error customizing outbound user properties for topic: {}", (Object)topic, (Object)e);
                    return Collections.emptyList();
                }
            }));
        }
    }
}

