/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandlersFactory;
import org.apache.bifromq.apiserver.http.handler.DisableBalancerHandler;
import org.apache.bifromq.apiserver.http.handler.EnableBalancerHandler;
import org.apache.bifromq.apiserver.http.handler.ExpireRetainHandler;
import org.apache.bifromq.apiserver.http.handler.ExpireSessionHandler;
import org.apache.bifromq.apiserver.http.handler.GetBalancerStateHandler;
import org.apache.bifromq.apiserver.http.handler.GetClusterHandler;
import org.apache.bifromq.apiserver.http.handler.GetLoadRulesHandler;
import org.apache.bifromq.apiserver.http.handler.GetServiceLandscapeHandler;
import org.apache.bifromq.apiserver.http.handler.GetSessionInboxStateHandler;
import org.apache.bifromq.apiserver.http.handler.GetSessionInfoHandler;
import org.apache.bifromq.apiserver.http.handler.GetStoreLandscapeHandler;
import org.apache.bifromq.apiserver.http.handler.GetStoreRangesHandler;
import org.apache.bifromq.apiserver.http.handler.GetTrafficRulesHandler;
import org.apache.bifromq.apiserver.http.handler.KillHandler;
import org.apache.bifromq.apiserver.http.handler.ListAllServicesHandler;
import org.apache.bifromq.apiserver.http.handler.ListAllStoreHandler;
import org.apache.bifromq.apiserver.http.handler.PubHandler;
import org.apache.bifromq.apiserver.http.handler.RetainHandler;
import org.apache.bifromq.apiserver.http.handler.SetLoadRulesHandler;
import org.apache.bifromq.apiserver.http.handler.SetServerGroupTagsHandler;
import org.apache.bifromq.apiserver.http.handler.SetTrafficRulesHandler;
import org.apache.bifromq.apiserver.http.handler.SubHandler;
import org.apache.bifromq.apiserver.http.handler.UnsetTrafficRulesHandler;
import org.apache.bifromq.apiserver.http.handler.UnsubHandler;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;

public final class RequestHandlersFactory
implements IHTTPRequestHandlersFactory {
    private final Map<Class<? extends IHTTPRequestHandler>, IHTTPRequestHandler> handlers = new HashMap<Class<? extends IHTTPRequestHandler>, IHTTPRequestHandler>();

    public RequestHandlersFactory(IAgentHost agentHost, IRPCServiceTrafficService trafficService, IBaseKVMetaService metaService, ISessionDictClient sessionDictClient, IDistClient distClient, IInboxClient inboxClient, IRetainClient retainClient, ISettingProvider settingProvider) {
        this.register(new ListAllStoreHandler(metaService));
        this.register(new GetStoreLandscapeHandler(metaService, trafficService));
        this.register(new GetStoreRangesHandler(metaService));
        this.register(new EnableBalancerHandler(metaService));
        this.register(new DisableBalancerHandler(metaService));
        this.register(new GetBalancerStateHandler(metaService));
        this.register(new GetLoadRulesHandler(metaService));
        this.register(new SetLoadRulesHandler(metaService));
        this.register(new GetTrafficRulesHandler(trafficService));
        this.register(new SetTrafficRulesHandler(trafficService));
        this.register(new UnsetTrafficRulesHandler(trafficService));
        this.register(new GetClusterHandler(agentHost));
        this.register(new ListAllServicesHandler(trafficService));
        this.register(new GetServiceLandscapeHandler(trafficService));
        this.register(new SetServerGroupTagsHandler(trafficService));
        this.register(new GetSessionInfoHandler(settingProvider, sessionDictClient));
        this.register(new KillHandler(settingProvider, sessionDictClient));
        this.register(new RetainHandler(settingProvider, retainClient));
        this.register(new ExpireRetainHandler(settingProvider, retainClient));
        this.register(new PubHandler(settingProvider, distClient));
        this.register(new SubHandler(settingProvider, sessionDictClient));
        this.register(new UnsubHandler(settingProvider, sessionDictClient));
        this.register(new ExpireSessionHandler(settingProvider, inboxClient));
        this.register(new GetSessionInboxStateHandler(settingProvider, sessionDictClient));
    }

    @Override
    public Collection<IHTTPRequestHandler> build() {
        return this.handlers.values();
    }

    private void register(IHTTPRequestHandler handler) {
        this.handlers.put(handler.getClass(), handler);
    }
}

