/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import java.util.Set;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.DelAccessMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RolePerm;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatedAccessMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)DelegatedAccessMgrImpl.class.getName());

    DelegatedAccessMgrImpl() {
    }

    FortResponse canAssign(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserRole uRole = (UserRole)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            boolean result = accessMgr.canAssign(session, new User(uRole.getUserId()), new Role(uRole.getName()));
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse canDeassign(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserRole uRole = (UserRole)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            boolean result = accessMgr.canDeassign(session, new User(uRole.getUserId()), new Role(uRole.getName()));
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse canGrant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            RolePerm context = (RolePerm)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            boolean result = accessMgr.canGrant(session, new Role(context.getRole().getName()), context.getPerm());
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse canRevoke(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            RolePerm context = (RolePerm)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            boolean result = accessMgr.canRevoke(session, new Role(context.getRole().getName()), context.getPerm());
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    public FortResponse checkAdminAccess(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            Permission perm = (Permission)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            perm.setAdmin(true);
            boolean result = accessMgr.checkAccess(session, perm);
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addActiveAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAdminRole uAdminRole = (UserAdminRole)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            accessMgr.addActiveRole(session, uAdminRole);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dropActiveAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAdminRole uAdminRole = (UserAdminRole)request.getEntity();
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            accessMgr.dropActiveRole(session, uAdminRole);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse sessionAdminRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            Session session = request.getSession();
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            List roles = accessMgr.sessionAdminRoles(session);
            response.setEntities(roles);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse sessionAdminPermissions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            List perms = accessMgr.sessionPermissions(session);
            response.setSession(session);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedSessionRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            DelAccessMgr accessMgr = DelAccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            Set roles = accessMgr.authorizedAdminRoles(session);
            response.setValueSet(roles);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

