/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.PropertyProvider;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUpdater;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;

final class RoleDAO
extends LdapDataProvider
implements PropertyProvider<Role>,
PropUpdater {
    private static final String ROLE_NM = "ftRoleName";
    private static final String[] ROLE_NM_ATR;
    private static final String POSIX_GROUP = "posixGroup";
    static final boolean IS_RFC2307;
    private static final String[] ROLE_ATRS;
    private static final String[] ROLE_CONSTRAINTS;
    private static String[] ROLE_OBJ_CLASS;

    RoleDAO() {
    }

    @Override
    public String newValue(String value) {
        Integer id = new Integer(value);
        Integer newId = id + 1;
        return newId.toString();
    }

    Role create(Role entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", ROLE_OBJ_CLASS);
            entity.setId();
            entry.add("ftId", new String[]{entity.getId()});
            entry.add(ROLE_NM, new String[]{entity.getName()});
            if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            entry.add("cn", new String[]{entity.getName()});
            entry.add("ftCstr", new String[]{ConstraintUtil.setConstraint(entity)});
            this.loadAttrs(entity.getParents(), (Entry)entry, "ftParents");
            if (IS_RFC2307) {
                this.loadGidNumber(entity);
                entry.add("gidNumber", new String[]{entity.getGidNumber()});
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
        }
        catch (LdapException e) {
            try {
                String error = "create role [" + entity.getName() + "] caught LdapException=" + e;
                throw new CreateException(5002, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Role update(Role entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            String szRawData;
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (entity.isTemporalSet() && StringUtils.isNotEmpty((CharSequence)(szRawData = ConstraintUtil.setConstraint(entity)))) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftCstr", new String[]{szRawData}));
            }
            this.loadAttrs(entity.getParents(), mods, "ftParents");
            if (IS_RFC2307 && StringUtils.isNotEmpty((CharSequence)entity.getGidNumber())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "gidNumber", new String[]{entity.getGidNumber()}));
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update name [" + entity.getName() + "] caught LdapException=" + e;
                throw new UpdateException(5003, error, (Exception)((Object)e));
                catch (Exception e2) {
                    error = "update name [" + entity.getName() + "] caught LdapException=" + e2.getMessage();
                    throw new UpdateException(5003, error, e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeAdminConnection(ld);
                    throw throwable;
                }
                catch (Exception e3) {
                    String error = "update name [" + entity.getName() + "] caught LdapException=" + e3;
                    throw new UpdateException(5003, error, e3);
                }
            }
        }
        try {
            this.closeAdminConnection(ld);
            return entity;
        }
        catch (Exception e) {
            String error = "update name [" + entity.getName() + "] caught LdapException=" + e;
            throw new UpdateException(5003, error, e);
        }
    }

    void deleteParent(Role entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftParents"));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deleteParent name [" + entity.getName() + "] caught LdapException=" + e;
                throw new UpdateException(5015, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    Role assign(Role entity, String userDn) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "roleOccupant", new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "assign role name [" + entity.getName() + "] user dn [" + userDn + "] caught LdapException=" + e;
                throw new UpdateException(5008, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    Role deassign(Role entity, String userDn) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "roleOccupant", new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deassign role name [" + entity.getName() + "] user dn [" + userDn + "] caught LdapException=" + e;
                throw new UpdateException(5009, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void remove(Role role) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(role.getName(), role.getContextId());
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn, (FortEntity)role);
        }
        catch (LdapException e) {
            String error = "remove role name=" + role.getName() + " LdapException=" + e;
            throw new RemoveException(5004, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    Role getRole(Role role) throws FinderException {
        Role entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(role.getName(), role.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, ROLE_ATRS);
            if (findEntry != null) {
                entity = this.unloadLdapEntry(findEntry, 0L, role.getContextId());
            }
            if (entity == null) {
                String warning = "getRole no entry found dn [" + dn + "]";
                throw new FinderException(5006, warning);
            }
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getRole Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(5006, warning);
        }
        catch (LdapException e) {
            String error = "getRole dn [" + dn + "] LEXCD=" + e;
            throw new FinderException(5001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    Role getConstraints(Role role) throws FinderException {
        Role entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(role.getName(), role.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, ROLE_CONSTRAINTS);
            if (findEntry != null) {
                entity = this.unloadLdapEntry(findEntry, 0L, role.getContextId());
            }
            if (entity == null) {
                String warning = "getConstraints no entry found dn [" + dn + "]";
                throw new FinderException(5006, warning);
            }
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getConstraints Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(5006, warning);
        }
        catch (LdapException e) {
            String error = "getConstraints dn [" + dn + "] LEXCD=" + e;
            throw new FinderException(5001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    List<Role> findRoles(Role role) throws FinderException {
        ArrayList<Role> roleList = new ArrayList<Role>();
        LdapConnection ld = null;
        String roleRoot = RoleDAO.getRootDn(role.getContextId(), "role.root");
        String filter = null;
        try {
            String searchVal = this.encodeSafeText(role.getName(), 40);
            filter = "(&(objectClass=ftRls)(ftRoleName=" + searchVal + "*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, ROLE_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    roleList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, role.getContextId()));
                }
            }
            catch (IOException e) {
                String error = "findRoles filter [" + filter + "] caught IOException=" + e.getMessage();
                throw new FinderException(5000, error, e);
            }
            catch (CursorException e) {
                String error = "findRoles filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(5000, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findRoles filter [" + filter + "] caught LdapException=" + e;
                throw new FinderException(5000, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleList;
    }

    List<Role> groupRoles(Group group) throws FinderException {
        LdapConnection ld;
        ArrayList<Role> roleList;
        block16: {
            roleList = new ArrayList<Role>();
            ld = null;
            String roleRoot = RoleDAO.getRootDn(group.getContextId(), "role.root");
            StringBuilder filterbuf = new StringBuilder();
            try {
                List<String> members = group.getMembers();
                if (CollectionUtils.isNotEmpty(members)) {
                    String error;
                    filterbuf.append("(&(objectClass=");
                    filterbuf.append("ftRls");
                    filterbuf.append(")(");
                    filterbuf.append("|");
                    for (String memberdn : members) {
                        filterbuf.append("(");
                        filterbuf.append("entryDN");
                        filterbuf.append("=");
                        filterbuf.append(memberdn);
                        filterbuf.append(")");
                    }
                    filterbuf.append("))");
                    ld = this.getAdminConnection();
                    try (SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filterbuf.toString(), ROLE_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                        long sequence = 0L;
                        while (searchResults.next()) {
                            roleList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, group.getContextId()));
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        error = "groupRoles filter [" + filterbuf.toString() + "] caught IOException=" + e.getMessage();
                        throw new FinderException(5000, error, e);
                    }
                    catch (CursorException e) {
                        error = "groupRoles filter [" + filterbuf.toString() + "] caught CursorException=" + e.getMessage();
                        throw new FinderException(5000, error, (Exception)((Object)e));
                    }
                }
                String error = "groupRoles passed empty member list";
                throw new FinderException(10315, error);
            }
            catch (LdapException e) {
                try {
                    String error = "groupRoles filter [" + filterbuf.toString() + "] caught LdapException=" + e;
                    throw new FinderException(5000, error, (Exception)((Object)e));
                }
                catch (Throwable throwable) {
                    this.closeAdminConnection(ld);
                    throw throwable;
                }
            }
        }
        this.closeAdminConnection(ld);
        return roleList;
    }

    List<String> findRoles(Role role, int limit) throws FinderException {
        ArrayList<String> roleList = new ArrayList<String>();
        LdapConnection ld = null;
        String roleRoot = RoleDAO.getRootDn(role.getContextId(), "role.root");
        String filter = null;
        try {
            String searchVal = this.encodeSafeText(role.getName(), 40);
            filter = "(&(objectClass=ftRls)(ftRoleName=" + searchVal + "*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, ROLE_NM_ATR, false, limit);){
                while (searchResults.next()) {
                    Entry entry = searchResults.getEntry();
                    roleList.add(this.getAttribute(entry, ROLE_NM));
                }
            }
            catch (IOException e) {
                String error = "findRoles filter [" + filter + "] caught IOException=" + e.getMessage();
                throw new FinderException(5000, error, e);
            }
            catch (CursorException e) {
                String error = "findRoles filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(5000, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findRoles filter [" + filter + "] caught LdapException=" + e;
                throw new FinderException(5000, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleList;
    }

    List<String> findAssignedRoles(String userDn, String contextId) throws FinderException {
        ArrayList<String> roleNameList = new ArrayList<String>();
        LdapConnection ld = null;
        String roleRoot = RoleDAO.getRootDn(contextId, "role.root");
        try {
            Object filter = "(&(objectClass=ftRls)";
            filter = (String)filter + "(roleOccupant=" + userDn + "))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, (String)filter, ROLE_NM_ATR, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                while (searchResults.next()) {
                    roleNameList.add(this.getAttribute(searchResults.getEntry(), ROLE_NM));
                }
            }
            catch (IOException e) {
                String error = "findAssignedRoles userDn [" + userDn + "] caught IOException=" + e.getMessage();
                throw new FinderException(5011, error, e);
            }
            catch (CursorException e) {
                String error = "findAssignedRoles userDn [" + userDn + "] caught CursorException=" + e.getMessage();
                throw new FinderException(5011, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findAssignedRoles userDn [" + userDn + "] caught LdapException=" + e;
                throw new FinderException(5011, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleNameList;
    }

    List<Graphable> getAllDescendants(String contextId) throws FinderException {
        String[] DESC_ATRS = new String[]{ROLE_NM, "ftParents"};
        ArrayList<Graphable> descendants = new ArrayList<Graphable>();
        LdapConnection ld = null;
        String roleRoot = RoleDAO.getRootDn(contextId, "role.root");
        String filter = null;
        try {
            filter = "(&(objectClass=ftRls)(ftParents=*))";
            ld = this.getAdminConnection();
            try (SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, DESC_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));){
                long sequence = 0L;
                while (searchResults.next()) {
                    descendants.add(this.unloadDescendants(searchResults.getEntry(), sequence++, contextId));
                }
            }
            catch (IOException e) {
                String error = "getAllDescendants filter [" + filter + "] caught IOException=" + e.getMessage();
                throw new FinderException(5000, error, e);
            }
            catch (CursorException e) {
                String error = "getAllDescendants filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(5000, error, (Exception)((Object)e));
            }
        }
        catch (LdapException e) {
            String error = "getAllDescendants filter [" + filter + "] caught LdapException=" + e;
            throw new FinderException(5000, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return descendants;
    }

    private void loadGidNumber(Role entity) throws CreateException {
        if (StringUtils.isEmpty((CharSequence)entity.getGidNumber())) {
            Configuration configuration;
            ArrayList<String> idNumbers = new ArrayList<String>();
            idNumbers.add("gidNumber");
            try {
                configuration = Config.getInstance().getIncrementReplacePosixIds(idNumbers, this);
            }
            catch (CfgException ce) {
                String error = "Create role had a problem loading the gidNumber, catching a CfgException:" + ce.getMessage();
                throw new CreateException(1002, error, ce);
            }
            entity.setGidNumber(configuration.getGidNumber());
        }
    }

    private Graphable unloadDescendants(Entry le, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        Role entity = new ObjectFactory().createRole();
        entity.setSequenceId(sequence);
        entity.setName(this.getAttribute(le, ROLE_NM));
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        return entity;
    }

    private Role unloadLdapEntry(Entry le, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        Role entity = new ObjectFactory().createRole();
        entity.setSequenceId(sequence);
        entity.setId(this.getAttribute(le, "ftId"));
        entity.setName(this.getAttribute(le, ROLE_NM));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.setChildren(RoleUtil.getInstance().getChildren(entity.getName().toUpperCase(), contextId));
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        this.unloadTemporal(le, entity);
        entity.setDn(le.getDn().getName());
        entity.addProperties(PropUtil.getProperties(this.getAttributes(le, "ftProps")));
        if (IS_RFC2307) {
            entity.setGidNumber(this.getAttribute(le, "gidNumber"));
        }
        entity.setOccupants(this.getAttributes(le, "roleOccupant"));
        return entity;
    }

    private String getDn(String name, String contextId) {
        return "cn=" + name + "," + RoleDAO.getRootDn(contextId, "role.root");
    }

    @Override
    public String getDn(Role entity) {
        return this.getDn(entity.getName(), entity.getContextId());
    }

    public Role getEntity(Role entity) throws FinderException {
        return this.getRole(entity);
    }

    static {
        String[] stringArray;
        ROLE_NM_ATR = new String[]{ROLE_NM};
        IS_RFC2307 = Config.getInstance().getProperty("rfc2307") != null && Config.getInstance().getProperty("rfc2307").equalsIgnoreCase("true");
        ROLE_ATRS = new String[]{"ftId", ROLE_NM, "description", "ftCstr", "roleOccupant", "ftParents", "ftProps", IS_RFC2307 ? "gidNumber" : null};
        ROLE_CONSTRAINTS = new String[]{ROLE_NM, "ftCstr", "ftParents"};
        if (IS_RFC2307) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "top";
            stringArray2[1] = "ftRls";
            stringArray2[2] = "ftProperties";
            stringArray2[3] = "ftMods";
            stringArray = stringArray2;
            stringArray2[4] = POSIX_GROUP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "top";
            stringArray3[1] = "ftRls";
            stringArray3[2] = "ftProperties";
            stringArray = stringArray3;
            stringArray3[3] = "ftMods";
        }
        ROLE_OBJ_CLASS = stringArray;
    }
}

