/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.api;

import java.lang.reflect.Method;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

public class QueryInvocationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public QueryInvocationException(Throwable t, QueryInvocationContext context) {
        super(QueryInvocationException.createMessage(context, t), t);
    }

    public QueryInvocationException(String message, QueryInvocationContext context) {
        super(QueryInvocationException.createMessage(context));
    }

    public QueryInvocationException(Throwable t, Class<?> proxy, Method method) {
        super(QueryInvocationException.createMessage(proxy, method, t), t);
    }

    private static String createMessage(QueryInvocationContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failed calling Repository: [");
        builder.append("Repository=").append(context.getRepositoryClass().getName()).append(",");
        builder.append("entity=").append(context.getEntityClass().getName()).append(",");
        builder.append("method=").append(context.getMethod().getName()).append(",");
        return builder.toString();
    }

    private static String createMessage(QueryInvocationContext context, Throwable t) {
        StringBuilder builder = new StringBuilder(QueryInvocationException.createMessage(context));
        builder.append("exception=").append(t.getClass()).append(",message=").append(t.getMessage());
        return builder.toString();
    }

    private static String createMessage(Class<?> repoClass, Method method, Throwable t) {
        StringBuilder builder = new StringBuilder();
        builder.append("Exception calling Repository: [");
        builder.append("Repository=").append(repoClass).append(",");
        builder.append("method=").append(method.getName()).append("],");
        builder.append("exception=").append(t.getClass()).append(",message=").append(t.getMessage());
        return builder.toString();
    }
}

