/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cli;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.WritableByteChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.ParseResult;
import org.apache.daffodil.api.UnparseResult;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.cli.InfosetHandler;
import org.apache.daffodil.cli.InfosetParseResult;
import org.apache.daffodil.cli.W3CDOMInfosetHandler$;
import org.apache.daffodil.cli.W3CDOMInfosetParseResult;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.util.ThreadSafePool;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.runtime1.infoset.W3CDOMInfosetOutputter;
import org.w3c.dom.Document;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class W3CDOMInfosetHandler
implements InfosetHandler,
Product,
Serializable {
    private final DataProcessor dataProcessor;

    public static W3CDOMInfosetHandler apply(DataProcessor dataProcessor) {
        return W3CDOMInfosetHandler$.MODULE$.apply(dataProcessor);
    }

    public static W3CDOMInfosetHandler fromProduct(Product product) {
        return W3CDOMInfosetHandler$.MODULE$.fromProduct(product);
    }

    public static W3CDOMInfosetHandler unapply(W3CDOMInfosetHandler w3CDOMInfosetHandler) {
        return W3CDOMInfosetHandler$.MODULE$.unapply(w3CDOMInfosetHandler);
    }

    public W3CDOMInfosetHandler(DataProcessor dataProcessor) {
        this.dataProcessor = dataProcessor;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1334423200, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof W3CDOMInfosetHandler)) return false;
        W3CDOMInfosetHandler w3CDOMInfosetHandler = (W3CDOMInfosetHandler)object;
        DataProcessor dataProcessor = this.dataProcessor();
        DataProcessor dataProcessor2 = w3CDOMInfosetHandler.dataProcessor();
        if (dataProcessor == null) {
            if (dataProcessor2 != null) {
                return false;
            }
        } else if (!dataProcessor.equals(dataProcessor2)) return false;
        if (!w3CDOMInfosetHandler.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof W3CDOMInfosetHandler;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "W3CDOMInfosetHandler";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "dataProcessor";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public DataProcessor dataProcessor() {
        return this.dataProcessor;
    }

    @Override
    public InfosetParseResult parse(InputSourceDataInputStream input, OutputStream os) {
        W3CDOMInfosetOutputter output = new W3CDOMInfosetOutputter();
        ParseResult pr = this.parseWithInfosetOutputter(input, (InfosetOutputter)output);
        return new W3CDOMInfosetParseResult(pr, output);
    }

    @Override
    public UnparseResult unparse(Object data, WritableByteChannel output) {
        UnparseResult unparseResult;
        ThreadSafePool domPool = (ThreadSafePool)data;
        ThreadSafePool ThreadSafePool_this = domPool;
        Document polled = (Document)ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().poll();
        Document inst = polled == null ? (Document)ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$allocate() : polled;
        try {
            UnparseResult ur;
            W3CDOMInfosetInputter input = new W3CDOMInfosetInputter(inst);
            unparseResult = ur = this.unparseWithInfosetInputter((InfosetInputter)input, output);
        }
        finally {
            ThreadSafePool_this.org$apache$daffodil$lib$util$ThreadSafePool$$inline$queue().offer(inst);
        }
        return unparseResult;
    }

    @Override
    public Object dataToInfoset(byte[] bytes) {
        ThreadSafePool<Document> domPool = new ThreadSafePool<Document>(bytes){
            private final byte[] bytes$1;
            {
                this.bytes$1 = bytes$2;
            }

            public Document allocate() {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setFeature(XMLUtils$.MODULE$.XML_DISALLOW_DOCTYPE_FEATURE(), true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                return db.parse(new ByteArrayInputStream(this.bytes$1));
            }
        };
        return domPool;
    }

    @Override
    public Object dataToInfoset(InputStream stream) {
        return this.dataToInfoset(IOUtils.toByteArray((InputStream)stream));
    }

    public W3CDOMInfosetHandler copy(DataProcessor dataProcessor) {
        return new W3CDOMInfosetHandler(dataProcessor);
    }

    public DataProcessor copy$default$1() {
        return this.dataProcessor();
    }

    public DataProcessor _1() {
        return this.dataProcessor();
    }
}

