/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;

public class JwtClaims
extends JsonMapObject {
    private static final long serialVersionUID = 6274136637301800283L;

    public JwtClaims() {
    }

    public JwtClaims(Map<String, Object> values) {
        super(values);
    }

    public void setIssuer(String issuer) {
        this.setClaim("iss", issuer);
    }

    public String getIssuer() {
        return (String)this.getClaim("iss");
    }

    public void setSubject(String subject) {
        this.setClaim("sub", subject);
    }

    public String getSubject() {
        return (String)this.getClaim("sub");
    }

    public void setAudience(String audience) {
        this.setClaim("aud", audience);
    }

    public String getAudience() {
        List<String> audiences = this.getAudiences();
        if (!StringUtils.isEmpty(audiences)) {
            return audiences.get(0);
        }
        return null;
    }

    public void setAudiences(List<String> audiences) {
        this.setClaim("aud", audiences);
    }

    public List<String> getAudiences() {
        Object audiences = this.getClaim("aud");
        if (audiences instanceof List) {
            return CastUtils.cast((List)((List)audiences));
        }
        if (audiences instanceof String) {
            return Collections.singletonList((String)audiences);
        }
        return Collections.emptyList();
    }

    public void setExpiryTime(Long expiresIn) {
        this.setClaim("exp", expiresIn);
    }

    public Long getExpiryTime() {
        return this.getLongProperty("exp");
    }

    public void setNotBefore(Long notBefore) {
        this.setClaim("nbf", notBefore);
    }

    public Long getNotBefore() {
        return this.getLongProperty("nbf");
    }

    public void setIssuedAt(Long issuedAt) {
        this.setClaim("iat", issuedAt);
    }

    public Long getIssuedAt() {
        return this.getLongProperty("iat");
    }

    public void setTokenId(String id) {
        this.setClaim("jti", id);
    }

    public String getTokenId() {
        return (String)this.getClaim("jti");
    }

    public JwtClaims setClaim(String name, Object value) {
        this.setProperty(name, value);
        return this;
    }

    public Object getClaim(String name) {
        return this.getProperty(name);
    }
}

