/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

public final class JSONCollectors {
    private JSONCollectors() {
    }

    public static <T> Collector<T, ?, JSONArray> toArray() {
        return Collector.of(JSONArray::new, JSONArray::add, JSONArray::putAll, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, JSONObject> toMap(Function<? super T, String> keyMapper, Function<? super T, Object> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, JSONObject::new);
    }
}

