/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matcher;

import jakarta.mail.MessagingException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsX509CertificateSubject
extends GenericMatcher {
    protected AttributeName sourceAttribute;
    protected String check;

    public void init() throws MessagingException {
        String condition = this.getCondition();
        if (condition == null || !condition.contains(";")) {
            throw new MessagingException("Invalid matcher configuration: " + condition);
        }
        int pos = condition.indexOf(";");
        this.sourceAttribute = AttributeName.of((String)condition.substring(0, pos).trim());
        this.check = condition.substring(pos + 1);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return AttributeUtils.getAttributeValueFromMail((Mail)mail, (AttributeName)this.sourceAttribute).map(this::getCertificates).filter(this::hasCertificate).map(any -> mail.getRecipients()).orElse(null);
    }

    private boolean hasCertificate(List<X509Certificate> certificates) {
        for (X509Certificate cert : certificates) {
            Principal prin = cert.getSubjectDN();
            if (prin.toString().indexOf(this.check) <= 0) continue;
            return true;
        }
        return false;
    }

    private List<X509Certificate> getCertificates(Object attributeValue) {
        if (attributeValue instanceof X509Certificate) {
            return Collections.singletonList((X509Certificate)attributeValue);
        }
        return (List)attributeValue;
    }
}

